/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.toolkits.bean;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import qilin.core.PTA;
import qilin.core.context.ContextElements;
import qilin.core.pag.AllocNode;
import qilin.pta.toolkits.bean.ContextSelector;
import qilin.pta.toolkits.bean.RepresentativeContextSelector;
import qilin.pta.toolkits.common.OAG;
import qilin.util.Pair;
import qilin.util.Stopwatch;

public class Bean {
    public static void run(PTA pta, Map<Object, Map<Object, Map<Object, Object>>> beanNexCtxMap) {
        System.out.println("Constructing object allocation graph (OAG) ...");
        Stopwatch timer = Stopwatch.newAndStart("OAG construction");
        OAG oag = new OAG(pta);
        oag.build();
        timer.stop();
        System.out.print("\u001b[1mOAG construction: \u001b[32m" + String.format("%.2fs", Float.valueOf(timer.elapsed())) + "\u001b[0m" + "\n");
        System.out.println("Computing contexts...");
        timer.restart();
        RepresentativeContextSelector cs = new RepresentativeContextSelector(oag, 1);
        timer.stop();
        System.out.print("\u001b[1mContext computation: \u001b[32m" + String.format("%.2fs", Float.valueOf(timer.elapsed())) + "\u001b[0m" + "\n");
        Bean.writeContext(cs, oag, beanNexCtxMap);
    }

    private static void writeContext(ContextSelector cs, OAG oag, Map<Object, Map<Object, Map<Object, Object>>> beanNexCtxMap) {
        oag.allNodes().forEach(allocator -> {
            Set<ContextElements> ctxs = cs.contextsOf((AllocNode)allocator);
            for (ContextElements ctx : ctxs) {
                AllocNode allocHctx = (AllocNode)ctx.get(0);
                Set<Pair<ContextElements, AllocNode>> csheaps = cs.allocatedBy(ctx, (AllocNode)allocator);
                if (csheaps == null) continue;
                csheaps.forEach(csheap -> {
                    AllocNode newHctx = (AllocNode)((ContextElements)csheap.getFirst()).get(0);
                    AllocNode heap = (AllocNode)csheap.getSecond();
                    beanNexCtxMap.computeIfAbsent(heap.getNewExpr(), k -> new HashMap()).computeIfAbsent(allocator.getNewExpr(), k -> new HashMap()).put(allocHctx.getNewExpr(), newHctx.getNewExpr());
                });
            }
        });
    }
}

