/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.toolkits.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import qilin.core.PTA;
import qilin.core.pag.AllocNode;
import qilin.core.pag.Node;
import qilin.core.pag.PAG;
import qilin.core.pag.SparkField;
import qilin.core.sets.PointsToSet;

public class FieldPointstoGraph {
    private final Map<AllocNode, Map<SparkField, Set<AllocNode>>> pointsTo = new HashMap<AllocNode, Map<SparkField, Set<AllocNode>>>();
    private final Map<AllocNode, Map<SparkField, Set<AllocNode>>> pointedBy = new HashMap<AllocNode, Map<SparkField, Set<AllocNode>>>();

    public FieldPointstoGraph(PTA pta) {
        this.buildFPG(pta);
    }

    private void buildFPG(PTA pta) {
        PAG pag = pta.getPag();
        pag.getAllocNodes().forEach(this::insertObj);
        pag.getContextFields().forEach(contextField -> {
            AllocNode base = contextField.getBase();
            if (base.getMethod() == null) {
                return;
            }
            SparkField field = contextField.getField();
            PointsToSet pts = pta.reachingObjects((Node)contextField).toCIPointsToSet();
            Iterator<AllocNode> it = pts.iterator();
            while (it.hasNext()) {
                AllocNode n = it.next();
                this.insertFPT(base, field, n);
            }
        });
    }

    public Set<AllocNode> getAllObjs() {
        return this.pointsTo.keySet();
    }

    public Set<SparkField> outFieldsOf(AllocNode baseObj) {
        return this.pointsTo.getOrDefault(baseObj, Collections.emptyMap()).keySet();
    }

    public Set<SparkField> inFieldsOf(AllocNode obj) {
        return this.pointedBy.get(obj).keySet();
    }

    public Set<AllocNode> pointsTo(AllocNode baseObj, SparkField field) {
        return this.pointsTo.get(baseObj).get(field);
    }

    public Set<AllocNode> pointedBy(AllocNode obj, SparkField field) {
        return this.pointedBy.get(obj).get(field);
    }

    public boolean hasFieldPointer(AllocNode obj, SparkField field) {
        return this.pointsTo.get(obj).containsKey(field);
    }

    private void insertObj(AllocNode obj) {
        this.pointsTo.computeIfAbsent(obj, k -> new HashMap());
        this.pointedBy.computeIfAbsent(obj, k -> new HashMap());
    }

    private void insertFPT(AllocNode baseObj, SparkField field, AllocNode obj) {
        this.insertPointsTo(baseObj, field, obj);
        this.insertPointedBy(baseObj, field, obj);
    }

    private void insertPointsTo(AllocNode baseObj, SparkField field, AllocNode obj) {
        Map fpt = this.pointsTo.computeIfAbsent(baseObj, k -> new HashMap());
        fpt.computeIfAbsent(field, k -> new HashSet()).add(obj);
    }

    private void insertPointedBy(AllocNode baseObj, SparkField field, AllocNode obj) {
        Map fpb = this.pointedBy.computeIfAbsent(obj, k -> new HashMap());
        fpb.computeIfAbsent(field, k -> new HashSet()).add(baseObj);
    }
}

