/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.toolkits.conch;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import qilin.core.PTA;
import qilin.core.builder.MethodNodeFactory;
import qilin.core.pag.AllocNode;
import qilin.core.pag.FieldRefNode;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.MethodPAG;
import qilin.core.pag.Node;
import qilin.core.pag.PAG;
import qilin.core.pag.SparkField;
import qilin.core.pag.StringConstantNode;
import qilin.core.pag.VarNode;
import qilin.core.sets.PointsToSet;
import qilin.pta.toolkits.conch.SMPAG;
import qilin.util.PTAUtils;
import qilin.util.Pair;
import sootup.core.model.SootMethod;
import sootup.core.types.ArrayType;
import sootup.core.types.PrimitiveType;

public class AbstractConch {
    public final PTA pta;
    public final PAG pag;
    protected final Map<AllocNode, Set<SootMethod>> invokedMethods = new HashMap<AllocNode, Set<SootMethod>>();
    protected final Map<SootMethod, Map<SparkField, Set<Pair<VarNode, VarNode>>>> m2thisFStores = new HashMap<SootMethod, Map<SparkField, Set<Pair<VarNode, VarNode>>>>();
    protected final Map<AllocNode, Map<SparkField, Set<Pair<VarNode, VarNode>>>> o2nonThisFStores = new HashMap<AllocNode, Map<SparkField, Set<Pair<VarNode, VarNode>>>>();
    protected final Map<SootMethod, Map<SparkField, Set<VarNode>>> m2thisFLoads = new HashMap<SootMethod, Map<SparkField, Set<VarNode>>>();
    protected final Map<AllocNode, Map<SparkField, Set<VarNode>>> o2nonThisFLoads = new HashMap<AllocNode, Map<SparkField, Set<VarNode>>>();
    protected final Map<AllocNode, Set<SparkField>> o2fs = new HashMap<AllocNode, Set<SparkField>>();
    private final Map<MethodPAG, SMPAG> methodSMPAGMap = new HashMap<MethodPAG, SMPAG>();

    public AbstractConch(PTA pta) {
        this.pta = pta;
        this.pag = pta.getPag();
        this.init();
    }

    private void init() {
        Map<LocalVarNode, Set<AllocNode>> pts = PTAUtils.calcStaticThisPTS(this.pta);
        this.pta.getNakedReachableMethods().stream().filter(PTAUtils::hasBody).forEach(method -> {
            this.collectStoresIn((SootMethod)method);
            this.collectLoadsIn((SootMethod)method);
            this.buildInvokedOnFor((SootMethod)method, pts);
        });
        this.buildHeap2AccessedFieldsMap();
    }

    private void buildHeap2AccessedFieldsMap() {
        for (AllocNode heap : this.pag.getAllocNodes()) {
            HashSet tmp = new HashSet();
            tmp.addAll(this.o2nonThisFLoads.getOrDefault(heap, Collections.emptyMap()).keySet());
            tmp.addAll(this.o2nonThisFStores.getOrDefault(heap, Collections.emptyMap()).keySet());
            for (SootMethod sm : this.invokedMethods.getOrDefault(heap, Collections.emptySet())) {
                tmp.addAll(this.m2thisFLoads.getOrDefault(sm, Collections.emptyMap()).keySet());
                tmp.addAll(this.m2thisFStores.getOrDefault(sm, Collections.emptyMap()).keySet());
            }
            this.o2fs.put(heap, tmp);
        }
    }

    private void buildInvokedOnFor(SootMethod m, Map<LocalVarNode, Set<AllocNode>> pts) {
        MethodPAG srcmpag = this.pag.getMethodPAG(m);
        MethodNodeFactory srcnf = srcmpag.nodeFactory();
        LocalVarNode thisRef = (LocalVarNode)srcnf.caseThis();
        if (m.isStatic()) {
            pts.getOrDefault(thisRef, Collections.emptySet()).forEach(a -> this.invokedMethods.computeIfAbsent((AllocNode)a, k -> new HashSet()).add(m));
        } else {
            PointsToSet thisPts = this.pta.reachingObjects(thisRef).toCIPointsToSet();
            Iterator<AllocNode> it = thisPts.iterator();
            while (it.hasNext()) {
                AllocNode n = it.next();
                this.invokedMethods.computeIfAbsent(n, k -> new HashSet()).add(m);
            }
        }
    }

    public SMPAG getSMAPG(MethodPAG mpag) {
        return this.methodSMPAGMap.computeIfAbsent(mpag, k -> new SMPAG(mpag));
    }

    private void collectLoadsIn(SootMethod method) {
        MethodPAG srcmpag = this.pag.getMethodPAG(method);
        MethodNodeFactory srcnf = srcmpag.nodeFactory();
        LocalVarNode thisRef = (LocalVarNode)srcnf.caseThis();
        SMPAG smpag = this.getSMAPG(srcmpag);
        for (Pair<Node, Node> ld : smpag.getLoads()) {
            FieldRefNode fr = (FieldRefNode)ld.getSecond();
            LocalVarNode loadBase = (LocalVarNode)fr.getBase();
            SparkField field = fr.getField();
            if (this.primitiveField(field)) continue;
            if (PTAUtils.mustAlias(this.pta, thisRef, loadBase)) {
                Map f2bs = this.m2thisFLoads.computeIfAbsent(method, k -> new HashMap());
                f2bs.computeIfAbsent(field, k -> new HashSet()).add(loadBase);
                continue;
            }
            for (AllocNode heap : this.pta.reachingObjects(loadBase).toCIPointsToSet().toCollection()) {
                if (heap.getMethod() == method) continue;
                Map f2bs = this.o2nonThisFLoads.computeIfAbsent(heap, k -> new HashMap());
                f2bs.computeIfAbsent(field, k -> new HashSet()).add(loadBase);
            }
        }
    }

    private void collectStoresIn(SootMethod method) {
        MethodPAG srcmpag = this.pag.getMethodPAG(method);
        MethodNodeFactory srcnf = srcmpag.nodeFactory();
        LocalVarNode thisRef = (LocalVarNode)srcnf.caseThis();
        SMPAG smpag = this.getSMAPG(srcmpag);
        for (Pair<Node, Node> st : smpag.getStores()) {
            LocalVarNode from = (LocalVarNode)st.getSecond();
            FieldRefNode fr = (FieldRefNode)st.getFirst();
            LocalVarNode storeBase = (LocalVarNode)fr.getBase();
            SparkField field = fr.getField();
            if (this.primitiveField(field)) continue;
            if (PTAUtils.mustAlias(this.pta, thisRef, storeBase)) {
                Map m2s = this.m2thisFStores.computeIfAbsent(method, k -> new HashMap());
                m2s.computeIfAbsent(field, k -> new HashSet()).add(new Pair<LocalVarNode, LocalVarNode>(storeBase, from));
                continue;
            }
            for (AllocNode heap : this.pta.reachingObjects(storeBase).toCIPointsToSet().toCollection()) {
                if (this.emptyFieldPts(heap, field)) continue;
                Map f2bs = this.o2nonThisFStores.computeIfAbsent(heap, k -> new HashMap());
                f2bs.computeIfAbsent(field, k -> new HashSet()).add(new Pair<LocalVarNode, LocalVarNode>(storeBase, from));
            }
        }
    }

    private boolean primitiveField(SparkField f) {
        String s = "java.lang.String";
        if (f.getType() instanceof PrimitiveType) {
            return true;
        }
        if (f.getType() instanceof ArrayType) {
            ArrayType at = (ArrayType)f.getType();
            return at.getBaseType() instanceof PrimitiveType;
        }
        return f.getType().toString().equals(s);
    }

    protected boolean emptyFieldPts(AllocNode heap, SparkField field) {
        PointsToSet pts = this.pta.reachingObjectsInternal(heap, field);
        HashSet<AllocNode> tmp = new HashSet<AllocNode>();
        Iterator<AllocNode> it = pts.iterator();
        while (it.hasNext()) {
            AllocNode n = it.next();
            if (n instanceof StringConstantNode) continue;
            tmp.add(n);
        }
        return tmp.isEmpty();
    }

    protected boolean hasLoadOn(AllocNode heap, SparkField field) {
        Map f2bs = this.o2nonThisFLoads.getOrDefault(heap, Collections.emptyMap());
        Set loadBases = f2bs.getOrDefault(field, Collections.emptySet());
        if (!loadBases.isEmpty()) {
            return true;
        }
        for (SootMethod method : this.invokedMethods.getOrDefault(heap, Collections.emptySet())) {
            Map f2bsX = this.m2thisFLoads.getOrDefault(method, Collections.emptyMap());
            Set loadBasesX = f2bsX.getOrDefault(field, Collections.emptySet());
            if (loadBasesX.isEmpty()) continue;
            return true;
        }
        return false;
    }

    protected boolean hasStoreOn(AllocNode heap, SparkField field) {
        Map f2bs = this.o2nonThisFStores.getOrDefault(heap, Collections.emptyMap());
        Set storeBases = f2bs.getOrDefault(field, Collections.emptySet());
        if (!storeBases.isEmpty()) {
            return true;
        }
        for (SootMethod method : this.invokedMethods.getOrDefault(heap, Collections.emptySet())) {
            Map f2bsX = this.m2thisFStores.getOrDefault(method, Collections.emptyMap());
            Set storeBasesX = f2bsX.getOrDefault(field, Collections.emptySet());
            if (storeBasesX.isEmpty()) continue;
            return true;
        }
        return false;
    }
}

