/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.toolkits.debloaterx;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import qilin.core.PTA;
import qilin.core.pag.AllocNode;
import qilin.core.pag.FieldRefNode;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.MethodPAG;
import qilin.core.pag.Node;
import qilin.core.pag.PAG;
import qilin.core.pag.SparkField;
import qilin.util.PTAUtils;
import qilin.util.queue.QueueReader;
import sootup.core.model.SootClass;
import sootup.core.model.SootMethod;
import sootup.core.types.ArrayType;
import sootup.core.types.ClassType;
import sootup.core.types.Type;

public class CollectionHeuristic {
    protected final PTA pta;
    protected final PAG pag;
    protected final Map<Type, Set<SparkField>> t2Fields = new ConcurrentHashMap<Type, Set<SparkField>>();
    protected final Set<Type> containerType = ConcurrentHashMap.newKeySet();
    protected final Set<AllocNode> ctxDepHeaps = ConcurrentHashMap.newKeySet();

    public Set<AllocNode> getCtxDepHeaps() {
        return this.ctxDepHeaps;
    }

    public CollectionHeuristic(PTA pta) {
        this.pta = pta;
        this.pag = pta.getPag();
    }

    private void buildHeapFieldsMappingIn(SootMethod method) {
        SparkField field;
        MethodPAG srcmpag = this.pag.getMethodPAG(method);
        HashSet<FieldRefNode> stores = new HashSet<FieldRefNode>();
        HashSet<FieldRefNode> loads = new HashSet<FieldRefNode>();
        Object reader = srcmpag.getInternalReader().clone();
        while (((QueueReader)reader).hasNext()) {
            FieldRefNode frn;
            Node from = (Node)((QueueReader)reader).next();
            Node to = (Node)((QueueReader)reader).next();
            if (from instanceof LocalVarNode) {
                if (!(to instanceof FieldRefNode)) continue;
                frn = (FieldRefNode)to;
                stores.add(frn);
                continue;
            }
            if (!(from instanceof FieldRefNode)) continue;
            frn = (FieldRefNode)from;
            loads.add(frn);
        }
        for (FieldRefNode frn : stores) {
            LocalVarNode storeBase = (LocalVarNode)frn.getBase();
            field = frn.getField();
            for (AllocNode heap : this.pta.reachingObjects(storeBase).toCIPointsToSet().toCollection()) {
                this.t2Fields.computeIfAbsent(heap.getType(), k -> ConcurrentHashMap.newKeySet()).add(field);
            }
        }
        for (FieldRefNode frn : loads) {
            LocalVarNode loadBase = (LocalVarNode)frn.getBase();
            field = frn.getField();
            for (AllocNode heap : this.pta.reachingObjects(loadBase).toCIPointsToSet().toCollection()) {
                this.t2Fields.computeIfAbsent(heap.getType(), k -> ConcurrentHashMap.newKeySet()).add(field);
            }
        }
    }

    private void buildHeapFieldsMapping() {
        this.pta.getNakedReachableMethods().stream().filter(PTAUtils::hasBody).forEach(this::buildHeapFieldsMappingIn);
    }

    private boolean isImplementingCollection(SootClass sc) {
        HashSet allInterfaces = new HashSet(sc.getInterfaces());
        while (sc.hasSuperclass()) {
            ClassType classType = (ClassType)sc.getSuperclass().get();
            sc = (SootClass)this.pta.getView().getClass(classType).get();
            allInterfaces.addAll(sc.getInterfaces());
        }
        HashSet<SootClass> worklist = new HashSet<SootClass>();
        block1: for (ClassType tmp : allInterfaces) {
            SootClass msc = (SootClass)this.pta.getView().getClass(tmp).get();
            worklist.add(msc);
            while (msc.hasSuperclass()) {
                ClassType superType = (ClassType)msc.getSuperclass().get();
                SootClass superClazz = (SootClass)this.pta.getView().getClass(superType).get();
                if (!superClazz.isInterface()) continue block1;
                worklist.add(superClazz);
                msc = superClazz;
            }
        }
        boolean flag = false;
        for (SootClass interf : worklist) {
            if (interf.getType() != PTAUtils.getClassType("java.util.Collection")) continue;
            flag = true;
        }
        return flag;
    }

    private boolean isNestedInClassImplementCollection(SootClass sc) {
        if (!sc.isInnerClass()) {
            return false;
        }
        ClassType outerType = (ClassType)sc.getOuterClass().get();
        SootClass outer = (SootClass)this.pta.getView().getClass(outerType).get();
        if (this.isImplementingCollection(outer)) {
            return true;
        }
        return this.isNestedInClassImplementCollection(outer);
    }

    private void computeContainerTypes() {
        block0: for (Type type : this.t2Fields.keySet()) {
            if (type instanceof ClassType) {
                ClassType classType = (ClassType)type;
                SootClass sc = (SootClass)this.pta.getView().getClass(classType).get();
                if (this.isImplementingCollection(sc) || this.isNestedInClassImplementCollection(sc)) {
                    this.containerType.add(type);
                    continue;
                }
                for (SparkField sf : this.t2Fields.get(type)) {
                    if (sf.getType() != PTAUtils.getClassType("java.lang.Object")) continue;
                    this.containerType.add(type);
                    continue block0;
                }
                continue;
            }
            if (type instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)type;
                if (arrayType.getBaseType() != PTAUtils.getClassType("java.lang.Object")) continue;
                this.containerType.add((Type)arrayType);
                continue;
            }
            System.out.println(type);
        }
        HashMap ft2t = new HashMap();
        for (Type type : this.t2Fields.keySet()) {
            if (type instanceof ClassType) {
                for (SparkField sparkField : this.t2Fields.get(type)) {
                    Type sft = sparkField.getType();
                    if (sft instanceof ArrayType) {
                        ArrayType at = (ArrayType)sft;
                        sft = at.getBaseType();
                    }
                    ft2t.computeIfAbsent(sft, k -> new HashSet()).add(type);
                }
                continue;
            }
            if (!(type instanceof ArrayType)) continue;
            ArrayType at = (ArrayType)type;
            ft2t.computeIfAbsent(at.getBaseType(), k -> new HashSet()).add(type);
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        this.containerType.addAll(ft2t.getOrDefault(PTAUtils.getClassType("java.lang.Object"), Collections.emptySet()));
        for (Type t1 : this.containerType) {
            for (Type t2 : ft2t.getOrDefault(t1, Collections.emptySet())) {
                if (this.containerType.contains(t2)) continue;
                hashSet.add(t2);
            }
        }
        while (!hashSet.isEmpty()) {
            this.containerType.addAll(hashSet);
            HashSet<Type> hashSet2 = new HashSet<Type>();
            for (Type type : hashSet) {
                for (Type t2 : ft2t.getOrDefault(type, Collections.emptySet())) {
                    if (this.containerType.contains(t2)) continue;
                    hashSet2.add(t2);
                }
            }
            hashSet.clear();
            hashSet.addAll(hashSet2);
        }
        System.out.println("#ContainerType:" + this.containerType.size());
    }

    private void computeContextDependentObjects() {
        for (AllocNode heap : this.pag.getAllocNodes()) {
            if (!this.containerType.contains(heap.getType())) continue;
            this.ctxDepHeaps.add(heap);
        }
        System.out.println("#OBJECTS:" + this.pag.getAllocNodes().size());
        System.out.println("#CS:" + this.ctxDepHeaps.size());
        System.out.println("#CI:" + (this.pag.getAllocNodes().size() - this.ctxDepHeaps.size()));
    }

    public void run() {
        this.buildHeapFieldsMapping();
        this.computeContainerTypes();
        this.computeContextDependentObjects();
    }
}

