/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.toolkits.debloaterx;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.Node;
import qilin.core.pag.SparkField;
import qilin.pta.toolkits.debloaterx.Edge;
import qilin.pta.toolkits.debloaterx.EdgeKind;
import qilin.pta.toolkits.debloaterx.State;
import qilin.pta.toolkits.debloaterx.XPAG;
import qilin.pta.toolkits.debloaterx.XUtility;
import qilin.util.Pair;
import qilin.util.queue.UniqueQueue;
import sootup.core.model.SootMethod;

public class InterFlowAnalysis {
    protected final XUtility utility;
    protected final XPAG xpag;
    protected final Map<SparkField, Set<LocalVarNode>> field2InParams = new ConcurrentHashMap<SparkField, Set<LocalVarNode>>();
    protected final Map<SparkField, Set<LocalVarNode>> field2OutParams = new ConcurrentHashMap<SparkField, Set<LocalVarNode>>();

    public InterFlowAnalysis(XUtility utility) {
        this.utility = utility;
        this.xpag = utility.getXpag();
        this.reachabilityAnalysis();
    }

    public void reachabilityAnalysis() {
        Set<SparkField> fields = this.utility.getFields();
        fields.parallelStream().forEach(field -> {
            Set<LocalVarNode> params;
            Set<LocalVarNode> retOrParams = this.runDFAandCollect((SparkField)field, false);
            if (!retOrParams.isEmpty()) {
                this.field2OutParams.computeIfAbsent((SparkField)field, k -> ConcurrentHashMap.newKeySet()).addAll(retOrParams);
            }
            if (!(params = this.runDFAandCollect((SparkField)field, true)).isEmpty()) {
                this.field2InParams.computeIfAbsent((SparkField)field, k -> ConcurrentHashMap.newKeySet()).addAll(params);
            }
        });
    }

    private Set<LocalVarNode> runDFAandCollect(SparkField field, boolean isInflow) {
        HashSet<LocalVarNode> ret = new HashSet<LocalVarNode>();
        HashMap<State, Set<Node>> state2nodes = new HashMap<State, Set<Node>>();
        UniqueQueue queue = new UniqueQueue();
        queue.add(new Pair<LocalVarNode, State>(this.xpag.getDummyThis(), State.THIS));
        while (!queue.isEmpty()) {
            Pair front = (Pair)queue.poll();
            if (front.getSecond() == State.End && front.getFirst() instanceof LocalVarNode) {
                LocalVarNode lvn = (LocalVarNode)front.getFirst();
                ret.add(lvn);
            }
            this.visit(front, state2nodes);
            Set<Pair<Node, State>> nexts = this.getNextNodeStates(front, field, isInflow);
            for (Pair<Node, State> nodeState : nexts) {
                if (this.isVisited(nodeState, state2nodes)) continue;
                queue.add(nodeState);
            }
        }
        return ret;
    }

    private Set<Pair<Node, State>> getNextNodeStates(Pair<Node, State> nodeState, SparkField field, boolean in) {
        Node node = nodeState.getFirst();
        State state = nodeState.getSecond();
        HashSet<Pair<Node, State>> ret = new HashSet<Pair<Node, State>>();
        for (Edge edge : this.xpag.getOutEdges(node)) {
            boolean mathched = edge.field != null && edge.field.equals(field);
            State nextState = in ? this.nextStateForIn(state, edge.kind, mathched) : this.nextStateForOut(state, edge.kind, mathched);
            if (nextState == State.Error) continue;
            ret.add(new Pair<Node, State>(edge.to, nextState));
        }
        return ret;
    }

    private State nextStateForOut(State currState, EdgeKind kind, boolean fieldMatch) {
        switch (currState) {
            case THIS: {
                if (kind == EdgeKind.ITHIS) {
                    return State.ThisAlias;
                }
            }
            case ThisAlias: {
                if (kind == EdgeKind.ASSIGN) {
                    return State.ThisAlias;
                }
                if (kind == EdgeKind.LOAD && fieldMatch) {
                    return State.VPlus;
                }
            }
            case VPlus: {
                if (kind == EdgeKind.ASSIGN || kind == EdgeKind.LOAD || kind == EdgeKind.CLOAD) {
                    return State.VPlus;
                }
                if (kind == EdgeKind.RETURN) {
                    return State.End;
                }
                if (kind == EdgeKind.CSTORE || kind == EdgeKind.STORE || kind == EdgeKind.ICSTORE || kind == EdgeKind.ISTORE) {
                    return State.VMinus;
                }
            }
            case VMinus: {
                if (kind == EdgeKind.IASSIGN || kind == EdgeKind.ILOAD || kind == EdgeKind.ICLOAD) {
                    return State.VMinus;
                }
                if (kind == EdgeKind.INEW) {
                    return State.O;
                }
                if (kind == EdgeKind.PARAM) {
                    return State.End;
                }
            }
            case O: {
                if (kind != EdgeKind.NEW) break;
                return State.VPlus;
            }
        }
        return State.Error;
    }

    private void visit(Pair<Node, State> nodeState, Map<State, Set<Node>> state2nodes) {
        Node node = nodeState.getFirst();
        State state = nodeState.getSecond();
        state2nodes.computeIfAbsent(state, k -> new HashSet()).add(node);
    }

    private boolean isVisited(Pair<Node, State> nodeState, Map<State, Set<Node>> state2nodes) {
        Node node = nodeState.getFirst();
        State state = nodeState.getSecond();
        Set nodes = state2nodes.getOrDefault((Object)state, Collections.emptySet());
        return nodes.contains(node);
    }

    private State nextStateForIn(State currState, EdgeKind kind, boolean fieldMatch) {
        switch (currState) {
            case O: {
                if (kind == EdgeKind.NEW) {
                    return State.VPlus;
                }
            }
            case THIS: {
                if (kind == EdgeKind.ITHIS) {
                    return State.ThisAlias;
                }
            }
            case VPlus: {
                if (kind == EdgeKind.ASSIGN || kind == EdgeKind.LOAD || kind == EdgeKind.CLOAD) {
                    return State.VPlus;
                }
                if (kind == EdgeKind.ISTORE || kind == EdgeKind.STORE || kind == EdgeKind.ICSTORE || kind == EdgeKind.CSTORE) {
                    return State.VMinus;
                }
            }
            case VMinus: {
                if (kind == EdgeKind.IASSIGN || kind == EdgeKind.ILOAD || kind == EdgeKind.ICLOAD) {
                    return State.VMinus;
                }
                if (kind == EdgeKind.INEW) {
                    return State.O;
                }
                if (kind == EdgeKind.PARAM) {
                    return State.End;
                }
            }
            case ThisAlias: {
                if (kind == EdgeKind.ASSIGN) {
                    return State.ThisAlias;
                }
                if (kind == EdgeKind.ISTORE) {
                    if (!fieldMatch) break;
                    return State.VMinus;
                }
                if (kind != EdgeKind.LOAD || !fieldMatch) break;
                return State.VPlus;
            }
        }
        return State.Error;
    }

    public Set<LocalVarNode> getParamsStoredInto(SparkField field) {
        return this.field2InParams.getOrDefault(field, Collections.emptySet());
    }

    public Set<SootMethod> getOutMethodsWithRetOrParamValueFrom(SparkField field) {
        return this.field2OutParams.getOrDefault(field, Collections.emptySet()).stream().map(LocalVarNode::getMethod).collect(Collectors.toSet());
    }
}

