/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.toolkits.mahjong.automata;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import qilin.core.pag.AllocNode;
import qilin.core.pag.SparkField;
import qilin.pta.toolkits.common.FieldPointstoGraph;
import qilin.pta.toolkits.mahjong.automata.DFA;
import qilin.pta.toolkits.mahjong.automata.DFAState;
import qilin.pta.toolkits.mahjong.automata.NFA;
import sootup.core.types.Type;

public class DFAFactory {
    private final FieldPointstoGraph fpg;
    private Map<Set<AllocNode>, DFAState> stateMap;
    private Set<DFAState> states;
    private Set<DFAState> visited;

    public DFAFactory(FieldPointstoGraph fpg) {
        this.fpg = fpg;
        this.buildAllDFA();
    }

    public DFA getDFA(AllocNode obj) {
        DFAState q0 = this.stateMap.get(Collections.singleton(obj));
        return new DFA(q0);
    }

    private void buildAllDFA() {
        this.stateMap = new HashMap<Set<AllocNode>, DFAState>();
        this.states = new HashSet<DFAState>();
        this.visited = new HashSet<DFAState>();
        this.fpg.getAllObjs().forEach(this::buildDFA);
    }

    private void buildDFA(AllocNode obj) {
        Set<AllocNode> q0Set = Collections.singleton(obj);
        if (!this.stateMap.containsKey(q0Set)) {
            NFA nfa = new NFA(obj, this.fpg);
            DFAState startState = this.getDFAState(q0Set, nfa);
            LinkedList<DFAState> worklist = new LinkedList<DFAState>();
            this.states.add(startState);
            worklist.add(startState);
            while (!worklist.isEmpty()) {
                DFAState s = (DFAState)worklist.poll();
                if (this.visited.contains(s)) continue;
                this.visited.add(s);
                Set<SparkField> fields = this.fields(nfa, s.getObjects());
                fields.forEach(f -> {
                    Set<AllocNode> nextNFAStates = this.move(nfa, s.getObjects(), (SparkField)f);
                    DFAState nextState = this.getDFAState(nextNFAStates, nfa);
                    if (!this.states.contains(nextState)) {
                        this.states.add(nextState);
                        worklist.add(nextState);
                    }
                    this.addTransition(s, (SparkField)f, nextState);
                });
            }
        }
    }

    private DFAState getDFAState(Set<AllocNode> objs, NFA nfa) {
        if (!this.stateMap.containsKey(objs)) {
            Set<Type> output = objs.stream().map(nfa::outputOf).collect(Collectors.toSet());
            this.stateMap.put(objs, new DFAState(objs, output));
        }
        return this.stateMap.get(objs);
    }

    private Set<AllocNode> move(NFA nfa, Set<AllocNode> objs, SparkField f) {
        return objs.stream().map(obj -> nfa.nextStates((AllocNode)obj, f)).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private Set<SparkField> fields(NFA nfa, Set<AllocNode> objs) {
        return objs.stream().map(nfa::outEdgesOf).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private void addTransition(DFAState s, SparkField f, DFAState nextState) {
        s.addTransition(f, nextState);
    }
}

