/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.toolkits.zipper.analysis;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import qilin.core.PTA;
import qilin.core.builder.MethodNodeFactory;
import qilin.core.pag.AllocNode;
import qilin.core.pag.ContextMethod;
import qilin.core.pag.VarNode;
import qilin.core.sets.PointsToSet;
import qilin.pta.toolkits.common.OAG;
import qilin.pta.toolkits.zipper.Global;
import qilin.util.collect.SetFactory;
import qilin.util.graph.MergedNode;
import qilin.util.graph.SCCMergedGraph;
import qilin.util.graph.TopologicalSorter;
import sootup.core.model.SootMethod;
import sootup.core.types.Type;

public class PotentialContextElement {
    private final PTA pta;
    private Map<AllocNode, Set<SootMethod>> invokedMethods;
    private Map<AllocNode, Set<SootMethod>> obj2invokedMethods;
    private final Map<Type, Set<SootMethod>> typePCEMethods;
    private final Map<AllocNode, Set<SootMethod>> pceOfMap;
    private final OAG oag;
    private final Map<Type, Set<AllocNode>> typeAllocatees;
    private final Map<AllocNode, Set<AllocNode>> allocateeMap;

    PotentialContextElement(PTA pta, OAG oag) {
        this.pta = pta;
        this.oag = oag;
        this.typePCEMethods = new ConcurrentHashMap<Type, Set<SootMethod>>();
        this.obj2invokedMethods = new ConcurrentHashMap<AllocNode, Set<SootMethod>>();
        this.pceOfMap = new ConcurrentHashMap<AllocNode, Set<SootMethod>>();
        this.typeAllocatees = new ConcurrentHashMap<Type, Set<AllocNode>>();
        this.allocateeMap = new ConcurrentHashMap<AllocNode, Set<AllocNode>>();
        this.init(oag);
    }

    public Set<SootMethod> PCEMethodsOf(AllocNode obj) {
        return this.pceOfMap.getOrDefault(obj, Collections.emptySet());
    }

    public Set<SootMethod> PCEMethodsOf(Type type) {
        if (!this.typePCEMethods.containsKey(type)) {
            ConcurrentHashMap.KeySetView methods = ConcurrentHashMap.newKeySet();
            this.pta.getPag().getAllocNodes().stream().filter(o -> o.getType().equals(type)).forEach(obj -> methods.addAll(this.PCEMethodsOf((AllocNode)obj)));
            this.typePCEMethods.put(type, methods);
        }
        return this.typePCEMethods.getOrDefault(type, Collections.emptySet());
    }

    private void init(OAG oag) {
        SCCMergedGraph<AllocNode> mg = new SCCMergedGraph<AllocNode>(oag);
        TopologicalSorter<AllocNode> topoSorter = new TopologicalSorter<AllocNode>();
        SetFactory setFactory = new SetFactory();
        SetFactory setFactory2 = new SetFactory();
        this.buildMethodsInvokedOnObjects();
        this.invokedMethods = new HashMap<AllocNode, Set<SootMethod>>();
        topoSorter.sort(mg, true).forEach(node -> {
            ConcurrentHashMap.KeySetView methods = ConcurrentHashMap.newKeySet();
            methods.addAll(setFactory.get(this.getPCEMethods((MergedNode<AllocNode>)node, mg)));
            ConcurrentHashMap.KeySetView allocatees = ConcurrentHashMap.newKeySet();
            allocatees.addAll(setFactory2.get(this.getAllocatees((MergedNode<AllocNode>)node, mg)));
            node.getContent().forEach(obj -> {
                this.pceOfMap.put((AllocNode)obj, methods);
                this.allocateeMap.put((AllocNode)obj, allocatees);
            });
        });
        this.invokedMethods = null;
        if (Global.isDebug()) {
            this.computePCEObjects();
        }
        oag.allNodes().forEach(obj -> {
            Type type = obj.getType();
            this.typeAllocatees.putIfAbsent(type, new HashSet());
            this.typeAllocatees.get(type).addAll(this.allocateesOf((AllocNode)obj));
        });
    }

    private Set<AllocNode> getAllocatees(MergedNode<AllocNode> node, SCCMergedGraph<AllocNode> mg) {
        HashSet<AllocNode> allocatees = new HashSet<AllocNode>();
        mg.succsOf(node).forEach(n -> {
            allocatees.addAll(n.getContent());
            AllocNode o = (AllocNode)n.getContent().iterator().next();
            allocatees.addAll(this.allocateesOf(o));
        });
        AllocNode obj = node.getContent().iterator().next();
        if (node.getContent().size() > 1 || this.oag.succsOf(obj).contains(obj)) {
            allocatees.addAll(node.getContent());
        }
        return allocatees;
    }

    private Set<AllocNode> allocateesOf(AllocNode obj) {
        return this.allocateeMap.getOrDefault(obj, Collections.emptySet());
    }

    public Set<AllocNode> allocateesOf(Type type) {
        return this.typeAllocatees.getOrDefault(type, Collections.emptySet());
    }

    private Set<SootMethod> getPCEMethods(MergedNode<AllocNode> node, SCCMergedGraph<AllocNode> mg) {
        HashSet<SootMethod> methods = new HashSet<SootMethod>();
        mg.succsOf(node).forEach(n -> {
            AllocNode o2 = (AllocNode)n.getContent().iterator().next();
            methods.addAll(this.PCEMethodsOf(o2));
        });
        node.getContent().forEach(o -> methods.addAll(this.invokedMethodsOf((AllocNode)o)));
        return methods;
    }

    public Set<SootMethod> methodsInvokedOn(AllocNode obj) {
        return this.obj2invokedMethods.getOrDefault(obj, Collections.emptySet());
    }

    private void buildMethodsInvokedOnObjects() {
        this.obj2invokedMethods = new HashMap<AllocNode, Set<SootMethod>>();
        this.pta.getNakedReachableMethods().stream().filter(m -> !m.isStatic()).forEach(instMtd -> {
            MethodNodeFactory mthdNF = this.pta.getPag().getMethodPAG((SootMethod)instMtd).nodeFactory();
            VarNode thisVar = mthdNF.caseThis();
            PointsToSet pts = this.pta.reachingObjects(thisVar).toCIPointsToSet();
            Iterator<AllocNode> it = pts.iterator();
            while (it.hasNext()) {
                AllocNode obj = it.next();
                this.obj2invokedMethods.computeIfAbsent(obj, k -> new HashSet()).add(instMtd);
            }
        });
    }

    private Set<SootMethod> invokedMethodsOf(AllocNode obj) {
        if (!this.invokedMethods.containsKey(obj)) {
            HashSet<SootMethod> methods = new HashSet<SootMethod>();
            LinkedList<SootMethod> queue = new LinkedList<SootMethod>(this.methodsInvokedOn(obj));
            while (!queue.isEmpty()) {
                SootMethod method = (SootMethod)queue.poll();
                methods.add(method);
                this.pta.getCallGraph().edgesOutOf(new ContextMethod(method, this.pta.emptyContext())).forEachRemaining(edge -> {
                    SootMethod callee = edge.getTgt().method();
                    if (callee.isStatic() && !methods.contains(callee)) {
                        queue.offer(callee);
                    }
                });
            }
            this.invokedMethods.put(obj, methods);
        }
        return this.invokedMethods.get(obj);
    }

    private void computePCEObjects() {
        HashMap pceObjs = new HashMap();
        this.pta.getPag().getAllocNodes().forEach(obj -> this.PCEMethodsOf((AllocNode)obj).forEach(method -> {
            if (!pceObjs.containsKey(method)) {
                pceObjs.put(method, new HashSet());
            }
            ((Set)pceObjs.get(method)).add(obj);
        }));
    }
}

