/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.toolkits.zipper.flowgraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import qilin.core.PTA;
import qilin.core.pag.AllocNode;
import qilin.core.pag.ContextField;
import qilin.core.pag.ContextVarNode;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.Node;
import qilin.core.pag.ValNode;
import qilin.core.pag.VarNode;
import qilin.pta.toolkits.common.ToolUtil;
import qilin.pta.toolkits.zipper.Global;
import qilin.pta.toolkits.zipper.analysis.PotentialContextElement;
import qilin.pta.toolkits.zipper.flowgraph.Edge;
import qilin.pta.toolkits.zipper.flowgraph.Kind;
import qilin.pta.toolkits.zipper.flowgraph.ObjectFlowGraph;
import qilin.util.ANSIColor;
import qilin.util.graph.ConcurrentDirectedGraphImpl;
import qilin.util.graph.Reachability;
import sootup.core.jimple.basic.LValue;
import sootup.core.jimple.common.expr.AbstractInstanceInvokeExpr;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.SootMethod;
import sootup.core.types.ReferenceType;
import sootup.core.types.Type;

public class FlowAnalysis {
    private final PTA pta;
    private final PotentialContextElement pce;
    private final ObjectFlowGraph objectFlowGraph;
    private Type currentType;
    private Set<VarNode> inVars;
    private Set<Node> outNodes;
    private Set<Node> visitedNodes;
    private Map<Node, Set<Edge>> wuEdges;
    private ConcurrentDirectedGraphImpl<Node> pollutionFlowGraph;
    private Reachability<Node> reachability;

    public FlowAnalysis(PTA pta, PotentialContextElement pce, ObjectFlowGraph ofg) {
        this.pta = pta;
        this.pce = pce;
        this.objectFlowGraph = ofg;
    }

    public void initialize(Type type, Set<SootMethod> inms, Set<SootMethod> outms) {
        this.currentType = type;
        this.inVars = inms.stream().map(m -> ToolUtil.getParameters(this.pta.getPag(), m)).flatMap(Collection::stream).collect(Collectors.toSet());
        this.outNodes = outms.stream().map(m -> ToolUtil.getRetVars(this.pta.getPag(), m)).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toSet());
        this.visitedNodes = new HashSet<Node>();
        this.wuEdges = new HashMap<Node, Set<Edge>>();
        this.pollutionFlowGraph = new ConcurrentDirectedGraphImpl();
        this.reachability = new Reachability<Node>(this.pollutionFlowGraph);
    }

    public void analyze(SootMethod startMethod) {
        for (VarNode param : ToolUtil.getParameters(this.pta.getPag(), startMethod)) {
            if (param != null) {
                this.dfs(param);
                continue;
            }
            if (!Global.isDebug()) continue;
            System.out.println(param + " is absent in the flow graph.");
        }
        if (Global.isDebug()) {
            HashSet<SootMethod> outMethods = new HashSet<SootMethod>();
            for (VarNode param : ToolUtil.getParameters(this.pta.getPag(), startMethod)) {
                if (param == null) continue;
                for (Node outNode : this.outNodes) {
                    if (!this.reachability.reachableNodesFrom(param).contains(outNode)) continue;
                    LocalVarNode outVarNode = (LocalVarNode)outNode;
                    outMethods.add(outVarNode.getMethod());
                }
            }
            System.out.println(ANSIColor.color("\u001b[32m", "In method: ") + startMethod);
            System.out.println(ANSIColor.color("\u001b[32m", "Out methods: ") + outMethods);
        }
    }

    public Set<Node> getFlowNodes() {
        HashSet<Node> results = new HashSet<Node>();
        for (Node outNode : this.outNodes) {
            if (!this.pollutionFlowGraph.allNodes().contains(outNode)) continue;
            results.addAll(this.reachability.nodesReach(outNode));
        }
        return results;
    }

    public int numberOfPFGNodes() {
        return this.pollutionFlowGraph.allNodes().size();
    }

    public int numberOfPFGEdges() {
        int nrEdges = 0;
        for (Node node : this.pollutionFlowGraph.allNodes()) {
            nrEdges += this.pollutionFlowGraph.succsOf(node).size();
        }
        return nrEdges;
    }

    public ConcurrentDirectedGraphImpl<Node> getPFG() {
        return this.pollutionFlowGraph;
    }

    public void clear() {
        this.currentType = null;
        this.inVars = null;
        this.outNodes = null;
        this.visitedNodes = null;
        this.wuEdges = null;
        this.pollutionFlowGraph = null;
        this.reachability = null;
    }

    private void dfs(Node node) {
        if (Global.isDebug()) {
            System.out.println(ANSIColor.color("\u001b[34m", "Node ") + node);
        }
        if (this.visitedNodes.contains(node)) {
            if (Global.isDebug()) {
                System.out.println(ANSIColor.color("\u001b[31m", "Visited node: ") + node);
            }
        } else {
            this.visitedNodes.add(node);
            this.pollutionFlowGraph.addNode(node);
            if (Global.isEnableUnwrappedFlow() && node instanceof VarNode) {
                VarNode var = (VarNode)node;
                Collection<AllocNode> varPts = this.pta.reachingObjects(var).toCIPointsToSet().toCollection();
                ((Collection)this.pta.getCgb().getReceiverToSitesMap().getOrDefault(var, Collections.emptySet())).forEach(vcs -> {
                    Stmt callsiteStmt = vcs.getUnit();
                    AbstractInvokeExpr invo = callsiteStmt.getInvokeExpr();
                    if (!(invo instanceof AbstractInstanceInvokeExpr)) {
                        return;
                    }
                    if (callsiteStmt instanceof JAssignStmt) {
                        JAssignStmt assignStmt = (JAssignStmt)callsiteStmt;
                        LValue lv = assignStmt.getLeftOp();
                        if (!(lv.getType() instanceof ReferenceType)) {
                            return;
                        }
                        VarNode to = (VarNode)this.pta.getPag().findValNode(lv, var.getMethod());
                        if (this.outNodes.contains(to)) {
                            for (VarNode inVar : this.inVars) {
                                if (Collections.disjoint(this.pta.reachingObjects(inVar).toCIPointsToSet().toCollection(), varPts)) continue;
                                Edge unwrappedEdge = new Edge(Kind.UNWRAPPED_FLOW, node, to);
                                this.addWUEdge(node, unwrappedEdge);
                                break;
                            }
                        }
                    }
                });
            }
            ArrayList<Edge> nextEdges = new ArrayList<Edge>();
            block5: for (Edge edge : this.outEdgesOf(node)) {
                switch (edge.getKind()) {
                    case UNWRAPPED_FLOW: 
                    case LOCAL_ASSIGN: {
                        nextEdges.add(edge);
                        break;
                    }
                    case INTERPROCEDURAL_ASSIGN: 
                    case INSTANCE_LOAD: 
                    case WRAPPED_FLOW: {
                        ValNode next = (LocalVarNode)edge.getTarget();
                        SootMethod inMethod = ((LocalVarNode)next).getMethod();
                        if (!this.pce.PCEMethodsOf(this.currentType).contains(inMethod)) continue block5;
                        nextEdges.add(edge);
                        break;
                    }
                    case INSTANCE_STORE: {
                        ValNode next = (ContextField)edge.getTarget();
                        AllocNode base = ((ContextField)next).getBase();
                        if (base.getType().equals(this.currentType)) {
                            if (Global.isEnableWrappedFlow()) {
                                this.methodsInvokedOn(this.currentType).stream().map(m -> ToolUtil.getThis(this.pta.getPag(), m)).map(arg_0 -> FlowAnalysis.lambda$dfs$4((ContextField)next, arg_0)).forEach(arg_0 -> this.lambda$dfs$5((ContextField)next, arg_0));
                            }
                            nextEdges.add(edge);
                            break;
                        }
                        if (!this.pce.allocateesOf(this.currentType).contains(base)) continue block5;
                        if (Global.isEnableWrappedFlow()) {
                            Node assigned;
                            HashSet r = new HashSet();
                            AllocNode mBase = (AllocNode)this.pta.parameterize(base, this.pta.emptyContext());
                            this.pta.getPag().allocLookup(mBase).forEach(v -> {
                                LocalVarNode lvn;
                                ContextVarNode cvn;
                                if (v instanceof ContextVarNode && (cvn = (ContextVarNode)v).base() instanceof LocalVarNode && !(lvn = (LocalVarNode)cvn.base()).isThis()) {
                                    r.add(lvn);
                                }
                            });
                            Iterator it = r.iterator();
                            if (it.hasNext() && (assigned = (Node)r.iterator().next()) != null) {
                                Edge e = new Edge(Kind.WRAPPED_FLOW, next, assigned);
                                this.addWUEdge(next, e);
                            }
                        }
                        nextEdges.add(edge);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown edge: " + edge);
                    }
                }
            }
            for (Edge nextEdge : nextEdges) {
                Node nextNode = nextEdge.getTarget();
                this.pollutionFlowGraph.addEdge(node, nextNode);
                this.dfs(nextNode);
            }
        }
    }

    private void addWUEdge(Node sourceNode, Edge edge) {
        this.wuEdges.computeIfAbsent(sourceNode, k -> new HashSet()).add(edge);
    }

    private Collection<SootMethod> methodsInvokedOn(Type type) {
        return this.pta.getPag().getAllocNodes().stream().filter(o -> o.getType().equals(type)).map(this.pce::methodsInvokedOn).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private Set<Edge> outEdgesOf(Node node) {
        Set<Edge> outEdges = this.objectFlowGraph.outEdgesOf(node);
        if (this.wuEdges.containsKey(node)) {
            outEdges = new HashSet<Edge>(outEdges);
            outEdges.addAll((Collection<Edge>)this.wuEdges.get(node));
        }
        return outEdges;
    }

    private void outputPollutionFlowGraphSize() {
        int nrNodes = this.pollutionFlowGraph.allNodes().size();
        int nrEdges = 0;
        for (Node node : this.pollutionFlowGraph.allNodes()) {
            nrEdges += this.pollutionFlowGraph.succsOf(node).size();
        }
        System.out.printf("#Size of PFG of %s: %d nodes, %d edges.\n", this.currentType, nrNodes, nrEdges);
    }

    private /* synthetic */ void lambda$dfs$5(ContextField next, Edge e) {
        this.addWUEdge(next, e);
    }

    private static /* synthetic */ Edge lambda$dfs$4(ContextField next, VarNode n) {
        return new Edge(Kind.WRAPPED_FLOW, next, n);
    }
}

