/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.toolkits.zipper.flowgraph;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import qilin.core.PTA;
import qilin.core.builder.MethodNodeFactory;
import qilin.core.pag.ContextField;
import qilin.core.pag.ContextVarNode;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.Node;
import qilin.core.pag.ValNode;
import qilin.core.pag.VarNode;
import qilin.pta.toolkits.zipper.Global;
import qilin.pta.toolkits.zipper.flowgraph.Edge;
import qilin.pta.toolkits.zipper.flowgraph.IObjectFlowGraph;
import qilin.pta.toolkits.zipper.flowgraph.Kind;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.common.expr.AbstractInstanceInvokeExpr;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.SootMethod;

public class ObjectFlowGraph
implements IObjectFlowGraph {
    private final PTA pta;
    private Map<Node, Set<Edge>> outEdges;

    public ObjectFlowGraph(PTA pta) {
        this.pta = pta;
        this.init();
    }

    @Override
    public Set<Edge> outEdgesOf(Node node) {
        return this.outEdges.getOrDefault(node, Collections.emptySet());
    }

    @Override
    public Set<Node> allNodes() {
        return this.outEdges.keySet();
    }

    private boolean localVarBase(ValNode valNode) {
        if (valNode instanceof ContextVarNode) {
            ContextVarNode cvn = (ContextVarNode)valNode;
            return cvn.base() instanceof LocalVarNode;
        }
        return valNode instanceof LocalVarNode;
    }

    private LocalVarNode fetchLocalVar(ValNode valNode) {
        if (valNode instanceof ContextVarNode) {
            ContextVarNode cvn = (ContextVarNode)valNode;
            if (cvn.base() instanceof LocalVarNode) {
                return (LocalVarNode)cvn.base();
            }
        } else if (valNode instanceof LocalVarNode) {
            return (LocalVarNode)valNode;
        }
        return null;
    }

    private LocalVarNode fetchVar(ValNode valNode) {
        if (valNode instanceof ContextVarNode) {
            ContextVarNode cvn = (ContextVarNode)valNode;
            VarNode base = cvn.base();
            if (base instanceof LocalVarNode) {
                return (LocalVarNode)base;
            }
        } else if (valNode instanceof LocalVarNode) {
            return (LocalVarNode)valNode;
        }
        return null;
    }

    public void addOutEdge(Edge e) {
        this.outEdges.computeIfAbsent(e.getSource(), k -> new HashSet()).add(e);
    }

    private void init() {
        this.outEdges = new HashMap<Node, Set<Edge>>();
        this.pta.getPag().getSimple().forEach((s, ts) -> {
            if (this.localVarBase((ValNode)s)) {
                ts.forEach(t -> {
                    if (this.localVarBase((ValNode)t)) {
                        LocalVarNode toNode = this.fetchVar((ValNode)t);
                        LocalVarNode fromNode = this.fetchVar((ValNode)s);
                        if (this.fetchLocalVar((ValNode)s).isInterProcSource()) {
                            this.addOutEdge(new Edge(Kind.INTERPROCEDURAL_ASSIGN, fromNode, toNode));
                        } else if (this.fetchLocalVar((ValNode)t).isInterProcTarget()) {
                            if (!this.fetchLocalVar((ValNode)t).isThis()) {
                                this.addOutEdge(new Edge(Kind.INTERPROCEDURAL_ASSIGN, fromNode, toNode));
                            }
                        } else {
                            this.addOutEdge(new Edge(Kind.LOCAL_ASSIGN, fromNode, toNode));
                        }
                    } else if (t instanceof ContextField) {
                        ContextField ctxField = (ContextField)t;
                        LocalVarNode varNode = this.fetchVar((ValNode)s);
                        this.addOutEdge(new Edge(Kind.INSTANCE_STORE, varNode, ctxField));
                    }
                });
            } else if (s instanceof ContextField) {
                ContextField ctxField = (ContextField)s;
                ts.forEach(t -> {
                    assert (this.localVarBase((ValNode)t));
                    LocalVarNode varNode = this.fetchVar((ValNode)t);
                    this.addOutEdge(new Edge(Kind.INSTANCE_LOAD, ctxField, varNode));
                });
            }
        });
        this.pta.getCallGraph().forEach(e -> {
            Stmt callsite = e.srcStmt();
            SootMethod caller = e.src();
            if (caller != null) {
                SootMethod callee = e.tgt();
                if (!callee.isStatic()) {
                    MethodNodeFactory calleeNF = this.pta.getPag().getMethodPAG(callee).nodeFactory();
                    LocalVarNode thisVar = (LocalVarNode)calleeNF.caseThis();
                    AbstractInvokeExpr ie = callsite.getInvokeExpr();
                    Local base = null;
                    if (ie instanceof AbstractInstanceInvokeExpr) {
                        AbstractInstanceInvokeExpr iie = (AbstractInstanceInvokeExpr)ie;
                        base = iie.getBase();
                    }
                    if (base != null) {
                        LocalVarNode fromNode = (LocalVarNode)this.pta.getPag().findValNode(base, caller);
                        this.addOutEdge(new Edge(Kind.INTERPROCEDURAL_ASSIGN, fromNode, thisVar));
                    }
                }
            } else if (Global.isDebug()) {
                System.out.println("Null caller of: " + callsite);
            }
        });
    }
}

