/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.tools;

import java.util.HashSet;
import java.util.Set;
import qilin.core.PTAScene;
import qilin.core.pag.AllocNode;
import qilin.core.pag.ContextMethod;
import qilin.core.pag.FieldRefNode;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.MethodPAG;
import qilin.core.pag.Node;
import qilin.core.pag.VarNode;
import qilin.parm.ctxcons.CtxConstructor;
import qilin.parm.heapabst.AllocSiteAbstractor;
import qilin.parm.heapabst.HeuristicAbstractor;
import qilin.parm.select.HeuristicSelector;
import qilin.parm.select.PartialMethodLvSelector;
import qilin.parm.select.PipelineSelector;
import qilin.pta.PTAConfig;
import qilin.pta.toolkits.zipper.Main;
import qilin.pta.tools.Spark;
import qilin.pta.tools.StagedPTA;
import qilin.util.PTAUtils;
import qilin.util.Stopwatch;
import qilin.util.queue.QueueReader;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.LValue;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.common.constant.NullConstant;
import sootup.core.jimple.common.expr.AbstractInstanceInvokeExpr;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.SootMethod;
import sootup.core.types.ReferenceType;

public class ZipperPTA
extends StagedPTA {
    private final Set<SootMethod> PCMs = new HashSet<SootMethod>();

    public ZipperPTA(PTAScene scene, int k, int hk, CtxConstructor ctxCons) {
        super(scene);
        this.ctxCons = ctxCons;
        PartialMethodLvSelector us = new PartialMethodLvSelector(k, hk, this.PCMs);
        this.ctxSel = PTAConfig.v().getPtaConfig().enforceEmptyCtxForIgnoreTypes ? new PipelineSelector(new HeuristicSelector(this.getView()), us) : us;
        this.heapAbst = PTAConfig.v().getPtaConfig().mergeHeap ? new HeuristicAbstractor(this.pag) : new AllocSiteAbstractor();
        this.prePTA = new Spark(scene);
    }

    @Override
    protected void preAnalysis() {
        Stopwatch sparkTimer = Stopwatch.newAndStart("Spark");
        this.prePTA.pureRun();
        sparkTimer.stop();
        System.out.println(sparkTimer);
        Stopwatch zipperTimer = Stopwatch.newAndStart("Zipper");
        Main.run(this.prePTA, this.PCMs);
        zipperTimer.stop();
        System.out.println(zipperTimer);
        this.extraStats();
    }

    protected void extraStats() {
        int[] RM = new int[1];
        int[] PCN = new int[1];
        int[] NPCN = new int[1];
        int[] totalN = new int[1];
        for (ContextMethod momc : this.prePTA.getReachableMethods()) {
            SootMethod method = momc.method();
            HashSet<Object> nodes = new HashSet<Object>();
            if (!PTAUtils.hasBody(method)) {
                return;
            }
            MethodPAG srcmpag = this.pag.getMethodPAG(method);
            Object reader = srcmpag.getInternalReader().clone();
            while (((QueueReader)reader).hasNext()) {
                FieldRefNode fr;
                VarNode base;
                Node from = (Node)((QueueReader)reader).next();
                Node to = (Node)((QueueReader)reader).next();
                if (from instanceof LocalVarNode) {
                    nodes.add(((VarNode)from).getVariable());
                } else if (from instanceof AllocNode) {
                    nodes.add(((AllocNode)from).getNewExpr());
                } else if (from instanceof FieldRefNode && (base = (fr = (FieldRefNode)from).getBase()) instanceof LocalVarNode) {
                    nodes.add(base.getVariable());
                }
                if (to instanceof LocalVarNode) {
                    nodes.add(((VarNode)to).getVariable());
                    continue;
                }
                if (!(to instanceof FieldRefNode) || !((base = (fr = (FieldRefNode)to).getBase()) instanceof LocalVarNode)) continue;
                nodes.add(base.getVariable());
            }
            for (Stmt s : srcmpag.getInvokeStmts()) {
                LValue dest;
                AbstractInvokeExpr ie = s.getInvokeExpr();
                int numArgs = ie.getArgCount();
                for (int i = 0; i < numArgs; ++i) {
                    Immediate arg = ie.getArg(i);
                    if (!(arg.getType() instanceof ReferenceType) || arg instanceof NullConstant) continue;
                    nodes.add(arg);
                }
                if (s instanceof JAssignStmt && (dest = ((JAssignStmt)s).getLeftOp()).getType() instanceof ReferenceType) {
                    nodes.add(dest);
                }
                if (!(ie instanceof AbstractInstanceInvokeExpr)) continue;
                AbstractInstanceInvokeExpr iie = (AbstractInstanceInvokeExpr)ie;
                Local base = iie.getBase();
                nodes.add(base);
            }
            if (this.PCMs.contains(method)) {
                PCN[0] = PCN[0] + nodes.size();
            } else {
                NPCN[0] = NPCN[0] + nodes.size();
            }
            RM[0] = RM[0] + 1;
            totalN[0] = totalN[0] + nodes.size();
        }
        RM[0] = RM[0] - 1;
        System.out.println("#ReachableMethod:" + RM[0]);
        System.out.println("#FCSM:" + this.PCMs.size());
        System.out.println("#PCSM:0");
        System.out.println("#CIM:" + (RM[0] - this.PCMs.size()));
        System.out.println("#CIN: " + NPCN[0]);
        System.out.println("#CSN: " + PCN[0]);
        System.out.println("totalN: " + totalN[0]);
    }
}

