/*
 * Decompiled with CFR 0.152.
 */
package qilin.stat;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import qilin.CoreConfig;
import qilin.core.PTA;
import qilin.core.builder.callgraph.Edge;
import qilin.core.builder.callgraph.OnFlyCallGraph;
import qilin.core.pag.AllocNode;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.Parm;
import qilin.core.sets.PointsToSet;
import qilin.util.Util;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.expr.JCastExpr;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.SootClass;
import sootup.core.model.SootMethod;
import sootup.core.signatures.MethodSignature;
import sootup.core.types.Type;

public class Exporter {
    private final PTA pta;
    private final String metrics = "Metrics.csv";
    private final String staticFPTs = "StaticFieldPointsTo.csv";
    private static final int STATLENGTH = 50;
    private final StringBuffer report = new StringBuffer();

    public Exporter(PTA pta) {
        this.pta = pta;
    }

    public void addLine(String str) {
        this.report.append(str).append('\n');
    }

    private String makeUp(String string) {
        String makeUpString = " ";
        String tmp = "";
        for (int i = 0; i < Math.max(0, 50 - string.length()); ++i) {
            tmp = tmp.concat(" ");
        }
        return string + tmp;
    }

    public void collectMetric(String desc, String value) {
        this.addLine(this.makeUp(desc) + value);
    }

    private String getFilePath(String fileName) {
        String finalPath = CoreConfig.v().getOutConfig().outDir;
        File file = new File(finalPath = finalPath + File.separator + CoreConfig.v().getAppConfig().MAIN_CLASS + File.separator + CoreConfig.v().getPtaConfig().ptaName + File.separator);
        if (!file.exists()) {
            file.mkdirs();
        }
        finalPath = finalPath + fileName;
        return finalPath;
    }

    private void dumpMethods(Collection<SootMethod> methods, String fileName) {
        StringBuilder builder = new StringBuilder();
        for (SootMethod sm : methods) {
            String sig = ((MethodSignature)sm.getSignature()).toString();
            sig = Util.stripQuotes(sig);
            builder.append(sig);
            builder.append("\n");
        }
        String finalPath = this.getFilePath(fileName);
        Util.writeToFile(finalPath, builder.toString());
    }

    public void dumpReachableMethods(Collection<SootMethod> reachables) {
        String reachMethods = "Reachable.csv";
        this.dumpMethods(reachables, reachMethods);
    }

    public void dumpAppReachableMethods(Collection<SootMethod> appReachables) {
        String appReachMethods = "AppReachable.csv";
        this.dumpMethods(appReachables, appReachMethods);
    }

    public void dumpSingleCallMethods(Collection<SootMethod> singleCallMs) {
        String singleCalls = "SingleCallMethods.csv";
        this.dumpMethods(singleCallMs, singleCalls);
    }

    public void dumpSingleReceiverMethods(Collection<SootMethod> singleReceiverMs) {
        String singleReceivers = "SingleReceiverMethods.csv";
        this.dumpMethods(singleReceiverMs, singleReceivers);
    }

    public void dumpSingleCallSingleReceiverMethods(Collection<SootMethod> singleCallSingleReceiverMs) {
        String singleCallSingleReceivers = "SingleCallSingleReceiverMethods.csv";
        this.dumpMethods(singleCallSingleReceiverMs, singleCallSingleReceivers);
    }

    public void dumpClassTypes(Collection<? extends SootClass> classes) {
        StringBuilder builder = new StringBuilder();
        for (SootClass sootClass : classes) {
            builder.append(sootClass.getName());
            builder.append("\n");
        }
        String classTypes = "ClassType.csv";
        String string = this.getFilePath(classTypes);
        Util.writeToFile(string, builder.toString());
    }

    public void dumpPolyCalls(Map<AbstractInvokeExpr, SootMethod> polys) {
        StringBuilder builder = new StringBuilder();
        for (AbstractInvokeExpr ie : polys.keySet()) {
            SootMethod tgt = (SootMethod)this.pta.getView().getMethod(ie.getMethodSignature()).get();
            String polySig = polys.get(ie).getSignature() + "/" + tgt.getDeclaringClassType() + "." + tgt.getName() + "\n";
            builder.append(polySig);
        }
        String polyCalls = "PolyCalls.csv";
        String finalPath = this.getFilePath(polyCalls);
        Util.writeToFile(finalPath, builder.toString());
    }

    public void dumpMayFailCasts(Map<SootMethod, Set<Stmt>> casts) {
        StringBuilder builder = new StringBuilder();
        for (SootMethod sm : casts.keySet()) {
            for (Stmt stmt : casts.get(sm)) {
                JAssignStmt as = (JAssignStmt)stmt;
                JCastExpr ce = (JCastExpr)as.getRightOp();
                Type targetType = ce.getType();
                builder.append(sm.toString());
                builder.append("\t");
                builder.append(targetType.toString());
                builder.append("\t");
                builder.append(sm).append("/").append(ce.getOp().toString());
                builder.append("\t");
                builder.append(sm).append("/").append(as.getLeftOp().toString());
                builder.append("\n");
            }
        }
        String mayFailCasts = "MayFailCasts.csv";
        String finalPath = this.getFilePath(mayFailCasts);
        Util.writeToFile(finalPath, builder.toString());
    }

    public void dumpMethodThrowPointsto(Map<SootMethod, PointsToSet> m2pts) {
        String methodThrowPts = "MethodThrowPointsTo.csv";
        String finalPath = this.getFilePath(methodThrowPts);
        try {
            File mfile = new File(finalPath);
            mfile.delete();
            mfile.createNewFile();
            BufferedWriter writer = new BufferedWriter(new FileWriter(mfile, true));
            for (SootMethod sm : m2pts.keySet()) {
                PointsToSet pts = m2pts.get(sm).toCIPointsToSet();
                Iterator<AllocNode> it = pts.iterator();
                while (it.hasNext()) {
                    AllocNode n = it.next();
                    StringBuilder builder = new StringBuilder();
                    builder.append(n.toString());
                    builder.append("\t");
                    String sig = Util.stripQuotes(((MethodSignature)sm.getSignature()).toString());
                    builder.append(sig);
                    builder.append("\n");
                    try {
                        writer.write(builder.toString());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dumpInsensCallGraph(OnFlyCallGraph ciCallGraph) {
        String insensCallGraphEdges = "InsensCallGraphEdges.csv";
        String finalPath = this.getFilePath(insensCallGraphEdges);
        try {
            File mfile = new File(finalPath);
            mfile.delete();
            mfile.createNewFile();
            BufferedWriter writer = new BufferedWriter(new FileWriter(mfile, true));
            for (Edge edge : ciCallGraph) {
                String srcSig = Util.stripQuotes(((MethodSignature)edge.src().getSignature()).toString());
                String dstSig = Util.stripQuotes(((MethodSignature)edge.tgt().getSignature()).toString());
                String str = edge.srcStmt() + " in method " + srcSig + "\t" + dstSig + "\n";
                writer.write(str);
            }
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dumpReachableLocalVars(Collection<LocalVarNode> lvns) {
        StringBuilder builder = new StringBuilder();
        for (LocalVarNode lvn : lvns) {
            String varName = this.getDoopVarName(lvn);
            builder.append(varName).append("\n");
        }
        String insensReachVars = "InsensReachVars.csv";
        String finalPath = this.getFilePath(insensReachVars);
        Util.writeToFile(finalPath, builder.toString());
    }

    public void dumpReachableLocalVarsNoNative(Collection<LocalVarNode> lvns) {
        StringBuilder builder = new StringBuilder();
        for (LocalVarNode lvn : lvns) {
            String varName = this.getDoopVarName(lvn);
            builder.append(varName).append("\n");
        }
        String insensReachVars = "InsensReachVarsNoNatives.csv";
        String finalPath = this.getFilePath(insensReachVars);
        Util.writeToFile(finalPath, builder.toString());
    }

    private String getDoopVarName(LocalVarNode lvn) {
        SootMethod m = lvn.getMethod();
        Object v = lvn.getVariable();
        String varName = v.toString();
        if (v instanceof Parm) {
            Parm parm = (Parm)v;
            if (parm.isThis()) {
                varName = "@this";
            } else if (!parm.isReturn() && !parm.isThrowRet()) {
                varName = "@parameter" + parm.getIndex();
            }
        }
        return m.getSignature() + "/" + varName;
    }

    public void dumpInsensPointsTo(Collection<LocalVarNode> lvns, PTA pta) {
        String insensVarPTs = "InsensVarPointsTo.csv";
        String finalPath = this.getFilePath(insensVarPTs);
        try {
            File mfile = new File(finalPath);
            mfile.delete();
            mfile.createNewFile();
            BufferedWriter writer = new BufferedWriter(new FileWriter(mfile, true));
            for (LocalVarNode lvn : lvns) {
                String varName = this.getDoopVarName(lvn);
                HashSet<AllocNode> callocSites = new HashSet<AllocNode>();
                PointsToSet cpts = pta.reachingObjects(lvn).toCIPointsToSet();
                Iterator<AllocNode> it = cpts.iterator();
                while (it.hasNext()) {
                    AllocNode heap = it.next();
                    callocSites.add(heap);
                }
                for (AllocNode heap : callocSites) {
                    String str = heap.getNewExpr() + "\t" + varName + "\n";
                    if (heap.getMethod() != null) {
                        str = heap.getMethod() + "/" + heap.getNewExpr() + "\t" + varName + "\n";
                    }
                    writer.write(str);
                }
            }
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String report() {
        String tmp = this.report.toString();
        if (CoreConfig.v().getOutConfig().dumpStats) {
            String statistics = "Statistics.txt";
            String finalPath = this.getFilePath(statistics);
            Util.writeToFile(finalPath, tmp);
        }
        return tmp;
    }
}

