/*
 * Decompiled with CFR 0.152.
 */
package qilin.stat;

import qilin.CoreConfig;
import qilin.core.PTA;
import qilin.stat.AliasStat;
import qilin.stat.BenchmarkStat;
import qilin.stat.CallGraphStat;
import qilin.stat.Exporter;
import qilin.stat.IEvaluator;
import qilin.stat.PAGStat;
import qilin.stat.PointsToStat;
import qilin.stat.RuntimeStat;
import qilin.stat.TypeClientStat;
import qilin.stat.YummyStat;

public class PTAEvaluator
implements IEvaluator {
    protected final RuntimeStat runtimeStat;
    protected final Exporter exporter;
    protected final PTA pta;

    public PTAEvaluator(PTA pta) {
        this.pta = pta;
        this.runtimeStat = new RuntimeStat();
        this.exporter = new Exporter(pta);
    }

    @Override
    public void begin() {
        Runtime runtime = Runtime.getRuntime();
        this.exporter.addLine(" ====== Memory Usage ======");
        this.exporter.collectMetric("Used Memory Before:", (runtime.totalMemory() - runtime.freeMemory()) / 0x40000000L + " GB");
        this.exporter.collectMetric("Free Memory Before:", runtime.freeMemory() / 0x40000000L + " GB");
        this.exporter.collectMetric("Total Memory Before:", runtime.totalMemory() / 0x40000000L + " GB");
        this.exporter.collectMetric("Max Memory Before:", runtime.maxMemory() / 0x40000000L + " GB");
        this.exporter.collectMetric("Analysis: ", CoreConfig.v().getPtaConfig().ptaName);
        this.runtimeStat.begin();
    }

    @Override
    public void end() {
        this.runtimeStat.end();
        PAGStat pagStat = new PAGStat(this.pta);
        BenchmarkStat benchmarkStat = new BenchmarkStat(this.pta);
        CallGraphStat callGraphStat = new CallGraphStat(this.pta);
        TypeClientStat typeClientStat = new TypeClientStat(this.pta);
        PointsToStat ptsStat = new PointsToStat(this.pta);
        AliasStat aliasStat = new AliasStat(this.pta);
        YummyStat yummyStat = new YummyStat(this.pta);
        this.runtimeStat.export(this.exporter);
        Runtime runtime = Runtime.getRuntime();
        this.exporter.collectMetric("Used Memory After:", (runtime.totalMemory() - runtime.freeMemory()) / 0x40000000L + " GB");
        this.exporter.collectMetric("Free Memory After:", runtime.freeMemory() / 0x40000000L + " GB");
        this.exporter.collectMetric("Total Memory After:", runtime.totalMemory() / 0x40000000L + " GB");
        this.exporter.collectMetric("Max Memory After:", runtime.maxMemory() / 0x40000000L + " GB");
        this.exporter.addLine(" ====== Yummy ======");
        yummyStat.export(this.exporter);
        this.exporter.addLine(" ====== Call Graph ======");
        callGraphStat.export(this.exporter);
        this.exporter.addLine(" ====== Statements ======");
        typeClientStat.export(this.exporter);
        this.exporter.addLine(" ====== Nodes ======");
        ptsStat.export(this.exporter);
        this.exporter.addLine(" ====== Assignments ======");
        pagStat.export(this.exporter);
        this.exporter.addLine(" ====== Aliases ======");
        aliasStat.export(this.exporter);
        this.exporter.addLine(" ====== Classes ======");
        benchmarkStat.export(this.exporter);
    }

    public String toString() {
        return this.exporter.report();
    }
}

