/*
 * Decompiled with CFR 0.152.
 */
package qilin.stat;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import qilin.core.PTA;
import qilin.core.builder.FakeMainFactory;
import qilin.core.builder.MethodNodeFactory;
import qilin.core.builder.callgraph.Edge;
import qilin.core.builder.callgraph.OnFlyCallGraph;
import qilin.core.pag.AllocNode;
import qilin.core.pag.ContextMethod;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.MethodPAG;
import qilin.core.pag.Node;
import qilin.core.pag.PAG;
import qilin.core.sets.PointsToSet;
import qilin.stat.AliasStat;
import qilin.stat.Exporter;
import qilin.stat.IEvaluator;
import qilin.util.PTAUtils;
import qilin.util.Stopwatch;
import qilin.util.Triple;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.LValue;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.expr.JCastExpr;
import sootup.core.jimple.common.expr.JStaticInvokeExpr;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.SootMethod;
import sootup.core.types.ReferenceType;
import sootup.core.types.Type;

public class SimplifiedEvaluator
implements IEvaluator {
    protected final PTA pta;
    protected final Exporter exporter;
    protected Stopwatch stopwatch;
    private final Set<String> handledNatives = Sets.newHashSet((Object[])new String[]{"<org.apache.xerces.parsers.XML11Configuration: boolean getFeature0(java.lang.String)>", "<java.lang.ref.Finalizer: void invokeFinalizeMethod(java.lang.Object)>", "<java.lang.Thread: java.lang.Thread currentThread()>", "<java.lang.Thread: void start0()>", "<java.lang.Object: java.lang.Object clone()>", "<java.lang.System: void setIn0(java.io.InputStream)>", "<java.lang.System: void setOut0(java.io.PrintStream)>", "<java.lang.System: void setErr0(java.io.PrintStream)>", "<java.io.FileSystem: java.io.FileSystem getFileSystem()>", "<java.io.UnixFileSystem: java.lang.String[] list(java.io.File)>", "<java.security.AccessController: java.lang.Object doPrivileged(java.security.PrivilegedAction)>", "<java.security.AccessController: java.lang.Object doPrivileged(java.security.PrivilegedAction,java.security.AccessControlContext)>", "<java.security.AccessController: java.lang.Object doPrivileged(java.security.PrivilegedExceptionAction)>", "<java.security.AccessController: java.lang.Object doPrivileged(java.security.PrivilegedExceptionAction,java.security.AccessControlContext)>"});
    private final Set<LocalVarNode> mLocalVarNodes = new HashSet<LocalVarNode>();

    public SimplifiedEvaluator(PTA pta) {
        this.pta = pta;
        this.exporter = new Exporter(pta);
    }

    @Override
    public void begin() {
        this.stopwatch = Stopwatch.newAndStart("PTA evaluator");
    }

    @Override
    public void end() {
        this.stopwatch.stop();
        this.exporter.collectMetric("Time (sec):", String.valueOf((double)this.stopwatch.elapsed()));
        this.exporter.collectMetric("#Reachable Method (CI):", String.valueOf(this.pta.getNakedReachableMethods().size() - 1));
        OnFlyCallGraph ciCallGraph = this.pta.getCallGraph();
        this.exporter.collectMetric("#Call Edge(CI):", String.valueOf(ciCallGraph.size() - FakeMainFactory.implicitCallEdges));
        OnFlyCallGraph callGraph = this.pta.getCallGraph();
        HashSet<Object> reachableMethods = new HashSet<Object>();
        for (ContextMethod momc : this.pta.getCgb().getReachableMethods()) {
            SootMethod sm = momc.method();
            reachableMethods.add(sm);
        }
        int totalPolyCalls = 0;
        int totalCastsMayFail = 0;
        for (SootMethod sootMethod : reachableMethods) {
            for (Stmt st : PTAUtils.getMethodBody(sootMethod).getStmts()) {
                if (st.containsInvokeExpr()) {
                    AbstractInvokeExpr ie = st.getInvokeExpr();
                    if (ie instanceof JStaticInvokeExpr) continue;
                    HashSet<SootMethod> targets = new HashSet<SootMethod>();
                    Iterator<Edge> it = callGraph.edgesOutOf(st);
                    while (it.hasNext()) {
                        targets.add(it.next().tgt());
                    }
                    if (targets.size() <= 1) continue;
                    ++totalPolyCalls;
                    continue;
                }
                if (!(st instanceof JAssignStmt)) continue;
                JAssignStmt assignStmt = (JAssignStmt)st;
                Value rhs = assignStmt.getRightOp();
                LValue lhs = assignStmt.getLeftOp();
                if (!(rhs instanceof JCastExpr) || !(lhs.getType() instanceof ReferenceType)) continue;
                Type targetType = rhs.getType();
                Immediate v = ((JCastExpr)rhs).getOp();
                if (!(v instanceof Local)) continue;
                boolean fails = false;
                Collection<AllocNode> pts = this.pta.reachingObjects(sootMethod, (Local)v).toCollection();
                for (Node node : pts) {
                    if (fails) break;
                    fails = !PTAUtils.castNeverFails(this.pta.getView(), node.getType(), targetType);
                }
                if (!fails) continue;
                ++totalCastsMayFail;
            }
        }
        AliasStat aliasStat = new AliasStat(this.pta);
        aliasStat.aliasesProcessing();
        this.exporter.collectMetric("#May Fail Cast (Total):", String.valueOf(totalCastsMayFail));
        this.exporter.collectMetric("#Virtual Call Site(Polymorphic):", String.valueOf(totalPolyCalls));
        this.exporter.collectMetric("#globalAlias_incstst:", String.valueOf(aliasStat.getGlobalAliasesIncludingStSt()));
        this.ptsStat();
    }

    private void ptsStat() {
        int ptsCntNoNative = 0;
        int varCntNoNative = 0;
        PAG pag = this.pta.getPag();
        for (Triple<SootMethod, Local, Type> localTriple : pag.getLocalPointers()) {
            try {
                SootMethod method = localTriple.getFirst();
                Local local = localTriple.getSecond();
                Type type = localTriple.getThird();
                LocalVarNode lvn = pag.findLocalVarNode(method, local, type);
                if (local.toString().contains("intermediate/")) continue;
                this.mLocalVarNodes.add(lvn);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (SootMethod sm : this.pta.getNakedReachableMethods()) {
            MethodPAG mpag = pag.getMethodPAG(sm);
            MethodNodeFactory mnf = mpag.nodeFactory();
            if (!sm.isStatic()) {
                this.mLocalVarNodes.add((LocalVarNode)mnf.caseThis());
            }
            for (int i = 0; i < sm.getParameterCount(); ++i) {
                Type mType = sm.getParameterType(i);
                if (!(mType instanceof ReferenceType)) continue;
                this.mLocalVarNodes.add((LocalVarNode)mnf.caseParm(i));
            }
        }
        HashSet<LocalVarNode> tmp = new HashSet<LocalVarNode>();
        for (LocalVarNode lvn : this.mLocalVarNodes) {
            SootMethod sm = lvn.getMethod();
            if (PTAUtils.isFakeMainMethod(sm)) {
                tmp.add(lvn);
                continue;
            }
            Set<Object> callocSites = this.getPointsToNewExpr(this.pta.reachingObjects(lvn));
            if (callocSites.size() > 0) {
                if (this.handledNatives.contains(sm.toString())) continue;
                ptsCntNoNative += callocSites.size();
                ++varCntNoNative;
                continue;
            }
            tmp.add(lvn);
        }
        this.mLocalVarNodes.removeAll(tmp);
        this.exporter.collectMetric("#Avg Points-to Target without Native Var(CI):", String.valueOf((double)ptsCntNoNative / (double)varCntNoNative));
    }

    protected Set<Object> getPointsToNewExpr(PointsToSet pts) {
        HashSet<Object> allocSites = new HashSet<Object>();
        for (AllocNode n : pts.toCollection()) {
            allocSites.add(n.getNewExpr());
        }
        return allocSites;
    }

    public String toString() {
        return this.exporter.report();
    }
}

