/*
 * Decompiled with CFR 0.152.
 */
package qilin.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qilin.CoreConfig;
import qilin.core.PTA;
import qilin.core.PTAScene;
import qilin.core.builder.MethodNodeFactory;
import qilin.core.builder.callgraph.Edge;
import qilin.core.context.Context;
import qilin.core.context.ContextElement;
import qilin.core.context.ContextElements;
import qilin.core.pag.AllocNode;
import qilin.core.pag.ContextAllocNode;
import qilin.core.pag.ContextField;
import qilin.core.pag.ContextVarNode;
import qilin.core.pag.Field;
import qilin.core.pag.FieldRefNode;
import qilin.core.pag.GlobalVarNode;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.MethodPAG;
import qilin.core.pag.Node;
import qilin.core.pag.PAG;
import qilin.core.pag.Parm;
import qilin.core.pag.VarNode;
import qilin.core.sets.PointsToSet;
import qilin.pta.PTAConfig;
import qilin.util.DataFactory;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.LValue;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.common.constant.IntConstant;
import sootup.core.jimple.common.expr.AbstractInstanceInvokeExpr;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.expr.JNewArrayExpr;
import sootup.core.jimple.common.expr.JStaticInvokeExpr;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.Body;
import sootup.core.model.SootClass;
import sootup.core.model.SootMethod;
import sootup.core.model.SourceType;
import sootup.core.signatures.MethodSignature;
import sootup.core.signatures.PackageName;
import sootup.core.types.ArrayType;
import sootup.core.types.ClassType;
import sootup.core.types.NullType;
import sootup.core.types.PrimitiveType;
import sootup.core.types.Type;
import sootup.core.util.printer.JimplePrinter;
import sootup.core.views.View;
import sootup.java.bytecode.inputlocation.JavaClassPathAnalysisInputLocation;
import sootup.java.core.JavaIdentifierFactory;
import sootup.java.core.views.JavaView;

public final class PTAUtils {
    private static final Logger logger = LoggerFactory.getLogger(PTAUtils.class);
    private static final Map<SootMethod, Body> methodToBody = DataFactory.createMap();

    public static ClassType getClassType(String fullyQualifiedClassName) {
        return JavaIdentifierFactory.getInstance().getClassType(fullyQualifiedClassName);
    }

    public static boolean isStaticInitializer(SootMethod method) {
        return method.getName().equals("<clinit>");
    }

    public static boolean isConstructor(SootMethod method) {
        return method.getName().equals("<init>");
    }

    public static Map<LocalVarNode, Set<AllocNode>> calcStaticThisPTS(PTA pta) {
        HashMap<LocalVarNode, Set<AllocNode>> pts = new HashMap<LocalVarNode, Set<AllocNode>>();
        HashSet<SootMethod> workList = new HashSet<SootMethod>();
        PAG pag = pta.getPag();
        for (SootMethod method : pta.getNakedReachableMethods()) {
            if (!PTAUtils.isFakeMainMethod(method) && (!PTAUtils.hasBody(method) || method.isStatic())) continue;
            MethodPAG srcmpag = pag.getMethodPAG(method);
            LocalVarNode thisRef = (LocalVarNode)srcmpag.nodeFactory().caseThis();
            PointsToSet other = pta.reachingObjects(thisRef).toCIPointsToSet();
            for (Stmt s : srcmpag.getInvokeStmts()) {
                AbstractInvokeExpr ie = s.getInvokeExpr();
                if (!(ie instanceof JStaticInvokeExpr)) continue;
                Iterator<Edge> it = pta.getCallGraph().edgesOutOf(s);
                while (it.hasNext()) {
                    Edge e = it.next();
                    SootMethod tgtmtd = e.tgt();
                    MethodPAG tgtmpag = pag.getMethodPAG(tgtmtd);
                    MethodNodeFactory tgtnf = tgtmpag.nodeFactory();
                    LocalVarNode tgtThisRef = (LocalVarNode)tgtnf.caseThis();
                    Set addTo = pts.computeIfAbsent(tgtThisRef, k -> new HashSet());
                    boolean returnValue = false;
                    Iterator<AllocNode> itx = other.iterator();
                    while (itx.hasNext()) {
                        AllocNode node = itx.next();
                        if (!addTo.add(node)) continue;
                        returnValue = true;
                    }
                    if (!returnValue) continue;
                    workList.add(tgtmtd);
                }
            }
        }
        while (!workList.isEmpty()) {
            SootMethod method = (SootMethod)workList.iterator().next();
            workList.remove(method);
            MethodPAG srcmpag = pag.getMethodPAG(method);
            LocalVarNode thisRef = (LocalVarNode)srcmpag.nodeFactory().caseThis();
            Set other = pts.computeIfAbsent(thisRef, k -> new HashSet());
            for (Stmt s : srcmpag.getInvokeStmts()) {
                AbstractInvokeExpr ie = s.getInvokeExpr();
                if (!(ie instanceof JStaticInvokeExpr)) continue;
                Iterator<Edge> it = pta.getCallGraph().edgesOutOf(s);
                while (it.hasNext()) {
                    Edge e = it.next();
                    SootMethod tgtmtd = e.tgt();
                    MethodPAG tgtmpag = pag.getMethodPAG(tgtmtd);
                    MethodNodeFactory tgtnf = tgtmpag.nodeFactory();
                    LocalVarNode tgtThisRef = (LocalVarNode)tgtnf.caseThis();
                    Set addTo = pts.computeIfAbsent(tgtThisRef, k -> new HashSet());
                    if (!addTo.addAll(other)) continue;
                    workList.add(tgtmtd);
                }
            }
        }
        return pts;
    }

    public static Object getIR(Object sparkNode) {
        if (sparkNode instanceof VarNode) {
            return ((VarNode)sparkNode).getVariable();
        }
        if (sparkNode instanceof AllocNode) {
            return ((AllocNode)sparkNode).getNewExpr();
        }
        if (sparkNode instanceof Field) {
            return ((Field)sparkNode).getField();
        }
        return sparkNode;
    }

    public static boolean mustAlias(PTA pta, VarNode v1, VarNode v2) {
        PointsToSet v1pts = pta.reachingObjects(v1).toCIPointsToSet();
        PointsToSet v2pts = pta.reachingObjects(v2).toCIPointsToSet();
        return v1pts.pointsToSetEquals(v2pts);
    }

    public static void printPts(PTA pta, PointsToSet pts) {
        StringBuffer ret = new StringBuffer();
        Iterator<AllocNode> it = pts.iterator();
        while (it.hasNext()) {
            AllocNode n = it.next();
            ret.append("\t").append(n).append("\n");
        }
        System.out.print(ret);
    }

    public static String getNodeLabel(Node node) {
        int num = node.getNumber();
        if (node instanceof LocalVarNode) {
            return "L" + num;
        }
        if (node instanceof ContextVarNode) {
            return "L" + num;
        }
        if (node instanceof GlobalVarNode) {
            return "G" + num;
        }
        if (node instanceof ContextField) {
            return "OF" + num;
        }
        if (node instanceof FieldRefNode) {
            return "VF" + num;
        }
        if (node instanceof AllocNode) {
            return "O" + num;
        }
        throw new RuntimeException("no such node type exists!");
    }

    public static boolean isThrowable(View view, Type type) {
        if (type instanceof ClassType) {
            return PTAUtils.canStoreType(view, type, (Type)PTAUtils.getClassType("java.lang.Throwable"));
        }
        return false;
    }

    public static boolean canStoreType(View view, Type child, Type parent) {
        if (child == parent || child.equals(parent)) {
            return true;
        }
        return view.getTypeHierarchy().isSubtype(parent, child);
    }

    public static boolean castNeverFails(View view, Type src, Type dst) {
        if (dst == null) {
            return true;
        }
        if (dst == src) {
            return true;
        }
        if (src == null) {
            return false;
        }
        if (dst.equals(src)) {
            return true;
        }
        if (src instanceof NullType) {
            return true;
        }
        if (dst instanceof NullType) {
            return false;
        }
        return PTAUtils.canStoreType(view, src, dst);
    }

    public static boolean subtypeOfAbstractStringBuilder(Type t) {
        if (!(t instanceof ClassType)) {
            return false;
        }
        ClassType rt = (ClassType)t;
        String s = rt.toString();
        return s.equals("java.lang.StringBuffer") || s.equals("java.lang.StringBuilder");
    }

    public static Context plusplusOp(AllocNode heap) {
        int s;
        ContextElement[] array;
        if (heap instanceof ContextAllocNode) {
            ContextAllocNode csHeap = (ContextAllocNode)heap;
            ContextElements ctxElems = (ContextElements)csHeap.context();
            int ms = ctxElems.size();
            ContextElement[] oldArray = ctxElems.getElements();
            array = new ContextElement[ms + 1];
            array[0] = csHeap.base();
            System.arraycopy(oldArray, 0, array, 1, ms);
            s = ms + 1;
        } else {
            array = new ContextElement[]{heap};
            s = 1;
        }
        return new ContextElements(array, s);
    }

    public static boolean isFakeMainMethod(SootMethod method) {
        String sig = "<qilin.pta.FakeMain: void main()>";
        return ((MethodSignature)method.getSignature()).toString().equals(sig);
    }

    public static boolean isFakeMainClass(ClassType classType) {
        String sig = "qilin.pta.FakeMain";
        return classType.toString().equals(sig);
    }

    public static boolean isOfPrimitiveBaseType(AllocNode heap) {
        if (heap.getType() instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)heap.getType();
            return arrayType.getBaseType() instanceof PrimitiveType;
        }
        return false;
    }

    public static boolean isPrimitiveArrayType(Type type) {
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            return arrayType.getElementType() instanceof PrimitiveType;
        }
        return false;
    }

    public static void dumpJimple(PTAScene scene, String outputDir) {
        for (SootClass clz : scene.getLibraryClasses()) {
            PTAUtils.writeJimple(outputDir, clz);
        }
        for (SootClass clz : scene.getApplicationClasses()) {
            PTAUtils.writeJimple(outputDir, clz);
        }
    }

    public static void writeJimple(String parentDir, SootClass clz) {
        PackageName pkgName = clz.getType().getPackageName();
        String clzName = clz.getType().getClassName();
        File packageDirectory = new File(parentDir + File.separator + pkgName.getName().replace(".", File.separator));
        try {
            packageDirectory.mkdirs();
            FileOutputStream streamOut = new FileOutputStream(packageDirectory + File.separator + clzName + ".jimple");
            PrintWriter writerOut = new PrintWriter(new OutputStreamWriter(streamOut));
            new JimplePrinter(new JimplePrinter.Option[0]).printTo(clz, writerOut);
            writerOut.flush();
            writerOut.close();
            ((OutputStream)streamOut).close();
        }
        catch (Exception e) {
            logger.error("Error writing jimple to file {}", (Object)clz, (Object)e);
        }
    }

    public static String findMainFromMetaInfo(String appPath) {
        String mainClass = null;
        try {
            JarFile jar = new JarFile(appPath);
            Enumeration<JarEntry> allEntries = jar.entries();
            while (allEntries.hasMoreElements()) {
                JarEntry entry = allEntries.nextElement();
                String name = entry.getName();
                if (!name.endsWith(".MF")) continue;
                String urlstring = "jar:file:" + appPath + "!/" + name;
                URL url = new URL(urlstring);
                Scanner scanner = new Scanner(url.openStream());
                while (scanner.hasNext()) {
                    String string = scanner.next();
                    if (!"Main-Class:".equals(string) || !scanner.hasNext()) continue;
                    mainClass = scanner.next();
                    break;
                }
                if (mainClass == null) {
                    System.out.println("cannot find meta info.");
                }
                scanner.close();
                jar.close();
                break;
            }
        }
        catch (IOException e) {
            System.out.println("cannot find meta info.");
        }
        return mainClass;
    }

    public static Body getMethodBody(SootMethod m) {
        Body body = methodToBody.get(m);
        if (body == null) {
            body = m.isConcrete() ? m.getBody() : Body.builder().setMethodSignature((MethodSignature)m.getSignature()).build();
            methodToBody.putIfAbsent(m, body);
        }
        return body;
    }

    public static void updateMethodBody(SootMethod m, Body body) {
        methodToBody.put(m, body);
    }

    public static boolean hasBody(SootMethod m) {
        return methodToBody.containsKey(m);
    }

    public static boolean isEmptyArray(AllocNode heap) {
        JNewArrayExpr nae;
        Immediate sizeVal;
        Object var = heap.getNewExpr();
        if (var instanceof JNewArrayExpr && (sizeVal = (nae = (JNewArrayExpr)var).getSize()) instanceof IntConstant) {
            IntConstant size = (IntConstant)sizeVal;
            return size.getValue() == 0;
        }
        return false;
    }

    public static LocalVarNode paramToArg(PAG pag, Stmt invokeStmt, MethodPAG srcmpag, VarNode pi) {
        LocalVarNode receiver;
        MethodNodeFactory srcnf = srcmpag.nodeFactory();
        AbstractInvokeExpr ie = invokeStmt.getInvokeExpr();
        Parm mPi = (Parm)pi.getVariable();
        LocalVarNode thisRef = (LocalVarNode)srcnf.caseThis();
        if (ie instanceof AbstractInstanceInvokeExpr) {
            AbstractInstanceInvokeExpr iie = (AbstractInstanceInvokeExpr)ie;
            Local base = iie.getBase();
            receiver = pag.findLocalVarNode(srcmpag.getMethod(), base, base.getType());
        } else {
            receiver = thisRef;
        }
        if (mPi.isThis()) {
            return receiver;
        }
        if (mPi.isReturn()) {
            if (invokeStmt instanceof JAssignStmt) {
                JAssignStmt assignStmt = (JAssignStmt)invokeStmt;
                LValue mR = assignStmt.getLeftOp();
                return (LocalVarNode)pag.findValNode(mR, srcmpag.getMethod());
            }
            return null;
        }
        if (mPi.isThrowRet()) {
            return srcnf.makeInvokeStmtThrowVarNode(invokeStmt, srcmpag.getMethod());
        }
        Immediate arg = ie.getArg(mPi.getIndex());
        if (arg == null) {
            return null;
        }
        return pag.findLocalVarNode(srcmpag.getMethod(), arg, arg.getType());
    }

    public static View createView() {
        ArrayList<String> classPaths = new ArrayList<String>();
        ArrayList<JavaClassPathAnalysisInputLocation> analysisInputLocations = new ArrayList<JavaClassPathAnalysisInputLocation>();
        CoreConfig.ApplicationConfiguration appConfig = PTAConfig.v().getAppConfig();
        classPaths.add(appConfig.APP_PATH);
        analysisInputLocations.add(new JavaClassPathAnalysisInputLocation(appConfig.APP_PATH));
        classPaths.addAll(PTAUtils.getLibJars(appConfig.LIB_PATH));
        for (String clazzPath : PTAUtils.getLibJars(appConfig.LIB_PATH)) {
            analysisInputLocations.add(new JavaClassPathAnalysisInputLocation(clazzPath));
        }
        classPaths.addAll(PTAUtils.getJreJars(appConfig.JRE));
        for (String clazzPath : PTAUtils.getJreJars(appConfig.JRE)) {
            analysisInputLocations.add(new JavaClassPathAnalysisInputLocation(clazzPath, SourceType.Library));
        }
        String classpath = String.join((CharSequence)File.pathSeparator, classPaths);
        logger.info("Soot ClassPath: {}", (Object)classpath);
        return new JavaView(analysisInputLocations);
    }

    private static Collection<String> getLibJars(String LIB_PATH) {
        if (LIB_PATH == null) {
            return Collections.emptySet();
        }
        File libFile = new File(LIB_PATH);
        if (libFile.exists()) {
            if (libFile.isDirectory()) {
                return FileUtils.listFiles((File)libFile, (String[])new String[]{"jar"}, (boolean)true).stream().map(File::toString).collect(Collectors.toList());
            }
            if (libFile.isFile()) {
                if (libFile.getName().endsWith(".jar")) {
                    return Collections.singletonList(LIB_PATH);
                }
                logger.error("Project not configured properly. Application library path {} is not a jar file.", (Object)libFile);
                System.exit(1);
            }
        }
        logger.error("Project not configured properly. Application library path {} is not correct.", (Object)libFile);
        System.exit(1);
        return null;
    }

    private static Collection<String> getJreJars(String JRE) {
        if (JRE == null) {
            return Collections.emptySet();
        }
        String jreLibDir = JRE + File.separator + "lib";
        return FileUtils.listFiles((File)new File(jreLibDir), (String[])new String[]{"jar"}, (boolean)false).stream().map(File::toString).collect(Collectors.toList());
    }
}

