/*
 * Decompiled with CFR 0.152.
 */
package qilin.util.graph;

import java.util.Collection;
import java.util.HashSet;
import java.util.Stack;
import java.util.stream.Collectors;

public interface DirectedGraph<N> {
    public Collection<N> allNodes();

    public Collection<N> predsOf(N var1);

    public Collection<N> succsOf(N var1);

    default public Collection<N> computeReachableNodes(N source) {
        HashSet reachableNodes = new HashSet();
        Stack<Object> stack = new Stack<Object>();
        stack.push(source);
        while (!stack.isEmpty()) {
            Object node = stack.pop();
            if (!reachableNodes.add(node)) continue;
            stack.addAll(this.succsOf(node));
        }
        return reachableNodes;
    }

    default public Collection<N> computeRootNodes() {
        return this.allNodes().stream().filter(node -> this.predsOf(node).size() == 0).collect(Collectors.toSet());
    }

    default public Collection<N> computeTailNodes() {
        return this.allNodes().stream().filter(node -> this.succsOf(node).size() == 0).collect(Collectors.toSet());
    }
}

