// $ANTLR 3.2 Sep 23, 2009 14:05:07 org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g 2014-07-28 14:43:27

  package org.sourceforge.xsparql.rewriter;

  import java.util.logging.Logger;
  import java.util.LinkedList;
  import java.util.UUID;
  import java.net.URL;
  import java.util.Iterator;

  import org.sourceforge.xsparql.rewriter.Pair;
  import org.sourceforge.xsparql.sql.SQLQuery;
  


import org.antlr.runtime.*;
import org.antlr.runtime.tree.*;import java.util.Stack;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;

/**
 *
 * Copyright (C) 2011, NUI Galway.
 * Copyright (C) 2014, NUI Galway, WU Wien, Politecnico di Milano, Vienna University of Technology 
 * All rights reserved.
 *
 * The software in this package is published under the terms of the BSD style license a copy of which has been included
 * with this distribution in the bsb_license.txt file and/or available on NUI Galway Server at
 * http://xsparql.deri.ie/license/bsd_license.txt
 *
 * Created on 09 February 2011 by Reasoning and Querying Unit (URQ), Digital Enterprise Research Institute (DERI) on behalf of
 * NUI Galway.
 * 20 May 2014 by Axel Polleres on behalf of WU Wien, Daniele Dell'Aglio on behalf of Politecnico di Milano,  Stefan 
 * Bischof on behalf of Vienna University of Technology,  Nuno Lopes on behalf of NUI Galway.
 * 
 */
public class XSPARQLRewriter extends TreeParser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "VAR", "ENDELM", "INTEGER", "LCURLY", "RCURLY", "NCNAME", "QSTRING", "DOT", "AT", "ASSIGN", "CARET", "CARETCARET", "COLON", "COMMA", "SLASH", "LBRACKET", "RBRACKET", "LPAR", "RPAR", "SEMICOLON", "STAR", "DOTDOT", "SLASHSLASH", "LESSTHAN", "GREATERTHAN", "PLUS", "MINUS", "UNIONSYMBOL", "QUESTIONMARK", "LESSTHANLESSTHAN", "GREATERTHANEQUALS", "LESSTHANEQUALS", "HAFENEQUALS", "EQUALS", "COLONCOLON", "BLANK_NODE_LABEL", "BNODE_CONSTRUCT", "IRI_CONSTRUCT", "ASK", "DESCRIBE", "SELECT", "PNAME_NS", "PNAME_LN", "CDATASTART", "CDATAELMEND", "RCURLYGREATERTHAN", "LESSTHANLCURLY", "ORSYMBOL", "ANDSYMBOL", "NOT", "WHITESPACE", "IRIREF", "NCNAMEELM", "ENDTAG", "A", "IS", "EQ", "NE", "LT", "GE", "LE", "GT", "FOR", "FROM", "LIMIT", "OFFSET", "LET", "ORDER", "BY", "ATS", "IN", "AS", "DESCENDING", "ASCENDING", "STABLE", "IF", "THEN", "ELSE", "RETURN", "CONSTRUCT", "WHERE", "GREATEST", "LEAST", "COLLATION", "CHILD", "DESCENDANT", "ATTRIBUTE", "SELF", "DESCENDANTORSELF", "FOLLOWINGSIBLING", "FOLLOWING", "PARENT", "ANCESTOR", "PRECEDINGSIBLING", "PRECEDING", "ANCESTORORSELF", "ORDERED", "UNORDERED", "DECLARE", "NAMESPACE", "DEFAULT", "ELEMENT", "FUNCTION", "BASEURI", "PREFIX", "BASE", "AND", "OR", "TO", "DIV", "IDIV", "MOD", "UNION", "INTERSECT", "EXCEPT", "INSTANCE", "TREAT", "CASTABLE", "CAST", "OF", "EMPTYSEQUENCE", "ITEM", "NODE", "DOCUMENTNODE", "TEXT", "COMMENT", "PROCESSINGINSTRUCTION", "SCHEMAATTRIBUTE", "SCHEMAELEMENT", "DOCUMENT", "NAMED", "OPTIONAL", "FILTER", "STR", "LANG", "LANGMATCHES", "DATATYPE", "BOUND", "ISIRI", "ISURI", "ISBLANK", "ISLITERAL", "REGEX", "TRUE", "FALSE", "GRAPH", "GREATERTHANGREATERTHAN", "DISTINCT", "GROUP", "HAVING", "ENDPOINT", "ROW", "DOUBLET", "T_NAMESPACE", "T_XML_ELEMENT", "T_XML_CONTENT", "T_XML_ATTRIBUTE", "T_FLWOR", "T_FUNCTION_DECL", "T_PARAMS", "T_FORLET", "T_WHERE", "T_SPARQL_FOR", "T_SPARQL_WHERE", "T_FOR", "T_LET", "T_CONSTRUCT", "T_ORDER", "T_RETURN", "T_UNION", "T_SQL_FOR", "T_SQL_WHERE", "T_SQL_FROM", "T_VAR", "T_TABLE", "T_BLANK", "T_ANON_BLANK", "T_EMPTY_ANON_BLANK", "T_SUBJECT", "T_VERB", "T_OBJECT", "T_MAIN", "T_PAR", "T_INSTANCEOF", "T_TYPE", "T_CASTAS", "T_CASTABLEAS", "T_TREATAS", "T_VARIABLE_DECL", "T_EXTERNAL_VARIABLE_DECL", "T_OPTION_DECL", "T_FUNCTION_CALL", "T_PARAM", "T_ORDER_BY", "T_STABLE_ORDER_BY", "T_GROUP_BY", "T_HAVING", "BOUNDARYSPACE", "STRIP", "VARIABLE", "IMPORT", "EXTERNAL", "NOPRESERVE", "PRESERVE", "CONSTRUCTION", "MODULE", "INHERIT", "NOINHERIT", "SCHEMA", "EMPTY", "ORDERING", "COPYNAMESPACES", "XQUERY", "VERSION", "ENCODING", "OPTION", "LAX", "CASE", "EVERY", "TYPESWITCH", "SATISFIES", "VALIDATE", "SOME", "STRICT", "ASC", "DESC", "REDUCED", "EXPONENT", "COUNT", "AVG", "MAX", "MIN", "SUM", "SAMPLE", "GROUP_CONCAT", "SEPARATOR", "BIND", "EXISTS", "NOTKW", "SERVICE", "SILENT", "UNDEF", "VALUES", "SUBSTR", "REPLACE", "IRI", "URI", "BNODE", "RAND", "ABS", "CEIL", "FLOOR", "ROUND", "CONCAT", "STRLEN", "UCASE", "LCASE", "ENCODE_FOR_URI", "CONTAINS", "STRSTARTS", "STRENDS", "STRBEFORE", "STRAFTER", "ISNUMERIC", "YEAR", "MONTH", "DAY", "HOURS", "MINUTES", "SECONDS", "TIMEZONE", "TZ", "NOW", "UID", "STRUUID", "MD5", "SHA1", "SHA256", "SHA384", "SHA512", "COALESCE", "STRLANG", "STRDT", "SAME_TERM", "T_SUBSELECT", "T_MODULE_DECL", "T_VERSION", "T_BOUNDARYSPACE_DECL", "T_DEFAULT_DECL", "T_ORDER_DECL", "T_EMPTY_ORDER_DECL", "T_DEFAULT_COLLATION_DECL", "T_BASEURI_DECL", "T_MODULE_IMPORT", "T_SCHEMA_IMPORT", "T_QUERY_BODY", "T_BODY_PART", "XPATH", "T_LITERAL_CONSTRUCT", "T_IRI_CONSTRUCT", "T_EPILOGUE", "DECIMAL", "REWRITEVNODE", "REWRITEVNODE1", "DELETEVNODE", "T_QSTRING", "NOTHING", "T_XML_CONTENTS", "T_ASVAR"
    };
    public static final int MONTH=269;
    public static final int INHERIT=210;
    public static final int RAND=252;
    public static final int CDATAELMEND=48;
    public static final int LEAST=86;
    public static final int T_EPILOGUE=304;
    public static final int T_XML_ELEMENT=158;
    public static final int CARETCARET=15;
    public static final int FOLLOWINGSIBLING=93;
    public static final int MINUS=30;
    public static final int STR=137;
    public static final int FLOOR=255;
    public static final int YEAR=268;
    public static final int T_NAMESPACE=157;
    public static final int T_EMPTY_ORDER_DECL=294;
    public static final int SAME_TERM=287;
    public static final int NOTHING=310;
    public static final int T_INSTANCEOF=187;
    public static final int BIND=240;
    public static final int BASEURI=107;
    public static final int UNIONSYMBOL=31;
    public static final int NODE=126;
    public static final int T_CASTABLEAS=190;
    public static final int STRENDS=264;
    public static final int SUM=236;
    public static final int WHERE=84;
    public static final int STRLEN=258;
    public static final int TYPESWITCH=223;
    public static final int UID=277;
    public static final int AS=75;
    public static final int AT=12;
    public static final int MIN=235;
    public static final int ENCODE_FOR_URI=261;
    public static final int THEN=80;
    public static final int DELETEVNODE=308;
    public static final int T_MODULE_IMPORT=297;
    public static final int A=58;
    public static final int T_PARAMS=163;
    public static final int STRIP=202;
    public static final int IRI=249;
    public static final int T_SQL_FROM=176;
    public static final int T_RETURN=172;
    public static final int COLONCOLON=38;
    public static final int T_VAR=177;
    public static final int GROUP=152;
    public static final int ASC=228;
    public static final int ABS=253;
    public static final int QUESTIONMARK=32;
    public static final int PRECEDINGSIBLING=97;
    public static final int T_OPTION_DECL=194;
    public static final int VARIABLE=203;
    public static final int BY=72;
    public static final int T_SUBJECT=182;
    public static final int ASK=42;
    public static final int OFFSET=69;
    public static final int DOUBLET=156;
    public static final int T_QUERY_BODY=299;
    public static final int BOUNDARYSPACE=201;
    public static final int PNAME_NS=45;
    public static final int T_TABLE=178;
    public static final int SECONDS=273;
    public static final int T_OBJECT=184;
    public static final int T_DEFAULT_DECL=292;
    public static final int DIV=113;
    public static final int T_MAIN=185;
    public static final int STAR=24;
    public static final int TO=112;
    public static final int UNION=116;
    public static final int UNDEF=245;
    public static final int ATS=73;
    public static final int XPATH=301;
    public static final int BNODE=251;
    public static final int REGEX=146;
    public static final int TZ=275;
    public static final int T_ASVAR=312;
    public static final int DESC=229;
    public static final int STRBEFORE=265;
    public static final int OPTIONAL=135;
    public static final int T_BODY_PART=300;
    public static final int T_VERB=183;
    public static final int T_FUNCTION_CALL=195;
    public static final int ORDERED=100;
    public static final int LPAR=21;
    public static final int PARENT=95;
    public static final int DESCENDING=76;
    public static final int BOUND=141;
    public static final int SCHEMAELEMENT=132;
    public static final int COPYNAMESPACES=215;
    public static final int REPLACE=248;
    public static final int DESCENDANT=89;
    public static final int T_CASTAS=189;
    public static final int INTEGER=6;
    public static final int STRICT=227;
    public static final int ATTRIBUTE=90;
    public static final int SLASHSLASH=26;
    public static final int LANGMATCHES=139;
    public static final int FOR=66;
    public static final int T_TREATAS=191;
    public static final int PNAME_LN=46;
    public static final int RCURLYGREATERTHAN=49;
    public static final int T_DEFAULT_COLLATION_DECL=295;
    public static final int EQ=60;
    public static final int CARET=14;
    public static final int NOT=53;
    public static final int AVG=233;
    public static final int DATATYPE=140;
    public static final int NOW=276;
    public static final int HAVING=153;
    public static final int SHA512=283;
    public static final int PRESERVE=207;
    public static final int SCHEMAATTRIBUTE=131;
    public static final int T_SPARQL_FOR=166;
    public static final int RPAR=22;
    public static final int T_CONSTRUCT=170;
    public static final int CONTAINS=262;
    public static final int BASE=109;
    public static final int RETURN=82;
    public static final int SOME=226;
    public static final int SCHEMA=212;
    public static final int T_SQL_WHERE=175;
    public static final int STRDT=286;
    public static final int T_LITERAL_CONSTRUCT=302;
    public static final int T_PAR=186;
    public static final int EOF=-1;
    public static final int T_EXTERNAL_VARIABLE_DECL=193;
    public static final int EMPTY=213;
    public static final int GE=63;
    public static final int QSTRING=10;
    public static final int MOD=115;
    public static final int FILTER=136;
    public static final int T_BLANK=179;
    public static final int EXISTS=241;
    public static final int COLON=16;
    public static final int RBRACKET=20;
    public static final int INTERSECT=117;
    public static final int GT=65;
    public static final int T_PARAM=196;
    public static final int SAMPLE=237;
    public static final int NCNAMEELM=56;
    public static final int T_QSTRING=309;
    public static final int HOURS=271;
    public static final int HAFENEQUALS=36;
    public static final int T_FOR=168;
    public static final int ENDTAG=57;
    public static final int T_EMPTY_ANON_BLANK=181;
    public static final int REWRITEVNODE1=307;
    public static final int VALIDATE=225;
    public static final int FALSE=148;
    public static final int MINUTES=272;
    public static final int T_TYPE=188;
    public static final int ISIRI=142;
    public static final int REDUCED=230;
    public static final int DEFAULT=104;
    public static final int LESSTHANLCURLY=50;
    public static final int NOPRESERVE=206;
    public static final int T_ORDER_DECL=293;
    public static final int SHA1=280;
    public static final int IRIREF=55;
    public static final int VAR=4;
    public static final int T_VERSION=290;
    public static final int TEXT=128;
    public static final int SATISFIES=224;
    public static final int EVERY=222;
    public static final int LESSTHANEQUALS=35;
    public static final int ANCESTORORSELF=99;
    public static final int ISLITERAL=145;
    public static final int SEMICOLON=23;
    public static final int WHITESPACE=54;
    public static final int ELSE=81;
    public static final int DOCUMENT=133;
    public static final int CEIL=254;
    public static final int TIMEZONE=274;
    public static final int IF=79;
    public static final int CAST=122;
    public static final int GRAPH=149;
    public static final int PROCESSINGINSTRUCTION=130;
    public static final int IN=74;
    public static final int T_ORDER_BY=197;
    public static final int T_XML_CONTENTS=311;
    public static final int DISTINCT=151;
    public static final int DOT=11;
    public static final int T_FUNCTION_DECL=162;
    public static final int OPTION=219;
    public static final int INSTANCE=119;
    public static final int IS=59;
    public static final int CHILD=88;
    public static final int FUNCTION=106;
    public static final int NCNAME=9;
    public static final int T_BOUNDARYSPACE_DECL=291;
    public static final int CASE=221;
    public static final int NOTKW=242;
    public static final int ITEM=125;
    public static final int T_IRI_CONSTRUCT=303;
    public static final int LCASE=260;
    public static final int CDATASTART=47;
    public static final int COUNT=232;
    public static final int TREAT=120;
    public static final int COLLATION=87;
    public static final int T_XML_ATTRIBUTE=160;
    public static final int CONSTRUCT=83;
    public static final int ISBLANK=144;
    public static final int MAX=234;
    public static final int LESSTHANLESSTHAN=33;
    public static final int ANCESTOR=96;
    public static final int ASSIGN=13;
    public static final int URI=250;
    public static final int COMMENT=129;
    public static final int ORDER=71;
    public static final int IMPORT=204;
    public static final int T_SPARQL_WHERE=167;
    public static final int VALUES=246;
    public static final int STABLE=78;
    public static final int T_LET=169;
    public static final int RCURLY=8;
    public static final int COMMA=17;
    public static final int STRAFTER=266;
    public static final int LCURLY=7;
    public static final int LBRACKET=19;
    public static final int SELF=91;
    public static final int T_BASEURI_DECL=296;
    public static final int SELECT=44;
    public static final int NAMED=134;
    public static final int PRECEDING=98;
    public static final int ELEMENT=105;
    public static final int ASCENDING=77;
    public static final int GREATEST=85;
    public static final int VERSION=217;
    public static final int LE=64;
    public static final int EXPONENT=231;
    public static final int GROUP_CONCAT=238;
    public static final int DAY=270;
    public static final int T_UNION=173;
    public static final int MD5=279;
    public static final int NAMESPACE=103;
    public static final int GREATERTHANGREATERTHAN=150;
    public static final int LAX=220;
    public static final int T_STABLE_ORDER_BY=198;
    public static final int LT=62;
    public static final int DECIMAL=305;
    public static final int GREATERTHANEQUALS=34;
    public static final int FROM=67;
    public static final int T_WHERE=165;
    public static final int T_SQL_FOR=174;
    public static final int STRSTARTS=263;
    public static final int T_GROUP_BY=199;
    public static final int COALESCE=284;
    public static final int XQUERY=216;
    public static final int ISNUMERIC=267;
    public static final int SERVICE=243;
    public static final int T_HAVING=200;
    public static final int T_VARIABLE_DECL=192;
    public static final int DESCRIBE=43;
    public static final int SUBSTR=247;
    public static final int SILENT=244;
    public static final int REWRITEVNODE=306;
    public static final int T_XML_CONTENT=159;
    public static final int T_ORDER=171;
    public static final int SEPARATOR=239;
    public static final int TRUE=147;
    public static final int IDIV=114;
    public static final int EXCEPT=118;
    public static final int MODULE=209;
    public static final int PREFIX=108;
    public static final int NE=61;
    public static final int AND=110;
    public static final int T_FORLET=164;
    public static final int UNORDERED=101;
    public static final int ROW=155;
    public static final int PLUS=29;
    public static final int ENDELM=5;
    public static final int DESCENDANTORSELF=92;
    public static final int DOCUMENTNODE=127;
    public static final int ROUND=256;
    public static final int CONCAT=257;
    public static final int IRI_CONSTRUCT=41;
    public static final int UCASE=259;
    public static final int ISURI=143;
    public static final int LIMIT=68;
    public static final int LANG=138;
    public static final int FOLLOWING=94;
    public static final int T_SCHEMA_IMPORT=298;
    public static final int ORSYMBOL=51;
    public static final int EXTERNAL=205;
    public static final int NOINHERIT=211;
    public static final int SHA384=282;
    public static final int OF=123;
    public static final int STRLANG=285;
    public static final int CASTABLE=121;
    public static final int T_SUBSELECT=288;
    public static final int ANDSYMBOL=52;
    public static final int EMPTYSEQUENCE=124;
    public static final int BNODE_CONSTRUCT=40;
    public static final int T_ANON_BLANK=180;
    public static final int OR=111;
    public static final int EQUALS=37;
    public static final int SLASH=18;
    public static final int BLANK_NODE_LABEL=39;
    public static final int DOTDOT=25;
    public static final int STRUUID=278;
    public static final int ORDERING=214;
    public static final int T_FLWOR=161;
    public static final int SHA256=281;
    public static final int T_MODULE_DECL=289;
    public static final int DECLARE=102;
    public static final int ENCODING=218;
    public static final int CONSTRUCTION=208;
    public static final int LESSTHAN=27;
    public static final int ENDPOINT=154;
    public static final int LET=70;
    public static final int GREATERTHAN=28;

    // delegates
    // delegators

    protected static class VariableScope_scope {
        Map<String, Types> variables;
        List<String> positions;
        boolean scopedDataset;
        boolean sparqlClause;
    }
    protected Stack VariableScope_stack = new Stack();
    protected static class SubQueryScope_scope {
        boolean isStar;
    }
    protected Stack SubQueryScope_stack = new Stack();


        public XSPARQLRewriter(TreeNodeStream input) {
            this(input, new RecognizerSharedState());
        }
        public XSPARQLRewriter(TreeNodeStream input, RecognizerSharedState state) {
            super(input, state);
             
        }
        
    protected TreeAdaptor adaptor = new CommonTreeAdaptor();

    public void setTreeAdaptor(TreeAdaptor adaptor) {
        this.adaptor = adaptor;
    }
    public TreeAdaptor getTreeAdaptor() {
        return adaptor;
    }

    public String[] getTokenNames() { return XSPARQLRewriter.tokenNames; }
    public String getGrammarFileName() { return "org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g"; }


      private static final Logger logger = Logger.getLogger(XSPARQLRewriter.class.getClass().getName());

      /** Types for variables */
      private enum Types {
       XQUERY, SPARQL, SQL, SQL_ROW, RDF_GRAPH 
     }

      /** Handle namespaces */
      private final Map<String, String> namespaces = new HashMap<String, String>();

      /** global stack for scoped datasets */
      private final Stack<ScopedDataset> scopedDataset = new Stack<ScopedDataset>();

      /** final part of the tree, used for postprocesssing, e.g. delete scopedDatasets */
      private final CommonTree epilogue = (CommonTree) adaptor.nil();
      
      /**
       * use validating XQuery engine
       */
      private boolean validatingXQuery = false;
      
      public void setValidatingXQuery(boolean b) {
        this.validatingXQuery = b;
      }
      
      private boolean warnIfNestedConstruct = false;
      
      public void setWarnIfNestedConstruct(boolean warnIfNestedConstruct) {
        this.warnIfNestedConstruct = warnIfNestedConstruct;
      }
      
      private String sparqlmethod;
      
      public void setSPARQLMethod(String sparqlmethod) {
        this.sparqlmethod = sparqlmethod;
      }
      
      private String endpointURI;
      
      public void setEndpointURI(String endpointURI) {
        this.endpointURI = endpointURI;
      }
      
      /*
       * Create a debug version of the rewritten query
       * The debug version will print all the SPARQL queries on the stdout before sending to the SPARQL engine
       */
      private boolean debugVersion = false;
      
      public void setDebugVersion(boolean debugVersion) {
        this.debugVersion = debugVersion;
      }
      
      
      /**
       * XQuery engine to be used for evaluation/code production.
       */
      private String xqueryEngine = "saxon-he";
    	
      public void setXQueryEngine(String xqueryEngine) {
        this.xqueryEngine = xqueryEngine;
      }
      
      private String basePrefix = null;

      private String getSPARQLBasePrefix() {
        if(basePrefix == null)
          return "";
        return "BASE <" + basePrefix + "> "+System.getProperties().getProperty("line.separator");
      }

      /** Add a namespace prefix and the corresponding IRI */
      private void addNamespace(final String name, final String iri) {
        logger.entering(this.getClass().getCanonicalName(), "addNamespace", new String[]{name, iri});

        namespaces.put(name, iri);
      }

      /** Get a string containing the SPARQL namespace declarations */
      private String getSPARQLNamespaces() {
         final StringBuffer sb = new StringBuffer();
         for(String key : namespaces.keySet()) {
            sb.append("PREFIX ");
            sb.append(key);
            if(!key.equals(":")) {
               sb.append(":");
            }
            sb.append(" <");
            sb.append(namespaces.get(key));
            sb.append("> ");
            sb.append(System.getProperties().getProperty("line.separator"));
         }

         return sb.toString();
      }


      private String getRDFNamespaceDecls() {
         final StringBuffer sb = new StringBuffer();
         for(String key : namespaces.keySet()) {
            sb.append("@prefix ");
            sb.append(key);
            if(!key.equals(":")) {
               sb.append(":");
            }
            sb.append(" <");
            sb.append(namespaces.get(key));
            sb.append("> . ");
            sb.append(System.getProperties().getProperty("line.separator"));
         }

         // if there are any prefixes, put a separator in the output
         if (sb.length() > 0) {
           sb.append(System.getProperties().getProperty("line.separator"));
         }
         
         return sb.toString();
      }

      // Create new temporary variables

      private int auxresultscounter = 0;
      private String getNewAuxResultsVariable() {
        logger.entering(this.getClass().getCanonicalName(), "getNewAuxResultsVariable");
        return "$_aux_results" + auxresultscounter++;
      }

      private int auxresultcounter = 0;
      private String getNewAuxResultVariable() {
        logger.entering(this.getClass().getCanonicalName(), "auxresultcounter");
        return "$_aux_result" + auxresultcounter++;
      }

      private int posvarcnt = 0;
      
      @Deprecated
      private String getNewPosVariableName() {
        logger.entering(this.getClass().getCanonicalName(), "getNewPosVariableName");
        return "$_pos" + posvarcnt++;
      }

      private int rdftermcnt = 0;
      private String getNewTempRdfTermVariable() {
        logger.entering(this.getClass().getCanonicalName(), "getNewTempRdfTermVariable");
        return "$_rdf" + rdftermcnt++;
      }

      // Variable scoping

      private void addVariableToScope(final String name) {
        addVariableToScope(name, Types.XQUERY);
      }

      private void addVariableToScope(final String name, final Types type) {
        logger.info(this.getClass().getCanonicalName() + " addVariableToScope "+ name);

        ((VariableScope_scope)VariableScope_stack.peek()).variables.put(name, type);
      }


      private void addVariablesToScope(final List<?> variables, final Types type) {
        logger.entering(this.getClass().getCanonicalName(), "addVariablesToScope");
        String text;
        for(Object o : variables) {
           final CommonTree tree = (CommonTree) o;
           
           if (type == Types.SQL) {
             int c = tree.getChildCount();
             text = ((CommonTree) tree.getChild(c-1)).getText();
           } else {
             if(tree.getChildCount() > 0 && ((CommonTree) tree.getChild(1)).getType() == T_FUNCTION_CALL)   // function_call
               text = tree.getChild(3).getText();
             else if(tree.getChildCount() > 0 && ((CommonTree) tree).getType() == T_ASVAR)   // function_call
               text = tree.getChild(tree.getChildCount()-2).getText();
             else
               text  = tree.getText();
           }

           addVariableToScope(text, type);
        }
      }

      @Deprecated
      private void addVariablesStringToScope(final List<String> variables, final Types type) {
        logger.entering(this.getClass().getCanonicalName(), "addVariablesStringToScope");

        for(String o : variables) {
           addVariableToScope("$"+o, type);
        }
      }


      private void addPositionVariableToScope(final String name) {
        logger.entering(this.getClass().getCanonicalName(), "addPositionVariableToScope", name);
        ((VariableScope_scope)VariableScope_stack.peek()).positions.add(name);
      }

      private boolean isBound(final String name, Types type) {
        logger.info(this.getClass().getCanonicalName() +" isBoundType "+ name+type);
        
        Types t = containsVar(name, 1);
        if (t != null) {
         return t.equals(type);
        } else {
          return false;
        }
      }
      
      private boolean isBoundEarlier(final String name, Types type) {
        logger.info(this.getClass().getCanonicalName()+ "isBoundEarlierType"+ name+type);

        Types t = containsVar(name, 2);
        if (t != null) {
         return t.equals(type);
        } else {
          return false;
        }
      }

      private boolean isBound(final String name) {
        logger.info(this.getClass().getCanonicalName()+ "isBound"+ name);
        return containsVar(name, 1) != null;
      }
      
      private boolean isBoundEarlier(final String name) {
        logger.info(this.getClass().getCanonicalName()+ "isBoundEarlier"+ name);
        return containsVar(name, 2) != null;
      }



      private Types containsVar(final String name, int pos) {
        logger.entering(this.getClass().getCanonicalName(), "isBound", name);
        for(int s=VariableScope_stack.size()-pos; s >= 0; s--) {
          if(((VariableScope_scope)VariableScope_stack.elementAt(s)).variables.containsKey(name)) {
            logger.exiting(this.getClass().getCanonicalName(), "isBound", "true");

           // Iterator iterator = ((VariableScope_scope)VariableScope_stack.elementAt(s)).variables.keySet().iterator();
           // while (iterator.hasNext()) {
           //    String key = iterator.next().toString();
           //    String value = ((VariableScope_scope)VariableScope_stack.elementAt(s)).variables.get(key).toString();
           //    System.out.println("VariableScope["+ s +"]: "+key + " " + value);
           // }

            return ((VariableScope_scope)VariableScope_stack.elementAt(s)).variables.get(name);
          }
        }
        logger.exiting(this.getClass().getCanonicalName(), "isBound", "false");
        return null;
      }

      private CommonTree getPositionVarList() {
        CommonTree ret = (CommonTree) adaptor.nil();
        
        for(int s=0; s < VariableScope_stack.size(); s++) {
          for(String name : ((VariableScope_scope)VariableScope_stack.elementAt(s)).positions) {
            adaptor.addChild(ret, (CommonTree)adaptor.create(QSTRING, "_"));
            adaptor.addChild(ret, (CommonTree)adaptor.create(VAR, name));
          }
        }
        
        return ret;
      }

      // CONSTANTS
      private static final String xsparqlNamespace = "http://xsparql.deri.org/demo/xquery/xsparql.xquery";


      private static final String xsparqlAbbrev = "_xsparql";
      private static final String javaExternalAbbrev = "_java";
      private String javaExternalURL;
      private static final String serializeFunction = xsparqlAbbrev + ":_serialize";
      private static final String rdfTermFunction = xsparqlAbbrev + ":_rdf_term";
      private static final String bindingTermFunction = xsparqlAbbrev+":_binding_term";

      private static String sparqlFunctionScopedCreate = xsparqlAbbrev+":createScopedDataset";
      private static String sparqlFunctionScopedInner = xsparqlAbbrev+":sparqlScopedDataset";
      private static String sparqlFunctionScopedDelete = xsparqlAbbrev+":deleteScopedDataset";
      private static String sparqlFunctionScopedPop = xsparqlAbbrev+":scopedDatasetPopResults";

      private String sparqlResultsFunctionNode;
      private static String storeGraphFunction;

      private static final String schemaAbbrev = "_sparql_result";
      private static final String schemaNamespace = "http://www.w3.org/2005/sparql-results#";
      private static String schemaURL = "http://xsparql.deri.org/demo/xquery/sparql.xsd";

      private static final String validSubjectFunction = xsparqlAbbrev+":_validSubject";
      private static final String validPredicateFunction = xsparqlAbbrev+":_validPredicate";
      private static final String validObjectFunction = xsparqlAbbrev+":_validObject";

      private static final String sparqlNamespaceAbbrev = "xsparql";
      private static final String sparqlFunctionsNamespace = "http://xsparql.deri.org/demo/xquery/sparql-functions.xquery";
      
      /*
      * set the library to be used
      */
      private String xsparqlLibURL = "http://xsparql.deri.org/demo/xquery/xsparql-types.xquery";
      private String sparqlLibURL  = "http://xsparql.deri.org/demo/xquery/sparql-functions.xquery";


      public void setLibraryVersion() {

        URL local = XSPARQLRewriter.class.getResource("/xquery/xsparql-types.xquery");
        if (local != null) {
          xsparqlLibURL = local.toString();
        }

        local = XSPARQLRewriter.class.getResource("/xquery/sparql-functions.xquery");
        if (local != null) {
          sparqlLibURL = local.toString();
        }

        if (!this.validatingXQuery) {
          local = XSPARQLRewriter.class.getResource("/xquery/xsparql.xquery");
          if (local != null) {
            xsparqlLibURL = local.toString();
          } else {
            xsparqlLibURL = "http://xsparql.deri.org/demo/xquery/xsparql.xquery";
          }
        }

    //    if(Configuration.debugVersion()) {
    //      local = XSPARQLRewriter.class.getResource("/xquery/xsparql-types.debug.xquery");
    //      if (local != null) {
    //        xsparqlLibURL = local.toString();
    //      } else {
    //        xsparqlLibURL = "http://xsparql.deri.org/demo/xquery/xsparql-types.debug.xquery";
    //      }
    //    } 

      }
      

      public CommonTree createSchemaImport() {
        CommonTree ret = (CommonTree) adaptor.nil();
        
        //    ^(T_SCHEMA_IMPORT ^(NAMESPACE NCNAME[schemaAbbrev]) QSTRING[schemaNamespace] ^(AT QSTRING[schemaURL]))
        if (this.validatingXQuery) {
          URL local = XSPARQLRewriter.class.getResource("/xquery/sparql.xsd");
          if (local != null) {
            schemaURL = local.toString();
          }

          CommonTree at = (CommonTree) adaptor.create(AT, "AT");
          adaptor.addChild(at, adaptor.create(QSTRING, schemaURL));

          CommonTree ns = (CommonTree) adaptor.create(NAMESPACE, "NAMESPACE");
          adaptor.addChild(ns, adaptor.create(NCNAME, schemaAbbrev));

          ret = (CommonTree) adaptor.create(T_SCHEMA_IMPORT, "T_SCHEMA_IMPORT");
          adaptor.addChild(ret, ns);
          adaptor.addChild(ret, adaptor.create(QSTRING, schemaNamespace));
          adaptor.addChild(ret, at);
        }

        return ret;
      }       

      private SQLQuery sqlQuery = null;

      /**
       * set the database connection
       */
      public void setDBconnection(SQLQuery q) {
        this.sqlQuery = q;
      }

      private String evaluationFunction = "";
      private String iterationFunction = "";

      private String SQLevaluationFunction = "";
      private String SQLiterationFunction = "";


      /**
       * set the evaluation method for SPARQL queries:
       *     arq = using saxon integrated (no need for an endpoint)
       *     joseki =  using a SPARQL endpoint (default)
       */
      public void setEvaluationMethod() {

        String externalFunctionAbbrev = "";

        // defaults, use joseki
        this.iterationFunction = xsparqlAbbrev+":_sparqlResults";
        this.evaluationFunction = xsparqlAbbrev+":_sparql";

        this.SQLevaluationFunction = xsparqlAbbrev+":_sqlQuery";
        this.SQLiterationFunction = xsparqlAbbrev+":_sqlResults";

        // Qexo engine
        if (this.xqueryEngine.equals("qexo")) {
          this.javaExternalURL = "class:org.deri.xquery.qexo.Sparql";

          if (this.sparqlmethod.equals("arq")) {
            this.evaluationFunction = javaExternalAbbrev+":sparqlResultsIterator";
            this.sparqlResultsFunctionNode = xsparqlAbbrev+":_sparqlResultsFromNode";
            this.iterationFunction = "iterator-items";
            externalFunctionAbbrev = javaExternalAbbrev;
          } 
        } 

        // saxon engine
        if (this.xqueryEngine.equals("saxon-he") || this.xqueryEngine.equals("saxon-ee")) {
          this.javaExternalURL = "java:org.deri.xquery.saxon.Sparql";
          externalFunctionAbbrev = xsparqlAbbrev;

          if (this.sparqlmethod.equals("arq")) {
            this.evaluationFunction = externalFunctionAbbrev+":_sparqlQuery";
            this.sparqlResultsFunctionNode = xsparqlAbbrev+":_sparqlResultsFromNode";
            this.iterationFunction = sparqlResultsFunctionNode; 

          }
        }

        sparqlFunctionScopedCreate = externalFunctionAbbrev+":createScopedDataset";
        sparqlFunctionScopedInner = externalFunctionAbbrev+":sparqlScopedDataset";
        sparqlFunctionScopedDelete = externalFunctionAbbrev+":deleteScopedDataset";
        sparqlFunctionScopedPop = externalFunctionAbbrev+":scopedDatasetPopResults";
        storeGraphFunction = externalFunctionAbbrev+":turtleGraphToURI";
      
      }


      // stores the variable as a joinVariable for the scoped Dataset and creates a
      // tree with with text of the variable as a string
      public CommonTree addJoinVar(int tok, String text) {
        ((sparqlForClause_scope)sparqlForClause_stack.peek()).joinVars += text+",";

        return new CommonTree(new CommonToken(tok, text));
      }       

      public CommonTree endpointURI(String endpoint) {
        CommonTree ret = (CommonTree) adaptor.nil();

        if(endpoint != null) {
          ret = new CommonTree(new CommonToken(QSTRING, endpoint));
        } else if(this.endpointURI != null) {
          ret = new CommonTree(new CommonToken(QSTRING, this.endpointURI));
        }

        return ret;
      }       


      public void changeTreeToScopedDataset() {
        logger.info("Entering changeTreeToScopedDataset");

        logger.info(scopedDataset.peek().toString());
        ScopedDataset sd = scopedDataset.peek();

        CommonTree functionTree = sd.getFunctionTree();
        if(!functionTree.isNil()) {
          Token tk1 = functionTree.getToken();
          tk1.setText(sparqlFunctionScopedCreate);
        }
        
        CommonTree resultsTree = sd.getResultsTree();
        if(!resultsTree.isNil()) {
          Token tk2 = resultsTree.getToken();
          tk2.setText(sparqlResultsFunctionNode);
        }

        String id = sd.getId();
        CommonTree idTree = sd.getIdTree();
        if(!idTree.isNil()) {
          Token tk3 = idTree.getToken();
          tk3.setText(id);
          tk3.setType(QSTRING);
        }
        
        // add the delete call to the epilogue
        if(!functionTree.isNil() && !resultsTree.isNil() && !idTree.isNil()) {
          CommonTree part = (CommonTree) adaptor.create(T_BODY_PART, "T_BODY_PART");
          adaptor.addChild(epilogue, part);

          CommonTree del = (CommonTree) adaptor.create(XPATH, "XPATH");
          adaptor.addChild(part, del);

          CommonTree func = (CommonTree) adaptor.create(T_FUNCTION_CALL, "T_FUNCTION_CALL");
          adaptor.addChild(del, func);

          CommonTree params = (CommonTree) adaptor.create(T_PARAMS, "T_PARAMS");
          CommonTree xpath = (CommonTree) adaptor.create(XPATH, "XPATH");
          adaptor.addChild(xpath, adaptor.create(QSTRING, id));
          adaptor.addChild(params, xpath);
          
          adaptor.addChild(func, adaptor.create(NCNAME, sparqlFunctionScopedDelete));
          adaptor.addChild(func, params);
        }
      }


      // returns the tree with the variable and saves the info that there has been
      // at least one unbound variable
      public CommonTree unboundVar(String var) {
        ((sparqlForClause_scope)sparqlForClause_stack.peek()).containsVars = true;

        return new CommonTree(new CommonToken(VAR, var));
      }       


      // If there is at least an unbound var return a tree with the variables, 
      // otherwise return a tree with the string *
      private CommonTree getVarList(final List<?> variables) {
        logger.info("Entering getVarList");

        CommonTree res = (CommonTree) adaptor.nil();
        
         for(Object o : variables) {
            if(((CommonTree) o).getType() == NOTHING) { continue; }
              CommonTree t = (CommonTree) adaptor.create(new CommonToken(REWRITEVNODE1));
              adaptor.addChild(t, (CommonTree) o);
              adaptor.addChild(res, t);
            }

          if(res.getChildCount() == 0) 
          {
            res = (CommonTree) adaptor.create(new CommonToken(REWRITEVNODE1));
            adaptor.addChild(res, adaptor.create(VAR, "*"));
          } 

        return res;
      } 


      // inserts a function call to the pop function if there was a scopeddataset
      private CommonTree generatePop() {
        logger.info("Entering generatePop");

        CommonTree res = (CommonTree) adaptor.nil();
        
        logger.info("generatePop: "+((VariableScope_scope)VariableScope_stack.peek()).scopedDataset+", "+((VariableScope_scope)VariableScope_stack.peek()).sparqlClause);

        if(((VariableScope_scope)VariableScope_stack.peek()).sparqlClause && ((VariableScope_scope)VariableScope_stack.peek()).scopedDataset) 
          {
            res = (CommonTree) adaptor.create(T_FLWOR, "T_FLWOR");
            CommonTree xpath = (CommonTree) adaptor.create(XPATH, "XPATH");
            CommonTree func = (CommonTree) adaptor.create(T_FUNCTION_CALL, "T_FUNCTION_CALL");
            CommonTree params = (CommonTree) adaptor.create(T_PARAMS, "T_PARAMS");
            adaptor.addChild(params, adaptor.create(QSTRING, scopedDataset.peek().getId()));

            adaptor.addChild(func, adaptor.create(NCNAME, sparqlFunctionScopedPop));
            adaptor.addChild(func, params);

            adaptor.addChild(xpath, (CommonTree) adaptor.create(NCNAME, ","));
            adaptor.addChild(xpath, func);
            adaptor.addChild(res, xpath);
          } 

        return res;
      } 


      private CommonTree getVarNodes(final List<String> variables, String auxVariable) {

        CommonTree res = (CommonTree) adaptor.nil();
        
        for(String o : variables) {
          CommonTree v = (CommonTree) adaptor.create(new CommonToken(T_VAR));
          adaptor.addChild(v, adaptor.create(new CommonToken(QSTRING, o)));
          adaptor.addChild(v, adaptor.create(new CommonToken(VAR, o)));

          CommonTree t = (CommonTree) adaptor.create(new CommonToken(REWRITEVNODE, auxVariable));
          adaptor.addChild(t, v);
          adaptor.addChild(res, t);
        }

        return res;
      } 
      
      private CommonTree getVars(final List<String> variables) {

        CommonTree res = (CommonTree) adaptor.nil();
        
        for(String o : variables) {
          adaptor.addChild(res, adaptor.create(new CommonToken(VAR, "$"+o)));
       }

        return res;
      } 

    // format the select line correctly
    protected String concat(List<String> list, String separator) {
        String res = "";
        String sep = "";
        for (String s : list) {
          res += sep + format(s) + " AS \"\"" + s +"\"\"";
          sep = separator;
        }
         
        return res;
      }


    protected String format(String relation) {
      logger.info("format: "+relation);
      if (relation.matches(".*\\..*")) {
        logger.info("format-true");
        String[] split = relation.split("\\.");
        logger.info("format-true: "+split.length);
        return new String("\"\"" + split[0] +"\"\".\"\"" + split[1] +"\"\"") ;
      } else {
        logger.info("format-false");
        return relation;
      }

    }

      protected int outerQuery = 0;
    //  protected boolean insideOuterQuery = false;


    public static class root_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "root"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:857:1: root : ( versionDecl )? ( libraryModule | mainModule ) ;
    public final XSPARQLRewriter.root_return root() throws RecognitionException {
        XSPARQLRewriter.root_return retval = new XSPARQLRewriter.root_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.versionDecl_return versionDecl1 = null;

        XSPARQLRewriter.libraryModule_return libraryModule2 = null;

        XSPARQLRewriter.mainModule_return mainModule3 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:858:3: ( ( versionDecl )? ( libraryModule | mainModule ) )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:858:5: ( versionDecl )? ( libraryModule | mainModule )
            {
            root_0 = (CommonTree)adaptor.nil();

            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:858:5: ( versionDecl )?
            int alt1=2;
            switch ( input.LA(1) ) {
                case T_VERSION:
                    {
                    alt1=1;
                    }
                    break;
            }

            switch (alt1) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: versionDecl
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_versionDecl_in_root1160);
                    versionDecl1=versionDecl();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, versionDecl1.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }

            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:858:18: ( libraryModule | mainModule )
            int alt2=2;
            switch ( input.LA(1) ) {
            case T_MODULE_DECL:
                {
                alt2=1;
                }
                break;
            case T_MAIN:
                {
                alt2=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 2, 0, input);

                throw nvae;
            }

            switch (alt2) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:858:19: libraryModule
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_libraryModule_in_root1164);
                    libraryModule2=libraryModule();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, libraryModule2.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:858:35: mainModule
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_mainModule_in_root1168);
                    mainModule3=mainModule();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, mainModule3.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }


            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "root"

    public static class versionDecl_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "versionDecl"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:861:1: versionDecl : ^( T_VERSION stringliteral ^( ENCODING ( stringliteral )? ) ) ;
    public final XSPARQLRewriter.versionDecl_return versionDecl() throws RecognitionException {
        XSPARQLRewriter.versionDecl_return retval = new XSPARQLRewriter.versionDecl_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree T_VERSION4=null;
        CommonTree ENCODING6=null;
        XSPARQLRewriter.stringliteral_return stringliteral5 = null;

        XSPARQLRewriter.stringliteral_return stringliteral7 = null;


        CommonTree T_VERSION4_tree=null;
        CommonTree ENCODING6_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:862:3: ( ^( T_VERSION stringliteral ^( ENCODING ( stringliteral )? ) ) )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:862:5: ^( T_VERSION stringliteral ^( ENCODING ( stringliteral )? ) )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            T_VERSION4=(CommonTree)match(input,T_VERSION,FOLLOW_T_VERSION_in_versionDecl1183); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            T_VERSION4_tree = (CommonTree)adaptor.dupNode(T_VERSION4);

            root_1 = (CommonTree)adaptor.becomeRoot(T_VERSION4_tree, root_1);
            }


            match(input, Token.DOWN, null); if (state.failed) return retval;
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_stringliteral_in_versionDecl1185);
            stringliteral5=stringliteral();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_1, stringliteral5.getTree());
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_2 = _last;
            CommonTree _first_2 = null;
            CommonTree root_2 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            ENCODING6=(CommonTree)match(input,ENCODING,FOLLOW_ENCODING_in_versionDecl1188); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            ENCODING6_tree = (CommonTree)adaptor.dupNode(ENCODING6);

            root_2 = (CommonTree)adaptor.becomeRoot(ENCODING6_tree, root_2);
            }


            if ( input.LA(1)==Token.DOWN ) {
                match(input, Token.DOWN, null); if (state.failed) return retval;
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:862:42: ( stringliteral )?
                int alt3=2;
                switch ( input.LA(1) ) {
                    case QSTRING:
                        {
                        alt3=1;
                        }
                        break;
                }

                switch (alt3) {
                    case 1 :
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: stringliteral
                        {
                        _last = (CommonTree)input.LT(1);
                        pushFollow(FOLLOW_stringliteral_in_versionDecl1190);
                        stringliteral7=stringliteral();

                        state._fsp--;
                        if (state.failed) return retval;
                        if ( state.backtracking==0 ) 
                        adaptor.addChild(root_2, stringliteral7.getTree());

                        if ( state.backtracking==0 ) {
                        }
                        }
                        break;

                }


                match(input, Token.UP, null); if (state.failed) return retval;
            }adaptor.addChild(root_1, root_2);_last = _save_last_2;
            }


            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "versionDecl"

    public static class mainModule_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "mainModule"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:865:1: mainModule : ^( T_MAIN prolog queryBody ) ;
    public final XSPARQLRewriter.mainModule_return mainModule() throws RecognitionException {
        VariableScope_stack.push(new VariableScope_scope());

        XSPARQLRewriter.mainModule_return retval = new XSPARQLRewriter.mainModule_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree T_MAIN8=null;
        XSPARQLRewriter.prolog_return prolog9 = null;

        XSPARQLRewriter.queryBody_return queryBody10 = null;


        CommonTree T_MAIN8_tree=null;


          // initialize global scopes
          ((VariableScope_scope)VariableScope_stack.peek()).variables = new HashMap<String,Types>();
          ((VariableScope_scope)VariableScope_stack.peek()).positions = new LinkedList<String>();
          logger.info("Creating new variable scope: mainModule");

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:873:3: ( ^( T_MAIN prolog queryBody ) )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:873:5: ^( T_MAIN prolog queryBody )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            T_MAIN8=(CommonTree)match(input,T_MAIN,FOLLOW_T_MAIN_in_mainModule1218); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            T_MAIN8_tree = (CommonTree)adaptor.dupNode(T_MAIN8);

            root_1 = (CommonTree)adaptor.becomeRoot(T_MAIN8_tree, root_1);
            }


            match(input, Token.DOWN, null); if (state.failed) return retval;
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_prolog_in_mainModule1220);
            prolog9=prolog();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_1, prolog9.getTree());
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_queryBody_in_mainModule1222);
            queryBody10=queryBody();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_1, queryBody10.getTree());

            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
            VariableScope_stack.pop();

        }
        return retval;
    }
    // $ANTLR end "mainModule"

    public static class libraryModule_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "libraryModule"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:876:1: libraryModule : moduleDecl prolog ;
    public final XSPARQLRewriter.libraryModule_return libraryModule() throws RecognitionException {
        XSPARQLRewriter.libraryModule_return retval = new XSPARQLRewriter.libraryModule_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.moduleDecl_return moduleDecl11 = null;

        XSPARQLRewriter.prolog_return prolog12 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:877:3: ( moduleDecl prolog )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:877:6: moduleDecl prolog
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_moduleDecl_in_libraryModule1237);
            moduleDecl11=moduleDecl();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_0, moduleDecl11.getTree());
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_prolog_in_libraryModule1239);
            prolog12=prolog();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_0, prolog12.getTree());

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "libraryModule"

    public static class moduleDecl_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "moduleDecl"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:880:1: moduleDecl : ^( T_MODULE_DECL NCNAME uriliteral ) ;
    public final XSPARQLRewriter.moduleDecl_return moduleDecl() throws RecognitionException {
        XSPARQLRewriter.moduleDecl_return retval = new XSPARQLRewriter.moduleDecl_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree T_MODULE_DECL13=null;
        CommonTree NCNAME14=null;
        XSPARQLRewriter.uriliteral_return uriliteral15 = null;


        CommonTree T_MODULE_DECL13_tree=null;
        CommonTree NCNAME14_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:881:3: ( ^( T_MODULE_DECL NCNAME uriliteral ) )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:881:5: ^( T_MODULE_DECL NCNAME uriliteral )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            T_MODULE_DECL13=(CommonTree)match(input,T_MODULE_DECL,FOLLOW_T_MODULE_DECL_in_moduleDecl1253); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            T_MODULE_DECL13_tree = (CommonTree)adaptor.dupNode(T_MODULE_DECL13);

            root_1 = (CommonTree)adaptor.becomeRoot(T_MODULE_DECL13_tree, root_1);
            }


            match(input, Token.DOWN, null); if (state.failed) return retval;
            _last = (CommonTree)input.LT(1);
            NCNAME14=(CommonTree)match(input,NCNAME,FOLLOW_NCNAME_in_moduleDecl1255); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            NCNAME14_tree = (CommonTree)adaptor.dupNode(NCNAME14);

            adaptor.addChild(root_1, NCNAME14_tree);
            }
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_uriliteral_in_moduleDecl1257);
            uriliteral15=uriliteral();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_1, uriliteral15.getTree());

            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "moduleDecl"

    public static class prolog_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "prolog"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:884:1: prolog : ( baseDecl )? ( prolog1 )* ( prolog2 )* -> ( baseDecl )? COMMENT[\"modules imported by default\"] ^( T_MODULE_IMPORT ^( NAMESPACE NCNAME[xsparqlAbbrev] ) QSTRING[xsparqlNamespace] ^( AT QSTRING[xsparqlLibURL] ) ) ^( T_MODULE_IMPORT ^( NAMESPACE NCNAME[sparqlNamespaceAbbrev] ) QSTRING[sparqlFunctionsNamespace] ^( AT QSTRING[sparqlLibURL] ) ) ( prolog1 )* COMMENT[\"SPARQL prefix namespaces\"] ^( T_VARIABLE_DECL VAR[\"\\$_sparql_prefixes\"] ^( T_TYPE ) QSTRING[getSPARQLBasePrefix()+getSPARQLNamespaces()] ) ( prolog2 )* ;
    public final XSPARQLRewriter.prolog_return prolog() throws RecognitionException {
        XSPARQLRewriter.prolog_return retval = new XSPARQLRewriter.prolog_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.baseDecl_return baseDecl16 = null;

        XSPARQLRewriter.prolog1_return prolog117 = null;

        XSPARQLRewriter.prolog2_return prolog218 = null;


        RewriteRuleSubtreeStream stream_baseDecl=new RewriteRuleSubtreeStream(adaptor,"rule baseDecl");
        RewriteRuleSubtreeStream stream_prolog2=new RewriteRuleSubtreeStream(adaptor,"rule prolog2");
        RewriteRuleSubtreeStream stream_prolog1=new RewriteRuleSubtreeStream(adaptor,"rule prolog1");
        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:885:3: ( ( baseDecl )? ( prolog1 )* ( prolog2 )* -> ( baseDecl )? COMMENT[\"modules imported by default\"] ^( T_MODULE_IMPORT ^( NAMESPACE NCNAME[xsparqlAbbrev] ) QSTRING[xsparqlNamespace] ^( AT QSTRING[xsparqlLibURL] ) ) ^( T_MODULE_IMPORT ^( NAMESPACE NCNAME[sparqlNamespaceAbbrev] ) QSTRING[sparqlFunctionsNamespace] ^( AT QSTRING[sparqlLibURL] ) ) ( prolog1 )* COMMENT[\"SPARQL prefix namespaces\"] ^( T_VARIABLE_DECL VAR[\"\\$_sparql_prefixes\"] ^( T_TYPE ) QSTRING[getSPARQLBasePrefix()+getSPARQLNamespaces()] ) ( prolog2 )* )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:885:5: ( baseDecl )? ( prolog1 )* ( prolog2 )*
            {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:885:5: ( baseDecl )?
            int alt4=2;
            switch ( input.LA(1) ) {
                case T_NAMESPACE:
                    {
                    switch ( input.LA(2) ) {
                        case DOWN:
                            {
                            switch ( input.LA(3) ) {
                                case BASE:
                                    {
                                    alt4=1;
                                    }
                                    break;
                            }

                            }
                            break;
                    }

                    }
                    break;
            }

            switch (alt4) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: baseDecl
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_baseDecl_in_prolog1271);
                    baseDecl16=baseDecl();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_baseDecl.add(baseDecl16.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }

            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:886:5: ( prolog1 )*
            loop5:
            do {
                int alt5=2;
                switch ( input.LA(1) ) {
                case DECLARE:
                case T_NAMESPACE:
                case COPYNAMESPACES:
                case T_BOUNDARYSPACE_DECL:
                case T_DEFAULT_DECL:
                case T_ORDER_DECL:
                case T_EMPTY_ORDER_DECL:
                case T_DEFAULT_COLLATION_DECL:
                case T_BASEURI_DECL:
                case T_MODULE_IMPORT:
                case T_SCHEMA_IMPORT:
                    {
                    alt5=1;
                    }
                    break;

                }

                switch (alt5) {
            	case 1 :
            	    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: prolog1
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_prolog1_in_prolog1278);
            	    prolog117=prolog1();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) stream_prolog1.add(prolog117.getTree());

            	    if ( state.backtracking==0 ) {
            	    }
            	    }
            	    break;

            	default :
            	    break loop5;
                }
            } while (true);

            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:887:5: ( prolog2 )*
            loop6:
            do {
                int alt6=2;
                switch ( input.LA(1) ) {
                case T_FUNCTION_DECL:
                case T_VARIABLE_DECL:
                case T_EXTERNAL_VARIABLE_DECL:
                case T_OPTION_DECL:
                    {
                    alt6=1;
                    }
                    break;

                }

                switch (alt6) {
            	case 1 :
            	    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: prolog2
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_prolog2_in_prolog1285);
            	    prolog218=prolog2();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) stream_prolog2.add(prolog218.getTree());

            	    if ( state.backtracking==0 ) {
            	    }
            	    }
            	    break;

            	default :
            	    break loop6;
                }
            } while (true);



            // AST REWRITE
            // elements: baseDecl, prolog2, prolog1
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 888:3: -> ( baseDecl )? COMMENT[\"modules imported by default\"] ^( T_MODULE_IMPORT ^( NAMESPACE NCNAME[xsparqlAbbrev] ) QSTRING[xsparqlNamespace] ^( AT QSTRING[xsparqlLibURL] ) ) ^( T_MODULE_IMPORT ^( NAMESPACE NCNAME[sparqlNamespaceAbbrev] ) QSTRING[sparqlFunctionsNamespace] ^( AT QSTRING[sparqlLibURL] ) ) ( prolog1 )* COMMENT[\"SPARQL prefix namespaces\"] ^( T_VARIABLE_DECL VAR[\"\\$_sparql_prefixes\"] ^( T_TYPE ) QSTRING[getSPARQLBasePrefix()+getSPARQLNamespaces()] ) ( prolog2 )*
            {
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:889:5: ( baseDecl )?
                if ( stream_baseDecl.hasNext() ) {
                    adaptor.addChild(root_0, stream_baseDecl.nextTree());

                }
                stream_baseDecl.reset();
                adaptor.addChild(root_0, (CommonTree)adaptor.create(COMMENT, "modules imported by default"));
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:891:5: ^( T_MODULE_IMPORT ^( NAMESPACE NCNAME[xsparqlAbbrev] ) QSTRING[xsparqlNamespace] ^( AT QSTRING[xsparqlLibURL] ) )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_MODULE_IMPORT, "T_MODULE_IMPORT"), root_1);

                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:891:23: ^( NAMESPACE NCNAME[xsparqlAbbrev] )
                {
                CommonTree root_2 = (CommonTree)adaptor.nil();
                root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(NAMESPACE, "NAMESPACE"), root_2);

                adaptor.addChild(root_2, (CommonTree)adaptor.create(NCNAME, xsparqlAbbrev));

                adaptor.addChild(root_1, root_2);
                }
                adaptor.addChild(root_1, (CommonTree)adaptor.create(QSTRING, xsparqlNamespace));
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:891:84: ^( AT QSTRING[xsparqlLibURL] )
                {
                CommonTree root_2 = (CommonTree)adaptor.nil();
                root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(AT, "AT"), root_2);

                adaptor.addChild(root_2, (CommonTree)adaptor.create(QSTRING, xsparqlLibURL));

                adaptor.addChild(root_1, root_2);
                }

                adaptor.addChild(root_0, root_1);
                }
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:892:5: ^( T_MODULE_IMPORT ^( NAMESPACE NCNAME[sparqlNamespaceAbbrev] ) QSTRING[sparqlFunctionsNamespace] ^( AT QSTRING[sparqlLibURL] ) )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_MODULE_IMPORT, "T_MODULE_IMPORT"), root_1);

                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:892:23: ^( NAMESPACE NCNAME[sparqlNamespaceAbbrev] )
                {
                CommonTree root_2 = (CommonTree)adaptor.nil();
                root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(NAMESPACE, "NAMESPACE"), root_2);

                adaptor.addChild(root_2, (CommonTree)adaptor.create(NCNAME, sparqlNamespaceAbbrev));

                adaptor.addChild(root_1, root_2);
                }
                adaptor.addChild(root_1, (CommonTree)adaptor.create(QSTRING, sparqlFunctionsNamespace));
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:892:100: ^( AT QSTRING[sparqlLibURL] )
                {
                CommonTree root_2 = (CommonTree)adaptor.nil();
                root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(AT, "AT"), root_2);

                adaptor.addChild(root_2, (CommonTree)adaptor.create(QSTRING, sparqlLibURL));

                adaptor.addChild(root_1, root_2);
                }

                adaptor.addChild(root_0, root_1);
                }
                adaptor.addChild(root_0,  createSchemaImport() );
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:894:5: ( prolog1 )*
                while ( stream_prolog1.hasNext() ) {
                    adaptor.addChild(root_0, stream_prolog1.nextTree());

                }
                stream_prolog1.reset();
                adaptor.addChild(root_0, (CommonTree)adaptor.create(COMMENT, "SPARQL prefix namespaces"));
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:897:7: ^( T_VARIABLE_DECL VAR[\"\\$_sparql_prefixes\"] ^( T_TYPE ) QSTRING[getSPARQLBasePrefix()+getSPARQLNamespaces()] )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_VARIABLE_DECL, "T_VARIABLE_DECL"), root_1);

                adaptor.addChild(root_1, (CommonTree)adaptor.create(VAR, "$_sparql_prefixes"));
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:897:51: ^( T_TYPE )
                {
                CommonTree root_2 = (CommonTree)adaptor.nil();
                root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_TYPE, "T_TYPE"), root_2);

                adaptor.addChild(root_1, root_2);
                }
                adaptor.addChild(root_1, (CommonTree)adaptor.create(QSTRING, getSPARQLBasePrefix()+getSPARQLNamespaces()));

                adaptor.addChild(root_0, root_1);
                }
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:899:5: ( prolog2 )*
                while ( stream_prolog2.hasNext() ) {
                    adaptor.addChild(root_0, stream_prolog2.nextTree());

                }
                stream_prolog2.reset();

            }

            retval.tree = root_0;}
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "prolog"

    public static class prolog1_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "prolog1"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:902:1: prolog1 : ( defaultNamespaceDecl | namespaceDecl | setter | importa | prefixDecl );
    public final XSPARQLRewriter.prolog1_return prolog1() throws RecognitionException {
        XSPARQLRewriter.prolog1_return retval = new XSPARQLRewriter.prolog1_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.defaultNamespaceDecl_return defaultNamespaceDecl19 = null;

        XSPARQLRewriter.namespaceDecl_return namespaceDecl20 = null;

        XSPARQLRewriter.setter_return setter21 = null;

        XSPARQLRewriter.importa_return importa22 = null;

        XSPARQLRewriter.prefixDecl_return prefixDecl23 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:903:3: ( defaultNamespaceDecl | namespaceDecl | setter | importa | prefixDecl )
            int alt7=5;
            switch ( input.LA(1) ) {
            case T_DEFAULT_DECL:
                {
                alt7=1;
                }
                break;
            case T_NAMESPACE:
                {
                switch ( input.LA(2) ) {
                case DOWN:
                    {
                    switch ( input.LA(3) ) {
                    case NCNAME:
                        {
                        alt7=2;
                        }
                        break;
                    case PNAME_NS:
                    case DEFAULT:
                        {
                        alt7=5;
                        }
                        break;
                    default:
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 7, 5, input);

                        throw nvae;
                    }

                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 7, 2, input);

                    throw nvae;
                }

                }
                break;
            case DECLARE:
            case COPYNAMESPACES:
            case T_BOUNDARYSPACE_DECL:
            case T_ORDER_DECL:
            case T_EMPTY_ORDER_DECL:
            case T_DEFAULT_COLLATION_DECL:
            case T_BASEURI_DECL:
                {
                alt7=3;
                }
                break;
            case T_MODULE_IMPORT:
            case T_SCHEMA_IMPORT:
                {
                alt7=4;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 7, 0, input);

                throw nvae;
            }

            switch (alt7) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:903:5: defaultNamespaceDecl
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_defaultNamespaceDecl_in_prolog11422);
                    defaultNamespaceDecl19=defaultNamespaceDecl();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, defaultNamespaceDecl19.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:904:5: namespaceDecl
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_namespaceDecl_in_prolog11428);
                    namespaceDecl20=namespaceDecl();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, namespaceDecl20.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 3 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:905:5: setter
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_setter_in_prolog11434);
                    setter21=setter();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, setter21.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 4 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:906:5: importa
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_importa_in_prolog11440);
                    importa22=importa();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, importa22.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 5 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:907:5: prefixDecl
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_prefixDecl_in_prolog11446);
                    prefixDecl23=prefixDecl();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, prefixDecl23.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "prolog1"

    public static class prolog2_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "prolog2"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:910:1: prolog2 : ( varDecl | functionDecl | optionDecl );
    public final XSPARQLRewriter.prolog2_return prolog2() throws RecognitionException {
        XSPARQLRewriter.prolog2_return retval = new XSPARQLRewriter.prolog2_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.varDecl_return varDecl24 = null;

        XSPARQLRewriter.functionDecl_return functionDecl25 = null;

        XSPARQLRewriter.optionDecl_return optionDecl26 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:911:3: ( varDecl | functionDecl | optionDecl )
            int alt8=3;
            switch ( input.LA(1) ) {
            case T_VARIABLE_DECL:
            case T_EXTERNAL_VARIABLE_DECL:
                {
                alt8=1;
                }
                break;
            case T_FUNCTION_DECL:
                {
                alt8=2;
                }
                break;
            case T_OPTION_DECL:
                {
                alt8=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 8, 0, input);

                throw nvae;
            }

            switch (alt8) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:911:5: varDecl
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_varDecl_in_prolog21459);
                    varDecl24=varDecl();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, varDecl24.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:912:5: functionDecl
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_functionDecl_in_prolog21465);
                    functionDecl25=functionDecl();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, functionDecl25.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 3 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:913:5: optionDecl
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_optionDecl_in_prolog21471);
                    optionDecl26=optionDecl();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, optionDecl26.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "prolog2"

    public static class setter_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "setter"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:916:1: setter : ( boundarySpaceDecl | defaultCollationDecl | baseURIDecl | constructionDecl | orderingModeDecl | emptyOrderDecl | copyNamespacesDecl );
    public final XSPARQLRewriter.setter_return setter() throws RecognitionException {
        XSPARQLRewriter.setter_return retval = new XSPARQLRewriter.setter_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.boundarySpaceDecl_return boundarySpaceDecl27 = null;

        XSPARQLRewriter.defaultCollationDecl_return defaultCollationDecl28 = null;

        XSPARQLRewriter.baseURIDecl_return baseURIDecl29 = null;

        XSPARQLRewriter.constructionDecl_return constructionDecl30 = null;

        XSPARQLRewriter.orderingModeDecl_return orderingModeDecl31 = null;

        XSPARQLRewriter.emptyOrderDecl_return emptyOrderDecl32 = null;

        XSPARQLRewriter.copyNamespacesDecl_return copyNamespacesDecl33 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:917:3: ( boundarySpaceDecl | defaultCollationDecl | baseURIDecl | constructionDecl | orderingModeDecl | emptyOrderDecl | copyNamespacesDecl )
            int alt9=7;
            switch ( input.LA(1) ) {
            case T_BOUNDARYSPACE_DECL:
                {
                alt9=1;
                }
                break;
            case T_DEFAULT_COLLATION_DECL:
                {
                alt9=2;
                }
                break;
            case T_BASEURI_DECL:
                {
                alt9=3;
                }
                break;
            case DECLARE:
                {
                alt9=4;
                }
                break;
            case T_ORDER_DECL:
                {
                alt9=5;
                }
                break;
            case T_EMPTY_ORDER_DECL:
                {
                alt9=6;
                }
                break;
            case COPYNAMESPACES:
                {
                alt9=7;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 9, 0, input);

                throw nvae;
            }

            switch (alt9) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:917:5: boundarySpaceDecl
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_boundarySpaceDecl_in_setter1484);
                    boundarySpaceDecl27=boundarySpaceDecl();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, boundarySpaceDecl27.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:918:5: defaultCollationDecl
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_defaultCollationDecl_in_setter1490);
                    defaultCollationDecl28=defaultCollationDecl();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, defaultCollationDecl28.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 3 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:919:5: baseURIDecl
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_baseURIDecl_in_setter1496);
                    baseURIDecl29=baseURIDecl();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, baseURIDecl29.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 4 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:920:5: constructionDecl
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_constructionDecl_in_setter1502);
                    constructionDecl30=constructionDecl();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, constructionDecl30.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 5 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:921:5: orderingModeDecl
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_orderingModeDecl_in_setter1508);
                    orderingModeDecl31=orderingModeDecl();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, orderingModeDecl31.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 6 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:922:5: emptyOrderDecl
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_emptyOrderDecl_in_setter1514);
                    emptyOrderDecl32=emptyOrderDecl();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, emptyOrderDecl32.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 7 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:923:5: copyNamespacesDecl
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_copyNamespacesDecl_in_setter1520);
                    copyNamespacesDecl33=copyNamespacesDecl();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, copyNamespacesDecl33.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "setter"

    public static class importa_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "importa"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:926:1: importa : ( schemaImport | moduleImport );
    public final XSPARQLRewriter.importa_return importa() throws RecognitionException {
        XSPARQLRewriter.importa_return retval = new XSPARQLRewriter.importa_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.schemaImport_return schemaImport34 = null;

        XSPARQLRewriter.moduleImport_return moduleImport35 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:927:3: ( schemaImport | moduleImport )
            int alt10=2;
            switch ( input.LA(1) ) {
            case T_SCHEMA_IMPORT:
                {
                alt10=1;
                }
                break;
            case T_MODULE_IMPORT:
                {
                alt10=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 10, 0, input);

                throw nvae;
            }

            switch (alt10) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:927:5: schemaImport
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_schemaImport_in_importa1533);
                    schemaImport34=schemaImport();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, schemaImport34.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:927:20: moduleImport
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_moduleImport_in_importa1537);
                    moduleImport35=moduleImport();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, moduleImport35.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "importa"

    public static class namespaceDecl_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "namespaceDecl"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:930:1: namespaceDecl : ^( T_NAMESPACE name= NCNAME irix= QSTRING ) ;
    public final XSPARQLRewriter.namespaceDecl_return namespaceDecl() throws RecognitionException {
        XSPARQLRewriter.namespaceDecl_return retval = new XSPARQLRewriter.namespaceDecl_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree name=null;
        CommonTree irix=null;
        CommonTree T_NAMESPACE36=null;

        CommonTree name_tree=null;
        CommonTree irix_tree=null;
        CommonTree T_NAMESPACE36_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:931:3: ( ^( T_NAMESPACE name= NCNAME irix= QSTRING ) )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:931:5: ^( T_NAMESPACE name= NCNAME irix= QSTRING )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            T_NAMESPACE36=(CommonTree)match(input,T_NAMESPACE,FOLLOW_T_NAMESPACE_in_namespaceDecl1551); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            T_NAMESPACE36_tree = (CommonTree)adaptor.dupNode(T_NAMESPACE36);

            root_1 = (CommonTree)adaptor.becomeRoot(T_NAMESPACE36_tree, root_1);
            }


            match(input, Token.DOWN, null); if (state.failed) return retval;
            _last = (CommonTree)input.LT(1);
            name=(CommonTree)match(input,NCNAME,FOLLOW_NCNAME_in_namespaceDecl1555); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            name_tree = (CommonTree)adaptor.dupNode(name);

            adaptor.addChild(root_1, name_tree);
            }
            _last = (CommonTree)input.LT(1);
            irix=(CommonTree)match(input,QSTRING,FOLLOW_QSTRING_in_namespaceDecl1559); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            irix_tree = (CommonTree)adaptor.dupNode(irix);

            adaptor.addChild(root_1, irix_tree);
            }

            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }

            if ( state.backtracking==0 ) {
              addNamespace((name!=null?name.getText():null), (irix!=null?irix.getText():null));
            }

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "namespaceDecl"

    public static class boundarySpaceDecl_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "boundarySpaceDecl"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:934:1: boundarySpaceDecl : ^( T_BOUNDARYSPACE_DECL ( PRESERVE | STRIP ) ) ;
    public final XSPARQLRewriter.boundarySpaceDecl_return boundarySpaceDecl() throws RecognitionException {
        XSPARQLRewriter.boundarySpaceDecl_return retval = new XSPARQLRewriter.boundarySpaceDecl_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree T_BOUNDARYSPACE_DECL37=null;
        CommonTree set38=null;

        CommonTree T_BOUNDARYSPACE_DECL37_tree=null;
        CommonTree set38_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:935:3: ( ^( T_BOUNDARYSPACE_DECL ( PRESERVE | STRIP ) ) )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:935:5: ^( T_BOUNDARYSPACE_DECL ( PRESERVE | STRIP ) )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            T_BOUNDARYSPACE_DECL37=(CommonTree)match(input,T_BOUNDARYSPACE_DECL,FOLLOW_T_BOUNDARYSPACE_DECL_in_boundarySpaceDecl1576); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            T_BOUNDARYSPACE_DECL37_tree = (CommonTree)adaptor.dupNode(T_BOUNDARYSPACE_DECL37);

            root_1 = (CommonTree)adaptor.becomeRoot(T_BOUNDARYSPACE_DECL37_tree, root_1);
            }


            match(input, Token.DOWN, null); if (state.failed) return retval;
            _last = (CommonTree)input.LT(1);
            set38=(CommonTree)input.LT(1);
            if ( input.LA(1)==STRIP||input.LA(1)==PRESERVE ) {
                input.consume();

                if ( state.backtracking==0 ) {
                set38_tree = (CommonTree)adaptor.dupNode(set38);

                adaptor.addChild(root_1, set38_tree);
                }
                state.errorRecovery=false;state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "boundarySpaceDecl"

    public static class defaultNamespaceDecl_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "defaultNamespaceDecl"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:938:1: defaultNamespaceDecl : ^( T_DEFAULT_DECL ( ELEMENT | FUNCTION ) NAMESPACE irix= QSTRING ) ;
    public final XSPARQLRewriter.defaultNamespaceDecl_return defaultNamespaceDecl() throws RecognitionException {
        XSPARQLRewriter.defaultNamespaceDecl_return retval = new XSPARQLRewriter.defaultNamespaceDecl_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree irix=null;
        CommonTree T_DEFAULT_DECL39=null;
        CommonTree set40=null;
        CommonTree NAMESPACE41=null;

        CommonTree irix_tree=null;
        CommonTree T_DEFAULT_DECL39_tree=null;
        CommonTree set40_tree=null;
        CommonTree NAMESPACE41_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:939:3: ( ^( T_DEFAULT_DECL ( ELEMENT | FUNCTION ) NAMESPACE irix= QSTRING ) )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:939:5: ^( T_DEFAULT_DECL ( ELEMENT | FUNCTION ) NAMESPACE irix= QSTRING )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            T_DEFAULT_DECL39=(CommonTree)match(input,T_DEFAULT_DECL,FOLLOW_T_DEFAULT_DECL_in_defaultNamespaceDecl1597); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            T_DEFAULT_DECL39_tree = (CommonTree)adaptor.dupNode(T_DEFAULT_DECL39);

            root_1 = (CommonTree)adaptor.becomeRoot(T_DEFAULT_DECL39_tree, root_1);
            }


            match(input, Token.DOWN, null); if (state.failed) return retval;
            _last = (CommonTree)input.LT(1);
            set40=(CommonTree)input.LT(1);
            if ( (input.LA(1)>=ELEMENT && input.LA(1)<=FUNCTION) ) {
                input.consume();

                if ( state.backtracking==0 ) {
                set40_tree = (CommonTree)adaptor.dupNode(set40);

                adaptor.addChild(root_1, set40_tree);
                }
                state.errorRecovery=false;state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

            _last = (CommonTree)input.LT(1);
            NAMESPACE41=(CommonTree)match(input,NAMESPACE,FOLLOW_NAMESPACE_in_defaultNamespaceDecl1605); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            NAMESPACE41_tree = (CommonTree)adaptor.dupNode(NAMESPACE41);

            adaptor.addChild(root_1, NAMESPACE41_tree);
            }
            _last = (CommonTree)input.LT(1);
            irix=(CommonTree)match(input,QSTRING,FOLLOW_QSTRING_in_defaultNamespaceDecl1609); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            irix_tree = (CommonTree)adaptor.dupNode(irix);

            adaptor.addChild(root_1, irix_tree);
            }

            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }

            if ( state.backtracking==0 ) {
              addNamespace(":", (irix!=null?irix.getText():null));
            }

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "defaultNamespaceDecl"

    public static class optionDecl_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "optionDecl"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:942:1: optionDecl : ^( T_OPTION_DECL qname stringliteral ) ;
    public final XSPARQLRewriter.optionDecl_return optionDecl() throws RecognitionException {
        XSPARQLRewriter.optionDecl_return retval = new XSPARQLRewriter.optionDecl_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree T_OPTION_DECL42=null;
        XSPARQLRewriter.qname_return qname43 = null;

        XSPARQLRewriter.stringliteral_return stringliteral44 = null;


        CommonTree T_OPTION_DECL42_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:943:3: ( ^( T_OPTION_DECL qname stringliteral ) )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:943:5: ^( T_OPTION_DECL qname stringliteral )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            T_OPTION_DECL42=(CommonTree)match(input,T_OPTION_DECL,FOLLOW_T_OPTION_DECL_in_optionDecl1626); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            T_OPTION_DECL42_tree = (CommonTree)adaptor.dupNode(T_OPTION_DECL42);

            root_1 = (CommonTree)adaptor.becomeRoot(T_OPTION_DECL42_tree, root_1);
            }


            match(input, Token.DOWN, null); if (state.failed) return retval;
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_qname_in_optionDecl1628);
            qname43=qname();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_1, qname43.getTree());
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_stringliteral_in_optionDecl1630);
            stringliteral44=stringliteral();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_1, stringliteral44.getTree());

            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "optionDecl"

    public static class orderingModeDecl_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "orderingModeDecl"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:946:1: orderingModeDecl : ^( T_ORDER_DECL ( ORDERED | UNORDERED ) ) ;
    public final XSPARQLRewriter.orderingModeDecl_return orderingModeDecl() throws RecognitionException {
        XSPARQLRewriter.orderingModeDecl_return retval = new XSPARQLRewriter.orderingModeDecl_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree T_ORDER_DECL45=null;
        CommonTree set46=null;

        CommonTree T_ORDER_DECL45_tree=null;
        CommonTree set46_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:947:3: ( ^( T_ORDER_DECL ( ORDERED | UNORDERED ) ) )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:947:5: ^( T_ORDER_DECL ( ORDERED | UNORDERED ) )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            T_ORDER_DECL45=(CommonTree)match(input,T_ORDER_DECL,FOLLOW_T_ORDER_DECL_in_orderingModeDecl1645); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            T_ORDER_DECL45_tree = (CommonTree)adaptor.dupNode(T_ORDER_DECL45);

            root_1 = (CommonTree)adaptor.becomeRoot(T_ORDER_DECL45_tree, root_1);
            }


            match(input, Token.DOWN, null); if (state.failed) return retval;
            _last = (CommonTree)input.LT(1);
            set46=(CommonTree)input.LT(1);
            if ( (input.LA(1)>=ORDERED && input.LA(1)<=UNORDERED) ) {
                input.consume();

                if ( state.backtracking==0 ) {
                set46_tree = (CommonTree)adaptor.dupNode(set46);

                adaptor.addChild(root_1, set46_tree);
                }
                state.errorRecovery=false;state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "orderingModeDecl"

    public static class emptyOrderDecl_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "emptyOrderDecl"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:950:1: emptyOrderDecl : ^( T_EMPTY_ORDER_DECL ( GREATEST | LEAST ) ) ;
    public final XSPARQLRewriter.emptyOrderDecl_return emptyOrderDecl() throws RecognitionException {
        XSPARQLRewriter.emptyOrderDecl_return retval = new XSPARQLRewriter.emptyOrderDecl_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree T_EMPTY_ORDER_DECL47=null;
        CommonTree set48=null;

        CommonTree T_EMPTY_ORDER_DECL47_tree=null;
        CommonTree set48_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:951:3: ( ^( T_EMPTY_ORDER_DECL ( GREATEST | LEAST ) ) )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:951:5: ^( T_EMPTY_ORDER_DECL ( GREATEST | LEAST ) )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            T_EMPTY_ORDER_DECL47=(CommonTree)match(input,T_EMPTY_ORDER_DECL,FOLLOW_T_EMPTY_ORDER_DECL_in_emptyOrderDecl1666); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            T_EMPTY_ORDER_DECL47_tree = (CommonTree)adaptor.dupNode(T_EMPTY_ORDER_DECL47);

            root_1 = (CommonTree)adaptor.becomeRoot(T_EMPTY_ORDER_DECL47_tree, root_1);
            }


            match(input, Token.DOWN, null); if (state.failed) return retval;
            _last = (CommonTree)input.LT(1);
            set48=(CommonTree)input.LT(1);
            if ( (input.LA(1)>=GREATEST && input.LA(1)<=LEAST) ) {
                input.consume();

                if ( state.backtracking==0 ) {
                set48_tree = (CommonTree)adaptor.dupNode(set48);

                adaptor.addChild(root_1, set48_tree);
                }
                state.errorRecovery=false;state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "emptyOrderDecl"

    public static class copyNamespacesDecl_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "copyNamespacesDecl"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:954:1: copyNamespacesDecl : ^( COPYNAMESPACES preserveMode inheritMode ) ;
    public final XSPARQLRewriter.copyNamespacesDecl_return copyNamespacesDecl() throws RecognitionException {
        XSPARQLRewriter.copyNamespacesDecl_return retval = new XSPARQLRewriter.copyNamespacesDecl_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree COPYNAMESPACES49=null;
        XSPARQLRewriter.preserveMode_return preserveMode50 = null;

        XSPARQLRewriter.inheritMode_return inheritMode51 = null;


        CommonTree COPYNAMESPACES49_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:955:3: ( ^( COPYNAMESPACES preserveMode inheritMode ) )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:955:5: ^( COPYNAMESPACES preserveMode inheritMode )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            COPYNAMESPACES49=(CommonTree)match(input,COPYNAMESPACES,FOLLOW_COPYNAMESPACES_in_copyNamespacesDecl1687); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            COPYNAMESPACES49_tree = (CommonTree)adaptor.dupNode(COPYNAMESPACES49);

            root_1 = (CommonTree)adaptor.becomeRoot(COPYNAMESPACES49_tree, root_1);
            }


            match(input, Token.DOWN, null); if (state.failed) return retval;
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_preserveMode_in_copyNamespacesDecl1689);
            preserveMode50=preserveMode();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_1, preserveMode50.getTree());
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_inheritMode_in_copyNamespacesDecl1691);
            inheritMode51=inheritMode();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_1, inheritMode51.getTree());

            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "copyNamespacesDecl"

    public static class preserveMode_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "preserveMode"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:958:1: preserveMode : ( PRESERVE | NOPRESERVE );
    public final XSPARQLRewriter.preserveMode_return preserveMode() throws RecognitionException {
        XSPARQLRewriter.preserveMode_return retval = new XSPARQLRewriter.preserveMode_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set52=null;

        CommonTree set52_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:959:3: ( PRESERVE | NOPRESERVE )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            set52=(CommonTree)input.LT(1);
            if ( (input.LA(1)>=NOPRESERVE && input.LA(1)<=PRESERVE) ) {
                input.consume();

                if ( state.backtracking==0 ) {
                set52_tree = (CommonTree)adaptor.dupNode(set52);

                adaptor.addChild(root_0, set52_tree);
                }
                state.errorRecovery=false;state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

            if ( state.backtracking==0 ) {
            } 

            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "preserveMode"

    public static class inheritMode_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "inheritMode"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:963:1: inheritMode : ( INHERIT | NOINHERIT );
    public final XSPARQLRewriter.inheritMode_return inheritMode() throws RecognitionException {
        XSPARQLRewriter.inheritMode_return retval = new XSPARQLRewriter.inheritMode_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set53=null;

        CommonTree set53_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:964:3: ( INHERIT | NOINHERIT )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            set53=(CommonTree)input.LT(1);
            if ( (input.LA(1)>=INHERIT && input.LA(1)<=NOINHERIT) ) {
                input.consume();

                if ( state.backtracking==0 ) {
                set53_tree = (CommonTree)adaptor.dupNode(set53);

                adaptor.addChild(root_0, set53_tree);
                }
                state.errorRecovery=false;state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

            if ( state.backtracking==0 ) {
            } 

            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "inheritMode"

    public static class defaultCollationDecl_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "defaultCollationDecl"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:968:1: defaultCollationDecl : ^( T_DEFAULT_COLLATION_DECL uriliteral ) ;
    public final XSPARQLRewriter.defaultCollationDecl_return defaultCollationDecl() throws RecognitionException {
        XSPARQLRewriter.defaultCollationDecl_return retval = new XSPARQLRewriter.defaultCollationDecl_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree T_DEFAULT_COLLATION_DECL54=null;
        XSPARQLRewriter.uriliteral_return uriliteral55 = null;


        CommonTree T_DEFAULT_COLLATION_DECL54_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:969:3: ( ^( T_DEFAULT_COLLATION_DECL uriliteral ) )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:969:5: ^( T_DEFAULT_COLLATION_DECL uriliteral )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            T_DEFAULT_COLLATION_DECL54=(CommonTree)match(input,T_DEFAULT_COLLATION_DECL,FOLLOW_T_DEFAULT_COLLATION_DECL_in_defaultCollationDecl1744); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            T_DEFAULT_COLLATION_DECL54_tree = (CommonTree)adaptor.dupNode(T_DEFAULT_COLLATION_DECL54);

            root_1 = (CommonTree)adaptor.becomeRoot(T_DEFAULT_COLLATION_DECL54_tree, root_1);
            }


            match(input, Token.DOWN, null); if (state.failed) return retval;
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_uriliteral_in_defaultCollationDecl1746);
            uriliteral55=uriliteral();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_1, uriliteral55.getTree());

            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "defaultCollationDecl"

    public static class baseURIDecl_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "baseURIDecl"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:972:1: baseURIDecl : ^( T_BASEURI_DECL QSTRING ) ;
    public final XSPARQLRewriter.baseURIDecl_return baseURIDecl() throws RecognitionException {
        XSPARQLRewriter.baseURIDecl_return retval = new XSPARQLRewriter.baseURIDecl_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree T_BASEURI_DECL56=null;
        CommonTree QSTRING57=null;

        CommonTree T_BASEURI_DECL56_tree=null;
        CommonTree QSTRING57_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:973:3: ( ^( T_BASEURI_DECL QSTRING ) )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:973:5: ^( T_BASEURI_DECL QSTRING )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            T_BASEURI_DECL56=(CommonTree)match(input,T_BASEURI_DECL,FOLLOW_T_BASEURI_DECL_in_baseURIDecl1761); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            T_BASEURI_DECL56_tree = (CommonTree)adaptor.dupNode(T_BASEURI_DECL56);

            root_1 = (CommonTree)adaptor.becomeRoot(T_BASEURI_DECL56_tree, root_1);
            }


            match(input, Token.DOWN, null); if (state.failed) return retval;
            _last = (CommonTree)input.LT(1);
            QSTRING57=(CommonTree)match(input,QSTRING,FOLLOW_QSTRING_in_baseURIDecl1763); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            QSTRING57_tree = (CommonTree)adaptor.dupNode(QSTRING57);

            adaptor.addChild(root_1, QSTRING57_tree);
            }

            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "baseURIDecl"

    public static class schemaImport_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "schemaImport"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:976:1: schemaImport : ^( T_SCHEMA_IMPORT ^( SCHEMA ( schemaPrefix )? ) uriliteral ^( AT ( uriliteral )* ) ) ;
    public final XSPARQLRewriter.schemaImport_return schemaImport() throws RecognitionException {
        XSPARQLRewriter.schemaImport_return retval = new XSPARQLRewriter.schemaImport_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree T_SCHEMA_IMPORT58=null;
        CommonTree SCHEMA59=null;
        CommonTree AT62=null;
        XSPARQLRewriter.schemaPrefix_return schemaPrefix60 = null;

        XSPARQLRewriter.uriliteral_return uriliteral61 = null;

        XSPARQLRewriter.uriliteral_return uriliteral63 = null;


        CommonTree T_SCHEMA_IMPORT58_tree=null;
        CommonTree SCHEMA59_tree=null;
        CommonTree AT62_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:977:3: ( ^( T_SCHEMA_IMPORT ^( SCHEMA ( schemaPrefix )? ) uriliteral ^( AT ( uriliteral )* ) ) )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:977:5: ^( T_SCHEMA_IMPORT ^( SCHEMA ( schemaPrefix )? ) uriliteral ^( AT ( uriliteral )* ) )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            T_SCHEMA_IMPORT58=(CommonTree)match(input,T_SCHEMA_IMPORT,FOLLOW_T_SCHEMA_IMPORT_in_schemaImport1778); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            T_SCHEMA_IMPORT58_tree = (CommonTree)adaptor.dupNode(T_SCHEMA_IMPORT58);

            root_1 = (CommonTree)adaptor.becomeRoot(T_SCHEMA_IMPORT58_tree, root_1);
            }


            match(input, Token.DOWN, null); if (state.failed) return retval;
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_2 = _last;
            CommonTree _first_2 = null;
            CommonTree root_2 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            SCHEMA59=(CommonTree)match(input,SCHEMA,FOLLOW_SCHEMA_in_schemaImport1781); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            SCHEMA59_tree = (CommonTree)adaptor.dupNode(SCHEMA59);

            root_2 = (CommonTree)adaptor.becomeRoot(SCHEMA59_tree, root_2);
            }


            if ( input.LA(1)==Token.DOWN ) {
                match(input, Token.DOWN, null); if (state.failed) return retval;
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:977:32: ( schemaPrefix )?
                int alt11=2;
                switch ( input.LA(1) ) {
                    case NCNAME:
                    case DEFAULT:
                        {
                        alt11=1;
                        }
                        break;
                }

                switch (alt11) {
                    case 1 :
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: schemaPrefix
                        {
                        _last = (CommonTree)input.LT(1);
                        pushFollow(FOLLOW_schemaPrefix_in_schemaImport1783);
                        schemaPrefix60=schemaPrefix();

                        state._fsp--;
                        if (state.failed) return retval;
                        if ( state.backtracking==0 ) 
                        adaptor.addChild(root_2, schemaPrefix60.getTree());

                        if ( state.backtracking==0 ) {
                        }
                        }
                        break;

                }


                match(input, Token.UP, null); if (state.failed) return retval;
            }adaptor.addChild(root_1, root_2);_last = _save_last_2;
            }

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_uriliteral_in_schemaImport1787);
            uriliteral61=uriliteral();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_1, uriliteral61.getTree());
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_2 = _last;
            CommonTree _first_2 = null;
            CommonTree root_2 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            AT62=(CommonTree)match(input,AT,FOLLOW_AT_in_schemaImport1790); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            AT62_tree = (CommonTree)adaptor.dupNode(AT62);

            root_2 = (CommonTree)adaptor.becomeRoot(AT62_tree, root_2);
            }


            if ( input.LA(1)==Token.DOWN ) {
                match(input, Token.DOWN, null); if (state.failed) return retval;
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:977:63: ( uriliteral )*
                loop12:
                do {
                    int alt12=2;
                    switch ( input.LA(1) ) {
                    case QSTRING:
                        {
                        alt12=1;
                        }
                        break;

                    }

                    switch (alt12) {
                	case 1 :
                	    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: uriliteral
                	    {
                	    _last = (CommonTree)input.LT(1);
                	    pushFollow(FOLLOW_uriliteral_in_schemaImport1792);
                	    uriliteral63=uriliteral();

                	    state._fsp--;
                	    if (state.failed) return retval;
                	    if ( state.backtracking==0 ) 
                	    adaptor.addChild(root_2, uriliteral63.getTree());

                	    if ( state.backtracking==0 ) {
                	    }
                	    }
                	    break;

                	default :
                	    break loop12;
                    }
                } while (true);


                match(input, Token.UP, null); if (state.failed) return retval;
            }adaptor.addChild(root_1, root_2);_last = _save_last_2;
            }


            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "schemaImport"

    public static class schemaPrefix_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "schemaPrefix"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:980:1: schemaPrefix : ( NCNAME | DEFAULT );
    public final XSPARQLRewriter.schemaPrefix_return schemaPrefix() throws RecognitionException {
        XSPARQLRewriter.schemaPrefix_return retval = new XSPARQLRewriter.schemaPrefix_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set64=null;

        CommonTree set64_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:981:3: ( NCNAME | DEFAULT )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            set64=(CommonTree)input.LT(1);
            if ( input.LA(1)==NCNAME||input.LA(1)==DEFAULT ) {
                input.consume();

                if ( state.backtracking==0 ) {
                set64_tree = (CommonTree)adaptor.dupNode(set64);

                adaptor.addChild(root_0, set64_tree);
                }
                state.errorRecovery=false;state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

            if ( state.backtracking==0 ) {
            } 

            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "schemaPrefix"

    public static class moduleImport_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "moduleImport"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:985:1: moduleImport : ^( T_MODULE_IMPORT ^( NAMESPACE ( NCNAME )? ) uriliteral ^( AT ( uriliteral )* ) ) ;
    public final XSPARQLRewriter.moduleImport_return moduleImport() throws RecognitionException {
        XSPARQLRewriter.moduleImport_return retval = new XSPARQLRewriter.moduleImport_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree T_MODULE_IMPORT65=null;
        CommonTree NAMESPACE66=null;
        CommonTree NCNAME67=null;
        CommonTree AT69=null;
        XSPARQLRewriter.uriliteral_return uriliteral68 = null;

        XSPARQLRewriter.uriliteral_return uriliteral70 = null;


        CommonTree T_MODULE_IMPORT65_tree=null;
        CommonTree NAMESPACE66_tree=null;
        CommonTree NCNAME67_tree=null;
        CommonTree AT69_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:986:3: ( ^( T_MODULE_IMPORT ^( NAMESPACE ( NCNAME )? ) uriliteral ^( AT ( uriliteral )* ) ) )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:986:5: ^( T_MODULE_IMPORT ^( NAMESPACE ( NCNAME )? ) uriliteral ^( AT ( uriliteral )* ) )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            T_MODULE_IMPORT65=(CommonTree)match(input,T_MODULE_IMPORT,FOLLOW_T_MODULE_IMPORT_in_moduleImport1828); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            T_MODULE_IMPORT65_tree = (CommonTree)adaptor.dupNode(T_MODULE_IMPORT65);

            root_1 = (CommonTree)adaptor.becomeRoot(T_MODULE_IMPORT65_tree, root_1);
            }


            match(input, Token.DOWN, null); if (state.failed) return retval;
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_2 = _last;
            CommonTree _first_2 = null;
            CommonTree root_2 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            NAMESPACE66=(CommonTree)match(input,NAMESPACE,FOLLOW_NAMESPACE_in_moduleImport1831); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            NAMESPACE66_tree = (CommonTree)adaptor.dupNode(NAMESPACE66);

            root_2 = (CommonTree)adaptor.becomeRoot(NAMESPACE66_tree, root_2);
            }


            if ( input.LA(1)==Token.DOWN ) {
                match(input, Token.DOWN, null); if (state.failed) return retval;
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:986:35: ( NCNAME )?
                int alt13=2;
                switch ( input.LA(1) ) {
                    case NCNAME:
                        {
                        alt13=1;
                        }
                        break;
                }

                switch (alt13) {
                    case 1 :
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: NCNAME
                        {
                        _last = (CommonTree)input.LT(1);
                        NCNAME67=(CommonTree)match(input,NCNAME,FOLLOW_NCNAME_in_moduleImport1833); if (state.failed) return retval;
                        if ( state.backtracking==0 ) {
                        NCNAME67_tree = (CommonTree)adaptor.dupNode(NCNAME67);

                        adaptor.addChild(root_2, NCNAME67_tree);
                        }

                        if ( state.backtracking==0 ) {
                        }
                        }
                        break;

                }


                match(input, Token.UP, null); if (state.failed) return retval;
            }adaptor.addChild(root_1, root_2);_last = _save_last_2;
            }

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_uriliteral_in_moduleImport1837);
            uriliteral68=uriliteral();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_1, uriliteral68.getTree());
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_2 = _last;
            CommonTree _first_2 = null;
            CommonTree root_2 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            AT69=(CommonTree)match(input,AT,FOLLOW_AT_in_moduleImport1840); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            AT69_tree = (CommonTree)adaptor.dupNode(AT69);

            root_2 = (CommonTree)adaptor.becomeRoot(AT69_tree, root_2);
            }


            if ( input.LA(1)==Token.DOWN ) {
                match(input, Token.DOWN, null); if (state.failed) return retval;
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:986:60: ( uriliteral )*
                loop14:
                do {
                    int alt14=2;
                    switch ( input.LA(1) ) {
                    case QSTRING:
                        {
                        alt14=1;
                        }
                        break;

                    }

                    switch (alt14) {
                	case 1 :
                	    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: uriliteral
                	    {
                	    _last = (CommonTree)input.LT(1);
                	    pushFollow(FOLLOW_uriliteral_in_moduleImport1842);
                	    uriliteral70=uriliteral();

                	    state._fsp--;
                	    if (state.failed) return retval;
                	    if ( state.backtracking==0 ) 
                	    adaptor.addChild(root_2, uriliteral70.getTree());

                	    if ( state.backtracking==0 ) {
                	    }
                	    }
                	    break;

                	default :
                	    break loop14;
                    }
                } while (true);


                match(input, Token.UP, null); if (state.failed) return retval;
            }adaptor.addChild(root_1, root_2);_last = _save_last_2;
            }


            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "moduleImport"

    public static class varDecl_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "varDecl"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:989:1: varDecl : ( ^( T_VARIABLE_DECL var= VAR ^( T_TYPE ( typeDeclaration )? ) exprSingle ) | ^( T_EXTERNAL_VARIABLE_DECL var= VAR ^( T_TYPE ( typeDeclaration )? ) ) );
    public final XSPARQLRewriter.varDecl_return varDecl() throws RecognitionException {
        XSPARQLRewriter.varDecl_return retval = new XSPARQLRewriter.varDecl_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree var=null;
        CommonTree T_VARIABLE_DECL71=null;
        CommonTree T_TYPE72=null;
        CommonTree T_EXTERNAL_VARIABLE_DECL75=null;
        CommonTree T_TYPE76=null;
        XSPARQLRewriter.typeDeclaration_return typeDeclaration73 = null;

        XSPARQLRewriter.exprSingle_return exprSingle74 = null;

        XSPARQLRewriter.typeDeclaration_return typeDeclaration77 = null;


        CommonTree var_tree=null;
        CommonTree T_VARIABLE_DECL71_tree=null;
        CommonTree T_TYPE72_tree=null;
        CommonTree T_EXTERNAL_VARIABLE_DECL75_tree=null;
        CommonTree T_TYPE76_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:990:3: ( ^( T_VARIABLE_DECL var= VAR ^( T_TYPE ( typeDeclaration )? ) exprSingle ) | ^( T_EXTERNAL_VARIABLE_DECL var= VAR ^( T_TYPE ( typeDeclaration )? ) ) )
            int alt17=2;
            switch ( input.LA(1) ) {
            case T_VARIABLE_DECL:
                {
                alt17=1;
                }
                break;
            case T_EXTERNAL_VARIABLE_DECL:
                {
                alt17=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 17, 0, input);

                throw nvae;
            }

            switch (alt17) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:990:5: ^( T_VARIABLE_DECL var= VAR ^( T_TYPE ( typeDeclaration )? ) exprSingle )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    T_VARIABLE_DECL71=(CommonTree)match(input,T_VARIABLE_DECL,FOLLOW_T_VARIABLE_DECL_in_varDecl1859); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    T_VARIABLE_DECL71_tree = (CommonTree)adaptor.dupNode(T_VARIABLE_DECL71);

                    root_1 = (CommonTree)adaptor.becomeRoot(T_VARIABLE_DECL71_tree, root_1);
                    }


                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    var=(CommonTree)match(input,VAR,FOLLOW_VAR_in_varDecl1863); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    var_tree = (CommonTree)adaptor.dupNode(var);

                    adaptor.addChild(root_1, var_tree);
                    }
                    if ( state.backtracking==0 ) {
                      addVariableToScope((var!=null?var.getText():null));
                    }
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_2 = _last;
                    CommonTree _first_2 = null;
                    CommonTree root_2 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    T_TYPE72=(CommonTree)match(input,T_TYPE,FOLLOW_T_TYPE_in_varDecl1868); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    T_TYPE72_tree = (CommonTree)adaptor.dupNode(T_TYPE72);

                    root_2 = (CommonTree)adaptor.becomeRoot(T_TYPE72_tree, root_2);
                    }


                    if ( input.LA(1)==Token.DOWN ) {
                        match(input, Token.DOWN, null); if (state.failed) return retval;
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:990:73: ( typeDeclaration )?
                        int alt15=2;
                        switch ( input.LA(1) ) {
                            case NCNAME:
                            case PNAME_NS:
                            case PNAME_LN:
                            case A:
                            case FROM:
                            case ATTRIBUTE:
                            case ELEMENT:
                            case TO:
                            case EMPTYSEQUENCE:
                            case ITEM:
                            case NODE:
                            case DOCUMENTNODE:
                            case TEXT:
                            case COMMENT:
                            case PROCESSINGINSTRUCTION:
                            case SCHEMAATTRIBUTE:
                            case SCHEMAELEMENT:
                            case ROW:
                                {
                                alt15=1;
                                }
                                break;
                        }

                        switch (alt15) {
                            case 1 :
                                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: typeDeclaration
                                {
                                _last = (CommonTree)input.LT(1);
                                pushFollow(FOLLOW_typeDeclaration_in_varDecl1870);
                                typeDeclaration73=typeDeclaration();

                                state._fsp--;
                                if (state.failed) return retval;
                                if ( state.backtracking==0 ) 
                                adaptor.addChild(root_2, typeDeclaration73.getTree());

                                if ( state.backtracking==0 ) {
                                }
                                }
                                break;

                        }


                        match(input, Token.UP, null); if (state.failed) return retval;
                    }adaptor.addChild(root_1, root_2);_last = _save_last_2;
                    }

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_exprSingle_in_varDecl1874);
                    exprSingle74=exprSingle();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_1, exprSingle74.getTree());

                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:991:5: ^( T_EXTERNAL_VARIABLE_DECL var= VAR ^( T_TYPE ( typeDeclaration )? ) )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    T_EXTERNAL_VARIABLE_DECL75=(CommonTree)match(input,T_EXTERNAL_VARIABLE_DECL,FOLLOW_T_EXTERNAL_VARIABLE_DECL_in_varDecl1882); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    T_EXTERNAL_VARIABLE_DECL75_tree = (CommonTree)adaptor.dupNode(T_EXTERNAL_VARIABLE_DECL75);

                    root_1 = (CommonTree)adaptor.becomeRoot(T_EXTERNAL_VARIABLE_DECL75_tree, root_1);
                    }


                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    var=(CommonTree)match(input,VAR,FOLLOW_VAR_in_varDecl1886); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    var_tree = (CommonTree)adaptor.dupNode(var);

                    adaptor.addChild(root_1, var_tree);
                    }
                    if ( state.backtracking==0 ) {
                      addVariableToScope((var!=null?var.getText():null));
                    }
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_2 = _last;
                    CommonTree _first_2 = null;
                    CommonTree root_2 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    T_TYPE76=(CommonTree)match(input,T_TYPE,FOLLOW_T_TYPE_in_varDecl1891); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    T_TYPE76_tree = (CommonTree)adaptor.dupNode(T_TYPE76);

                    root_2 = (CommonTree)adaptor.becomeRoot(T_TYPE76_tree, root_2);
                    }


                    if ( input.LA(1)==Token.DOWN ) {
                        match(input, Token.DOWN, null); if (state.failed) return retval;
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:991:82: ( typeDeclaration )?
                        int alt16=2;
                        switch ( input.LA(1) ) {
                            case NCNAME:
                            case PNAME_NS:
                            case PNAME_LN:
                            case A:
                            case FROM:
                            case ATTRIBUTE:
                            case ELEMENT:
                            case TO:
                            case EMPTYSEQUENCE:
                            case ITEM:
                            case NODE:
                            case DOCUMENTNODE:
                            case TEXT:
                            case COMMENT:
                            case PROCESSINGINSTRUCTION:
                            case SCHEMAATTRIBUTE:
                            case SCHEMAELEMENT:
                            case ROW:
                                {
                                alt16=1;
                                }
                                break;
                        }

                        switch (alt16) {
                            case 1 :
                                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: typeDeclaration
                                {
                                _last = (CommonTree)input.LT(1);
                                pushFollow(FOLLOW_typeDeclaration_in_varDecl1893);
                                typeDeclaration77=typeDeclaration();

                                state._fsp--;
                                if (state.failed) return retval;
                                if ( state.backtracking==0 ) 
                                adaptor.addChild(root_2, typeDeclaration77.getTree());

                                if ( state.backtracking==0 ) {
                                }
                                }
                                break;

                        }


                        match(input, Token.UP, null); if (state.failed) return retval;
                    }adaptor.addChild(root_1, root_2);_last = _save_last_2;
                    }


                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "varDecl"

    public static class constructionDecl_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "constructionDecl"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:994:1: constructionDecl : DECLARE CONSTRUCTION ( STRIP | PRESERVE ) ;
    public final XSPARQLRewriter.constructionDecl_return constructionDecl() throws RecognitionException {
        XSPARQLRewriter.constructionDecl_return retval = new XSPARQLRewriter.constructionDecl_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree DECLARE78=null;
        CommonTree CONSTRUCTION79=null;
        CommonTree set80=null;

        CommonTree DECLARE78_tree=null;
        CommonTree CONSTRUCTION79_tree=null;
        CommonTree set80_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:995:3: ( DECLARE CONSTRUCTION ( STRIP | PRESERVE ) )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:995:5: DECLARE CONSTRUCTION ( STRIP | PRESERVE )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            DECLARE78=(CommonTree)match(input,DECLARE,FOLLOW_DECLARE_in_constructionDecl1909); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            DECLARE78_tree = (CommonTree)adaptor.dupNode(DECLARE78);

            adaptor.addChild(root_0, DECLARE78_tree);
            }
            _last = (CommonTree)input.LT(1);
            CONSTRUCTION79=(CommonTree)match(input,CONSTRUCTION,FOLLOW_CONSTRUCTION_in_constructionDecl1911); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            CONSTRUCTION79_tree = (CommonTree)adaptor.dupNode(CONSTRUCTION79);

            adaptor.addChild(root_0, CONSTRUCTION79_tree);
            }
            _last = (CommonTree)input.LT(1);
            set80=(CommonTree)input.LT(1);
            if ( input.LA(1)==STRIP||input.LA(1)==PRESERVE ) {
                input.consume();

                if ( state.backtracking==0 ) {
                set80_tree = (CommonTree)adaptor.dupNode(set80);

                adaptor.addChild(root_0, set80_tree);
                }
                state.errorRecovery=false;state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "constructionDecl"

    public static class functionDecl_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "functionDecl"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:998:1: functionDecl : ^( T_FUNCTION_DECL qname ^( T_PARAMS ( paramList )? ) ( ^( AS sequenceType ) )? ( enclosedExpr | EXTERNAL ) ) ;
    public final XSPARQLRewriter.functionDecl_return functionDecl() throws RecognitionException {
        VariableScope_stack.push(new VariableScope_scope());

        XSPARQLRewriter.functionDecl_return retval = new XSPARQLRewriter.functionDecl_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree T_FUNCTION_DECL81=null;
        CommonTree T_PARAMS83=null;
        CommonTree AS85=null;
        CommonTree EXTERNAL88=null;
        XSPARQLRewriter.qname_return qname82 = null;

        XSPARQLRewriter.paramList_return paramList84 = null;

        XSPARQLRewriter.sequenceType_return sequenceType86 = null;

        XSPARQLRewriter.enclosedExpr_return enclosedExpr87 = null;


        CommonTree T_FUNCTION_DECL81_tree=null;
        CommonTree T_PARAMS83_tree=null;
        CommonTree AS85_tree=null;
        CommonTree EXTERNAL88_tree=null;


          ((VariableScope_scope)VariableScope_stack.peek()).variables = new HashMap<String,Types>();
          logger.info("Creating new variable scope: functionDecl");

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1004:3: ( ^( T_FUNCTION_DECL qname ^( T_PARAMS ( paramList )? ) ( ^( AS sequenceType ) )? ( enclosedExpr | EXTERNAL ) ) )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1004:5: ^( T_FUNCTION_DECL qname ^( T_PARAMS ( paramList )? ) ( ^( AS sequenceType ) )? ( enclosedExpr | EXTERNAL ) )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            T_FUNCTION_DECL81=(CommonTree)match(input,T_FUNCTION_DECL,FOLLOW_T_FUNCTION_DECL_in_functionDecl1944); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            T_FUNCTION_DECL81_tree = (CommonTree)adaptor.dupNode(T_FUNCTION_DECL81);

            root_1 = (CommonTree)adaptor.becomeRoot(T_FUNCTION_DECL81_tree, root_1);
            }


            match(input, Token.DOWN, null); if (state.failed) return retval;
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_qname_in_functionDecl1946);
            qname82=qname();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_1, qname82.getTree());
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_2 = _last;
            CommonTree _first_2 = null;
            CommonTree root_2 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            T_PARAMS83=(CommonTree)match(input,T_PARAMS,FOLLOW_T_PARAMS_in_functionDecl1949); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            T_PARAMS83_tree = (CommonTree)adaptor.dupNode(T_PARAMS83);

            root_2 = (CommonTree)adaptor.becomeRoot(T_PARAMS83_tree, root_2);
            }


            if ( input.LA(1)==Token.DOWN ) {
                match(input, Token.DOWN, null); if (state.failed) return retval;
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1004:40: ( paramList )?
                int alt18=2;
                switch ( input.LA(1) ) {
                    case T_PARAM:
                        {
                        alt18=1;
                        }
                        break;
                }

                switch (alt18) {
                    case 1 :
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: paramList
                        {
                        _last = (CommonTree)input.LT(1);
                        pushFollow(FOLLOW_paramList_in_functionDecl1951);
                        paramList84=paramList();

                        state._fsp--;
                        if (state.failed) return retval;
                        if ( state.backtracking==0 ) 
                        adaptor.addChild(root_2, paramList84.getTree());

                        if ( state.backtracking==0 ) {
                        }
                        }
                        break;

                }


                match(input, Token.UP, null); if (state.failed) return retval;
            }adaptor.addChild(root_1, root_2);_last = _save_last_2;
            }

            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1004:52: ( ^( AS sequenceType ) )?
            int alt19=2;
            switch ( input.LA(1) ) {
                case AS:
                    {
                    alt19=1;
                    }
                    break;
            }

            switch (alt19) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1004:53: ^( AS sequenceType )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_2 = _last;
                    CommonTree _first_2 = null;
                    CommonTree root_2 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    AS85=(CommonTree)match(input,AS,FOLLOW_AS_in_functionDecl1957); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    AS85_tree = (CommonTree)adaptor.dupNode(AS85);

                    root_2 = (CommonTree)adaptor.becomeRoot(AS85_tree, root_2);
                    }


                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_sequenceType_in_functionDecl1959);
                    sequenceType86=sequenceType();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_2, sequenceType86.getTree());

                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_1, root_2);_last = _save_last_2;
                    }


                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }

            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1004:74: ( enclosedExpr | EXTERNAL )
            int alt20=2;
            switch ( input.LA(1) ) {
            case LCURLY:
            case STAR:
            case LESSTHAN:
            case GREATERTHAN:
            case PLUS:
            case MINUS:
            case UNIONSYMBOL:
            case LESSTHANLESSTHAN:
            case GREATERTHANEQUALS:
            case LESSTHANEQUALS:
            case HAFENEQUALS:
            case EQUALS:
            case IS:
            case EQ:
            case NE:
            case LT:
            case GE:
            case LE:
            case GT:
            case IF:
            case AND:
            case OR:
            case TO:
            case DIV:
            case IDIV:
            case MOD:
            case UNION:
            case INTERSECT:
            case EXCEPT:
            case GREATERTHANGREATERTHAN:
            case T_FLWOR:
            case T_INSTANCEOF:
            case T_CASTAS:
            case T_CASTABLEAS:
            case T_TREATAS:
            case EVERY:
            case TYPESWITCH:
            case VALIDATE:
            case SOME:
            case XPATH:
                {
                alt20=1;
                }
                break;
            case EXTERNAL:
                {
                alt20=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 20, 0, input);

                throw nvae;
            }

            switch (alt20) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1004:75: enclosedExpr
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_enclosedExpr_in_functionDecl1965);
                    enclosedExpr87=enclosedExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_1, enclosedExpr87.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1004:90: EXTERNAL
                    {
                    _last = (CommonTree)input.LT(1);
                    EXTERNAL88=(CommonTree)match(input,EXTERNAL,FOLLOW_EXTERNAL_in_functionDecl1969); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    EXTERNAL88_tree = (CommonTree)adaptor.dupNode(EXTERNAL88);

                    adaptor.addChild(root_1, EXTERNAL88_tree);
                    }

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }


            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
            VariableScope_stack.pop();

        }
        return retval;
    }
    // $ANTLR end "functionDecl"

    public static class paramList_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "paramList"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1007:1: paramList : ( param )+ ;
    public final XSPARQLRewriter.paramList_return paramList() throws RecognitionException {
        XSPARQLRewriter.paramList_return retval = new XSPARQLRewriter.paramList_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.param_return param89 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1008:3: ( ( param )+ )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1008:5: ( param )+
            {
            root_0 = (CommonTree)adaptor.nil();

            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1008:5: ( param )+
            int cnt21=0;
            loop21:
            do {
                int alt21=2;
                switch ( input.LA(1) ) {
                case T_PARAM:
                    {
                    alt21=1;
                    }
                    break;

                }

                switch (alt21) {
            	case 1 :
            	    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: param
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_param_in_paramList1984);
            	    param89=param();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) 
            	    adaptor.addChild(root_0, param89.getTree());

            	    if ( state.backtracking==0 ) {
            	    }
            	    }
            	    break;

            	default :
            	    if ( cnt21 >= 1 ) break loop21;
            	    if (state.backtracking>0) {state.failed=true; return retval;}
                        EarlyExitException eee =
                            new EarlyExitException(21, input);
                        throw eee;
                }
                cnt21++;
            } while (true);


            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "paramList"

    public static class param_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "param"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1011:1: param : ^( T_PARAM var= VAR ^( T_TYPE ( typeDeclaration )? ) ) ;
    public final XSPARQLRewriter.param_return param() throws RecognitionException {
        XSPARQLRewriter.param_return retval = new XSPARQLRewriter.param_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree var=null;
        CommonTree T_PARAM90=null;
        CommonTree T_TYPE91=null;
        XSPARQLRewriter.typeDeclaration_return typeDeclaration92 = null;


        CommonTree var_tree=null;
        CommonTree T_PARAM90_tree=null;
        CommonTree T_TYPE91_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1012:3: ( ^( T_PARAM var= VAR ^( T_TYPE ( typeDeclaration )? ) ) )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1012:5: ^( T_PARAM var= VAR ^( T_TYPE ( typeDeclaration )? ) )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            T_PARAM90=(CommonTree)match(input,T_PARAM,FOLLOW_T_PARAM_in_param1999); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            T_PARAM90_tree = (CommonTree)adaptor.dupNode(T_PARAM90);

            root_1 = (CommonTree)adaptor.becomeRoot(T_PARAM90_tree, root_1);
            }


            match(input, Token.DOWN, null); if (state.failed) return retval;
            _last = (CommonTree)input.LT(1);
            var=(CommonTree)match(input,VAR,FOLLOW_VAR_in_param2003); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            var_tree = (CommonTree)adaptor.dupNode(var);

            adaptor.addChild(root_1, var_tree);
            }
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_2 = _last;
            CommonTree _first_2 = null;
            CommonTree root_2 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            T_TYPE91=(CommonTree)match(input,T_TYPE,FOLLOW_T_TYPE_in_param2006); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            T_TYPE91_tree = (CommonTree)adaptor.dupNode(T_TYPE91);

            root_2 = (CommonTree)adaptor.becomeRoot(T_TYPE91_tree, root_2);
            }


            if ( input.LA(1)==Token.DOWN ) {
                match(input, Token.DOWN, null); if (state.failed) return retval;
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1012:32: ( typeDeclaration )?
                int alt22=2;
                switch ( input.LA(1) ) {
                    case NCNAME:
                    case PNAME_NS:
                    case PNAME_LN:
                    case A:
                    case FROM:
                    case ATTRIBUTE:
                    case ELEMENT:
                    case TO:
                    case EMPTYSEQUENCE:
                    case ITEM:
                    case NODE:
                    case DOCUMENTNODE:
                    case TEXT:
                    case COMMENT:
                    case PROCESSINGINSTRUCTION:
                    case SCHEMAATTRIBUTE:
                    case SCHEMAELEMENT:
                    case ROW:
                        {
                        alt22=1;
                        }
                        break;
                }

                switch (alt22) {
                    case 1 :
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: typeDeclaration
                        {
                        _last = (CommonTree)input.LT(1);
                        pushFollow(FOLLOW_typeDeclaration_in_param2008);
                        typeDeclaration92=typeDeclaration();

                        state._fsp--;
                        if (state.failed) return retval;
                        if ( state.backtracking==0 ) 
                        adaptor.addChild(root_2, typeDeclaration92.getTree());

                        if ( state.backtracking==0 ) {
                        }
                        }
                        break;

                }


                match(input, Token.UP, null); if (state.failed) return retval;
            }adaptor.addChild(root_1, root_2);_last = _save_last_2;
            }


            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }

            if ( state.backtracking==0 ) {
              addVariableToScope((var!=null?var.getText():null));
            }

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "param"

    public static class enclosedExpr_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "enclosedExpr"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1015:1: enclosedExpr : expr ;
    public final XSPARQLRewriter.enclosedExpr_return enclosedExpr() throws RecognitionException {
        XSPARQLRewriter.enclosedExpr_return retval = new XSPARQLRewriter.enclosedExpr_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.expr_return expr93 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1016:3: ( expr )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1016:5: expr
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_expr_in_enclosedExpr2026);
            expr93=expr();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_0, expr93.getTree());

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "enclosedExpr"

    public static class enclosedExpr__return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "enclosedExpr_"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1019:1: enclosedExpr_ : LCURLY expr RCURLY ;
    public final XSPARQLRewriter.enclosedExpr__return enclosedExpr_() throws RecognitionException {
        XSPARQLRewriter.enclosedExpr__return retval = new XSPARQLRewriter.enclosedExpr__return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree LCURLY94=null;
        CommonTree RCURLY96=null;
        XSPARQLRewriter.expr_return expr95 = null;


        CommonTree LCURLY94_tree=null;
        CommonTree RCURLY96_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1020:3: ( LCURLY expr RCURLY )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1020:5: LCURLY expr RCURLY
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            LCURLY94=(CommonTree)match(input,LCURLY,FOLLOW_LCURLY_in_enclosedExpr_2039); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            LCURLY94_tree = (CommonTree)adaptor.dupNode(LCURLY94);

            adaptor.addChild(root_0, LCURLY94_tree);
            }
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_expr_in_enclosedExpr_2041);
            expr95=expr();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_0, expr95.getTree());
            _last = (CommonTree)input.LT(1);
            RCURLY96=(CommonTree)match(input,RCURLY,FOLLOW_RCURLY_in_enclosedExpr_2043); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            RCURLY96_tree = (CommonTree)adaptor.dupNode(RCURLY96);

            adaptor.addChild(root_0, RCURLY96_tree);
            }

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "enclosedExpr_"

    public static class queryBody_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "queryBody"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1023:1: queryBody : ^( T_QUERY_BODY ( ^( T_BODY_PART exprSingle ) )+ epilogue ) -> {XSPARQL.graphoutput}? ^( T_QUERY_BODY ^( T_FUNCTION_CALL NCNAME[serializeFunction] ^( T_PARAMS ^( T_PAR ^( T_BODY_PART COMMENT[\"N3 namespace declaration\"] QSTRING[getRDFNamespaceDecls()] ) ( ^( T_BODY_PART exprSingle ) )+ ) ) ) ) -> ^( T_QUERY_BODY ( ^( T_BODY_PART exprSingle ) )+ epilogue ) ;
    public final XSPARQLRewriter.queryBody_return queryBody() throws RecognitionException {
        XSPARQLRewriter.queryBody_return retval = new XSPARQLRewriter.queryBody_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree T_QUERY_BODY97=null;
        CommonTree T_BODY_PART98=null;
        XSPARQLRewriter.exprSingle_return exprSingle99 = null;

        XSPARQLRewriter.epilogue_return epilogue100 = null;


        CommonTree T_QUERY_BODY97_tree=null;
        CommonTree T_BODY_PART98_tree=null;
        RewriteRuleNodeStream stream_T_BODY_PART=new RewriteRuleNodeStream(adaptor,"token T_BODY_PART");
        RewriteRuleNodeStream stream_T_QUERY_BODY=new RewriteRuleNodeStream(adaptor,"token T_QUERY_BODY");
        RewriteRuleSubtreeStream stream_epilogue=new RewriteRuleSubtreeStream(adaptor,"rule epilogue");
        RewriteRuleSubtreeStream stream_exprSingle=new RewriteRuleSubtreeStream(adaptor,"rule exprSingle");
        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1024:3: ( ^( T_QUERY_BODY ( ^( T_BODY_PART exprSingle ) )+ epilogue ) -> {XSPARQL.graphoutput}? ^( T_QUERY_BODY ^( T_FUNCTION_CALL NCNAME[serializeFunction] ^( T_PARAMS ^( T_PAR ^( T_BODY_PART COMMENT[\"N3 namespace declaration\"] QSTRING[getRDFNamespaceDecls()] ) ( ^( T_BODY_PART exprSingle ) )+ ) ) ) ) -> ^( T_QUERY_BODY ( ^( T_BODY_PART exprSingle ) )+ epilogue ) )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1024:5: ^( T_QUERY_BODY ( ^( T_BODY_PART exprSingle ) )+ epilogue )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            T_QUERY_BODY97=(CommonTree)match(input,T_QUERY_BODY,FOLLOW_T_QUERY_BODY_in_queryBody2057); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_T_QUERY_BODY.add(T_QUERY_BODY97);



            match(input, Token.DOWN, null); if (state.failed) return retval;
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1024:20: ( ^( T_BODY_PART exprSingle ) )+
            int cnt23=0;
            loop23:
            do {
                int alt23=2;
                switch ( input.LA(1) ) {
                case T_BODY_PART:
                    {
                    alt23=1;
                    }
                    break;

                }

                switch (alt23) {
            	case 1 :
            	    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1024:21: ^( T_BODY_PART exprSingle )
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    {
            	    CommonTree _save_last_2 = _last;
            	    CommonTree _first_2 = null;
            	    CommonTree root_2 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            	    T_BODY_PART98=(CommonTree)match(input,T_BODY_PART,FOLLOW_T_BODY_PART_in_queryBody2061); if (state.failed) return retval; 
            	    if ( state.backtracking==0 ) stream_T_BODY_PART.add(T_BODY_PART98);



            	    match(input, Token.DOWN, null); if (state.failed) return retval;
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_exprSingle_in_queryBody2063);
            	    exprSingle99=exprSingle();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) stream_exprSingle.add(exprSingle99.getTree());

            	    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_1, root_2);_last = _save_last_2;
            	    }


            	    if ( state.backtracking==0 ) {
            	    }
            	    }
            	    break;

            	default :
            	    if ( cnt23 >= 1 ) break loop23;
            	    if (state.backtracking>0) {state.failed=true; return retval;}
                        EarlyExitException eee =
                            new EarlyExitException(23, input);
                        throw eee;
                }
                cnt23++;
            } while (true);

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_epilogue_in_queryBody2068);
            epilogue100=epilogue();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_epilogue.add(epilogue100.getTree());

            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }



            // AST REWRITE
            // elements: T_BODY_PART, T_BODY_PART, T_QUERY_BODY, exprSingle, exprSingle, T_BODY_PART, T_QUERY_BODY, epilogue
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1025:3: -> {XSPARQL.graphoutput}? ^( T_QUERY_BODY ^( T_FUNCTION_CALL NCNAME[serializeFunction] ^( T_PARAMS ^( T_PAR ^( T_BODY_PART COMMENT[\"N3 namespace declaration\"] QSTRING[getRDFNamespaceDecls()] ) ( ^( T_BODY_PART exprSingle ) )+ ) ) ) )
            if (XSPARQL.graphoutput) {
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1026:6: ^( T_QUERY_BODY ^( T_FUNCTION_CALL NCNAME[serializeFunction] ^( T_PARAMS ^( T_PAR ^( T_BODY_PART COMMENT[\"N3 namespace declaration\"] QSTRING[getRDFNamespaceDecls()] ) ( ^( T_BODY_PART exprSingle ) )+ ) ) ) )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(stream_T_QUERY_BODY.nextNode(), root_1);

                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1027:9: ^( T_FUNCTION_CALL NCNAME[serializeFunction] ^( T_PARAMS ^( T_PAR ^( T_BODY_PART COMMENT[\"N3 namespace declaration\"] QSTRING[getRDFNamespaceDecls()] ) ( ^( T_BODY_PART exprSingle ) )+ ) ) )
                {
                CommonTree root_2 = (CommonTree)adaptor.nil();
                root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FUNCTION_CALL, "T_FUNCTION_CALL"), root_2);

                adaptor.addChild(root_2, (CommonTree)adaptor.create(NCNAME, serializeFunction));
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1029:11: ^( T_PARAMS ^( T_PAR ^( T_BODY_PART COMMENT[\"N3 namespace declaration\"] QSTRING[getRDFNamespaceDecls()] ) ( ^( T_BODY_PART exprSingle ) )+ ) )
                {
                CommonTree root_3 = (CommonTree)adaptor.nil();
                root_3 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_PARAMS, "T_PARAMS"), root_3);

                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1029:22: ^( T_PAR ^( T_BODY_PART COMMENT[\"N3 namespace declaration\"] QSTRING[getRDFNamespaceDecls()] ) ( ^( T_BODY_PART exprSingle ) )+ )
                {
                CommonTree root_4 = (CommonTree)adaptor.nil();
                root_4 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_PAR, "T_PAR"), root_4);

                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1030:13: ^( T_BODY_PART COMMENT[\"N3 namespace declaration\"] QSTRING[getRDFNamespaceDecls()] )
                {
                CommonTree root_5 = (CommonTree)adaptor.nil();
                root_5 = (CommonTree)adaptor.becomeRoot(stream_T_BODY_PART.nextNode(), root_5);

                adaptor.addChild(root_5, (CommonTree)adaptor.create(COMMENT, "N3 namespace declaration"));
                adaptor.addChild(root_5, (CommonTree)adaptor.create(QSTRING, getRDFNamespaceDecls()));

                adaptor.addChild(root_4, root_5);
                }
                if ( !(stream_exprSingle.hasNext()||stream_T_BODY_PART.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_exprSingle.hasNext()||stream_T_BODY_PART.hasNext() ) {
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1034:11: ^( T_BODY_PART exprSingle )
                    {
                    CommonTree root_5 = (CommonTree)adaptor.nil();
                    root_5 = (CommonTree)adaptor.becomeRoot(stream_T_BODY_PART.nextNode(), root_5);

                    adaptor.addChild(root_5, stream_exprSingle.nextTree());

                    adaptor.addChild(root_4, root_5);
                    }

                }
                stream_exprSingle.reset();
                stream_T_BODY_PART.reset();

                adaptor.addChild(root_3, root_4);
                }

                adaptor.addChild(root_2, root_3);
                }

                adaptor.addChild(root_1, root_2);
                }

                adaptor.addChild(root_0, root_1);
                }

            }
            else // 1039:3: -> ^( T_QUERY_BODY ( ^( T_BODY_PART exprSingle ) )+ epilogue )
            {
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1039:7: ^( T_QUERY_BODY ( ^( T_BODY_PART exprSingle ) )+ epilogue )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(stream_T_QUERY_BODY.nextNode(), root_1);

                if ( !(stream_T_BODY_PART.hasNext()||stream_exprSingle.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_T_BODY_PART.hasNext()||stream_exprSingle.hasNext() ) {
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1039:23: ^( T_BODY_PART exprSingle )
                    {
                    CommonTree root_2 = (CommonTree)adaptor.nil();
                    root_2 = (CommonTree)adaptor.becomeRoot(stream_T_BODY_PART.nextNode(), root_2);

                    adaptor.addChild(root_2, stream_exprSingle.nextTree());

                    adaptor.addChild(root_1, root_2);
                    }

                }
                stream_T_BODY_PART.reset();
                stream_exprSingle.reset();
                adaptor.addChild(root_1, stream_epilogue.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "queryBody"

    public static class epilogue_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "epilogue"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1043:1: epilogue : T_EPILOGUE -> { epilogue.getChildCount() > 0 }? -> DELETEVNODE[\"epilogue\"] ;
    public final XSPARQLRewriter.epilogue_return epilogue() throws RecognitionException {
        XSPARQLRewriter.epilogue_return retval = new XSPARQLRewriter.epilogue_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree T_EPILOGUE101=null;

        CommonTree T_EPILOGUE101_tree=null;
        RewriteRuleNodeStream stream_T_EPILOGUE=new RewriteRuleNodeStream(adaptor,"token T_EPILOGUE");

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1044:3: ( T_EPILOGUE -> { epilogue.getChildCount() > 0 }? -> DELETEVNODE[\"epilogue\"] )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1044:5: T_EPILOGUE
            {
            _last = (CommonTree)input.LT(1);
            T_EPILOGUE101=(CommonTree)match(input,T_EPILOGUE,FOLLOW_T_EPILOGUE_in_epilogue2277); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_T_EPILOGUE.add(T_EPILOGUE101);



            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1045:3: -> { epilogue.getChildCount() > 0 }?
            if ( epilogue.getChildCount() > 0 ) {
                adaptor.addChild(root_0,  epilogue );

            }
            else // 1046:3: -> DELETEVNODE[\"epilogue\"]
            {
                adaptor.addChild(root_0, (CommonTree)adaptor.create(DELETEVNODE, "epilogue"));

            }

            retval.tree = root_0;}
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "epilogue"

    public static class expr_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "expr"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1050:1: expr options {backtrack=false; } : ( exprSingle )+ ;
    public final XSPARQLRewriter.expr_return expr() throws RecognitionException {
        XSPARQLRewriter.expr_return retval = new XSPARQLRewriter.expr_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.exprSingle_return exprSingle102 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1055:3: ( ( exprSingle )+ )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1055:5: ( exprSingle )+
            {
            root_0 = (CommonTree)adaptor.nil();

            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1055:5: ( exprSingle )+
            int cnt24=0;
            loop24:
            do {
                int alt24=2;
                alt24 = dfa24.predict(input);
                switch (alt24) {
            	case 1 :
            	    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: exprSingle
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_exprSingle_in_expr2316);
            	    exprSingle102=exprSingle();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) 
            	    adaptor.addChild(root_0, exprSingle102.getTree());

            	    if ( state.backtracking==0 ) {
            	    }
            	    }
            	    break;

            	default :
            	    if ( cnt24 >= 1 ) break loop24;
            	    if (state.backtracking>0) {state.failed=true; return retval;}
                        EarlyExitException eee =
                            new EarlyExitException(24, input);
                        throw eee;
                }
                cnt24++;
            } while (true);


            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "expr"

    protected static class exprSingle_scope {
        boolean isConstruct;
    }
    protected Stack exprSingle_stack = new Stack();

    public static class exprSingle_return extends TreeRuleReturnScope {
        public Types type;
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "exprSingle"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1058:1: exprSingle returns [Types type] : ( flworExpr | quantifiedExpr | typeSwitchExpr | orExpr | ifExpr );
    public final XSPARQLRewriter.exprSingle_return exprSingle() throws RecognitionException {
        exprSingle_stack.push(new exprSingle_scope());
        XSPARQLRewriter.exprSingle_return retval = new XSPARQLRewriter.exprSingle_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.flworExpr_return flworExpr103 = null;

        XSPARQLRewriter.quantifiedExpr_return quantifiedExpr104 = null;

        XSPARQLRewriter.typeSwitchExpr_return typeSwitchExpr105 = null;

        XSPARQLRewriter.orExpr_return orExpr106 = null;

        XSPARQLRewriter.ifExpr_return ifExpr107 = null;




            logger.info("exprSingle");
            ((exprSingle_scope)exprSingle_stack.peek()).isConstruct = false;
            retval.type = Types.XQUERY;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1068:3: ( flworExpr | quantifiedExpr | typeSwitchExpr | orExpr | ifExpr )
            int alt25=5;
            switch ( input.LA(1) ) {
            case T_FLWOR:
                {
                alt25=1;
                }
                break;
            case EVERY:
            case SOME:
                {
                alt25=2;
                }
                break;
            case TYPESWITCH:
                {
                alt25=3;
                }
                break;
            case LCURLY:
            case STAR:
            case LESSTHAN:
            case GREATERTHAN:
            case PLUS:
            case MINUS:
            case UNIONSYMBOL:
            case LESSTHANLESSTHAN:
            case GREATERTHANEQUALS:
            case LESSTHANEQUALS:
            case HAFENEQUALS:
            case EQUALS:
            case IS:
            case EQ:
            case NE:
            case LT:
            case GE:
            case LE:
            case GT:
            case AND:
            case OR:
            case TO:
            case DIV:
            case IDIV:
            case MOD:
            case UNION:
            case INTERSECT:
            case EXCEPT:
            case GREATERTHANGREATERTHAN:
            case T_INSTANCEOF:
            case T_CASTAS:
            case T_CASTABLEAS:
            case T_TREATAS:
            case VALIDATE:
            case XPATH:
                {
                alt25=4;
                }
                break;
            case IF:
                {
                alt25=5;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 25, 0, input);

                throw nvae;
            }

            switch (alt25) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1068:5: flworExpr
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_flworExpr_in_exprSingle2347);
                    flworExpr103=flworExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, flworExpr103.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1069:5: quantifiedExpr
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_quantifiedExpr_in_exprSingle2353);
                    quantifiedExpr104=quantifiedExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, quantifiedExpr104.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 3 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1070:5: typeSwitchExpr
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_typeSwitchExpr_in_exprSingle2359);
                    typeSwitchExpr105=typeSwitchExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, typeSwitchExpr105.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 4 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1071:5: orExpr
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_orExpr_in_exprSingle2365);
                    orExpr106=orExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, orExpr106.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 5 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1072:5: ifExpr
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_ifExpr_in_exprSingle2371);
                    ifExpr107=ifExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, ifExpr107.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
            if ( state.backtracking==0 ) {
               if (((exprSingle_scope)exprSingle_stack.peek()).isConstruct) { retval.type = Types.RDF_GRAPH; }  
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
            exprSingle_stack.pop();
        }
        return retval;
    }
    // $ANTLR end "exprSingle"

    public static class flworExpr_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "flworExpr"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1075:1: flworExpr : ^( T_FLWOR forletClause ( returnClause )? ) ;
    public final XSPARQLRewriter.flworExpr_return flworExpr() throws RecognitionException {
        VariableScope_stack.push(new VariableScope_scope());

        XSPARQLRewriter.flworExpr_return retval = new XSPARQLRewriter.flworExpr_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree T_FLWOR108=null;
        XSPARQLRewriter.forletClause_return forletClause109 = null;

        XSPARQLRewriter.returnClause_return returnClause110 = null;


        CommonTree T_FLWOR108_tree=null;


          ((VariableScope_scope)VariableScope_stack.peek()).variables = new HashMap<String,Types>();
          ((VariableScope_scope)VariableScope_stack.peek()).positions = new LinkedList<String>();
          ((VariableScope_scope)VariableScope_stack.peek()).scopedDataset = true;
          ((VariableScope_scope)VariableScope_stack.peek()).sparqlClause = false;
          logger.info("Creating new variable scope: flworExpr");

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1084:3: ( ^( T_FLWOR forletClause ( returnClause )? ) )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1084:5: ^( T_FLWOR forletClause ( returnClause )? )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            T_FLWOR108=(CommonTree)match(input,T_FLWOR,FOLLOW_T_FLWOR_in_flworExpr2395); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            T_FLWOR108_tree = (CommonTree)adaptor.dupNode(T_FLWOR108);

            root_1 = (CommonTree)adaptor.becomeRoot(T_FLWOR108_tree, root_1);
            }


            match(input, Token.DOWN, null); if (state.failed) return retval;
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_forletClause_in_flworExpr2397);
            forletClause109=forletClause();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_1, forletClause109.getTree());
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1085:7: ( returnClause )?
            int alt26=2;
            switch ( input.LA(1) ) {
                case T_CONSTRUCT:
                case T_RETURN:
                    {
                    alt26=1;
                    }
                    break;
            }

            switch (alt26) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: returnClause
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_returnClause_in_flworExpr2406);
                    returnClause110=returnClause();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_1, returnClause110.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }


            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
            VariableScope_stack.pop();

        }
        return retval;
    }
    // $ANTLR end "flworExpr"

    public static class returnClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "returnClause"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1089:1: returnClause : ( ^( T_RETURN exprSingle ) -> ^( T_RETURN exprSingle ) | ^(c= T_CONSTRUCT constructTemplate ) -> COMMENT[\"SPARQL CONSTRUCT \" + $c.text + \" from \" + $c.line + \":\" + $c.pos] ^( T_RETURN[$c.token, \"return\"] ^( T_FUNCTION_CALL[$c.token, \"T_FUNCTION_CALL\"] NCNAME[serializeFunction] ^( T_PARAMS ^( T_PAR constructTemplate ) ) ) ) );
    public final XSPARQLRewriter.returnClause_return returnClause() throws RecognitionException {
        XSPARQLRewriter.returnClause_return retval = new XSPARQLRewriter.returnClause_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree c=null;
        CommonTree T_RETURN111=null;
        XSPARQLRewriter.exprSingle_return exprSingle112 = null;

        XSPARQLRewriter.constructTemplate_return constructTemplate113 = null;


        CommonTree c_tree=null;
        CommonTree T_RETURN111_tree=null;
        RewriteRuleNodeStream stream_T_RETURN=new RewriteRuleNodeStream(adaptor,"token T_RETURN");
        RewriteRuleNodeStream stream_T_CONSTRUCT=new RewriteRuleNodeStream(adaptor,"token T_CONSTRUCT");
        RewriteRuleSubtreeStream stream_constructTemplate=new RewriteRuleSubtreeStream(adaptor,"rule constructTemplate");
        RewriteRuleSubtreeStream stream_exprSingle=new RewriteRuleSubtreeStream(adaptor,"rule exprSingle");

          logger.info("returnClause");

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1094:3: ( ^( T_RETURN exprSingle ) -> ^( T_RETURN exprSingle ) | ^(c= T_CONSTRUCT constructTemplate ) -> COMMENT[\"SPARQL CONSTRUCT \" + $c.text + \" from \" + $c.line + \":\" + $c.pos] ^( T_RETURN[$c.token, \"return\"] ^( T_FUNCTION_CALL[$c.token, \"T_FUNCTION_CALL\"] NCNAME[serializeFunction] ^( T_PARAMS ^( T_PAR constructTemplate ) ) ) ) )
            int alt27=2;
            switch ( input.LA(1) ) {
            case T_RETURN:
                {
                alt27=1;
                }
                break;
            case T_CONSTRUCT:
                {
                alt27=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 27, 0, input);

                throw nvae;
            }

            switch (alt27) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1094:5: ^( T_RETURN exprSingle )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    T_RETURN111=(CommonTree)match(input,T_RETURN,FOLLOW_T_RETURN_in_returnClause2438); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_T_RETURN.add(T_RETURN111);



                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_exprSingle_in_returnClause2440);
                    exprSingle112=exprSingle();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_exprSingle.add(exprSingle112.getTree());

                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }



                    // AST REWRITE
                    // elements: T_RETURN, exprSingle
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1094:28: -> ^( T_RETURN exprSingle )
                    {
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1094:31: ^( T_RETURN exprSingle )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(stream_T_RETURN.nextNode(), root_1);

                        adaptor.addChild(root_1, stream_exprSingle.nextTree());
                        adaptor.addChild(root_1,  generatePop() );

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;}
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1095:5: ^(c= T_CONSTRUCT constructTemplate )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    c=(CommonTree)match(input,T_CONSTRUCT,FOLLOW_T_CONSTRUCT_in_returnClause2460); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_T_CONSTRUCT.add(c);



                    if ( input.LA(1)==Token.DOWN ) {
                        match(input, Token.DOWN, null); if (state.failed) return retval;
                        _last = (CommonTree)input.LT(1);
                        pushFollow(FOLLOW_constructTemplate_in_returnClause2463);
                        constructTemplate113=constructTemplate();

                        state._fsp--;
                        if (state.failed) return retval;
                        if ( state.backtracking==0 ) stream_constructTemplate.add(constructTemplate113.getTree());
                        if ( state.backtracking==0 ) {
                           ((exprSingle_scope)exprSingle_stack.peek()).isConstruct = true; 
                        }

                        match(input, Token.UP, null); if (state.failed) return retval;
                    }adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }



                    // AST REWRITE
                    // elements: constructTemplate
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1096:3: -> COMMENT[\"SPARQL CONSTRUCT \" + $c.text + \" from \" + $c.line + \":\" + $c.pos] ^( T_RETURN[$c.token, \"return\"] ^( T_FUNCTION_CALL[$c.token, \"T_FUNCTION_CALL\"] NCNAME[serializeFunction] ^( T_PARAMS ^( T_PAR constructTemplate ) ) ) )
                    {
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(COMMENT, "SPARQL CONSTRUCT " + (c!=null?c.getText():null) + " from " + (c!=null?c.getLine():0) + ":" + (c!=null?c.getCharPositionInLine():0)));
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1097:6: ^( T_RETURN[$c.token, \"return\"] ^( T_FUNCTION_CALL[$c.token, \"T_FUNCTION_CALL\"] NCNAME[serializeFunction] ^( T_PARAMS ^( T_PAR constructTemplate ) ) ) )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_RETURN, c.token, "return"), root_1);

                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1098:8: ^( T_FUNCTION_CALL[$c.token, \"T_FUNCTION_CALL\"] NCNAME[serializeFunction] ^( T_PARAMS ^( T_PAR constructTemplate ) ) )
                        {
                        CommonTree root_2 = (CommonTree)adaptor.nil();
                        root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FUNCTION_CALL, c.token, "T_FUNCTION_CALL"), root_2);

                        adaptor.addChild(root_2, (CommonTree)adaptor.create(NCNAME, serializeFunction));
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1099:10: ^( T_PARAMS ^( T_PAR constructTemplate ) )
                        {
                        CommonTree root_3 = (CommonTree)adaptor.nil();
                        root_3 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_PARAMS, "T_PARAMS"), root_3);

                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1099:21: ^( T_PAR constructTemplate )
                        {
                        CommonTree root_4 = (CommonTree)adaptor.nil();
                        root_4 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_PAR, "T_PAR"), root_4);

                        adaptor.addChild(root_4, stream_constructTemplate.nextTree());

                        adaptor.addChild(root_3, root_4);
                        }

                        adaptor.addChild(root_2, root_3);
                        }

                        adaptor.addChild(root_1, root_2);
                        }
                        adaptor.addChild(root_1, generatePop());

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;}
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
            if ( state.backtracking==0 ) {
               if(((VariableScope_scope)VariableScope_stack.peek()).sparqlClause) { scopedDataset.pop(); }
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "returnClause"

    public static class forletClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "forletClause"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1105:1: forletClause : ( forClause ( ^( T_WHERE whereClause ) )? ( ^( T_ORDER orderByClause ) )? | sparqlForClause | sqlForClause | letClause ( ^( T_WHERE whereClause ) )? ( ^( T_ORDER orderByClause ) )? );
    public final XSPARQLRewriter.forletClause_return forletClause() throws RecognitionException {
        XSPARQLRewriter.forletClause_return retval = new XSPARQLRewriter.forletClause_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree T_WHERE115=null;
        CommonTree T_ORDER117=null;
        CommonTree T_WHERE122=null;
        CommonTree T_ORDER124=null;
        XSPARQLRewriter.forClause_return forClause114 = null;

        XSPARQLRewriter.whereClause_return whereClause116 = null;

        XSPARQLRewriter.orderByClause_return orderByClause118 = null;

        XSPARQLRewriter.sparqlForClause_return sparqlForClause119 = null;

        XSPARQLRewriter.sqlForClause_return sqlForClause120 = null;

        XSPARQLRewriter.letClause_return letClause121 = null;

        XSPARQLRewriter.whereClause_return whereClause123 = null;

        XSPARQLRewriter.orderByClause_return orderByClause125 = null;


        CommonTree T_WHERE115_tree=null;
        CommonTree T_ORDER117_tree=null;
        CommonTree T_WHERE122_tree=null;
        CommonTree T_ORDER124_tree=null;

         logger.info("forletClause"); 
        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1107:3: ( forClause ( ^( T_WHERE whereClause ) )? ( ^( T_ORDER orderByClause ) )? | sparqlForClause | sqlForClause | letClause ( ^( T_WHERE whereClause ) )? ( ^( T_ORDER orderByClause ) )? )
            int alt32=4;
            switch ( input.LA(1) ) {
            case T_FOR:
                {
                alt32=1;
                }
                break;
            case T_SPARQL_FOR:
                {
                alt32=2;
                }
                break;
            case T_SQL_FOR:
                {
                alt32=3;
                }
                break;
            case T_LET:
                {
                alt32=4;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 32, 0, input);

                throw nvae;
            }

            switch (alt32) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1107:5: forClause ( ^( T_WHERE whereClause ) )? ( ^( T_ORDER orderByClause ) )?
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_forClause_in_forletClause2563);
                    forClause114=forClause();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, forClause114.getTree());
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1107:15: ( ^( T_WHERE whereClause ) )?
                    int alt28=2;
                    switch ( input.LA(1) ) {
                        case T_WHERE:
                            {
                            alt28=1;
                            }
                            break;
                    }

                    switch (alt28) {
                        case 1 :
                            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1107:16: ^( T_WHERE whereClause )
                            {
                            _last = (CommonTree)input.LT(1);
                            {
                            CommonTree _save_last_1 = _last;
                            CommonTree _first_1 = null;
                            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                            T_WHERE115=(CommonTree)match(input,T_WHERE,FOLLOW_T_WHERE_in_forletClause2567); if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                            T_WHERE115_tree = (CommonTree)adaptor.dupNode(T_WHERE115);

                            root_1 = (CommonTree)adaptor.becomeRoot(T_WHERE115_tree, root_1);
                            }


                            match(input, Token.DOWN, null); if (state.failed) return retval;
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_whereClause_in_forletClause2569);
                            whereClause116=whereClause();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) 
                            adaptor.addChild(root_1, whereClause116.getTree());

                            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                            }


                            if ( state.backtracking==0 ) {
                            }
                            }
                            break;

                    }

                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1107:41: ( ^( T_ORDER orderByClause ) )?
                    int alt29=2;
                    switch ( input.LA(1) ) {
                        case T_ORDER:
                            {
                            alt29=1;
                            }
                            break;
                    }

                    switch (alt29) {
                        case 1 :
                            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1107:42: ^( T_ORDER orderByClause )
                            {
                            _last = (CommonTree)input.LT(1);
                            {
                            CommonTree _save_last_1 = _last;
                            CommonTree _first_1 = null;
                            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                            T_ORDER117=(CommonTree)match(input,T_ORDER,FOLLOW_T_ORDER_in_forletClause2576); if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                            T_ORDER117_tree = (CommonTree)adaptor.dupNode(T_ORDER117);

                            root_1 = (CommonTree)adaptor.becomeRoot(T_ORDER117_tree, root_1);
                            }


                            match(input, Token.DOWN, null); if (state.failed) return retval;
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_orderByClause_in_forletClause2578);
                            orderByClause118=orderByClause();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) 
                            adaptor.addChild(root_1, orderByClause118.getTree());

                            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                            }


                            if ( state.backtracking==0 ) {
                            }
                            }
                            break;

                    }


                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1108:5: sparqlForClause
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_sparqlForClause_in_forletClause2587);
                    sparqlForClause119=sparqlForClause();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, sparqlForClause119.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 3 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1109:5: sqlForClause
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_sqlForClause_in_forletClause2593);
                    sqlForClause120=sqlForClause();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, sqlForClause120.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 4 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1110:5: letClause ( ^( T_WHERE whereClause ) )? ( ^( T_ORDER orderByClause ) )?
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_letClause_in_forletClause2599);
                    letClause121=letClause();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, letClause121.getTree());
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1110:15: ( ^( T_WHERE whereClause ) )?
                    int alt30=2;
                    switch ( input.LA(1) ) {
                        case T_WHERE:
                            {
                            alt30=1;
                            }
                            break;
                    }

                    switch (alt30) {
                        case 1 :
                            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1110:16: ^( T_WHERE whereClause )
                            {
                            _last = (CommonTree)input.LT(1);
                            {
                            CommonTree _save_last_1 = _last;
                            CommonTree _first_1 = null;
                            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                            T_WHERE122=(CommonTree)match(input,T_WHERE,FOLLOW_T_WHERE_in_forletClause2603); if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                            T_WHERE122_tree = (CommonTree)adaptor.dupNode(T_WHERE122);

                            root_1 = (CommonTree)adaptor.becomeRoot(T_WHERE122_tree, root_1);
                            }


                            match(input, Token.DOWN, null); if (state.failed) return retval;
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_whereClause_in_forletClause2605);
                            whereClause123=whereClause();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) 
                            adaptor.addChild(root_1, whereClause123.getTree());

                            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                            }


                            if ( state.backtracking==0 ) {
                            }
                            }
                            break;

                    }

                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1110:41: ( ^( T_ORDER orderByClause ) )?
                    int alt31=2;
                    switch ( input.LA(1) ) {
                        case T_ORDER:
                            {
                            alt31=1;
                            }
                            break;
                    }

                    switch (alt31) {
                        case 1 :
                            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1110:42: ^( T_ORDER orderByClause )
                            {
                            _last = (CommonTree)input.LT(1);
                            {
                            CommonTree _save_last_1 = _last;
                            CommonTree _first_1 = null;
                            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                            T_ORDER124=(CommonTree)match(input,T_ORDER,FOLLOW_T_ORDER_in_forletClause2612); if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                            T_ORDER124_tree = (CommonTree)adaptor.dupNode(T_ORDER124);

                            root_1 = (CommonTree)adaptor.becomeRoot(T_ORDER124_tree, root_1);
                            }


                            match(input, Token.DOWN, null); if (state.failed) return retval;
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_orderByClause_in_forletClause2614);
                            orderByClause125=orderByClause();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) 
                            adaptor.addChild(root_1, orderByClause125.getTree());

                            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                            }


                            if ( state.backtracking==0 ) {
                            }
                            }
                            break;

                    }


                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "forletClause"

    public static class distinct_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "distinct"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1113:1: distinct : ( DISTINCT -> QSTRING[ \" DISTINCT \" ] | REDUCED -> QSTRING[ \" REDUCED \" ] );
    public final XSPARQLRewriter.distinct_return distinct() throws RecognitionException {
        XSPARQLRewriter.distinct_return retval = new XSPARQLRewriter.distinct_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree DISTINCT126=null;
        CommonTree REDUCED127=null;

        CommonTree DISTINCT126_tree=null;
        CommonTree REDUCED127_tree=null;
        RewriteRuleNodeStream stream_DISTINCT=new RewriteRuleNodeStream(adaptor,"token DISTINCT");
        RewriteRuleNodeStream stream_REDUCED=new RewriteRuleNodeStream(adaptor,"token REDUCED");

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1114:3: ( DISTINCT -> QSTRING[ \" DISTINCT \" ] | REDUCED -> QSTRING[ \" REDUCED \" ] )
            int alt33=2;
            switch ( input.LA(1) ) {
            case DISTINCT:
                {
                alt33=1;
                }
                break;
            case REDUCED:
                {
                alt33=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 33, 0, input);

                throw nvae;
            }

            switch (alt33) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1114:5: DISTINCT
                    {
                    _last = (CommonTree)input.LT(1);
                    DISTINCT126=(CommonTree)match(input,DISTINCT,FOLLOW_DISTINCT_in_distinct2630); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_DISTINCT.add(DISTINCT126);



                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1115:3: -> QSTRING[ \" DISTINCT \" ]
                    {
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, " DISTINCT "));

                    }

                    retval.tree = root_0;}
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1116:5: REDUCED
                    {
                    _last = (CommonTree)input.LT(1);
                    REDUCED127=(CommonTree)match(input,REDUCED,FOLLOW_REDUCED_in_distinct2644); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_REDUCED.add(REDUCED127);



                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1117:3: -> QSTRING[ \" REDUCED \" ]
                    {
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, " REDUCED "));

                    }

                    retval.tree = root_0;}
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "distinct"

    protected static class sqlForClause_scope {
        List<Pair<String,String>> relationsAlias;
        List<String> relations;
    }
    protected Stack sqlForClause_stack = new Stack();

    public static class sqlForClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "sqlForClause"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1129:1: sqlForClause : ( ^(fo= T_SQL_FOR ( distinct )? (var+= sqlVarOrFunction )+ ) relationClause ( sqlWhereClause )? -> COMMENT[$fo.token, \"SQL FOR from \" + $fo.line + \":\" + $fo.pos] ^( T_LET VAR[auxResults] ^( T_FUNCTION_CALL NCNAME[SQLevaluationFunction] ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS QSTRING[\" SELECT \"] ( distinct )? ( $var)+ relationClause ( sqlWhereClause )? ) ) ) ) ) ^( T_FOR VAR[auxResult] ^( AT VAR[auxResultPos] ) ^( IN ^( T_FUNCTION_CALL NCNAME[SQLiterationFunction] ^( T_PARAMS VAR[auxResults] ) ) ) ) ( ^( REWRITEVNODE[$fo.token, auxResult] $var) )+ | ^(fo= T_SQL_FOR ( distinct )? s= STAR ) relationClause ( sqlWhereClause )? -> COMMENT[$fo.token, \"SQL FOR from \" + $fo.line + \":\" + $fo.pos] ^( T_LET VAR[auxResults] ^( T_FUNCTION_CALL NCNAME[SQLevaluationFunction] ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS QSTRING[\" SELECT \"] ( distinct )? QSTRING[concat($sqlForClause::relations, \", \")+\" \"] relationClause ( sqlWhereClause )? ) ) ) ) ) ^( T_FOR VAR[auxResult] ^( AT VAR[auxResultPos] ) ^( IN ^( T_FUNCTION_CALL NCNAME[SQLiterationFunction] ^( T_PARAMS VAR[auxResults] ) ) ) ) | ^(fo= T_SQL_FOR ( distinct )? ROW v= VAR ) ^( T_SQL_FROM ^( T_FUNCTION_CALL qname ^( T_PARAMS sqlVarOrString ) ) ) -> COMMENT[$fo.token, \"SQL FOR from \" + $fo.line + \":\" + $fo.pos] ^( T_LET VAR[auxResults] ^( T_FUNCTION_CALL NCNAME[SQLevaluationFunction] ^( T_PARAMS sqlVarOrString ) ) ) ^( T_FOR $v ^( AT VAR[auxResultPos] ) ^( IN ^( T_FUNCTION_CALL NCNAME[SQLiterationFunction] ^( T_PARAMS VAR[auxResults] ) ) ) ) | ^(fo= T_SQL_FOR ( distinct )? ROW v= VAR ) relationClause ( sqlWhereClause )? -> COMMENT[$fo.token, \"SQL FOR from \" + $fo.line + \":\" + $fo.pos] ^( T_LET VAR[auxResults] ^( T_FUNCTION_CALL NCNAME[SQLevaluationFunction] ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS QSTRING[\" SELECT \"] ( distinct )? QSTRING[\" * \"] relationClause ( sqlWhereClause )? ) ) ) ) ) ^( T_FOR $v ^( AT VAR[auxResultPos] ) ^( IN ^( T_FUNCTION_CALL NCNAME[SQLiterationFunction] ^( T_PARAMS VAR[auxResults] ) ) ) ) );
    public final XSPARQLRewriter.sqlForClause_return sqlForClause() throws RecognitionException {
        sqlForClause_stack.push(new sqlForClause_scope());
        XSPARQLRewriter.sqlForClause_return retval = new XSPARQLRewriter.sqlForClause_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree fo=null;
        CommonTree s=null;
        CommonTree v=null;
        CommonTree ROW135=null;
        CommonTree T_SQL_FROM136=null;
        CommonTree T_FUNCTION_CALL137=null;
        CommonTree T_PARAMS139=null;
        CommonTree ROW142=null;
        List list_var=null;
        XSPARQLRewriter.distinct_return distinct128 = null;

        XSPARQLRewriter.relationClause_return relationClause129 = null;

        XSPARQLRewriter.sqlWhereClause_return sqlWhereClause130 = null;

        XSPARQLRewriter.distinct_return distinct131 = null;

        XSPARQLRewriter.relationClause_return relationClause132 = null;

        XSPARQLRewriter.sqlWhereClause_return sqlWhereClause133 = null;

        XSPARQLRewriter.distinct_return distinct134 = null;

        XSPARQLRewriter.qname_return qname138 = null;

        XSPARQLRewriter.sqlVarOrString_return sqlVarOrString140 = null;

        XSPARQLRewriter.distinct_return distinct141 = null;

        XSPARQLRewriter.relationClause_return relationClause143 = null;

        XSPARQLRewriter.sqlWhereClause_return sqlWhereClause144 = null;

        RuleReturnScope var = null;
        CommonTree fo_tree=null;
        CommonTree s_tree=null;
        CommonTree v_tree=null;
        CommonTree ROW135_tree=null;
        CommonTree T_SQL_FROM136_tree=null;
        CommonTree T_FUNCTION_CALL137_tree=null;
        CommonTree T_PARAMS139_tree=null;
        CommonTree ROW142_tree=null;
        RewriteRuleNodeStream stream_T_SQL_FOR=new RewriteRuleNodeStream(adaptor,"token T_SQL_FOR");
        RewriteRuleNodeStream stream_T_PARAMS=new RewriteRuleNodeStream(adaptor,"token T_PARAMS");
        RewriteRuleNodeStream stream_T_SQL_FROM=new RewriteRuleNodeStream(adaptor,"token T_SQL_FROM");
        RewriteRuleNodeStream stream_STAR=new RewriteRuleNodeStream(adaptor,"token STAR");
        RewriteRuleNodeStream stream_T_FUNCTION_CALL=new RewriteRuleNodeStream(adaptor,"token T_FUNCTION_CALL");
        RewriteRuleNodeStream stream_VAR=new RewriteRuleNodeStream(adaptor,"token VAR");
        RewriteRuleNodeStream stream_ROW=new RewriteRuleNodeStream(adaptor,"token ROW");
        RewriteRuleSubtreeStream stream_sqlVarOrString=new RewriteRuleSubtreeStream(adaptor,"rule sqlVarOrString");
        RewriteRuleSubtreeStream stream_relationClause=new RewriteRuleSubtreeStream(adaptor,"rule relationClause");
        RewriteRuleSubtreeStream stream_qname=new RewriteRuleSubtreeStream(adaptor,"rule qname");
        RewriteRuleSubtreeStream stream_distinct=new RewriteRuleSubtreeStream(adaptor,"rule distinct");
        RewriteRuleSubtreeStream stream_sqlVarOrFunction=new RewriteRuleSubtreeStream(adaptor,"rule sqlVarOrFunction");
        RewriteRuleSubtreeStream stream_sqlWhereClause=new RewriteRuleSubtreeStream(adaptor,"rule sqlWhereClause");

          String auxResults = getNewAuxResultsVariable();
          String auxResult = getNewAuxResultVariable();
          String auxResultPos = auxResult + "_pos";
          
          ((sqlForClause_scope)sqlForClause_stack.peek()).relationsAlias = new LinkedList<Pair<String,String>>();
          ((sqlForClause_scope)sqlForClause_stack.peek()).relations = new LinkedList<String>();
         
        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1142:3: ( ^(fo= T_SQL_FOR ( distinct )? (var+= sqlVarOrFunction )+ ) relationClause ( sqlWhereClause )? -> COMMENT[$fo.token, \"SQL FOR from \" + $fo.line + \":\" + $fo.pos] ^( T_LET VAR[auxResults] ^( T_FUNCTION_CALL NCNAME[SQLevaluationFunction] ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS QSTRING[\" SELECT \"] ( distinct )? ( $var)+ relationClause ( sqlWhereClause )? ) ) ) ) ) ^( T_FOR VAR[auxResult] ^( AT VAR[auxResultPos] ) ^( IN ^( T_FUNCTION_CALL NCNAME[SQLiterationFunction] ^( T_PARAMS VAR[auxResults] ) ) ) ) ( ^( REWRITEVNODE[$fo.token, auxResult] $var) )+ | ^(fo= T_SQL_FOR ( distinct )? s= STAR ) relationClause ( sqlWhereClause )? -> COMMENT[$fo.token, \"SQL FOR from \" + $fo.line + \":\" + $fo.pos] ^( T_LET VAR[auxResults] ^( T_FUNCTION_CALL NCNAME[SQLevaluationFunction] ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS QSTRING[\" SELECT \"] ( distinct )? QSTRING[concat($sqlForClause::relations, \", \")+\" \"] relationClause ( sqlWhereClause )? ) ) ) ) ) ^( T_FOR VAR[auxResult] ^( AT VAR[auxResultPos] ) ^( IN ^( T_FUNCTION_CALL NCNAME[SQLiterationFunction] ^( T_PARAMS VAR[auxResults] ) ) ) ) | ^(fo= T_SQL_FOR ( distinct )? ROW v= VAR ) ^( T_SQL_FROM ^( T_FUNCTION_CALL qname ^( T_PARAMS sqlVarOrString ) ) ) -> COMMENT[$fo.token, \"SQL FOR from \" + $fo.line + \":\" + $fo.pos] ^( T_LET VAR[auxResults] ^( T_FUNCTION_CALL NCNAME[SQLevaluationFunction] ^( T_PARAMS sqlVarOrString ) ) ) ^( T_FOR $v ^( AT VAR[auxResultPos] ) ^( IN ^( T_FUNCTION_CALL NCNAME[SQLiterationFunction] ^( T_PARAMS VAR[auxResults] ) ) ) ) | ^(fo= T_SQL_FOR ( distinct )? ROW v= VAR ) relationClause ( sqlWhereClause )? -> COMMENT[$fo.token, \"SQL FOR from \" + $fo.line + \":\" + $fo.pos] ^( T_LET VAR[auxResults] ^( T_FUNCTION_CALL NCNAME[SQLevaluationFunction] ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS QSTRING[\" SELECT \"] ( distinct )? QSTRING[\" * \"] relationClause ( sqlWhereClause )? ) ) ) ) ) ^( T_FOR $v ^( AT VAR[auxResultPos] ) ^( IN ^( T_FUNCTION_CALL NCNAME[SQLiterationFunction] ^( T_PARAMS VAR[auxResults] ) ) ) ) )
            int alt42=4;
            alt42 = dfa42.predict(input);
            switch (alt42) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1142:5: ^(fo= T_SQL_FOR ( distinct )? (var+= sqlVarOrFunction )+ ) relationClause ( sqlWhereClause )?
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    fo=(CommonTree)match(input,T_SQL_FOR,FOLLOW_T_SQL_FOR_in_sqlForClause2685); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_T_SQL_FOR.add(fo);



                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1142:20: ( distinct )?
                    int alt34=2;
                    switch ( input.LA(1) ) {
                        case DISTINCT:
                        case REDUCED:
                            {
                            alt34=1;
                            }
                            break;
                    }

                    switch (alt34) {
                        case 1 :
                            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: distinct
                            {
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_distinct_in_sqlForClause2687);
                            distinct128=distinct();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_distinct.add(distinct128.getTree());

                            if ( state.backtracking==0 ) {
                            }
                            }
                            break;

                    }

                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1142:33: (var+= sqlVarOrFunction )+
                    int cnt35=0;
                    loop35:
                    do {
                        int alt35=2;
                        switch ( input.LA(1) ) {
                        case COMMA:
                        case LPAR:
                        case T_VAR:
                            {
                            alt35=1;
                            }
                            break;

                        }

                        switch (alt35) {
                    	case 1 :
                    	    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: var+= sqlVarOrFunction
                    	    {
                    	    _last = (CommonTree)input.LT(1);
                    	    _last = (CommonTree)input.LT(1);
                    	    pushFollow(FOLLOW_sqlVarOrFunction_in_sqlForClause2692);
                    	    var=sqlVarOrFunction();

                    	    state._fsp--;
                    	    if (state.failed) return retval;
                    	    if ( state.backtracking==0 ) stream_sqlVarOrFunction.add(var.getTree());
                    	    if (list_var==null) list_var=new ArrayList();
                    	    list_var.add(var.getTree());


                    	    if ( state.backtracking==0 ) {
                    	    }
                    	    }
                    	    break;

                    	default :
                    	    if ( cnt35 >= 1 ) break loop35;
                    	    if (state.backtracking>0) {state.failed=true; return retval;}
                                EarlyExitException eee =
                                    new EarlyExitException(35, input);
                                throw eee;
                        }
                        cnt35++;
                    } while (true);


                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }

                    if ( state.backtracking==0 ) {
                       addVariablesToScope(list_var, Types.SQL); 
                                                                              addPositionVariableToScope(auxResultPos); 
                    }
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_relationClause_in_sqlForClause2706);
                    relationClause129=relationClause();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_relationClause.add(relationClause129.getTree());
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1144:23: ( sqlWhereClause )?
                    int alt36=2;
                    switch ( input.LA(1) ) {
                        case WHERE:
                            {
                            alt36=1;
                            }
                            break;
                    }

                    switch (alt36) {
                        case 1 :
                            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: sqlWhereClause
                            {
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_sqlWhereClause_in_sqlForClause2708);
                            sqlWhereClause130=sqlWhereClause();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_sqlWhereClause.add(sqlWhereClause130.getTree());

                            if ( state.backtracking==0 ) {
                            }
                            }
                            break;

                    }



                    // AST REWRITE
                    // elements: distinct, var, relationClause, var, sqlWhereClause
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: var
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_var=new RewriteRuleSubtreeStream(adaptor,"token var",list_var);
                    root_0 = (CommonTree)adaptor.nil();
                    // 1145:5: -> COMMENT[$fo.token, \"SQL FOR from \" + $fo.line + \":\" + $fo.pos] ^( T_LET VAR[auxResults] ^( T_FUNCTION_CALL NCNAME[SQLevaluationFunction] ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS QSTRING[\" SELECT \"] ( distinct )? ( $var)+ relationClause ( sqlWhereClause )? ) ) ) ) ) ^( T_FOR VAR[auxResult] ^( AT VAR[auxResultPos] ) ^( IN ^( T_FUNCTION_CALL NCNAME[SQLiterationFunction] ^( T_PARAMS VAR[auxResults] ) ) ) ) ( ^( REWRITEVNODE[$fo.token, auxResult] $var) )+
                    {
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(COMMENT, fo.token, "SQL FOR from " + (fo!=null?fo.getLine():0) + ":" + (fo!=null?fo.getCharPositionInLine():0)));
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1146:5: ^( T_LET VAR[auxResults] ^( T_FUNCTION_CALL NCNAME[SQLevaluationFunction] ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS QSTRING[\" SELECT \"] ( distinct )? ( $var)+ relationClause ( sqlWhereClause )? ) ) ) ) )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_LET, "T_LET"), root_1);

                        adaptor.addChild(root_1, (CommonTree)adaptor.create(VAR, auxResults));
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1147:7: ^( T_FUNCTION_CALL NCNAME[SQLevaluationFunction] ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS QSTRING[\" SELECT \"] ( distinct )? ( $var)+ relationClause ( sqlWhereClause )? ) ) ) )
                        {
                        CommonTree root_2 = (CommonTree)adaptor.nil();
                        root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FUNCTION_CALL, "T_FUNCTION_CALL"), root_2);

                        adaptor.addChild(root_2, (CommonTree)adaptor.create(NCNAME, SQLevaluationFunction));
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1149:9: ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS QSTRING[\" SELECT \"] ( distinct )? ( $var)+ relationClause ( sqlWhereClause )? ) ) )
                        {
                        CommonTree root_3 = (CommonTree)adaptor.nil();
                        root_3 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_PARAMS, "T_PARAMS"), root_3);

                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1150:11: ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS QSTRING[\" SELECT \"] ( distinct )? ( $var)+ relationClause ( sqlWhereClause )? ) )
                        {
                        CommonTree root_4 = (CommonTree)adaptor.nil();
                        root_4 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FUNCTION_CALL, "T_FUNCTION_CALL"), root_4);

                        adaptor.addChild(root_4, (CommonTree)adaptor.create(NCNAME, "fn:concat"));
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1152:13: ^( T_PARAMS QSTRING[\" SELECT \"] ( distinct )? ( $var)+ relationClause ( sqlWhereClause )? )
                        {
                        CommonTree root_5 = (CommonTree)adaptor.nil();
                        root_5 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_PARAMS, "T_PARAMS"), root_5);

                        adaptor.addChild(root_5, (CommonTree)adaptor.create(QSTRING, " SELECT "));
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1154:15: ( distinct )?
                        if ( stream_distinct.hasNext() ) {
                            adaptor.addChild(root_5, stream_distinct.nextTree());

                        }
                        stream_distinct.reset();
                        if ( !(stream_var.hasNext()) ) {
                            throw new RewriteEarlyExitException();
                        }
                        while ( stream_var.hasNext() ) {
                            adaptor.addChild(root_5, stream_var.nextTree());

                        }
                        stream_var.reset();
                        adaptor.addChild(root_5, stream_relationClause.nextTree());
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1157:15: ( sqlWhereClause )?
                        if ( stream_sqlWhereClause.hasNext() ) {
                            adaptor.addChild(root_5, stream_sqlWhereClause.nextTree());

                        }
                        stream_sqlWhereClause.reset();

                        adaptor.addChild(root_4, root_5);
                        }

                        adaptor.addChild(root_3, root_4);
                        }

                        adaptor.addChild(root_2, root_3);
                        }

                        adaptor.addChild(root_1, root_2);
                        }

                        adaptor.addChild(root_0, root_1);
                        }
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1164:5: ^( T_FOR VAR[auxResult] ^( AT VAR[auxResultPos] ) ^( IN ^( T_FUNCTION_CALL NCNAME[SQLiterationFunction] ^( T_PARAMS VAR[auxResults] ) ) ) )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FOR, "T_FOR"), root_1);

                        adaptor.addChild(root_1, (CommonTree)adaptor.create(VAR, auxResult));
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1166:7: ^( AT VAR[auxResultPos] )
                        {
                        CommonTree root_2 = (CommonTree)adaptor.nil();
                        root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(AT, "AT"), root_2);

                        adaptor.addChild(root_2, (CommonTree)adaptor.create(VAR, auxResultPos));

                        adaptor.addChild(root_1, root_2);
                        }
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1169:7: ^( IN ^( T_FUNCTION_CALL NCNAME[SQLiterationFunction] ^( T_PARAMS VAR[auxResults] ) ) )
                        {
                        CommonTree root_2 = (CommonTree)adaptor.nil();
                        root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(IN, "IN"), root_2);

                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1170:9: ^( T_FUNCTION_CALL NCNAME[SQLiterationFunction] ^( T_PARAMS VAR[auxResults] ) )
                        {
                        CommonTree root_3 = (CommonTree)adaptor.nil();
                        root_3 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FUNCTION_CALL, "T_FUNCTION_CALL"), root_3);

                        adaptor.addChild(root_3, (CommonTree)adaptor.create(NCNAME, SQLiterationFunction));
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1172:11: ^( T_PARAMS VAR[auxResults] )
                        {
                        CommonTree root_4 = (CommonTree)adaptor.nil();
                        root_4 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_PARAMS, "T_PARAMS"), root_4);

                        adaptor.addChild(root_4, (CommonTree)adaptor.create(VAR, auxResults));

                        adaptor.addChild(root_3, root_4);
                        }

                        adaptor.addChild(root_2, root_3);
                        }

                        adaptor.addChild(root_1, root_2);
                        }

                        adaptor.addChild(root_0, root_1);
                        }
                        if ( !(stream_var.hasNext()) ) {
                            throw new RewriteEarlyExitException();
                        }
                        while ( stream_var.hasNext() ) {
                            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1178:5: ^( REWRITEVNODE[$fo.token, auxResult] $var)
                            {
                            CommonTree root_1 = (CommonTree)adaptor.nil();
                            root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(REWRITEVNODE, fo.token, auxResult), root_1);

                            adaptor.addChild(root_1, stream_var.nextTree());

                            adaptor.addChild(root_0, root_1);
                            }

                        }
                        stream_var.reset();

                    }

                    retval.tree = root_0;}
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1180:5: ^(fo= T_SQL_FOR ( distinct )? s= STAR ) relationClause ( sqlWhereClause )?
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    fo=(CommonTree)match(input,T_SQL_FOR,FOLLOW_T_SQL_FOR_in_sqlForClause3140); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_T_SQL_FOR.add(fo);



                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1180:20: ( distinct )?
                    int alt37=2;
                    switch ( input.LA(1) ) {
                        case DISTINCT:
                        case REDUCED:
                            {
                            alt37=1;
                            }
                            break;
                    }

                    switch (alt37) {
                        case 1 :
                            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: distinct
                            {
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_distinct_in_sqlForClause3142);
                            distinct131=distinct();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_distinct.add(distinct131.getTree());

                            if ( state.backtracking==0 ) {
                            }
                            }
                            break;

                    }

                    _last = (CommonTree)input.LT(1);
                    s=(CommonTree)match(input,STAR,FOLLOW_STAR_in_sqlForClause3147); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_STAR.add(s);


                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_relationClause_in_sqlForClause3151);
                    relationClause132=relationClause();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_relationClause.add(relationClause132.getTree());
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1180:54: ( sqlWhereClause )?
                    int alt38=2;
                    switch ( input.LA(1) ) {
                        case WHERE:
                            {
                            alt38=1;
                            }
                            break;
                    }

                    switch (alt38) {
                        case 1 :
                            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: sqlWhereClause
                            {
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_sqlWhereClause_in_sqlForClause3153);
                            sqlWhereClause133=sqlWhereClause();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_sqlWhereClause.add(sqlWhereClause133.getTree());

                            if ( state.backtracking==0 ) {
                            }
                            }
                            break;

                    }

                    if ( state.backtracking==0 ) {
                       if (sqlQuery != null) {
                              ((sqlForClause_scope)sqlForClause_stack.peek()).relations = sqlQuery.getRelationAttributes(((sqlForClause_scope)sqlForClause_stack.peek()).relationsAlias); 
                              addVariablesStringToScope(((sqlForClause_scope)sqlForClause_stack.peek()).relations, Types.SQL); 
                              addPositionVariableToScope(auxResultPos); 
                            } else {
                              logger.severe("Unable to connect to the database!");
                              System.exit(1);
                            }

                          
                    }


                    // AST REWRITE
                    // elements: distinct, relationClause, sqlWhereClause
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1191:3: -> COMMENT[$fo.token, \"SQL FOR from \" + $fo.line + \":\" + $fo.pos] ^( T_LET VAR[auxResults] ^( T_FUNCTION_CALL NCNAME[SQLevaluationFunction] ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS QSTRING[\" SELECT \"] ( distinct )? QSTRING[concat($sqlForClause::relations, \", \")+\" \"] relationClause ( sqlWhereClause )? ) ) ) ) ) ^( T_FOR VAR[auxResult] ^( AT VAR[auxResultPos] ) ^( IN ^( T_FUNCTION_CALL NCNAME[SQLiterationFunction] ^( T_PARAMS VAR[auxResults] ) ) ) )
                    {
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(COMMENT, fo.token, "SQL FOR from " + (fo!=null?fo.getLine():0) + ":" + (fo!=null?fo.getCharPositionInLine():0)));
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1192:5: ^( T_LET VAR[auxResults] ^( T_FUNCTION_CALL NCNAME[SQLevaluationFunction] ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS QSTRING[\" SELECT \"] ( distinct )? QSTRING[concat($sqlForClause::relations, \", \")+\" \"] relationClause ( sqlWhereClause )? ) ) ) ) )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_LET, "T_LET"), root_1);

                        adaptor.addChild(root_1, (CommonTree)adaptor.create(VAR, auxResults));
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1193:7: ^( T_FUNCTION_CALL NCNAME[SQLevaluationFunction] ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS QSTRING[\" SELECT \"] ( distinct )? QSTRING[concat($sqlForClause::relations, \", \")+\" \"] relationClause ( sqlWhereClause )? ) ) ) )
                        {
                        CommonTree root_2 = (CommonTree)adaptor.nil();
                        root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FUNCTION_CALL, "T_FUNCTION_CALL"), root_2);

                        adaptor.addChild(root_2, (CommonTree)adaptor.create(NCNAME, SQLevaluationFunction));
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1195:9: ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS QSTRING[\" SELECT \"] ( distinct )? QSTRING[concat($sqlForClause::relations, \", \")+\" \"] relationClause ( sqlWhereClause )? ) ) )
                        {
                        CommonTree root_3 = (CommonTree)adaptor.nil();
                        root_3 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_PARAMS, "T_PARAMS"), root_3);

                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1196:11: ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS QSTRING[\" SELECT \"] ( distinct )? QSTRING[concat($sqlForClause::relations, \", \")+\" \"] relationClause ( sqlWhereClause )? ) )
                        {
                        CommonTree root_4 = (CommonTree)adaptor.nil();
                        root_4 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FUNCTION_CALL, "T_FUNCTION_CALL"), root_4);

                        adaptor.addChild(root_4, (CommonTree)adaptor.create(NCNAME, "fn:concat"));
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1198:13: ^( T_PARAMS QSTRING[\" SELECT \"] ( distinct )? QSTRING[concat($sqlForClause::relations, \", \")+\" \"] relationClause ( sqlWhereClause )? )
                        {
                        CommonTree root_5 = (CommonTree)adaptor.nil();
                        root_5 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_PARAMS, "T_PARAMS"), root_5);

                        adaptor.addChild(root_5, (CommonTree)adaptor.create(QSTRING, " SELECT "));
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1200:15: ( distinct )?
                        if ( stream_distinct.hasNext() ) {
                            adaptor.addChild(root_5, stream_distinct.nextTree());

                        }
                        stream_distinct.reset();
                        adaptor.addChild(root_5, (CommonTree)adaptor.create(QSTRING, concat(((sqlForClause_scope)sqlForClause_stack.peek()).relations, ", ")+" "));
                        adaptor.addChild(root_5, stream_relationClause.nextTree());
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1203:15: ( sqlWhereClause )?
                        if ( stream_sqlWhereClause.hasNext() ) {
                            adaptor.addChild(root_5, stream_sqlWhereClause.nextTree());

                        }
                        stream_sqlWhereClause.reset();

                        adaptor.addChild(root_4, root_5);
                        }

                        adaptor.addChild(root_3, root_4);
                        }

                        adaptor.addChild(root_2, root_3);
                        }

                        adaptor.addChild(root_1, root_2);
                        }

                        adaptor.addChild(root_0, root_1);
                        }
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1210:5: ^( T_FOR VAR[auxResult] ^( AT VAR[auxResultPos] ) ^( IN ^( T_FUNCTION_CALL NCNAME[SQLiterationFunction] ^( T_PARAMS VAR[auxResults] ) ) ) )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FOR, "T_FOR"), root_1);

                        adaptor.addChild(root_1, (CommonTree)adaptor.create(VAR, auxResult));
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1212:7: ^( AT VAR[auxResultPos] )
                        {
                        CommonTree root_2 = (CommonTree)adaptor.nil();
                        root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(AT, "AT"), root_2);

                        adaptor.addChild(root_2, (CommonTree)adaptor.create(VAR, auxResultPos));

                        adaptor.addChild(root_1, root_2);
                        }
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1215:7: ^( IN ^( T_FUNCTION_CALL NCNAME[SQLiterationFunction] ^( T_PARAMS VAR[auxResults] ) ) )
                        {
                        CommonTree root_2 = (CommonTree)adaptor.nil();
                        root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(IN, "IN"), root_2);

                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1216:9: ^( T_FUNCTION_CALL NCNAME[SQLiterationFunction] ^( T_PARAMS VAR[auxResults] ) )
                        {
                        CommonTree root_3 = (CommonTree)adaptor.nil();
                        root_3 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FUNCTION_CALL, "T_FUNCTION_CALL"), root_3);

                        adaptor.addChild(root_3, (CommonTree)adaptor.create(NCNAME, SQLiterationFunction));
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1218:11: ^( T_PARAMS VAR[auxResults] )
                        {
                        CommonTree root_4 = (CommonTree)adaptor.nil();
                        root_4 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_PARAMS, "T_PARAMS"), root_4);

                        adaptor.addChild(root_4, (CommonTree)adaptor.create(VAR, auxResults));

                        adaptor.addChild(root_3, root_4);
                        }

                        adaptor.addChild(root_2, root_3);
                        }

                        adaptor.addChild(root_1, root_2);
                        }

                        adaptor.addChild(root_0, root_1);
                        }
                        adaptor.addChild(root_0, getVarNodes(((sqlForClause_scope)sqlForClause_stack.peek()).relations, auxResult));

                    }

                    retval.tree = root_0;}
                    }
                    break;
                case 3 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1228:5: ^(fo= T_SQL_FOR ( distinct )? ROW v= VAR ) ^( T_SQL_FROM ^( T_FUNCTION_CALL qname ^( T_PARAMS sqlVarOrString ) ) )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    fo=(CommonTree)match(input,T_SQL_FOR,FOLLOW_T_SQL_FOR_in_sqlForClause3579); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_T_SQL_FOR.add(fo);



                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1228:20: ( distinct )?
                    int alt39=2;
                    switch ( input.LA(1) ) {
                        case DISTINCT:
                        case REDUCED:
                            {
                            alt39=1;
                            }
                            break;
                    }

                    switch (alt39) {
                        case 1 :
                            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: distinct
                            {
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_distinct_in_sqlForClause3581);
                            distinct134=distinct();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_distinct.add(distinct134.getTree());

                            if ( state.backtracking==0 ) {
                            }
                            }
                            break;

                    }

                    _last = (CommonTree)input.LT(1);
                    ROW135=(CommonTree)match(input,ROW,FOLLOW_ROW_in_sqlForClause3584); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_ROW.add(ROW135);

                    _last = (CommonTree)input.LT(1);
                    v=(CommonTree)match(input,VAR,FOLLOW_VAR_in_sqlForClause3588); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_VAR.add(v);


                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }

                    if ( state.backtracking==0 ) {
                       addVariableToScope((v!=null?v.getText():null), Types.SQL_ROW); addPositionVariableToScope(auxResultPos); 
                    }
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    T_SQL_FROM136=(CommonTree)match(input,T_SQL_FROM,FOLLOW_T_SQL_FROM_in_sqlForClause3602); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_T_SQL_FROM.add(T_SQL_FROM136);



                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_2 = _last;
                    CommonTree _first_2 = null;
                    CommonTree root_2 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    T_FUNCTION_CALL137=(CommonTree)match(input,T_FUNCTION_CALL,FOLLOW_T_FUNCTION_CALL_in_sqlForClause3605); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_T_FUNCTION_CALL.add(T_FUNCTION_CALL137);



                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_qname_in_sqlForClause3607);
                    qname138=qname();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_qname.add(qname138.getTree());
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_3 = _last;
                    CommonTree _first_3 = null;
                    CommonTree root_3 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    T_PARAMS139=(CommonTree)match(input,T_PARAMS,FOLLOW_T_PARAMS_in_sqlForClause3610); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_T_PARAMS.add(T_PARAMS139);



                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_sqlVarOrString_in_sqlForClause3612);
                    sqlVarOrString140=sqlVarOrString();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_sqlVarOrString.add(sqlVarOrString140.getTree());

                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_2, root_3);_last = _save_last_3;
                    }


                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_1, root_2);_last = _save_last_2;
                    }


                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }



                    // AST REWRITE
                    // elements: VAR, VAR, T_FUNCTION_CALL, VAR, T_FUNCTION_CALL, T_PARAMS, T_PARAMS, sqlVarOrString, v
                    // token labels: v
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleNodeStream stream_v=new RewriteRuleNodeStream(adaptor,"token v",v);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1230:3: -> COMMENT[$fo.token, \"SQL FOR from \" + $fo.line + \":\" + $fo.pos] ^( T_LET VAR[auxResults] ^( T_FUNCTION_CALL NCNAME[SQLevaluationFunction] ^( T_PARAMS sqlVarOrString ) ) ) ^( T_FOR $v ^( AT VAR[auxResultPos] ) ^( IN ^( T_FUNCTION_CALL NCNAME[SQLiterationFunction] ^( T_PARAMS VAR[auxResults] ) ) ) )
                    {
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(COMMENT, fo.token, "SQL FOR from " + (fo!=null?fo.getLine():0) + ":" + (fo!=null?fo.getCharPositionInLine():0)));
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1231:5: ^( T_LET VAR[auxResults] ^( T_FUNCTION_CALL NCNAME[SQLevaluationFunction] ^( T_PARAMS sqlVarOrString ) ) )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_LET, "T_LET"), root_1);

                        adaptor.addChild(root_1, (CommonTree)adaptor.create(VAR, auxResults));
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1232:7: ^( T_FUNCTION_CALL NCNAME[SQLevaluationFunction] ^( T_PARAMS sqlVarOrString ) )
                        {
                        CommonTree root_2 = (CommonTree)adaptor.nil();
                        root_2 = (CommonTree)adaptor.becomeRoot(stream_T_FUNCTION_CALL.nextNode(), root_2);

                        adaptor.addChild(root_2, (CommonTree)adaptor.create(NCNAME, SQLevaluationFunction));
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1234:9: ^( T_PARAMS sqlVarOrString )
                        {
                        CommonTree root_3 = (CommonTree)adaptor.nil();
                        root_3 = (CommonTree)adaptor.becomeRoot(stream_T_PARAMS.nextNode(), root_3);

                        adaptor.addChild(root_3, stream_sqlVarOrString.nextTree());

                        adaptor.addChild(root_2, root_3);
                        }

                        adaptor.addChild(root_1, root_2);
                        }

                        adaptor.addChild(root_0, root_1);
                        }
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1239:5: ^( T_FOR $v ^( AT VAR[auxResultPos] ) ^( IN ^( T_FUNCTION_CALL NCNAME[SQLiterationFunction] ^( T_PARAMS VAR[auxResults] ) ) ) )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FOR, "T_FOR"), root_1);

                        adaptor.addChild(root_1, stream_v.nextNode());
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1241:7: ^( AT VAR[auxResultPos] )
                        {
                        CommonTree root_2 = (CommonTree)adaptor.nil();
                        root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(AT, "AT"), root_2);

                        adaptor.addChild(root_2, (CommonTree)adaptor.create(VAR, auxResultPos));

                        adaptor.addChild(root_1, root_2);
                        }
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1244:7: ^( IN ^( T_FUNCTION_CALL NCNAME[SQLiterationFunction] ^( T_PARAMS VAR[auxResults] ) ) )
                        {
                        CommonTree root_2 = (CommonTree)adaptor.nil();
                        root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(IN, "IN"), root_2);

                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1245:9: ^( T_FUNCTION_CALL NCNAME[SQLiterationFunction] ^( T_PARAMS VAR[auxResults] ) )
                        {
                        CommonTree root_3 = (CommonTree)adaptor.nil();
                        root_3 = (CommonTree)adaptor.becomeRoot(stream_T_FUNCTION_CALL.nextNode(), root_3);

                        adaptor.addChild(root_3, (CommonTree)adaptor.create(NCNAME, SQLiterationFunction));
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1247:11: ^( T_PARAMS VAR[auxResults] )
                        {
                        CommonTree root_4 = (CommonTree)adaptor.nil();
                        root_4 = (CommonTree)adaptor.becomeRoot(stream_T_PARAMS.nextNode(), root_4);

                        adaptor.addChild(root_4, (CommonTree)adaptor.create(VAR, auxResults));

                        adaptor.addChild(root_3, root_4);
                        }

                        adaptor.addChild(root_2, root_3);
                        }

                        adaptor.addChild(root_1, root_2);
                        }

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;}
                    }
                    break;
                case 4 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1255:5: ^(fo= T_SQL_FOR ( distinct )? ROW v= VAR ) relationClause ( sqlWhereClause )?
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    fo=(CommonTree)match(input,T_SQL_FOR,FOLLOW_T_SQL_FOR_in_sqlForClause3873); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_T_SQL_FOR.add(fo);



                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1255:20: ( distinct )?
                    int alt40=2;
                    switch ( input.LA(1) ) {
                        case DISTINCT:
                        case REDUCED:
                            {
                            alt40=1;
                            }
                            break;
                    }

                    switch (alt40) {
                        case 1 :
                            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: distinct
                            {
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_distinct_in_sqlForClause3875);
                            distinct141=distinct();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_distinct.add(distinct141.getTree());

                            if ( state.backtracking==0 ) {
                            }
                            }
                            break;

                    }

                    _last = (CommonTree)input.LT(1);
                    ROW142=(CommonTree)match(input,ROW,FOLLOW_ROW_in_sqlForClause3878); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_ROW.add(ROW142);

                    _last = (CommonTree)input.LT(1);
                    v=(CommonTree)match(input,VAR,FOLLOW_VAR_in_sqlForClause3882); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_VAR.add(v);


                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }

                    if ( state.backtracking==0 ) {
                      addVariableToScope((v!=null?v.getText():null), Types.SQL_ROW); addPositionVariableToScope(auxResultPos);
                    }
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_relationClause_in_sqlForClause3897);
                    relationClause143=relationClause();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_relationClause.add(relationClause143.getTree());
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1256:26: ( sqlWhereClause )?
                    int alt41=2;
                    switch ( input.LA(1) ) {
                        case WHERE:
                            {
                            alt41=1;
                            }
                            break;
                    }

                    switch (alt41) {
                        case 1 :
                            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: sqlWhereClause
                            {
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_sqlWhereClause_in_sqlForClause3899);
                            sqlWhereClause144=sqlWhereClause();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_sqlWhereClause.add(sqlWhereClause144.getTree());

                            if ( state.backtracking==0 ) {
                            }
                            }
                            break;

                    }



                    // AST REWRITE
                    // elements: v, distinct, VAR, sqlWhereClause, relationClause, VAR, VAR
                    // token labels: v
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleNodeStream stream_v=new RewriteRuleNodeStream(adaptor,"token v",v);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1257:3: -> COMMENT[$fo.token, \"SQL FOR from \" + $fo.line + \":\" + $fo.pos] ^( T_LET VAR[auxResults] ^( T_FUNCTION_CALL NCNAME[SQLevaluationFunction] ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS QSTRING[\" SELECT \"] ( distinct )? QSTRING[\" * \"] relationClause ( sqlWhereClause )? ) ) ) ) ) ^( T_FOR $v ^( AT VAR[auxResultPos] ) ^( IN ^( T_FUNCTION_CALL NCNAME[SQLiterationFunction] ^( T_PARAMS VAR[auxResults] ) ) ) )
                    {
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(COMMENT, fo.token, "SQL FOR from " + (fo!=null?fo.getLine():0) + ":" + (fo!=null?fo.getCharPositionInLine():0)));
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1258:5: ^( T_LET VAR[auxResults] ^( T_FUNCTION_CALL NCNAME[SQLevaluationFunction] ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS QSTRING[\" SELECT \"] ( distinct )? QSTRING[\" * \"] relationClause ( sqlWhereClause )? ) ) ) ) )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_LET, "T_LET"), root_1);

                        adaptor.addChild(root_1, (CommonTree)adaptor.create(VAR, auxResults));
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1259:7: ^( T_FUNCTION_CALL NCNAME[SQLevaluationFunction] ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS QSTRING[\" SELECT \"] ( distinct )? QSTRING[\" * \"] relationClause ( sqlWhereClause )? ) ) ) )
                        {
                        CommonTree root_2 = (CommonTree)adaptor.nil();
                        root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FUNCTION_CALL, "T_FUNCTION_CALL"), root_2);

                        adaptor.addChild(root_2, (CommonTree)adaptor.create(NCNAME, SQLevaluationFunction));
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1261:9: ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS QSTRING[\" SELECT \"] ( distinct )? QSTRING[\" * \"] relationClause ( sqlWhereClause )? ) ) )
                        {
                        CommonTree root_3 = (CommonTree)adaptor.nil();
                        root_3 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_PARAMS, "T_PARAMS"), root_3);

                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1262:11: ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS QSTRING[\" SELECT \"] ( distinct )? QSTRING[\" * \"] relationClause ( sqlWhereClause )? ) )
                        {
                        CommonTree root_4 = (CommonTree)adaptor.nil();
                        root_4 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FUNCTION_CALL, "T_FUNCTION_CALL"), root_4);

                        adaptor.addChild(root_4, (CommonTree)adaptor.create(NCNAME, "fn:concat"));
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1264:13: ^( T_PARAMS QSTRING[\" SELECT \"] ( distinct )? QSTRING[\" * \"] relationClause ( sqlWhereClause )? )
                        {
                        CommonTree root_5 = (CommonTree)adaptor.nil();
                        root_5 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_PARAMS, "T_PARAMS"), root_5);

                        adaptor.addChild(root_5, (CommonTree)adaptor.create(QSTRING, " SELECT "));
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1266:15: ( distinct )?
                        if ( stream_distinct.hasNext() ) {
                            adaptor.addChild(root_5, stream_distinct.nextTree());

                        }
                        stream_distinct.reset();
                        adaptor.addChild(root_5, (CommonTree)adaptor.create(QSTRING, " * "));
                        adaptor.addChild(root_5, stream_relationClause.nextTree());
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1269:15: ( sqlWhereClause )?
                        if ( stream_sqlWhereClause.hasNext() ) {
                            adaptor.addChild(root_5, stream_sqlWhereClause.nextTree());

                        }
                        stream_sqlWhereClause.reset();

                        adaptor.addChild(root_4, root_5);
                        }

                        adaptor.addChild(root_3, root_4);
                        }

                        adaptor.addChild(root_2, root_3);
                        }

                        adaptor.addChild(root_1, root_2);
                        }

                        adaptor.addChild(root_0, root_1);
                        }
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1276:5: ^( T_FOR $v ^( AT VAR[auxResultPos] ) ^( IN ^( T_FUNCTION_CALL NCNAME[SQLiterationFunction] ^( T_PARAMS VAR[auxResults] ) ) ) )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FOR, "T_FOR"), root_1);

                        adaptor.addChild(root_1, stream_v.nextNode());
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1278:7: ^( AT VAR[auxResultPos] )
                        {
                        CommonTree root_2 = (CommonTree)adaptor.nil();
                        root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(AT, "AT"), root_2);

                        adaptor.addChild(root_2, (CommonTree)adaptor.create(VAR, auxResultPos));

                        adaptor.addChild(root_1, root_2);
                        }
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1281:7: ^( IN ^( T_FUNCTION_CALL NCNAME[SQLiterationFunction] ^( T_PARAMS VAR[auxResults] ) ) )
                        {
                        CommonTree root_2 = (CommonTree)adaptor.nil();
                        root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(IN, "IN"), root_2);

                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1282:9: ^( T_FUNCTION_CALL NCNAME[SQLiterationFunction] ^( T_PARAMS VAR[auxResults] ) )
                        {
                        CommonTree root_3 = (CommonTree)adaptor.nil();
                        root_3 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FUNCTION_CALL, "T_FUNCTION_CALL"), root_3);

                        adaptor.addChild(root_3, (CommonTree)adaptor.create(NCNAME, SQLiterationFunction));
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1284:11: ^( T_PARAMS VAR[auxResults] )
                        {
                        CommonTree root_4 = (CommonTree)adaptor.nil();
                        root_4 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_PARAMS, "T_PARAMS"), root_4);

                        adaptor.addChild(root_4, (CommonTree)adaptor.create(VAR, auxResults));

                        adaptor.addChild(root_3, root_4);
                        }

                        adaptor.addChild(root_2, root_3);
                        }

                        adaptor.addChild(root_1, root_2);
                        }

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;}
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
            sqlForClause_stack.pop();
        }
        return retval;
    }
    // $ANTLR end "sqlForClause"

    public static class sqlVarOrString_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "sqlVarOrString"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1294:1: sqlVarOrString : ^( T_TABLE v= sqlQuerySpec ) -> $v;
    public final XSPARQLRewriter.sqlVarOrString_return sqlVarOrString() throws RecognitionException {
        XSPARQLRewriter.sqlVarOrString_return retval = new XSPARQLRewriter.sqlVarOrString_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree T_TABLE145=null;
        XSPARQLRewriter.sqlQuerySpec_return v = null;


        CommonTree T_TABLE145_tree=null;
        RewriteRuleNodeStream stream_T_TABLE=new RewriteRuleNodeStream(adaptor,"token T_TABLE");
        RewriteRuleSubtreeStream stream_sqlQuerySpec=new RewriteRuleSubtreeStream(adaptor,"rule sqlQuerySpec");
        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1295:3: ( ^( T_TABLE v= sqlQuerySpec ) -> $v)
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1295:5: ^( T_TABLE v= sqlQuerySpec )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            T_TABLE145=(CommonTree)match(input,T_TABLE,FOLLOW_T_TABLE_in_sqlVarOrString4315); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_T_TABLE.add(T_TABLE145);



            match(input, Token.DOWN, null); if (state.failed) return retval;
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_sqlQuerySpec_in_sqlVarOrString4319);
            v=sqlQuerySpec();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_sqlQuerySpec.add(v.getTree());

            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }



            // AST REWRITE
            // elements: v
            // token labels: 
            // rule labels: v, retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_v=new RewriteRuleSubtreeStream(adaptor,"rule v",v!=null?v.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1296:3: -> $v
            {
                adaptor.addChild(root_0, stream_v.nextTree());

            }

            retval.tree = root_0;}
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "sqlVarOrString"

    public static class sqlQuerySpec_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "sqlQuerySpec"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1300:1: sqlQuerySpec : (v= qname -> QSTRING[$v.text] | VAR );
    public final XSPARQLRewriter.sqlQuerySpec_return sqlQuerySpec() throws RecognitionException {
        XSPARQLRewriter.sqlQuerySpec_return retval = new XSPARQLRewriter.sqlQuerySpec_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree VAR146=null;
        XSPARQLRewriter.qname_return v = null;


        CommonTree VAR146_tree=null;
        RewriteRuleSubtreeStream stream_qname=new RewriteRuleSubtreeStream(adaptor,"rule qname");
        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1301:3: (v= qname -> QSTRING[$v.text] | VAR )
            int alt43=2;
            switch ( input.LA(1) ) {
            case NCNAME:
            case PNAME_NS:
            case PNAME_LN:
            case A:
            case FROM:
            case TO:
            case ITEM:
            case NODE:
            case COMMENT:
            case ROW:
                {
                alt43=1;
                }
                break;
            case VAR:
                {
                alt43=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 43, 0, input);

                throw nvae;
            }

            switch (alt43) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1301:5: v= qname
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_qname_in_sqlQuerySpec4345);
                    v=qname();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_qname.add(v.getTree());


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1301:13: -> QSTRING[$v.text]
                    {
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, (v!=null?(input.getTokenStream().toString(
                          input.getTreeAdaptor().getTokenStartIndex(v.start),
                          input.getTreeAdaptor().getTokenStopIndex(v.start))):null)));

                    }

                    retval.tree = root_0;}
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1302:5: VAR
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    VAR146=(CommonTree)match(input,VAR,FOLLOW_VAR_in_sqlQuerySpec4356); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    VAR146_tree = (CommonTree)adaptor.dupNode(VAR146);

                    adaptor.addChild(root_0, VAR146_tree);
                    }

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "sqlQuerySpec"

    public static class sqlVarOrFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "sqlVarOrFunction"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1309:1: sqlVarOrFunction : ( ^( T_VAR ( COMMA )? q= qname ) -> ^( T_VAR ( COMMA )? QSTRING[$q.text] VAR[\"\\$\"+$q.text] ) | ^( T_VAR ( COMMA )? q= qname VAR ) -> ^( T_VAR ( COMMA )? QSTRING[$q.text] VAR ) | ( COMMA )? LPAR functionCall AS v3= VAR RPAR );
    public final XSPARQLRewriter.sqlVarOrFunction_return sqlVarOrFunction() throws RecognitionException {
        XSPARQLRewriter.sqlVarOrFunction_return retval = new XSPARQLRewriter.sqlVarOrFunction_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree v3=null;
        CommonTree T_VAR147=null;
        CommonTree COMMA148=null;
        CommonTree T_VAR149=null;
        CommonTree COMMA150=null;
        CommonTree VAR151=null;
        CommonTree COMMA152=null;
        CommonTree LPAR153=null;
        CommonTree AS155=null;
        CommonTree RPAR156=null;
        XSPARQLRewriter.qname_return q = null;

        XSPARQLRewriter.functionCall_return functionCall154 = null;


        CommonTree v3_tree=null;
        CommonTree T_VAR147_tree=null;
        CommonTree COMMA148_tree=null;
        CommonTree T_VAR149_tree=null;
        CommonTree COMMA150_tree=null;
        CommonTree VAR151_tree=null;
        CommonTree COMMA152_tree=null;
        CommonTree LPAR153_tree=null;
        CommonTree AS155_tree=null;
        CommonTree RPAR156_tree=null;
        RewriteRuleNodeStream stream_T_VAR=new RewriteRuleNodeStream(adaptor,"token T_VAR");
        RewriteRuleNodeStream stream_COMMA=new RewriteRuleNodeStream(adaptor,"token COMMA");
        RewriteRuleNodeStream stream_VAR=new RewriteRuleNodeStream(adaptor,"token VAR");
        RewriteRuleSubtreeStream stream_qname=new RewriteRuleSubtreeStream(adaptor,"rule qname");
        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1310:3: ( ^( T_VAR ( COMMA )? q= qname ) -> ^( T_VAR ( COMMA )? QSTRING[$q.text] VAR[\"\\$\"+$q.text] ) | ^( T_VAR ( COMMA )? q= qname VAR ) -> ^( T_VAR ( COMMA )? QSTRING[$q.text] VAR ) | ( COMMA )? LPAR functionCall AS v3= VAR RPAR )
            int alt47=3;
            alt47 = dfa47.predict(input);
            switch (alt47) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1310:5: ^( T_VAR ( COMMA )? q= qname )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    T_VAR147=(CommonTree)match(input,T_VAR,FOLLOW_T_VAR_in_sqlVarOrFunction4378); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_T_VAR.add(T_VAR147);



                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1310:13: ( COMMA )?
                    int alt44=2;
                    switch ( input.LA(1) ) {
                        case COMMA:
                            {
                            alt44=1;
                            }
                            break;
                    }

                    switch (alt44) {
                        case 1 :
                            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: COMMA
                            {
                            _last = (CommonTree)input.LT(1);
                            COMMA148=(CommonTree)match(input,COMMA,FOLLOW_COMMA_in_sqlVarOrFunction4380); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_COMMA.add(COMMA148);


                            if ( state.backtracking==0 ) {
                            }
                            }
                            break;

                    }

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_qname_in_sqlVarOrFunction4385);
                    q=qname();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_qname.add(q.getTree());

                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }



                    // AST REWRITE
                    // elements: COMMA, T_VAR
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1311:5: -> ^( T_VAR ( COMMA )? QSTRING[$q.text] VAR[\"\\$\"+$q.text] )
                    {
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1311:8: ^( T_VAR ( COMMA )? QSTRING[$q.text] VAR[\"\\$\"+$q.text] )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(stream_T_VAR.nextNode(), root_1);

                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1311:16: ( COMMA )?
                        if ( stream_COMMA.hasNext() ) {
                            adaptor.addChild(root_1, stream_COMMA.nextNode());

                        }
                        stream_COMMA.reset();
                        adaptor.addChild(root_1, (CommonTree)adaptor.create(QSTRING, (q!=null?(input.getTokenStream().toString(
                          input.getTreeAdaptor().getTokenStartIndex(q.start),
                          input.getTreeAdaptor().getTokenStopIndex(q.start))):null)));
                        adaptor.addChild(root_1, (CommonTree)adaptor.create(VAR, "$"+(q!=null?(input.getTokenStream().toString(
                          input.getTreeAdaptor().getTokenStartIndex(q.start),
                          input.getTreeAdaptor().getTokenStopIndex(q.start))):null)));

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;}
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1312:5: ^( T_VAR ( COMMA )? q= qname VAR )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    T_VAR149=(CommonTree)match(input,T_VAR,FOLLOW_T_VAR_in_sqlVarOrFunction4413); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_T_VAR.add(T_VAR149);



                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1312:13: ( COMMA )?
                    int alt45=2;
                    switch ( input.LA(1) ) {
                        case COMMA:
                            {
                            alt45=1;
                            }
                            break;
                    }

                    switch (alt45) {
                        case 1 :
                            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: COMMA
                            {
                            _last = (CommonTree)input.LT(1);
                            COMMA150=(CommonTree)match(input,COMMA,FOLLOW_COMMA_in_sqlVarOrFunction4415); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_COMMA.add(COMMA150);


                            if ( state.backtracking==0 ) {
                            }
                            }
                            break;

                    }

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_qname_in_sqlVarOrFunction4420);
                    q=qname();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_qname.add(q.getTree());
                    _last = (CommonTree)input.LT(1);
                    VAR151=(CommonTree)match(input,VAR,FOLLOW_VAR_in_sqlVarOrFunction4422); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_VAR.add(VAR151);


                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }



                    // AST REWRITE
                    // elements: COMMA, T_VAR, VAR
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1313:5: -> ^( T_VAR ( COMMA )? QSTRING[$q.text] VAR )
                    {
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1313:8: ^( T_VAR ( COMMA )? QSTRING[$q.text] VAR )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(stream_T_VAR.nextNode(), root_1);

                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1313:16: ( COMMA )?
                        if ( stream_COMMA.hasNext() ) {
                            adaptor.addChild(root_1, stream_COMMA.nextNode());

                        }
                        stream_COMMA.reset();
                        adaptor.addChild(root_1, (CommonTree)adaptor.create(QSTRING, (q!=null?(input.getTokenStream().toString(
                          input.getTreeAdaptor().getTokenStartIndex(q.start),
                          input.getTreeAdaptor().getTokenStopIndex(q.start))):null)));
                        adaptor.addChild(root_1, stream_VAR.nextNode());

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;}
                    }
                    break;
                case 3 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1314:5: ( COMMA )? LPAR functionCall AS v3= VAR RPAR
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1314:5: ( COMMA )?
                    int alt46=2;
                    switch ( input.LA(1) ) {
                        case COMMA:
                            {
                            alt46=1;
                            }
                            break;
                    }

                    switch (alt46) {
                        case 1 :
                            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: COMMA
                            {
                            _last = (CommonTree)input.LT(1);
                            COMMA152=(CommonTree)match(input,COMMA,FOLLOW_COMMA_in_sqlVarOrFunction4448); if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                            COMMA152_tree = (CommonTree)adaptor.dupNode(COMMA152);

                            adaptor.addChild(root_0, COMMA152_tree);
                            }

                            if ( state.backtracking==0 ) {
                            }
                            }
                            break;

                    }

                    _last = (CommonTree)input.LT(1);
                    LPAR153=(CommonTree)match(input,LPAR,FOLLOW_LPAR_in_sqlVarOrFunction4451); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    LPAR153_tree = (CommonTree)adaptor.dupNode(LPAR153);

                    adaptor.addChild(root_0, LPAR153_tree);
                    }
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_functionCall_in_sqlVarOrFunction4453);
                    functionCall154=functionCall();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, functionCall154.getTree());
                    _last = (CommonTree)input.LT(1);
                    AS155=(CommonTree)match(input,AS,FOLLOW_AS_in_sqlVarOrFunction4455); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    AS155_tree = (CommonTree)adaptor.dupNode(AS155);

                    adaptor.addChild(root_0, AS155_tree);
                    }
                    _last = (CommonTree)input.LT(1);
                    v3=(CommonTree)match(input,VAR,FOLLOW_VAR_in_sqlVarOrFunction4459); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    v3_tree = (CommonTree)adaptor.dupNode(v3);

                    adaptor.addChild(root_0, v3_tree);
                    }
                    _last = (CommonTree)input.LT(1);
                    RPAR156=(CommonTree)match(input,RPAR,FOLLOW_RPAR_in_sqlVarOrFunction4461); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    RPAR156_tree = (CommonTree)adaptor.dupNode(RPAR156);

                    adaptor.addChild(root_0, RPAR156_tree);
                    }

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "sqlVarOrFunction"

    public static class relationClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "relationClause"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1318:1: relationClause : ^( T_SQL_FROM rdbSourceSelector ( COMMA rdbSourceSelector )* ) -> QSTRING[\"from \"] rdbSourceSelector ( QSTRING[\", \"] rdbSourceSelector )* ;
    public final XSPARQLRewriter.relationClause_return relationClause() throws RecognitionException {
        XSPARQLRewriter.relationClause_return retval = new XSPARQLRewriter.relationClause_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree T_SQL_FROM157=null;
        CommonTree COMMA159=null;
        XSPARQLRewriter.rdbSourceSelector_return rdbSourceSelector158 = null;

        XSPARQLRewriter.rdbSourceSelector_return rdbSourceSelector160 = null;


        CommonTree T_SQL_FROM157_tree=null;
        CommonTree COMMA159_tree=null;
        RewriteRuleNodeStream stream_COMMA=new RewriteRuleNodeStream(adaptor,"token COMMA");
        RewriteRuleNodeStream stream_T_SQL_FROM=new RewriteRuleNodeStream(adaptor,"token T_SQL_FROM");
        RewriteRuleSubtreeStream stream_rdbSourceSelector=new RewriteRuleSubtreeStream(adaptor,"rule rdbSourceSelector");
        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1319:3: ( ^( T_SQL_FROM rdbSourceSelector ( COMMA rdbSourceSelector )* ) -> QSTRING[\"from \"] rdbSourceSelector ( QSTRING[\", \"] rdbSourceSelector )* )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1319:5: ^( T_SQL_FROM rdbSourceSelector ( COMMA rdbSourceSelector )* )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            T_SQL_FROM157=(CommonTree)match(input,T_SQL_FROM,FOLLOW_T_SQL_FROM_in_relationClause4474); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_T_SQL_FROM.add(T_SQL_FROM157);



            match(input, Token.DOWN, null); if (state.failed) return retval;
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_rdbSourceSelector_in_relationClause4476);
            rdbSourceSelector158=rdbSourceSelector();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_rdbSourceSelector.add(rdbSourceSelector158.getTree());
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1319:36: ( COMMA rdbSourceSelector )*
            loop48:
            do {
                int alt48=2;
                switch ( input.LA(1) ) {
                case COMMA:
                    {
                    alt48=1;
                    }
                    break;

                }

                switch (alt48) {
            	case 1 :
            	    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1319:37: COMMA rdbSourceSelector
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    COMMA159=(CommonTree)match(input,COMMA,FOLLOW_COMMA_in_relationClause4479); if (state.failed) return retval; 
            	    if ( state.backtracking==0 ) stream_COMMA.add(COMMA159);

            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_rdbSourceSelector_in_relationClause4481);
            	    rdbSourceSelector160=rdbSourceSelector();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) stream_rdbSourceSelector.add(rdbSourceSelector160.getTree());

            	    if ( state.backtracking==0 ) {
            	    }
            	    }
            	    break;

            	default :
            	    break loop48;
                }
            } while (true);


            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }



            // AST REWRITE
            // elements: rdbSourceSelector, rdbSourceSelector
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1320:5: -> QSTRING[\"from \"] rdbSourceSelector ( QSTRING[\", \"] rdbSourceSelector )*
            {
                adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, "from "));
                adaptor.addChild(root_0, stream_rdbSourceSelector.nextTree());
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1320:43: ( QSTRING[\", \"] rdbSourceSelector )*
                while ( stream_rdbSourceSelector.hasNext() ) {
                    adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, ", "));
                    adaptor.addChild(root_0, stream_rdbSourceSelector.nextTree());

                }
                stream_rdbSourceSelector.reset();

            }

            retval.tree = root_0;}
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "relationClause"

    public static class rdbSourceSelector_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "rdbSourceSelector"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1323:1: rdbSourceSelector : ^( T_TABLE v= relationSchemaName (alias= relationAlias )? ) -> $v ( QSTRING[\" \"] $alias)? ;
    public final XSPARQLRewriter.rdbSourceSelector_return rdbSourceSelector() throws RecognitionException {
        XSPARQLRewriter.rdbSourceSelector_return retval = new XSPARQLRewriter.rdbSourceSelector_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree T_TABLE161=null;
        XSPARQLRewriter.relationSchemaName_return v = null;

        XSPARQLRewriter.relationAlias_return alias = null;


        CommonTree T_TABLE161_tree=null;
        RewriteRuleNodeStream stream_T_TABLE=new RewriteRuleNodeStream(adaptor,"token T_TABLE");
        RewriteRuleSubtreeStream stream_relationSchemaName=new RewriteRuleSubtreeStream(adaptor,"rule relationSchemaName");
        RewriteRuleSubtreeStream stream_relationAlias=new RewriteRuleSubtreeStream(adaptor,"rule relationAlias");
        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1324:3: ( ^( T_TABLE v= relationSchemaName (alias= relationAlias )? ) -> $v ( QSTRING[\" \"] $alias)? )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1324:5: ^( T_TABLE v= relationSchemaName (alias= relationAlias )? )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            T_TABLE161=(CommonTree)match(input,T_TABLE,FOLLOW_T_TABLE_in_rdbSourceSelector4518); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_T_TABLE.add(T_TABLE161);



            match(input, Token.DOWN, null); if (state.failed) return retval;
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_relationSchemaName_in_rdbSourceSelector4522);
            v=relationSchemaName();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_relationSchemaName.add(v.getTree());
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1324:41: (alias= relationAlias )?
            int alt49=2;
            switch ( input.LA(1) ) {
                case VAR:
                case NCNAME:
                case PNAME_NS:
                case PNAME_LN:
                case A:
                case FROM:
                case TO:
                case ITEM:
                case NODE:
                case COMMENT:
                case ROW:
                    {
                    alt49=1;
                    }
                    break;
            }

            switch (alt49) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: alias= relationAlias
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_relationAlias_in_rdbSourceSelector4526);
                    alias=relationAlias();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_relationAlias.add(alias.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }


            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }

            if ( state.backtracking==0 ) {
               ((sqlForClause_scope)sqlForClause_stack.peek()).relationsAlias.add(new Pair<String,String>((v!=null?(input.getTokenStream().toString(
                input.getTreeAdaptor().getTokenStartIndex(v.start),
                input.getTreeAdaptor().getTokenStopIndex(v.start))):null), (alias!=null?(input.getTokenStream().toString(
                input.getTreeAdaptor().getTokenStartIndex(alias.start),
                input.getTreeAdaptor().getTokenStopIndex(alias.start))):null))); 
            }


            // AST REWRITE
            // elements: alias, v
            // token labels: 
            // rule labels: v, alias, retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_v=new RewriteRuleSubtreeStream(adaptor,"rule v",v!=null?v.tree:null);
            RewriteRuleSubtreeStream stream_alias=new RewriteRuleSubtreeStream(adaptor,"rule alias",alias!=null?alias.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1326:3: -> $v ( QSTRING[\" \"] $alias)?
            {
                adaptor.addChild(root_0, stream_v.nextTree());
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1326:9: ( QSTRING[\" \"] $alias)?
                if ( stream_alias.hasNext() ) {
                    adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, " "));
                    adaptor.addChild(root_0, stream_alias.nextTree());

                }
                stream_alias.reset();

            }

            retval.tree = root_0;}
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "rdbSourceSelector"

    public static class relationSchemaName_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "relationSchemaName"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1330:1: relationSchemaName : (p1= qname DOT q1= qname -> QSTRING[\"\\\"\\\"\"+$p1.text+\"\\\"\\\".\\\"\\\"\"+$q1.text+\"\\\"\\\"\"] | relationAlias | p2= relationAlias DOT q2= relationAlias -> ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS $p2 QSTRING[\".\"] $q2) ) );
    public final XSPARQLRewriter.relationSchemaName_return relationSchemaName() throws RecognitionException {
        XSPARQLRewriter.relationSchemaName_return retval = new XSPARQLRewriter.relationSchemaName_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree DOT162=null;
        CommonTree DOT164=null;
        XSPARQLRewriter.qname_return p1 = null;

        XSPARQLRewriter.qname_return q1 = null;

        XSPARQLRewriter.relationAlias_return p2 = null;

        XSPARQLRewriter.relationAlias_return q2 = null;

        XSPARQLRewriter.relationAlias_return relationAlias163 = null;


        CommonTree DOT162_tree=null;
        CommonTree DOT164_tree=null;
        RewriteRuleNodeStream stream_DOT=new RewriteRuleNodeStream(adaptor,"token DOT");
        RewriteRuleSubtreeStream stream_qname=new RewriteRuleSubtreeStream(adaptor,"rule qname");
        RewriteRuleSubtreeStream stream_relationAlias=new RewriteRuleSubtreeStream(adaptor,"rule relationAlias");
         logger.info("relationSchemaName"); 
        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1332:3: (p1= qname DOT q1= qname -> QSTRING[\"\\\"\\\"\"+$p1.text+\"\\\"\\\".\\\"\\\"\"+$q1.text+\"\\\"\\\"\"] | relationAlias | p2= relationAlias DOT q2= relationAlias -> ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS $p2 QSTRING[\".\"] $q2) ) )
            int alt50=3;
            alt50 = dfa50.predict(input);
            switch (alt50) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1332:5: p1= qname DOT q1= qname
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_qname_in_relationSchemaName4574);
                    p1=qname();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_qname.add(p1.getTree());
                    _last = (CommonTree)input.LT(1);
                    DOT162=(CommonTree)match(input,DOT,FOLLOW_DOT_in_relationSchemaName4576); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_DOT.add(DOT162);

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_qname_in_relationSchemaName4580);
                    q1=qname();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_qname.add(q1.getTree());


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1332:27: -> QSTRING[\"\\\"\\\"\"+$p1.text+\"\\\"\\\".\\\"\\\"\"+$q1.text+\"\\\"\\\"\"]
                    {
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, "\"\""+(p1!=null?(input.getTokenStream().toString(
                          input.getTreeAdaptor().getTokenStartIndex(p1.start),
                          input.getTreeAdaptor().getTokenStopIndex(p1.start))):null)+"\"\".\"\""+(q1!=null?(input.getTokenStream().toString(
                          input.getTreeAdaptor().getTokenStartIndex(q1.start),
                          input.getTreeAdaptor().getTokenStopIndex(q1.start))):null)+"\"\""));

                    }

                    retval.tree = root_0;}
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1333:5: relationAlias
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_relationAlias_in_relationSchemaName4591);
                    relationAlias163=relationAlias();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, relationAlias163.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 3 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1334:5: p2= relationAlias DOT q2= relationAlias
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_relationAlias_in_relationSchemaName4602);
                    p2=relationAlias();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_relationAlias.add(p2.getTree());
                    _last = (CommonTree)input.LT(1);
                    DOT164=(CommonTree)match(input,DOT,FOLLOW_DOT_in_relationSchemaName4604); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_DOT.add(DOT164);

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_relationAlias_in_relationSchemaName4608);
                    q2=relationAlias();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_relationAlias.add(q2.getTree());


                    // AST REWRITE
                    // elements: p2, q2
                    // token labels: 
                    // rule labels: q2, p2, retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_q2=new RewriteRuleSubtreeStream(adaptor,"rule q2",q2!=null?q2.tree:null);
                    RewriteRuleSubtreeStream stream_p2=new RewriteRuleSubtreeStream(adaptor,"rule p2",p2!=null?p2.tree:null);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1334:43: -> ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS $p2 QSTRING[\".\"] $q2) )
                    {
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1335:5: ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS $p2 QSTRING[\".\"] $q2) )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FUNCTION_CALL, "T_FUNCTION_CALL"), root_1);

                        adaptor.addChild(root_1, (CommonTree)adaptor.create(NCNAME, "fn:concat"));
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1335:43: ^( T_PARAMS $p2 QSTRING[\".\"] $q2)
                        {
                        CommonTree root_2 = (CommonTree)adaptor.nil();
                        root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_PARAMS, "T_PARAMS"), root_2);

                        adaptor.addChild(root_2, stream_p2.nextTree());
                        adaptor.addChild(root_2, (CommonTree)adaptor.create(QSTRING, "."));
                        adaptor.addChild(root_2, stream_q2.nextTree());

                        adaptor.addChild(root_1, root_2);
                        }

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;}
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "relationSchemaName"

    public static class relationAlias_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "relationAlias"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1339:1: relationAlias : (v= qname -> QSTRING[$v.text] | var= VAR );
    public final XSPARQLRewriter.relationAlias_return relationAlias() throws RecognitionException {
        XSPARQLRewriter.relationAlias_return retval = new XSPARQLRewriter.relationAlias_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree var=null;
        XSPARQLRewriter.qname_return v = null;


        CommonTree var_tree=null;
        RewriteRuleSubtreeStream stream_qname=new RewriteRuleSubtreeStream(adaptor,"rule qname");
        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1342:3: (v= qname -> QSTRING[$v.text] | var= VAR )
            int alt51=2;
            switch ( input.LA(1) ) {
            case NCNAME:
            case PNAME_NS:
            case PNAME_LN:
            case A:
            case FROM:
            case TO:
            case ITEM:
            case NODE:
            case COMMENT:
            case ROW:
                {
                alt51=1;
                }
                break;
            case VAR:
                {
                alt51=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 51, 0, input);

                throw nvae;
            }

            switch (alt51) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1342:5: v= qname
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_qname_in_relationAlias4654);
                    v=qname();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_qname.add(v.getTree());


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1342:13: -> QSTRING[$v.text]
                    {
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, (v!=null?(input.getTokenStream().toString(
                          input.getTreeAdaptor().getTokenStartIndex(v.start),
                          input.getTreeAdaptor().getTokenStopIndex(v.start))):null)));

                    }

                    retval.tree = root_0;}
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1343:5: var= VAR
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    var=(CommonTree)match(input,VAR,FOLLOW_VAR_in_relationAlias4667); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    var_tree = (CommonTree)adaptor.dupNode(var);

                    adaptor.addChild(root_0, var_tree);
                    }

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "relationAlias"

    public static class sqlWhereClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "sqlWhereClause"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1346:1: sqlWhereClause : ^( WHERE sqlWhereSpecList ) -> QSTRING[\" where \"] sqlWhereSpecList ;
    public final XSPARQLRewriter.sqlWhereClause_return sqlWhereClause() throws RecognitionException {
        XSPARQLRewriter.sqlWhereClause_return retval = new XSPARQLRewriter.sqlWhereClause_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree WHERE165=null;
        XSPARQLRewriter.sqlWhereSpecList_return sqlWhereSpecList166 = null;


        CommonTree WHERE165_tree=null;
        RewriteRuleNodeStream stream_WHERE=new RewriteRuleNodeStream(adaptor,"token WHERE");
        RewriteRuleSubtreeStream stream_sqlWhereSpecList=new RewriteRuleSubtreeStream(adaptor,"rule sqlWhereSpecList");
        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1347:3: ( ^( WHERE sqlWhereSpecList ) -> QSTRING[\" where \"] sqlWhereSpecList )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1347:5: ^( WHERE sqlWhereSpecList )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            WHERE165=(CommonTree)match(input,WHERE,FOLLOW_WHERE_in_sqlWhereClause4683); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_WHERE.add(WHERE165);



            match(input, Token.DOWN, null); if (state.failed) return retval;
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_sqlWhereSpecList_in_sqlWhereClause4685);
            sqlWhereSpecList166=sqlWhereSpecList();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_sqlWhereSpecList.add(sqlWhereSpecList166.getTree());

            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }



            // AST REWRITE
            // elements: sqlWhereSpecList
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1348:3: -> QSTRING[\" where \"] sqlWhereSpecList
            {
                adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, " where "));
                adaptor.addChild(root_0, stream_sqlWhereSpecList.nextTree());

            }

            retval.tree = root_0;}
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "sqlWhereClause"

    public static class sqlWhereSpecList_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "sqlWhereSpecList"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1351:1: sqlWhereSpecList : sqlAttrSpecList (b= sqlBooleanOp sqlWhereSpecList )* -> sqlAttrSpecList ( QSTRING[\" \"] QSTRING[$b.text] QSTRING[\" \"] sqlWhereSpecList )* ;
    public final XSPARQLRewriter.sqlWhereSpecList_return sqlWhereSpecList() throws RecognitionException {
        XSPARQLRewriter.sqlWhereSpecList_return retval = new XSPARQLRewriter.sqlWhereSpecList_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.sqlBooleanOp_return b = null;

        XSPARQLRewriter.sqlAttrSpecList_return sqlAttrSpecList167 = null;

        XSPARQLRewriter.sqlWhereSpecList_return sqlWhereSpecList168 = null;


        RewriteRuleSubtreeStream stream_sqlBooleanOp=new RewriteRuleSubtreeStream(adaptor,"rule sqlBooleanOp");
        RewriteRuleSubtreeStream stream_sqlWhereSpecList=new RewriteRuleSubtreeStream(adaptor,"rule sqlWhereSpecList");
        RewriteRuleSubtreeStream stream_sqlAttrSpecList=new RewriteRuleSubtreeStream(adaptor,"rule sqlAttrSpecList");
        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1352:2: ( sqlAttrSpecList (b= sqlBooleanOp sqlWhereSpecList )* -> sqlAttrSpecList ( QSTRING[\" \"] QSTRING[$b.text] QSTRING[\" \"] sqlWhereSpecList )* )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1352:4: sqlAttrSpecList (b= sqlBooleanOp sqlWhereSpecList )*
            {
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_sqlAttrSpecList_in_sqlWhereSpecList4710);
            sqlAttrSpecList167=sqlAttrSpecList();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_sqlAttrSpecList.add(sqlAttrSpecList167.getTree());
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1352:20: (b= sqlBooleanOp sqlWhereSpecList )*
            loop52:
            do {
                int alt52=2;
                switch ( input.LA(1) ) {
                case AND:
                case OR:
                    {
                    int LA52_2 = input.LA(2);

                    if ( (synpred78_XSPARQLRewriter()) ) {
                        alt52=1;
                    }


                    }
                    break;

                }

                switch (alt52) {
            	case 1 :
            	    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1352:21: b= sqlBooleanOp sqlWhereSpecList
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_sqlBooleanOp_in_sqlWhereSpecList4715);
            	    b=sqlBooleanOp();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) stream_sqlBooleanOp.add(b.getTree());
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_sqlWhereSpecList_in_sqlWhereSpecList4717);
            	    sqlWhereSpecList168=sqlWhereSpecList();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) stream_sqlWhereSpecList.add(sqlWhereSpecList168.getTree());

            	    if ( state.backtracking==0 ) {
            	    }
            	    }
            	    break;

            	default :
            	    break loop52;
                }
            } while (true);



            // AST REWRITE
            // elements: sqlAttrSpecList, sqlWhereSpecList
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1353:2: -> sqlAttrSpecList ( QSTRING[\" \"] QSTRING[$b.text] QSTRING[\" \"] sqlWhereSpecList )*
            {
                adaptor.addChild(root_0, stream_sqlAttrSpecList.nextTree());
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1353:21: ( QSTRING[\" \"] QSTRING[$b.text] QSTRING[\" \"] sqlWhereSpecList )*
                while ( stream_sqlWhereSpecList.hasNext() ) {
                    adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, " "));
                    adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, (b!=null?(input.getTokenStream().toString(
                      input.getTreeAdaptor().getTokenStartIndex(b.start),
                      input.getTreeAdaptor().getTokenStopIndex(b.start))):null)));
                    adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, " "));
                    adaptor.addChild(root_0, stream_sqlWhereSpecList.nextTree());

                }
                stream_sqlWhereSpecList.reset();

            }

            retval.tree = root_0;}
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "sqlWhereSpecList"

    public static class sqlAttrSpecList_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "sqlAttrSpecList"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1357:1: sqlAttrSpecList : ( sqlAttrSpec g= generalComp sqlAttrSpec -> sqlAttrSpec QSTRING[\" \"] QSTRING[$g.text] QSTRING[\" \"] sqlAttrSpec | l= LPAR sqlWhereSpecList r= RPAR -> QSTRING[$l.text] sqlWhereSpecList QSTRING[$r.text] );
    public final XSPARQLRewriter.sqlAttrSpecList_return sqlAttrSpecList() throws RecognitionException {
        XSPARQLRewriter.sqlAttrSpecList_return retval = new XSPARQLRewriter.sqlAttrSpecList_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree l=null;
        CommonTree r=null;
        XSPARQLRewriter.generalComp_return g = null;

        XSPARQLRewriter.sqlAttrSpec_return sqlAttrSpec169 = null;

        XSPARQLRewriter.sqlAttrSpec_return sqlAttrSpec170 = null;

        XSPARQLRewriter.sqlWhereSpecList_return sqlWhereSpecList171 = null;


        CommonTree l_tree=null;
        CommonTree r_tree=null;
        RewriteRuleNodeStream stream_LPAR=new RewriteRuleNodeStream(adaptor,"token LPAR");
        RewriteRuleNodeStream stream_RPAR=new RewriteRuleNodeStream(adaptor,"token RPAR");
        RewriteRuleSubtreeStream stream_sqlWhereSpecList=new RewriteRuleSubtreeStream(adaptor,"rule sqlWhereSpecList");
        RewriteRuleSubtreeStream stream_generalComp=new RewriteRuleSubtreeStream(adaptor,"rule generalComp");
        RewriteRuleSubtreeStream stream_sqlAttrSpec=new RewriteRuleSubtreeStream(adaptor,"rule sqlAttrSpec");
        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1358:3: ( sqlAttrSpec g= generalComp sqlAttrSpec -> sqlAttrSpec QSTRING[\" \"] QSTRING[$g.text] QSTRING[\" \"] sqlAttrSpec | l= LPAR sqlWhereSpecList r= RPAR -> QSTRING[$l.text] sqlWhereSpecList QSTRING[$r.text] )
            int alt53=2;
            switch ( input.LA(1) ) {
            case VAR:
            case INTEGER:
            case LCURLY:
            case NCNAME:
            case QSTRING:
            case STAR:
            case LESSTHAN:
            case GREATERTHAN:
            case PLUS:
            case MINUS:
            case UNIONSYMBOL:
            case LESSTHANLESSTHAN:
            case GREATERTHANEQUALS:
            case LESSTHANEQUALS:
            case HAFENEQUALS:
            case EQUALS:
            case PNAME_NS:
            case PNAME_LN:
            case A:
            case IS:
            case EQ:
            case NE:
            case LT:
            case GE:
            case LE:
            case GT:
            case FROM:
            case IF:
            case AND:
            case OR:
            case TO:
            case DIV:
            case IDIV:
            case MOD:
            case UNION:
            case INTERSECT:
            case EXCEPT:
            case ITEM:
            case NODE:
            case COMMENT:
            case GREATERTHANGREATERTHAN:
            case ROW:
            case T_FLWOR:
            case T_INSTANCEOF:
            case T_CASTAS:
            case T_CASTABLEAS:
            case T_TREATAS:
            case EVERY:
            case TYPESWITCH:
            case VALIDATE:
            case SOME:
            case XPATH:
            case DECIMAL:
                {
                alt53=1;
                }
                break;
            case LPAR:
                {
                alt53=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 53, 0, input);

                throw nvae;
            }

            switch (alt53) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1358:5: sqlAttrSpec g= generalComp sqlAttrSpec
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_sqlAttrSpec_in_sqlAttrSpecList4755);
                    sqlAttrSpec169=sqlAttrSpec();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_sqlAttrSpec.add(sqlAttrSpec169.getTree());
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_generalComp_in_sqlAttrSpecList4759);
                    g=generalComp();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_generalComp.add(g.getTree());
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_sqlAttrSpec_in_sqlAttrSpecList4761);
                    sqlAttrSpec170=sqlAttrSpec();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_sqlAttrSpec.add(sqlAttrSpec170.getTree());


                    // AST REWRITE
                    // elements: sqlAttrSpec, sqlAttrSpec
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1359:2: -> sqlAttrSpec QSTRING[\" \"] QSTRING[$g.text] QSTRING[\" \"] sqlAttrSpec
                    {
                        adaptor.addChild(root_0, stream_sqlAttrSpec.nextTree());
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, " "));
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, (g!=null?(input.getTokenStream().toString(
                          input.getTreeAdaptor().getTokenStartIndex(g.start),
                          input.getTreeAdaptor().getTokenStopIndex(g.start))):null)));
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, " "));
                        adaptor.addChild(root_0, stream_sqlAttrSpec.nextTree());

                    }

                    retval.tree = root_0;}
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1360:5: l= LPAR sqlWhereSpecList r= RPAR
                    {
                    _last = (CommonTree)input.LT(1);
                    l=(CommonTree)match(input,LPAR,FOLLOW_LPAR_in_sqlAttrSpecList4786); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_LPAR.add(l);

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_sqlWhereSpecList_in_sqlAttrSpecList4788);
                    sqlWhereSpecList171=sqlWhereSpecList();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_sqlWhereSpecList.add(sqlWhereSpecList171.getTree());
                    _last = (CommonTree)input.LT(1);
                    r=(CommonTree)match(input,RPAR,FOLLOW_RPAR_in_sqlAttrSpecList4792); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_RPAR.add(r);



                    // AST REWRITE
                    // elements: sqlWhereSpecList
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1361:3: -> QSTRING[$l.text] sqlWhereSpecList QSTRING[$r.text]
                    {
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, (l!=null?l.getText():null)));
                        adaptor.addChild(root_0, stream_sqlWhereSpecList.nextTree());
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, (r!=null?r.getText():null)));

                    }

                    retval.tree = root_0;}
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "sqlAttrSpecList"

    public static class sqlBooleanOp_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "sqlBooleanOp"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1364:1: sqlBooleanOp : ( AND | OR );
    public final XSPARQLRewriter.sqlBooleanOp_return sqlBooleanOp() throws RecognitionException {
        XSPARQLRewriter.sqlBooleanOp_return retval = new XSPARQLRewriter.sqlBooleanOp_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set172=null;

        CommonTree set172_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1365:3: ( AND | OR )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            set172=(CommonTree)input.LT(1);
            if ( (input.LA(1)>=AND && input.LA(1)<=OR) ) {
                input.consume();

                if ( state.backtracking==0 ) {
                set172_tree = (CommonTree)adaptor.dupNode(set172);

                adaptor.addChild(root_0, set172_tree);
                }
                state.errorRecovery=false;state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

            if ( state.backtracking==0 ) {
            } 

            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "sqlBooleanOp"

    public static class sqlAttrSpec_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "sqlAttrSpec"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1368:1: sqlAttrSpec : (v= qname -> QSTRING[format($v.text)] | VAR -> ^( T_FUNCTION_CALL NCNAME[\"_xsparql:_sql_binding_term\"] ^( T_PARAMS VAR ) ) | nl= numericliteral -> QSTRING[$nl.text] | sl= stringliteral -> QSTRING[\"'\"+$sl.text+\"'\"] | enclosedExpr );
    public final XSPARQLRewriter.sqlAttrSpec_return sqlAttrSpec() throws RecognitionException {
        XSPARQLRewriter.sqlAttrSpec_return retval = new XSPARQLRewriter.sqlAttrSpec_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree VAR173=null;
        XSPARQLRewriter.qname_return v = null;

        XSPARQLRewriter.numericliteral_return nl = null;

        XSPARQLRewriter.stringliteral_return sl = null;

        XSPARQLRewriter.enclosedExpr_return enclosedExpr174 = null;


        CommonTree VAR173_tree=null;
        RewriteRuleNodeStream stream_VAR=new RewriteRuleNodeStream(adaptor,"token VAR");
        RewriteRuleSubtreeStream stream_numericliteral=new RewriteRuleSubtreeStream(adaptor,"rule numericliteral");
        RewriteRuleSubtreeStream stream_qname=new RewriteRuleSubtreeStream(adaptor,"rule qname");
        RewriteRuleSubtreeStream stream_stringliteral=new RewriteRuleSubtreeStream(adaptor,"rule stringliteral");
        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1369:3: (v= qname -> QSTRING[format($v.text)] | VAR -> ^( T_FUNCTION_CALL NCNAME[\"_xsparql:_sql_binding_term\"] ^( T_PARAMS VAR ) ) | nl= numericliteral -> QSTRING[$nl.text] | sl= stringliteral -> QSTRING[\"'\"+$sl.text+\"'\"] | enclosedExpr )
            int alt54=5;
            switch ( input.LA(1) ) {
            case NCNAME:
            case PNAME_NS:
            case PNAME_LN:
            case A:
            case FROM:
            case ITEM:
            case NODE:
            case COMMENT:
            case ROW:
                {
                alt54=1;
                }
                break;
            case TO:
                {
                switch ( input.LA(2) ) {
                case DOWN:
                    {
                    alt54=5;
                    }
                    break;
                case EOF:
                case UP:
                case RPAR:
                case LESSTHAN:
                case GREATERTHAN:
                case GREATERTHANEQUALS:
                case LESSTHANEQUALS:
                case HAFENEQUALS:
                case EQUALS:
                case AND:
                case OR:
                    {
                    alt54=1;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 54, 2, input);

                    throw nvae;
                }

                }
                break;
            case VAR:
                {
                alt54=2;
                }
                break;
            case INTEGER:
            case DECIMAL:
                {
                alt54=3;
                }
                break;
            case QSTRING:
                {
                alt54=4;
                }
                break;
            case LCURLY:
            case STAR:
            case LESSTHAN:
            case GREATERTHAN:
            case PLUS:
            case MINUS:
            case UNIONSYMBOL:
            case LESSTHANLESSTHAN:
            case GREATERTHANEQUALS:
            case LESSTHANEQUALS:
            case HAFENEQUALS:
            case EQUALS:
            case IS:
            case EQ:
            case NE:
            case LT:
            case GE:
            case LE:
            case GT:
            case IF:
            case AND:
            case OR:
            case DIV:
            case IDIV:
            case MOD:
            case UNION:
            case INTERSECT:
            case EXCEPT:
            case GREATERTHANGREATERTHAN:
            case T_FLWOR:
            case T_INSTANCEOF:
            case T_CASTAS:
            case T_CASTABLEAS:
            case T_TREATAS:
            case EVERY:
            case TYPESWITCH:
            case VALIDATE:
            case SOME:
            case XPATH:
                {
                alt54=5;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 54, 0, input);

                throw nvae;
            }

            switch (alt54) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1369:5: v= qname
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_qname_in_sqlAttrSpec4837);
                    v=qname();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_qname.add(v.getTree());


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1369:13: -> QSTRING[format($v.text)]
                    {
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, format((v!=null?(input.getTokenStream().toString(
                          input.getTreeAdaptor().getTokenStartIndex(v.start),
                          input.getTreeAdaptor().getTokenStopIndex(v.start))):null))));

                    }

                    retval.tree = root_0;}
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1370:5: VAR
                    {
                    _last = (CommonTree)input.LT(1);
                    VAR173=(CommonTree)match(input,VAR,FOLLOW_VAR_in_sqlAttrSpec4848); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_VAR.add(VAR173);



                    // AST REWRITE
                    // elements: VAR
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1370:9: -> ^( T_FUNCTION_CALL NCNAME[\"_xsparql:_sql_binding_term\"] ^( T_PARAMS VAR ) )
                    {
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1370:12: ^( T_FUNCTION_CALL NCNAME[\"_xsparql:_sql_binding_term\"] ^( T_PARAMS VAR ) )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FUNCTION_CALL, "T_FUNCTION_CALL"), root_1);

                        adaptor.addChild(root_1, (CommonTree)adaptor.create(NCNAME, "_xsparql:_sql_binding_term"));
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1372:15: ^( T_PARAMS VAR )
                        {
                        CommonTree root_2 = (CommonTree)adaptor.nil();
                        root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_PARAMS, "T_PARAMS"), root_2);

                        adaptor.addChild(root_2, stream_VAR.nextNode());

                        adaptor.addChild(root_1, root_2);
                        }

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;}
                    }
                    break;
                case 3 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1374:5: nl= numericliteral
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numericliteral_in_sqlAttrSpec4913);
                    nl=numericliteral();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_numericliteral.add(nl.getTree());


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1374:23: -> QSTRING[$nl.text]
                    {
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, (nl!=null?(input.getTokenStream().toString(
                          input.getTreeAdaptor().getTokenStartIndex(nl.start),
                          input.getTreeAdaptor().getTokenStopIndex(nl.start))):null)));

                    }

                    retval.tree = root_0;}
                    }
                    break;
                case 4 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1375:5: sl= stringliteral
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_stringliteral_in_sqlAttrSpec4926);
                    sl=stringliteral();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_stringliteral.add(sl.getTree());


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1375:22: -> QSTRING[\"'\"+$sl.text+\"'\"]
                    {
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, "'"+(sl!=null?(input.getTokenStream().toString(
                          input.getTreeAdaptor().getTokenStartIndex(sl.start),
                          input.getTreeAdaptor().getTokenStopIndex(sl.start))):null)+"'"));

                    }

                    retval.tree = root_0;}
                    }
                    break;
                case 5 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1376:5: enclosedExpr
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_enclosedExpr_in_sqlAttrSpec4937);
                    enclosedExpr174=enclosedExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, enclosedExpr174.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "sqlAttrSpec"

    public static class generalComp_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "generalComp"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1379:1: generalComp : ( EQUALS | LESSTHAN | GREATERTHAN | LESSTHANEQUALS | GREATERTHANEQUALS | HAFENEQUALS );
    public final XSPARQLRewriter.generalComp_return generalComp() throws RecognitionException {
        XSPARQLRewriter.generalComp_return retval = new XSPARQLRewriter.generalComp_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set175=null;

        CommonTree set175_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1380:3: ( EQUALS | LESSTHAN | GREATERTHAN | LESSTHANEQUALS | GREATERTHANEQUALS | HAFENEQUALS )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            set175=(CommonTree)input.LT(1);
            if ( (input.LA(1)>=LESSTHAN && input.LA(1)<=GREATERTHAN)||(input.LA(1)>=GREATERTHANEQUALS && input.LA(1)<=EQUALS) ) {
                input.consume();

                if ( state.backtracking==0 ) {
                set175_tree = (CommonTree)adaptor.dupNode(set175);

                adaptor.addChild(root_0, set175_tree);
                }
                state.errorRecovery=false;state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

            if ( state.backtracking==0 ) {
            } 

            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "generalComp"

    protected static class sparqlForClause_scope {
        String joinVars;
        boolean containsVars;
        String evaluationFunction;
        String iterationFunction;
        String endpointURI;
    }
    protected Stack sparqlForClause_stack = new Stack();

    public static class sparqlForClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "sparqlForClause"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1391:1: sparqlForClause : ^(fo= T_SPARQL_FOR ( distinct )? (var+= varOrFunction )+ ) ( datasetClause )* (e= endpointClause )? sWhereClause ( solutionmodifier )? ( valuesClause )? -> { $VariableScope::scopedDataset }? COMMENT[$fo.token, \"XSPARQL FOR from \" + $fo.line + \":\" + $fo.pos] ^( T_LET VAR[auxResults] ^( T_FUNCTION_CALL NCNAME[sparqlFunctionScopedInner] ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS VAR[\"\\$_sparql_prefixes\"] QSTRING[\" SELECT \"] ( distinct )? ( datasetClause )* sWhereClause ( solutionmodifier )? ( valuesClause )? ) ) QSTRING[scopedDataset.peek().getId()] QSTRING[$sparqlForClause::joinVars.replaceAll(\",$\", \"\")] VAR[scopedDataset.peek().getVar()] ) ) ) ^( T_FOR VAR[auxResult] ^( AT VAR[auxResultPos] ) ^( IN ^( T_FUNCTION_CALL NCNAME[sparqlResultsFunctionNode] ^( T_PARAMS VAR[auxResults] ) ) ) ) ( ^( REWRITEVNODE[$fo.token, auxResult] $var) )+ -> {this.debugVersion}? COMMENT[$fo.token, \"XSPARQL FOR from \" + $fo.line + \":\" + $fo.pos] ^( T_LET VAR[auxResults] ^( T_FUNCTION_CALL ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:trace\"] ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS VAR[\"\\$_sparql_prefixes\"] QSTRING[\" SELECT \"] ( distinct )? ( datasetClause )* sWhereClause ( solutionmodifier )? ( valuesClause )? ) ) QSTRING[\"XSPARQL FOR from \" + $fo.line + \":\" + $fo.pos] ) ) ) ) ) ^( T_FOR VAR[auxResult] ^( AT VAR[auxResultPos] ) ^( IN ^( T_FUNCTION_CALL ^( T_PARAMS VAR[auxResults] ) ) ) ) ( ^( REWRITEVNODE[$fo.token, auxResult] $var) )+ -> COMMENT[$fo.token, \"XSPARQL FOR from \" + $fo.line + \":\" + $fo.pos] ^( T_LET VAR[auxResults] ^( T_FUNCTION_CALL ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS VAR[\"\\$_sparql_prefixes\"] QSTRING[\" SELECT \"] ( distinct )? ( datasetClause )* sWhereClause ( solutionmodifier )? ( valuesClause )? ) ) ) ) ) ^( T_FOR VAR[auxResult] ^( AT VAR[auxResultPos] ) ^( IN ^( T_FUNCTION_CALL ^( T_PARAMS VAR[auxResults] ) ) ) ) ( ^( REWRITEVNODE[$fo.token, auxResult] $var) )+ ;
    public final XSPARQLRewriter.sparqlForClause_return sparqlForClause() throws RecognitionException {
        sparqlForClause_stack.push(new sparqlForClause_scope());
        XSPARQLRewriter.sparqlForClause_return retval = new XSPARQLRewriter.sparqlForClause_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree fo=null;
        List list_var=null;
        XSPARQLRewriter.endpointClause_return e = null;

        XSPARQLRewriter.distinct_return distinct176 = null;

        XSPARQLRewriter.datasetClause_return datasetClause177 = null;

        XSPARQLRewriter.sWhereClause_return sWhereClause178 = null;

        XSPARQLRewriter.solutionmodifier_return solutionmodifier179 = null;

        XSPARQLRewriter.valuesClause_return valuesClause180 = null;

        RuleReturnScope var = null;
        CommonTree fo_tree=null;
        RewriteRuleNodeStream stream_T_SPARQL_FOR=new RewriteRuleNodeStream(adaptor,"token T_SPARQL_FOR");
        RewriteRuleSubtreeStream stream_valuesClause=new RewriteRuleSubtreeStream(adaptor,"rule valuesClause");
        RewriteRuleSubtreeStream stream_endpointClause=new RewriteRuleSubtreeStream(adaptor,"rule endpointClause");
        RewriteRuleSubtreeStream stream_sWhereClause=new RewriteRuleSubtreeStream(adaptor,"rule sWhereClause");
        RewriteRuleSubtreeStream stream_solutionmodifier=new RewriteRuleSubtreeStream(adaptor,"rule solutionmodifier");
        RewriteRuleSubtreeStream stream_distinct=new RewriteRuleSubtreeStream(adaptor,"rule distinct");
        RewriteRuleSubtreeStream stream_datasetClause=new RewriteRuleSubtreeStream(adaptor,"rule datasetClause");
        RewriteRuleSubtreeStream stream_varOrFunction=new RewriteRuleSubtreeStream(adaptor,"rule varOrFunction");

          String auxResults = getNewAuxResultsVariable();
          String auxResult = getNewAuxResultVariable();
          String auxResultPos = auxResult + "_pos";
          
          CommonTree sparqlFunctionTree = (CommonTree) adaptor.nil();
          CommonTree sparqlResultsFunctionTree = (CommonTree) adaptor.nil();
          CommonTree sparqlResultsIdTree = (CommonTree) adaptor.nil();

          ((VariableScope_scope)VariableScope_stack.peek()).sparqlClause = true; 
          ((sparqlForClause_scope)sparqlForClause_stack.peek()).joinVars = "";
          ((sparqlForClause_scope)sparqlForClause_stack.peek()).containsVars = false;

          ((sparqlForClause_scope)sparqlForClause_stack.peek()).iterationFunction = iterationFunction;
          ((sparqlForClause_scope)sparqlForClause_stack.peek()).evaluationFunction = evaluationFunction;
          logger.info("sparqlForClause");
          
          if(state.backtracking==0){
            if(outerQuery==0)
              ((VariableScope_scope)VariableScope_stack.peek()).scopedDataset = false;
            outerQuery++; 
          }

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1441:3: ( ^(fo= T_SPARQL_FOR ( distinct )? (var+= varOrFunction )+ ) ( datasetClause )* (e= endpointClause )? sWhereClause ( solutionmodifier )? ( valuesClause )? -> { $VariableScope::scopedDataset }? COMMENT[$fo.token, \"XSPARQL FOR from \" + $fo.line + \":\" + $fo.pos] ^( T_LET VAR[auxResults] ^( T_FUNCTION_CALL NCNAME[sparqlFunctionScopedInner] ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS VAR[\"\\$_sparql_prefixes\"] QSTRING[\" SELECT \"] ( distinct )? ( datasetClause )* sWhereClause ( solutionmodifier )? ( valuesClause )? ) ) QSTRING[scopedDataset.peek().getId()] QSTRING[$sparqlForClause::joinVars.replaceAll(\",$\", \"\")] VAR[scopedDataset.peek().getVar()] ) ) ) ^( T_FOR VAR[auxResult] ^( AT VAR[auxResultPos] ) ^( IN ^( T_FUNCTION_CALL NCNAME[sparqlResultsFunctionNode] ^( T_PARAMS VAR[auxResults] ) ) ) ) ( ^( REWRITEVNODE[$fo.token, auxResult] $var) )+ -> {this.debugVersion}? COMMENT[$fo.token, \"XSPARQL FOR from \" + $fo.line + \":\" + $fo.pos] ^( T_LET VAR[auxResults] ^( T_FUNCTION_CALL ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:trace\"] ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS VAR[\"\\$_sparql_prefixes\"] QSTRING[\" SELECT \"] ( distinct )? ( datasetClause )* sWhereClause ( solutionmodifier )? ( valuesClause )? ) ) QSTRING[\"XSPARQL FOR from \" + $fo.line + \":\" + $fo.pos] ) ) ) ) ) ^( T_FOR VAR[auxResult] ^( AT VAR[auxResultPos] ) ^( IN ^( T_FUNCTION_CALL ^( T_PARAMS VAR[auxResults] ) ) ) ) ( ^( REWRITEVNODE[$fo.token, auxResult] $var) )+ -> COMMENT[$fo.token, \"XSPARQL FOR from \" + $fo.line + \":\" + $fo.pos] ^( T_LET VAR[auxResults] ^( T_FUNCTION_CALL ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS VAR[\"\\$_sparql_prefixes\"] QSTRING[\" SELECT \"] ( distinct )? ( datasetClause )* sWhereClause ( solutionmodifier )? ( valuesClause )? ) ) ) ) ) ^( T_FOR VAR[auxResult] ^( AT VAR[auxResultPos] ) ^( IN ^( T_FUNCTION_CALL ^( T_PARAMS VAR[auxResults] ) ) ) ) ( ^( REWRITEVNODE[$fo.token, auxResult] $var) )+ )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1441:5: ^(fo= T_SPARQL_FOR ( distinct )? (var+= varOrFunction )+ ) ( datasetClause )* (e= endpointClause )? sWhereClause ( solutionmodifier )? ( valuesClause )?
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            fo=(CommonTree)match(input,T_SPARQL_FOR,FOLLOW_T_SPARQL_FOR_in_sparqlForClause5013); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_T_SPARQL_FOR.add(fo);



            match(input, Token.DOWN, null); if (state.failed) return retval;
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1441:23: ( distinct )?
            int alt55=2;
            switch ( input.LA(1) ) {
                case DISTINCT:
                case REDUCED:
                    {
                    alt55=1;
                    }
                    break;
            }

            switch (alt55) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: distinct
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_distinct_in_sparqlForClause5015);
                    distinct176=distinct();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_distinct.add(distinct176.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }

            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1441:36: (var+= varOrFunction )+
            int cnt56=0;
            loop56:
            do {
                int alt56=2;
                switch ( input.LA(1) ) {
                case VAR:
                case LPAR:
                    {
                    alt56=1;
                    }
                    break;

                }

                switch (alt56) {
            	case 1 :
            	    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: var+= varOrFunction
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_varOrFunction_in_sparqlForClause5020);
            	    var=varOrFunction();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) stream_varOrFunction.add(var.getTree());
            	    if (list_var==null) list_var=new ArrayList();
            	    list_var.add(var.getTree());


            	    if ( state.backtracking==0 ) {
            	    }
            	    }
            	    break;

            	default :
            	    if ( cnt56 >= 1 ) break loop56;
            	    if (state.backtracking>0) {state.failed=true; return retval;}
                        EarlyExitException eee =
                            new EarlyExitException(56, input);
                        throw eee;
                }
                cnt56++;
            } while (true);

            if ( state.backtracking==0 ) {
               addVariablesToScope(list_var, Types.SPARQL); 
              //                                                      addGeneratedVariablesToScope(list_var); 
                                                                    addPositionVariableToScope(auxResultPos); 
            }

            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }

            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1444:8: ( datasetClause )*
            loop57:
            do {
                int alt57=2;
                switch ( input.LA(1) ) {
                case FROM:
                    {
                    alt57=1;
                    }
                    break;

                }

                switch (alt57) {
            	case 1 :
            	    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: datasetClause
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_datasetClause_in_sparqlForClause5032);
            	    datasetClause177=datasetClause();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) stream_datasetClause.add(datasetClause177.getTree());

            	    if ( state.backtracking==0 ) {
            	    }
            	    }
            	    break;

            	default :
            	    break loop57;
                }
            } while (true);

            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1444:24: (e= endpointClause )?
            int alt58=2;
            switch ( input.LA(1) ) {
                case ENDPOINT:
                    {
                    alt58=1;
                    }
                    break;
            }

            switch (alt58) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: e= endpointClause
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_endpointClause_in_sparqlForClause5037);
                    e=endpointClause();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_endpointClause.add(e.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_sWhereClause_in_sparqlForClause5040);
            sWhereClause178=sWhereClause();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_sWhereClause.add(sWhereClause178.getTree());
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1444:54: ( solutionmodifier )?
            int alt59=2;
            switch ( input.LA(1) ) {
                case LIMIT:
                case OFFSET:
                case T_ORDER_BY:
                case T_GROUP_BY:
                case T_HAVING:
                    {
                    alt59=1;
                    }
                    break;
                case VALUES:
                    {
                    int LA59_2 = input.LA(2);

                    if ( (synpred94_XSPARQLRewriter()) ) {
                        alt59=1;
                    }
                    }
                    break;
                case T_RETURN:
                    {
                    int LA59_3 = input.LA(2);

                    if ( (synpred94_XSPARQLRewriter()) ) {
                        alt59=1;
                    }
                    }
                    break;
                case T_CONSTRUCT:
                    {
                    int LA59_4 = input.LA(2);

                    if ( (synpred94_XSPARQLRewriter()) ) {
                        alt59=1;
                    }
                    }
                    break;
                case UP:
                    {
                    int LA59_5 = input.LA(2);

                    if ( (synpred94_XSPARQLRewriter()) ) {
                        alt59=1;
                    }
                    }
                    break;
                case EOF:
                    {
                    int LA59_6 = input.LA(2);

                    if ( (synpred94_XSPARQLRewriter()) ) {
                        alt59=1;
                    }
                    }
                    break;
            }

            switch (alt59) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: solutionmodifier
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_solutionmodifier_in_sparqlForClause5042);
                    solutionmodifier179=solutionmodifier();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_solutionmodifier.add(solutionmodifier179.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }

            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1444:72: ( valuesClause )?
            int alt60=2;
            switch ( input.LA(1) ) {
                case VALUES:
                    {
                    alt60=1;
                    }
                    break;
            }

            switch (alt60) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: valuesClause
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valuesClause_in_sparqlForClause5045);
                    valuesClause180=valuesClause();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_valuesClause.add(valuesClause180.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }



            // AST REWRITE
            // elements: valuesClause, valuesClause, distinct, var, sWhereClause, datasetClause, solutionmodifier, datasetClause, solutionmodifier, distinct, valuesClause, datasetClause, distinct, solutionmodifier, sWhereClause, sWhereClause, var, var
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: var
            // wildcard labels: 
            if ( state.backtracking==0 ) {
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_var=new RewriteRuleSubtreeStream(adaptor,"token var",list_var);
            root_0 = (CommonTree)adaptor.nil();
            // 1447:3: -> { $VariableScope::scopedDataset }? COMMENT[$fo.token, \"XSPARQL FOR from \" + $fo.line + \":\" + $fo.pos] ^( T_LET VAR[auxResults] ^( T_FUNCTION_CALL NCNAME[sparqlFunctionScopedInner] ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS VAR[\"\\$_sparql_prefixes\"] QSTRING[\" SELECT \"] ( distinct )? ( datasetClause )* sWhereClause ( solutionmodifier )? ( valuesClause )? ) ) QSTRING[scopedDataset.peek().getId()] QSTRING[$sparqlForClause::joinVars.replaceAll(\",$\", \"\")] VAR[scopedDataset.peek().getVar()] ) ) ) ^( T_FOR VAR[auxResult] ^( AT VAR[auxResultPos] ) ^( IN ^( T_FUNCTION_CALL NCNAME[sparqlResultsFunctionNode] ^( T_PARAMS VAR[auxResults] ) ) ) ) ( ^( REWRITEVNODE[$fo.token, auxResult] $var) )+
            if ( ((VariableScope_scope)VariableScope_stack.peek()).scopedDataset ) {
                adaptor.addChild(root_0, (CommonTree)adaptor.create(COMMENT, fo.token, "XSPARQL FOR from " + (fo!=null?fo.getLine():0) + ":" + (fo!=null?fo.getCharPositionInLine():0)));
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1449:6: ^( T_LET VAR[auxResults] ^( T_FUNCTION_CALL NCNAME[sparqlFunctionScopedInner] ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS VAR[\"\\$_sparql_prefixes\"] QSTRING[\" SELECT \"] ( distinct )? ( datasetClause )* sWhereClause ( solutionmodifier )? ( valuesClause )? ) ) QSTRING[scopedDataset.peek().getId()] QSTRING[$sparqlForClause::joinVars.replaceAll(\",$\", \"\")] VAR[scopedDataset.peek().getVar()] ) ) )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_LET, "T_LET"), root_1);

                adaptor.addChild(root_1, (CommonTree)adaptor.create(VAR, auxResults));
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1450:13: ^( T_FUNCTION_CALL NCNAME[sparqlFunctionScopedInner] ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS VAR[\"\\$_sparql_prefixes\"] QSTRING[\" SELECT \"] ( distinct )? ( datasetClause )* sWhereClause ( solutionmodifier )? ( valuesClause )? ) ) QSTRING[scopedDataset.peek().getId()] QSTRING[$sparqlForClause::joinVars.replaceAll(\",$\", \"\")] VAR[scopedDataset.peek().getVar()] ) )
                {
                CommonTree root_2 = (CommonTree)adaptor.nil();
                root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FUNCTION_CALL, "T_FUNCTION_CALL"), root_2);

                adaptor.addChild(root_2, (CommonTree)adaptor.create(NCNAME, sparqlFunctionScopedInner));
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1452:15: ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS VAR[\"\\$_sparql_prefixes\"] QSTRING[\" SELECT \"] ( distinct )? ( datasetClause )* sWhereClause ( solutionmodifier )? ( valuesClause )? ) ) QSTRING[scopedDataset.peek().getId()] QSTRING[$sparqlForClause::joinVars.replaceAll(\",$\", \"\")] VAR[scopedDataset.peek().getVar()] )
                {
                CommonTree root_3 = (CommonTree)adaptor.nil();
                root_3 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_PARAMS, "T_PARAMS"), root_3);

                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1453:16: ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS VAR[\"\\$_sparql_prefixes\"] QSTRING[\" SELECT \"] ( distinct )? ( datasetClause )* sWhereClause ( solutionmodifier )? ( valuesClause )? ) )
                {
                CommonTree root_4 = (CommonTree)adaptor.nil();
                root_4 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FUNCTION_CALL, "T_FUNCTION_CALL"), root_4);

                adaptor.addChild(root_4, (CommonTree)adaptor.create(NCNAME, "fn:concat"));
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1455:15: ^( T_PARAMS VAR[\"\\$_sparql_prefixes\"] QSTRING[\" SELECT \"] ( distinct )? ( datasetClause )* sWhereClause ( solutionmodifier )? ( valuesClause )? )
                {
                CommonTree root_5 = (CommonTree)adaptor.nil();
                root_5 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_PARAMS, "T_PARAMS"), root_5);

                adaptor.addChild(root_5, (CommonTree)adaptor.create(VAR, "$_sparql_prefixes"));
                adaptor.addChild(root_5, (CommonTree)adaptor.create(QSTRING, " SELECT "));
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1459:18: ( distinct )?
                if ( stream_distinct.hasNext() ) {
                    adaptor.addChild(root_5, stream_distinct.nextTree());

                }
                stream_distinct.reset();
                adaptor.addChild(root_5, getVarList(list_var));
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1461:18: ( datasetClause )*
                while ( stream_datasetClause.hasNext() ) {
                    adaptor.addChild(root_5, stream_datasetClause.nextTree());

                }
                stream_datasetClause.reset();
                adaptor.addChild(root_5, stream_sWhereClause.nextTree());
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1463:18: ( solutionmodifier )?
                if ( stream_solutionmodifier.hasNext() ) {
                    adaptor.addChild(root_5, stream_solutionmodifier.nextTree());

                }
                stream_solutionmodifier.reset();
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1464:18: ( valuesClause )?
                if ( stream_valuesClause.hasNext() ) {
                    adaptor.addChild(root_5, stream_valuesClause.nextTree());

                }
                stream_valuesClause.reset();

                adaptor.addChild(root_4, root_5);
                }

                adaptor.addChild(root_3, root_4);
                }
                adaptor.addChild(root_3, (CommonTree)adaptor.create(QSTRING, scopedDataset.peek().getId()));
                adaptor.addChild(root_3, (CommonTree)adaptor.create(QSTRING, ((sparqlForClause_scope)sparqlForClause_stack.peek()).joinVars.replaceAll(",$", "")));
                adaptor.addChild(root_3, (CommonTree)adaptor.create(VAR, scopedDataset.peek().getVar()));

                adaptor.addChild(root_2, root_3);
                }

                adaptor.addChild(root_1, root_2);
                }

                adaptor.addChild(root_0, root_1);
                }
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1473:5: ^( T_FOR VAR[auxResult] ^( AT VAR[auxResultPos] ) ^( IN ^( T_FUNCTION_CALL NCNAME[sparqlResultsFunctionNode] ^( T_PARAMS VAR[auxResults] ) ) ) )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FOR, "T_FOR"), root_1);

                adaptor.addChild(root_1, (CommonTree)adaptor.create(VAR, auxResult));
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1475:7: ^( AT VAR[auxResultPos] )
                {
                CommonTree root_2 = (CommonTree)adaptor.nil();
                root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(AT, "AT"), root_2);

                adaptor.addChild(root_2, (CommonTree)adaptor.create(VAR, auxResultPos));

                adaptor.addChild(root_1, root_2);
                }
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1478:7: ^( IN ^( T_FUNCTION_CALL NCNAME[sparqlResultsFunctionNode] ^( T_PARAMS VAR[auxResults] ) ) )
                {
                CommonTree root_2 = (CommonTree)adaptor.nil();
                root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(IN, "IN"), root_2);

                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1479:9: ^( T_FUNCTION_CALL NCNAME[sparqlResultsFunctionNode] ^( T_PARAMS VAR[auxResults] ) )
                {
                CommonTree root_3 = (CommonTree)adaptor.nil();
                root_3 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FUNCTION_CALL, "T_FUNCTION_CALL"), root_3);

                adaptor.addChild(root_3, (CommonTree)adaptor.create(NCNAME, sparqlResultsFunctionNode));
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1481:11: ^( T_PARAMS VAR[auxResults] )
                {
                CommonTree root_4 = (CommonTree)adaptor.nil();
                root_4 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_PARAMS, "T_PARAMS"), root_4);

                adaptor.addChild(root_4, (CommonTree)adaptor.create(VAR, auxResults));

                adaptor.addChild(root_3, root_4);
                }

                adaptor.addChild(root_2, root_3);
                }

                adaptor.addChild(root_1, root_2);
                }

                adaptor.addChild(root_0, root_1);
                }
                if ( !(stream_var.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_var.hasNext() ) {
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1487:5: ^( REWRITEVNODE[$fo.token, auxResult] $var)
                    {
                    CommonTree root_1 = (CommonTree)adaptor.nil();
                    root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(REWRITEVNODE, fo.token, auxResult), root_1);

                    adaptor.addChild(root_1, stream_var.nextTree());

                    adaptor.addChild(root_0, root_1);
                    }

                }
                stream_var.reset();

            }
            else // 1490:3: -> {this.debugVersion}? COMMENT[$fo.token, \"XSPARQL FOR from \" + $fo.line + \":\" + $fo.pos] ^( T_LET VAR[auxResults] ^( T_FUNCTION_CALL ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:trace\"] ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS VAR[\"\\$_sparql_prefixes\"] QSTRING[\" SELECT \"] ( distinct )? ( datasetClause )* sWhereClause ( solutionmodifier )? ( valuesClause )? ) ) QSTRING[\"XSPARQL FOR from \" + $fo.line + \":\" + $fo.pos] ) ) ) ) ) ^( T_FOR VAR[auxResult] ^( AT VAR[auxResultPos] ) ^( IN ^( T_FUNCTION_CALL ^( T_PARAMS VAR[auxResults] ) ) ) ) ( ^( REWRITEVNODE[$fo.token, auxResult] $var) )+
            if (this.debugVersion) {
                adaptor.addChild(root_0, (CommonTree)adaptor.create(COMMENT, fo.token, "XSPARQL FOR from " + (fo!=null?fo.getLine():0) + ":" + (fo!=null?fo.getCharPositionInLine():0)));
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1492:6: ^( T_LET VAR[auxResults] ^( T_FUNCTION_CALL ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:trace\"] ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS VAR[\"\\$_sparql_prefixes\"] QSTRING[\" SELECT \"] ( distinct )? ( datasetClause )* sWhereClause ( solutionmodifier )? ( valuesClause )? ) ) QSTRING[\"XSPARQL FOR from \" + $fo.line + \":\" + $fo.pos] ) ) ) ) )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_LET, "T_LET"), root_1);

                adaptor.addChild(root_1, (CommonTree)adaptor.create(VAR, auxResults));
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1493:8: ^( T_FUNCTION_CALL ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:trace\"] ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS VAR[\"\\$_sparql_prefixes\"] QSTRING[\" SELECT \"] ( distinct )? ( datasetClause )* sWhereClause ( solutionmodifier )? ( valuesClause )? ) ) QSTRING[\"XSPARQL FOR from \" + $fo.line + \":\" + $fo.pos] ) ) ) )
                {
                CommonTree root_2 = (CommonTree)adaptor.nil();
                root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FUNCTION_CALL, "T_FUNCTION_CALL"), root_2);

                adaptor.addChild(root_2,  sparqlFunctionTree = new CommonTree(new CommonToken(NCNAME, ((sparqlForClause_scope)sparqlForClause_stack.peek()).evaluationFunction)) );
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1495:10: ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:trace\"] ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS VAR[\"\\$_sparql_prefixes\"] QSTRING[\" SELECT \"] ( distinct )? ( datasetClause )* sWhereClause ( solutionmodifier )? ( valuesClause )? ) ) QSTRING[\"XSPARQL FOR from \" + $fo.line + \":\" + $fo.pos] ) ) )
                {
                CommonTree root_3 = (CommonTree)adaptor.nil();
                root_3 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_PARAMS, "T_PARAMS"), root_3);

                adaptor.addChild(root_3,  endpointURI(((sparqlForClause_scope)sparqlForClause_stack.peek()).endpointURI) );
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1496:12: ^( T_FUNCTION_CALL NCNAME[\"fn:trace\"] ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS VAR[\"\\$_sparql_prefixes\"] QSTRING[\" SELECT \"] ( distinct )? ( datasetClause )* sWhereClause ( solutionmodifier )? ( valuesClause )? ) ) QSTRING[\"XSPARQL FOR from \" + $fo.line + \":\" + $fo.pos] ) )
                {
                CommonTree root_4 = (CommonTree)adaptor.nil();
                root_4 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FUNCTION_CALL, "T_FUNCTION_CALL"), root_4);

                adaptor.addChild(root_4, (CommonTree)adaptor.create(NCNAME, "fn:trace"));
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1498:14: ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS VAR[\"\\$_sparql_prefixes\"] QSTRING[\" SELECT \"] ( distinct )? ( datasetClause )* sWhereClause ( solutionmodifier )? ( valuesClause )? ) ) QSTRING[\"XSPARQL FOR from \" + $fo.line + \":\" + $fo.pos] )
                {
                CommonTree root_5 = (CommonTree)adaptor.nil();
                root_5 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_PARAMS, "T_PARAMS"), root_5);

                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1499:16: ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS VAR[\"\\$_sparql_prefixes\"] QSTRING[\" SELECT \"] ( distinct )? ( datasetClause )* sWhereClause ( solutionmodifier )? ( valuesClause )? ) )
                {
                CommonTree root_6 = (CommonTree)adaptor.nil();
                root_6 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FUNCTION_CALL, "T_FUNCTION_CALL"), root_6);

                adaptor.addChild(root_6, (CommonTree)adaptor.create(NCNAME, "fn:concat"));
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1501:18: ^( T_PARAMS VAR[\"\\$_sparql_prefixes\"] QSTRING[\" SELECT \"] ( distinct )? ( datasetClause )* sWhereClause ( solutionmodifier )? ( valuesClause )? )
                {
                CommonTree root_7 = (CommonTree)adaptor.nil();
                root_7 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_PARAMS, "T_PARAMS"), root_7);

                adaptor.addChild(root_7, (CommonTree)adaptor.create(VAR, "$_sparql_prefixes"));
                adaptor.addChild(root_7, (CommonTree)adaptor.create(QSTRING, " SELECT "));
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1505:20: ( distinct )?
                if ( stream_distinct.hasNext() ) {
                    adaptor.addChild(root_7, stream_distinct.nextTree());

                }
                stream_distinct.reset();
                adaptor.addChild(root_7, getVarList(list_var));
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1506:20: ( datasetClause )*
                while ( stream_datasetClause.hasNext() ) {
                    adaptor.addChild(root_7, stream_datasetClause.nextTree());

                }
                stream_datasetClause.reset();
                adaptor.addChild(root_7, stream_sWhereClause.nextTree());
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1508:20: ( solutionmodifier )?
                if ( stream_solutionmodifier.hasNext() ) {
                    adaptor.addChild(root_7, stream_solutionmodifier.nextTree());

                }
                stream_solutionmodifier.reset();
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1509:20: ( valuesClause )?
                if ( stream_valuesClause.hasNext() ) {
                    adaptor.addChild(root_7, stream_valuesClause.nextTree());

                }
                stream_valuesClause.reset();

                adaptor.addChild(root_6, root_7);
                }

                adaptor.addChild(root_5, root_6);
                }
                adaptor.addChild(root_5,  sparqlResultsIdTree = new CommonTree(new CommonToken(DELETEVNODE, "deleteNode")) );
                adaptor.addChild(root_5, (CommonTree)adaptor.create(QSTRING, "XSPARQL FOR from " + (fo!=null?fo.getLine():0) + ":" + (fo!=null?fo.getCharPositionInLine():0)));

                adaptor.addChild(root_4, root_5);
                }

                adaptor.addChild(root_3, root_4);
                }

                adaptor.addChild(root_2, root_3);
                }

                adaptor.addChild(root_1, root_2);
                }

                adaptor.addChild(root_0, root_1);
                }
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1519:6: ^( T_FOR VAR[auxResult] ^( AT VAR[auxResultPos] ) ^( IN ^( T_FUNCTION_CALL ^( T_PARAMS VAR[auxResults] ) ) ) )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FOR, "T_FOR"), root_1);

                adaptor.addChild(root_1, (CommonTree)adaptor.create(VAR, auxResult));
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1521:8: ^( AT VAR[auxResultPos] )
                {
                CommonTree root_2 = (CommonTree)adaptor.nil();
                root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(AT, "AT"), root_2);

                adaptor.addChild(root_2, (CommonTree)adaptor.create(VAR, auxResultPos));

                adaptor.addChild(root_1, root_2);
                }
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1524:8: ^( IN ^( T_FUNCTION_CALL ^( T_PARAMS VAR[auxResults] ) ) )
                {
                CommonTree root_2 = (CommonTree)adaptor.nil();
                root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(IN, "IN"), root_2);

                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1525:10: ^( T_FUNCTION_CALL ^( T_PARAMS VAR[auxResults] ) )
                {
                CommonTree root_3 = (CommonTree)adaptor.nil();
                root_3 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FUNCTION_CALL, "T_FUNCTION_CALL"), root_3);

                adaptor.addChild(root_3,  sparqlResultsFunctionTree = new CommonTree(new CommonToken(NCNAME, ((sparqlForClause_scope)sparqlForClause_stack.peek()).iterationFunction)) );
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1527:12: ^( T_PARAMS VAR[auxResults] )
                {
                CommonTree root_4 = (CommonTree)adaptor.nil();
                root_4 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_PARAMS, "T_PARAMS"), root_4);

                adaptor.addChild(root_4, (CommonTree)adaptor.create(VAR, auxResults));

                adaptor.addChild(root_3, root_4);
                }

                adaptor.addChild(root_2, root_3);
                }

                adaptor.addChild(root_1, root_2);
                }

                adaptor.addChild(root_0, root_1);
                }
                if ( !(stream_var.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_var.hasNext() ) {
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1533:6: ^( REWRITEVNODE[$fo.token, auxResult] $var)
                    {
                    CommonTree root_1 = (CommonTree)adaptor.nil();
                    root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(REWRITEVNODE, fo.token, auxResult), root_1);

                    adaptor.addChild(root_1, stream_var.nextTree());

                    adaptor.addChild(root_0, root_1);
                    }

                }
                stream_var.reset();

            }
            else // 1535:3: -> COMMENT[$fo.token, \"XSPARQL FOR from \" + $fo.line + \":\" + $fo.pos] ^( T_LET VAR[auxResults] ^( T_FUNCTION_CALL ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS VAR[\"\\$_sparql_prefixes\"] QSTRING[\" SELECT \"] ( distinct )? ( datasetClause )* sWhereClause ( solutionmodifier )? ( valuesClause )? ) ) ) ) ) ^( T_FOR VAR[auxResult] ^( AT VAR[auxResultPos] ) ^( IN ^( T_FUNCTION_CALL ^( T_PARAMS VAR[auxResults] ) ) ) ) ( ^( REWRITEVNODE[$fo.token, auxResult] $var) )+
            {
                adaptor.addChild(root_0, (CommonTree)adaptor.create(COMMENT, fo.token, "XSPARQL FOR from " + (fo!=null?fo.getLine():0) + ":" + (fo!=null?fo.getCharPositionInLine():0)));
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1536:6: ^( T_LET VAR[auxResults] ^( T_FUNCTION_CALL ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS VAR[\"\\$_sparql_prefixes\"] QSTRING[\" SELECT \"] ( distinct )? ( datasetClause )* sWhereClause ( solutionmodifier )? ( valuesClause )? ) ) ) ) )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_LET, "T_LET"), root_1);

                adaptor.addChild(root_1, (CommonTree)adaptor.create(VAR, auxResults));
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1537:8: ^( T_FUNCTION_CALL ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS VAR[\"\\$_sparql_prefixes\"] QSTRING[\" SELECT \"] ( distinct )? ( datasetClause )* sWhereClause ( solutionmodifier )? ( valuesClause )? ) ) ) )
                {
                CommonTree root_2 = (CommonTree)adaptor.nil();
                root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FUNCTION_CALL, "T_FUNCTION_CALL"), root_2);

                adaptor.addChild(root_2,  sparqlFunctionTree = new CommonTree(new CommonToken(NCNAME, ((sparqlForClause_scope)sparqlForClause_stack.peek()).evaluationFunction)) );
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1539:10: ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS VAR[\"\\$_sparql_prefixes\"] QSTRING[\" SELECT \"] ( distinct )? ( datasetClause )* sWhereClause ( solutionmodifier )? ( valuesClause )? ) ) )
                {
                CommonTree root_3 = (CommonTree)adaptor.nil();
                root_3 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_PARAMS, "T_PARAMS"), root_3);

                adaptor.addChild(root_3,  endpointURI(((sparqlForClause_scope)sparqlForClause_stack.peek()).endpointURI) );
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1540:12: ^( T_FUNCTION_CALL NCNAME[\"fn:concat\"] ^( T_PARAMS VAR[\"\\$_sparql_prefixes\"] QSTRING[\" SELECT \"] ( distinct )? ( datasetClause )* sWhereClause ( solutionmodifier )? ( valuesClause )? ) )
                {
                CommonTree root_4 = (CommonTree)adaptor.nil();
                root_4 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FUNCTION_CALL, "T_FUNCTION_CALL"), root_4);

                adaptor.addChild(root_4, (CommonTree)adaptor.create(NCNAME, "fn:concat"));
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1542:14: ^( T_PARAMS VAR[\"\\$_sparql_prefixes\"] QSTRING[\" SELECT \"] ( distinct )? ( datasetClause )* sWhereClause ( solutionmodifier )? ( valuesClause )? )
                {
                CommonTree root_5 = (CommonTree)adaptor.nil();
                root_5 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_PARAMS, "T_PARAMS"), root_5);

                adaptor.addChild(root_5, (CommonTree)adaptor.create(VAR, "$_sparql_prefixes"));
                adaptor.addChild(root_5, (CommonTree)adaptor.create(QSTRING, " SELECT "));
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1546:16: ( distinct )?
                if ( stream_distinct.hasNext() ) {
                    adaptor.addChild(root_5, stream_distinct.nextTree());

                }
                stream_distinct.reset();
                adaptor.addChild(root_5, getVarList(list_var));
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1547:16: ( datasetClause )*
                while ( stream_datasetClause.hasNext() ) {
                    adaptor.addChild(root_5, stream_datasetClause.nextTree());

                }
                stream_datasetClause.reset();
                adaptor.addChild(root_5, stream_sWhereClause.nextTree());
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1549:16: ( solutionmodifier )?
                if ( stream_solutionmodifier.hasNext() ) {
                    adaptor.addChild(root_5, stream_solutionmodifier.nextTree());

                }
                stream_solutionmodifier.reset();
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1550:16: ( valuesClause )?
                if ( stream_valuesClause.hasNext() ) {
                    adaptor.addChild(root_5, stream_valuesClause.nextTree());

                }
                stream_valuesClause.reset();

                adaptor.addChild(root_4, root_5);
                }

                adaptor.addChild(root_3, root_4);
                }
                adaptor.addChild(root_3,  sparqlResultsIdTree = new CommonTree(new CommonToken(DELETEVNODE, "deleteNode")) );

                adaptor.addChild(root_2, root_3);
                }

                adaptor.addChild(root_1, root_2);
                }

                adaptor.addChild(root_0, root_1);
                }
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1557:6: ^( T_FOR VAR[auxResult] ^( AT VAR[auxResultPos] ) ^( IN ^( T_FUNCTION_CALL ^( T_PARAMS VAR[auxResults] ) ) ) )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FOR, "T_FOR"), root_1);

                adaptor.addChild(root_1, (CommonTree)adaptor.create(VAR, auxResult));
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1559:8: ^( AT VAR[auxResultPos] )
                {
                CommonTree root_2 = (CommonTree)adaptor.nil();
                root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(AT, "AT"), root_2);

                adaptor.addChild(root_2, (CommonTree)adaptor.create(VAR, auxResultPos));

                adaptor.addChild(root_1, root_2);
                }
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1562:8: ^( IN ^( T_FUNCTION_CALL ^( T_PARAMS VAR[auxResults] ) ) )
                {
                CommonTree root_2 = (CommonTree)adaptor.nil();
                root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(IN, "IN"), root_2);

                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1563:10: ^( T_FUNCTION_CALL ^( T_PARAMS VAR[auxResults] ) )
                {
                CommonTree root_3 = (CommonTree)adaptor.nil();
                root_3 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FUNCTION_CALL, "T_FUNCTION_CALL"), root_3);

                adaptor.addChild(root_3,  sparqlResultsFunctionTree = new CommonTree(new CommonToken(NCNAME, ((sparqlForClause_scope)sparqlForClause_stack.peek()).iterationFunction)) );
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1565:12: ^( T_PARAMS VAR[auxResults] )
                {
                CommonTree root_4 = (CommonTree)adaptor.nil();
                root_4 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_PARAMS, "T_PARAMS"), root_4);

                adaptor.addChild(root_4, (CommonTree)adaptor.create(VAR, auxResults));

                adaptor.addChild(root_3, root_4);
                }

                adaptor.addChild(root_2, root_3);
                }

                adaptor.addChild(root_1, root_2);
                }

                adaptor.addChild(root_0, root_1);
                }
                if ( !(stream_var.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_var.hasNext() ) {
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1571:6: ^( REWRITEVNODE[$fo.token, auxResult] $var)
                    {
                    CommonTree root_1 = (CommonTree)adaptor.nil();
                    root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(REWRITEVNODE, fo.token, auxResult), root_1);

                    adaptor.addChild(root_1, stream_var.nextTree());

                    adaptor.addChild(root_0, root_1);
                    }

                }
                stream_var.reset();

            }

            retval.tree = root_0;}
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
            if ( state.backtracking==0 ) {

                logger.info("Creating new variable scope: sparqlForClause-1");

                if(state.backtracking==0){
                  outerQuery--;
                }
                if(((VariableScope_scope)VariableScope_stack.peek()).scopedDataset) {
                  changeTreeToScopedDataset();
                } 

                ScopedDataset sd = new ScopedDataset (((VariableScope_scope)VariableScope_stack.peek()).scopedDataset, 
                                                      ((VariableScope_scope)VariableScope_stack.peek()).scopedDataset?scopedDataset.peek().getId():UUID.randomUUID().toString(), 
                                                      sparqlFunctionTree, 
                                                      sparqlResultsFunctionTree, 
                                                      sparqlResultsIdTree, 
                                                      auxResultPos); 
                scopedDataset.add(sd); 

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
            sparqlForClause_stack.pop();
        }
        return retval;
    }
    // $ANTLR end "sparqlForClause"

    public static class endpointClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "endpointClause"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1574:1: endpointClause : ENDPOINT e= sourceSelector ;
    public final XSPARQLRewriter.endpointClause_return endpointClause() throws RecognitionException {
        XSPARQLRewriter.endpointClause_return retval = new XSPARQLRewriter.endpointClause_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree ENDPOINT181=null;
        XSPARQLRewriter.sourceSelector_return e = null;


        CommonTree ENDPOINT181_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1575:3: ( ENDPOINT e= sourceSelector )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1575:5: ENDPOINT e= sourceSelector
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            ENDPOINT181=(CommonTree)match(input,ENDPOINT,FOLLOW_ENDPOINT_in_endpointClause6757); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            ENDPOINT181_tree = (CommonTree)adaptor.dupNode(ENDPOINT181);

            adaptor.addChild(root_0, ENDPOINT181_tree);
            }
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_sourceSelector_in_endpointClause6761);
            e=sourceSelector();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_0, e.getTree());
            if ( state.backtracking==0 ) {
               ((sparqlForClause_scope)sparqlForClause_stack.peek()).iterationFunction = xsparqlAbbrev+":_sparqlResults";
                                              ((sparqlForClause_scope)sparqlForClause_stack.peek()).evaluationFunction = xsparqlAbbrev+":_sparql";
                                              ((sparqlForClause_scope)sparqlForClause_stack.peek()).endpointURI = (e!=null?(input.getTokenStream().toString(
                input.getTreeAdaptor().getTokenStartIndex(e.start),
                input.getTreeAdaptor().getTokenStopIndex(e.start))):null);
                
            }

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "endpointClause"

    public static class varOrFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "varOrFunction"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1581:1: varOrFunction : (v= VAR -> {isBoundEarlier($v.text)}? NOTHING[$v.text] -> | LPAR expression AS v= VAR RPAR -> ^( T_ASVAR LPAR expression AS RPAR ) );
    public final XSPARQLRewriter.varOrFunction_return varOrFunction() throws RecognitionException {
        XSPARQLRewriter.varOrFunction_return retval = new XSPARQLRewriter.varOrFunction_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree v=null;
        CommonTree LPAR182=null;
        CommonTree AS184=null;
        CommonTree RPAR185=null;
        XSPARQLRewriter.expression_return expression183 = null;


        CommonTree v_tree=null;
        CommonTree LPAR182_tree=null;
        CommonTree AS184_tree=null;
        CommonTree RPAR185_tree=null;
        RewriteRuleNodeStream stream_AS=new RewriteRuleNodeStream(adaptor,"token AS");
        RewriteRuleNodeStream stream_VAR=new RewriteRuleNodeStream(adaptor,"token VAR");
        RewriteRuleNodeStream stream_LPAR=new RewriteRuleNodeStream(adaptor,"token LPAR");
        RewriteRuleNodeStream stream_RPAR=new RewriteRuleNodeStream(adaptor,"token RPAR");
        RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1582:3: (v= VAR -> {isBoundEarlier($v.text)}? NOTHING[$v.text] -> | LPAR expression AS v= VAR RPAR -> ^( T_ASVAR LPAR expression AS RPAR ) )
            int alt61=2;
            switch ( input.LA(1) ) {
            case VAR:
                {
                alt61=1;
                }
                break;
            case LPAR:
                {
                alt61=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 61, 0, input);

                throw nvae;
            }

            switch (alt61) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1582:5: v= VAR
                    {
                    _last = (CommonTree)input.LT(1);
                    v=(CommonTree)match(input,VAR,FOLLOW_VAR_in_varOrFunction6778); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_VAR.add(v);



                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1583:3: -> {isBoundEarlier($v.text)}? NOTHING[$v.text]
                    if (isBoundEarlier((v!=null?v.getText():null))) {
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(NOTHING, (v!=null?v.getText():null)));

                    }
                    else // 1584:3: ->
                    {
                        adaptor.addChild(root_0,  unboundVar((v!=null?v.getText():null)) );

                    }

                    retval.tree = root_0;}
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1585:5: LPAR expression AS v= VAR RPAR
                    {
                    _last = (CommonTree)input.LT(1);
                    LPAR182=(CommonTree)match(input,LPAR,FOLLOW_LPAR_in_varOrFunction6801); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_LPAR.add(LPAR182);

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_varOrFunction6803);
                    expression183=expression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_expression.add(expression183.getTree());
                    _last = (CommonTree)input.LT(1);
                    AS184=(CommonTree)match(input,AS,FOLLOW_AS_in_varOrFunction6805); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_AS.add(AS184);

                    _last = (CommonTree)input.LT(1);
                    v=(CommonTree)match(input,VAR,FOLLOW_VAR_in_varOrFunction6809); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_VAR.add(v);

                    _last = (CommonTree)input.LT(1);
                    RPAR185=(CommonTree)match(input,RPAR,FOLLOW_RPAR_in_varOrFunction6811); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_RPAR.add(RPAR185);



                    // AST REWRITE
                    // elements: RPAR, LPAR, AS, expression
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1587:3: -> ^( T_ASVAR LPAR expression AS RPAR )
                    {
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1587:6: ^( T_ASVAR LPAR expression AS RPAR )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_ASVAR, "T_ASVAR"), root_1);

                        adaptor.addChild(root_1, stream_LPAR.nextNode());
                        adaptor.addChild(root_1, stream_expression.nextTree());
                        adaptor.addChild(root_1, stream_AS.nextNode());
                        adaptor.addChild(root_1,  unboundVar((v!=null?v.getText():null)) );
                        adaptor.addChild(root_1, stream_RPAR.nextNode());

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;}
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "varOrFunction"

    public static class forClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "forClause"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1591:1: forClause : ( singleForClause )+ ;
    public final XSPARQLRewriter.forClause_return forClause() throws RecognitionException {
        XSPARQLRewriter.forClause_return retval = new XSPARQLRewriter.forClause_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.singleForClause_return singleForClause186 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1592:3: ( ( singleForClause )+ )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1592:5: ( singleForClause )+
            {
            root_0 = (CommonTree)adaptor.nil();

            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1592:5: ( singleForClause )+
            int cnt62=0;
            loop62:
            do {
                int alt62=2;
                switch ( input.LA(1) ) {
                case T_FOR:
                    {
                    alt62=1;
                    }
                    break;

                }

                switch (alt62) {
            	case 1 :
            	    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: singleForClause
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_singleForClause_in_forClause6843);
            	    singleForClause186=singleForClause();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) 
            	    adaptor.addChild(root_0, singleForClause186.getTree());

            	    if ( state.backtracking==0 ) {
            	    }
            	    }
            	    break;

            	default :
            	    if ( cnt62 >= 1 ) break loop62;
            	    if (state.backtracking>0) {state.failed=true; return retval;}
                        EarlyExitException eee =
                            new EarlyExitException(62, input);
                        throw eee;
                }
                cnt62++;
            } while (true);


            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "forClause"

    public static class singleForClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "singleForClause"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1595:1: singleForClause : ^( T_FOR var= VAR ( ^( T_TYPE typeDeclaration ) )? optionalPosClause[$var.text] ) ;
    public final XSPARQLRewriter.singleForClause_return singleForClause() throws RecognitionException {
        XSPARQLRewriter.singleForClause_return retval = new XSPARQLRewriter.singleForClause_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree var=null;
        CommonTree T_FOR187=null;
        CommonTree T_TYPE188=null;
        XSPARQLRewriter.typeDeclaration_return typeDeclaration189 = null;

        XSPARQLRewriter.optionalPosClause_return optionalPosClause190 = null;


        CommonTree var_tree=null;
        CommonTree T_FOR187_tree=null;
        CommonTree T_TYPE188_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1596:3: ( ^( T_FOR var= VAR ( ^( T_TYPE typeDeclaration ) )? optionalPosClause[$var.text] ) )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1596:5: ^( T_FOR var= VAR ( ^( T_TYPE typeDeclaration ) )? optionalPosClause[$var.text] )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            T_FOR187=(CommonTree)match(input,T_FOR,FOLLOW_T_FOR_in_singleForClause6858); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            T_FOR187_tree = (CommonTree)adaptor.dupNode(T_FOR187);

            root_1 = (CommonTree)adaptor.becomeRoot(T_FOR187_tree, root_1);
            }


            match(input, Token.DOWN, null); if (state.failed) return retval;
            _last = (CommonTree)input.LT(1);
            var=(CommonTree)match(input,VAR,FOLLOW_VAR_in_singleForClause6862); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            var_tree = (CommonTree)adaptor.dupNode(var);

            adaptor.addChild(root_1, var_tree);
            }
            if ( state.backtracking==0 ) {
               addVariableToScope((var!=null?var.getText():null)); 
            }
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1596:56: ( ^( T_TYPE typeDeclaration ) )?
            int alt63=2;
            switch ( input.LA(1) ) {
                case T_TYPE:
                    {
                    alt63=1;
                    }
                    break;
            }

            switch (alt63) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1596:57: ^( T_TYPE typeDeclaration )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_2 = _last;
                    CommonTree _first_2 = null;
                    CommonTree root_2 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    T_TYPE188=(CommonTree)match(input,T_TYPE,FOLLOW_T_TYPE_in_singleForClause6868); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    T_TYPE188_tree = (CommonTree)adaptor.dupNode(T_TYPE188);

                    root_2 = (CommonTree)adaptor.becomeRoot(T_TYPE188_tree, root_2);
                    }


                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_typeDeclaration_in_singleForClause6870);
                    typeDeclaration189=typeDeclaration();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_2, typeDeclaration189.getTree());

                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_1, root_2);_last = _save_last_2;
                    }


                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_optionalPosClause_in_singleForClause6875);
            optionalPosClause190=optionalPosClause((var!=null?var.getText():null));

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_1, optionalPosClause190.getTree());

            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "singleForClause"

    public static class optionalPosClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "optionalPosClause"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1600:1: optionalPosClause[String var] : ( ^( IN exprSingle ) -> ^( AT VAR[$var + \"_pos\"] ) ^( IN exprSingle ) | ^(a= AT p= positionalVar ) ^( IN exprSingle ) -> ^( $a $p) ^( IN exprSingle ) );
    public final XSPARQLRewriter.optionalPosClause_return optionalPosClause(String var) throws RecognitionException {
        XSPARQLRewriter.optionalPosClause_return retval = new XSPARQLRewriter.optionalPosClause_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree a=null;
        CommonTree IN191=null;
        CommonTree IN193=null;
        XSPARQLRewriter.positionalVar_return p = null;

        XSPARQLRewriter.exprSingle_return exprSingle192 = null;

        XSPARQLRewriter.exprSingle_return exprSingle194 = null;


        CommonTree a_tree=null;
        CommonTree IN191_tree=null;
        CommonTree IN193_tree=null;
        RewriteRuleNodeStream stream_AT=new RewriteRuleNodeStream(adaptor,"token AT");
        RewriteRuleNodeStream stream_IN=new RewriteRuleNodeStream(adaptor,"token IN");
        RewriteRuleSubtreeStream stream_positionalVar=new RewriteRuleSubtreeStream(adaptor,"rule positionalVar");
        RewriteRuleSubtreeStream stream_exprSingle=new RewriteRuleSubtreeStream(adaptor,"rule exprSingle");
        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1601:3: ( ^( IN exprSingle ) -> ^( AT VAR[$var + \"_pos\"] ) ^( IN exprSingle ) | ^(a= AT p= positionalVar ) ^( IN exprSingle ) -> ^( $a $p) ^( IN exprSingle ) )
            int alt64=2;
            switch ( input.LA(1) ) {
            case IN:
                {
                alt64=1;
                }
                break;
            case AT:
                {
                alt64=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 64, 0, input);

                throw nvae;
            }

            switch (alt64) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1601:5: ^( IN exprSingle )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    IN191=(CommonTree)match(input,IN,FOLLOW_IN_in_optionalPosClause6894); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_IN.add(IN191);



                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_exprSingle_in_optionalPosClause6896);
                    exprSingle192=exprSingle();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_exprSingle.add(exprSingle192.getTree());

                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }

                    if ( state.backtracking==0 ) {
                      addPositionVariableToScope(var + "_pos");
                    }


                    // AST REWRITE
                    // elements: IN, exprSingle
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1602:3: -> ^( AT VAR[$var + \"_pos\"] ) ^( IN exprSingle )
                    {
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1602:6: ^( AT VAR[$var + \"_pos\"] )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(AT, "AT"), root_1);

                        adaptor.addChild(root_1, (CommonTree)adaptor.create(VAR, var + "_pos"));

                        adaptor.addChild(root_0, root_1);
                        }
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1602:31: ^( IN exprSingle )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(stream_IN.nextNode(), root_1);

                        adaptor.addChild(root_1, stream_exprSingle.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;}
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1603:5: ^(a= AT p= positionalVar ) ^( IN exprSingle )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    a=(CommonTree)match(input,AT,FOLLOW_AT_in_optionalPosClause6925); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_AT.add(a);



                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_positionalVar_in_optionalPosClause6929);
                    p=positionalVar();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_positionalVar.add(p.getTree());

                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    IN193=(CommonTree)match(input,IN,FOLLOW_IN_in_optionalPosClause6933); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_IN.add(IN193);



                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_exprSingle_in_optionalPosClause6935);
                    exprSingle194=exprSingle();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_exprSingle.add(exprSingle194.getTree());

                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }

                    if ( state.backtracking==0 ) {
                      addPositionVariableToScope((p!=null?(input.getTokenStream().toString(
                        input.getTreeAdaptor().getTokenStartIndex(p.start),
                        input.getTreeAdaptor().getTokenStopIndex(p.start))):null));
                    }


                    // AST REWRITE
                    // elements: IN, a, exprSingle, p
                    // token labels: a
                    // rule labels: p, retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleNodeStream stream_a=new RewriteRuleNodeStream(adaptor,"token a",a);
                    RewriteRuleSubtreeStream stream_p=new RewriteRuleSubtreeStream(adaptor,"rule p",p!=null?p.tree:null);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1604:3: -> ^( $a $p) ^( IN exprSingle )
                    {
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1604:6: ^( $a $p)
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(stream_a.nextNode(), root_1);

                        adaptor.addChild(root_1, stream_p.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1604:15: ^( IN exprSingle )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(stream_IN.nextNode(), root_1);

                        adaptor.addChild(root_1, stream_exprSingle.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;}
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "optionalPosClause"

    public static class positionalVar_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "positionalVar"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1607:1: positionalVar : VAR ;
    public final XSPARQLRewriter.positionalVar_return positionalVar() throws RecognitionException {
        XSPARQLRewriter.positionalVar_return retval = new XSPARQLRewriter.positionalVar_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree VAR195=null;

        CommonTree VAR195_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1608:3: ( VAR )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1608:5: VAR
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            VAR195=(CommonTree)match(input,VAR,FOLLOW_VAR_in_positionalVar6969); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            VAR195_tree = (CommonTree)adaptor.dupNode(VAR195);

            adaptor.addChild(root_0, VAR195_tree);
            }

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "positionalVar"

    public static class letClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "letClause"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1611:1: letClause : ( singleLetClause )+ ;
    public final XSPARQLRewriter.letClause_return letClause() throws RecognitionException {
        XSPARQLRewriter.letClause_return retval = new XSPARQLRewriter.letClause_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.singleLetClause_return singleLetClause196 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1612:3: ( ( singleLetClause )+ )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1612:5: ( singleLetClause )+
            {
            root_0 = (CommonTree)adaptor.nil();

            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1612:5: ( singleLetClause )+
            int cnt65=0;
            loop65:
            do {
                int alt65=2;
                switch ( input.LA(1) ) {
                case T_LET:
                    {
                    alt65=1;
                    }
                    break;

                }

                switch (alt65) {
            	case 1 :
            	    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1612:6: singleLetClause
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_singleLetClause_in_letClause6983);
            	    singleLetClause196=singleLetClause();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) 
            	    adaptor.addChild(root_0, singleLetClause196.getTree());

            	    if ( state.backtracking==0 ) {
            	    }
            	    }
            	    break;

            	default :
            	    if ( cnt65 >= 1 ) break loop65;
            	    if (state.backtracking>0) {state.failed=true; return retval;}
                        EarlyExitException eee =
                            new EarlyExitException(65, input);
                        throw eee;
                }
                cnt65++;
            } while (true);


            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "letClause"

    public static class singleLetClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "singleLetClause"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1615:1: singleLetClause : ^( T_LET ^(var= VAR ( typeDeclaration )? ) exprSingle ) -> { $exprSingle.type.equals(Types.RDF_GRAPH) }? ^( T_LET ^( $var ( typeDeclaration )? ) ^( T_FUNCTION_CALL NCNAME[serializeFunction] ^( T_PARAMS exprSingle ) ) ) ^( T_RETURN ^( T_FLWOR ^( T_LET VAR[\"\\$_\" + Helper.removeLeading($var.text,\"\\$\")+\"_graph\"] ^( T_FUNCTION_CALL NCNAME[storeGraphFunction] ^( T_PARAMS QSTRING[getRDFNamespaceDecls()] $var) ) ) ) ) -> ^( T_LET ^( $var ( typeDeclaration )? ) exprSingle ) ;
    public final XSPARQLRewriter.singleLetClause_return singleLetClause() throws RecognitionException {
        XSPARQLRewriter.singleLetClause_return retval = new XSPARQLRewriter.singleLetClause_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree var=null;
        CommonTree T_LET197=null;
        XSPARQLRewriter.typeDeclaration_return typeDeclaration198 = null;

        XSPARQLRewriter.exprSingle_return exprSingle199 = null;


        CommonTree var_tree=null;
        CommonTree T_LET197_tree=null;
        RewriteRuleNodeStream stream_VAR=new RewriteRuleNodeStream(adaptor,"token VAR");
        RewriteRuleNodeStream stream_T_LET=new RewriteRuleNodeStream(adaptor,"token T_LET");
        RewriteRuleSubtreeStream stream_exprSingle=new RewriteRuleSubtreeStream(adaptor,"rule exprSingle");
        RewriteRuleSubtreeStream stream_typeDeclaration=new RewriteRuleSubtreeStream(adaptor,"rule typeDeclaration");
        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1616:3: ( ^( T_LET ^(var= VAR ( typeDeclaration )? ) exprSingle ) -> { $exprSingle.type.equals(Types.RDF_GRAPH) }? ^( T_LET ^( $var ( typeDeclaration )? ) ^( T_FUNCTION_CALL NCNAME[serializeFunction] ^( T_PARAMS exprSingle ) ) ) ^( T_RETURN ^( T_FLWOR ^( T_LET VAR[\"\\$_\" + Helper.removeLeading($var.text,\"\\$\")+\"_graph\"] ^( T_FUNCTION_CALL NCNAME[storeGraphFunction] ^( T_PARAMS QSTRING[getRDFNamespaceDecls()] $var) ) ) ) ) -> ^( T_LET ^( $var ( typeDeclaration )? ) exprSingle ) )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1616:5: ^( T_LET ^(var= VAR ( typeDeclaration )? ) exprSingle )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            T_LET197=(CommonTree)match(input,T_LET,FOLLOW_T_LET_in_singleLetClause6999); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_T_LET.add(T_LET197);



            match(input, Token.DOWN, null); if (state.failed) return retval;
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_2 = _last;
            CommonTree _first_2 = null;
            CommonTree root_2 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            var=(CommonTree)match(input,VAR,FOLLOW_VAR_in_singleLetClause7011); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_VAR.add(var);



            if ( input.LA(1)==Token.DOWN ) {
                match(input, Token.DOWN, null); if (state.failed) return retval;
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1617:17: ( typeDeclaration )?
                int alt66=2;
                switch ( input.LA(1) ) {
                    case NCNAME:
                    case PNAME_NS:
                    case PNAME_LN:
                    case A:
                    case FROM:
                    case ATTRIBUTE:
                    case ELEMENT:
                    case TO:
                    case EMPTYSEQUENCE:
                    case ITEM:
                    case NODE:
                    case DOCUMENTNODE:
                    case TEXT:
                    case COMMENT:
                    case PROCESSINGINSTRUCTION:
                    case SCHEMAATTRIBUTE:
                    case SCHEMAELEMENT:
                    case ROW:
                        {
                        alt66=1;
                        }
                        break;
                }

                switch (alt66) {
                    case 1 :
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: typeDeclaration
                        {
                        _last = (CommonTree)input.LT(1);
                        pushFollow(FOLLOW_typeDeclaration_in_singleLetClause7013);
                        typeDeclaration198=typeDeclaration();

                        state._fsp--;
                        if (state.failed) return retval;
                        if ( state.backtracking==0 ) stream_typeDeclaration.add(typeDeclaration198.getTree());

                        if ( state.backtracking==0 ) {
                        }
                        }
                        break;

                }


                match(input, Token.UP, null); if (state.failed) return retval;
            }adaptor.addChild(root_1, root_2);_last = _save_last_2;
            }

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_exprSingle_in_singleLetClause7023);
            exprSingle199=exprSingle();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_exprSingle.add(exprSingle199.getTree());

            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }

            if ( state.backtracking==0 ) {
               addVariableToScope((var!=null?var.getText():null)); 
                      if ( (exprSingle199!=null?exprSingle199.type:null).equals(Types.RDF_GRAPH) ) {
                        addVariableToScope("$_" + Helper.removeLeading((var!=null?var.getText():null),"$")+"_graph");
                      } 
                      if(this.warnIfNestedConstruct) {
                        logger.severe("The evaluation will probably NOT work because you are using a nested construct and want to evaluate that on a SPARQL endpoint which is not located on your host. That doesn't work! If you want to evaluate a nested constuct, then the XQuery engine and the SPARQL engine have to be running on the same host.");
                      }
                    
            }


            // AST REWRITE
            // elements: T_LET, T_LET, exprSingle, var, VAR, T_LET, exprSingle, var, typeDeclaration, typeDeclaration, var
            // token labels: var
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {
            retval.tree = root_0;
            RewriteRuleNodeStream stream_var=new RewriteRuleNodeStream(adaptor,"token var",var);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1627:3: -> { $exprSingle.type.equals(Types.RDF_GRAPH) }? ^( T_LET ^( $var ( typeDeclaration )? ) ^( T_FUNCTION_CALL NCNAME[serializeFunction] ^( T_PARAMS exprSingle ) ) ) ^( T_RETURN ^( T_FLWOR ^( T_LET VAR[\"\\$_\" + Helper.removeLeading($var.text,\"\\$\")+\"_graph\"] ^( T_FUNCTION_CALL NCNAME[storeGraphFunction] ^( T_PARAMS QSTRING[getRDFNamespaceDecls()] $var) ) ) ) )
            if ( (exprSingle199!=null?exprSingle199.type:null).equals(Types.RDF_GRAPH) ) {
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1627:52: ^( T_LET ^( $var ( typeDeclaration )? ) ^( T_FUNCTION_CALL NCNAME[serializeFunction] ^( T_PARAMS exprSingle ) ) )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(stream_T_LET.nextNode(), root_1);

                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1627:60: ^( $var ( typeDeclaration )? )
                {
                CommonTree root_2 = (CommonTree)adaptor.nil();
                root_2 = (CommonTree)adaptor.becomeRoot(stream_var.nextNode(), root_2);

                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1627:67: ( typeDeclaration )?
                if ( stream_typeDeclaration.hasNext() ) {
                    adaptor.addChild(root_2, stream_typeDeclaration.nextTree());

                }
                stream_typeDeclaration.reset();

                adaptor.addChild(root_1, root_2);
                }
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1627:85: ^( T_FUNCTION_CALL NCNAME[serializeFunction] ^( T_PARAMS exprSingle ) )
                {
                CommonTree root_2 = (CommonTree)adaptor.nil();
                root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FUNCTION_CALL, "T_FUNCTION_CALL"), root_2);

                adaptor.addChild(root_2, (CommonTree)adaptor.create(NCNAME, serializeFunction));
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1627:129: ^( T_PARAMS exprSingle )
                {
                CommonTree root_3 = (CommonTree)adaptor.nil();
                root_3 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_PARAMS, "T_PARAMS"), root_3);

                adaptor.addChild(root_3, stream_exprSingle.nextTree());

                adaptor.addChild(root_2, root_3);
                }

                adaptor.addChild(root_1, root_2);
                }

                adaptor.addChild(root_0, root_1);
                }
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1627:154: ^( T_RETURN ^( T_FLWOR ^( T_LET VAR[\"\\$_\" + Helper.removeLeading($var.text,\"\\$\")+\"_graph\"] ^( T_FUNCTION_CALL NCNAME[storeGraphFunction] ^( T_PARAMS QSTRING[getRDFNamespaceDecls()] $var) ) ) ) )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_RETURN, "T_RETURN"), root_1);

                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1627:165: ^( T_FLWOR ^( T_LET VAR[\"\\$_\" + Helper.removeLeading($var.text,\"\\$\")+\"_graph\"] ^( T_FUNCTION_CALL NCNAME[storeGraphFunction] ^( T_PARAMS QSTRING[getRDFNamespaceDecls()] $var) ) ) )
                {
                CommonTree root_2 = (CommonTree)adaptor.nil();
                root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FLWOR, "T_FLWOR"), root_2);

                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1627:175: ^( T_LET VAR[\"\\$_\" + Helper.removeLeading($var.text,\"\\$\")+\"_graph\"] ^( T_FUNCTION_CALL NCNAME[storeGraphFunction] ^( T_PARAMS QSTRING[getRDFNamespaceDecls()] $var) ) )
                {
                CommonTree root_3 = (CommonTree)adaptor.nil();
                root_3 = (CommonTree)adaptor.becomeRoot(stream_T_LET.nextNode(), root_3);

                adaptor.addChild(root_3, (CommonTree)adaptor.create(VAR, "$_" + Helper.removeLeading((var!=null?var.getText():null),"$")+"_graph"));
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1627:242: ^( T_FUNCTION_CALL NCNAME[storeGraphFunction] ^( T_PARAMS QSTRING[getRDFNamespaceDecls()] $var) )
                {
                CommonTree root_4 = (CommonTree)adaptor.nil();
                root_4 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FUNCTION_CALL, "T_FUNCTION_CALL"), root_4);

                adaptor.addChild(root_4, (CommonTree)adaptor.create(NCNAME, storeGraphFunction));
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1627:287: ^( T_PARAMS QSTRING[getRDFNamespaceDecls()] $var)
                {
                CommonTree root_5 = (CommonTree)adaptor.nil();
                root_5 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_PARAMS, "T_PARAMS"), root_5);

                adaptor.addChild(root_5, (CommonTree)adaptor.create(QSTRING, getRDFNamespaceDecls()));
                adaptor.addChild(root_5, stream_var.nextNode());

                adaptor.addChild(root_4, root_5);
                }

                adaptor.addChild(root_3, root_4);
                }

                adaptor.addChild(root_2, root_3);
                }

                adaptor.addChild(root_1, root_2);
                }

                adaptor.addChild(root_0, root_1);
                }

            }
            else // 1628:3: -> ^( T_LET ^( $var ( typeDeclaration )? ) exprSingle )
            {
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1628:6: ^( T_LET ^( $var ( typeDeclaration )? ) exprSingle )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(stream_T_LET.nextNode(), root_1);

                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1628:14: ^( $var ( typeDeclaration )? )
                {
                CommonTree root_2 = (CommonTree)adaptor.nil();
                root_2 = (CommonTree)adaptor.becomeRoot(stream_var.nextNode(), root_2);

                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1628:21: ( typeDeclaration )?
                if ( stream_typeDeclaration.hasNext() ) {
                    adaptor.addChild(root_2, stream_typeDeclaration.nextTree());

                }
                stream_typeDeclaration.reset();

                adaptor.addChild(root_1, root_2);
                }
                adaptor.addChild(root_1, stream_exprSingle.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "singleLetClause"

    public static class whereClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "whereClause"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1631:1: whereClause : ^( WHERE exprSingle ) -> exprSingle ;
    public final XSPARQLRewriter.whereClause_return whereClause() throws RecognitionException {
        XSPARQLRewriter.whereClause_return retval = new XSPARQLRewriter.whereClause_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree WHERE200=null;
        XSPARQLRewriter.exprSingle_return exprSingle201 = null;


        CommonTree WHERE200_tree=null;
        RewriteRuleNodeStream stream_WHERE=new RewriteRuleNodeStream(adaptor,"token WHERE");
        RewriteRuleSubtreeStream stream_exprSingle=new RewriteRuleSubtreeStream(adaptor,"rule exprSingle");
        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1632:3: ( ^( WHERE exprSingle ) -> exprSingle )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1632:5: ^( WHERE exprSingle )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            WHERE200=(CommonTree)match(input,WHERE,FOLLOW_WHERE_in_whereClause7127); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_WHERE.add(WHERE200);



            match(input, Token.DOWN, null); if (state.failed) return retval;
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_exprSingle_in_whereClause7129);
            exprSingle201=exprSingle();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_exprSingle.add(exprSingle201.getTree());

            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }



            // AST REWRITE
            // elements: exprSingle
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1632:25: -> exprSingle
            {
                adaptor.addChild(root_0, stream_exprSingle.nextTree());

            }

            retval.tree = root_0;}
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "whereClause"

    public static class orderByClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "orderByClause"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1635:1: orderByClause : ( ^( T_ORDER_BY orderSpecList ) | ^( T_STABLE_ORDER_BY orderSpecList ) );
    public final XSPARQLRewriter.orderByClause_return orderByClause() throws RecognitionException {
        XSPARQLRewriter.orderByClause_return retval = new XSPARQLRewriter.orderByClause_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree T_ORDER_BY202=null;
        CommonTree T_STABLE_ORDER_BY204=null;
        XSPARQLRewriter.orderSpecList_return orderSpecList203 = null;

        XSPARQLRewriter.orderSpecList_return orderSpecList205 = null;


        CommonTree T_ORDER_BY202_tree=null;
        CommonTree T_STABLE_ORDER_BY204_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1636:3: ( ^( T_ORDER_BY orderSpecList ) | ^( T_STABLE_ORDER_BY orderSpecList ) )
            int alt67=2;
            switch ( input.LA(1) ) {
            case T_ORDER_BY:
                {
                alt67=1;
                }
                break;
            case T_STABLE_ORDER_BY:
                {
                alt67=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 67, 0, input);

                throw nvae;
            }

            switch (alt67) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1636:5: ^( T_ORDER_BY orderSpecList )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    T_ORDER_BY202=(CommonTree)match(input,T_ORDER_BY,FOLLOW_T_ORDER_BY_in_orderByClause7148); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    T_ORDER_BY202_tree = (CommonTree)adaptor.dupNode(T_ORDER_BY202);

                    root_1 = (CommonTree)adaptor.becomeRoot(T_ORDER_BY202_tree, root_1);
                    }


                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_orderSpecList_in_orderByClause7150);
                    orderSpecList203=orderSpecList();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_1, orderSpecList203.getTree());

                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1637:5: ^( T_STABLE_ORDER_BY orderSpecList )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    T_STABLE_ORDER_BY204=(CommonTree)match(input,T_STABLE_ORDER_BY,FOLLOW_T_STABLE_ORDER_BY_in_orderByClause7158); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    T_STABLE_ORDER_BY204_tree = (CommonTree)adaptor.dupNode(T_STABLE_ORDER_BY204);

                    root_1 = (CommonTree)adaptor.becomeRoot(T_STABLE_ORDER_BY204_tree, root_1);
                    }


                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_orderSpecList_in_orderByClause7160);
                    orderSpecList205=orderSpecList();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_1, orderSpecList205.getTree());

                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "orderByClause"

    public static class orderSpecList_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "orderSpecList"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1640:1: orderSpecList : ( orderSpec )+ ;
    public final XSPARQLRewriter.orderSpecList_return orderSpecList() throws RecognitionException {
        XSPARQLRewriter.orderSpecList_return retval = new XSPARQLRewriter.orderSpecList_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.orderSpec_return orderSpec206 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1641:3: ( ( orderSpec )+ )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1641:5: ( orderSpec )+
            {
            root_0 = (CommonTree)adaptor.nil();

            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1641:5: ( orderSpec )+
            int cnt68=0;
            loop68:
            do {
                int alt68=2;
                switch ( input.LA(1) ) {
                case LCURLY:
                case STAR:
                case LESSTHAN:
                case GREATERTHAN:
                case PLUS:
                case MINUS:
                case UNIONSYMBOL:
                case LESSTHANLESSTHAN:
                case GREATERTHANEQUALS:
                case LESSTHANEQUALS:
                case HAFENEQUALS:
                case EQUALS:
                case IS:
                case EQ:
                case NE:
                case LT:
                case GE:
                case LE:
                case GT:
                case IF:
                case AND:
                case OR:
                case TO:
                case DIV:
                case IDIV:
                case MOD:
                case UNION:
                case INTERSECT:
                case EXCEPT:
                case GREATERTHANGREATERTHAN:
                case T_FLWOR:
                case T_INSTANCEOF:
                case T_CASTAS:
                case T_CASTABLEAS:
                case T_TREATAS:
                case EVERY:
                case TYPESWITCH:
                case VALIDATE:
                case SOME:
                case XPATH:
                    {
                    alt68=1;
                    }
                    break;

                }

                switch (alt68) {
            	case 1 :
            	    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: orderSpec
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_orderSpec_in_orderSpecList7174);
            	    orderSpec206=orderSpec();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) 
            	    adaptor.addChild(root_0, orderSpec206.getTree());

            	    if ( state.backtracking==0 ) {
            	    }
            	    }
            	    break;

            	default :
            	    if ( cnt68 >= 1 ) break loop68;
            	    if (state.backtracking>0) {state.failed=true; return retval;}
                        EarlyExitException eee =
                            new EarlyExitException(68, input);
                        throw eee;
                }
                cnt68++;
            } while (true);


            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "orderSpecList"

    public static class orderSpec_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "orderSpec"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1644:1: orderSpec : exprSingle orderModifier ;
    public final XSPARQLRewriter.orderSpec_return orderSpec() throws RecognitionException {
        XSPARQLRewriter.orderSpec_return retval = new XSPARQLRewriter.orderSpec_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.exprSingle_return exprSingle207 = null;

        XSPARQLRewriter.orderModifier_return orderModifier208 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1645:3: ( exprSingle orderModifier )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1645:6: exprSingle orderModifier
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_exprSingle_in_orderSpec7189);
            exprSingle207=exprSingle();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_0, exprSingle207.getTree());
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_orderModifier_in_orderSpec7191);
            orderModifier208=orderModifier();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_0, orderModifier208.getTree());

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "orderSpec"

    public static class orderModifier_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "orderModifier"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1648:1: orderModifier : ( ASCENDING | DESCENDING )? ( EMPTY ( GREATEST | LEAST ) )? ( COLLATION uriliteral )? ;
    public final XSPARQLRewriter.orderModifier_return orderModifier() throws RecognitionException {
        XSPARQLRewriter.orderModifier_return retval = new XSPARQLRewriter.orderModifier_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set209=null;
        CommonTree EMPTY210=null;
        CommonTree set211=null;
        CommonTree COLLATION212=null;
        XSPARQLRewriter.uriliteral_return uriliteral213 = null;


        CommonTree set209_tree=null;
        CommonTree EMPTY210_tree=null;
        CommonTree set211_tree=null;
        CommonTree COLLATION212_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1649:3: ( ( ASCENDING | DESCENDING )? ( EMPTY ( GREATEST | LEAST ) )? ( COLLATION uriliteral )? )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1649:5: ( ASCENDING | DESCENDING )? ( EMPTY ( GREATEST | LEAST ) )? ( COLLATION uriliteral )?
            {
            root_0 = (CommonTree)adaptor.nil();

            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1649:5: ( ASCENDING | DESCENDING )?
            int alt69=2;
            switch ( input.LA(1) ) {
                case DESCENDING:
                case ASCENDING:
                    {
                    alt69=1;
                    }
                    break;
            }

            switch (alt69) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:
                    {
                    _last = (CommonTree)input.LT(1);
                    set209=(CommonTree)input.LT(1);
                    if ( (input.LA(1)>=DESCENDING && input.LA(1)<=ASCENDING) ) {
                        input.consume();

                        if ( state.backtracking==0 ) {
                        set209_tree = (CommonTree)adaptor.dupNode(set209);

                        adaptor.addChild(root_0, set209_tree);
                        }
                        state.errorRecovery=false;state.failed=false;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }


                    }
                    break;

            }

            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1649:31: ( EMPTY ( GREATEST | LEAST ) )?
            int alt70=2;
            switch ( input.LA(1) ) {
                case EMPTY:
                    {
                    alt70=1;
                    }
                    break;
            }

            switch (alt70) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1649:32: EMPTY ( GREATEST | LEAST )
                    {
                    _last = (CommonTree)input.LT(1);
                    EMPTY210=(CommonTree)match(input,EMPTY,FOLLOW_EMPTY_in_orderModifier7214); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    EMPTY210_tree = (CommonTree)adaptor.dupNode(EMPTY210);

                    adaptor.addChild(root_0, EMPTY210_tree);
                    }
                    _last = (CommonTree)input.LT(1);
                    set211=(CommonTree)input.LT(1);
                    if ( (input.LA(1)>=GREATEST && input.LA(1)<=LEAST) ) {
                        input.consume();

                        if ( state.backtracking==0 ) {
                        set211_tree = (CommonTree)adaptor.dupNode(set211);

                        adaptor.addChild(root_0, set211_tree);
                        }
                        state.errorRecovery=false;state.failed=false;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }


                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }

            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1649:59: ( COLLATION uriliteral )?
            int alt71=2;
            switch ( input.LA(1) ) {
                case COLLATION:
                    {
                    alt71=1;
                    }
                    break;
            }

            switch (alt71) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1649:60: COLLATION uriliteral
                    {
                    _last = (CommonTree)input.LT(1);
                    COLLATION212=(CommonTree)match(input,COLLATION,FOLLOW_COLLATION_in_orderModifier7227); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    COLLATION212_tree = (CommonTree)adaptor.dupNode(COLLATION212);

                    adaptor.addChild(root_0, COLLATION212_tree);
                    }
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_uriliteral_in_orderModifier7229);
                    uriliteral213=uriliteral();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, uriliteral213.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }


            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "orderModifier"

    public static class quantifiedExpr_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "quantifiedExpr"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1652:1: quantifiedExpr : ^( ( SOME | EVERY ) ( ^( T_VAR VAR ( ^( T_TYPE typeDeclaration ) )? ^( IN exprSingle ) ) )+ ^( SATISFIES exprSingle ) ) ;
    public final XSPARQLRewriter.quantifiedExpr_return quantifiedExpr() throws RecognitionException {
        XSPARQLRewriter.quantifiedExpr_return retval = new XSPARQLRewriter.quantifiedExpr_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set214=null;
        CommonTree T_VAR215=null;
        CommonTree VAR216=null;
        CommonTree T_TYPE217=null;
        CommonTree IN219=null;
        CommonTree SATISFIES221=null;
        XSPARQLRewriter.typeDeclaration_return typeDeclaration218 = null;

        XSPARQLRewriter.exprSingle_return exprSingle220 = null;

        XSPARQLRewriter.exprSingle_return exprSingle222 = null;


        CommonTree set214_tree=null;
        CommonTree T_VAR215_tree=null;
        CommonTree VAR216_tree=null;
        CommonTree T_TYPE217_tree=null;
        CommonTree IN219_tree=null;
        CommonTree SATISFIES221_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1653:3: ( ^( ( SOME | EVERY ) ( ^( T_VAR VAR ( ^( T_TYPE typeDeclaration ) )? ^( IN exprSingle ) ) )+ ^( SATISFIES exprSingle ) ) )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1653:5: ^( ( SOME | EVERY ) ( ^( T_VAR VAR ( ^( T_TYPE typeDeclaration ) )? ^( IN exprSingle ) ) )+ ^( SATISFIES exprSingle ) )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();set214=(CommonTree)input.LT(1);
            if ( input.LA(1)==EVERY||input.LA(1)==SOME ) {
                input.consume();

                if ( state.backtracking==0 ) {
                set214_tree = (CommonTree)adaptor.dupNode(set214);

                root_1 = (CommonTree)adaptor.becomeRoot(set214_tree, root_1);
                }
                state.errorRecovery=false;state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }



            match(input, Token.DOWN, null); if (state.failed) return retval;
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1653:20: ( ^( T_VAR VAR ( ^( T_TYPE typeDeclaration ) )? ^( IN exprSingle ) ) )+
            int cnt73=0;
            loop73:
            do {
                int alt73=2;
                switch ( input.LA(1) ) {
                case T_VAR:
                    {
                    alt73=1;
                    }
                    break;

                }

                switch (alt73) {
            	case 1 :
            	    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1653:21: ^( T_VAR VAR ( ^( T_TYPE typeDeclaration ) )? ^( IN exprSingle ) )
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    {
            	    CommonTree _save_last_2 = _last;
            	    CommonTree _first_2 = null;
            	    CommonTree root_2 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            	    T_VAR215=(CommonTree)match(input,T_VAR,FOLLOW_T_VAR_in_quantifiedExpr7253); if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {
            	    T_VAR215_tree = (CommonTree)adaptor.dupNode(T_VAR215);

            	    root_2 = (CommonTree)adaptor.becomeRoot(T_VAR215_tree, root_2);
            	    }


            	    match(input, Token.DOWN, null); if (state.failed) return retval;
            	    _last = (CommonTree)input.LT(1);
            	    VAR216=(CommonTree)match(input,VAR,FOLLOW_VAR_in_quantifiedExpr7255); if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {
            	    VAR216_tree = (CommonTree)adaptor.dupNode(VAR216);

            	    adaptor.addChild(root_2, VAR216_tree);
            	    }
            	    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1653:33: ( ^( T_TYPE typeDeclaration ) )?
            	    int alt72=2;
            	    switch ( input.LA(1) ) {
            	        case T_TYPE:
            	            {
            	            alt72=1;
            	            }
            	            break;
            	    }

            	    switch (alt72) {
            	        case 1 :
            	            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1653:34: ^( T_TYPE typeDeclaration )
            	            {
            	            _last = (CommonTree)input.LT(1);
            	            {
            	            CommonTree _save_last_3 = _last;
            	            CommonTree _first_3 = null;
            	            CommonTree root_3 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            	            T_TYPE217=(CommonTree)match(input,T_TYPE,FOLLOW_T_TYPE_in_quantifiedExpr7259); if (state.failed) return retval;
            	            if ( state.backtracking==0 ) {
            	            T_TYPE217_tree = (CommonTree)adaptor.dupNode(T_TYPE217);

            	            root_3 = (CommonTree)adaptor.becomeRoot(T_TYPE217_tree, root_3);
            	            }


            	            match(input, Token.DOWN, null); if (state.failed) return retval;
            	            _last = (CommonTree)input.LT(1);
            	            pushFollow(FOLLOW_typeDeclaration_in_quantifiedExpr7261);
            	            typeDeclaration218=typeDeclaration();

            	            state._fsp--;
            	            if (state.failed) return retval;
            	            if ( state.backtracking==0 ) 
            	            adaptor.addChild(root_3, typeDeclaration218.getTree());

            	            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_2, root_3);_last = _save_last_3;
            	            }


            	            if ( state.backtracking==0 ) {
            	            }
            	            }
            	            break;

            	    }

            	    _last = (CommonTree)input.LT(1);
            	    {
            	    CommonTree _save_last_3 = _last;
            	    CommonTree _first_3 = null;
            	    CommonTree root_3 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            	    IN219=(CommonTree)match(input,IN,FOLLOW_IN_in_quantifiedExpr7267); if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {
            	    IN219_tree = (CommonTree)adaptor.dupNode(IN219);

            	    root_3 = (CommonTree)adaptor.becomeRoot(IN219_tree, root_3);
            	    }


            	    match(input, Token.DOWN, null); if (state.failed) return retval;
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_exprSingle_in_quantifiedExpr7269);
            	    exprSingle220=exprSingle();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) 
            	    adaptor.addChild(root_3, exprSingle220.getTree());

            	    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_2, root_3);_last = _save_last_3;
            	    }


            	    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_1, root_2);_last = _save_last_2;
            	    }


            	    if ( state.backtracking==0 ) {
            	    }
            	    }
            	    break;

            	default :
            	    if ( cnt73 >= 1 ) break loop73;
            	    if (state.backtracking>0) {state.failed=true; return retval;}
                        EarlyExitException eee =
                            new EarlyExitException(73, input);
                        throw eee;
                }
                cnt73++;
            } while (true);

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_2 = _last;
            CommonTree _first_2 = null;
            CommonTree root_2 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            SATISFIES221=(CommonTree)match(input,SATISFIES,FOLLOW_SATISFIES_in_quantifiedExpr7276); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            SATISFIES221_tree = (CommonTree)adaptor.dupNode(SATISFIES221);

            root_2 = (CommonTree)adaptor.becomeRoot(SATISFIES221_tree, root_2);
            }


            match(input, Token.DOWN, null); if (state.failed) return retval;
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_exprSingle_in_quantifiedExpr7278);
            exprSingle222=exprSingle();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_2, exprSingle222.getTree());

            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_1, root_2);_last = _save_last_2;
            }


            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "quantifiedExpr"

    public static class typeSwitchExpr_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "typeSwitchExpr"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1656:1: typeSwitchExpr : ^( TYPESWITCH expr ( caseClause )+ ( VAR )? exprSingle ) ;
    public final XSPARQLRewriter.typeSwitchExpr_return typeSwitchExpr() throws RecognitionException {
        XSPARQLRewriter.typeSwitchExpr_return retval = new XSPARQLRewriter.typeSwitchExpr_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree TYPESWITCH223=null;
        CommonTree VAR226=null;
        XSPARQLRewriter.expr_return expr224 = null;

        XSPARQLRewriter.caseClause_return caseClause225 = null;

        XSPARQLRewriter.exprSingle_return exprSingle227 = null;


        CommonTree TYPESWITCH223_tree=null;
        CommonTree VAR226_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1657:3: ( ^( TYPESWITCH expr ( caseClause )+ ( VAR )? exprSingle ) )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1657:5: ^( TYPESWITCH expr ( caseClause )+ ( VAR )? exprSingle )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            TYPESWITCH223=(CommonTree)match(input,TYPESWITCH,FOLLOW_TYPESWITCH_in_typeSwitchExpr7294); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            TYPESWITCH223_tree = (CommonTree)adaptor.dupNode(TYPESWITCH223);

            root_1 = (CommonTree)adaptor.becomeRoot(TYPESWITCH223_tree, root_1);
            }


            match(input, Token.DOWN, null); if (state.failed) return retval;
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_expr_in_typeSwitchExpr7296);
            expr224=expr();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_1, expr224.getTree());
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1657:23: ( caseClause )+
            int cnt74=0;
            loop74:
            do {
                int alt74=2;
                switch ( input.LA(1) ) {
                case CASE:
                    {
                    alt74=1;
                    }
                    break;

                }

                switch (alt74) {
            	case 1 :
            	    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: caseClause
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_caseClause_in_typeSwitchExpr7298);
            	    caseClause225=caseClause();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) 
            	    adaptor.addChild(root_1, caseClause225.getTree());

            	    if ( state.backtracking==0 ) {
            	    }
            	    }
            	    break;

            	default :
            	    if ( cnt74 >= 1 ) break loop74;
            	    if (state.backtracking>0) {state.failed=true; return retval;}
                        EarlyExitException eee =
                            new EarlyExitException(74, input);
                        throw eee;
                }
                cnt74++;
            } while (true);

            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1657:35: ( VAR )?
            int alt75=2;
            switch ( input.LA(1) ) {
                case VAR:
                    {
                    alt75=1;
                    }
                    break;
            }

            switch (alt75) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: VAR
                    {
                    _last = (CommonTree)input.LT(1);
                    VAR226=(CommonTree)match(input,VAR,FOLLOW_VAR_in_typeSwitchExpr7301); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    VAR226_tree = (CommonTree)adaptor.dupNode(VAR226);

                    adaptor.addChild(root_1, VAR226_tree);
                    }

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_exprSingle_in_typeSwitchExpr7304);
            exprSingle227=exprSingle();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_1, exprSingle227.getTree());

            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "typeSwitchExpr"

    public static class caseClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "caseClause"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1660:1: caseClause : CASE ( VAR AS )? sequenceType RETURN exprSingle ;
    public final XSPARQLRewriter.caseClause_return caseClause() throws RecognitionException {
        XSPARQLRewriter.caseClause_return retval = new XSPARQLRewriter.caseClause_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree CASE228=null;
        CommonTree VAR229=null;
        CommonTree AS230=null;
        CommonTree RETURN232=null;
        XSPARQLRewriter.sequenceType_return sequenceType231 = null;

        XSPARQLRewriter.exprSingle_return exprSingle233 = null;


        CommonTree CASE228_tree=null;
        CommonTree VAR229_tree=null;
        CommonTree AS230_tree=null;
        CommonTree RETURN232_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1661:3: ( CASE ( VAR AS )? sequenceType RETURN exprSingle )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1661:5: CASE ( VAR AS )? sequenceType RETURN exprSingle
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            CASE228=(CommonTree)match(input,CASE,FOLLOW_CASE_in_caseClause7318); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            CASE228_tree = (CommonTree)adaptor.dupNode(CASE228);

            adaptor.addChild(root_0, CASE228_tree);
            }
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1661:10: ( VAR AS )?
            int alt76=2;
            switch ( input.LA(1) ) {
                case VAR:
                    {
                    alt76=1;
                    }
                    break;
            }

            switch (alt76) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1661:11: VAR AS
                    {
                    _last = (CommonTree)input.LT(1);
                    VAR229=(CommonTree)match(input,VAR,FOLLOW_VAR_in_caseClause7321); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    VAR229_tree = (CommonTree)adaptor.dupNode(VAR229);

                    adaptor.addChild(root_0, VAR229_tree);
                    }
                    _last = (CommonTree)input.LT(1);
                    AS230=(CommonTree)match(input,AS,FOLLOW_AS_in_caseClause7323); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    AS230_tree = (CommonTree)adaptor.dupNode(AS230);

                    adaptor.addChild(root_0, AS230_tree);
                    }

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_sequenceType_in_caseClause7327);
            sequenceType231=sequenceType();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_0, sequenceType231.getTree());
            _last = (CommonTree)input.LT(1);
            RETURN232=(CommonTree)match(input,RETURN,FOLLOW_RETURN_in_caseClause7329); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            RETURN232_tree = (CommonTree)adaptor.dupNode(RETURN232);

            adaptor.addChild(root_0, RETURN232_tree);
            }
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_exprSingle_in_caseClause7331);
            exprSingle233=exprSingle();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_0, exprSingle233.getTree());

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "caseClause"

    public static class ifExpr_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "ifExpr"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1664:1: ifExpr : ^( IF exprSingle exprSingle exprSingle ) ;
    public final XSPARQLRewriter.ifExpr_return ifExpr() throws RecognitionException {
        XSPARQLRewriter.ifExpr_return retval = new XSPARQLRewriter.ifExpr_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree IF234=null;
        XSPARQLRewriter.exprSingle_return exprSingle235 = null;

        XSPARQLRewriter.exprSingle_return exprSingle236 = null;

        XSPARQLRewriter.exprSingle_return exprSingle237 = null;


        CommonTree IF234_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1666:3: ( ^( IF exprSingle exprSingle exprSingle ) )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1666:5: ^( IF exprSingle exprSingle exprSingle )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            IF234=(CommonTree)match(input,IF,FOLLOW_IF_in_ifExpr7346); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            IF234_tree = (CommonTree)adaptor.dupNode(IF234);

            root_1 = (CommonTree)adaptor.becomeRoot(IF234_tree, root_1);
            }


            match(input, Token.DOWN, null); if (state.failed) return retval;
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_exprSingle_in_ifExpr7348);
            exprSingle235=exprSingle();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_1, exprSingle235.getTree());
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_exprSingle_in_ifExpr7350);
            exprSingle236=exprSingle();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_1, exprSingle236.getTree());
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_exprSingle_in_ifExpr7352);
            exprSingle237=exprSingle();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_1, exprSingle237.getTree());

            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "ifExpr"

    public static class orExpr_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "orExpr"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1669:1: orExpr : ( andExpr | ^( OR orExpr andExpr ) );
    public final XSPARQLRewriter.orExpr_return orExpr() throws RecognitionException {
        XSPARQLRewriter.orExpr_return retval = new XSPARQLRewriter.orExpr_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree OR239=null;
        XSPARQLRewriter.andExpr_return andExpr238 = null;

        XSPARQLRewriter.orExpr_return orExpr240 = null;

        XSPARQLRewriter.andExpr_return andExpr241 = null;


        CommonTree OR239_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1670:3: ( andExpr | ^( OR orExpr andExpr ) )
            int alt77=2;
            switch ( input.LA(1) ) {
            case LCURLY:
            case STAR:
            case LESSTHAN:
            case GREATERTHAN:
            case PLUS:
            case MINUS:
            case UNIONSYMBOL:
            case LESSTHANLESSTHAN:
            case GREATERTHANEQUALS:
            case LESSTHANEQUALS:
            case HAFENEQUALS:
            case EQUALS:
            case IS:
            case EQ:
            case NE:
            case LT:
            case GE:
            case LE:
            case GT:
            case AND:
            case TO:
            case DIV:
            case IDIV:
            case MOD:
            case UNION:
            case INTERSECT:
            case EXCEPT:
            case GREATERTHANGREATERTHAN:
            case T_INSTANCEOF:
            case T_CASTAS:
            case T_CASTABLEAS:
            case T_TREATAS:
            case VALIDATE:
            case XPATH:
                {
                alt77=1;
                }
                break;
            case OR:
                {
                alt77=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 77, 0, input);

                throw nvae;
            }

            switch (alt77) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1670:5: andExpr
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_andExpr_in_orExpr7366);
                    andExpr238=andExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, andExpr238.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1671:5: ^( OR orExpr andExpr )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    OR239=(CommonTree)match(input,OR,FOLLOW_OR_in_orExpr7373); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    OR239_tree = (CommonTree)adaptor.dupNode(OR239);

                    root_1 = (CommonTree)adaptor.becomeRoot(OR239_tree, root_1);
                    }


                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_orExpr_in_orExpr7375);
                    orExpr240=orExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_1, orExpr240.getTree());
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_andExpr_in_orExpr7377);
                    andExpr241=andExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_1, andExpr241.getTree());

                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "orExpr"

    public static class andExpr_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "andExpr"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1674:1: andExpr : ( comparisonExpr | ^( AND andExpr comparisonExpr ) );
    public final XSPARQLRewriter.andExpr_return andExpr() throws RecognitionException {
        XSPARQLRewriter.andExpr_return retval = new XSPARQLRewriter.andExpr_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree AND243=null;
        XSPARQLRewriter.comparisonExpr_return comparisonExpr242 = null;

        XSPARQLRewriter.andExpr_return andExpr244 = null;

        XSPARQLRewriter.comparisonExpr_return comparisonExpr245 = null;


        CommonTree AND243_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1675:3: ( comparisonExpr | ^( AND andExpr comparisonExpr ) )
            int alt78=2;
            switch ( input.LA(1) ) {
            case LCURLY:
            case STAR:
            case LESSTHAN:
            case GREATERTHAN:
            case PLUS:
            case MINUS:
            case UNIONSYMBOL:
            case LESSTHANLESSTHAN:
            case GREATERTHANEQUALS:
            case LESSTHANEQUALS:
            case HAFENEQUALS:
            case EQUALS:
            case IS:
            case EQ:
            case NE:
            case LT:
            case GE:
            case LE:
            case GT:
            case TO:
            case DIV:
            case IDIV:
            case MOD:
            case UNION:
            case INTERSECT:
            case EXCEPT:
            case GREATERTHANGREATERTHAN:
            case T_INSTANCEOF:
            case T_CASTAS:
            case T_CASTABLEAS:
            case T_TREATAS:
            case VALIDATE:
            case XPATH:
                {
                alt78=1;
                }
                break;
            case AND:
                {
                alt78=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 78, 0, input);

                throw nvae;
            }

            switch (alt78) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1675:5: comparisonExpr
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_comparisonExpr_in_andExpr7391);
                    comparisonExpr242=comparisonExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, comparisonExpr242.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1676:5: ^( AND andExpr comparisonExpr )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    AND243=(CommonTree)match(input,AND,FOLLOW_AND_in_andExpr7398); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    AND243_tree = (CommonTree)adaptor.dupNode(AND243);

                    root_1 = (CommonTree)adaptor.becomeRoot(AND243_tree, root_1);
                    }


                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_andExpr_in_andExpr7400);
                    andExpr244=andExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_1, andExpr244.getTree());
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_comparisonExpr_in_andExpr7402);
                    comparisonExpr245=comparisonExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_1, comparisonExpr245.getTree());

                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "andExpr"

    public static class comparisonExpr_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "comparisonExpr"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1679:1: comparisonExpr : ( rangeExpr | ^( ( EQ | NE | LT | LE | GT | GE | EQUALS | LESSTHAN | GREATERTHAN | LESSTHANEQUALS | GREATERTHANEQUALS | HAFENEQUALS | LESSTHANLESSTHAN | GREATERTHANGREATERTHAN | IS ) rangeExpr rangeExpr ) );
    public final XSPARQLRewriter.comparisonExpr_return comparisonExpr() throws RecognitionException {
        XSPARQLRewriter.comparisonExpr_return retval = new XSPARQLRewriter.comparisonExpr_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set247=null;
        XSPARQLRewriter.rangeExpr_return rangeExpr246 = null;

        XSPARQLRewriter.rangeExpr_return rangeExpr248 = null;

        XSPARQLRewriter.rangeExpr_return rangeExpr249 = null;


        CommonTree set247_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1680:3: ( rangeExpr | ^( ( EQ | NE | LT | LE | GT | GE | EQUALS | LESSTHAN | GREATERTHAN | LESSTHANEQUALS | GREATERTHANEQUALS | HAFENEQUALS | LESSTHANLESSTHAN | GREATERTHANGREATERTHAN | IS ) rangeExpr rangeExpr ) )
            int alt79=2;
            switch ( input.LA(1) ) {
            case LCURLY:
            case STAR:
            case PLUS:
            case MINUS:
            case UNIONSYMBOL:
            case TO:
            case DIV:
            case IDIV:
            case MOD:
            case UNION:
            case INTERSECT:
            case EXCEPT:
            case T_INSTANCEOF:
            case T_CASTAS:
            case T_CASTABLEAS:
            case T_TREATAS:
            case VALIDATE:
            case XPATH:
                {
                alt79=1;
                }
                break;
            case LESSTHAN:
            case GREATERTHAN:
            case LESSTHANLESSTHAN:
            case GREATERTHANEQUALS:
            case LESSTHANEQUALS:
            case HAFENEQUALS:
            case EQUALS:
            case IS:
            case EQ:
            case NE:
            case LT:
            case GE:
            case LE:
            case GT:
            case GREATERTHANGREATERTHAN:
                {
                alt79=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 79, 0, input);

                throw nvae;
            }

            switch (alt79) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1680:5: rangeExpr
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rangeExpr_in_comparisonExpr7416);
                    rangeExpr246=rangeExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, rangeExpr246.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1681:5: ^( ( EQ | NE | LT | LE | GT | GE | EQUALS | LESSTHAN | GREATERTHAN | LESSTHANEQUALS | GREATERTHANEQUALS | HAFENEQUALS | LESSTHANLESSTHAN | GREATERTHANGREATERTHAN | IS ) rangeExpr rangeExpr )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();set247=(CommonTree)input.LT(1);
                    if ( (input.LA(1)>=LESSTHAN && input.LA(1)<=GREATERTHAN)||(input.LA(1)>=LESSTHANLESSTHAN && input.LA(1)<=EQUALS)||(input.LA(1)>=IS && input.LA(1)<=GT)||input.LA(1)==GREATERTHANGREATERTHAN ) {
                        input.consume();

                        if ( state.backtracking==0 ) {
                        set247_tree = (CommonTree)adaptor.dupNode(set247);

                        root_1 = (CommonTree)adaptor.becomeRoot(set247_tree, root_1);
                        }
                        state.errorRecovery=false;state.failed=false;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }



                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rangeExpr_in_comparisonExpr7588);
                    rangeExpr248=rangeExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_1, rangeExpr248.getTree());
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rangeExpr_in_comparisonExpr7590);
                    rangeExpr249=rangeExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_1, rangeExpr249.getTree());

                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "comparisonExpr"

    public static class rangeExpr_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "rangeExpr"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1702:1: rangeExpr : ( additiveExpr | ^( TO rangeExpr additiveExpr ) );
    public final XSPARQLRewriter.rangeExpr_return rangeExpr() throws RecognitionException {
        XSPARQLRewriter.rangeExpr_return retval = new XSPARQLRewriter.rangeExpr_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree TO251=null;
        XSPARQLRewriter.additiveExpr_return additiveExpr250 = null;

        XSPARQLRewriter.rangeExpr_return rangeExpr252 = null;

        XSPARQLRewriter.additiveExpr_return additiveExpr253 = null;


        CommonTree TO251_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1703:3: ( additiveExpr | ^( TO rangeExpr additiveExpr ) )
            int alt80=2;
            switch ( input.LA(1) ) {
            case LCURLY:
            case STAR:
            case PLUS:
            case MINUS:
            case UNIONSYMBOL:
            case DIV:
            case IDIV:
            case MOD:
            case UNION:
            case INTERSECT:
            case EXCEPT:
            case T_INSTANCEOF:
            case T_CASTAS:
            case T_CASTABLEAS:
            case T_TREATAS:
            case VALIDATE:
            case XPATH:
                {
                alt80=1;
                }
                break;
            case TO:
                {
                alt80=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 80, 0, input);

                throw nvae;
            }

            switch (alt80) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1703:5: additiveExpr
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_additiveExpr_in_rangeExpr7609);
                    additiveExpr250=additiveExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, additiveExpr250.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1704:5: ^( TO rangeExpr additiveExpr )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    TO251=(CommonTree)match(input,TO,FOLLOW_TO_in_rangeExpr7616); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    TO251_tree = (CommonTree)adaptor.dupNode(TO251);

                    root_1 = (CommonTree)adaptor.becomeRoot(TO251_tree, root_1);
                    }


                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rangeExpr_in_rangeExpr7618);
                    rangeExpr252=rangeExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_1, rangeExpr252.getTree());
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_additiveExpr_in_rangeExpr7620);
                    additiveExpr253=additiveExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_1, additiveExpr253.getTree());

                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "rangeExpr"

    public static class additiveExpr_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "additiveExpr"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1707:1: additiveExpr : ( multiplicativeExpr | ^( ( PLUS | MINUS ) additiveExpr multiplicativeExpr ) );
    public final XSPARQLRewriter.additiveExpr_return additiveExpr() throws RecognitionException {
        XSPARQLRewriter.additiveExpr_return retval = new XSPARQLRewriter.additiveExpr_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set255=null;
        XSPARQLRewriter.multiplicativeExpr_return multiplicativeExpr254 = null;

        XSPARQLRewriter.additiveExpr_return additiveExpr256 = null;

        XSPARQLRewriter.multiplicativeExpr_return multiplicativeExpr257 = null;


        CommonTree set255_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1708:3: ( multiplicativeExpr | ^( ( PLUS | MINUS ) additiveExpr multiplicativeExpr ) )
            int alt81=2;
            switch ( input.LA(1) ) {
            case PLUS:
            case MINUS:
                {
                switch ( input.LA(2) ) {
                case DOWN:
                    {
                    alt81=2;
                    }
                    break;
                case LCURLY:
                case PLUS:
                case MINUS:
                case VALIDATE:
                case XPATH:
                    {
                    alt81=1;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 81, 1, input);

                    throw nvae;
                }

                }
                break;
            case LCURLY:
            case STAR:
            case UNIONSYMBOL:
            case DIV:
            case IDIV:
            case MOD:
            case UNION:
            case INTERSECT:
            case EXCEPT:
            case T_INSTANCEOF:
            case T_CASTAS:
            case T_CASTABLEAS:
            case T_TREATAS:
            case VALIDATE:
            case XPATH:
                {
                alt81=1;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 81, 0, input);

                throw nvae;
            }

            switch (alt81) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1708:5: multiplicativeExpr
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_multiplicativeExpr_in_additiveExpr7634);
                    multiplicativeExpr254=multiplicativeExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, multiplicativeExpr254.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1709:5: ^( ( PLUS | MINUS ) additiveExpr multiplicativeExpr )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();set255=(CommonTree)input.LT(1);
                    if ( (input.LA(1)>=PLUS && input.LA(1)<=MINUS) ) {
                        input.consume();

                        if ( state.backtracking==0 ) {
                        set255_tree = (CommonTree)adaptor.dupNode(set255);

                        root_1 = (CommonTree)adaptor.becomeRoot(set255_tree, root_1);
                        }
                        state.errorRecovery=false;state.failed=false;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }



                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_additiveExpr_in_additiveExpr7647);
                    additiveExpr256=additiveExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_1, additiveExpr256.getTree());
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_multiplicativeExpr_in_additiveExpr7649);
                    multiplicativeExpr257=multiplicativeExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_1, multiplicativeExpr257.getTree());

                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "additiveExpr"

    public static class multiplicativeExpr_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "multiplicativeExpr"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1711:1: multiplicativeExpr : ( unionExpr | ^( ( STAR | DIV | IDIV | MOD ) multiplicativeExpr unionExpr ) );
    public final XSPARQLRewriter.multiplicativeExpr_return multiplicativeExpr() throws RecognitionException {
        XSPARQLRewriter.multiplicativeExpr_return retval = new XSPARQLRewriter.multiplicativeExpr_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set259=null;
        XSPARQLRewriter.unionExpr_return unionExpr258 = null;

        XSPARQLRewriter.multiplicativeExpr_return multiplicativeExpr260 = null;

        XSPARQLRewriter.unionExpr_return unionExpr261 = null;


        CommonTree set259_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1712:3: ( unionExpr | ^( ( STAR | DIV | IDIV | MOD ) multiplicativeExpr unionExpr ) )
            int alt82=2;
            switch ( input.LA(1) ) {
            case LCURLY:
            case PLUS:
            case MINUS:
            case UNIONSYMBOL:
            case UNION:
            case INTERSECT:
            case EXCEPT:
            case T_INSTANCEOF:
            case T_CASTAS:
            case T_CASTABLEAS:
            case T_TREATAS:
            case VALIDATE:
            case XPATH:
                {
                alt82=1;
                }
                break;
            case STAR:
            case DIV:
            case IDIV:
            case MOD:
                {
                alt82=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 82, 0, input);

                throw nvae;
            }

            switch (alt82) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1712:5: unionExpr
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_unionExpr_in_multiplicativeExpr7660);
                    unionExpr258=unionExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, unionExpr258.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1713:5: ^( ( STAR | DIV | IDIV | MOD ) multiplicativeExpr unionExpr )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();set259=(CommonTree)input.LT(1);
                    if ( input.LA(1)==STAR||(input.LA(1)>=DIV && input.LA(1)<=MOD) ) {
                        input.consume();

                        if ( state.backtracking==0 ) {
                        set259_tree = (CommonTree)adaptor.dupNode(set259);

                        root_1 = (CommonTree)adaptor.becomeRoot(set259_tree, root_1);
                        }
                        state.errorRecovery=false;state.failed=false;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }



                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_multiplicativeExpr_in_multiplicativeExpr7683);
                    multiplicativeExpr260=multiplicativeExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_1, multiplicativeExpr260.getTree());
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_unionExpr_in_multiplicativeExpr7685);
                    unionExpr261=unionExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_1, unionExpr261.getTree());

                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "multiplicativeExpr"

    public static class unionExpr_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "unionExpr"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1716:1: unionExpr : ( intersectExceptExpr | ^( ( UNION | UNIONSYMBOL ) unionExpr intersectExceptExpr ) );
    public final XSPARQLRewriter.unionExpr_return unionExpr() throws RecognitionException {
        XSPARQLRewriter.unionExpr_return retval = new XSPARQLRewriter.unionExpr_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set263=null;
        XSPARQLRewriter.intersectExceptExpr_return intersectExceptExpr262 = null;

        XSPARQLRewriter.unionExpr_return unionExpr264 = null;

        XSPARQLRewriter.intersectExceptExpr_return intersectExceptExpr265 = null;


        CommonTree set263_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1717:3: ( intersectExceptExpr | ^( ( UNION | UNIONSYMBOL ) unionExpr intersectExceptExpr ) )
            int alt83=2;
            switch ( input.LA(1) ) {
            case LCURLY:
            case PLUS:
            case MINUS:
            case INTERSECT:
            case EXCEPT:
            case T_INSTANCEOF:
            case T_CASTAS:
            case T_CASTABLEAS:
            case T_TREATAS:
            case VALIDATE:
            case XPATH:
                {
                alt83=1;
                }
                break;
            case UNIONSYMBOL:
            case UNION:
                {
                alt83=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 83, 0, input);

                throw nvae;
            }

            switch (alt83) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1717:5: intersectExceptExpr
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_intersectExceptExpr_in_unionExpr7699);
                    intersectExceptExpr262=intersectExceptExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, intersectExceptExpr262.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1718:5: ^( ( UNION | UNIONSYMBOL ) unionExpr intersectExceptExpr )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();set263=(CommonTree)input.LT(1);
                    if ( input.LA(1)==UNIONSYMBOL||input.LA(1)==UNION ) {
                        input.consume();

                        if ( state.backtracking==0 ) {
                        set263_tree = (CommonTree)adaptor.dupNode(set263);

                        root_1 = (CommonTree)adaptor.becomeRoot(set263_tree, root_1);
                        }
                        state.errorRecovery=false;state.failed=false;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }



                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_unionExpr_in_unionExpr7714);
                    unionExpr264=unionExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_1, unionExpr264.getTree());
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_intersectExceptExpr_in_unionExpr7716);
                    intersectExceptExpr265=intersectExceptExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_1, intersectExceptExpr265.getTree());

                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "unionExpr"

    public static class intersectExceptExpr_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "intersectExceptExpr"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1721:1: intersectExceptExpr : ( instanceOfExpr | ^( ( INTERSECT | EXCEPT ) intersectExceptExpr instanceOfExpr ) );
    public final XSPARQLRewriter.intersectExceptExpr_return intersectExceptExpr() throws RecognitionException {
        XSPARQLRewriter.intersectExceptExpr_return retval = new XSPARQLRewriter.intersectExceptExpr_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set267=null;
        XSPARQLRewriter.instanceOfExpr_return instanceOfExpr266 = null;

        XSPARQLRewriter.intersectExceptExpr_return intersectExceptExpr268 = null;

        XSPARQLRewriter.instanceOfExpr_return instanceOfExpr269 = null;


        CommonTree set267_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1722:3: ( instanceOfExpr | ^( ( INTERSECT | EXCEPT ) intersectExceptExpr instanceOfExpr ) )
            int alt84=2;
            switch ( input.LA(1) ) {
            case LCURLY:
            case PLUS:
            case MINUS:
            case T_INSTANCEOF:
            case T_CASTAS:
            case T_CASTABLEAS:
            case T_TREATAS:
            case VALIDATE:
            case XPATH:
                {
                alt84=1;
                }
                break;
            case INTERSECT:
            case EXCEPT:
                {
                alt84=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 84, 0, input);

                throw nvae;
            }

            switch (alt84) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1722:5: instanceOfExpr
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_instanceOfExpr_in_intersectExceptExpr7730);
                    instanceOfExpr266=instanceOfExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, instanceOfExpr266.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1723:5: ^( ( INTERSECT | EXCEPT ) intersectExceptExpr instanceOfExpr )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();set267=(CommonTree)input.LT(1);
                    if ( (input.LA(1)>=INTERSECT && input.LA(1)<=EXCEPT) ) {
                        input.consume();

                        if ( state.backtracking==0 ) {
                        set267_tree = (CommonTree)adaptor.dupNode(set267);

                        root_1 = (CommonTree)adaptor.becomeRoot(set267_tree, root_1);
                        }
                        state.errorRecovery=false;state.failed=false;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }



                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_intersectExceptExpr_in_intersectExceptExpr7745);
                    intersectExceptExpr268=intersectExceptExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_1, intersectExceptExpr268.getTree());
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_instanceOfExpr_in_intersectExceptExpr7747);
                    instanceOfExpr269=instanceOfExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_1, instanceOfExpr269.getTree());

                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "intersectExceptExpr"

    public static class instanceOfExpr_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "instanceOfExpr"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1726:1: instanceOfExpr : ( treatExpr | ^( T_INSTANCEOF instanceOfExpr sequenceType ) );
    public final XSPARQLRewriter.instanceOfExpr_return instanceOfExpr() throws RecognitionException {
        XSPARQLRewriter.instanceOfExpr_return retval = new XSPARQLRewriter.instanceOfExpr_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree T_INSTANCEOF271=null;
        XSPARQLRewriter.treatExpr_return treatExpr270 = null;

        XSPARQLRewriter.instanceOfExpr_return instanceOfExpr272 = null;

        XSPARQLRewriter.sequenceType_return sequenceType273 = null;


        CommonTree T_INSTANCEOF271_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1727:3: ( treatExpr | ^( T_INSTANCEOF instanceOfExpr sequenceType ) )
            int alt85=2;
            switch ( input.LA(1) ) {
            case LCURLY:
            case PLUS:
            case MINUS:
            case T_CASTAS:
            case T_CASTABLEAS:
            case T_TREATAS:
            case VALIDATE:
            case XPATH:
                {
                alt85=1;
                }
                break;
            case T_INSTANCEOF:
                {
                alt85=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 85, 0, input);

                throw nvae;
            }

            switch (alt85) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1727:5: treatExpr
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_treatExpr_in_instanceOfExpr7761);
                    treatExpr270=treatExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, treatExpr270.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1728:5: ^( T_INSTANCEOF instanceOfExpr sequenceType )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    T_INSTANCEOF271=(CommonTree)match(input,T_INSTANCEOF,FOLLOW_T_INSTANCEOF_in_instanceOfExpr7768); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    T_INSTANCEOF271_tree = (CommonTree)adaptor.dupNode(T_INSTANCEOF271);

                    root_1 = (CommonTree)adaptor.becomeRoot(T_INSTANCEOF271_tree, root_1);
                    }


                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_instanceOfExpr_in_instanceOfExpr7770);
                    instanceOfExpr272=instanceOfExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_1, instanceOfExpr272.getTree());
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_sequenceType_in_instanceOfExpr7772);
                    sequenceType273=sequenceType();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_1, sequenceType273.getTree());

                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "instanceOfExpr"

    public static class treatExpr_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "treatExpr"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1731:1: treatExpr : ( castableExpr | ^( T_TREATAS treatExpr sequenceType ) );
    public final XSPARQLRewriter.treatExpr_return treatExpr() throws RecognitionException {
        XSPARQLRewriter.treatExpr_return retval = new XSPARQLRewriter.treatExpr_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree T_TREATAS275=null;
        XSPARQLRewriter.castableExpr_return castableExpr274 = null;

        XSPARQLRewriter.treatExpr_return treatExpr276 = null;

        XSPARQLRewriter.sequenceType_return sequenceType277 = null;


        CommonTree T_TREATAS275_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1732:3: ( castableExpr | ^( T_TREATAS treatExpr sequenceType ) )
            int alt86=2;
            switch ( input.LA(1) ) {
            case LCURLY:
            case PLUS:
            case MINUS:
            case T_CASTAS:
            case T_CASTABLEAS:
            case VALIDATE:
            case XPATH:
                {
                alt86=1;
                }
                break;
            case T_TREATAS:
                {
                alt86=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 86, 0, input);

                throw nvae;
            }

            switch (alt86) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1732:5: castableExpr
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_castableExpr_in_treatExpr7786);
                    castableExpr274=castableExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, castableExpr274.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1733:5: ^( T_TREATAS treatExpr sequenceType )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    T_TREATAS275=(CommonTree)match(input,T_TREATAS,FOLLOW_T_TREATAS_in_treatExpr7793); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    T_TREATAS275_tree = (CommonTree)adaptor.dupNode(T_TREATAS275);

                    root_1 = (CommonTree)adaptor.becomeRoot(T_TREATAS275_tree, root_1);
                    }


                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_treatExpr_in_treatExpr7795);
                    treatExpr276=treatExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_1, treatExpr276.getTree());
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_sequenceType_in_treatExpr7797);
                    sequenceType277=sequenceType();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_1, sequenceType277.getTree());

                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "treatExpr"

    public static class castableExpr_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "castableExpr"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1736:1: castableExpr : ( castExpr | ^( T_CASTABLEAS castableExpr singleType ) );
    public final XSPARQLRewriter.castableExpr_return castableExpr() throws RecognitionException {
        XSPARQLRewriter.castableExpr_return retval = new XSPARQLRewriter.castableExpr_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree T_CASTABLEAS279=null;
        XSPARQLRewriter.castExpr_return castExpr278 = null;

        XSPARQLRewriter.castableExpr_return castableExpr280 = null;

        XSPARQLRewriter.singleType_return singleType281 = null;


        CommonTree T_CASTABLEAS279_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1737:3: ( castExpr | ^( T_CASTABLEAS castableExpr singleType ) )
            int alt87=2;
            switch ( input.LA(1) ) {
            case LCURLY:
            case PLUS:
            case MINUS:
            case T_CASTAS:
            case VALIDATE:
            case XPATH:
                {
                alt87=1;
                }
                break;
            case T_CASTABLEAS:
                {
                alt87=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 87, 0, input);

                throw nvae;
            }

            switch (alt87) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1737:5: castExpr
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_castExpr_in_castableExpr7811);
                    castExpr278=castExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, castExpr278.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1738:5: ^( T_CASTABLEAS castableExpr singleType )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    T_CASTABLEAS279=(CommonTree)match(input,T_CASTABLEAS,FOLLOW_T_CASTABLEAS_in_castableExpr7818); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    T_CASTABLEAS279_tree = (CommonTree)adaptor.dupNode(T_CASTABLEAS279);

                    root_1 = (CommonTree)adaptor.becomeRoot(T_CASTABLEAS279_tree, root_1);
                    }


                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_castableExpr_in_castableExpr7820);
                    castableExpr280=castableExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_1, castableExpr280.getTree());
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_singleType_in_castableExpr7822);
                    singleType281=singleType();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_1, singleType281.getTree());

                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "castableExpr"

    public static class castExpr_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "castExpr"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1741:1: castExpr : ( unaryExpr | ^( T_CASTAS castExpr singleType ) );
    public final XSPARQLRewriter.castExpr_return castExpr() throws RecognitionException {
        XSPARQLRewriter.castExpr_return retval = new XSPARQLRewriter.castExpr_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree T_CASTAS283=null;
        XSPARQLRewriter.unaryExpr_return unaryExpr282 = null;

        XSPARQLRewriter.castExpr_return castExpr284 = null;

        XSPARQLRewriter.singleType_return singleType285 = null;


        CommonTree T_CASTAS283_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1742:3: ( unaryExpr | ^( T_CASTAS castExpr singleType ) )
            int alt88=2;
            switch ( input.LA(1) ) {
            case LCURLY:
            case PLUS:
            case MINUS:
            case VALIDATE:
            case XPATH:
                {
                alt88=1;
                }
                break;
            case T_CASTAS:
                {
                alt88=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 88, 0, input);

                throw nvae;
            }

            switch (alt88) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1742:5: unaryExpr
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_unaryExpr_in_castExpr7836);
                    unaryExpr282=unaryExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, unaryExpr282.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1743:5: ^( T_CASTAS castExpr singleType )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    T_CASTAS283=(CommonTree)match(input,T_CASTAS,FOLLOW_T_CASTAS_in_castExpr7843); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    T_CASTAS283_tree = (CommonTree)adaptor.dupNode(T_CASTAS283);

                    root_1 = (CommonTree)adaptor.becomeRoot(T_CASTAS283_tree, root_1);
                    }


                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_castExpr_in_castExpr7845);
                    castExpr284=castExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_1, castExpr284.getTree());
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_singleType_in_castExpr7847);
                    singleType285=singleType();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_1, singleType285.getTree());

                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "castExpr"

    public static class unaryExpr_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "unaryExpr"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1746:1: unaryExpr : ( MINUS | PLUS )* valueExpr ;
    public final XSPARQLRewriter.unaryExpr_return unaryExpr() throws RecognitionException {
        XSPARQLRewriter.unaryExpr_return retval = new XSPARQLRewriter.unaryExpr_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set286=null;
        XSPARQLRewriter.valueExpr_return valueExpr287 = null;


        CommonTree set286_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1747:3: ( ( MINUS | PLUS )* valueExpr )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1747:5: ( MINUS | PLUS )* valueExpr
            {
            root_0 = (CommonTree)adaptor.nil();

            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1747:5: ( MINUS | PLUS )*
            loop89:
            do {
                int alt89=2;
                switch ( input.LA(1) ) {
                case PLUS:
                case MINUS:
                    {
                    alt89=1;
                    }
                    break;

                }

                switch (alt89) {
            	case 1 :
            	    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    set286=(CommonTree)input.LT(1);
            	    if ( (input.LA(1)>=PLUS && input.LA(1)<=MINUS) ) {
            	        input.consume();

            	        if ( state.backtracking==0 ) {
            	        set286_tree = (CommonTree)adaptor.dupNode(set286);

            	        adaptor.addChild(root_0, set286_tree);
            	        }
            	        state.errorRecovery=false;state.failed=false;
            	    }
            	    else {
            	        if (state.backtracking>0) {state.failed=true; return retval;}
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        throw mse;
            	    }


            	    }
            	    break;

            	default :
            	    break loop89;
                }
            } while (true);

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_valueExpr_in_unaryExpr7870);
            valueExpr287=valueExpr();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_0, valueExpr287.getTree());

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "unaryExpr"

    public static class valueExpr_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "valueExpr"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1750:1: valueExpr : ( pathExpr | validateExpr | extensionExpr );
    public final XSPARQLRewriter.valueExpr_return valueExpr() throws RecognitionException {
        XSPARQLRewriter.valueExpr_return retval = new XSPARQLRewriter.valueExpr_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.pathExpr_return pathExpr288 = null;

        XSPARQLRewriter.validateExpr_return validateExpr289 = null;

        XSPARQLRewriter.extensionExpr_return extensionExpr290 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1751:3: ( pathExpr | validateExpr | extensionExpr )
            int alt90=3;
            switch ( input.LA(1) ) {
            case XPATH:
                {
                alt90=1;
                }
                break;
            case VALIDATE:
                {
                alt90=2;
                }
                break;
            case LCURLY:
                {
                alt90=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 90, 0, input);

                throw nvae;
            }

            switch (alt90) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1751:5: pathExpr
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_pathExpr_in_valueExpr7883);
                    pathExpr288=pathExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, pathExpr288.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1752:5: validateExpr
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_validateExpr_in_valueExpr7889);
                    validateExpr289=validateExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, validateExpr289.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 3 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1753:5: extensionExpr
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_extensionExpr_in_valueExpr7895);
                    extensionExpr290=extensionExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, extensionExpr290.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "valueExpr"

    public static class validateExpr_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "validateExpr"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1756:1: validateExpr : VALIDATE ( validationMode )? expr ;
    public final XSPARQLRewriter.validateExpr_return validateExpr() throws RecognitionException {
        XSPARQLRewriter.validateExpr_return retval = new XSPARQLRewriter.validateExpr_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree VALIDATE291=null;
        XSPARQLRewriter.validationMode_return validationMode292 = null;

        XSPARQLRewriter.expr_return expr293 = null;


        CommonTree VALIDATE291_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1757:3: ( VALIDATE ( validationMode )? expr )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1757:5: VALIDATE ( validationMode )? expr
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            VALIDATE291=(CommonTree)match(input,VALIDATE,FOLLOW_VALIDATE_in_validateExpr7908); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            VALIDATE291_tree = (CommonTree)adaptor.dupNode(VALIDATE291);

            adaptor.addChild(root_0, VALIDATE291_tree);
            }
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1757:14: ( validationMode )?
            int alt91=2;
            switch ( input.LA(1) ) {
                case LAX:
                case STRICT:
                    {
                    alt91=1;
                    }
                    break;
            }

            switch (alt91) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: validationMode
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_validationMode_in_validateExpr7910);
                    validationMode292=validationMode();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, validationMode292.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_expr_in_validateExpr7913);
            expr293=expr();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_0, expr293.getTree());

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "validateExpr"

    public static class validationMode_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "validationMode"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1760:1: validationMode : ( LAX | STRICT );
    public final XSPARQLRewriter.validationMode_return validationMode() throws RecognitionException {
        XSPARQLRewriter.validationMode_return retval = new XSPARQLRewriter.validationMode_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set294=null;

        CommonTree set294_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1761:3: ( LAX | STRICT )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            set294=(CommonTree)input.LT(1);
            if ( input.LA(1)==LAX||input.LA(1)==STRICT ) {
                input.consume();

                if ( state.backtracking==0 ) {
                set294_tree = (CommonTree)adaptor.dupNode(set294);

                adaptor.addChild(root_0, set294_tree);
                }
                state.errorRecovery=false;state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

            if ( state.backtracking==0 ) {
            } 

            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "validationMode"

    public static class extensionExpr_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "extensionExpr"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1765:1: extensionExpr : LCURLY ( expr )? RCURLY ;
    public final XSPARQLRewriter.extensionExpr_return extensionExpr() throws RecognitionException {
        XSPARQLRewriter.extensionExpr_return retval = new XSPARQLRewriter.extensionExpr_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree LCURLY295=null;
        CommonTree RCURLY297=null;
        XSPARQLRewriter.expr_return expr296 = null;


        CommonTree LCURLY295_tree=null;
        CommonTree RCURLY297_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1766:3: ( LCURLY ( expr )? RCURLY )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1767:5: LCURLY ( expr )? RCURLY
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            LCURLY295=(CommonTree)match(input,LCURLY,FOLLOW_LCURLY_in_extensionExpr7950); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            LCURLY295_tree = (CommonTree)adaptor.dupNode(LCURLY295);

            adaptor.addChild(root_0, LCURLY295_tree);
            }
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1767:12: ( expr )?
            int alt92=2;
            switch ( input.LA(1) ) {
                case LCURLY:
                case STAR:
                case LESSTHAN:
                case GREATERTHAN:
                case PLUS:
                case MINUS:
                case UNIONSYMBOL:
                case LESSTHANLESSTHAN:
                case GREATERTHANEQUALS:
                case LESSTHANEQUALS:
                case HAFENEQUALS:
                case EQUALS:
                case IS:
                case EQ:
                case NE:
                case LT:
                case GE:
                case LE:
                case GT:
                case IF:
                case AND:
                case OR:
                case TO:
                case DIV:
                case IDIV:
                case MOD:
                case UNION:
                case INTERSECT:
                case EXCEPT:
                case GREATERTHANGREATERTHAN:
                case T_FLWOR:
                case T_INSTANCEOF:
                case T_CASTAS:
                case T_CASTABLEAS:
                case T_TREATAS:
                case EVERY:
                case TYPESWITCH:
                case VALIDATE:
                case SOME:
                case XPATH:
                    {
                    alt92=1;
                    }
                    break;
            }

            switch (alt92) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: expr
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expr_in_extensionExpr7952);
                    expr296=expr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, expr296.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }

            _last = (CommonTree)input.LT(1);
            RCURLY297=(CommonTree)match(input,RCURLY,FOLLOW_RCURLY_in_extensionExpr7955); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            RCURLY297_tree = (CommonTree)adaptor.dupNode(RCURLY297);

            adaptor.addChild(root_0, RCURLY297_tree);
            }

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "extensionExpr"

    public static class pathExpr_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "pathExpr"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1770:1: pathExpr : ( ^( XPATH SLASH SLASH relativePathExpr ) | ^( XPATH SLASH relativePathExpr ) | ^( XPATH SLASH ) | ^( XPATH relativePathExpr ) );
    public final XSPARQLRewriter.pathExpr_return pathExpr() throws RecognitionException {
        XSPARQLRewriter.pathExpr_return retval = new XSPARQLRewriter.pathExpr_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree XPATH298=null;
        CommonTree SLASH299=null;
        CommonTree SLASH300=null;
        CommonTree XPATH302=null;
        CommonTree SLASH303=null;
        CommonTree XPATH305=null;
        CommonTree SLASH306=null;
        CommonTree XPATH307=null;
        XSPARQLRewriter.relativePathExpr_return relativePathExpr301 = null;

        XSPARQLRewriter.relativePathExpr_return relativePathExpr304 = null;

        XSPARQLRewriter.relativePathExpr_return relativePathExpr308 = null;


        CommonTree XPATH298_tree=null;
        CommonTree SLASH299_tree=null;
        CommonTree SLASH300_tree=null;
        CommonTree XPATH302_tree=null;
        CommonTree SLASH303_tree=null;
        CommonTree XPATH305_tree=null;
        CommonTree SLASH306_tree=null;
        CommonTree XPATH307_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1771:3: ( ^( XPATH SLASH SLASH relativePathExpr ) | ^( XPATH SLASH relativePathExpr ) | ^( XPATH SLASH ) | ^( XPATH relativePathExpr ) )
            int alt93=4;
            switch ( input.LA(1) ) {
            case XPATH:
                {
                switch ( input.LA(2) ) {
                case DOWN:
                    {
                    switch ( input.LA(3) ) {
                    case SLASH:
                        {
                        switch ( input.LA(4) ) {
                        case SLASH:
                            {
                            alt93=1;
                            }
                            break;
                        case UP:
                            {
                            alt93=3;
                            }
                            break;
                        case VAR:
                        case INTEGER:
                        case NCNAME:
                        case QSTRING:
                        case DOT:
                        case AT:
                        case STAR:
                        case DOTDOT:
                        case PNAME_NS:
                        case PNAME_LN:
                        case A:
                        case FROM:
                        case CHILD:
                        case DESCENDANT:
                        case ATTRIBUTE:
                        case SELF:
                        case DESCENDANTORSELF:
                        case FOLLOWINGSIBLING:
                        case FOLLOWING:
                        case PARENT:
                        case ANCESTOR:
                        case PRECEDINGSIBLING:
                        case PRECEDING:
                        case ANCESTORORSELF:
                        case ORDERED:
                        case UNORDERED:
                        case ELEMENT:
                        case TO:
                        case ITEM:
                        case NODE:
                        case DOCUMENTNODE:
                        case TEXT:
                        case COMMENT:
                        case PROCESSINGINSTRUCTION:
                        case SCHEMAATTRIBUTE:
                        case SCHEMAELEMENT:
                        case DOCUMENT:
                        case ROW:
                        case T_XML_ELEMENT:
                        case T_PAR:
                        case T_FUNCTION_CALL:
                        case DECIMAL:
                            {
                            alt93=2;
                            }
                            break;
                        default:
                            if (state.backtracking>0) {state.failed=true; return retval;}
                            NoViableAltException nvae =
                                new NoViableAltException("", 93, 3, input);

                            throw nvae;
                        }

                        }
                        break;
                    case VAR:
                    case INTEGER:
                    case NCNAME:
                    case QSTRING:
                    case DOT:
                    case AT:
                    case STAR:
                    case DOTDOT:
                    case PNAME_NS:
                    case PNAME_LN:
                    case A:
                    case FROM:
                    case CHILD:
                    case DESCENDANT:
                    case ATTRIBUTE:
                    case SELF:
                    case DESCENDANTORSELF:
                    case FOLLOWINGSIBLING:
                    case FOLLOWING:
                    case PARENT:
                    case ANCESTOR:
                    case PRECEDINGSIBLING:
                    case PRECEDING:
                    case ANCESTORORSELF:
                    case ORDERED:
                    case UNORDERED:
                    case ELEMENT:
                    case TO:
                    case ITEM:
                    case NODE:
                    case DOCUMENTNODE:
                    case TEXT:
                    case COMMENT:
                    case PROCESSINGINSTRUCTION:
                    case SCHEMAATTRIBUTE:
                    case SCHEMAELEMENT:
                    case DOCUMENT:
                    case ROW:
                    case T_XML_ELEMENT:
                    case T_PAR:
                    case T_FUNCTION_CALL:
                    case DECIMAL:
                        {
                        alt93=4;
                        }
                        break;
                    default:
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 93, 2, input);

                        throw nvae;
                    }

                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 93, 1, input);

                    throw nvae;
                }

                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 93, 0, input);

                throw nvae;
            }

            switch (alt93) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1771:5: ^( XPATH SLASH SLASH relativePathExpr )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    XPATH298=(CommonTree)match(input,XPATH,FOLLOW_XPATH_in_pathExpr7969); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    XPATH298_tree = (CommonTree)adaptor.dupNode(XPATH298);

                    root_1 = (CommonTree)adaptor.becomeRoot(XPATH298_tree, root_1);
                    }


                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    SLASH299=(CommonTree)match(input,SLASH,FOLLOW_SLASH_in_pathExpr7971); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    SLASH299_tree = (CommonTree)adaptor.dupNode(SLASH299);

                    adaptor.addChild(root_1, SLASH299_tree);
                    }
                    _last = (CommonTree)input.LT(1);
                    SLASH300=(CommonTree)match(input,SLASH,FOLLOW_SLASH_in_pathExpr7973); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    SLASH300_tree = (CommonTree)adaptor.dupNode(SLASH300);

                    adaptor.addChild(root_1, SLASH300_tree);
                    }
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_relativePathExpr_in_pathExpr7975);
                    relativePathExpr301=relativePathExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_1, relativePathExpr301.getTree());

                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1772:5: ^( XPATH SLASH relativePathExpr )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    XPATH302=(CommonTree)match(input,XPATH,FOLLOW_XPATH_in_pathExpr7983); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    XPATH302_tree = (CommonTree)adaptor.dupNode(XPATH302);

                    root_1 = (CommonTree)adaptor.becomeRoot(XPATH302_tree, root_1);
                    }


                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    SLASH303=(CommonTree)match(input,SLASH,FOLLOW_SLASH_in_pathExpr7985); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    SLASH303_tree = (CommonTree)adaptor.dupNode(SLASH303);

                    adaptor.addChild(root_1, SLASH303_tree);
                    }
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_relativePathExpr_in_pathExpr7987);
                    relativePathExpr304=relativePathExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_1, relativePathExpr304.getTree());

                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 3 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1773:5: ^( XPATH SLASH )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    XPATH305=(CommonTree)match(input,XPATH,FOLLOW_XPATH_in_pathExpr7995); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    XPATH305_tree = (CommonTree)adaptor.dupNode(XPATH305);

                    root_1 = (CommonTree)adaptor.becomeRoot(XPATH305_tree, root_1);
                    }


                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    SLASH306=(CommonTree)match(input,SLASH,FOLLOW_SLASH_in_pathExpr7997); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    SLASH306_tree = (CommonTree)adaptor.dupNode(SLASH306);

                    adaptor.addChild(root_1, SLASH306_tree);
                    }

                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 4 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1774:5: ^( XPATH relativePathExpr )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    XPATH307=(CommonTree)match(input,XPATH,FOLLOW_XPATH_in_pathExpr8005); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    XPATH307_tree = (CommonTree)adaptor.dupNode(XPATH307);

                    root_1 = (CommonTree)adaptor.becomeRoot(XPATH307_tree, root_1);
                    }


                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_relativePathExpr_in_pathExpr8007);
                    relativePathExpr308=relativePathExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_1, relativePathExpr308.getTree());

                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "pathExpr"

    protected static class relativePathExpr_scope {
        boolean rdbVar;
    }
    protected Stack relativePathExpr_stack = new Stack();

    public static class relativePathExpr_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "relativePathExpr"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1777:1: relativePathExpr : stepExpr ( SLASH ( SLASH )? stepExpr )* ;
    public final XSPARQLRewriter.relativePathExpr_return relativePathExpr() throws RecognitionException {
        relativePathExpr_stack.push(new relativePathExpr_scope());
        XSPARQLRewriter.relativePathExpr_return retval = new XSPARQLRewriter.relativePathExpr_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree SLASH310=null;
        CommonTree SLASH311=null;
        XSPARQLRewriter.stepExpr_return stepExpr309 = null;

        XSPARQLRewriter.stepExpr_return stepExpr312 = null;


        CommonTree SLASH310_tree=null;
        CommonTree SLASH311_tree=null;


          ((relativePathExpr_scope)relativePathExpr_stack.peek()).rdbVar = false;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1784:3: ( stepExpr ( SLASH ( SLASH )? stepExpr )* )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1784:5: stepExpr ( SLASH ( SLASH )? stepExpr )*
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_stepExpr_in_relativePathExpr8030);
            stepExpr309=stepExpr();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_0, stepExpr309.getTree());
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1784:14: ( SLASH ( SLASH )? stepExpr )*
            loop95:
            do {
                int alt95=2;
                switch ( input.LA(1) ) {
                case SLASH:
                    {
                    alt95=1;
                    }
                    break;

                }

                switch (alt95) {
            	case 1 :
            	    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1784:15: SLASH ( SLASH )? stepExpr
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    SLASH310=(CommonTree)match(input,SLASH,FOLLOW_SLASH_in_relativePathExpr8033); if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {
            	    SLASH310_tree = (CommonTree)adaptor.dupNode(SLASH310);

            	    adaptor.addChild(root_0, SLASH310_tree);
            	    }
            	    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1784:21: ( SLASH )?
            	    int alt94=2;
            	    switch ( input.LA(1) ) {
            	        case SLASH:
            	            {
            	            alt94=1;
            	            }
            	            break;
            	    }

            	    switch (alt94) {
            	        case 1 :
            	            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: SLASH
            	            {
            	            _last = (CommonTree)input.LT(1);
            	            SLASH311=(CommonTree)match(input,SLASH,FOLLOW_SLASH_in_relativePathExpr8035); if (state.failed) return retval;
            	            if ( state.backtracking==0 ) {
            	            SLASH311_tree = (CommonTree)adaptor.dupNode(SLASH311);

            	            adaptor.addChild(root_0, SLASH311_tree);
            	            }

            	            if ( state.backtracking==0 ) {
            	            }
            	            }
            	            break;

            	    }

            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_stepExpr_in_relativePathExpr8038);
            	    stepExpr312=stepExpr();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) 
            	    adaptor.addChild(root_0, stepExpr312.getTree());

            	    if ( state.backtracking==0 ) {
            	    }
            	    }
            	    break;

            	default :
            	    break loop95;
                }
            } while (true);


            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
            relativePathExpr_stack.pop();
        }
        return retval;
    }
    // $ANTLR end "relativePathExpr"

    public static class stepExpr_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "stepExpr"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1790:1: stepExpr : ( filterExpr | axisStep );
    public final XSPARQLRewriter.stepExpr_return stepExpr() throws RecognitionException {
        XSPARQLRewriter.stepExpr_return retval = new XSPARQLRewriter.stepExpr_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.filterExpr_return filterExpr313 = null;

        XSPARQLRewriter.axisStep_return axisStep314 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1791:3: ( filterExpr | axisStep )
            int alt96=2;
            switch ( input.LA(1) ) {
            case VAR:
            case INTEGER:
            case QSTRING:
            case DOT:
            case ORDERED:
            case UNORDERED:
            case DOCUMENT:
            case T_XML_ELEMENT:
            case T_PAR:
            case T_FUNCTION_CALL:
            case DECIMAL:
                {
                alt96=1;
                }
                break;
            case ELEMENT:
                {
                switch ( input.LA(2) ) {
                case LPAR:
                    {
                    alt96=2;
                    }
                    break;
                case LCURLY:
                case NCNAME:
                case PNAME_NS:
                case PNAME_LN:
                case A:
                case FROM:
                case TO:
                case ITEM:
                case NODE:
                case COMMENT:
                case ROW:
                    {
                    alt96=1;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 96, 2, input);

                    throw nvae;
                }

                }
                break;
            case ATTRIBUTE:
                {
                switch ( input.LA(2) ) {
                case LPAR:
                case COLONCOLON:
                    {
                    alt96=2;
                    }
                    break;
                case LCURLY:
                case NCNAME:
                case STAR:
                case LESSTHAN:
                case GREATERTHAN:
                case PLUS:
                case MINUS:
                case UNIONSYMBOL:
                case LESSTHANLESSTHAN:
                case GREATERTHANEQUALS:
                case LESSTHANEQUALS:
                case HAFENEQUALS:
                case EQUALS:
                case PNAME_NS:
                case PNAME_LN:
                case A:
                case IS:
                case EQ:
                case NE:
                case LT:
                case GE:
                case LE:
                case GT:
                case FROM:
                case IF:
                case AND:
                case OR:
                case TO:
                case DIV:
                case IDIV:
                case MOD:
                case UNION:
                case INTERSECT:
                case EXCEPT:
                case ITEM:
                case NODE:
                case COMMENT:
                case GREATERTHANGREATERTHAN:
                case ROW:
                case T_FLWOR:
                case T_INSTANCEOF:
                case T_CASTAS:
                case T_CASTABLEAS:
                case T_TREATAS:
                case EVERY:
                case TYPESWITCH:
                case VALIDATE:
                case SOME:
                case XPATH:
                    {
                    alt96=1;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 96, 3, input);

                    throw nvae;
                }

                }
                break;
            case TEXT:
                {
                switch ( input.LA(2) ) {
                case LPAR:
                    {
                    alt96=2;
                    }
                    break;
                case LCURLY:
                    {
                    alt96=1;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 96, 4, input);

                    throw nvae;
                }

                }
                break;
            case COMMENT:
                {
                switch ( input.LA(2) ) {
                case EOF:
                case UP:
                case SLASH:
                case LBRACKET:
                case LPAR:
                    {
                    alt96=2;
                    }
                    break;
                case LCURLY:
                case STAR:
                case LESSTHAN:
                case GREATERTHAN:
                case PLUS:
                case MINUS:
                case UNIONSYMBOL:
                case LESSTHANLESSTHAN:
                case GREATERTHANEQUALS:
                case LESSTHANEQUALS:
                case HAFENEQUALS:
                case EQUALS:
                case IS:
                case EQ:
                case NE:
                case LT:
                case GE:
                case LE:
                case GT:
                case IF:
                case AND:
                case OR:
                case TO:
                case DIV:
                case IDIV:
                case MOD:
                case UNION:
                case INTERSECT:
                case EXCEPT:
                case GREATERTHANGREATERTHAN:
                case T_FLWOR:
                case T_INSTANCEOF:
                case T_CASTAS:
                case T_CASTABLEAS:
                case T_TREATAS:
                case EVERY:
                case TYPESWITCH:
                case VALIDATE:
                case SOME:
                case XPATH:
                    {
                    alt96=1;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 96, 5, input);

                    throw nvae;
                }

                }
                break;
            case PROCESSINGINSTRUCTION:
                {
                switch ( input.LA(2) ) {
                case LPAR:
                    {
                    alt96=2;
                    }
                    break;
                case LCURLY:
                case NCNAME:
                case STAR:
                case LESSTHAN:
                case GREATERTHAN:
                case PLUS:
                case MINUS:
                case UNIONSYMBOL:
                case LESSTHANLESSTHAN:
                case GREATERTHANEQUALS:
                case LESSTHANEQUALS:
                case HAFENEQUALS:
                case EQUALS:
                case IS:
                case EQ:
                case NE:
                case LT:
                case GE:
                case LE:
                case GT:
                case IF:
                case AND:
                case OR:
                case TO:
                case DIV:
                case IDIV:
                case MOD:
                case UNION:
                case INTERSECT:
                case EXCEPT:
                case GREATERTHANGREATERTHAN:
                case T_FLWOR:
                case T_INSTANCEOF:
                case T_CASTAS:
                case T_CASTABLEAS:
                case T_TREATAS:
                case EVERY:
                case TYPESWITCH:
                case VALIDATE:
                case SOME:
                case XPATH:
                    {
                    alt96=1;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 96, 6, input);

                    throw nvae;
                }

                }
                break;
            case NCNAME:
            case AT:
            case STAR:
            case DOTDOT:
            case PNAME_NS:
            case PNAME_LN:
            case A:
            case FROM:
            case CHILD:
            case DESCENDANT:
            case SELF:
            case DESCENDANTORSELF:
            case FOLLOWINGSIBLING:
            case FOLLOWING:
            case PARENT:
            case ANCESTOR:
            case PRECEDINGSIBLING:
            case PRECEDING:
            case ANCESTORORSELF:
            case TO:
            case ITEM:
            case NODE:
            case DOCUMENTNODE:
            case SCHEMAATTRIBUTE:
            case SCHEMAELEMENT:
            case ROW:
                {
                alt96=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 96, 0, input);

                throw nvae;
            }

            switch (alt96) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1791:5: filterExpr
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_filterExpr_in_stepExpr8056);
                    filterExpr313=filterExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, filterExpr313.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1792:5: axisStep
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_axisStep_in_stepExpr8062);
                    axisStep314=axisStep();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, axisStep314.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "stepExpr"

    public static class axisStep_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "axisStep"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1795:1: axisStep : ( reverseStep | forwardStep ) predicateList ;
    public final XSPARQLRewriter.axisStep_return axisStep() throws RecognitionException {
        XSPARQLRewriter.axisStep_return retval = new XSPARQLRewriter.axisStep_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.reverseStep_return reverseStep315 = null;

        XSPARQLRewriter.forwardStep_return forwardStep316 = null;

        XSPARQLRewriter.predicateList_return predicateList317 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1796:3: ( ( reverseStep | forwardStep ) predicateList )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1796:5: ( reverseStep | forwardStep ) predicateList
            {
            root_0 = (CommonTree)adaptor.nil();

            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1796:5: ( reverseStep | forwardStep )
            int alt97=2;
            switch ( input.LA(1) ) {
            case DOTDOT:
            case PARENT:
            case ANCESTOR:
            case PRECEDINGSIBLING:
            case PRECEDING:
            case ANCESTORORSELF:
                {
                alt97=1;
                }
                break;
            case NCNAME:
            case AT:
            case STAR:
            case PNAME_NS:
            case PNAME_LN:
            case A:
            case FROM:
            case CHILD:
            case DESCENDANT:
            case ATTRIBUTE:
            case SELF:
            case DESCENDANTORSELF:
            case FOLLOWINGSIBLING:
            case FOLLOWING:
            case ELEMENT:
            case TO:
            case ITEM:
            case NODE:
            case DOCUMENTNODE:
            case TEXT:
            case COMMENT:
            case PROCESSINGINSTRUCTION:
            case SCHEMAATTRIBUTE:
            case SCHEMAELEMENT:
            case ROW:
                {
                alt97=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 97, 0, input);

                throw nvae;
            }

            switch (alt97) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1796:6: reverseStep
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_reverseStep_in_axisStep8076);
                    reverseStep315=reverseStep();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, reverseStep315.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1796:20: forwardStep
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_forwardStep_in_axisStep8080);
                    forwardStep316=forwardStep();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, forwardStep316.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_predicateList_in_axisStep8083);
            predicateList317=predicateList();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_0, predicateList317.getTree());

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "axisStep"

    public static class forwardStep_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "forwardStep"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1799:1: forwardStep : ( forwardAxis nodeTest | abbrevForwardStep );
    public final XSPARQLRewriter.forwardStep_return forwardStep() throws RecognitionException {
        XSPARQLRewriter.forwardStep_return retval = new XSPARQLRewriter.forwardStep_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.forwardAxis_return forwardAxis318 = null;

        XSPARQLRewriter.nodeTest_return nodeTest319 = null;

        XSPARQLRewriter.abbrevForwardStep_return abbrevForwardStep320 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1800:3: ( forwardAxis nodeTest | abbrevForwardStep )
            int alt98=2;
            switch ( input.LA(1) ) {
            case CHILD:
            case DESCENDANT:
            case SELF:
            case DESCENDANTORSELF:
            case FOLLOWINGSIBLING:
            case FOLLOWING:
                {
                alt98=1;
                }
                break;
            case ATTRIBUTE:
                {
                switch ( input.LA(2) ) {
                case COLONCOLON:
                    {
                    alt98=1;
                    }
                    break;
                case LPAR:
                    {
                    alt98=2;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 98, 2, input);

                    throw nvae;
                }

                }
                break;
            case NCNAME:
            case AT:
            case STAR:
            case PNAME_NS:
            case PNAME_LN:
            case A:
            case FROM:
            case ELEMENT:
            case TO:
            case ITEM:
            case NODE:
            case DOCUMENTNODE:
            case TEXT:
            case COMMENT:
            case PROCESSINGINSTRUCTION:
            case SCHEMAATTRIBUTE:
            case SCHEMAELEMENT:
            case ROW:
                {
                alt98=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 98, 0, input);

                throw nvae;
            }

            switch (alt98) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1800:5: forwardAxis nodeTest
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_forwardAxis_in_forwardStep8096);
                    forwardAxis318=forwardAxis();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, forwardAxis318.getTree());
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_nodeTest_in_forwardStep8098);
                    nodeTest319=nodeTest();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, nodeTest319.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1801:5: abbrevForwardStep
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_abbrevForwardStep_in_forwardStep8104);
                    abbrevForwardStep320=abbrevForwardStep();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, abbrevForwardStep320.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "forwardStep"

    public static class forwardAxis_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "forwardAxis"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1804:1: forwardAxis : ( CHILD COLONCOLON | DESCENDANT COLONCOLON | ATTRIBUTE COLONCOLON | SELF COLONCOLON | DESCENDANTORSELF COLONCOLON | FOLLOWINGSIBLING COLONCOLON | FOLLOWING COLONCOLON );
    public final XSPARQLRewriter.forwardAxis_return forwardAxis() throws RecognitionException {
        XSPARQLRewriter.forwardAxis_return retval = new XSPARQLRewriter.forwardAxis_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree CHILD321=null;
        CommonTree COLONCOLON322=null;
        CommonTree DESCENDANT323=null;
        CommonTree COLONCOLON324=null;
        CommonTree ATTRIBUTE325=null;
        CommonTree COLONCOLON326=null;
        CommonTree SELF327=null;
        CommonTree COLONCOLON328=null;
        CommonTree DESCENDANTORSELF329=null;
        CommonTree COLONCOLON330=null;
        CommonTree FOLLOWINGSIBLING331=null;
        CommonTree COLONCOLON332=null;
        CommonTree FOLLOWING333=null;
        CommonTree COLONCOLON334=null;

        CommonTree CHILD321_tree=null;
        CommonTree COLONCOLON322_tree=null;
        CommonTree DESCENDANT323_tree=null;
        CommonTree COLONCOLON324_tree=null;
        CommonTree ATTRIBUTE325_tree=null;
        CommonTree COLONCOLON326_tree=null;
        CommonTree SELF327_tree=null;
        CommonTree COLONCOLON328_tree=null;
        CommonTree DESCENDANTORSELF329_tree=null;
        CommonTree COLONCOLON330_tree=null;
        CommonTree FOLLOWINGSIBLING331_tree=null;
        CommonTree COLONCOLON332_tree=null;
        CommonTree FOLLOWING333_tree=null;
        CommonTree COLONCOLON334_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1805:3: ( CHILD COLONCOLON | DESCENDANT COLONCOLON | ATTRIBUTE COLONCOLON | SELF COLONCOLON | DESCENDANTORSELF COLONCOLON | FOLLOWINGSIBLING COLONCOLON | FOLLOWING COLONCOLON )
            int alt99=7;
            switch ( input.LA(1) ) {
            case CHILD:
                {
                alt99=1;
                }
                break;
            case DESCENDANT:
                {
                alt99=2;
                }
                break;
            case ATTRIBUTE:
                {
                alt99=3;
                }
                break;
            case SELF:
                {
                alt99=4;
                }
                break;
            case DESCENDANTORSELF:
                {
                alt99=5;
                }
                break;
            case FOLLOWINGSIBLING:
                {
                alt99=6;
                }
                break;
            case FOLLOWING:
                {
                alt99=7;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 99, 0, input);

                throw nvae;
            }

            switch (alt99) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1805:5: CHILD COLONCOLON
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    CHILD321=(CommonTree)match(input,CHILD,FOLLOW_CHILD_in_forwardAxis8117); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    CHILD321_tree = (CommonTree)adaptor.dupNode(CHILD321);

                    adaptor.addChild(root_0, CHILD321_tree);
                    }
                    _last = (CommonTree)input.LT(1);
                    COLONCOLON322=(CommonTree)match(input,COLONCOLON,FOLLOW_COLONCOLON_in_forwardAxis8119); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    COLONCOLON322_tree = (CommonTree)adaptor.dupNode(COLONCOLON322);

                    adaptor.addChild(root_0, COLONCOLON322_tree);
                    }

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1806:5: DESCENDANT COLONCOLON
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    DESCENDANT323=(CommonTree)match(input,DESCENDANT,FOLLOW_DESCENDANT_in_forwardAxis8125); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    DESCENDANT323_tree = (CommonTree)adaptor.dupNode(DESCENDANT323);

                    adaptor.addChild(root_0, DESCENDANT323_tree);
                    }
                    _last = (CommonTree)input.LT(1);
                    COLONCOLON324=(CommonTree)match(input,COLONCOLON,FOLLOW_COLONCOLON_in_forwardAxis8127); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    COLONCOLON324_tree = (CommonTree)adaptor.dupNode(COLONCOLON324);

                    adaptor.addChild(root_0, COLONCOLON324_tree);
                    }

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 3 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1807:5: ATTRIBUTE COLONCOLON
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    ATTRIBUTE325=(CommonTree)match(input,ATTRIBUTE,FOLLOW_ATTRIBUTE_in_forwardAxis8133); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    ATTRIBUTE325_tree = (CommonTree)adaptor.dupNode(ATTRIBUTE325);

                    adaptor.addChild(root_0, ATTRIBUTE325_tree);
                    }
                    _last = (CommonTree)input.LT(1);
                    COLONCOLON326=(CommonTree)match(input,COLONCOLON,FOLLOW_COLONCOLON_in_forwardAxis8135); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    COLONCOLON326_tree = (CommonTree)adaptor.dupNode(COLONCOLON326);

                    adaptor.addChild(root_0, COLONCOLON326_tree);
                    }

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 4 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1808:5: SELF COLONCOLON
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    SELF327=(CommonTree)match(input,SELF,FOLLOW_SELF_in_forwardAxis8141); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    SELF327_tree = (CommonTree)adaptor.dupNode(SELF327);

                    adaptor.addChild(root_0, SELF327_tree);
                    }
                    _last = (CommonTree)input.LT(1);
                    COLONCOLON328=(CommonTree)match(input,COLONCOLON,FOLLOW_COLONCOLON_in_forwardAxis8143); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    COLONCOLON328_tree = (CommonTree)adaptor.dupNode(COLONCOLON328);

                    adaptor.addChild(root_0, COLONCOLON328_tree);
                    }

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 5 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1809:5: DESCENDANTORSELF COLONCOLON
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    DESCENDANTORSELF329=(CommonTree)match(input,DESCENDANTORSELF,FOLLOW_DESCENDANTORSELF_in_forwardAxis8149); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    DESCENDANTORSELF329_tree = (CommonTree)adaptor.dupNode(DESCENDANTORSELF329);

                    adaptor.addChild(root_0, DESCENDANTORSELF329_tree);
                    }
                    _last = (CommonTree)input.LT(1);
                    COLONCOLON330=(CommonTree)match(input,COLONCOLON,FOLLOW_COLONCOLON_in_forwardAxis8151); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    COLONCOLON330_tree = (CommonTree)adaptor.dupNode(COLONCOLON330);

                    adaptor.addChild(root_0, COLONCOLON330_tree);
                    }

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 6 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1810:5: FOLLOWINGSIBLING COLONCOLON
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    FOLLOWINGSIBLING331=(CommonTree)match(input,FOLLOWINGSIBLING,FOLLOW_FOLLOWINGSIBLING_in_forwardAxis8157); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    FOLLOWINGSIBLING331_tree = (CommonTree)adaptor.dupNode(FOLLOWINGSIBLING331);

                    adaptor.addChild(root_0, FOLLOWINGSIBLING331_tree);
                    }
                    _last = (CommonTree)input.LT(1);
                    COLONCOLON332=(CommonTree)match(input,COLONCOLON,FOLLOW_COLONCOLON_in_forwardAxis8159); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    COLONCOLON332_tree = (CommonTree)adaptor.dupNode(COLONCOLON332);

                    adaptor.addChild(root_0, COLONCOLON332_tree);
                    }

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 7 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1811:5: FOLLOWING COLONCOLON
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    FOLLOWING333=(CommonTree)match(input,FOLLOWING,FOLLOW_FOLLOWING_in_forwardAxis8165); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    FOLLOWING333_tree = (CommonTree)adaptor.dupNode(FOLLOWING333);

                    adaptor.addChild(root_0, FOLLOWING333_tree);
                    }
                    _last = (CommonTree)input.LT(1);
                    COLONCOLON334=(CommonTree)match(input,COLONCOLON,FOLLOW_COLONCOLON_in_forwardAxis8167); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    COLONCOLON334_tree = (CommonTree)adaptor.dupNode(COLONCOLON334);

                    adaptor.addChild(root_0, COLONCOLON334_tree);
                    }

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "forwardAxis"

    public static class abbrevForwardStep_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "abbrevForwardStep"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1814:1: abbrevForwardStep : ( AT )? nodeTest ;
    public final XSPARQLRewriter.abbrevForwardStep_return abbrevForwardStep() throws RecognitionException {
        XSPARQLRewriter.abbrevForwardStep_return retval = new XSPARQLRewriter.abbrevForwardStep_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree AT335=null;
        XSPARQLRewriter.nodeTest_return nodeTest336 = null;


        CommonTree AT335_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1815:3: ( ( AT )? nodeTest )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1815:5: ( AT )? nodeTest
            {
            root_0 = (CommonTree)adaptor.nil();

            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1815:5: ( AT )?
            int alt100=2;
            switch ( input.LA(1) ) {
                case AT:
                    {
                    alt100=1;
                    }
                    break;
            }

            switch (alt100) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: AT
                    {
                    _last = (CommonTree)input.LT(1);
                    AT335=(CommonTree)match(input,AT,FOLLOW_AT_in_abbrevForwardStep8180); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    AT335_tree = (CommonTree)adaptor.dupNode(AT335);

                    adaptor.addChild(root_0, AT335_tree);
                    }

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_nodeTest_in_abbrevForwardStep8183);
            nodeTest336=nodeTest();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_0, nodeTest336.getTree());

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "abbrevForwardStep"

    public static class reverseStep_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "reverseStep"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1818:1: reverseStep : ( reverseAxis nodeTest | abbrevReverseStep );
    public final XSPARQLRewriter.reverseStep_return reverseStep() throws RecognitionException {
        XSPARQLRewriter.reverseStep_return retval = new XSPARQLRewriter.reverseStep_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.reverseAxis_return reverseAxis337 = null;

        XSPARQLRewriter.nodeTest_return nodeTest338 = null;

        XSPARQLRewriter.abbrevReverseStep_return abbrevReverseStep339 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1819:3: ( reverseAxis nodeTest | abbrevReverseStep )
            int alt101=2;
            switch ( input.LA(1) ) {
            case PARENT:
            case ANCESTOR:
            case PRECEDINGSIBLING:
            case PRECEDING:
            case ANCESTORORSELF:
                {
                alt101=1;
                }
                break;
            case DOTDOT:
                {
                alt101=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 101, 0, input);

                throw nvae;
            }

            switch (alt101) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1819:5: reverseAxis nodeTest
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_reverseAxis_in_reverseStep8196);
                    reverseAxis337=reverseAxis();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, reverseAxis337.getTree());
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_nodeTest_in_reverseStep8198);
                    nodeTest338=nodeTest();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, nodeTest338.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1820:5: abbrevReverseStep
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_abbrevReverseStep_in_reverseStep8204);
                    abbrevReverseStep339=abbrevReverseStep();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, abbrevReverseStep339.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "reverseStep"

    public static class reverseAxis_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "reverseAxis"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1823:1: reverseAxis : ( PARENT COLONCOLON | ANCESTOR COLONCOLON | PRECEDINGSIBLING COLONCOLON | PRECEDING COLONCOLON | ANCESTORORSELF COLONCOLON );
    public final XSPARQLRewriter.reverseAxis_return reverseAxis() throws RecognitionException {
        XSPARQLRewriter.reverseAxis_return retval = new XSPARQLRewriter.reverseAxis_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree PARENT340=null;
        CommonTree COLONCOLON341=null;
        CommonTree ANCESTOR342=null;
        CommonTree COLONCOLON343=null;
        CommonTree PRECEDINGSIBLING344=null;
        CommonTree COLONCOLON345=null;
        CommonTree PRECEDING346=null;
        CommonTree COLONCOLON347=null;
        CommonTree ANCESTORORSELF348=null;
        CommonTree COLONCOLON349=null;

        CommonTree PARENT340_tree=null;
        CommonTree COLONCOLON341_tree=null;
        CommonTree ANCESTOR342_tree=null;
        CommonTree COLONCOLON343_tree=null;
        CommonTree PRECEDINGSIBLING344_tree=null;
        CommonTree COLONCOLON345_tree=null;
        CommonTree PRECEDING346_tree=null;
        CommonTree COLONCOLON347_tree=null;
        CommonTree ANCESTORORSELF348_tree=null;
        CommonTree COLONCOLON349_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1824:3: ( PARENT COLONCOLON | ANCESTOR COLONCOLON | PRECEDINGSIBLING COLONCOLON | PRECEDING COLONCOLON | ANCESTORORSELF COLONCOLON )
            int alt102=5;
            switch ( input.LA(1) ) {
            case PARENT:
                {
                alt102=1;
                }
                break;
            case ANCESTOR:
                {
                alt102=2;
                }
                break;
            case PRECEDINGSIBLING:
                {
                alt102=3;
                }
                break;
            case PRECEDING:
                {
                alt102=4;
                }
                break;
            case ANCESTORORSELF:
                {
                alt102=5;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 102, 0, input);

                throw nvae;
            }

            switch (alt102) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1824:5: PARENT COLONCOLON
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    PARENT340=(CommonTree)match(input,PARENT,FOLLOW_PARENT_in_reverseAxis8217); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    PARENT340_tree = (CommonTree)adaptor.dupNode(PARENT340);

                    adaptor.addChild(root_0, PARENT340_tree);
                    }
                    _last = (CommonTree)input.LT(1);
                    COLONCOLON341=(CommonTree)match(input,COLONCOLON,FOLLOW_COLONCOLON_in_reverseAxis8219); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    COLONCOLON341_tree = (CommonTree)adaptor.dupNode(COLONCOLON341);

                    adaptor.addChild(root_0, COLONCOLON341_tree);
                    }

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1825:5: ANCESTOR COLONCOLON
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    ANCESTOR342=(CommonTree)match(input,ANCESTOR,FOLLOW_ANCESTOR_in_reverseAxis8225); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    ANCESTOR342_tree = (CommonTree)adaptor.dupNode(ANCESTOR342);

                    adaptor.addChild(root_0, ANCESTOR342_tree);
                    }
                    _last = (CommonTree)input.LT(1);
                    COLONCOLON343=(CommonTree)match(input,COLONCOLON,FOLLOW_COLONCOLON_in_reverseAxis8227); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    COLONCOLON343_tree = (CommonTree)adaptor.dupNode(COLONCOLON343);

                    adaptor.addChild(root_0, COLONCOLON343_tree);
                    }

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 3 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1826:5: PRECEDINGSIBLING COLONCOLON
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    PRECEDINGSIBLING344=(CommonTree)match(input,PRECEDINGSIBLING,FOLLOW_PRECEDINGSIBLING_in_reverseAxis8233); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    PRECEDINGSIBLING344_tree = (CommonTree)adaptor.dupNode(PRECEDINGSIBLING344);

                    adaptor.addChild(root_0, PRECEDINGSIBLING344_tree);
                    }
                    _last = (CommonTree)input.LT(1);
                    COLONCOLON345=(CommonTree)match(input,COLONCOLON,FOLLOW_COLONCOLON_in_reverseAxis8235); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    COLONCOLON345_tree = (CommonTree)adaptor.dupNode(COLONCOLON345);

                    adaptor.addChild(root_0, COLONCOLON345_tree);
                    }

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 4 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1827:5: PRECEDING COLONCOLON
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    PRECEDING346=(CommonTree)match(input,PRECEDING,FOLLOW_PRECEDING_in_reverseAxis8241); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    PRECEDING346_tree = (CommonTree)adaptor.dupNode(PRECEDING346);

                    adaptor.addChild(root_0, PRECEDING346_tree);
                    }
                    _last = (CommonTree)input.LT(1);
                    COLONCOLON347=(CommonTree)match(input,COLONCOLON,FOLLOW_COLONCOLON_in_reverseAxis8243); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    COLONCOLON347_tree = (CommonTree)adaptor.dupNode(COLONCOLON347);

                    adaptor.addChild(root_0, COLONCOLON347_tree);
                    }

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 5 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1828:5: ANCESTORORSELF COLONCOLON
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    ANCESTORORSELF348=(CommonTree)match(input,ANCESTORORSELF,FOLLOW_ANCESTORORSELF_in_reverseAxis8249); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    ANCESTORORSELF348_tree = (CommonTree)adaptor.dupNode(ANCESTORORSELF348);

                    adaptor.addChild(root_0, ANCESTORORSELF348_tree);
                    }
                    _last = (CommonTree)input.LT(1);
                    COLONCOLON349=(CommonTree)match(input,COLONCOLON,FOLLOW_COLONCOLON_in_reverseAxis8251); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    COLONCOLON349_tree = (CommonTree)adaptor.dupNode(COLONCOLON349);

                    adaptor.addChild(root_0, COLONCOLON349_tree);
                    }

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "reverseAxis"

    public static class abbrevReverseStep_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "abbrevReverseStep"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1831:1: abbrevReverseStep : DOTDOT ;
    public final XSPARQLRewriter.abbrevReverseStep_return abbrevReverseStep() throws RecognitionException {
        XSPARQLRewriter.abbrevReverseStep_return retval = new XSPARQLRewriter.abbrevReverseStep_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree DOTDOT350=null;

        CommonTree DOTDOT350_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1832:3: ( DOTDOT )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1832:5: DOTDOT
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            DOTDOT350=(CommonTree)match(input,DOTDOT,FOLLOW_DOTDOT_in_abbrevReverseStep8264); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            DOTDOT350_tree = (CommonTree)adaptor.dupNode(DOTDOT350);

            adaptor.addChild(root_0, DOTDOT350_tree);
            }

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "abbrevReverseStep"

    public static class nodeTest_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "nodeTest"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1835:1: nodeTest : ( kindTest | nameTest );
    public final XSPARQLRewriter.nodeTest_return nodeTest() throws RecognitionException {
        XSPARQLRewriter.nodeTest_return retval = new XSPARQLRewriter.nodeTest_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.kindTest_return kindTest351 = null;

        XSPARQLRewriter.nameTest_return nameTest352 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1836:3: ( kindTest | nameTest )
            int alt103=2;
            switch ( input.LA(1) ) {
            case ATTRIBUTE:
            case ELEMENT:
            case DOCUMENTNODE:
            case TEXT:
            case PROCESSINGINSTRUCTION:
            case SCHEMAATTRIBUTE:
            case SCHEMAELEMENT:
                {
                alt103=1;
                }
                break;
            case COMMENT:
                {
                switch ( input.LA(2) ) {
                case LPAR:
                    {
                    alt103=1;
                    }
                    break;
                case EOF:
                case UP:
                case SLASH:
                case LBRACKET:
                    {
                    alt103=2;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 103, 2, input);

                    throw nvae;
                }

                }
                break;
            case NODE:
                {
                switch ( input.LA(2) ) {
                case LPAR:
                    {
                    alt103=1;
                    }
                    break;
                case EOF:
                case UP:
                case SLASH:
                case LBRACKET:
                    {
                    alt103=2;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 103, 3, input);

                    throw nvae;
                }

                }
                break;
            case NCNAME:
            case STAR:
            case PNAME_NS:
            case PNAME_LN:
            case A:
            case FROM:
            case TO:
            case ITEM:
            case ROW:
                {
                alt103=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 103, 0, input);

                throw nvae;
            }

            switch (alt103) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1836:5: kindTest
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_kindTest_in_nodeTest8277);
                    kindTest351=kindTest();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, kindTest351.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1837:5: nameTest
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_nameTest_in_nodeTest8283);
                    nameTest352=nameTest();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, nameTest352.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "nodeTest"

    public static class nameTest_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "nameTest"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1840:1: nameTest : ( qname | wildCard );
    public final XSPARQLRewriter.nameTest_return nameTest() throws RecognitionException {
        XSPARQLRewriter.nameTest_return retval = new XSPARQLRewriter.nameTest_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.qname_return qname353 = null;

        XSPARQLRewriter.wildCard_return wildCard354 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1841:3: ( qname | wildCard )
            int alt104=2;
            switch ( input.LA(1) ) {
            case PNAME_NS:
            case PNAME_LN:
            case A:
            case FROM:
            case TO:
            case ITEM:
            case NODE:
            case COMMENT:
            case ROW:
                {
                alt104=1;
                }
                break;
            case NCNAME:
                {
                switch ( input.LA(2) ) {
                case COLON:
                    {
                    alt104=2;
                    }
                    break;
                case EOF:
                case UP:
                case SLASH:
                case LBRACKET:
                    {
                    alt104=1;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 104, 2, input);

                    throw nvae;
                }

                }
                break;
            case STAR:
                {
                alt104=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 104, 0, input);

                throw nvae;
            }

            switch (alt104) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1841:5: qname
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_qname_in_nameTest8296);
                    qname353=qname();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, qname353.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1842:5: wildCard
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_wildCard_in_nameTest8302);
                    wildCard354=wildCard();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, wildCard354.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "nameTest"

    public static class wildCard_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "wildCard"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1845:1: wildCard : ( STAR | STAR COLON NCNAME | NCNAME COLON STAR );
    public final XSPARQLRewriter.wildCard_return wildCard() throws RecognitionException {
        XSPARQLRewriter.wildCard_return retval = new XSPARQLRewriter.wildCard_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree STAR355=null;
        CommonTree STAR356=null;
        CommonTree COLON357=null;
        CommonTree NCNAME358=null;
        CommonTree NCNAME359=null;
        CommonTree COLON360=null;
        CommonTree STAR361=null;

        CommonTree STAR355_tree=null;
        CommonTree STAR356_tree=null;
        CommonTree COLON357_tree=null;
        CommonTree NCNAME358_tree=null;
        CommonTree NCNAME359_tree=null;
        CommonTree COLON360_tree=null;
        CommonTree STAR361_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1846:3: ( STAR | STAR COLON NCNAME | NCNAME COLON STAR )
            int alt105=3;
            switch ( input.LA(1) ) {
            case STAR:
                {
                switch ( input.LA(2) ) {
                case COLON:
                    {
                    alt105=2;
                    }
                    break;
                case EOF:
                case UP:
                case SLASH:
                case LBRACKET:
                    {
                    alt105=1;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 105, 1, input);

                    throw nvae;
                }

                }
                break;
            case NCNAME:
                {
                alt105=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 105, 0, input);

                throw nvae;
            }

            switch (alt105) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1846:5: STAR
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    STAR355=(CommonTree)match(input,STAR,FOLLOW_STAR_in_wildCard8315); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    STAR355_tree = (CommonTree)adaptor.dupNode(STAR355);

                    adaptor.addChild(root_0, STAR355_tree);
                    }

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1847:5: STAR COLON NCNAME
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    STAR356=(CommonTree)match(input,STAR,FOLLOW_STAR_in_wildCard8321); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    STAR356_tree = (CommonTree)adaptor.dupNode(STAR356);

                    adaptor.addChild(root_0, STAR356_tree);
                    }
                    _last = (CommonTree)input.LT(1);
                    COLON357=(CommonTree)match(input,COLON,FOLLOW_COLON_in_wildCard8323); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    COLON357_tree = (CommonTree)adaptor.dupNode(COLON357);

                    adaptor.addChild(root_0, COLON357_tree);
                    }
                    _last = (CommonTree)input.LT(1);
                    NCNAME358=(CommonTree)match(input,NCNAME,FOLLOW_NCNAME_in_wildCard8325); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    NCNAME358_tree = (CommonTree)adaptor.dupNode(NCNAME358);

                    adaptor.addChild(root_0, NCNAME358_tree);
                    }

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 3 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1848:5: NCNAME COLON STAR
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    NCNAME359=(CommonTree)match(input,NCNAME,FOLLOW_NCNAME_in_wildCard8331); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    NCNAME359_tree = (CommonTree)adaptor.dupNode(NCNAME359);

                    adaptor.addChild(root_0, NCNAME359_tree);
                    }
                    _last = (CommonTree)input.LT(1);
                    COLON360=(CommonTree)match(input,COLON,FOLLOW_COLON_in_wildCard8333); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    COLON360_tree = (CommonTree)adaptor.dupNode(COLON360);

                    adaptor.addChild(root_0, COLON360_tree);
                    }
                    _last = (CommonTree)input.LT(1);
                    STAR361=(CommonTree)match(input,STAR,FOLLOW_STAR_in_wildCard8335); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    STAR361_tree = (CommonTree)adaptor.dupNode(STAR361);

                    adaptor.addChild(root_0, STAR361_tree);
                    }

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "wildCard"

    public static class filterExpr_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "filterExpr"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1851:1: filterExpr : primaryExpr predicateList ;
    public final XSPARQLRewriter.filterExpr_return filterExpr() throws RecognitionException {
        XSPARQLRewriter.filterExpr_return retval = new XSPARQLRewriter.filterExpr_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.primaryExpr_return primaryExpr362 = null;

        XSPARQLRewriter.predicateList_return predicateList363 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1852:3: ( primaryExpr predicateList )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1852:5: primaryExpr predicateList
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_primaryExpr_in_filterExpr8348);
            primaryExpr362=primaryExpr();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_0, primaryExpr362.getTree());
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_predicateList_in_filterExpr8350);
            predicateList363=predicateList();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_0, predicateList363.getTree());

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "filterExpr"

    public static class predicateList_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "predicateList"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1855:1: predicateList : ( predicate )* ;
    public final XSPARQLRewriter.predicateList_return predicateList() throws RecognitionException {
        XSPARQLRewriter.predicateList_return retval = new XSPARQLRewriter.predicateList_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.predicate_return predicate364 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1856:3: ( ( predicate )* )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1856:5: ( predicate )*
            {
            root_0 = (CommonTree)adaptor.nil();

            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1856:5: ( predicate )*
            loop106:
            do {
                int alt106=2;
                switch ( input.LA(1) ) {
                case LBRACKET:
                    {
                    alt106=1;
                    }
                    break;

                }

                switch (alt106) {
            	case 1 :
            	    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: predicate
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_predicate_in_predicateList8363);
            	    predicate364=predicate();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) 
            	    adaptor.addChild(root_0, predicate364.getTree());

            	    if ( state.backtracking==0 ) {
            	    }
            	    }
            	    break;

            	default :
            	    break loop106;
                }
            } while (true);


            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "predicateList"

    public static class predicate_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "predicate"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1859:1: predicate : LBRACKET expr RBRACKET ;
    public final XSPARQLRewriter.predicate_return predicate() throws RecognitionException {
        XSPARQLRewriter.predicate_return retval = new XSPARQLRewriter.predicate_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree LBRACKET365=null;
        CommonTree RBRACKET367=null;
        XSPARQLRewriter.expr_return expr366 = null;


        CommonTree LBRACKET365_tree=null;
        CommonTree RBRACKET367_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1860:3: ( LBRACKET expr RBRACKET )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1860:5: LBRACKET expr RBRACKET
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            LBRACKET365=(CommonTree)match(input,LBRACKET,FOLLOW_LBRACKET_in_predicate8377); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            LBRACKET365_tree = (CommonTree)adaptor.dupNode(LBRACKET365);

            adaptor.addChild(root_0, LBRACKET365_tree);
            }
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_expr_in_predicate8379);
            expr366=expr();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_0, expr366.getTree());
            _last = (CommonTree)input.LT(1);
            RBRACKET367=(CommonTree)match(input,RBRACKET,FOLLOW_RBRACKET_in_predicate8381); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            RBRACKET367_tree = (CommonTree)adaptor.dupNode(RBRACKET367);

            adaptor.addChild(root_0, RBRACKET367_tree);
            }

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "predicate"

    public static class primaryExpr_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "primaryExpr"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1863:1: primaryExpr : ( varRef | literal | parenthesizedExpr | contextItemExpr | functionCall | orderedExpr | unorderedExpr | constructor );
    public final XSPARQLRewriter.primaryExpr_return primaryExpr() throws RecognitionException {
        XSPARQLRewriter.primaryExpr_return retval = new XSPARQLRewriter.primaryExpr_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.varRef_return varRef368 = null;

        XSPARQLRewriter.literal_return literal369 = null;

        XSPARQLRewriter.parenthesizedExpr_return parenthesizedExpr370 = null;

        XSPARQLRewriter.contextItemExpr_return contextItemExpr371 = null;

        XSPARQLRewriter.functionCall_return functionCall372 = null;

        XSPARQLRewriter.orderedExpr_return orderedExpr373 = null;

        XSPARQLRewriter.unorderedExpr_return unorderedExpr374 = null;

        XSPARQLRewriter.constructor_return constructor375 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1864:3: ( varRef | literal | parenthesizedExpr | contextItemExpr | functionCall | orderedExpr | unorderedExpr | constructor )
            int alt107=8;
            switch ( input.LA(1) ) {
            case VAR:
                {
                alt107=1;
                }
                break;
            case INTEGER:
            case QSTRING:
            case DECIMAL:
                {
                alt107=2;
                }
                break;
            case T_PAR:
                {
                alt107=3;
                }
                break;
            case DOT:
                {
                alt107=4;
                }
                break;
            case T_FUNCTION_CALL:
                {
                alt107=5;
                }
                break;
            case ORDERED:
                {
                alt107=6;
                }
                break;
            case UNORDERED:
                {
                alt107=7;
                }
                break;
            case ATTRIBUTE:
            case ELEMENT:
            case TEXT:
            case COMMENT:
            case PROCESSINGINSTRUCTION:
            case DOCUMENT:
            case T_XML_ELEMENT:
                {
                alt107=8;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 107, 0, input);

                throw nvae;
            }

            switch (alt107) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1864:5: varRef
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_varRef_in_primaryExpr8394);
                    varRef368=varRef();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, varRef368.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1865:5: literal
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_literal_in_primaryExpr8400);
                    literal369=literal();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, literal369.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 3 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1866:5: parenthesizedExpr
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_parenthesizedExpr_in_primaryExpr8406);
                    parenthesizedExpr370=parenthesizedExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, parenthesizedExpr370.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 4 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1867:5: contextItemExpr
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_contextItemExpr_in_primaryExpr8412);
                    contextItemExpr371=contextItemExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, contextItemExpr371.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 5 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1868:5: functionCall
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_functionCall_in_primaryExpr8418);
                    functionCall372=functionCall();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, functionCall372.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 6 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1869:5: orderedExpr
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_orderedExpr_in_primaryExpr8424);
                    orderedExpr373=orderedExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, orderedExpr373.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 7 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1870:5: unorderedExpr
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_unorderedExpr_in_primaryExpr8430);
                    unorderedExpr374=unorderedExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, unorderedExpr374.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 8 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1871:5: constructor
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_constructor_in_primaryExpr8436);
                    constructor375=constructor();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, constructor375.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "primaryExpr"

    public static class literal_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "literal"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1874:1: literal : ( numericliteral | stringliteral );
    public final XSPARQLRewriter.literal_return literal() throws RecognitionException {
        XSPARQLRewriter.literal_return retval = new XSPARQLRewriter.literal_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.numericliteral_return numericliteral376 = null;

        XSPARQLRewriter.stringliteral_return stringliteral377 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1875:3: ( numericliteral | stringliteral )
            int alt108=2;
            switch ( input.LA(1) ) {
            case INTEGER:
            case DECIMAL:
                {
                alt108=1;
                }
                break;
            case QSTRING:
                {
                alt108=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 108, 0, input);

                throw nvae;
            }

            switch (alt108) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1875:5: numericliteral
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numericliteral_in_literal8449);
                    numericliteral376=numericliteral();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, numericliteral376.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1876:5: stringliteral
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_stringliteral_in_literal8455);
                    stringliteral377=stringliteral();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, stringliteral377.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "literal"

    public static class numericliteral_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "numericliteral"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1879:1: numericliteral : ( integerLiteral | decimalLiteral );
    public final XSPARQLRewriter.numericliteral_return numericliteral() throws RecognitionException {
        XSPARQLRewriter.numericliteral_return retval = new XSPARQLRewriter.numericliteral_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.integerLiteral_return integerLiteral378 = null;

        XSPARQLRewriter.decimalLiteral_return decimalLiteral379 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1880:3: ( integerLiteral | decimalLiteral )
            int alt109=2;
            switch ( input.LA(1) ) {
            case INTEGER:
                {
                alt109=1;
                }
                break;
            case DECIMAL:
                {
                alt109=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 109, 0, input);

                throw nvae;
            }

            switch (alt109) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1880:5: integerLiteral
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_integerLiteral_in_numericliteral8468);
                    integerLiteral378=integerLiteral();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, integerLiteral378.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1881:5: decimalLiteral
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_decimalLiteral_in_numericliteral8474);
                    decimalLiteral379=decimalLiteral();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, decimalLiteral379.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "numericliteral"

    public static class varRef_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "varRef"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1885:1: varRef : v= VAR -> { isBound($v.text, Types.SPARQL) || $relativePathExpr::rdbVar }? ^( T_FUNCTION_CALL NCNAME[\"_xsparql:_typeData\"] ^( T_PARAMS $v) ) -> $v;
    public final XSPARQLRewriter.varRef_return varRef() throws RecognitionException {
        XSPARQLRewriter.varRef_return retval = new XSPARQLRewriter.varRef_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree v=null;

        CommonTree v_tree=null;
        RewriteRuleNodeStream stream_VAR=new RewriteRuleNodeStream(adaptor,"token VAR");

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1886:3: (v= VAR -> { isBound($v.text, Types.SPARQL) || $relativePathExpr::rdbVar }? ^( T_FUNCTION_CALL NCNAME[\"_xsparql:_typeData\"] ^( T_PARAMS $v) ) -> $v)
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1886:5: v= VAR
            {
            _last = (CommonTree)input.LT(1);
            v=(CommonTree)match(input,VAR,FOLLOW_VAR_in_varRef8493); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_VAR.add(v);

            if ( state.backtracking==0 ) {
               ((relativePathExpr_scope)relativePathExpr_stack.peek()).rdbVar = isBound((v!=null?v.getText():null), Types.SQL); 
            }


            // AST REWRITE
            // elements: v, v
            // token labels: v
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {
            retval.tree = root_0;
            RewriteRuleNodeStream stream_v=new RewriteRuleNodeStream(adaptor,"token v",v);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1887:5: -> { isBound($v.text, Types.SPARQL) || $relativePathExpr::rdbVar }? ^( T_FUNCTION_CALL NCNAME[\"_xsparql:_typeData\"] ^( T_PARAMS $v) )
            if ( isBound((v!=null?v.getText():null), Types.SPARQL) || ((relativePathExpr_scope)relativePathExpr_stack.peek()).rdbVar ) {
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1887:73: ^( T_FUNCTION_CALL NCNAME[\"_xsparql:_typeData\"] ^( T_PARAMS $v) )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FUNCTION_CALL, "T_FUNCTION_CALL"), root_1);

                adaptor.addChild(root_1, (CommonTree)adaptor.create(NCNAME, "_xsparql:_typeData"));
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1887:120: ^( T_PARAMS $v)
                {
                CommonTree root_2 = (CommonTree)adaptor.nil();
                root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_PARAMS, "T_PARAMS"), root_2);

                adaptor.addChild(root_2, stream_v.nextNode());

                adaptor.addChild(root_1, root_2);
                }

                adaptor.addChild(root_0, root_1);
                }

            }
            else // 1888:5: -> $v
            {
                adaptor.addChild(root_0, stream_v.nextNode());

            }

            retval.tree = root_0;}
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "varRef"

    public static class varName_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "varName"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1891:1: varName : qname ;
    public final XSPARQLRewriter.varName_return varName() throws RecognitionException {
        XSPARQLRewriter.varName_return retval = new XSPARQLRewriter.varName_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.qname_return qname380 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1892:3: ( qname )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1892:5: qname
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_qname_in_varName8540);
            qname380=qname();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_0, qname380.getTree());

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "varName"

    public static class parenthesizedExpr_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "parenthesizedExpr"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1895:1: parenthesizedExpr : ^( T_PAR ( expr )? ) ;
    public final XSPARQLRewriter.parenthesizedExpr_return parenthesizedExpr() throws RecognitionException {
        XSPARQLRewriter.parenthesizedExpr_return retval = new XSPARQLRewriter.parenthesizedExpr_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree T_PAR381=null;
        XSPARQLRewriter.expr_return expr382 = null;


        CommonTree T_PAR381_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1896:3: ( ^( T_PAR ( expr )? ) )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1896:5: ^( T_PAR ( expr )? )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            T_PAR381=(CommonTree)match(input,T_PAR,FOLLOW_T_PAR_in_parenthesizedExpr8554); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            T_PAR381_tree = (CommonTree)adaptor.dupNode(T_PAR381);

            root_1 = (CommonTree)adaptor.becomeRoot(T_PAR381_tree, root_1);
            }


            if ( input.LA(1)==Token.DOWN ) {
                match(input, Token.DOWN, null); if (state.failed) return retval;
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1896:13: ( expr )?
                int alt110=2;
                switch ( input.LA(1) ) {
                    case LCURLY:
                    case STAR:
                    case LESSTHAN:
                    case GREATERTHAN:
                    case PLUS:
                    case MINUS:
                    case UNIONSYMBOL:
                    case LESSTHANLESSTHAN:
                    case GREATERTHANEQUALS:
                    case LESSTHANEQUALS:
                    case HAFENEQUALS:
                    case EQUALS:
                    case IS:
                    case EQ:
                    case NE:
                    case LT:
                    case GE:
                    case LE:
                    case GT:
                    case IF:
                    case AND:
                    case OR:
                    case TO:
                    case DIV:
                    case IDIV:
                    case MOD:
                    case UNION:
                    case INTERSECT:
                    case EXCEPT:
                    case GREATERTHANGREATERTHAN:
                    case T_FLWOR:
                    case T_INSTANCEOF:
                    case T_CASTAS:
                    case T_CASTABLEAS:
                    case T_TREATAS:
                    case EVERY:
                    case TYPESWITCH:
                    case VALIDATE:
                    case SOME:
                    case XPATH:
                        {
                        alt110=1;
                        }
                        break;
                }

                switch (alt110) {
                    case 1 :
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: expr
                        {
                        _last = (CommonTree)input.LT(1);
                        pushFollow(FOLLOW_expr_in_parenthesizedExpr8556);
                        expr382=expr();

                        state._fsp--;
                        if (state.failed) return retval;
                        if ( state.backtracking==0 ) 
                        adaptor.addChild(root_1, expr382.getTree());

                        if ( state.backtracking==0 ) {
                        }
                        }
                        break;

                }


                match(input, Token.UP, null); if (state.failed) return retval;
            }adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "parenthesizedExpr"

    public static class contextItemExpr_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "contextItemExpr"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1899:1: contextItemExpr : DOT ;
    public final XSPARQLRewriter.contextItemExpr_return contextItemExpr() throws RecognitionException {
        XSPARQLRewriter.contextItemExpr_return retval = new XSPARQLRewriter.contextItemExpr_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree DOT383=null;

        CommonTree DOT383_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1900:3: ( DOT )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1900:5: DOT
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            DOT383=(CommonTree)match(input,DOT,FOLLOW_DOT_in_contextItemExpr8571); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            DOT383_tree = (CommonTree)adaptor.dupNode(DOT383);

            adaptor.addChild(root_0, DOT383_tree);
            }

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "contextItemExpr"

    public static class orderedExpr_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "orderedExpr"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1903:1: orderedExpr : ORDERED expr ;
    public final XSPARQLRewriter.orderedExpr_return orderedExpr() throws RecognitionException {
        XSPARQLRewriter.orderedExpr_return retval = new XSPARQLRewriter.orderedExpr_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree ORDERED384=null;
        XSPARQLRewriter.expr_return expr385 = null;


        CommonTree ORDERED384_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1904:3: ( ORDERED expr )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1904:5: ORDERED expr
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            ORDERED384=(CommonTree)match(input,ORDERED,FOLLOW_ORDERED_in_orderedExpr8584); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            ORDERED384_tree = (CommonTree)adaptor.dupNode(ORDERED384);

            adaptor.addChild(root_0, ORDERED384_tree);
            }
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_expr_in_orderedExpr8586);
            expr385=expr();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_0, expr385.getTree());

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "orderedExpr"

    public static class unorderedExpr_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "unorderedExpr"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1907:1: unorderedExpr : UNORDERED expr ;
    public final XSPARQLRewriter.unorderedExpr_return unorderedExpr() throws RecognitionException {
        XSPARQLRewriter.unorderedExpr_return retval = new XSPARQLRewriter.unorderedExpr_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree UNORDERED386=null;
        XSPARQLRewriter.expr_return expr387 = null;


        CommonTree UNORDERED386_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1908:3: ( UNORDERED expr )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1908:5: UNORDERED expr
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            UNORDERED386=(CommonTree)match(input,UNORDERED,FOLLOW_UNORDERED_in_unorderedExpr8599); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            UNORDERED386_tree = (CommonTree)adaptor.dupNode(UNORDERED386);

            adaptor.addChild(root_0, UNORDERED386_tree);
            }
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_expr_in_unorderedExpr8601);
            expr387=expr();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_0, expr387.getTree());

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "unorderedExpr"

    public static class functionCall_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "functionCall"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1911:1: functionCall : ( ^( T_FUNCTION_CALL qname ^( T_PARAMS ( exprSingle )* ) ) | ^( T_FUNCTION_CALL (c= COUNT | c= SUM | c= MIN | c= MAX | c= AVG | c= SAMPLE | c= GROUP_CONCAT | c= NOTKW | c= EXISTS ) ^( T_PARAMS ( exprSingle )* ) ) -> ^( T_FUNCTION_CALL NCNAME[$c.token, $c.text] ^( T_PARAMS ( exprSingle )* ) ) );
    public final XSPARQLRewriter.functionCall_return functionCall() throws RecognitionException {
        XSPARQLRewriter.functionCall_return retval = new XSPARQLRewriter.functionCall_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree c=null;
        CommonTree T_FUNCTION_CALL388=null;
        CommonTree T_PARAMS390=null;
        CommonTree T_FUNCTION_CALL392=null;
        CommonTree T_PARAMS393=null;
        XSPARQLRewriter.qname_return qname389 = null;

        XSPARQLRewriter.exprSingle_return exprSingle391 = null;

        XSPARQLRewriter.exprSingle_return exprSingle394 = null;


        CommonTree c_tree=null;
        CommonTree T_FUNCTION_CALL388_tree=null;
        CommonTree T_PARAMS390_tree=null;
        CommonTree T_FUNCTION_CALL392_tree=null;
        CommonTree T_PARAMS393_tree=null;
        RewriteRuleNodeStream stream_SAMPLE=new RewriteRuleNodeStream(adaptor,"token SAMPLE");
        RewriteRuleNodeStream stream_T_PARAMS=new RewriteRuleNodeStream(adaptor,"token T_PARAMS");
        RewriteRuleNodeStream stream_AVG=new RewriteRuleNodeStream(adaptor,"token AVG");
        RewriteRuleNodeStream stream_MIN=new RewriteRuleNodeStream(adaptor,"token MIN");
        RewriteRuleNodeStream stream_T_FUNCTION_CALL=new RewriteRuleNodeStream(adaptor,"token T_FUNCTION_CALL");
        RewriteRuleNodeStream stream_EXISTS=new RewriteRuleNodeStream(adaptor,"token EXISTS");
        RewriteRuleNodeStream stream_MAX=new RewriteRuleNodeStream(adaptor,"token MAX");
        RewriteRuleNodeStream stream_COUNT=new RewriteRuleNodeStream(adaptor,"token COUNT");
        RewriteRuleNodeStream stream_SUM=new RewriteRuleNodeStream(adaptor,"token SUM");
        RewriteRuleNodeStream stream_GROUP_CONCAT=new RewriteRuleNodeStream(adaptor,"token GROUP_CONCAT");
        RewriteRuleNodeStream stream_NOTKW=new RewriteRuleNodeStream(adaptor,"token NOTKW");
        RewriteRuleSubtreeStream stream_exprSingle=new RewriteRuleSubtreeStream(adaptor,"rule exprSingle");
        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1912:3: ( ^( T_FUNCTION_CALL qname ^( T_PARAMS ( exprSingle )* ) ) | ^( T_FUNCTION_CALL (c= COUNT | c= SUM | c= MIN | c= MAX | c= AVG | c= SAMPLE | c= GROUP_CONCAT | c= NOTKW | c= EXISTS ) ^( T_PARAMS ( exprSingle )* ) ) -> ^( T_FUNCTION_CALL NCNAME[$c.token, $c.text] ^( T_PARAMS ( exprSingle )* ) ) )
            int alt114=2;
            switch ( input.LA(1) ) {
            case T_FUNCTION_CALL:
                {
                switch ( input.LA(2) ) {
                case DOWN:
                    {
                    switch ( input.LA(3) ) {
                    case COUNT:
                    case AVG:
                    case MAX:
                    case MIN:
                    case SUM:
                    case SAMPLE:
                    case GROUP_CONCAT:
                    case EXISTS:
                    case NOTKW:
                        {
                        alt114=2;
                        }
                        break;
                    case NCNAME:
                    case PNAME_NS:
                    case PNAME_LN:
                    case A:
                    case FROM:
                    case TO:
                    case ITEM:
                    case NODE:
                    case COMMENT:
                    case ROW:
                        {
                        alt114=1;
                        }
                        break;
                    default:
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 114, 2, input);

                        throw nvae;
                    }

                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 114, 1, input);

                    throw nvae;
                }

                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 114, 0, input);

                throw nvae;
            }

            switch (alt114) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1912:5: ^( T_FUNCTION_CALL qname ^( T_PARAMS ( exprSingle )* ) )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    T_FUNCTION_CALL388=(CommonTree)match(input,T_FUNCTION_CALL,FOLLOW_T_FUNCTION_CALL_in_functionCall8615); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    T_FUNCTION_CALL388_tree = (CommonTree)adaptor.dupNode(T_FUNCTION_CALL388);

                    root_1 = (CommonTree)adaptor.becomeRoot(T_FUNCTION_CALL388_tree, root_1);
                    }


                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_qname_in_functionCall8617);
                    qname389=qname();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_1, qname389.getTree());
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_2 = _last;
                    CommonTree _first_2 = null;
                    CommonTree root_2 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    T_PARAMS390=(CommonTree)match(input,T_PARAMS,FOLLOW_T_PARAMS_in_functionCall8620); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    T_PARAMS390_tree = (CommonTree)adaptor.dupNode(T_PARAMS390);

                    root_2 = (CommonTree)adaptor.becomeRoot(T_PARAMS390_tree, root_2);
                    }


                    if ( input.LA(1)==Token.DOWN ) {
                        match(input, Token.DOWN, null); if (state.failed) return retval;
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1912:40: ( exprSingle )*
                        loop111:
                        do {
                            int alt111=2;
                            switch ( input.LA(1) ) {
                            case LCURLY:
                            case STAR:
                            case LESSTHAN:
                            case GREATERTHAN:
                            case PLUS:
                            case MINUS:
                            case UNIONSYMBOL:
                            case LESSTHANLESSTHAN:
                            case GREATERTHANEQUALS:
                            case LESSTHANEQUALS:
                            case HAFENEQUALS:
                            case EQUALS:
                            case IS:
                            case EQ:
                            case NE:
                            case LT:
                            case GE:
                            case LE:
                            case GT:
                            case IF:
                            case AND:
                            case OR:
                            case TO:
                            case DIV:
                            case IDIV:
                            case MOD:
                            case UNION:
                            case INTERSECT:
                            case EXCEPT:
                            case GREATERTHANGREATERTHAN:
                            case T_FLWOR:
                            case T_INSTANCEOF:
                            case T_CASTAS:
                            case T_CASTABLEAS:
                            case T_TREATAS:
                            case EVERY:
                            case TYPESWITCH:
                            case VALIDATE:
                            case SOME:
                            case XPATH:
                                {
                                alt111=1;
                                }
                                break;

                            }

                            switch (alt111) {
                        	case 1 :
                        	    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: exprSingle
                        	    {
                        	    _last = (CommonTree)input.LT(1);
                        	    pushFollow(FOLLOW_exprSingle_in_functionCall8622);
                        	    exprSingle391=exprSingle();

                        	    state._fsp--;
                        	    if (state.failed) return retval;
                        	    if ( state.backtracking==0 ) 
                        	    adaptor.addChild(root_2, exprSingle391.getTree());

                        	    if ( state.backtracking==0 ) {
                        	    }
                        	    }
                        	    break;

                        	default :
                        	    break loop111;
                            }
                        } while (true);


                        match(input, Token.UP, null); if (state.failed) return retval;
                    }adaptor.addChild(root_1, root_2);_last = _save_last_2;
                    }


                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1913:5: ^( T_FUNCTION_CALL (c= COUNT | c= SUM | c= MIN | c= MAX | c= AVG | c= SAMPLE | c= GROUP_CONCAT | c= NOTKW | c= EXISTS ) ^( T_PARAMS ( exprSingle )* ) )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    T_FUNCTION_CALL392=(CommonTree)match(input,T_FUNCTION_CALL,FOLLOW_T_FUNCTION_CALL_in_functionCall8632); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_T_FUNCTION_CALL.add(T_FUNCTION_CALL392);



                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1913:23: (c= COUNT | c= SUM | c= MIN | c= MAX | c= AVG | c= SAMPLE | c= GROUP_CONCAT | c= NOTKW | c= EXISTS )
                    int alt112=9;
                    switch ( input.LA(1) ) {
                    case COUNT:
                        {
                        alt112=1;
                        }
                        break;
                    case SUM:
                        {
                        alt112=2;
                        }
                        break;
                    case MIN:
                        {
                        alt112=3;
                        }
                        break;
                    case MAX:
                        {
                        alt112=4;
                        }
                        break;
                    case AVG:
                        {
                        alt112=5;
                        }
                        break;
                    case SAMPLE:
                        {
                        alt112=6;
                        }
                        break;
                    case GROUP_CONCAT:
                        {
                        alt112=7;
                        }
                        break;
                    case NOTKW:
                        {
                        alt112=8;
                        }
                        break;
                    case EXISTS:
                        {
                        alt112=9;
                        }
                        break;
                    default:
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 112, 0, input);

                        throw nvae;
                    }

                    switch (alt112) {
                        case 1 :
                            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1913:24: c= COUNT
                            {
                            _last = (CommonTree)input.LT(1);
                            c=(CommonTree)match(input,COUNT,FOLLOW_COUNT_in_functionCall8637); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_COUNT.add(c);


                            if ( state.backtracking==0 ) {
                            }
                            }
                            break;
                        case 2 :
                            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1913:32: c= SUM
                            {
                            _last = (CommonTree)input.LT(1);
                            c=(CommonTree)match(input,SUM,FOLLOW_SUM_in_functionCall8641); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_SUM.add(c);


                            if ( state.backtracking==0 ) {
                            }
                            }
                            break;
                        case 3 :
                            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1913:38: c= MIN
                            {
                            _last = (CommonTree)input.LT(1);
                            c=(CommonTree)match(input,MIN,FOLLOW_MIN_in_functionCall8645); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_MIN.add(c);


                            if ( state.backtracking==0 ) {
                            }
                            }
                            break;
                        case 4 :
                            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1913:44: c= MAX
                            {
                            _last = (CommonTree)input.LT(1);
                            c=(CommonTree)match(input,MAX,FOLLOW_MAX_in_functionCall8649); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_MAX.add(c);


                            if ( state.backtracking==0 ) {
                            }
                            }
                            break;
                        case 5 :
                            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1913:50: c= AVG
                            {
                            _last = (CommonTree)input.LT(1);
                            c=(CommonTree)match(input,AVG,FOLLOW_AVG_in_functionCall8653); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_AVG.add(c);


                            if ( state.backtracking==0 ) {
                            }
                            }
                            break;
                        case 6 :
                            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1913:56: c= SAMPLE
                            {
                            _last = (CommonTree)input.LT(1);
                            c=(CommonTree)match(input,SAMPLE,FOLLOW_SAMPLE_in_functionCall8657); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_SAMPLE.add(c);


                            if ( state.backtracking==0 ) {
                            }
                            }
                            break;
                        case 7 :
                            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1913:65: c= GROUP_CONCAT
                            {
                            _last = (CommonTree)input.LT(1);
                            c=(CommonTree)match(input,GROUP_CONCAT,FOLLOW_GROUP_CONCAT_in_functionCall8661); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_GROUP_CONCAT.add(c);


                            if ( state.backtracking==0 ) {
                            }
                            }
                            break;
                        case 8 :
                            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1913:80: c= NOTKW
                            {
                            _last = (CommonTree)input.LT(1);
                            c=(CommonTree)match(input,NOTKW,FOLLOW_NOTKW_in_functionCall8665); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_NOTKW.add(c);


                            if ( state.backtracking==0 ) {
                            }
                            }
                            break;
                        case 9 :
                            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1913:88: c= EXISTS
                            {
                            _last = (CommonTree)input.LT(1);
                            c=(CommonTree)match(input,EXISTS,FOLLOW_EXISTS_in_functionCall8669); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_EXISTS.add(c);


                            if ( state.backtracking==0 ) {
                            }
                            }
                            break;

                    }

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_2 = _last;
                    CommonTree _first_2 = null;
                    CommonTree root_2 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    T_PARAMS393=(CommonTree)match(input,T_PARAMS,FOLLOW_T_PARAMS_in_functionCall8673); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_T_PARAMS.add(T_PARAMS393);



                    if ( input.LA(1)==Token.DOWN ) {
                        match(input, Token.DOWN, null); if (state.failed) return retval;
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1913:109: ( exprSingle )*
                        loop113:
                        do {
                            int alt113=2;
                            switch ( input.LA(1) ) {
                            case LCURLY:
                            case STAR:
                            case LESSTHAN:
                            case GREATERTHAN:
                            case PLUS:
                            case MINUS:
                            case UNIONSYMBOL:
                            case LESSTHANLESSTHAN:
                            case GREATERTHANEQUALS:
                            case LESSTHANEQUALS:
                            case HAFENEQUALS:
                            case EQUALS:
                            case IS:
                            case EQ:
                            case NE:
                            case LT:
                            case GE:
                            case LE:
                            case GT:
                            case IF:
                            case AND:
                            case OR:
                            case TO:
                            case DIV:
                            case IDIV:
                            case MOD:
                            case UNION:
                            case INTERSECT:
                            case EXCEPT:
                            case GREATERTHANGREATERTHAN:
                            case T_FLWOR:
                            case T_INSTANCEOF:
                            case T_CASTAS:
                            case T_CASTABLEAS:
                            case T_TREATAS:
                            case EVERY:
                            case TYPESWITCH:
                            case VALIDATE:
                            case SOME:
                            case XPATH:
                                {
                                alt113=1;
                                }
                                break;

                            }

                            switch (alt113) {
                        	case 1 :
                        	    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: exprSingle
                        	    {
                        	    _last = (CommonTree)input.LT(1);
                        	    pushFollow(FOLLOW_exprSingle_in_functionCall8675);
                        	    exprSingle394=exprSingle();

                        	    state._fsp--;
                        	    if (state.failed) return retval;
                        	    if ( state.backtracking==0 ) stream_exprSingle.add(exprSingle394.getTree());

                        	    if ( state.backtracking==0 ) {
                        	    }
                        	    }
                        	    break;

                        	default :
                        	    break loop113;
                            }
                        } while (true);


                        match(input, Token.UP, null); if (state.failed) return retval;
                    }adaptor.addChild(root_1, root_2);_last = _save_last_2;
                    }


                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }



                    // AST REWRITE
                    // elements: exprSingle, T_FUNCTION_CALL, T_PARAMS
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1914:3: -> ^( T_FUNCTION_CALL NCNAME[$c.token, $c.text] ^( T_PARAMS ( exprSingle )* ) )
                    {
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1914:6: ^( T_FUNCTION_CALL NCNAME[$c.token, $c.text] ^( T_PARAMS ( exprSingle )* ) )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(stream_T_FUNCTION_CALL.nextNode(), root_1);

                        adaptor.addChild(root_1, (CommonTree)adaptor.create(NCNAME, c.token, (c!=null?c.getText():null)));
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1914:50: ^( T_PARAMS ( exprSingle )* )
                        {
                        CommonTree root_2 = (CommonTree)adaptor.nil();
                        root_2 = (CommonTree)adaptor.becomeRoot(stream_T_PARAMS.nextNode(), root_2);

                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1914:61: ( exprSingle )*
                        while ( stream_exprSingle.hasNext() ) {
                            adaptor.addChild(root_2, stream_exprSingle.nextTree());

                        }
                        stream_exprSingle.reset();

                        adaptor.addChild(root_1, root_2);
                        }

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;}
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "functionCall"

    public static class constructor_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "constructor"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1917:1: constructor : ( directConstructor | computedConstructor );
    public final XSPARQLRewriter.constructor_return constructor() throws RecognitionException {
        XSPARQLRewriter.constructor_return retval = new XSPARQLRewriter.constructor_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.directConstructor_return directConstructor395 = null;

        XSPARQLRewriter.computedConstructor_return computedConstructor396 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1918:3: ( directConstructor | computedConstructor )
            int alt115=2;
            switch ( input.LA(1) ) {
            case T_XML_ELEMENT:
                {
                alt115=1;
                }
                break;
            case ATTRIBUTE:
            case ELEMENT:
            case TEXT:
            case COMMENT:
            case PROCESSINGINSTRUCTION:
            case DOCUMENT:
                {
                alt115=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 115, 0, input);

                throw nvae;
            }

            switch (alt115) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1918:5: directConstructor
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_directConstructor_in_constructor8709);
                    directConstructor395=directConstructor();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, directConstructor395.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1919:5: computedConstructor
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_computedConstructor_in_constructor8715);
                    computedConstructor396=computedConstructor();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, computedConstructor396.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "constructor"

    public static class directConstructor_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "directConstructor"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1922:1: directConstructor : dirElemConstructor ;
    public final XSPARQLRewriter.directConstructor_return directConstructor() throws RecognitionException {
        XSPARQLRewriter.directConstructor_return retval = new XSPARQLRewriter.directConstructor_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.dirElemConstructor_return dirElemConstructor397 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1923:3: ( dirElemConstructor )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1923:5: dirElemConstructor
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_dirElemConstructor_in_directConstructor8728);
            dirElemConstructor397=dirElemConstructor();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_0, dirElemConstructor397.getTree());

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "directConstructor"

    public static class dirElemConstructor_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "dirElemConstructor"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1928:1: dirElemConstructor : ^( T_XML_ELEMENT qname ( dirAttributeList )? ( ^( T_XML_CONTENT dirElemContent ) )* ) ;
    public final XSPARQLRewriter.dirElemConstructor_return dirElemConstructor() throws RecognitionException {
        XSPARQLRewriter.dirElemConstructor_return retval = new XSPARQLRewriter.dirElemConstructor_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree T_XML_ELEMENT398=null;
        CommonTree T_XML_CONTENT401=null;
        XSPARQLRewriter.qname_return qname399 = null;

        XSPARQLRewriter.dirAttributeList_return dirAttributeList400 = null;

        XSPARQLRewriter.dirElemContent_return dirElemContent402 = null;


        CommonTree T_XML_ELEMENT398_tree=null;
        CommonTree T_XML_CONTENT401_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1929:3: ( ^( T_XML_ELEMENT qname ( dirAttributeList )? ( ^( T_XML_CONTENT dirElemContent ) )* ) )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1929:5: ^( T_XML_ELEMENT qname ( dirAttributeList )? ( ^( T_XML_CONTENT dirElemContent ) )* )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            T_XML_ELEMENT398=(CommonTree)match(input,T_XML_ELEMENT,FOLLOW_T_XML_ELEMENT_in_dirElemConstructor8744); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            T_XML_ELEMENT398_tree = (CommonTree)adaptor.dupNode(T_XML_ELEMENT398);

            root_1 = (CommonTree)adaptor.becomeRoot(T_XML_ELEMENT398_tree, root_1);
            }


            match(input, Token.DOWN, null); if (state.failed) return retval;
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_qname_in_dirElemConstructor8746);
            qname399=qname();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_1, qname399.getTree());
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1929:27: ( dirAttributeList )?
            int alt116=2;
            switch ( input.LA(1) ) {
                case T_XML_ATTRIBUTE:
                    {
                    alt116=1;
                    }
                    break;
            }

            switch (alt116) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: dirAttributeList
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_dirAttributeList_in_dirElemConstructor8748);
                    dirAttributeList400=dirAttributeList();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_1, dirAttributeList400.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }

            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1929:45: ( ^( T_XML_CONTENT dirElemContent ) )*
            loop117:
            do {
                int alt117=2;
                switch ( input.LA(1) ) {
                case T_XML_CONTENT:
                    {
                    alt117=1;
                    }
                    break;

                }

                switch (alt117) {
            	case 1 :
            	    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1929:46: ^( T_XML_CONTENT dirElemContent )
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    {
            	    CommonTree _save_last_2 = _last;
            	    CommonTree _first_2 = null;
            	    CommonTree root_2 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            	    T_XML_CONTENT401=(CommonTree)match(input,T_XML_CONTENT,FOLLOW_T_XML_CONTENT_in_dirElemConstructor8753); if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {
            	    T_XML_CONTENT401_tree = (CommonTree)adaptor.dupNode(T_XML_CONTENT401);

            	    root_2 = (CommonTree)adaptor.becomeRoot(T_XML_CONTENT401_tree, root_2);
            	    }


            	    match(input, Token.DOWN, null); if (state.failed) return retval;
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_dirElemContent_in_dirElemConstructor8755);
            	    dirElemContent402=dirElemContent();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) 
            	    adaptor.addChild(root_2, dirElemContent402.getTree());

            	    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_1, root_2);_last = _save_last_2;
            	    }


            	    if ( state.backtracking==0 ) {
            	    }
            	    }
            	    break;

            	default :
            	    break loop117;
                }
            } while (true);


            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "dirElemConstructor"

    public static class dirAttributeList_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "dirAttributeList"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1932:1: dirAttributeList : ( dirAttribute )+ ;
    public final XSPARQLRewriter.dirAttributeList_return dirAttributeList() throws RecognitionException {
        XSPARQLRewriter.dirAttributeList_return retval = new XSPARQLRewriter.dirAttributeList_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.dirAttribute_return dirAttribute403 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1933:3: ( ( dirAttribute )+ )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1933:6: ( dirAttribute )+
            {
            root_0 = (CommonTree)adaptor.nil();

            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1933:6: ( dirAttribute )+
            int cnt118=0;
            loop118:
            do {
                int alt118=2;
                switch ( input.LA(1) ) {
                case T_XML_ATTRIBUTE:
                    {
                    alt118=1;
                    }
                    break;

                }

                switch (alt118) {
            	case 1 :
            	    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: dirAttribute
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_dirAttribute_in_dirAttributeList8774);
            	    dirAttribute403=dirAttribute();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) 
            	    adaptor.addChild(root_0, dirAttribute403.getTree());

            	    if ( state.backtracking==0 ) {
            	    }
            	    }
            	    break;

            	default :
            	    if ( cnt118 >= 1 ) break loop118;
            	    if (state.backtracking>0) {state.failed=true; return retval;}
                        EarlyExitException eee =
                            new EarlyExitException(118, input);
                        throw eee;
                }
                cnt118++;
            } while (true);


            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "dirAttributeList"

    public static class dirAttribute_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "dirAttribute"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1936:1: dirAttribute : ^( T_XML_ATTRIBUTE qname dirAttributeValue ) ;
    public final XSPARQLRewriter.dirAttribute_return dirAttribute() throws RecognitionException {
        XSPARQLRewriter.dirAttribute_return retval = new XSPARQLRewriter.dirAttribute_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree T_XML_ATTRIBUTE404=null;
        XSPARQLRewriter.qname_return qname405 = null;

        XSPARQLRewriter.dirAttributeValue_return dirAttributeValue406 = null;


        CommonTree T_XML_ATTRIBUTE404_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1937:3: ( ^( T_XML_ATTRIBUTE qname dirAttributeValue ) )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1937:5: ^( T_XML_ATTRIBUTE qname dirAttributeValue )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            T_XML_ATTRIBUTE404=(CommonTree)match(input,T_XML_ATTRIBUTE,FOLLOW_T_XML_ATTRIBUTE_in_dirAttribute8789); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            T_XML_ATTRIBUTE404_tree = (CommonTree)adaptor.dupNode(T_XML_ATTRIBUTE404);

            root_1 = (CommonTree)adaptor.becomeRoot(T_XML_ATTRIBUTE404_tree, root_1);
            }


            match(input, Token.DOWN, null); if (state.failed) return retval;
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_qname_in_dirAttribute8791);
            qname405=qname();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_1, qname405.getTree());
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_dirAttributeValue_in_dirAttribute8793);
            dirAttributeValue406=dirAttributeValue();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_1, dirAttributeValue406.getTree());

            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "dirAttribute"

    public static class dirAttributeValue_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "dirAttributeValue"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1940:1: dirAttributeValue : ( enclosedExpr | QSTRING );
    public final XSPARQLRewriter.dirAttributeValue_return dirAttributeValue() throws RecognitionException {
        XSPARQLRewriter.dirAttributeValue_return retval = new XSPARQLRewriter.dirAttributeValue_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree QSTRING408=null;
        XSPARQLRewriter.enclosedExpr_return enclosedExpr407 = null;


        CommonTree QSTRING408_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1941:3: ( enclosedExpr | QSTRING )
            int alt119=2;
            switch ( input.LA(1) ) {
            case LCURLY:
            case STAR:
            case LESSTHAN:
            case GREATERTHAN:
            case PLUS:
            case MINUS:
            case UNIONSYMBOL:
            case LESSTHANLESSTHAN:
            case GREATERTHANEQUALS:
            case LESSTHANEQUALS:
            case HAFENEQUALS:
            case EQUALS:
            case IS:
            case EQ:
            case NE:
            case LT:
            case GE:
            case LE:
            case GT:
            case IF:
            case AND:
            case OR:
            case TO:
            case DIV:
            case IDIV:
            case MOD:
            case UNION:
            case INTERSECT:
            case EXCEPT:
            case GREATERTHANGREATERTHAN:
            case T_FLWOR:
            case T_INSTANCEOF:
            case T_CASTAS:
            case T_CASTABLEAS:
            case T_TREATAS:
            case EVERY:
            case TYPESWITCH:
            case VALIDATE:
            case SOME:
            case XPATH:
                {
                alt119=1;
                }
                break;
            case QSTRING:
                {
                alt119=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 119, 0, input);

                throw nvae;
            }

            switch (alt119) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1941:5: enclosedExpr
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_enclosedExpr_in_dirAttributeValue8807);
                    enclosedExpr407=enclosedExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, enclosedExpr407.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1942:5: QSTRING
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    QSTRING408=(CommonTree)match(input,QSTRING,FOLLOW_QSTRING_in_dirAttributeValue8813); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    QSTRING408_tree = (CommonTree)adaptor.dupNode(QSTRING408);

                    adaptor.addChild(root_0, QSTRING408_tree);
                    }

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "dirAttributeValue"

    public static class dirElemContent_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "dirElemContent"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1945:1: dirElemContent : ( directConstructor | commonContent | WHITESPACE | NCNAMEELM | cDataSection );
    public final XSPARQLRewriter.dirElemContent_return dirElemContent() throws RecognitionException {
        XSPARQLRewriter.dirElemContent_return retval = new XSPARQLRewriter.dirElemContent_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree WHITESPACE411=null;
        CommonTree NCNAMEELM412=null;
        XSPARQLRewriter.directConstructor_return directConstructor409 = null;

        XSPARQLRewriter.commonContent_return commonContent410 = null;

        XSPARQLRewriter.cDataSection_return cDataSection413 = null;


        CommonTree WHITESPACE411_tree=null;
        CommonTree NCNAMEELM412_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1946:3: ( directConstructor | commonContent | WHITESPACE | NCNAMEELM | cDataSection )
            int alt120=5;
            switch ( input.LA(1) ) {
            case T_XML_ELEMENT:
                {
                alt120=1;
                }
                break;
            case LCURLY:
            case RCURLY:
                {
                alt120=2;
                }
                break;
            case WHITESPACE:
                {
                alt120=3;
                }
                break;
            case NCNAMEELM:
                {
                alt120=4;
                }
                break;
            case CDATASTART:
                {
                alt120=5;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 120, 0, input);

                throw nvae;
            }

            switch (alt120) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1946:5: directConstructor
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_directConstructor_in_dirElemContent8826);
                    directConstructor409=directConstructor();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, directConstructor409.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1947:5: commonContent
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_commonContent_in_dirElemContent8832);
                    commonContent410=commonContent();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, commonContent410.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 3 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1948:5: WHITESPACE
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    WHITESPACE411=(CommonTree)match(input,WHITESPACE,FOLLOW_WHITESPACE_in_dirElemContent8838); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    WHITESPACE411_tree = (CommonTree)adaptor.dupNode(WHITESPACE411);

                    adaptor.addChild(root_0, WHITESPACE411_tree);
                    }

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 4 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1949:5: NCNAMEELM
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    NCNAMEELM412=(CommonTree)match(input,NCNAMEELM,FOLLOW_NCNAMEELM_in_dirElemContent8845); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    NCNAMEELM412_tree = (CommonTree)adaptor.dupNode(NCNAMEELM412);

                    adaptor.addChild(root_0, NCNAMEELM412_tree);
                    }

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 5 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1950:5: cDataSection
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_cDataSection_in_dirElemContent8852);
                    cDataSection413=cDataSection();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, cDataSection413.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "dirElemContent"

    public static class commonContent_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "commonContent"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1953:1: commonContent : ( LCURLY expr RCURLY -> ^( T_XML_CONTENTS expr ) | LCURLY LCURLY | RCURLY RCURLY );
    public final XSPARQLRewriter.commonContent_return commonContent() throws RecognitionException {
        XSPARQLRewriter.commonContent_return retval = new XSPARQLRewriter.commonContent_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree LCURLY414=null;
        CommonTree RCURLY416=null;
        CommonTree LCURLY417=null;
        CommonTree LCURLY418=null;
        CommonTree RCURLY419=null;
        CommonTree RCURLY420=null;
        XSPARQLRewriter.expr_return expr415 = null;


        CommonTree LCURLY414_tree=null;
        CommonTree RCURLY416_tree=null;
        CommonTree LCURLY417_tree=null;
        CommonTree LCURLY418_tree=null;
        CommonTree RCURLY419_tree=null;
        CommonTree RCURLY420_tree=null;
        RewriteRuleNodeStream stream_LCURLY=new RewriteRuleNodeStream(adaptor,"token LCURLY");
        RewriteRuleNodeStream stream_RCURLY=new RewriteRuleNodeStream(adaptor,"token RCURLY");
        RewriteRuleSubtreeStream stream_expr=new RewriteRuleSubtreeStream(adaptor,"rule expr");
        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1954:3: ( LCURLY expr RCURLY -> ^( T_XML_CONTENTS expr ) | LCURLY LCURLY | RCURLY RCURLY )
            int alt121=3;
            switch ( input.LA(1) ) {
            case LCURLY:
                {
                switch ( input.LA(2) ) {
                case LCURLY:
                    {
                    switch ( input.LA(3) ) {
                    case EOF:
                    case UP:
                        {
                        alt121=2;
                        }
                        break;
                    case LCURLY:
                    case RCURLY:
                    case STAR:
                    case LESSTHAN:
                    case GREATERTHAN:
                    case PLUS:
                    case MINUS:
                    case UNIONSYMBOL:
                    case LESSTHANLESSTHAN:
                    case GREATERTHANEQUALS:
                    case LESSTHANEQUALS:
                    case HAFENEQUALS:
                    case EQUALS:
                    case IS:
                    case EQ:
                    case NE:
                    case LT:
                    case GE:
                    case LE:
                    case GT:
                    case IF:
                    case AND:
                    case OR:
                    case TO:
                    case DIV:
                    case IDIV:
                    case MOD:
                    case UNION:
                    case INTERSECT:
                    case EXCEPT:
                    case GREATERTHANGREATERTHAN:
                    case T_FLWOR:
                    case T_INSTANCEOF:
                    case T_CASTAS:
                    case T_CASTABLEAS:
                    case T_TREATAS:
                    case EVERY:
                    case TYPESWITCH:
                    case VALIDATE:
                    case SOME:
                    case XPATH:
                        {
                        alt121=1;
                        }
                        break;
                    default:
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 121, 3, input);

                        throw nvae;
                    }

                    }
                    break;
                case STAR:
                case LESSTHAN:
                case GREATERTHAN:
                case PLUS:
                case MINUS:
                case UNIONSYMBOL:
                case LESSTHANLESSTHAN:
                case GREATERTHANEQUALS:
                case LESSTHANEQUALS:
                case HAFENEQUALS:
                case EQUALS:
                case IS:
                case EQ:
                case NE:
                case LT:
                case GE:
                case LE:
                case GT:
                case IF:
                case AND:
                case OR:
                case TO:
                case DIV:
                case IDIV:
                case MOD:
                case UNION:
                case INTERSECT:
                case EXCEPT:
                case GREATERTHANGREATERTHAN:
                case T_FLWOR:
                case T_INSTANCEOF:
                case T_CASTAS:
                case T_CASTABLEAS:
                case T_TREATAS:
                case EVERY:
                case TYPESWITCH:
                case VALIDATE:
                case SOME:
                case XPATH:
                    {
                    alt121=1;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 121, 1, input);

                    throw nvae;
                }

                }
                break;
            case RCURLY:
                {
                alt121=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 121, 0, input);

                throw nvae;
            }

            switch (alt121) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1954:5: LCURLY expr RCURLY
                    {
                    _last = (CommonTree)input.LT(1);
                    LCURLY414=(CommonTree)match(input,LCURLY,FOLLOW_LCURLY_in_commonContent8865); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_LCURLY.add(LCURLY414);

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expr_in_commonContent8867);
                    expr415=expr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_expr.add(expr415.getTree());
                    _last = (CommonTree)input.LT(1);
                    RCURLY416=(CommonTree)match(input,RCURLY,FOLLOW_RCURLY_in_commonContent8869); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_RCURLY.add(RCURLY416);



                    // AST REWRITE
                    // elements: expr
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1954:24: -> ^( T_XML_CONTENTS expr )
                    {
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1954:27: ^( T_XML_CONTENTS expr )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_XML_CONTENTS, "T_XML_CONTENTS"), root_1);

                        adaptor.addChild(root_1, stream_expr.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;}
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1955:5: LCURLY LCURLY
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    LCURLY417=(CommonTree)match(input,LCURLY,FOLLOW_LCURLY_in_commonContent8883); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    LCURLY417_tree = (CommonTree)adaptor.dupNode(LCURLY417);

                    adaptor.addChild(root_0, LCURLY417_tree);
                    }
                    _last = (CommonTree)input.LT(1);
                    LCURLY418=(CommonTree)match(input,LCURLY,FOLLOW_LCURLY_in_commonContent8885); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    LCURLY418_tree = (CommonTree)adaptor.dupNode(LCURLY418);

                    adaptor.addChild(root_0, LCURLY418_tree);
                    }

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 3 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1956:5: RCURLY RCURLY
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    RCURLY419=(CommonTree)match(input,RCURLY,FOLLOW_RCURLY_in_commonContent8891); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    RCURLY419_tree = (CommonTree)adaptor.dupNode(RCURLY419);

                    adaptor.addChild(root_0, RCURLY419_tree);
                    }
                    _last = (CommonTree)input.LT(1);
                    RCURLY420=(CommonTree)match(input,RCURLY,FOLLOW_RCURLY_in_commonContent8893); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    RCURLY420_tree = (CommonTree)adaptor.dupNode(RCURLY420);

                    adaptor.addChild(root_0, RCURLY420_tree);
                    }

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "commonContent"

    public static class cDataSection_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "cDataSection"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1959:1: cDataSection : CDATASTART CDATAELMEND ;
    public final XSPARQLRewriter.cDataSection_return cDataSection() throws RecognitionException {
        XSPARQLRewriter.cDataSection_return retval = new XSPARQLRewriter.cDataSection_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree CDATASTART421=null;
        CommonTree CDATAELMEND422=null;

        CommonTree CDATASTART421_tree=null;
        CommonTree CDATAELMEND422_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1960:3: ( CDATASTART CDATAELMEND )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1960:5: CDATASTART CDATAELMEND
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            CDATASTART421=(CommonTree)match(input,CDATASTART,FOLLOW_CDATASTART_in_cDataSection8906); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            CDATASTART421_tree = (CommonTree)adaptor.dupNode(CDATASTART421);

            adaptor.addChild(root_0, CDATASTART421_tree);
            }
            _last = (CommonTree)input.LT(1);
            CDATAELMEND422=(CommonTree)match(input,CDATAELMEND,FOLLOW_CDATAELMEND_in_cDataSection8908); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            CDATAELMEND422_tree = (CommonTree)adaptor.dupNode(CDATAELMEND422);

            adaptor.addChild(root_0, CDATAELMEND422_tree);
            }

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "cDataSection"

    public static class computedConstructor_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "computedConstructor"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1963:1: computedConstructor : ( compDocConstructor | compElemConstructor | compAttrConstructor | compTextConstructor | compCommentConstructor | compPIConstructor );
    public final XSPARQLRewriter.computedConstructor_return computedConstructor() throws RecognitionException {
        XSPARQLRewriter.computedConstructor_return retval = new XSPARQLRewriter.computedConstructor_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.compDocConstructor_return compDocConstructor423 = null;

        XSPARQLRewriter.compElemConstructor_return compElemConstructor424 = null;

        XSPARQLRewriter.compAttrConstructor_return compAttrConstructor425 = null;

        XSPARQLRewriter.compTextConstructor_return compTextConstructor426 = null;

        XSPARQLRewriter.compCommentConstructor_return compCommentConstructor427 = null;

        XSPARQLRewriter.compPIConstructor_return compPIConstructor428 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1964:3: ( compDocConstructor | compElemConstructor | compAttrConstructor | compTextConstructor | compCommentConstructor | compPIConstructor )
            int alt122=6;
            switch ( input.LA(1) ) {
            case DOCUMENT:
                {
                alt122=1;
                }
                break;
            case ELEMENT:
                {
                alt122=2;
                }
                break;
            case ATTRIBUTE:
                {
                alt122=3;
                }
                break;
            case TEXT:
                {
                alt122=4;
                }
                break;
            case COMMENT:
                {
                alt122=5;
                }
                break;
            case PROCESSINGINSTRUCTION:
                {
                alt122=6;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 122, 0, input);

                throw nvae;
            }

            switch (alt122) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1964:5: compDocConstructor
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_compDocConstructor_in_computedConstructor8921);
                    compDocConstructor423=compDocConstructor();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, compDocConstructor423.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1965:5: compElemConstructor
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_compElemConstructor_in_computedConstructor8927);
                    compElemConstructor424=compElemConstructor();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, compElemConstructor424.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 3 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1966:5: compAttrConstructor
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_compAttrConstructor_in_computedConstructor8933);
                    compAttrConstructor425=compAttrConstructor();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, compAttrConstructor425.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 4 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1967:5: compTextConstructor
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_compTextConstructor_in_computedConstructor8939);
                    compTextConstructor426=compTextConstructor();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, compTextConstructor426.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 5 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1968:5: compCommentConstructor
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_compCommentConstructor_in_computedConstructor8945);
                    compCommentConstructor427=compCommentConstructor();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, compCommentConstructor427.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 6 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1969:5: compPIConstructor
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_compPIConstructor_in_computedConstructor8951);
                    compPIConstructor428=compPIConstructor();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, compPIConstructor428.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "computedConstructor"

    public static class compDocConstructor_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "compDocConstructor"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1972:1: compDocConstructor : DOCUMENT enclosedExpr ;
    public final XSPARQLRewriter.compDocConstructor_return compDocConstructor() throws RecognitionException {
        XSPARQLRewriter.compDocConstructor_return retval = new XSPARQLRewriter.compDocConstructor_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree DOCUMENT429=null;
        XSPARQLRewriter.enclosedExpr_return enclosedExpr430 = null;


        CommonTree DOCUMENT429_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1973:3: ( DOCUMENT enclosedExpr )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1973:5: DOCUMENT enclosedExpr
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            DOCUMENT429=(CommonTree)match(input,DOCUMENT,FOLLOW_DOCUMENT_in_compDocConstructor8964); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            DOCUMENT429_tree = (CommonTree)adaptor.dupNode(DOCUMENT429);

            adaptor.addChild(root_0, DOCUMENT429_tree);
            }
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_enclosedExpr_in_compDocConstructor8966);
            enclosedExpr430=enclosedExpr();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_0, enclosedExpr430.getTree());

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "compDocConstructor"

    public static class compElemConstructor_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "compElemConstructor"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1976:1: compElemConstructor : ELEMENT ( qname | enclosedExpr_ ) LCURLY ( contentExpr )? RCURLY ;
    public final XSPARQLRewriter.compElemConstructor_return compElemConstructor() throws RecognitionException {
        XSPARQLRewriter.compElemConstructor_return retval = new XSPARQLRewriter.compElemConstructor_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree ELEMENT431=null;
        CommonTree LCURLY434=null;
        CommonTree RCURLY436=null;
        XSPARQLRewriter.qname_return qname432 = null;

        XSPARQLRewriter.enclosedExpr__return enclosedExpr_433 = null;

        XSPARQLRewriter.contentExpr_return contentExpr435 = null;


        CommonTree ELEMENT431_tree=null;
        CommonTree LCURLY434_tree=null;
        CommonTree RCURLY436_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1977:3: ( ELEMENT ( qname | enclosedExpr_ ) LCURLY ( contentExpr )? RCURLY )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1977:5: ELEMENT ( qname | enclosedExpr_ ) LCURLY ( contentExpr )? RCURLY
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            ELEMENT431=(CommonTree)match(input,ELEMENT,FOLLOW_ELEMENT_in_compElemConstructor8979); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            ELEMENT431_tree = (CommonTree)adaptor.dupNode(ELEMENT431);

            adaptor.addChild(root_0, ELEMENT431_tree);
            }
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1977:13: ( qname | enclosedExpr_ )
            int alt123=2;
            switch ( input.LA(1) ) {
            case NCNAME:
            case PNAME_NS:
            case PNAME_LN:
            case A:
            case FROM:
            case TO:
            case ITEM:
            case NODE:
            case COMMENT:
            case ROW:
                {
                alt123=1;
                }
                break;
            case LCURLY:
                {
                alt123=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 123, 0, input);

                throw nvae;
            }

            switch (alt123) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1977:15: qname
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_qname_in_compElemConstructor8983);
                    qname432=qname();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, qname432.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1977:23: enclosedExpr_
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_enclosedExpr__in_compElemConstructor8987);
                    enclosedExpr_433=enclosedExpr_();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, enclosedExpr_433.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }

            _last = (CommonTree)input.LT(1);
            LCURLY434=(CommonTree)match(input,LCURLY,FOLLOW_LCURLY_in_compElemConstructor8990); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            LCURLY434_tree = (CommonTree)adaptor.dupNode(LCURLY434);

            adaptor.addChild(root_0, LCURLY434_tree);
            }
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1977:45: ( contentExpr )?
            int alt124=2;
            switch ( input.LA(1) ) {
                case LCURLY:
                case STAR:
                case LESSTHAN:
                case GREATERTHAN:
                case PLUS:
                case MINUS:
                case UNIONSYMBOL:
                case LESSTHANLESSTHAN:
                case GREATERTHANEQUALS:
                case LESSTHANEQUALS:
                case HAFENEQUALS:
                case EQUALS:
                case IS:
                case EQ:
                case NE:
                case LT:
                case GE:
                case LE:
                case GT:
                case IF:
                case AND:
                case OR:
                case TO:
                case DIV:
                case IDIV:
                case MOD:
                case UNION:
                case INTERSECT:
                case EXCEPT:
                case GREATERTHANGREATERTHAN:
                case T_FLWOR:
                case T_INSTANCEOF:
                case T_CASTAS:
                case T_CASTABLEAS:
                case T_TREATAS:
                case EVERY:
                case TYPESWITCH:
                case VALIDATE:
                case SOME:
                case XPATH:
                    {
                    alt124=1;
                    }
                    break;
            }

            switch (alt124) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: contentExpr
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_contentExpr_in_compElemConstructor8992);
                    contentExpr435=contentExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, contentExpr435.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }

            _last = (CommonTree)input.LT(1);
            RCURLY436=(CommonTree)match(input,RCURLY,FOLLOW_RCURLY_in_compElemConstructor8995); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            RCURLY436_tree = (CommonTree)adaptor.dupNode(RCURLY436);

            adaptor.addChild(root_0, RCURLY436_tree);
            }

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "compElemConstructor"

    public static class contentExpr_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "contentExpr"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1980:1: contentExpr : expr ;
    public final XSPARQLRewriter.contentExpr_return contentExpr() throws RecognitionException {
        XSPARQLRewriter.contentExpr_return retval = new XSPARQLRewriter.contentExpr_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.expr_return expr437 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1981:3: ( expr )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1981:5: expr
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_expr_in_contentExpr9008);
            expr437=expr();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_0, expr437.getTree());

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "contentExpr"

    public static class compAttrConstructor_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "compAttrConstructor"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1984:1: compAttrConstructor : ATTRIBUTE ( qname | enclosedExpr ) LCURLY ( expr )? RCURLY ;
    public final XSPARQLRewriter.compAttrConstructor_return compAttrConstructor() throws RecognitionException {
        XSPARQLRewriter.compAttrConstructor_return retval = new XSPARQLRewriter.compAttrConstructor_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree ATTRIBUTE438=null;
        CommonTree LCURLY441=null;
        CommonTree RCURLY443=null;
        XSPARQLRewriter.qname_return qname439 = null;

        XSPARQLRewriter.enclosedExpr_return enclosedExpr440 = null;

        XSPARQLRewriter.expr_return expr442 = null;


        CommonTree ATTRIBUTE438_tree=null;
        CommonTree LCURLY441_tree=null;
        CommonTree RCURLY443_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1985:3: ( ATTRIBUTE ( qname | enclosedExpr ) LCURLY ( expr )? RCURLY )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1985:5: ATTRIBUTE ( qname | enclosedExpr ) LCURLY ( expr )? RCURLY
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            ATTRIBUTE438=(CommonTree)match(input,ATTRIBUTE,FOLLOW_ATTRIBUTE_in_compAttrConstructor9021); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            ATTRIBUTE438_tree = (CommonTree)adaptor.dupNode(ATTRIBUTE438);

            adaptor.addChild(root_0, ATTRIBUTE438_tree);
            }
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1985:15: ( qname | enclosedExpr )
            int alt125=2;
            switch ( input.LA(1) ) {
            case NCNAME:
            case PNAME_NS:
            case PNAME_LN:
            case A:
            case FROM:
            case ITEM:
            case NODE:
            case COMMENT:
            case ROW:
                {
                alt125=1;
                }
                break;
            case TO:
                {
                switch ( input.LA(2) ) {
                case DOWN:
                    {
                    alt125=2;
                    }
                    break;
                case LCURLY:
                    {
                    alt125=1;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 125, 2, input);

                    throw nvae;
                }

                }
                break;
            case LCURLY:
            case STAR:
            case LESSTHAN:
            case GREATERTHAN:
            case PLUS:
            case MINUS:
            case UNIONSYMBOL:
            case LESSTHANLESSTHAN:
            case GREATERTHANEQUALS:
            case LESSTHANEQUALS:
            case HAFENEQUALS:
            case EQUALS:
            case IS:
            case EQ:
            case NE:
            case LT:
            case GE:
            case LE:
            case GT:
            case IF:
            case AND:
            case OR:
            case DIV:
            case IDIV:
            case MOD:
            case UNION:
            case INTERSECT:
            case EXCEPT:
            case GREATERTHANGREATERTHAN:
            case T_FLWOR:
            case T_INSTANCEOF:
            case T_CASTAS:
            case T_CASTABLEAS:
            case T_TREATAS:
            case EVERY:
            case TYPESWITCH:
            case VALIDATE:
            case SOME:
            case XPATH:
                {
                alt125=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 125, 0, input);

                throw nvae;
            }

            switch (alt125) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1985:16: qname
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_qname_in_compAttrConstructor9024);
                    qname439=qname();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, qname439.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1985:24: enclosedExpr
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_enclosedExpr_in_compAttrConstructor9028);
                    enclosedExpr440=enclosedExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, enclosedExpr440.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }

            _last = (CommonTree)input.LT(1);
            LCURLY441=(CommonTree)match(input,LCURLY,FOLLOW_LCURLY_in_compAttrConstructor9031); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            LCURLY441_tree = (CommonTree)adaptor.dupNode(LCURLY441);

            adaptor.addChild(root_0, LCURLY441_tree);
            }
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1985:45: ( expr )?
            int alt126=2;
            switch ( input.LA(1) ) {
                case LCURLY:
                case STAR:
                case LESSTHAN:
                case GREATERTHAN:
                case PLUS:
                case MINUS:
                case UNIONSYMBOL:
                case LESSTHANLESSTHAN:
                case GREATERTHANEQUALS:
                case LESSTHANEQUALS:
                case HAFENEQUALS:
                case EQUALS:
                case IS:
                case EQ:
                case NE:
                case LT:
                case GE:
                case LE:
                case GT:
                case IF:
                case AND:
                case OR:
                case TO:
                case DIV:
                case IDIV:
                case MOD:
                case UNION:
                case INTERSECT:
                case EXCEPT:
                case GREATERTHANGREATERTHAN:
                case T_FLWOR:
                case T_INSTANCEOF:
                case T_CASTAS:
                case T_CASTABLEAS:
                case T_TREATAS:
                case EVERY:
                case TYPESWITCH:
                case VALIDATE:
                case SOME:
                case XPATH:
                    {
                    alt126=1;
                    }
                    break;
            }

            switch (alt126) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: expr
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expr_in_compAttrConstructor9033);
                    expr442=expr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, expr442.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }

            _last = (CommonTree)input.LT(1);
            RCURLY443=(CommonTree)match(input,RCURLY,FOLLOW_RCURLY_in_compAttrConstructor9036); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            RCURLY443_tree = (CommonTree)adaptor.dupNode(RCURLY443);

            adaptor.addChild(root_0, RCURLY443_tree);
            }

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "compAttrConstructor"

    public static class compTextConstructor_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "compTextConstructor"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1988:1: compTextConstructor : TEXT enclosedExpr_ ;
    public final XSPARQLRewriter.compTextConstructor_return compTextConstructor() throws RecognitionException {
        XSPARQLRewriter.compTextConstructor_return retval = new XSPARQLRewriter.compTextConstructor_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree TEXT444=null;
        XSPARQLRewriter.enclosedExpr__return enclosedExpr_445 = null;


        CommonTree TEXT444_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1989:3: ( TEXT enclosedExpr_ )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1989:5: TEXT enclosedExpr_
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            TEXT444=(CommonTree)match(input,TEXT,FOLLOW_TEXT_in_compTextConstructor9049); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            TEXT444_tree = (CommonTree)adaptor.dupNode(TEXT444);

            adaptor.addChild(root_0, TEXT444_tree);
            }
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_enclosedExpr__in_compTextConstructor9051);
            enclosedExpr_445=enclosedExpr_();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_0, enclosedExpr_445.getTree());

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "compTextConstructor"

    public static class compCommentConstructor_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "compCommentConstructor"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1992:1: compCommentConstructor : COMMENT enclosedExpr ;
    public final XSPARQLRewriter.compCommentConstructor_return compCommentConstructor() throws RecognitionException {
        XSPARQLRewriter.compCommentConstructor_return retval = new XSPARQLRewriter.compCommentConstructor_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree COMMENT446=null;
        XSPARQLRewriter.enclosedExpr_return enclosedExpr447 = null;


        CommonTree COMMENT446_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1993:3: ( COMMENT enclosedExpr )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1993:5: COMMENT enclosedExpr
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            COMMENT446=(CommonTree)match(input,COMMENT,FOLLOW_COMMENT_in_compCommentConstructor9064); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            COMMENT446_tree = (CommonTree)adaptor.dupNode(COMMENT446);

            adaptor.addChild(root_0, COMMENT446_tree);
            }
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_enclosedExpr_in_compCommentConstructor9066);
            enclosedExpr447=enclosedExpr();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_0, enclosedExpr447.getTree());

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "compCommentConstructor"

    public static class compPIConstructor_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "compPIConstructor"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1996:1: compPIConstructor : PROCESSINGINSTRUCTION ( NCNAME | enclosedExpr ) LCURLY ( expr )? RCURLY ;
    public final XSPARQLRewriter.compPIConstructor_return compPIConstructor() throws RecognitionException {
        XSPARQLRewriter.compPIConstructor_return retval = new XSPARQLRewriter.compPIConstructor_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree PROCESSINGINSTRUCTION448=null;
        CommonTree NCNAME449=null;
        CommonTree LCURLY451=null;
        CommonTree RCURLY453=null;
        XSPARQLRewriter.enclosedExpr_return enclosedExpr450 = null;

        XSPARQLRewriter.expr_return expr452 = null;


        CommonTree PROCESSINGINSTRUCTION448_tree=null;
        CommonTree NCNAME449_tree=null;
        CommonTree LCURLY451_tree=null;
        CommonTree RCURLY453_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1997:3: ( PROCESSINGINSTRUCTION ( NCNAME | enclosedExpr ) LCURLY ( expr )? RCURLY )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1997:5: PROCESSINGINSTRUCTION ( NCNAME | enclosedExpr ) LCURLY ( expr )? RCURLY
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            PROCESSINGINSTRUCTION448=(CommonTree)match(input,PROCESSINGINSTRUCTION,FOLLOW_PROCESSINGINSTRUCTION_in_compPIConstructor9079); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            PROCESSINGINSTRUCTION448_tree = (CommonTree)adaptor.dupNode(PROCESSINGINSTRUCTION448);

            adaptor.addChild(root_0, PROCESSINGINSTRUCTION448_tree);
            }
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1997:27: ( NCNAME | enclosedExpr )
            int alt127=2;
            switch ( input.LA(1) ) {
            case NCNAME:
                {
                alt127=1;
                }
                break;
            case LCURLY:
            case STAR:
            case LESSTHAN:
            case GREATERTHAN:
            case PLUS:
            case MINUS:
            case UNIONSYMBOL:
            case LESSTHANLESSTHAN:
            case GREATERTHANEQUALS:
            case LESSTHANEQUALS:
            case HAFENEQUALS:
            case EQUALS:
            case IS:
            case EQ:
            case NE:
            case LT:
            case GE:
            case LE:
            case GT:
            case IF:
            case AND:
            case OR:
            case TO:
            case DIV:
            case IDIV:
            case MOD:
            case UNION:
            case INTERSECT:
            case EXCEPT:
            case GREATERTHANGREATERTHAN:
            case T_FLWOR:
            case T_INSTANCEOF:
            case T_CASTAS:
            case T_CASTABLEAS:
            case T_TREATAS:
            case EVERY:
            case TYPESWITCH:
            case VALIDATE:
            case SOME:
            case XPATH:
                {
                alt127=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 127, 0, input);

                throw nvae;
            }

            switch (alt127) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1997:29: NCNAME
                    {
                    _last = (CommonTree)input.LT(1);
                    NCNAME449=(CommonTree)match(input,NCNAME,FOLLOW_NCNAME_in_compPIConstructor9083); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    NCNAME449_tree = (CommonTree)adaptor.dupNode(NCNAME449);

                    adaptor.addChild(root_0, NCNAME449_tree);
                    }

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1997:38: enclosedExpr
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_enclosedExpr_in_compPIConstructor9087);
                    enclosedExpr450=enclosedExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, enclosedExpr450.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }

            _last = (CommonTree)input.LT(1);
            LCURLY451=(CommonTree)match(input,LCURLY,FOLLOW_LCURLY_in_compPIConstructor9090); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            LCURLY451_tree = (CommonTree)adaptor.dupNode(LCURLY451);

            adaptor.addChild(root_0, LCURLY451_tree);
            }
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:1997:59: ( expr )?
            int alt128=2;
            switch ( input.LA(1) ) {
                case LCURLY:
                case STAR:
                case LESSTHAN:
                case GREATERTHAN:
                case PLUS:
                case MINUS:
                case UNIONSYMBOL:
                case LESSTHANLESSTHAN:
                case GREATERTHANEQUALS:
                case LESSTHANEQUALS:
                case HAFENEQUALS:
                case EQUALS:
                case IS:
                case EQ:
                case NE:
                case LT:
                case GE:
                case LE:
                case GT:
                case IF:
                case AND:
                case OR:
                case TO:
                case DIV:
                case IDIV:
                case MOD:
                case UNION:
                case INTERSECT:
                case EXCEPT:
                case GREATERTHANGREATERTHAN:
                case T_FLWOR:
                case T_INSTANCEOF:
                case T_CASTAS:
                case T_CASTABLEAS:
                case T_TREATAS:
                case EVERY:
                case TYPESWITCH:
                case VALIDATE:
                case SOME:
                case XPATH:
                    {
                    alt128=1;
                    }
                    break;
            }

            switch (alt128) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: expr
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expr_in_compPIConstructor9092);
                    expr452=expr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, expr452.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }

            _last = (CommonTree)input.LT(1);
            RCURLY453=(CommonTree)match(input,RCURLY,FOLLOW_RCURLY_in_compPIConstructor9095); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            RCURLY453_tree = (CommonTree)adaptor.dupNode(RCURLY453);

            adaptor.addChild(root_0, RCURLY453_tree);
            }

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "compPIConstructor"

    public static class singleType_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "singleType"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2000:1: singleType : atomicType ( QUESTIONMARK )? ;
    public final XSPARQLRewriter.singleType_return singleType() throws RecognitionException {
        XSPARQLRewriter.singleType_return retval = new XSPARQLRewriter.singleType_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree QUESTIONMARK455=null;
        XSPARQLRewriter.atomicType_return atomicType454 = null;


        CommonTree QUESTIONMARK455_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2001:3: ( atomicType ( QUESTIONMARK )? )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2001:5: atomicType ( QUESTIONMARK )?
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_atomicType_in_singleType9108);
            atomicType454=atomicType();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_0, atomicType454.getTree());
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2001:16: ( QUESTIONMARK )?
            int alt129=2;
            switch ( input.LA(1) ) {
                case QUESTIONMARK:
                    {
                    alt129=1;
                    }
                    break;
            }

            switch (alt129) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: QUESTIONMARK
                    {
                    _last = (CommonTree)input.LT(1);
                    QUESTIONMARK455=(CommonTree)match(input,QUESTIONMARK,FOLLOW_QUESTIONMARK_in_singleType9110); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    QUESTIONMARK455_tree = (CommonTree)adaptor.dupNode(QUESTIONMARK455);

                    adaptor.addChild(root_0, QUESTIONMARK455_tree);
                    }

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }


            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "singleType"

    public static class typeDeclaration_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "typeDeclaration"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2004:1: typeDeclaration : sequenceType ;
    public final XSPARQLRewriter.typeDeclaration_return typeDeclaration() throws RecognitionException {
        XSPARQLRewriter.typeDeclaration_return retval = new XSPARQLRewriter.typeDeclaration_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.sequenceType_return sequenceType456 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2005:3: ( sequenceType )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2005:5: sequenceType
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_sequenceType_in_typeDeclaration9124);
            sequenceType456=sequenceType();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_0, sequenceType456.getTree());

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "typeDeclaration"

    public static class sequenceType_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "sequenceType"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2008:1: sequenceType : ( EMPTYSEQUENCE LPAR RPAR | itemType ( occurrenceIndicator )? );
    public final XSPARQLRewriter.sequenceType_return sequenceType() throws RecognitionException {
        XSPARQLRewriter.sequenceType_return retval = new XSPARQLRewriter.sequenceType_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree EMPTYSEQUENCE457=null;
        CommonTree LPAR458=null;
        CommonTree RPAR459=null;
        XSPARQLRewriter.itemType_return itemType460 = null;

        XSPARQLRewriter.occurrenceIndicator_return occurrenceIndicator461 = null;


        CommonTree EMPTYSEQUENCE457_tree=null;
        CommonTree LPAR458_tree=null;
        CommonTree RPAR459_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2009:3: ( EMPTYSEQUENCE LPAR RPAR | itemType ( occurrenceIndicator )? )
            int alt131=2;
            switch ( input.LA(1) ) {
            case EMPTYSEQUENCE:
                {
                alt131=1;
                }
                break;
            case NCNAME:
            case PNAME_NS:
            case PNAME_LN:
            case A:
            case FROM:
            case ATTRIBUTE:
            case ELEMENT:
            case TO:
            case ITEM:
            case NODE:
            case DOCUMENTNODE:
            case TEXT:
            case COMMENT:
            case PROCESSINGINSTRUCTION:
            case SCHEMAATTRIBUTE:
            case SCHEMAELEMENT:
            case ROW:
                {
                alt131=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 131, 0, input);

                throw nvae;
            }

            switch (alt131) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2009:5: EMPTYSEQUENCE LPAR RPAR
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    EMPTYSEQUENCE457=(CommonTree)match(input,EMPTYSEQUENCE,FOLLOW_EMPTYSEQUENCE_in_sequenceType9137); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    EMPTYSEQUENCE457_tree = (CommonTree)adaptor.dupNode(EMPTYSEQUENCE457);

                    adaptor.addChild(root_0, EMPTYSEQUENCE457_tree);
                    }
                    _last = (CommonTree)input.LT(1);
                    LPAR458=(CommonTree)match(input,LPAR,FOLLOW_LPAR_in_sequenceType9139); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    LPAR458_tree = (CommonTree)adaptor.dupNode(LPAR458);

                    adaptor.addChild(root_0, LPAR458_tree);
                    }
                    _last = (CommonTree)input.LT(1);
                    RPAR459=(CommonTree)match(input,RPAR,FOLLOW_RPAR_in_sequenceType9141); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    RPAR459_tree = (CommonTree)adaptor.dupNode(RPAR459);

                    adaptor.addChild(root_0, RPAR459_tree);
                    }

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2010:5: itemType ( occurrenceIndicator )?
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_itemType_in_sequenceType9147);
                    itemType460=itemType();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, itemType460.getTree());
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2010:14: ( occurrenceIndicator )?
                    int alt130=2;
                    switch ( input.LA(1) ) {
                        case STAR:
                        case PLUS:
                        case QUESTIONMARK:
                            {
                            alt130=1;
                            }
                            break;
                    }

                    switch (alt130) {
                        case 1 :
                            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: occurrenceIndicator
                            {
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_occurrenceIndicator_in_sequenceType9149);
                            occurrenceIndicator461=occurrenceIndicator();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) 
                            adaptor.addChild(root_0, occurrenceIndicator461.getTree());

                            if ( state.backtracking==0 ) {
                            }
                            }
                            break;

                    }


                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "sequenceType"

    public static class occurrenceIndicator_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "occurrenceIndicator"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2013:1: occurrenceIndicator : ( QUESTIONMARK | STAR | PLUS );
    public final XSPARQLRewriter.occurrenceIndicator_return occurrenceIndicator() throws RecognitionException {
        XSPARQLRewriter.occurrenceIndicator_return retval = new XSPARQLRewriter.occurrenceIndicator_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set462=null;

        CommonTree set462_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2014:3: ( QUESTIONMARK | STAR | PLUS )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            set462=(CommonTree)input.LT(1);
            if ( input.LA(1)==STAR||input.LA(1)==PLUS||input.LA(1)==QUESTIONMARK ) {
                input.consume();

                if ( state.backtracking==0 ) {
                set462_tree = (CommonTree)adaptor.dupNode(set462);

                adaptor.addChild(root_0, set462_tree);
                }
                state.errorRecovery=false;state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

            if ( state.backtracking==0 ) {
            } 

            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "occurrenceIndicator"

    public static class itemType_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "itemType"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2017:1: itemType : ( ITEM LPAR RPAR | atomicType | kindTest );
    public final XSPARQLRewriter.itemType_return itemType() throws RecognitionException {
        XSPARQLRewriter.itemType_return retval = new XSPARQLRewriter.itemType_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree ITEM463=null;
        CommonTree LPAR464=null;
        CommonTree RPAR465=null;
        XSPARQLRewriter.atomicType_return atomicType466 = null;

        XSPARQLRewriter.kindTest_return kindTest467 = null;


        CommonTree ITEM463_tree=null;
        CommonTree LPAR464_tree=null;
        CommonTree RPAR465_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2018:3: ( ITEM LPAR RPAR | atomicType | kindTest )
            int alt132=3;
            switch ( input.LA(1) ) {
            case ITEM:
                {
                switch ( input.LA(2) ) {
                case LPAR:
                    {
                    alt132=1;
                    }
                    break;
                case EOF:
                case UP:
                case STAR:
                case PLUS:
                case QUESTIONMARK:
                case RETURN:
                    {
                    alt132=2;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 132, 1, input);

                    throw nvae;
                }

                }
                break;
            case NCNAME:
            case PNAME_NS:
            case PNAME_LN:
            case A:
            case FROM:
            case TO:
            case ROW:
                {
                alt132=2;
                }
                break;
            case COMMENT:
                {
                switch ( input.LA(2) ) {
                case LPAR:
                    {
                    alt132=3;
                    }
                    break;
                case EOF:
                case UP:
                case STAR:
                case PLUS:
                case QUESTIONMARK:
                case RETURN:
                    {
                    alt132=2;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 132, 3, input);

                    throw nvae;
                }

                }
                break;
            case NODE:
                {
                switch ( input.LA(2) ) {
                case LPAR:
                    {
                    alt132=3;
                    }
                    break;
                case EOF:
                case UP:
                case STAR:
                case PLUS:
                case QUESTIONMARK:
                case RETURN:
                    {
                    alt132=2;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 132, 4, input);

                    throw nvae;
                }

                }
                break;
            case ATTRIBUTE:
            case ELEMENT:
            case DOCUMENTNODE:
            case TEXT:
            case PROCESSINGINSTRUCTION:
            case SCHEMAATTRIBUTE:
            case SCHEMAELEMENT:
                {
                alt132=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 132, 0, input);

                throw nvae;
            }

            switch (alt132) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2018:5: ITEM LPAR RPAR
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    ITEM463=(CommonTree)match(input,ITEM,FOLLOW_ITEM_in_itemType9184); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    ITEM463_tree = (CommonTree)adaptor.dupNode(ITEM463);

                    adaptor.addChild(root_0, ITEM463_tree);
                    }
                    _last = (CommonTree)input.LT(1);
                    LPAR464=(CommonTree)match(input,LPAR,FOLLOW_LPAR_in_itemType9186); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    LPAR464_tree = (CommonTree)adaptor.dupNode(LPAR464);

                    adaptor.addChild(root_0, LPAR464_tree);
                    }
                    _last = (CommonTree)input.LT(1);
                    RPAR465=(CommonTree)match(input,RPAR,FOLLOW_RPAR_in_itemType9188); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    RPAR465_tree = (CommonTree)adaptor.dupNode(RPAR465);

                    adaptor.addChild(root_0, RPAR465_tree);
                    }

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2019:5: atomicType
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_atomicType_in_itemType9194);
                    atomicType466=atomicType();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, atomicType466.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 3 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2020:5: kindTest
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_kindTest_in_itemType9200);
                    kindTest467=kindTest();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, kindTest467.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "itemType"

    public static class atomicType_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "atomicType"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2023:1: atomicType : qname ;
    public final XSPARQLRewriter.atomicType_return atomicType() throws RecognitionException {
        XSPARQLRewriter.atomicType_return retval = new XSPARQLRewriter.atomicType_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.qname_return qname468 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2024:3: ( qname )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2024:5: qname
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_qname_in_atomicType9213);
            qname468=qname();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_0, qname468.getTree());

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "atomicType"

    public static class kindTest_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "kindTest"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2027:1: kindTest : ( documentTest | elementTest | attributeTest | schemaElementTest | schemaAttributeTest | piTest | commentTest | textTest | anyKindTest );
    public final XSPARQLRewriter.kindTest_return kindTest() throws RecognitionException {
        XSPARQLRewriter.kindTest_return retval = new XSPARQLRewriter.kindTest_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.documentTest_return documentTest469 = null;

        XSPARQLRewriter.elementTest_return elementTest470 = null;

        XSPARQLRewriter.attributeTest_return attributeTest471 = null;

        XSPARQLRewriter.schemaElementTest_return schemaElementTest472 = null;

        XSPARQLRewriter.schemaAttributeTest_return schemaAttributeTest473 = null;

        XSPARQLRewriter.piTest_return piTest474 = null;

        XSPARQLRewriter.commentTest_return commentTest475 = null;

        XSPARQLRewriter.textTest_return textTest476 = null;

        XSPARQLRewriter.anyKindTest_return anyKindTest477 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2028:3: ( documentTest | elementTest | attributeTest | schemaElementTest | schemaAttributeTest | piTest | commentTest | textTest | anyKindTest )
            int alt133=9;
            switch ( input.LA(1) ) {
            case DOCUMENTNODE:
                {
                alt133=1;
                }
                break;
            case ELEMENT:
                {
                alt133=2;
                }
                break;
            case ATTRIBUTE:
                {
                alt133=3;
                }
                break;
            case SCHEMAELEMENT:
                {
                alt133=4;
                }
                break;
            case SCHEMAATTRIBUTE:
                {
                alt133=5;
                }
                break;
            case PROCESSINGINSTRUCTION:
                {
                alt133=6;
                }
                break;
            case COMMENT:
                {
                alt133=7;
                }
                break;
            case TEXT:
                {
                alt133=8;
                }
                break;
            case NODE:
                {
                alt133=9;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 133, 0, input);

                throw nvae;
            }

            switch (alt133) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2028:5: documentTest
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_documentTest_in_kindTest9226);
                    documentTest469=documentTest();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, documentTest469.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2029:5: elementTest
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_elementTest_in_kindTest9232);
                    elementTest470=elementTest();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, elementTest470.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 3 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2030:5: attributeTest
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_attributeTest_in_kindTest9238);
                    attributeTest471=attributeTest();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, attributeTest471.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 4 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2031:5: schemaElementTest
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_schemaElementTest_in_kindTest9244);
                    schemaElementTest472=schemaElementTest();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, schemaElementTest472.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 5 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2032:5: schemaAttributeTest
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_schemaAttributeTest_in_kindTest9250);
                    schemaAttributeTest473=schemaAttributeTest();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, schemaAttributeTest473.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 6 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2033:5: piTest
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_piTest_in_kindTest9256);
                    piTest474=piTest();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, piTest474.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 7 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2034:5: commentTest
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_commentTest_in_kindTest9262);
                    commentTest475=commentTest();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, commentTest475.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 8 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2035:5: textTest
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_textTest_in_kindTest9268);
                    textTest476=textTest();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, textTest476.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 9 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2036:5: anyKindTest
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_anyKindTest_in_kindTest9274);
                    anyKindTest477=anyKindTest();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, anyKindTest477.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "kindTest"

    public static class anyKindTest_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "anyKindTest"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2039:1: anyKindTest : NODE LPAR RPAR ;
    public final XSPARQLRewriter.anyKindTest_return anyKindTest() throws RecognitionException {
        XSPARQLRewriter.anyKindTest_return retval = new XSPARQLRewriter.anyKindTest_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree NODE478=null;
        CommonTree LPAR479=null;
        CommonTree RPAR480=null;

        CommonTree NODE478_tree=null;
        CommonTree LPAR479_tree=null;
        CommonTree RPAR480_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2040:3: ( NODE LPAR RPAR )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2040:5: NODE LPAR RPAR
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            NODE478=(CommonTree)match(input,NODE,FOLLOW_NODE_in_anyKindTest9287); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            NODE478_tree = (CommonTree)adaptor.dupNode(NODE478);

            adaptor.addChild(root_0, NODE478_tree);
            }
            _last = (CommonTree)input.LT(1);
            LPAR479=(CommonTree)match(input,LPAR,FOLLOW_LPAR_in_anyKindTest9289); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            LPAR479_tree = (CommonTree)adaptor.dupNode(LPAR479);

            adaptor.addChild(root_0, LPAR479_tree);
            }
            _last = (CommonTree)input.LT(1);
            RPAR480=(CommonTree)match(input,RPAR,FOLLOW_RPAR_in_anyKindTest9291); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            RPAR480_tree = (CommonTree)adaptor.dupNode(RPAR480);

            adaptor.addChild(root_0, RPAR480_tree);
            }

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "anyKindTest"

    public static class documentTest_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "documentTest"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2043:1: documentTest : DOCUMENTNODE LPAR ( elementTest | schemaElementTest )? RPAR ;
    public final XSPARQLRewriter.documentTest_return documentTest() throws RecognitionException {
        XSPARQLRewriter.documentTest_return retval = new XSPARQLRewriter.documentTest_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree DOCUMENTNODE481=null;
        CommonTree LPAR482=null;
        CommonTree RPAR485=null;
        XSPARQLRewriter.elementTest_return elementTest483 = null;

        XSPARQLRewriter.schemaElementTest_return schemaElementTest484 = null;


        CommonTree DOCUMENTNODE481_tree=null;
        CommonTree LPAR482_tree=null;
        CommonTree RPAR485_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2044:3: ( DOCUMENTNODE LPAR ( elementTest | schemaElementTest )? RPAR )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2044:5: DOCUMENTNODE LPAR ( elementTest | schemaElementTest )? RPAR
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            DOCUMENTNODE481=(CommonTree)match(input,DOCUMENTNODE,FOLLOW_DOCUMENTNODE_in_documentTest9304); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            DOCUMENTNODE481_tree = (CommonTree)adaptor.dupNode(DOCUMENTNODE481);

            adaptor.addChild(root_0, DOCUMENTNODE481_tree);
            }
            _last = (CommonTree)input.LT(1);
            LPAR482=(CommonTree)match(input,LPAR,FOLLOW_LPAR_in_documentTest9306); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            LPAR482_tree = (CommonTree)adaptor.dupNode(LPAR482);

            adaptor.addChild(root_0, LPAR482_tree);
            }
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2044:23: ( elementTest | schemaElementTest )?
            int alt134=3;
            switch ( input.LA(1) ) {
                case ELEMENT:
                    {
                    alt134=1;
                    }
                    break;
                case SCHEMAELEMENT:
                    {
                    alt134=2;
                    }
                    break;
            }

            switch (alt134) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2044:24: elementTest
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_elementTest_in_documentTest9309);
                    elementTest483=elementTest();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, elementTest483.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2044:38: schemaElementTest
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_schemaElementTest_in_documentTest9313);
                    schemaElementTest484=schemaElementTest();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, schemaElementTest484.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }

            _last = (CommonTree)input.LT(1);
            RPAR485=(CommonTree)match(input,RPAR,FOLLOW_RPAR_in_documentTest9317); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            RPAR485_tree = (CommonTree)adaptor.dupNode(RPAR485);

            adaptor.addChild(root_0, RPAR485_tree);
            }

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "documentTest"

    public static class textTest_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "textTest"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2047:1: textTest : TEXT LPAR RPAR ;
    public final XSPARQLRewriter.textTest_return textTest() throws RecognitionException {
        XSPARQLRewriter.textTest_return retval = new XSPARQLRewriter.textTest_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree TEXT486=null;
        CommonTree LPAR487=null;
        CommonTree RPAR488=null;

        CommonTree TEXT486_tree=null;
        CommonTree LPAR487_tree=null;
        CommonTree RPAR488_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2048:3: ( TEXT LPAR RPAR )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2048:5: TEXT LPAR RPAR
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            TEXT486=(CommonTree)match(input,TEXT,FOLLOW_TEXT_in_textTest9330); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            TEXT486_tree = (CommonTree)adaptor.dupNode(TEXT486);

            adaptor.addChild(root_0, TEXT486_tree);
            }
            _last = (CommonTree)input.LT(1);
            LPAR487=(CommonTree)match(input,LPAR,FOLLOW_LPAR_in_textTest9332); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            LPAR487_tree = (CommonTree)adaptor.dupNode(LPAR487);

            adaptor.addChild(root_0, LPAR487_tree);
            }
            _last = (CommonTree)input.LT(1);
            RPAR488=(CommonTree)match(input,RPAR,FOLLOW_RPAR_in_textTest9334); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            RPAR488_tree = (CommonTree)adaptor.dupNode(RPAR488);

            adaptor.addChild(root_0, RPAR488_tree);
            }

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "textTest"

    public static class commentTest_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "commentTest"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2051:1: commentTest : COMMENT LPAR RPAR ;
    public final XSPARQLRewriter.commentTest_return commentTest() throws RecognitionException {
        XSPARQLRewriter.commentTest_return retval = new XSPARQLRewriter.commentTest_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree COMMENT489=null;
        CommonTree LPAR490=null;
        CommonTree RPAR491=null;

        CommonTree COMMENT489_tree=null;
        CommonTree LPAR490_tree=null;
        CommonTree RPAR491_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2052:3: ( COMMENT LPAR RPAR )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2052:5: COMMENT LPAR RPAR
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            COMMENT489=(CommonTree)match(input,COMMENT,FOLLOW_COMMENT_in_commentTest9347); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            COMMENT489_tree = (CommonTree)adaptor.dupNode(COMMENT489);

            adaptor.addChild(root_0, COMMENT489_tree);
            }
            _last = (CommonTree)input.LT(1);
            LPAR490=(CommonTree)match(input,LPAR,FOLLOW_LPAR_in_commentTest9349); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            LPAR490_tree = (CommonTree)adaptor.dupNode(LPAR490);

            adaptor.addChild(root_0, LPAR490_tree);
            }
            _last = (CommonTree)input.LT(1);
            RPAR491=(CommonTree)match(input,RPAR,FOLLOW_RPAR_in_commentTest9351); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            RPAR491_tree = (CommonTree)adaptor.dupNode(RPAR491);

            adaptor.addChild(root_0, RPAR491_tree);
            }

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "commentTest"

    public static class piTest_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "piTest"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2055:1: piTest : PROCESSINGINSTRUCTION LPAR ( NCNAME | stringliteral )? RPAR ;
    public final XSPARQLRewriter.piTest_return piTest() throws RecognitionException {
        XSPARQLRewriter.piTest_return retval = new XSPARQLRewriter.piTest_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree PROCESSINGINSTRUCTION492=null;
        CommonTree LPAR493=null;
        CommonTree NCNAME494=null;
        CommonTree RPAR496=null;
        XSPARQLRewriter.stringliteral_return stringliteral495 = null;


        CommonTree PROCESSINGINSTRUCTION492_tree=null;
        CommonTree LPAR493_tree=null;
        CommonTree NCNAME494_tree=null;
        CommonTree RPAR496_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2056:3: ( PROCESSINGINSTRUCTION LPAR ( NCNAME | stringliteral )? RPAR )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2056:5: PROCESSINGINSTRUCTION LPAR ( NCNAME | stringliteral )? RPAR
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            PROCESSINGINSTRUCTION492=(CommonTree)match(input,PROCESSINGINSTRUCTION,FOLLOW_PROCESSINGINSTRUCTION_in_piTest9364); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            PROCESSINGINSTRUCTION492_tree = (CommonTree)adaptor.dupNode(PROCESSINGINSTRUCTION492);

            adaptor.addChild(root_0, PROCESSINGINSTRUCTION492_tree);
            }
            _last = (CommonTree)input.LT(1);
            LPAR493=(CommonTree)match(input,LPAR,FOLLOW_LPAR_in_piTest9366); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            LPAR493_tree = (CommonTree)adaptor.dupNode(LPAR493);

            adaptor.addChild(root_0, LPAR493_tree);
            }
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2056:32: ( NCNAME | stringliteral )?
            int alt135=3;
            switch ( input.LA(1) ) {
                case NCNAME:
                    {
                    alt135=1;
                    }
                    break;
                case QSTRING:
                    {
                    alt135=2;
                    }
                    break;
            }

            switch (alt135) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2056:33: NCNAME
                    {
                    _last = (CommonTree)input.LT(1);
                    NCNAME494=(CommonTree)match(input,NCNAME,FOLLOW_NCNAME_in_piTest9369); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    NCNAME494_tree = (CommonTree)adaptor.dupNode(NCNAME494);

                    adaptor.addChild(root_0, NCNAME494_tree);
                    }

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2056:42: stringliteral
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_stringliteral_in_piTest9373);
                    stringliteral495=stringliteral();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, stringliteral495.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }

            _last = (CommonTree)input.LT(1);
            RPAR496=(CommonTree)match(input,RPAR,FOLLOW_RPAR_in_piTest9377); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            RPAR496_tree = (CommonTree)adaptor.dupNode(RPAR496);

            adaptor.addChild(root_0, RPAR496_tree);
            }

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "piTest"

    public static class attributeTest_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "attributeTest"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2059:1: attributeTest : ATTRIBUTE LPAR ( attributeNameOrWildcard ( COMMA typeName )? )? RPAR ;
    public final XSPARQLRewriter.attributeTest_return attributeTest() throws RecognitionException {
        XSPARQLRewriter.attributeTest_return retval = new XSPARQLRewriter.attributeTest_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree ATTRIBUTE497=null;
        CommonTree LPAR498=null;
        CommonTree COMMA500=null;
        CommonTree RPAR502=null;
        XSPARQLRewriter.attributeNameOrWildcard_return attributeNameOrWildcard499 = null;

        XSPARQLRewriter.typeName_return typeName501 = null;


        CommonTree ATTRIBUTE497_tree=null;
        CommonTree LPAR498_tree=null;
        CommonTree COMMA500_tree=null;
        CommonTree RPAR502_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2060:3: ( ATTRIBUTE LPAR ( attributeNameOrWildcard ( COMMA typeName )? )? RPAR )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2060:5: ATTRIBUTE LPAR ( attributeNameOrWildcard ( COMMA typeName )? )? RPAR
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            ATTRIBUTE497=(CommonTree)match(input,ATTRIBUTE,FOLLOW_ATTRIBUTE_in_attributeTest9390); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            ATTRIBUTE497_tree = (CommonTree)adaptor.dupNode(ATTRIBUTE497);

            adaptor.addChild(root_0, ATTRIBUTE497_tree);
            }
            _last = (CommonTree)input.LT(1);
            LPAR498=(CommonTree)match(input,LPAR,FOLLOW_LPAR_in_attributeTest9392); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            LPAR498_tree = (CommonTree)adaptor.dupNode(LPAR498);

            adaptor.addChild(root_0, LPAR498_tree);
            }
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2060:20: ( attributeNameOrWildcard ( COMMA typeName )? )?
            int alt137=2;
            switch ( input.LA(1) ) {
                case NCNAME:
                case STAR:
                case PNAME_NS:
                case PNAME_LN:
                case A:
                case FROM:
                case TO:
                case ITEM:
                case NODE:
                case COMMENT:
                case ROW:
                    {
                    alt137=1;
                    }
                    break;
            }

            switch (alt137) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2060:21: attributeNameOrWildcard ( COMMA typeName )?
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_attributeNameOrWildcard_in_attributeTest9395);
                    attributeNameOrWildcard499=attributeNameOrWildcard();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, attributeNameOrWildcard499.getTree());
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2060:45: ( COMMA typeName )?
                    int alt136=2;
                    switch ( input.LA(1) ) {
                        case COMMA:
                            {
                            alt136=1;
                            }
                            break;
                    }

                    switch (alt136) {
                        case 1 :
                            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2060:46: COMMA typeName
                            {
                            _last = (CommonTree)input.LT(1);
                            COMMA500=(CommonTree)match(input,COMMA,FOLLOW_COMMA_in_attributeTest9398); if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                            COMMA500_tree = (CommonTree)adaptor.dupNode(COMMA500);

                            adaptor.addChild(root_0, COMMA500_tree);
                            }
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_typeName_in_attributeTest9400);
                            typeName501=typeName();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) 
                            adaptor.addChild(root_0, typeName501.getTree());

                            if ( state.backtracking==0 ) {
                            }
                            }
                            break;

                    }


                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }

            _last = (CommonTree)input.LT(1);
            RPAR502=(CommonTree)match(input,RPAR,FOLLOW_RPAR_in_attributeTest9406); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            RPAR502_tree = (CommonTree)adaptor.dupNode(RPAR502);

            adaptor.addChild(root_0, RPAR502_tree);
            }

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "attributeTest"

    public static class attributeNameOrWildcard_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "attributeNameOrWildcard"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2063:1: attributeNameOrWildcard : ( attributeName | STAR );
    public final XSPARQLRewriter.attributeNameOrWildcard_return attributeNameOrWildcard() throws RecognitionException {
        XSPARQLRewriter.attributeNameOrWildcard_return retval = new XSPARQLRewriter.attributeNameOrWildcard_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree STAR504=null;
        XSPARQLRewriter.attributeName_return attributeName503 = null;


        CommonTree STAR504_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2064:3: ( attributeName | STAR )
            int alt138=2;
            switch ( input.LA(1) ) {
            case NCNAME:
            case PNAME_NS:
            case PNAME_LN:
            case A:
            case FROM:
            case TO:
            case ITEM:
            case NODE:
            case COMMENT:
            case ROW:
                {
                alt138=1;
                }
                break;
            case STAR:
                {
                alt138=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 138, 0, input);

                throw nvae;
            }

            switch (alt138) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2064:5: attributeName
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_attributeName_in_attributeNameOrWildcard9419);
                    attributeName503=attributeName();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, attributeName503.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2064:21: STAR
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    STAR504=(CommonTree)match(input,STAR,FOLLOW_STAR_in_attributeNameOrWildcard9423); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    STAR504_tree = (CommonTree)adaptor.dupNode(STAR504);

                    adaptor.addChild(root_0, STAR504_tree);
                    }

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "attributeNameOrWildcard"

    public static class schemaAttributeTest_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "schemaAttributeTest"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2067:1: schemaAttributeTest : SCHEMAATTRIBUTE LPAR attributeDeclaration RPAR ;
    public final XSPARQLRewriter.schemaAttributeTest_return schemaAttributeTest() throws RecognitionException {
        XSPARQLRewriter.schemaAttributeTest_return retval = new XSPARQLRewriter.schemaAttributeTest_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree SCHEMAATTRIBUTE505=null;
        CommonTree LPAR506=null;
        CommonTree RPAR508=null;
        XSPARQLRewriter.attributeDeclaration_return attributeDeclaration507 = null;


        CommonTree SCHEMAATTRIBUTE505_tree=null;
        CommonTree LPAR506_tree=null;
        CommonTree RPAR508_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2068:3: ( SCHEMAATTRIBUTE LPAR attributeDeclaration RPAR )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2068:5: SCHEMAATTRIBUTE LPAR attributeDeclaration RPAR
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            SCHEMAATTRIBUTE505=(CommonTree)match(input,SCHEMAATTRIBUTE,FOLLOW_SCHEMAATTRIBUTE_in_schemaAttributeTest9436); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            SCHEMAATTRIBUTE505_tree = (CommonTree)adaptor.dupNode(SCHEMAATTRIBUTE505);

            adaptor.addChild(root_0, SCHEMAATTRIBUTE505_tree);
            }
            _last = (CommonTree)input.LT(1);
            LPAR506=(CommonTree)match(input,LPAR,FOLLOW_LPAR_in_schemaAttributeTest9438); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            LPAR506_tree = (CommonTree)adaptor.dupNode(LPAR506);

            adaptor.addChild(root_0, LPAR506_tree);
            }
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_attributeDeclaration_in_schemaAttributeTest9440);
            attributeDeclaration507=attributeDeclaration();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_0, attributeDeclaration507.getTree());
            _last = (CommonTree)input.LT(1);
            RPAR508=(CommonTree)match(input,RPAR,FOLLOW_RPAR_in_schemaAttributeTest9442); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            RPAR508_tree = (CommonTree)adaptor.dupNode(RPAR508);

            adaptor.addChild(root_0, RPAR508_tree);
            }

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "schemaAttributeTest"

    public static class attributeDeclaration_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "attributeDeclaration"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2071:1: attributeDeclaration : attributeName ;
    public final XSPARQLRewriter.attributeDeclaration_return attributeDeclaration() throws RecognitionException {
        XSPARQLRewriter.attributeDeclaration_return retval = new XSPARQLRewriter.attributeDeclaration_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.attributeName_return attributeName509 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2072:3: ( attributeName )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2072:5: attributeName
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_attributeName_in_attributeDeclaration9455);
            attributeName509=attributeName();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_0, attributeName509.getTree());

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "attributeDeclaration"

    public static class elementTest_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "elementTest"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2075:1: elementTest : ELEMENT LPAR ( elementNameOrWildcard ( COMMA typeName ( QUESTIONMARK )? )? )? RPAR ;
    public final XSPARQLRewriter.elementTest_return elementTest() throws RecognitionException {
        XSPARQLRewriter.elementTest_return retval = new XSPARQLRewriter.elementTest_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree ELEMENT510=null;
        CommonTree LPAR511=null;
        CommonTree COMMA513=null;
        CommonTree QUESTIONMARK515=null;
        CommonTree RPAR516=null;
        XSPARQLRewriter.elementNameOrWildcard_return elementNameOrWildcard512 = null;

        XSPARQLRewriter.typeName_return typeName514 = null;


        CommonTree ELEMENT510_tree=null;
        CommonTree LPAR511_tree=null;
        CommonTree COMMA513_tree=null;
        CommonTree QUESTIONMARK515_tree=null;
        CommonTree RPAR516_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2076:3: ( ELEMENT LPAR ( elementNameOrWildcard ( COMMA typeName ( QUESTIONMARK )? )? )? RPAR )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2076:5: ELEMENT LPAR ( elementNameOrWildcard ( COMMA typeName ( QUESTIONMARK )? )? )? RPAR
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            ELEMENT510=(CommonTree)match(input,ELEMENT,FOLLOW_ELEMENT_in_elementTest9468); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            ELEMENT510_tree = (CommonTree)adaptor.dupNode(ELEMENT510);

            adaptor.addChild(root_0, ELEMENT510_tree);
            }
            _last = (CommonTree)input.LT(1);
            LPAR511=(CommonTree)match(input,LPAR,FOLLOW_LPAR_in_elementTest9470); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            LPAR511_tree = (CommonTree)adaptor.dupNode(LPAR511);

            adaptor.addChild(root_0, LPAR511_tree);
            }
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2076:18: ( elementNameOrWildcard ( COMMA typeName ( QUESTIONMARK )? )? )?
            int alt141=2;
            switch ( input.LA(1) ) {
                case NCNAME:
                case STAR:
                case PNAME_NS:
                case PNAME_LN:
                case A:
                case FROM:
                case TO:
                case ITEM:
                case NODE:
                case COMMENT:
                case ROW:
                    {
                    alt141=1;
                    }
                    break;
            }

            switch (alt141) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2076:19: elementNameOrWildcard ( COMMA typeName ( QUESTIONMARK )? )?
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_elementNameOrWildcard_in_elementTest9473);
                    elementNameOrWildcard512=elementNameOrWildcard();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, elementNameOrWildcard512.getTree());
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2076:41: ( COMMA typeName ( QUESTIONMARK )? )?
                    int alt140=2;
                    switch ( input.LA(1) ) {
                        case COMMA:
                            {
                            alt140=1;
                            }
                            break;
                    }

                    switch (alt140) {
                        case 1 :
                            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2076:42: COMMA typeName ( QUESTIONMARK )?
                            {
                            _last = (CommonTree)input.LT(1);
                            COMMA513=(CommonTree)match(input,COMMA,FOLLOW_COMMA_in_elementTest9476); if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                            COMMA513_tree = (CommonTree)adaptor.dupNode(COMMA513);

                            adaptor.addChild(root_0, COMMA513_tree);
                            }
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_typeName_in_elementTest9478);
                            typeName514=typeName();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) 
                            adaptor.addChild(root_0, typeName514.getTree());
                            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2076:57: ( QUESTIONMARK )?
                            int alt139=2;
                            switch ( input.LA(1) ) {
                                case QUESTIONMARK:
                                    {
                                    alt139=1;
                                    }
                                    break;
                            }

                            switch (alt139) {
                                case 1 :
                                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: QUESTIONMARK
                                    {
                                    _last = (CommonTree)input.LT(1);
                                    QUESTIONMARK515=(CommonTree)match(input,QUESTIONMARK,FOLLOW_QUESTIONMARK_in_elementTest9480); if (state.failed) return retval;
                                    if ( state.backtracking==0 ) {
                                    QUESTIONMARK515_tree = (CommonTree)adaptor.dupNode(QUESTIONMARK515);

                                    adaptor.addChild(root_0, QUESTIONMARK515_tree);
                                    }

                                    if ( state.backtracking==0 ) {
                                    }
                                    }
                                    break;

                            }


                            if ( state.backtracking==0 ) {
                            }
                            }
                            break;

                    }


                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }

            _last = (CommonTree)input.LT(1);
            RPAR516=(CommonTree)match(input,RPAR,FOLLOW_RPAR_in_elementTest9487); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            RPAR516_tree = (CommonTree)adaptor.dupNode(RPAR516);

            adaptor.addChild(root_0, RPAR516_tree);
            }

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "elementTest"

    public static class elementNameOrWildcard_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "elementNameOrWildcard"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2079:1: elementNameOrWildcard : ( elementName | STAR );
    public final XSPARQLRewriter.elementNameOrWildcard_return elementNameOrWildcard() throws RecognitionException {
        XSPARQLRewriter.elementNameOrWildcard_return retval = new XSPARQLRewriter.elementNameOrWildcard_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree STAR518=null;
        XSPARQLRewriter.elementName_return elementName517 = null;


        CommonTree STAR518_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2080:3: ( elementName | STAR )
            int alt142=2;
            switch ( input.LA(1) ) {
            case NCNAME:
            case PNAME_NS:
            case PNAME_LN:
            case A:
            case FROM:
            case TO:
            case ITEM:
            case NODE:
            case COMMENT:
            case ROW:
                {
                alt142=1;
                }
                break;
            case STAR:
                {
                alt142=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 142, 0, input);

                throw nvae;
            }

            switch (alt142) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2080:5: elementName
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_elementName_in_elementNameOrWildcard9500);
                    elementName517=elementName();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, elementName517.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2080:19: STAR
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    STAR518=(CommonTree)match(input,STAR,FOLLOW_STAR_in_elementNameOrWildcard9504); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    STAR518_tree = (CommonTree)adaptor.dupNode(STAR518);

                    adaptor.addChild(root_0, STAR518_tree);
                    }

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "elementNameOrWildcard"

    public static class schemaElementTest_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "schemaElementTest"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2083:1: schemaElementTest : SCHEMAELEMENT LPAR elementDeclaration RPAR ;
    public final XSPARQLRewriter.schemaElementTest_return schemaElementTest() throws RecognitionException {
        XSPARQLRewriter.schemaElementTest_return retval = new XSPARQLRewriter.schemaElementTest_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree SCHEMAELEMENT519=null;
        CommonTree LPAR520=null;
        CommonTree RPAR522=null;
        XSPARQLRewriter.elementDeclaration_return elementDeclaration521 = null;


        CommonTree SCHEMAELEMENT519_tree=null;
        CommonTree LPAR520_tree=null;
        CommonTree RPAR522_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2084:3: ( SCHEMAELEMENT LPAR elementDeclaration RPAR )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2084:5: SCHEMAELEMENT LPAR elementDeclaration RPAR
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            SCHEMAELEMENT519=(CommonTree)match(input,SCHEMAELEMENT,FOLLOW_SCHEMAELEMENT_in_schemaElementTest9517); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            SCHEMAELEMENT519_tree = (CommonTree)adaptor.dupNode(SCHEMAELEMENT519);

            adaptor.addChild(root_0, SCHEMAELEMENT519_tree);
            }
            _last = (CommonTree)input.LT(1);
            LPAR520=(CommonTree)match(input,LPAR,FOLLOW_LPAR_in_schemaElementTest9519); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            LPAR520_tree = (CommonTree)adaptor.dupNode(LPAR520);

            adaptor.addChild(root_0, LPAR520_tree);
            }
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_elementDeclaration_in_schemaElementTest9521);
            elementDeclaration521=elementDeclaration();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_0, elementDeclaration521.getTree());
            _last = (CommonTree)input.LT(1);
            RPAR522=(CommonTree)match(input,RPAR,FOLLOW_RPAR_in_schemaElementTest9523); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            RPAR522_tree = (CommonTree)adaptor.dupNode(RPAR522);

            adaptor.addChild(root_0, RPAR522_tree);
            }

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "schemaElementTest"

    public static class elementDeclaration_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "elementDeclaration"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2087:1: elementDeclaration : elementName ;
    public final XSPARQLRewriter.elementDeclaration_return elementDeclaration() throws RecognitionException {
        XSPARQLRewriter.elementDeclaration_return retval = new XSPARQLRewriter.elementDeclaration_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.elementName_return elementName523 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2088:3: ( elementName )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2088:5: elementName
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_elementName_in_elementDeclaration9536);
            elementName523=elementName();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_0, elementName523.getTree());

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "elementDeclaration"

    public static class attributeName_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "attributeName"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2091:1: attributeName : qname ;
    public final XSPARQLRewriter.attributeName_return attributeName() throws RecognitionException {
        XSPARQLRewriter.attributeName_return retval = new XSPARQLRewriter.attributeName_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.qname_return qname524 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2092:3: ( qname )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2092:5: qname
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_qname_in_attributeName9549);
            qname524=qname();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_0, qname524.getTree());

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "attributeName"

    public static class elementName_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "elementName"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2095:1: elementName : qname ;
    public final XSPARQLRewriter.elementName_return elementName() throws RecognitionException {
        XSPARQLRewriter.elementName_return retval = new XSPARQLRewriter.elementName_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.qname_return qname525 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2096:3: ( qname )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2096:5: qname
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_qname_in_elementName9562);
            qname525=qname();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_0, qname525.getTree());

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "elementName"

    public static class typeName_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "typeName"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2099:1: typeName : qname ;
    public final XSPARQLRewriter.typeName_return typeName() throws RecognitionException {
        XSPARQLRewriter.typeName_return retval = new XSPARQLRewriter.typeName_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.qname_return qname526 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2100:3: ( qname )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2100:5: qname
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_qname_in_typeName9575);
            qname526=qname();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_0, qname526.getTree());

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "typeName"

    public static class uriliteral_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "uriliteral"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2103:1: uriliteral : stringliteral ;
    public final XSPARQLRewriter.uriliteral_return uriliteral() throws RecognitionException {
        XSPARQLRewriter.uriliteral_return retval = new XSPARQLRewriter.uriliteral_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.stringliteral_return stringliteral527 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2104:3: ( stringliteral )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2104:5: stringliteral
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_stringliteral_in_uriliteral9588);
            stringliteral527=stringliteral();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_0, stringliteral527.getTree());

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "uriliteral"

    public static class integerLiteral_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "integerLiteral"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2107:1: integerLiteral : INTEGER ;
    public final XSPARQLRewriter.integerLiteral_return integerLiteral() throws RecognitionException {
        XSPARQLRewriter.integerLiteral_return retval = new XSPARQLRewriter.integerLiteral_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree INTEGER528=null;

        CommonTree INTEGER528_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2108:3: ( INTEGER )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2108:5: INTEGER
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            INTEGER528=(CommonTree)match(input,INTEGER,FOLLOW_INTEGER_in_integerLiteral9601); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            INTEGER528_tree = (CommonTree)adaptor.dupNode(INTEGER528);

            adaptor.addChild(root_0, INTEGER528_tree);
            }

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "integerLiteral"

    public static class decimalLiteral_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "decimalLiteral"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2111:1: decimalLiteral : DECIMAL ;
    public final XSPARQLRewriter.decimalLiteral_return decimalLiteral() throws RecognitionException {
        XSPARQLRewriter.decimalLiteral_return retval = new XSPARQLRewriter.decimalLiteral_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree DECIMAL529=null;

        CommonTree DECIMAL529_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2112:3: ( DECIMAL )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2112:5: DECIMAL
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            DECIMAL529=(CommonTree)match(input,DECIMAL,FOLLOW_DECIMAL_in_decimalLiteral9614); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            DECIMAL529_tree = (CommonTree)adaptor.dupNode(DECIMAL529);

            adaptor.addChild(root_0, DECIMAL529_tree);
            }

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "decimalLiteral"

    public static class stringliteral_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "stringliteral"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2115:1: stringliteral : QSTRING ;
    public final XSPARQLRewriter.stringliteral_return stringliteral() throws RecognitionException {
        XSPARQLRewriter.stringliteral_return retval = new XSPARQLRewriter.stringliteral_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree QSTRING530=null;

        CommonTree QSTRING530_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2116:3: ( QSTRING )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2116:5: QSTRING
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            QSTRING530=(CommonTree)match(input,QSTRING,FOLLOW_QSTRING_in_stringliteral9627); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            QSTRING530_tree = (CommonTree)adaptor.dupNode(QSTRING530);

            adaptor.addChild(root_0, QSTRING530_tree);
            }

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "stringliteral"

    public static class baseDecl_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "baseDecl"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2135:1: baseDecl : ^( T_NAMESPACE BASE irix= IRIREF ) ->;
    public final XSPARQLRewriter.baseDecl_return baseDecl() throws RecognitionException {
        XSPARQLRewriter.baseDecl_return retval = new XSPARQLRewriter.baseDecl_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree irix=null;
        CommonTree T_NAMESPACE531=null;
        CommonTree BASE532=null;

        CommonTree irix_tree=null;
        CommonTree T_NAMESPACE531_tree=null;
        CommonTree BASE532_tree=null;
        RewriteRuleNodeStream stream_IRIREF=new RewriteRuleNodeStream(adaptor,"token IRIREF");
        RewriteRuleNodeStream stream_T_NAMESPACE=new RewriteRuleNodeStream(adaptor,"token T_NAMESPACE");
        RewriteRuleNodeStream stream_BASE=new RewriteRuleNodeStream(adaptor,"token BASE");

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2136:3: ( ^( T_NAMESPACE BASE irix= IRIREF ) ->)
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2136:5: ^( T_NAMESPACE BASE irix= IRIREF )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            T_NAMESPACE531=(CommonTree)match(input,T_NAMESPACE,FOLLOW_T_NAMESPACE_in_baseDecl9657); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_T_NAMESPACE.add(T_NAMESPACE531);



            match(input, Token.DOWN, null); if (state.failed) return retval;
            _last = (CommonTree)input.LT(1);
            BASE532=(CommonTree)match(input,BASE,FOLLOW_BASE_in_baseDecl9659); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_BASE.add(BASE532);

            _last = (CommonTree)input.LT(1);
            irix=(CommonTree)match(input,IRIREF,FOLLOW_IRIREF_in_baseDecl9663); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IRIREF.add(irix);


            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }

            if ( state.backtracking==0 ) {
              basePrefix = (irix!=null?irix.getText():null);
            }


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 2137:3: ->
            {
                root_0 = null;
            }

            retval.tree = root_0;}
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "baseDecl"

    public static class prefixDecl_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "prefixDecl"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2140:1: prefixDecl : ( ^( T_NAMESPACE DEFAULT irix= QSTRING ) -> | ^( T_NAMESPACE p= PNAME_NS irix= QSTRING ) -> ^( T_NAMESPACE NCNAME[$p.token, $p.text] QSTRING ) );
    public final XSPARQLRewriter.prefixDecl_return prefixDecl() throws RecognitionException {
        XSPARQLRewriter.prefixDecl_return retval = new XSPARQLRewriter.prefixDecl_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree irix=null;
        CommonTree p=null;
        CommonTree T_NAMESPACE533=null;
        CommonTree DEFAULT534=null;
        CommonTree T_NAMESPACE535=null;

        CommonTree irix_tree=null;
        CommonTree p_tree=null;
        CommonTree T_NAMESPACE533_tree=null;
        CommonTree DEFAULT534_tree=null;
        CommonTree T_NAMESPACE535_tree=null;
        RewriteRuleNodeStream stream_QSTRING=new RewriteRuleNodeStream(adaptor,"token QSTRING");
        RewriteRuleNodeStream stream_PNAME_NS=new RewriteRuleNodeStream(adaptor,"token PNAME_NS");
        RewriteRuleNodeStream stream_T_NAMESPACE=new RewriteRuleNodeStream(adaptor,"token T_NAMESPACE");
        RewriteRuleNodeStream stream_DEFAULT=new RewriteRuleNodeStream(adaptor,"token DEFAULT");

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2141:3: ( ^( T_NAMESPACE DEFAULT irix= QSTRING ) -> | ^( T_NAMESPACE p= PNAME_NS irix= QSTRING ) -> ^( T_NAMESPACE NCNAME[$p.token, $p.text] QSTRING ) )
            int alt143=2;
            switch ( input.LA(1) ) {
            case T_NAMESPACE:
                {
                switch ( input.LA(2) ) {
                case DOWN:
                    {
                    switch ( input.LA(3) ) {
                    case DEFAULT:
                        {
                        alt143=1;
                        }
                        break;
                    case PNAME_NS:
                        {
                        alt143=2;
                        }
                        break;
                    default:
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 143, 2, input);

                        throw nvae;
                    }

                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 143, 1, input);

                    throw nvae;
                }

                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 143, 0, input);

                throw nvae;
            }

            switch (alt143) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2141:5: ^( T_NAMESPACE DEFAULT irix= QSTRING )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    T_NAMESPACE533=(CommonTree)match(input,T_NAMESPACE,FOLLOW_T_NAMESPACE_in_prefixDecl9684); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_T_NAMESPACE.add(T_NAMESPACE533);



                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    DEFAULT534=(CommonTree)match(input,DEFAULT,FOLLOW_DEFAULT_in_prefixDecl9686); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_DEFAULT.add(DEFAULT534);

                    _last = (CommonTree)input.LT(1);
                    irix=(CommonTree)match(input,QSTRING,FOLLOW_QSTRING_in_prefixDecl9690); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_QSTRING.add(irix);


                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }

                    if ( state.backtracking==0 ) {
                      addNamespace(":", (irix!=null?irix.getText():null));
                    }


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 2142:3: ->
                    {
                        root_0 = null;
                    }

                    retval.tree = root_0;}
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2143:5: ^( T_NAMESPACE p= PNAME_NS irix= QSTRING )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    T_NAMESPACE535=(CommonTree)match(input,T_NAMESPACE,FOLLOW_T_NAMESPACE_in_prefixDecl9706); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_T_NAMESPACE.add(T_NAMESPACE535);



                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    p=(CommonTree)match(input,PNAME_NS,FOLLOW_PNAME_NS_in_prefixDecl9710); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_PNAME_NS.add(p);

                    _last = (CommonTree)input.LT(1);
                    irix=(CommonTree)match(input,QSTRING,FOLLOW_QSTRING_in_prefixDecl9714); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_QSTRING.add(irix);


                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }

                    if ( state.backtracking==0 ) {
                      addNamespace((p!=null?p.getText():null), (irix!=null?irix.getText():null));
                    }


                    // AST REWRITE
                    // elements: QSTRING, T_NAMESPACE
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 2144:3: -> ^( T_NAMESPACE NCNAME[$p.token, $p.text] QSTRING )
                    {
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2144:6: ^( T_NAMESPACE NCNAME[$p.token, $p.text] QSTRING )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(stream_T_NAMESPACE.nextNode(), root_1);

                        adaptor.addChild(root_1, (CommonTree)adaptor.create(NCNAME, p.token, (p!=null?p.getText():null)));
                        adaptor.addChild(root_1, stream_QSTRING.nextNode());

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;}
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "prefixDecl"

    public static class datasetClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "datasetClause"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2147:1: datasetClause : ^(f= FROM (d= defaultGraphClause | e= namedGraphClause ) ) -> QSTRING[$f.token, \"\\n \" + $f.text + \" \"] ( $d)? ( $e)? ;
    public final XSPARQLRewriter.datasetClause_return datasetClause() throws RecognitionException {
        XSPARQLRewriter.datasetClause_return retval = new XSPARQLRewriter.datasetClause_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree f=null;
        XSPARQLRewriter.defaultGraphClause_return d = null;

        XSPARQLRewriter.namedGraphClause_return e = null;


        CommonTree f_tree=null;
        RewriteRuleNodeStream stream_FROM=new RewriteRuleNodeStream(adaptor,"token FROM");
        RewriteRuleSubtreeStream stream_namedGraphClause=new RewriteRuleSubtreeStream(adaptor,"rule namedGraphClause");
        RewriteRuleSubtreeStream stream_defaultGraphClause=new RewriteRuleSubtreeStream(adaptor,"rule defaultGraphClause");
        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2148:3: ( ^(f= FROM (d= defaultGraphClause | e= namedGraphClause ) ) -> QSTRING[$f.token, \"\\n \" + $f.text + \" \"] ( $d)? ( $e)? )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2148:5: ^(f= FROM (d= defaultGraphClause | e= namedGraphClause ) )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            f=(CommonTree)match(input,FROM,FOLLOW_FROM_in_datasetClause9746); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_FROM.add(f);


            if ( state.backtracking==0 ) {
               ((VariableScope_scope)VariableScope_stack.peek()).scopedDataset = false; 
            }

            match(input, Token.DOWN, null); if (state.failed) return retval;
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2148:57: (d= defaultGraphClause | e= namedGraphClause )
            int alt144=2;
            switch ( input.LA(1) ) {
            case VAR:
            case IRIREF:
                {
                alt144=1;
                }
                break;
            case NAMED:
                {
                alt144=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 144, 0, input);

                throw nvae;
            }

            switch (alt144) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2148:58: d= defaultGraphClause
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_defaultGraphClause_in_datasetClause9753);
                    d=defaultGraphClause();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_defaultGraphClause.add(d.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2148:81: e= namedGraphClause
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_namedGraphClause_in_datasetClause9759);
                    e=namedGraphClause();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_namedGraphClause.add(e.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }


            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }



            // AST REWRITE
            // elements: e, d
            // token labels: 
            // rule labels: d, e, retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_d=new RewriteRuleSubtreeStream(adaptor,"rule d",d!=null?d.tree:null);
            RewriteRuleSubtreeStream stream_e=new RewriteRuleSubtreeStream(adaptor,"rule e",e!=null?e.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 2149:3: -> QSTRING[$f.token, \"\\n \" + $f.text + \" \"] ( $d)? ( $e)?
            {
                adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, f.token, "\n " + (f!=null?f.getText():null) + " "));
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2149:47: ( $d)?
                if ( stream_d.hasNext() ) {
                    adaptor.addChild(root_0, stream_d.nextTree());

                }
                stream_d.reset();
                // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2149:51: ( $e)?
                if ( stream_e.hasNext() ) {
                    adaptor.addChild(root_0, stream_e.nextTree());

                }
                stream_e.reset();

            }

            retval.tree = root_0;}
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "datasetClause"

    public static class defaultGraphClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "defaultGraphClause"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2154:1: defaultGraphClause : sourceSelector ;
    public final XSPARQLRewriter.defaultGraphClause_return defaultGraphClause() throws RecognitionException {
        XSPARQLRewriter.defaultGraphClause_return retval = new XSPARQLRewriter.defaultGraphClause_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.sourceSelector_return sourceSelector536 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2155:3: ( sourceSelector )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2155:5: sourceSelector
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_sourceSelector_in_defaultGraphClause9792);
            sourceSelector536=sourceSelector();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_0, sourceSelector536.getTree());

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "defaultGraphClause"

    public static class namedGraphClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "namedGraphClause"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2158:1: namedGraphClause : n= NAMED sourceSelector -> QSTRING[$n.token, $n.text] sourceSelector ;
    public final XSPARQLRewriter.namedGraphClause_return namedGraphClause() throws RecognitionException {
        XSPARQLRewriter.namedGraphClause_return retval = new XSPARQLRewriter.namedGraphClause_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree n=null;
        XSPARQLRewriter.sourceSelector_return sourceSelector537 = null;


        CommonTree n_tree=null;
        RewriteRuleNodeStream stream_NAMED=new RewriteRuleNodeStream(adaptor,"token NAMED");
        RewriteRuleSubtreeStream stream_sourceSelector=new RewriteRuleSubtreeStream(adaptor,"rule sourceSelector");
        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2159:3: (n= NAMED sourceSelector -> QSTRING[$n.token, $n.text] sourceSelector )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2159:5: n= NAMED sourceSelector
            {
            _last = (CommonTree)input.LT(1);
            n=(CommonTree)match(input,NAMED,FOLLOW_NAMED_in_namedGraphClause9807); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_NAMED.add(n);

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_sourceSelector_in_namedGraphClause9809);
            sourceSelector537=sourceSelector();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_sourceSelector.add(sourceSelector537.getTree());


            // AST REWRITE
            // elements: sourceSelector
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 2160:3: -> QSTRING[$n.token, $n.text] sourceSelector
            {
                adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, n.token, (n!=null?n.getText():null)));
                adaptor.addChild(root_0, stream_sourceSelector.nextTree());

            }

            retval.tree = root_0;}
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "namedGraphClause"

    public static class sourceSelector_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "sourceSelector"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2163:1: sourceSelector : (i= IRIREF -> QSTRING[$i.token, \"<\" + $i.text + \">\"] | v= VAR -> {isBound(\"\\$_\" + Helper.removeLeading($v.text,\"\\$\")+\"_graph\")}? QSTRING[$v.token, \"<\"] VAR[\"\\$_\" + Helper.removeLeading($v.text,\"\\$\")+\"_graph\"] QSTRING[$v.token, \">\"] -> ^( T_FUNCTION_CALL NCNAME[rdfTermFunction] ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[bindingTermFunction] ^( T_PARAMS $v) ) ) ) );
    public final XSPARQLRewriter.sourceSelector_return sourceSelector() throws RecognitionException {
        XSPARQLRewriter.sourceSelector_return retval = new XSPARQLRewriter.sourceSelector_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree i=null;
        CommonTree v=null;

        CommonTree i_tree=null;
        CommonTree v_tree=null;
        RewriteRuleNodeStream stream_IRIREF=new RewriteRuleNodeStream(adaptor,"token IRIREF");
        RewriteRuleNodeStream stream_VAR=new RewriteRuleNodeStream(adaptor,"token VAR");

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2164:3: (i= IRIREF -> QSTRING[$i.token, \"<\" + $i.text + \">\"] | v= VAR -> {isBound(\"\\$_\" + Helper.removeLeading($v.text,\"\\$\")+\"_graph\")}? QSTRING[$v.token, \"<\"] VAR[\"\\$_\" + Helper.removeLeading($v.text,\"\\$\")+\"_graph\"] QSTRING[$v.token, \">\"] -> ^( T_FUNCTION_CALL NCNAME[rdfTermFunction] ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[bindingTermFunction] ^( T_PARAMS $v) ) ) ) )
            int alt145=2;
            switch ( input.LA(1) ) {
            case IRIREF:
                {
                alt145=1;
                }
                break;
            case VAR:
                {
                alt145=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 145, 0, input);

                throw nvae;
            }

            switch (alt145) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2164:5: i= IRIREF
                    {
                    _last = (CommonTree)input.LT(1);
                    i=(CommonTree)match(input,IRIREF,FOLLOW_IRIREF_in_sourceSelector9833); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_IRIREF.add(i);



                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 2165:3: -> QSTRING[$i.token, \"<\" + $i.text + \">\"]
                    {
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, i.token, "<" + (i!=null?i.getText():null) + ">"));

                    }

                    retval.tree = root_0;}
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2166:5: v= VAR
                    {
                    _last = (CommonTree)input.LT(1);
                    v=(CommonTree)match(input,VAR,FOLLOW_VAR_in_sourceSelector9848); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_VAR.add(v);



                    // AST REWRITE
                    // elements: VAR, v
                    // token labels: v
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleNodeStream stream_v=new RewriteRuleNodeStream(adaptor,"token v",v);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 2167:3: -> {isBound(\"\\$_\" + Helper.removeLeading($v.text,\"\\$\")+\"_graph\")}? QSTRING[$v.token, \"<\"] VAR[\"\\$_\" + Helper.removeLeading($v.text,\"\\$\")+\"_graph\"] QSTRING[$v.token, \">\"]
                    if (isBound("$_" + Helper.removeLeading((v!=null?v.getText():null),"$")+"_graph")) {
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, v.token, "<"));
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(VAR, "$_" + Helper.removeLeading((v!=null?v.getText():null),"$")+"_graph"));
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, v.token, ">"));

                    }
                    else // 2168:3: -> ^( T_FUNCTION_CALL NCNAME[rdfTermFunction] ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[bindingTermFunction] ^( T_PARAMS $v) ) ) )
                    {
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2168:6: ^( T_FUNCTION_CALL NCNAME[rdfTermFunction] ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[bindingTermFunction] ^( T_PARAMS $v) ) ) )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FUNCTION_CALL, "T_FUNCTION_CALL"), root_1);

                        adaptor.addChild(root_1, (CommonTree)adaptor.create(NCNAME, rdfTermFunction));
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2169:9: ^( T_PARAMS ^( T_FUNCTION_CALL NCNAME[bindingTermFunction] ^( T_PARAMS $v) ) )
                        {
                        CommonTree root_2 = (CommonTree)adaptor.nil();
                        root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_PARAMS, "T_PARAMS"), root_2);

                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2170:15: ^( T_FUNCTION_CALL NCNAME[bindingTermFunction] ^( T_PARAMS $v) )
                        {
                        CommonTree root_3 = (CommonTree)adaptor.nil();
                        root_3 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FUNCTION_CALL, "T_FUNCTION_CALL"), root_3);

                        adaptor.addChild(root_3, (CommonTree)adaptor.create(NCNAME, bindingTermFunction));
                        // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2170:61: ^( T_PARAMS $v)
                        {
                        CommonTree root_4 = (CommonTree)adaptor.nil();
                        root_4 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_PARAMS, "T_PARAMS"), root_4);

                        adaptor.addChild(root_4, stream_v.nextNode());

                        adaptor.addChild(root_3, root_4);
                        }

                        adaptor.addChild(root_2, root_3);
                        }

                        adaptor.addChild(root_1, root_2);
                        }

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;}
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "sourceSelector"

    public static class sWhereClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "sWhereClause"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2175:1: sWhereClause : ( ^(w= T_SPARQL_WHERE groupGraphPattern ) -> QSTRING[$w.token, \"\\n \" + $w.text + \" \"] groupGraphPattern | w= T_SPARQL_WHERE -> QSTRING[$w.token, \"\\n \" + $w.text + \" \"] QSTRING[\" { \"] QSTRING[\" } \"] );
    public final XSPARQLRewriter.sWhereClause_return sWhereClause() throws RecognitionException {
        XSPARQLRewriter.sWhereClause_return retval = new XSPARQLRewriter.sWhereClause_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree w=null;
        XSPARQLRewriter.groupGraphPattern_return groupGraphPattern538 = null;


        CommonTree w_tree=null;
        RewriteRuleNodeStream stream_T_SPARQL_WHERE=new RewriteRuleNodeStream(adaptor,"token T_SPARQL_WHERE");
        RewriteRuleSubtreeStream stream_groupGraphPattern=new RewriteRuleSubtreeStream(adaptor,"rule groupGraphPattern");
        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2176:3: ( ^(w= T_SPARQL_WHERE groupGraphPattern ) -> QSTRING[$w.token, \"\\n \" + $w.text + \" \"] groupGraphPattern | w= T_SPARQL_WHERE -> QSTRING[$w.token, \"\\n \" + $w.text + \" \"] QSTRING[\" { \"] QSTRING[\" } \"] )
            int alt146=2;
            switch ( input.LA(1) ) {
            case T_SPARQL_WHERE:
                {
                switch ( input.LA(2) ) {
                case DOWN:
                    {
                    alt146=1;
                    }
                    break;
                case EOF:
                case UP:
                case LIMIT:
                case OFFSET:
                case T_CONSTRUCT:
                case T_RETURN:
                case T_ORDER_BY:
                case T_GROUP_BY:
                case T_HAVING:
                case VALUES:
                    {
                    alt146=2;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 146, 1, input);

                    throw nvae;
                }

                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 146, 0, input);

                throw nvae;
            }

            switch (alt146) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2176:5: ^(w= T_SPARQL_WHERE groupGraphPattern )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    w=(CommonTree)match(input,T_SPARQL_WHERE,FOLLOW_T_SPARQL_WHERE_in_sWhereClause9949); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_T_SPARQL_WHERE.add(w);



                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_groupGraphPattern_in_sWhereClause9951);
                    groupGraphPattern538=groupGraphPattern();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_groupGraphPattern.add(groupGraphPattern538.getTree());

                    match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }



                    // AST REWRITE
                    // elements: groupGraphPattern
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 2177:3: -> QSTRING[$w.token, \"\\n \" + $w.text + \" \"] groupGraphPattern
                    {
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, w.token, "\n " + (w!=null?w.getText():null) + " "));
                        adaptor.addChild(root_0, stream_groupGraphPattern.nextTree());

                    }

                    retval.tree = root_0;}
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2179:5: w= T_SPARQL_WHERE
                    {
                    _last = (CommonTree)input.LT(1);
                    w=(CommonTree)match(input,T_SPARQL_WHERE,FOLLOW_T_SPARQL_WHERE_in_sWhereClause9974); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_T_SPARQL_WHERE.add(w);



                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 2180:3: -> QSTRING[$w.token, \"\\n \" + $w.text + \" \"] QSTRING[\" { \"] QSTRING[\" } \"]
                    {
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, w.token, "\n " + (w!=null?w.getText():null) + " "));
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, " { "));
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, " } "));

                    }

                    retval.tree = root_0;}
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "sWhereClause"

    public static class solutionmodifier_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "solutionmodifier"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2183:1: solutionmodifier : ( groupBy )? ( having )? ( orderclause )? ( limitoffsetclauses )? ;
    public final XSPARQLRewriter.solutionmodifier_return solutionmodifier() throws RecognitionException {
        XSPARQLRewriter.solutionmodifier_return retval = new XSPARQLRewriter.solutionmodifier_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.groupBy_return groupBy539 = null;

        XSPARQLRewriter.having_return having540 = null;

        XSPARQLRewriter.orderclause_return orderclause541 = null;

        XSPARQLRewriter.limitoffsetclauses_return limitoffsetclauses542 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2184:3: ( ( groupBy )? ( having )? ( orderclause )? ( limitoffsetclauses )? )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2184:5: ( groupBy )? ( having )? ( orderclause )? ( limitoffsetclauses )?
            {
            root_0 = (CommonTree)adaptor.nil();

            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2184:5: ( groupBy )?
            int alt147=2;
            switch ( input.LA(1) ) {
                case T_GROUP_BY:
                    {
                    alt147=1;
                    }
                    break;
            }

            switch (alt147) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: groupBy
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_groupBy_in_solutionmodifier10001);
                    groupBy539=groupBy();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, groupBy539.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }

            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2184:14: ( having )?
            int alt148=2;
            switch ( input.LA(1) ) {
                case T_HAVING:
                    {
                    alt148=1;
                    }
                    break;
            }

            switch (alt148) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: having
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_having_in_solutionmodifier10004);
                    having540=having();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, having540.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }

            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2184:22: ( orderclause )?
            int alt149=2;
            switch ( input.LA(1) ) {
                case T_ORDER_BY:
                    {
                    alt149=1;
                    }
                    break;
            }

            switch (alt149) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: orderclause
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_orderclause_in_solutionmodifier10007);
                    orderclause541=orderclause();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, orderclause541.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }

            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2184:35: ( limitoffsetclauses )?
            int alt150=2;
            switch ( input.LA(1) ) {
                case LIMIT:
                case OFFSET:
                    {
                    alt150=1;
                    }
                    break;
            }

            switch (alt150) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: limitoffsetclauses
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_limitoffsetclauses_in_solutionmodifier10010);
                    limitoffsetclauses542=limitoffsetclauses();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, limitoffsetclauses542.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;

            }


            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "solutionmodifier"

    public static class groupBy_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "groupBy"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2189:1: groupBy : ^( T_GROUP_BY ( groupByCondition )+ ) ;
    public final XSPARQLRewriter.groupBy_return groupBy() throws RecognitionException {
        XSPARQLRewriter.groupBy_return retval = new XSPARQLRewriter.groupBy_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree T_GROUP_BY543=null;
        XSPARQLRewriter.groupByCondition_return groupByCondition544 = null;


        CommonTree T_GROUP_BY543_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2190:3: ( ^( T_GROUP_BY ( groupByCondition )+ ) )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2190:5: ^( T_GROUP_BY ( groupByCondition )+ )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            T_GROUP_BY543=(CommonTree)match(input,T_GROUP_BY,FOLLOW_T_GROUP_BY_in_groupBy10028); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            T_GROUP_BY543_tree = (CommonTree)adaptor.dupNode(T_GROUP_BY543);

            root_1 = (CommonTree)adaptor.becomeRoot(T_GROUP_BY543_tree, root_1);
            }


            match(input, Token.DOWN, null); if (state.failed) return retval;
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2190:18: ( groupByCondition )+
            int cnt151=0;
            loop151:
            do {
                int alt151=2;
                switch ( input.LA(1) ) {
                case VAR:
                case LPAR:
                case PNAME_NS:
                case PNAME_LN:
                case IRIREF:
                case IF:
                case STR:
                case LANG:
                case LANGMATCHES:
                case DATATYPE:
                case BOUND:
                case ISIRI:
                case ISURI:
                case ISBLANK:
                case ISLITERAL:
                case REGEX:
                case COUNT:
                case AVG:
                case MAX:
                case MIN:
                case SUM:
                case SAMPLE:
                case GROUP_CONCAT:
                case EXISTS:
                case NOTKW:
                case SUBSTR:
                case REPLACE:
                case IRI:
                case URI:
                case BNODE:
                case RAND:
                case ABS:
                case CEIL:
                case FLOOR:
                case ROUND:
                case CONCAT:
                case STRLEN:
                case UCASE:
                case LCASE:
                case ENCODE_FOR_URI:
                case CONTAINS:
                case STRSTARTS:
                case STRENDS:
                case STRBEFORE:
                case STRAFTER:
                case ISNUMERIC:
                case YEAR:
                case MONTH:
                case DAY:
                case HOURS:
                case MINUTES:
                case SECONDS:
                case TIMEZONE:
                case TZ:
                case NOW:
                case UID:
                case STRUUID:
                case MD5:
                case SHA1:
                case SHA256:
                case SHA384:
                case SHA512:
                case COALESCE:
                case STRLANG:
                case STRDT:
                case SAME_TERM:
                    {
                    alt151=1;
                    }
                    break;

                }

                switch (alt151) {
            	case 1 :
            	    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: groupByCondition
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_groupByCondition_in_groupBy10030);
            	    groupByCondition544=groupByCondition();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) 
            	    adaptor.addChild(root_1, groupByCondition544.getTree());

            	    if ( state.backtracking==0 ) {
            	    }
            	    }
            	    break;

            	default :
            	    if ( cnt151 >= 1 ) break loop151;
            	    if (state.backtracking>0) {state.failed=true; return retval;}
                        EarlyExitException eee =
                            new EarlyExitException(151, input);
                        throw eee;
                }
                cnt151++;
            } while (true);


            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "groupBy"

    public static class groupByCondition_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "groupByCondition"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2193:1: groupByCondition : ( builtInCall | sFunctionCall | l= LPAR expression r= RPAR -> QSTRING[$l.token, $l.text] expression QSTRING[$r.token, $r.text] | l= LPAR expression a= AS v= VAR r= RPAR -> QSTRING[$l.token, $l.text] expression QSTRING[$a.token, \" \"+$a.text+\" \"] QSTRING[$v.token, $v.text] QSTRING[$r.token, $r.text] | v= VAR -> QSTRING[$v.token, $v.text+ \" \"] );
    public final XSPARQLRewriter.groupByCondition_return groupByCondition() throws RecognitionException {
        XSPARQLRewriter.groupByCondition_return retval = new XSPARQLRewriter.groupByCondition_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree l=null;
        CommonTree r=null;
        CommonTree a=null;
        CommonTree v=null;
        XSPARQLRewriter.builtInCall_return builtInCall545 = null;

        XSPARQLRewriter.sFunctionCall_return sFunctionCall546 = null;

        XSPARQLRewriter.expression_return expression547 = null;

        XSPARQLRewriter.expression_return expression548 = null;


        CommonTree l_tree=null;
        CommonTree r_tree=null;
        CommonTree a_tree=null;
        CommonTree v_tree=null;
        RewriteRuleNodeStream stream_AS=new RewriteRuleNodeStream(adaptor,"token AS");
        RewriteRuleNodeStream stream_LPAR=new RewriteRuleNodeStream(adaptor,"token LPAR");
        RewriteRuleNodeStream stream_VAR=new RewriteRuleNodeStream(adaptor,"token VAR");
        RewriteRuleNodeStream stream_RPAR=new RewriteRuleNodeStream(adaptor,"token RPAR");
        RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2194:3: ( builtInCall | sFunctionCall | l= LPAR expression r= RPAR -> QSTRING[$l.token, $l.text] expression QSTRING[$r.token, $r.text] | l= LPAR expression a= AS v= VAR r= RPAR -> QSTRING[$l.token, $l.text] expression QSTRING[$a.token, \" \"+$a.text+\" \"] QSTRING[$v.token, $v.text] QSTRING[$r.token, $r.text] | v= VAR -> QSTRING[$v.token, $v.text+ \" \"] )
            int alt152=5;
            alt152 = dfa152.predict(input);
            switch (alt152) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2194:5: builtInCall
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_builtInCall_in_groupByCondition10047);
                    builtInCall545=builtInCall();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, builtInCall545.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2195:5: sFunctionCall
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_sFunctionCall_in_groupByCondition10053);
                    sFunctionCall546=sFunctionCall();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, sFunctionCall546.getTree());

                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 3 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2196:5: l= LPAR expression r= RPAR
                    {
                    _last = (CommonTree)input.LT(1);
                    l=(CommonTree)match(input,LPAR,FOLLOW_LPAR_in_groupByCondition10061); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_LPAR.add(l);

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_groupByCondition10063);
                    expression547=expression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_expression.add(expression547.getTree());
                    _last = (CommonTree)input.LT(1);
                    r=(CommonTree)match(input,RPAR,FOLLOW_RPAR_in_groupByCondition10067); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_RPAR.add(r);



                    // AST REWRITE
                    // elements: expression
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 2197:3: -> QSTRING[$l.token, $l.text] expression QSTRING[$r.token, $r.text]
                    {
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, l.token, (l!=null?l.getText():null)));
                        adaptor.addChild(root_0, stream_expression.nextTree());
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, r.token, (r!=null?r.getText():null)));

                    }

                    retval.tree = root_0;}
                    }
                    break;
                case 4 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2198:5: l= LPAR expression a= AS v= VAR r= RPAR
                    {
                    _last = (CommonTree)input.LT(1);
                    l=(CommonTree)match(input,LPAR,FOLLOW_LPAR_in_groupByCondition10087); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_LPAR.add(l);

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_groupByCondition10089);
                    expression548=expression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_expression.add(expression548.getTree());
                    _last = (CommonTree)input.LT(1);
                    a=(CommonTree)match(input,AS,FOLLOW_AS_in_groupByCondition10093); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_AS.add(a);

                    _last = (CommonTree)input.LT(1);
                    v=(CommonTree)match(input,VAR,FOLLOW_VAR_in_groupByCondition10097); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_VAR.add(v);

                    _last = (CommonTree)input.LT(1);
                    r=(CommonTree)match(input,RPAR,FOLLOW_RPAR_in_groupByCondition10101); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_RPAR.add(r);



                    // AST REWRITE
                    // elements: expression
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 2199:3: -> QSTRING[$l.token, $l.text] expression QSTRING[$a.token, \" \"+$a.text+\" \"] QSTRING[$v.token, $v.text] QSTRING[$r.token, $r.text]
                    {
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, l.token, (l!=null?l.getText():null)));
                        adaptor.addChild(root_0, stream_expression.nextTree());
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, a.token, " "+(a!=null?a.getText():null)+" "));
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, v.token, (v!=null?v.getText():null)));
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, r.token, (r!=null?r.getText():null)));

                    }

                    retval.tree = root_0;}
                    }
                    break;
                case 5 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2200:5: v= VAR
                    {
                    _last = (CommonTree)input.LT(1);
                    v=(CommonTree)match(input,VAR,FOLLOW_VAR_in_groupByCondition10127); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_VAR.add(v);



                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 2201:3: -> QSTRING[$v.token, $v.text+ \" \"]
                    {
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, v.token, (v!=null?v.getText():null)+ " "));

                    }

                    retval.tree = root_0;}
                    }
                    break;

            }
            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "groupByCondition"

    public static class having_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "having"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2204:1: having : ^( T_HAVING havingCondition ) ;
    public final XSPARQLRewriter.having_return having() throws RecognitionException {
        XSPARQLRewriter.having_return retval = new XSPARQLRewriter.having_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree T_HAVING549=null;
        XSPARQLRewriter.havingCondition_return havingCondition550 = null;


        CommonTree T_HAVING549_tree=null;

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2205:3: ( ^( T_HAVING havingCondition ) )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2205:5: ^( T_HAVING havingCondition )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            T_HAVING549=(CommonTree)match(input,T_HAVING,FOLLOW_T_HAVING_in_having10148); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            T_HAVING549_tree = (CommonTree)adaptor.dupNode(T_HAVING549);

            root_1 = (CommonTree)adaptor.becomeRoot(T_HAVING549_tree, root_1);
            }


            match(input, Token.DOWN, null); if (state.failed) return retval;
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_havingCondition_in_having10150);
            havingCondition550=havingCondition();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_1, havingCondition550.getTree());

            match(input, Token.UP, null); if (state.failed) return retval;adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "having"

    public static class havingCondition_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "havingCondition"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2208:1: havingCondition : constraint ;
    public final XSPARQLRewriter.havingCondition_return havingCondition() throws RecognitionException {
        XSPARQLRewriter.havingCondition_return retval = new XSPARQLRewriter.havingCondition_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.constraint_return constraint551 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2209:3: ( constraint )
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2209:5: constraint
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_constraint_in_havingCondition10166);
            constraint551=constraint();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) 
            adaptor.addChild(root_0, constraint551.getTree());

            if ( state.backtracking==0 ) {
            }
            }

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "havingCondition"

    public static class limitoffsetclauses_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "limitoffsetclauses"
    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2212:1: limitoffsetclauses : ( limitclause ( offsetclause )? | offsetclause ( limitclause )? );
    public final XSPARQLRewriter.limitoffsetclauses_return limitoffsetclauses() throws RecognitionException {
        XSPARQLRewriter.limitoffsetclauses_return retval = new XSPARQLRewriter.limitoffsetclauses_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLRewriter.limitclause_return limitclause552 = null;

        XSPARQLRewriter.offsetclause_return offsetclause553 = null;

        XSPARQLRewriter.offsetclause_return offsetclause554 = null;

        XSPARQLRewriter.limitclause_return limitclause555 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2213:3: ( limitclause ( offsetclause )? | offsetclause ( limitclause )? )
            int alt155=2;
            switch ( input.LA(1) ) {
            case LIMIT:
                {
                alt155=1;
                }
                break;
            case OFFSET:
                {
                alt155=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 155, 0, input);

                throw nvae;
            }

            switch (alt155) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2213:5: limitclause ( offsetclause )?
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_limitclause_in_limitoffsetclauses10179);
                    limitclause552=limitclause();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, limitclause552.getTree());
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2213:17: ( offsetclause )?
                    int alt153=2;
                    switch ( input.LA(1) ) {
                        case OFFSET:
                            {
                            alt153=1;
                            }
                            break;
                    }

                    switch (alt153) {
                        case 1 :
                            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: offsetclause
                            {
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_offsetclause_in_limitoffsetclauses10181);
                            offsetclause553=offsetclause();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) 
                            adaptor.addChild(root_0, offsetclause553.getTree());

                            if ( state.backtracking==0 ) {
                            }
                            }
                            break;

                    }


                    if ( state.backtracking==0 ) {
                    }
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2214:5: offsetclause ( limitclause )?
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_offsetclause_in_limitoffsetclauses10188);
                    offsetclause554=offsetclause();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) 
                    adaptor.addChild(root_0, offsetclause554.getTree());
                    // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:2214:18: ( limitclause )?
                    int alt154=2;
                    switch ( input.LA(1) ) {
                        case LIMIT:
                            {
                            alt154=1;
                            }
                            break;
                    }

                    switch (alt154) {
                        case 1 :
                            // org/sourceforge/xsparql/rewriter/XSPARQLRewriter.g:0:0: limitclause
