// $ANTLR 3.2 Sep 23, 2009 14:05:07 org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g 2014-07-28 14:43:30

  package org.sourceforge.xsparql.rewriter;

  import java.util.logging.Logger;
  import java.util.Collection;
  import java.util.ArrayList;



import org.antlr.runtime.*;
import org.antlr.runtime.tree.*;import java.util.Stack;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;

/**
 *
 * Copyright (C) 2011, NUI Galway.
 * Copyright (C) 2014, NUI Galway, WU Wien, Politecnico di Milano, Vienna University of Technology 
 * All rights reserved.
 *
 * The software in this package is published under the terms of the BSD style license a copy of which has been included
 * with this distribution in the bsb_license.txt file and/or available on NUI Galway Server at
 * http://xsparql.deri.ie/license/bsd_license.txt
 *
 * Created on 09 February 2011 by Reasoning and Querying Unit (URQ), Digital Enterprise Research Institute (DERI) on behalf of
 * NUI Galway.
 * 20 May 2014 by Axel Polleres on behalf of WU Wien, Daniele Dell'Aglio on behalf of Politecnico di Milano,  Stefan 
 * Bischof on behalf of Vienna University of Technology,  Nuno Lopes on behalf of NUI Galway.
 * 
 */
public class XSPARQLSimplifier extends AbstractMyTreeRewriter {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "VAR", "ENDELM", "INTEGER", "LCURLY", "RCURLY", "NCNAME", "QSTRING", "DOT", "AT", "ASSIGN", "CARET", "CARETCARET", "COLON", "COMMA", "SLASH", "LBRACKET", "RBRACKET", "LPAR", "RPAR", "SEMICOLON", "STAR", "DOTDOT", "SLASHSLASH", "LESSTHAN", "GREATERTHAN", "PLUS", "MINUS", "UNIONSYMBOL", "QUESTIONMARK", "LESSTHANLESSTHAN", "GREATERTHANEQUALS", "LESSTHANEQUALS", "HAFENEQUALS", "EQUALS", "COLONCOLON", "BLANK_NODE_LABEL", "BNODE_CONSTRUCT", "IRI_CONSTRUCT", "ASK", "DESCRIBE", "SELECT", "PNAME_NS", "PNAME_LN", "CDATASTART", "CDATAELMEND", "RCURLYGREATERTHAN", "LESSTHANLCURLY", "ORSYMBOL", "ANDSYMBOL", "NOT", "WHITESPACE", "IRIREF", "NCNAMEELM", "ENDTAG", "A", "IS", "EQ", "NE", "LT", "GE", "LE", "GT", "FOR", "FROM", "LIMIT", "OFFSET", "LET", "ORDER", "BY", "ATS", "IN", "AS", "DESCENDING", "ASCENDING", "STABLE", "IF", "THEN", "ELSE", "RETURN", "CONSTRUCT", "WHERE", "GREATEST", "LEAST", "COLLATION", "CHILD", "DESCENDANT", "ATTRIBUTE", "SELF", "DESCENDANTORSELF", "FOLLOWINGSIBLING", "FOLLOWING", "PARENT", "ANCESTOR", "PRECEDINGSIBLING", "PRECEDING", "ANCESTORORSELF", "ORDERED", "UNORDERED", "DECLARE", "NAMESPACE", "DEFAULT", "ELEMENT", "FUNCTION", "BASEURI", "PREFIX", "BASE", "AND", "OR", "TO", "DIV", "IDIV", "MOD", "UNION", "INTERSECT", "EXCEPT", "INSTANCE", "TREAT", "CASTABLE", "CAST", "OF", "EMPTYSEQUENCE", "ITEM", "NODE", "DOCUMENTNODE", "TEXT", "COMMENT", "PROCESSINGINSTRUCTION", "SCHEMAATTRIBUTE", "SCHEMAELEMENT", "DOCUMENT", "NAMED", "OPTIONAL", "FILTER", "STR", "LANG", "LANGMATCHES", "DATATYPE", "BOUND", "ISIRI", "ISURI", "ISBLANK", "ISLITERAL", "REGEX", "TRUE", "FALSE", "GRAPH", "GREATERTHANGREATERTHAN", "DISTINCT", "GROUP", "HAVING", "ENDPOINT", "ROW", "DOUBLET", "T_NAMESPACE", "T_XML_ELEMENT", "T_XML_CONTENT", "T_XML_ATTRIBUTE", "T_FLWOR", "T_FUNCTION_DECL", "T_PARAMS", "T_FORLET", "T_WHERE", "T_SPARQL_FOR", "T_SPARQL_WHERE", "T_FOR", "T_LET", "T_CONSTRUCT", "T_ORDER", "T_RETURN", "T_UNION", "T_SQL_FOR", "T_SQL_WHERE", "T_SQL_FROM", "T_VAR", "T_TABLE", "T_BLANK", "T_ANON_BLANK", "T_EMPTY_ANON_BLANK", "T_SUBJECT", "T_VERB", "T_OBJECT", "T_MAIN", "T_PAR", "T_INSTANCEOF", "T_TYPE", "T_CASTAS", "T_CASTABLEAS", "T_TREATAS", "T_VARIABLE_DECL", "T_EXTERNAL_VARIABLE_DECL", "T_OPTION_DECL", "T_FUNCTION_CALL", "T_PARAM", "T_ORDER_BY", "T_STABLE_ORDER_BY", "T_GROUP_BY", "T_HAVING", "BOUNDARYSPACE", "STRIP", "VARIABLE", "IMPORT", "EXTERNAL", "NOPRESERVE", "PRESERVE", "CONSTRUCTION", "MODULE", "INHERIT", "NOINHERIT", "SCHEMA", "EMPTY", "ORDERING", "COPYNAMESPACES", "XQUERY", "VERSION", "ENCODING", "OPTION", "LAX", "CASE", "EVERY", "TYPESWITCH", "SATISFIES", "VALIDATE", "SOME", "STRICT", "ASC", "DESC", "REDUCED", "EXPONENT", "COUNT", "AVG", "MAX", "MIN", "SUM", "SAMPLE", "GROUP_CONCAT", "SEPARATOR", "BIND", "EXISTS", "NOTKW", "SERVICE", "SILENT", "UNDEF", "VALUES", "SUBSTR", "REPLACE", "IRI", "URI", "BNODE", "RAND", "ABS", "CEIL", "FLOOR", "ROUND", "CONCAT", "STRLEN", "UCASE", "LCASE", "ENCODE_FOR_URI", "CONTAINS", "STRSTARTS", "STRENDS", "STRBEFORE", "STRAFTER", "ISNUMERIC", "YEAR", "MONTH", "DAY", "HOURS", "MINUTES", "SECONDS", "TIMEZONE", "TZ", "NOW", "UID", "STRUUID", "MD5", "SHA1", "SHA256", "SHA384", "SHA512", "COALESCE", "STRLANG", "STRDT", "SAME_TERM", "T_SUBSELECT", "T_MODULE_DECL", "T_VERSION", "T_BOUNDARYSPACE_DECL", "T_DEFAULT_DECL", "T_ORDER_DECL", "T_EMPTY_ORDER_DECL", "T_DEFAULT_COLLATION_DECL", "T_BASEURI_DECL", "T_MODULE_IMPORT", "T_SCHEMA_IMPORT", "T_QUERY_BODY", "T_BODY_PART", "XPATH", "T_LITERAL_CONSTRUCT", "T_IRI_CONSTRUCT", "T_EPILOGUE", "DECIMAL", "REWRITEVNODE", "REWRITEVNODE1", "DELETEVNODE", "T_QSTRING", "NOTHING", "T_XML_CONTENTS", "T_ASVAR", "T_UNOPTIMIZED_FUNCTION_CALL"
    };
    public static final int MONTH=269;
    public static final int INHERIT=210;
    public static final int RAND=252;
    public static final int CDATAELMEND=48;
    public static final int LEAST=86;
    public static final int T_EPILOGUE=304;
    public static final int T_XML_ELEMENT=158;
    public static final int CARETCARET=15;
    public static final int FOLLOWINGSIBLING=93;
    public static final int MINUS=30;
    public static final int STR=137;
    public static final int FLOOR=255;
    public static final int YEAR=268;
    public static final int T_NAMESPACE=157;
    public static final int T_EMPTY_ORDER_DECL=294;
    public static final int SAME_TERM=287;
    public static final int NOTHING=310;
    public static final int T_INSTANCEOF=187;
    public static final int BIND=240;
    public static final int BASEURI=107;
    public static final int UNIONSYMBOL=31;
    public static final int NODE=126;
    public static final int T_CASTABLEAS=190;
    public static final int STRENDS=264;
    public static final int SUM=236;
    public static final int WHERE=84;
    public static final int STRLEN=258;
    public static final int TYPESWITCH=223;
    public static final int UID=277;
    public static final int AS=75;
    public static final int AT=12;
    public static final int MIN=235;
    public static final int ENCODE_FOR_URI=261;
    public static final int THEN=80;
    public static final int DELETEVNODE=308;
    public static final int T_MODULE_IMPORT=297;
    public static final int A=58;
    public static final int T_PARAMS=163;
    public static final int STRIP=202;
    public static final int IRI=249;
    public static final int T_SQL_FROM=176;
    public static final int T_RETURN=172;
    public static final int COLONCOLON=38;
    public static final int T_VAR=177;
    public static final int GROUP=152;
    public static final int ASC=228;
    public static final int ABS=253;
    public static final int QUESTIONMARK=32;
    public static final int PRECEDINGSIBLING=97;
    public static final int T_OPTION_DECL=194;
    public static final int VARIABLE=203;
    public static final int BY=72;
    public static final int T_SUBJECT=182;
    public static final int ASK=42;
    public static final int OFFSET=69;
    public static final int DOUBLET=156;
    public static final int T_QUERY_BODY=299;
    public static final int BOUNDARYSPACE=201;
    public static final int PNAME_NS=45;
    public static final int T_TABLE=178;
    public static final int SECONDS=273;
    public static final int T_OBJECT=184;
    public static final int T_DEFAULT_DECL=292;
    public static final int DIV=113;
    public static final int T_MAIN=185;
    public static final int STAR=24;
    public static final int TO=112;
    public static final int UNION=116;
    public static final int UNDEF=245;
    public static final int ATS=73;
    public static final int XPATH=301;
    public static final int BNODE=251;
    public static final int REGEX=146;
    public static final int TZ=275;
    public static final int T_ASVAR=312;
    public static final int DESC=229;
    public static final int STRBEFORE=265;
    public static final int OPTIONAL=135;
    public static final int T_BODY_PART=300;
    public static final int T_VERB=183;
    public static final int T_FUNCTION_CALL=195;
    public static final int ORDERED=100;
    public static final int LPAR=21;
    public static final int PARENT=95;
    public static final int DESCENDING=76;
    public static final int BOUND=141;
    public static final int SCHEMAELEMENT=132;
    public static final int COPYNAMESPACES=215;
    public static final int REPLACE=248;
    public static final int DESCENDANT=89;
    public static final int T_CASTAS=189;
    public static final int INTEGER=6;
    public static final int STRICT=227;
    public static final int ATTRIBUTE=90;
    public static final int SLASHSLASH=26;
    public static final int LANGMATCHES=139;
    public static final int FOR=66;
    public static final int T_TREATAS=191;
    public static final int PNAME_LN=46;
    public static final int RCURLYGREATERTHAN=49;
    public static final int T_DEFAULT_COLLATION_DECL=295;
    public static final int EQ=60;
    public static final int CARET=14;
    public static final int NOT=53;
    public static final int AVG=233;
    public static final int DATATYPE=140;
    public static final int NOW=276;
    public static final int HAVING=153;
    public static final int SHA512=283;
    public static final int PRESERVE=207;
    public static final int SCHEMAATTRIBUTE=131;
    public static final int T_UNOPTIMIZED_FUNCTION_CALL=313;
    public static final int T_SPARQL_FOR=166;
    public static final int RPAR=22;
    public static final int T_CONSTRUCT=170;
    public static final int CONTAINS=262;
    public static final int BASE=109;
    public static final int RETURN=82;
    public static final int SOME=226;
    public static final int SCHEMA=212;
    public static final int T_SQL_WHERE=175;
    public static final int STRDT=286;
    public static final int T_LITERAL_CONSTRUCT=302;
    public static final int T_PAR=186;
    public static final int EOF=-1;
    public static final int T_EXTERNAL_VARIABLE_DECL=193;
    public static final int EMPTY=213;
    public static final int GE=63;
    public static final int QSTRING=10;
    public static final int MOD=115;
    public static final int FILTER=136;
    public static final int T_BLANK=179;
    public static final int EXISTS=241;
    public static final int COLON=16;
    public static final int RBRACKET=20;
    public static final int INTERSECT=117;
    public static final int GT=65;
    public static final int T_PARAM=196;
    public static final int SAMPLE=237;
    public static final int NCNAMEELM=56;
    public static final int T_QSTRING=309;
    public static final int HOURS=271;
    public static final int HAFENEQUALS=36;
    public static final int T_FOR=168;
    public static final int ENDTAG=57;
    public static final int T_EMPTY_ANON_BLANK=181;
    public static final int REWRITEVNODE1=307;
    public static final int VALIDATE=225;
    public static final int FALSE=148;
    public static final int MINUTES=272;
    public static final int T_TYPE=188;
    public static final int ISIRI=142;
    public static final int REDUCED=230;
    public static final int DEFAULT=104;
    public static final int LESSTHANLCURLY=50;
    public static final int NOPRESERVE=206;
    public static final int T_ORDER_DECL=293;
    public static final int SHA1=280;
    public static final int IRIREF=55;
    public static final int VAR=4;
    public static final int T_VERSION=290;
    public static final int TEXT=128;
    public static final int SATISFIES=224;
    public static final int EVERY=222;
    public static final int LESSTHANEQUALS=35;
    public static final int ANCESTORORSELF=99;
    public static final int ISLITERAL=145;
    public static final int SEMICOLON=23;
    public static final int WHITESPACE=54;
    public static final int ELSE=81;
    public static final int DOCUMENT=133;
    public static final int CEIL=254;
    public static final int TIMEZONE=274;
    public static final int IF=79;
    public static final int CAST=122;
    public static final int GRAPH=149;
    public static final int PROCESSINGINSTRUCTION=130;
    public static final int IN=74;
    public static final int T_ORDER_BY=197;
    public static final int T_XML_CONTENTS=311;
    public static final int DISTINCT=151;
    public static final int DOT=11;
    public static final int T_FUNCTION_DECL=162;
    public static final int OPTION=219;
    public static final int INSTANCE=119;
    public static final int IS=59;
    public static final int CHILD=88;
    public static final int FUNCTION=106;
    public static final int NCNAME=9;
    public static final int T_BOUNDARYSPACE_DECL=291;
    public static final int CASE=221;
    public static final int NOTKW=242;
    public static final int ITEM=125;
    public static final int T_IRI_CONSTRUCT=303;
    public static final int LCASE=260;
    public static final int CDATASTART=47;
    public static final int COUNT=232;
    public static final int TREAT=120;
    public static final int COLLATION=87;
    public static final int T_XML_ATTRIBUTE=160;
    public static final int CONSTRUCT=83;
    public static final int ISBLANK=144;
    public static final int MAX=234;
    public static final int LESSTHANLESSTHAN=33;
    public static final int ANCESTOR=96;
    public static final int ASSIGN=13;
    public static final int URI=250;
    public static final int COMMENT=129;
    public static final int ORDER=71;
    public static final int IMPORT=204;
    public static final int T_SPARQL_WHERE=167;
    public static final int VALUES=246;
    public static final int STABLE=78;
    public static final int T_LET=169;
    public static final int RCURLY=8;
    public static final int COMMA=17;
    public static final int STRAFTER=266;
    public static final int LCURLY=7;
    public static final int LBRACKET=19;
    public static final int SELF=91;
    public static final int T_BASEURI_DECL=296;
    public static final int SELECT=44;
    public static final int NAMED=134;
    public static final int PRECEDING=98;
    public static final int ELEMENT=105;
    public static final int ASCENDING=77;
    public static final int GREATEST=85;
    public static final int VERSION=217;
    public static final int LE=64;
    public static final int EXPONENT=231;
    public static final int GROUP_CONCAT=238;
    public static final int DAY=270;
    public static final int T_UNION=173;
    public static final int MD5=279;
    public static final int NAMESPACE=103;
    public static final int GREATERTHANGREATERTHAN=150;
    public static final int LAX=220;
    public static final int T_STABLE_ORDER_BY=198;
    public static final int LT=62;
    public static final int DECIMAL=305;
    public static final int GREATERTHANEQUALS=34;
    public static final int FROM=67;
    public static final int T_WHERE=165;
    public static final int T_SQL_FOR=174;
    public static final int STRSTARTS=263;
    public static final int T_GROUP_BY=199;
    public static final int COALESCE=284;
    public static final int XQUERY=216;
    public static final int ISNUMERIC=267;
    public static final int SERVICE=243;
    public static final int T_HAVING=200;
    public static final int T_VARIABLE_DECL=192;
    public static final int DESCRIBE=43;
    public static final int SUBSTR=247;
    public static final int SILENT=244;
    public static final int REWRITEVNODE=306;
    public static final int T_XML_CONTENT=159;
    public static final int T_ORDER=171;
    public static final int SEPARATOR=239;
    public static final int TRUE=147;
    public static final int IDIV=114;
    public static final int EXCEPT=118;
    public static final int MODULE=209;
    public static final int PREFIX=108;
    public static final int NE=61;
    public static final int AND=110;
    public static final int T_FORLET=164;
    public static final int UNORDERED=101;
    public static final int ROW=155;
    public static final int PLUS=29;
    public static final int ENDELM=5;
    public static final int DESCENDANTORSELF=92;
    public static final int DOCUMENTNODE=127;
    public static final int ROUND=256;
    public static final int CONCAT=257;
    public static final int IRI_CONSTRUCT=41;
    public static final int UCASE=259;
    public static final int ISURI=143;
    public static final int LIMIT=68;
    public static final int LANG=138;
    public static final int FOLLOWING=94;
    public static final int T_SCHEMA_IMPORT=298;
    public static final int ORSYMBOL=51;
    public static final int EXTERNAL=205;
    public static final int NOINHERIT=211;
    public static final int SHA384=282;
    public static final int OF=123;
    public static final int STRLANG=285;
    public static final int CASTABLE=121;
    public static final int T_SUBSELECT=288;
    public static final int ANDSYMBOL=52;
    public static final int EMPTYSEQUENCE=124;
    public static final int BNODE_CONSTRUCT=40;
    public static final int T_ANON_BLANK=180;
    public static final int OR=111;
    public static final int EQUALS=37;
    public static final int SLASH=18;
    public static final int BLANK_NODE_LABEL=39;
    public static final int DOTDOT=25;
    public static final int STRUUID=278;
    public static final int ORDERING=214;
    public static final int T_FLWOR=161;
    public static final int SHA256=281;
    public static final int T_MODULE_DECL=289;
    public static final int DECLARE=102;
    public static final int ENCODING=218;
    public static final int CONSTRUCTION=208;
    public static final int LESSTHAN=27;
    public static final int ENDPOINT=154;
    public static final int LET=70;
    public static final int GREATERTHAN=28;

    // delegates
    // delegators


        public XSPARQLSimplifier(TreeNodeStream input) {
            this(input, new RecognizerSharedState());
        }
        public XSPARQLSimplifier(TreeNodeStream input, RecognizerSharedState state) {
            super(input, state);
             
        }
        
    protected TreeAdaptor adaptor = new CommonTreeAdaptor();

    public void setTreeAdaptor(TreeAdaptor adaptor) {
        this.adaptor = adaptor;
    }
    public TreeAdaptor getTreeAdaptor() {
        return adaptor;
    }

    public String[] getTokenNames() { return XSPARQLSimplifier.tokenNames; }
    public String getGrammarFileName() { return "org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g"; }


      private static final Logger logger = Logger.getLogger(XSPARQLSimplifier.class.getClass().getName());

      private String nodeFunction;


      /**
       * set the XQuery evaluation engine
       */
      public void setEngine(String xqueryEngine, String sparqlmethod) {
       if (xqueryEngine.equals("qexo") && sparqlmethod.equals("arq")) {
          this.nodeFunction = "_java:resultNode";
        } else {
          this.nodeFunction = "_xsparql:_resultNode";
        }
      }

    protected String exprToString(Collection expr){
      StringBuilder sb = new StringBuilder();
      for(Object o : expr)
        sb.append(o.toString());
      return sb.toString();
    }

    protected String format(String relation) {
      logger.info("format: "+relation);
      if (relation.matches(".*\\..*")) {
        logger.info("format-true");
        String[] split = relation.split("\\.");
        logger.info("format-true: "+split.length);
        return new String("\"\"" + split[0] +"\"\".\"\"" + split[1] +"\"\"") ;
      } else {
        logger.info("format-false");
        return relation;
      }
    }



    public static class topdown_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "topdown"
    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:229:1: topdown : ( varrewrite | singleconcat | markunoptimized );
    public final XSPARQLSimplifier.topdown_return topdown() throws RecognitionException {
        XSPARQLSimplifier.topdown_return retval = new XSPARQLSimplifier.topdown_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLSimplifier.varrewrite_return varrewrite1 = null;

        XSPARQLSimplifier.singleconcat_return singleconcat2 = null;

        XSPARQLSimplifier.markunoptimized_return markunoptimized3 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:230:3: ( varrewrite | singleconcat | markunoptimized )
            int alt1=3;
            alt1 = dfa1.predict(input);
            switch (alt1) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:230:5: varrewrite
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_varrewrite_in_topdown1107);
                    varrewrite1=varrewrite();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==1 ) 
                     
                    if ( _first_0==null ) _first_0 = varrewrite1.tree;

                    if ( state.backtracking==1 ) {
                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);}
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:231:5: singleconcat
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_singleconcat_in_topdown1113);
                    singleconcat2=singleconcat();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==1 ) 
                     
                    if ( _first_0==null ) _first_0 = singleconcat2.tree;

                    if ( state.backtracking==1 ) {
                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);}
                    }
                    break;
                case 3 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:232:5: markunoptimized
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_markunoptimized_in_topdown1119);
                    markunoptimized3=markunoptimized();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==1 ) 
                     
                    if ( _first_0==null ) _first_0 = markunoptimized3.tree;

                    if ( state.backtracking==1 ) {
                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);}
                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "topdown"

    public static class varrewrite_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "varrewrite"
    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:235:1: varrewrite : ( ^(r= REWRITEVNODE v= VAR ) -> ^( T_FLWOR[$v.token,\"i'm a stupid flworExpr 1\"] COMMENT[\"SPARQL variable \" + $v.text + \" from \" + $v.line + \":\" + $v.pos] ^( T_LET[$v.token,\"LET\"] VAR[$v.token, \"\\$\" + varName ] ^( T_FUNCTION_CALL NCNAME[nodeFunction] ^( T_PARAMS VAR[$r.text] QSTRING[varName] ) ) ) ) | ^( T_VAR q= QSTRING VAR ) -> QSTRING[\" \"+format($q.text)+\" AS \\\"\\\"\" + $q.text +\"\\\"\\\" \"] | ^( T_VAR c= COMMA q= QSTRING VAR ) -> QSTRING[$c.text+\" \"+format($q.text)+\" AS \\\"\\\"\" + $q.text +\"\\\"\\\" \"] | ^(r= REWRITEVNODE ^( T_VAR ( COMMA )? q= QSTRING v= VAR ) ) -> ^( T_FLWOR[$q.token,\"i'm a stupid flworExpr 2\"] COMMENT[\"SPARQL variable \" + $q.text + \" from \" + $q.line + \":\" + $q.pos] ^( T_LET[$q.token,\"LET\"] VAR[$q.token, \"\\$\" + varName] ^( T_FUNCTION_CALL NCNAME[\"_xsparql:_sqlResultNode\"] ^( T_PARAMS VAR[$r.text] QSTRING ) ) ) ) | ^(r= REWRITEVNODE LPAR ^( T_FUNCTION_CALL n= NCNAME ^( T_PARAMS ^( XPATH v= STAR ) ) ) AS v2= VAR RPAR ) -> ^( T_FLWOR[$v2.token,\"i'm a stupid flworExpr 3\"] COMMENT[\"SPARQL variable \" + $v.text + \" from \" + $v.line + \":\" + $v.pos] ^( T_LET[$v2.token,\"LET\"] VAR[$v2.token, \"\\$\" + varName ] ^( T_FUNCTION_CALL NCNAME[nodeFunction] ^( T_PARAMS VAR[$r.text] QSTRING[varName] ) ) ) ) | ^(r= REWRITEVNODE LPAR ^( T_FUNCTION_CALL n= NCNAME ^( T_PARAMS ^( XPATH v= VAR ) ) ) AS v2= VAR RPAR ) -> ^( T_FLWOR[$v2.token,\"i'm a stupid flworExpr\"] COMMENT[\"SPARQL variable \" + $v.text + \" from \" + $v.line + \":\" + $v.pos] ^( T_LET[$v2.token,\"LET\"] VAR[$v2.token, \"\\$\" + varName ] ^( T_FUNCTION_CALL NCNAME[nodeFunction] ^( T_PARAMS VAR[$r.text] QSTRING[varName] ) ) ) ) | ^(r= REWRITEVNODE q= NOTHING ) -> COMMENT[$q.token, \"dependent variable \" + $q.text] | DELETEVNODE -> DELETEVNODE | ^( REWRITEVNODE1 v= VAR ) -> QSTRING[$v.token, $v.text + \" \"] | ^( REWRITEVNODE1 vv= NOTHING ) -> QSTRING[$vv.token, \" \"] | ^( REWRITEVNODE1 LPAR ^( T_FUNCTION_CALL n= NCNAME ^( T_PARAMS ^( XPATH v= STAR ) ) ) AS v2= VAR RPAR ) -> QSTRING[$n.token, \"(\" + $n.text + \"(*) AS \" + $v2.text + \")\"] | ^( REWRITEVNODE1 LPAR ^( T_FUNCTION_CALL n= NCNAME ^( T_PARAMS ^( XPATH v= VAR ) ) ) AS v2= VAR RPAR ) -> QSTRING[$n.token, \"(\" + $n.text + \"(\" + $v.text + \") AS \" + $v2.text + \")\"] | ^( REWRITEVNODE1 ^(t= T_ASVAR LPAR (e+= . )+ AS v= VAR RPAR ) ) -> QSTRING[$t.token, \"(\" + exprToString($e) + \" AS \" + $v.text + \")\"] | ^(r= REWRITEVNODE ^( T_ASVAR LPAR (e+= . )+ AS v= VAR RPAR ) ) -> ^( T_FLWOR[$v.token,\"i'm a stupid flworExpr 4\"] COMMENT[\"SPARQL variable \" + $v.text + \" from \" + $v.line + \":\" + $v.pos] ^( T_LET[$v.token,\"LET\"] VAR[$v.token, \"\\$\" + varName ] ^( T_FUNCTION_CALL NCNAME[nodeFunction] ^( T_PARAMS VAR[$r.text] QSTRING[varName] ) ) ) ) );
    public final XSPARQLSimplifier.varrewrite_return varrewrite() throws RecognitionException {
        XSPARQLSimplifier.varrewrite_return retval = new XSPARQLSimplifier.varrewrite_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree r=null;
        CommonTree v=null;
        CommonTree q=null;
        CommonTree c=null;
        CommonTree n=null;
        CommonTree v2=null;
        CommonTree vv=null;
        CommonTree t=null;
        CommonTree T_VAR4=null;
        CommonTree VAR5=null;
        CommonTree T_VAR6=null;
        CommonTree VAR7=null;
        CommonTree T_VAR8=null;
        CommonTree COMMA9=null;
        CommonTree LPAR10=null;
        CommonTree T_FUNCTION_CALL11=null;
        CommonTree T_PARAMS12=null;
        CommonTree XPATH13=null;
        CommonTree AS14=null;
        CommonTree RPAR15=null;
        CommonTree LPAR16=null;
        CommonTree T_FUNCTION_CALL17=null;
        CommonTree T_PARAMS18=null;
        CommonTree XPATH19=null;
        CommonTree AS20=null;
        CommonTree RPAR21=null;
        CommonTree DELETEVNODE22=null;
        CommonTree REWRITEVNODE123=null;
        CommonTree REWRITEVNODE124=null;
        CommonTree REWRITEVNODE125=null;
        CommonTree LPAR26=null;
        CommonTree T_FUNCTION_CALL27=null;
        CommonTree T_PARAMS28=null;
        CommonTree XPATH29=null;
        CommonTree AS30=null;
        CommonTree RPAR31=null;
        CommonTree REWRITEVNODE132=null;
        CommonTree LPAR33=null;
        CommonTree T_FUNCTION_CALL34=null;
        CommonTree T_PARAMS35=null;
        CommonTree XPATH36=null;
        CommonTree AS37=null;
        CommonTree RPAR38=null;
        CommonTree REWRITEVNODE139=null;
        CommonTree LPAR40=null;
        CommonTree AS41=null;
        CommonTree RPAR42=null;
        CommonTree T_ASVAR43=null;
        CommonTree LPAR44=null;
        CommonTree AS45=null;
        CommonTree RPAR46=null;
        CommonTree e=null;
        List list_e=null;

        CommonTree r_tree=null;
        CommonTree v_tree=null;
        CommonTree q_tree=null;
        CommonTree c_tree=null;
        CommonTree n_tree=null;
        CommonTree v2_tree=null;
        CommonTree vv_tree=null;
        CommonTree t_tree=null;
        CommonTree T_VAR4_tree=null;
        CommonTree VAR5_tree=null;
        CommonTree T_VAR6_tree=null;
        CommonTree VAR7_tree=null;
        CommonTree T_VAR8_tree=null;
        CommonTree COMMA9_tree=null;
        CommonTree LPAR10_tree=null;
        CommonTree T_FUNCTION_CALL11_tree=null;
        CommonTree T_PARAMS12_tree=null;
        CommonTree XPATH13_tree=null;
        CommonTree AS14_tree=null;
        CommonTree RPAR15_tree=null;
        CommonTree LPAR16_tree=null;
        CommonTree T_FUNCTION_CALL17_tree=null;
        CommonTree T_PARAMS18_tree=null;
        CommonTree XPATH19_tree=null;
        CommonTree AS20_tree=null;
        CommonTree RPAR21_tree=null;
        CommonTree DELETEVNODE22_tree=null;
        CommonTree REWRITEVNODE123_tree=null;
        CommonTree REWRITEVNODE124_tree=null;
        CommonTree REWRITEVNODE125_tree=null;
        CommonTree LPAR26_tree=null;
        CommonTree T_FUNCTION_CALL27_tree=null;
        CommonTree T_PARAMS28_tree=null;
        CommonTree XPATH29_tree=null;
        CommonTree AS30_tree=null;
        CommonTree RPAR31_tree=null;
        CommonTree REWRITEVNODE132_tree=null;
        CommonTree LPAR33_tree=null;
        CommonTree T_FUNCTION_CALL34_tree=null;
        CommonTree T_PARAMS35_tree=null;
        CommonTree XPATH36_tree=null;
        CommonTree AS37_tree=null;
        CommonTree RPAR38_tree=null;
        CommonTree REWRITEVNODE139_tree=null;
        CommonTree LPAR40_tree=null;
        CommonTree AS41_tree=null;
        CommonTree RPAR42_tree=null;
        CommonTree T_ASVAR43_tree=null;
        CommonTree LPAR44_tree=null;
        CommonTree AS45_tree=null;
        CommonTree RPAR46_tree=null;
        CommonTree e_tree=null;
        RewriteRuleNodeStream stream_REWRITEVNODE=new RewriteRuleNodeStream(adaptor,"token REWRITEVNODE");
        RewriteRuleNodeStream stream_COMMA=new RewriteRuleNodeStream(adaptor,"token COMMA");
        RewriteRuleNodeStream stream_XPATH=new RewriteRuleNodeStream(adaptor,"token XPATH");
        RewriteRuleNodeStream stream_T_PARAMS=new RewriteRuleNodeStream(adaptor,"token T_PARAMS");
        RewriteRuleNodeStream stream_QSTRING=new RewriteRuleNodeStream(adaptor,"token QSTRING");
        RewriteRuleNodeStream stream_VAR=new RewriteRuleNodeStream(adaptor,"token VAR");
        RewriteRuleNodeStream stream_T_ASVAR=new RewriteRuleNodeStream(adaptor,"token T_ASVAR");
        RewriteRuleNodeStream stream_RPAR=new RewriteRuleNodeStream(adaptor,"token RPAR");
        RewriteRuleNodeStream stream_NCNAME=new RewriteRuleNodeStream(adaptor,"token NCNAME");
        RewriteRuleNodeStream stream_T_VAR=new RewriteRuleNodeStream(adaptor,"token T_VAR");
        RewriteRuleNodeStream stream_AS=new RewriteRuleNodeStream(adaptor,"token AS");
        RewriteRuleNodeStream stream_T_FUNCTION_CALL=new RewriteRuleNodeStream(adaptor,"token T_FUNCTION_CALL");
        RewriteRuleNodeStream stream_STAR=new RewriteRuleNodeStream(adaptor,"token STAR");
        RewriteRuleNodeStream stream_LPAR=new RewriteRuleNodeStream(adaptor,"token LPAR");
        RewriteRuleNodeStream stream_REWRITEVNODE1=new RewriteRuleNodeStream(adaptor,"token REWRITEVNODE1");
        RewriteRuleNodeStream stream_DELETEVNODE=new RewriteRuleNodeStream(adaptor,"token DELETEVNODE");
        RewriteRuleNodeStream stream_NOTHING=new RewriteRuleNodeStream(adaptor,"token NOTHING");


          String varName = "";

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:239:3: ( ^(r= REWRITEVNODE v= VAR ) -> ^( T_FLWOR[$v.token,\"i'm a stupid flworExpr 1\"] COMMENT[\"SPARQL variable \" + $v.text + \" from \" + $v.line + \":\" + $v.pos] ^( T_LET[$v.token,\"LET\"] VAR[$v.token, \"\\$\" + varName ] ^( T_FUNCTION_CALL NCNAME[nodeFunction] ^( T_PARAMS VAR[$r.text] QSTRING[varName] ) ) ) ) | ^( T_VAR q= QSTRING VAR ) -> QSTRING[\" \"+format($q.text)+\" AS \\\"\\\"\" + $q.text +\"\\\"\\\" \"] | ^( T_VAR c= COMMA q= QSTRING VAR ) -> QSTRING[$c.text+\" \"+format($q.text)+\" AS \\\"\\\"\" + $q.text +\"\\\"\\\" \"] | ^(r= REWRITEVNODE ^( T_VAR ( COMMA )? q= QSTRING v= VAR ) ) -> ^( T_FLWOR[$q.token,\"i'm a stupid flworExpr 2\"] COMMENT[\"SPARQL variable \" + $q.text + \" from \" + $q.line + \":\" + $q.pos] ^( T_LET[$q.token,\"LET\"] VAR[$q.token, \"\\$\" + varName] ^( T_FUNCTION_CALL NCNAME[\"_xsparql:_sqlResultNode\"] ^( T_PARAMS VAR[$r.text] QSTRING ) ) ) ) | ^(r= REWRITEVNODE LPAR ^( T_FUNCTION_CALL n= NCNAME ^( T_PARAMS ^( XPATH v= STAR ) ) ) AS v2= VAR RPAR ) -> ^( T_FLWOR[$v2.token,\"i'm a stupid flworExpr 3\"] COMMENT[\"SPARQL variable \" + $v.text + \" from \" + $v.line + \":\" + $v.pos] ^( T_LET[$v2.token,\"LET\"] VAR[$v2.token, \"\\$\" + varName ] ^( T_FUNCTION_CALL NCNAME[nodeFunction] ^( T_PARAMS VAR[$r.text] QSTRING[varName] ) ) ) ) | ^(r= REWRITEVNODE LPAR ^( T_FUNCTION_CALL n= NCNAME ^( T_PARAMS ^( XPATH v= VAR ) ) ) AS v2= VAR RPAR ) -> ^( T_FLWOR[$v2.token,\"i'm a stupid flworExpr\"] COMMENT[\"SPARQL variable \" + $v.text + \" from \" + $v.line + \":\" + $v.pos] ^( T_LET[$v2.token,\"LET\"] VAR[$v2.token, \"\\$\" + varName ] ^( T_FUNCTION_CALL NCNAME[nodeFunction] ^( T_PARAMS VAR[$r.text] QSTRING[varName] ) ) ) ) | ^(r= REWRITEVNODE q= NOTHING ) -> COMMENT[$q.token, \"dependent variable \" + $q.text] | DELETEVNODE -> DELETEVNODE | ^( REWRITEVNODE1 v= VAR ) -> QSTRING[$v.token, $v.text + \" \"] | ^( REWRITEVNODE1 vv= NOTHING ) -> QSTRING[$vv.token, \" \"] | ^( REWRITEVNODE1 LPAR ^( T_FUNCTION_CALL n= NCNAME ^( T_PARAMS ^( XPATH v= STAR ) ) ) AS v2= VAR RPAR ) -> QSTRING[$n.token, \"(\" + $n.text + \"(*) AS \" + $v2.text + \")\"] | ^( REWRITEVNODE1 LPAR ^( T_FUNCTION_CALL n= NCNAME ^( T_PARAMS ^( XPATH v= VAR ) ) ) AS v2= VAR RPAR ) -> QSTRING[$n.token, \"(\" + $n.text + \"(\" + $v.text + \") AS \" + $v2.text + \")\"] | ^( REWRITEVNODE1 ^(t= T_ASVAR LPAR (e+= . )+ AS v= VAR RPAR ) ) -> QSTRING[$t.token, \"(\" + exprToString($e) + \" AS \" + $v.text + \")\"] | ^(r= REWRITEVNODE ^( T_ASVAR LPAR (e+= . )+ AS v= VAR RPAR ) ) -> ^( T_FLWOR[$v.token,\"i'm a stupid flworExpr 4\"] COMMENT[\"SPARQL variable \" + $v.text + \" from \" + $v.line + \":\" + $v.pos] ^( T_LET[$v.token,\"LET\"] VAR[$v.token, \"\\$\" + varName ] ^( T_FUNCTION_CALL NCNAME[nodeFunction] ^( T_PARAMS VAR[$r.text] QSTRING[varName] ) ) ) ) )
            int alt5=14;
            alt5 = dfa5.predict(input);
            switch (alt5) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:239:6: ^(r= REWRITEVNODE v= VAR )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    r=(CommonTree)match(input,REWRITEVNODE,FOLLOW_REWRITEVNODE_in_varrewrite1141); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_REWRITEVNODE.add(r);


                    if ( state.backtracking==1 )
                    if ( _first_0==null ) _first_0 = r;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    v=(CommonTree)match(input,VAR,FOLLOW_VAR_in_varrewrite1145); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_VAR.add(v);


                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_1;
                    }

                    if ( state.backtracking==1 ) {
                       varName=Helper.removeLeading((v!=null?v.getText():null), "$"); 
                    }


                    // AST REWRITE
                    // elements: VAR, VAR
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==1 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 240:3: -> ^( T_FLWOR[$v.token,\"i'm a stupid flworExpr 1\"] COMMENT[\"SPARQL variable \" + $v.text + \" from \" + $v.line + \":\" + $v.pos] ^( T_LET[$v.token,\"LET\"] VAR[$v.token, \"\\$\" + varName ] ^( T_FUNCTION_CALL NCNAME[nodeFunction] ^( T_PARAMS VAR[$r.text] QSTRING[varName] ) ) ) )
                    {
                        // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:240:6: ^( T_FLWOR[$v.token,\"i'm a stupid flworExpr 1\"] COMMENT[\"SPARQL variable \" + $v.text + \" from \" + $v.line + \":\" + $v.pos] ^( T_LET[$v.token,\"LET\"] VAR[$v.token, \"\\$\" + varName ] ^( T_FUNCTION_CALL NCNAME[nodeFunction] ^( T_PARAMS VAR[$r.text] QSTRING[varName] ) ) ) )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FLWOR, v.token, "i'm a stupid flworExpr 1"), root_1);

                        adaptor.addChild(root_1, (CommonTree)adaptor.create(COMMENT, "SPARQL variable " + (v!=null?v.getText():null) + " from " + (v!=null?v.getLine():0) + ":" + (v!=null?v.getCharPositionInLine():0)));
                        // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:242:8: ^( T_LET[$v.token,\"LET\"] VAR[$v.token, \"\\$\" + varName ] ^( T_FUNCTION_CALL NCNAME[nodeFunction] ^( T_PARAMS VAR[$r.text] QSTRING[varName] ) ) )
                        {
                        CommonTree root_2 = (CommonTree)adaptor.nil();
                        root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_LET, v.token, "LET"), root_2);

                        adaptor.addChild(root_2, (CommonTree)adaptor.create(VAR, v.token, "$" + varName));
                        // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:244:10: ^( T_FUNCTION_CALL NCNAME[nodeFunction] ^( T_PARAMS VAR[$r.text] QSTRING[varName] ) )
                        {
                        CommonTree root_3 = (CommonTree)adaptor.nil();
                        root_3 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FUNCTION_CALL, "T_FUNCTION_CALL"), root_3);

                        adaptor.addChild(root_3, (CommonTree)adaptor.create(NCNAME, nodeFunction));
                        // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:246:12: ^( T_PARAMS VAR[$r.text] QSTRING[varName] )
                        {
                        CommonTree root_4 = (CommonTree)adaptor.nil();
                        root_4 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_PARAMS, "T_PARAMS"), root_4);

                        adaptor.addChild(root_4, (CommonTree)adaptor.create(VAR, (r!=null?r.getText():null)));
                        adaptor.addChild(root_4, (CommonTree)adaptor.create(QSTRING, varName));

                        adaptor.addChild(root_3, root_4);
                        }

                        adaptor.addChild(root_2, root_3);
                        }

                        adaptor.addChild(root_1, root_2);
                        }

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                    input.replaceChildren(adaptor.getParent(retval.start),
                                          adaptor.getChildIndex(retval.start),
                                          adaptor.getChildIndex(_last),
                                          retval.tree);}
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:254:5: ^( T_VAR q= QSTRING VAR )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    T_VAR4=(CommonTree)match(input,T_VAR,FOLLOW_T_VAR_in_varrewrite1320); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_T_VAR.add(T_VAR4);


                    if ( state.backtracking==1 )
                    if ( _first_0==null ) _first_0 = T_VAR4;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    q=(CommonTree)match(input,QSTRING,FOLLOW_QSTRING_in_varrewrite1324); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_QSTRING.add(q);

                    _last = (CommonTree)input.LT(1);
                    VAR5=(CommonTree)match(input,VAR,FOLLOW_VAR_in_varrewrite1326); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_VAR.add(VAR5);


                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_1;
                    }



                    // AST REWRITE
                    // elements: QSTRING
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==1 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 255:3: -> QSTRING[\" \"+format($q.text)+\" AS \\\"\\\"\" + $q.text +\"\\\"\\\" \"]
                    {
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, " "+format((q!=null?q.getText():null))+" AS \"\"" + (q!=null?q.getText():null) +"\"\" "));

                    }

                    retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                    input.replaceChildren(adaptor.getParent(retval.start),
                                          adaptor.getChildIndex(retval.start),
                                          adaptor.getChildIndex(_last),
                                          retval.tree);}
                    }
                    break;
                case 3 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:257:5: ^( T_VAR c= COMMA q= QSTRING VAR )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    T_VAR6=(CommonTree)match(input,T_VAR,FOLLOW_T_VAR_in_varrewrite1345); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_T_VAR.add(T_VAR6);


                    if ( state.backtracking==1 )
                    if ( _first_0==null ) _first_0 = T_VAR6;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    c=(CommonTree)match(input,COMMA,FOLLOW_COMMA_in_varrewrite1349); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_COMMA.add(c);

                    _last = (CommonTree)input.LT(1);
                    q=(CommonTree)match(input,QSTRING,FOLLOW_QSTRING_in_varrewrite1353); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_QSTRING.add(q);

                    _last = (CommonTree)input.LT(1);
                    VAR7=(CommonTree)match(input,VAR,FOLLOW_VAR_in_varrewrite1355); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_VAR.add(VAR7);


                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_1;
                    }



                    // AST REWRITE
                    // elements: QSTRING
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==1 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 258:3: -> QSTRING[$c.text+\" \"+format($q.text)+\" AS \\\"\\\"\" + $q.text +\"\\\"\\\" \"]
                    {
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, (c!=null?c.getText():null)+" "+format((q!=null?q.getText():null))+" AS \"\"" + (q!=null?q.getText():null) +"\"\" "));

                    }

                    retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                    input.replaceChildren(adaptor.getParent(retval.start),
                                          adaptor.getChildIndex(retval.start),
                                          adaptor.getChildIndex(_last),
                                          retval.tree);}
                    }
                    break;
                case 4 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:259:6: ^(r= REWRITEVNODE ^( T_VAR ( COMMA )? q= QSTRING v= VAR ) )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    r=(CommonTree)match(input,REWRITEVNODE,FOLLOW_REWRITEVNODE_in_varrewrite1375); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_REWRITEVNODE.add(r);


                    if ( state.backtracking==1 )
                    if ( _first_0==null ) _first_0 = r;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_2 = _last;
                    CommonTree _first_2 = null;
                    _last = (CommonTree)input.LT(1);
                    T_VAR8=(CommonTree)match(input,T_VAR,FOLLOW_T_VAR_in_varrewrite1378); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_T_VAR.add(T_VAR8);


                    if ( state.backtracking==1 )
                    if ( _first_1==null ) _first_1 = T_VAR8;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:259:31: ( COMMA )?
                    int alt2=2;
                    switch ( input.LA(1) ) {
                        case COMMA:
                            {
                            alt2=1;
                            }
                            break;
                    }

                    switch (alt2) {
                        case 1 :
                            // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:0:0: COMMA
                            {
                            _last = (CommonTree)input.LT(1);
                            COMMA9=(CommonTree)match(input,COMMA,FOLLOW_COMMA_in_varrewrite1380); if (state.failed) return retval; 
                            if ( state.backtracking==1 ) stream_COMMA.add(COMMA9);


                            if ( state.backtracking==1 ) {
                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);}
                            }
                            break;

                    }

                    _last = (CommonTree)input.LT(1);
                    q=(CommonTree)match(input,QSTRING,FOLLOW_QSTRING_in_varrewrite1385); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_QSTRING.add(q);

                    _last = (CommonTree)input.LT(1);
                    v=(CommonTree)match(input,VAR,FOLLOW_VAR_in_varrewrite1389); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_VAR.add(v);


                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_2;
                    }


                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_1;
                    }

                    if ( state.backtracking==1 ) {
                       varName = Helper.removeLeading((v!=null?v.getText():null), "$"); 
                    }


                    // AST REWRITE
                    // elements: VAR, QSTRING, VAR
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==1 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 260:3: -> ^( T_FLWOR[$q.token,\"i'm a stupid flworExpr 2\"] COMMENT[\"SPARQL variable \" + $q.text + \" from \" + $q.line + \":\" + $q.pos] ^( T_LET[$q.token,\"LET\"] VAR[$q.token, \"\\$\" + varName] ^( T_FUNCTION_CALL NCNAME[\"_xsparql:_sqlResultNode\"] ^( T_PARAMS VAR[$r.text] QSTRING ) ) ) )
                    {
                        // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:260:6: ^( T_FLWOR[$q.token,\"i'm a stupid flworExpr 2\"] COMMENT[\"SPARQL variable \" + $q.text + \" from \" + $q.line + \":\" + $q.pos] ^( T_LET[$q.token,\"LET\"] VAR[$q.token, \"\\$\" + varName] ^( T_FUNCTION_CALL NCNAME[\"_xsparql:_sqlResultNode\"] ^( T_PARAMS VAR[$r.text] QSTRING ) ) ) )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FLWOR, q.token, "i'm a stupid flworExpr 2"), root_1);

                        adaptor.addChild(root_1, (CommonTree)adaptor.create(COMMENT, "SPARQL variable " + (q!=null?q.getText():null) + " from " + (q!=null?q.getLine():0) + ":" + (q!=null?q.getCharPositionInLine():0)));
                        // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:262:8: ^( T_LET[$q.token,\"LET\"] VAR[$q.token, \"\\$\" + varName] ^( T_FUNCTION_CALL NCNAME[\"_xsparql:_sqlResultNode\"] ^( T_PARAMS VAR[$r.text] QSTRING ) ) )
                        {
                        CommonTree root_2 = (CommonTree)adaptor.nil();
                        root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_LET, q.token, "LET"), root_2);

                        adaptor.addChild(root_2, (CommonTree)adaptor.create(VAR, q.token, "$" + varName));
                        // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:264:10: ^( T_FUNCTION_CALL NCNAME[\"_xsparql:_sqlResultNode\"] ^( T_PARAMS VAR[$r.text] QSTRING ) )
                        {
                        CommonTree root_3 = (CommonTree)adaptor.nil();
                        root_3 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FUNCTION_CALL, "T_FUNCTION_CALL"), root_3);

                        adaptor.addChild(root_3, (CommonTree)adaptor.create(NCNAME, "_xsparql:_sqlResultNode"));
                        // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:266:12: ^( T_PARAMS VAR[$r.text] QSTRING )
                        {
                        CommonTree root_4 = (CommonTree)adaptor.nil();
                        root_4 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_PARAMS, "T_PARAMS"), root_4);

                        adaptor.addChild(root_4, (CommonTree)adaptor.create(VAR, (r!=null?r.getText():null)));
                        adaptor.addChild(root_4, stream_QSTRING.nextNode());

                        adaptor.addChild(root_3, root_4);
                        }

                        adaptor.addChild(root_2, root_3);
                        }

                        adaptor.addChild(root_1, root_2);
                        }

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                    input.replaceChildren(adaptor.getParent(retval.start),
                                          adaptor.getChildIndex(retval.start),
                                          adaptor.getChildIndex(_last),
                                          retval.tree);}
                    }
                    break;
                case 5 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:273:6: ^(r= REWRITEVNODE LPAR ^( T_FUNCTION_CALL n= NCNAME ^( T_PARAMS ^( XPATH v= STAR ) ) ) AS v2= VAR RPAR )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    r=(CommonTree)match(input,REWRITEVNODE,FOLLOW_REWRITEVNODE_in_varrewrite1564); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_REWRITEVNODE.add(r);


                    if ( state.backtracking==1 )
                    if ( _first_0==null ) _first_0 = r;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    LPAR10=(CommonTree)match(input,LPAR,FOLLOW_LPAR_in_varrewrite1566); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_LPAR.add(LPAR10);

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_2 = _last;
                    CommonTree _first_2 = null;
                    _last = (CommonTree)input.LT(1);
                    T_FUNCTION_CALL11=(CommonTree)match(input,T_FUNCTION_CALL,FOLLOW_T_FUNCTION_CALL_in_varrewrite1569); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_T_FUNCTION_CALL.add(T_FUNCTION_CALL11);


                    if ( state.backtracking==1 )
                    if ( _first_1==null ) _first_1 = T_FUNCTION_CALL11;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    n=(CommonTree)match(input,NCNAME,FOLLOW_NCNAME_in_varrewrite1573); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_NCNAME.add(n);

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_3 = _last;
                    CommonTree _first_3 = null;
                    _last = (CommonTree)input.LT(1);
                    T_PARAMS12=(CommonTree)match(input,T_PARAMS,FOLLOW_T_PARAMS_in_varrewrite1576); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_T_PARAMS.add(T_PARAMS12);


                    if ( state.backtracking==1 )
                    if ( _first_2==null ) _first_2 = T_PARAMS12;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_4 = _last;
                    CommonTree _first_4 = null;
                    _last = (CommonTree)input.LT(1);
                    XPATH13=(CommonTree)match(input,XPATH,FOLLOW_XPATH_in_varrewrite1579); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_XPATH.add(XPATH13);


                    if ( state.backtracking==1 )
                    if ( _first_3==null ) _first_3 = XPATH13;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    v=(CommonTree)match(input,STAR,FOLLOW_STAR_in_varrewrite1583); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_STAR.add(v);


                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_4;
                    }


                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_3;
                    }


                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_2;
                    }

                    _last = (CommonTree)input.LT(1);
                    AS14=(CommonTree)match(input,AS,FOLLOW_AS_in_varrewrite1588); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_AS.add(AS14);

                    _last = (CommonTree)input.LT(1);
                    v2=(CommonTree)match(input,VAR,FOLLOW_VAR_in_varrewrite1592); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_VAR.add(v2);

                    _last = (CommonTree)input.LT(1);
                    RPAR15=(CommonTree)match(input,RPAR,FOLLOW_RPAR_in_varrewrite1594); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_RPAR.add(RPAR15);


                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_1;
                    }

                    if ( state.backtracking==1 ) {
                      varName=Helper.removeLeading((v2!=null?v2.getText():null), "$");
                    }


                    // AST REWRITE
                    // elements: VAR, VAR, NCNAME, T_FUNCTION_CALL, T_PARAMS
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==1 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 274:3: -> ^( T_FLWOR[$v2.token,\"i'm a stupid flworExpr 3\"] COMMENT[\"SPARQL variable \" + $v.text + \" from \" + $v.line + \":\" + $v.pos] ^( T_LET[$v2.token,\"LET\"] VAR[$v2.token, \"\\$\" + varName ] ^( T_FUNCTION_CALL NCNAME[nodeFunction] ^( T_PARAMS VAR[$r.text] QSTRING[varName] ) ) ) )
                    {
                        // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:274:6: ^( T_FLWOR[$v2.token,\"i'm a stupid flworExpr 3\"] COMMENT[\"SPARQL variable \" + $v.text + \" from \" + $v.line + \":\" + $v.pos] ^( T_LET[$v2.token,\"LET\"] VAR[$v2.token, \"\\$\" + varName ] ^( T_FUNCTION_CALL NCNAME[nodeFunction] ^( T_PARAMS VAR[$r.text] QSTRING[varName] ) ) ) )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FLWOR, v2.token, "i'm a stupid flworExpr 3"), root_1);

                        adaptor.addChild(root_1, (CommonTree)adaptor.create(COMMENT, "SPARQL variable " + (v!=null?v.getText():null) + " from " + (v!=null?v.getLine():0) + ":" + (v!=null?v.getCharPositionInLine():0)));
                        // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:276:8: ^( T_LET[$v2.token,\"LET\"] VAR[$v2.token, \"\\$\" + varName ] ^( T_FUNCTION_CALL NCNAME[nodeFunction] ^( T_PARAMS VAR[$r.text] QSTRING[varName] ) ) )
                        {
                        CommonTree root_2 = (CommonTree)adaptor.nil();
                        root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_LET, v2.token, "LET"), root_2);

                        adaptor.addChild(root_2, (CommonTree)adaptor.create(VAR, v2.token, "$" + varName));
                        // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:278:10: ^( T_FUNCTION_CALL NCNAME[nodeFunction] ^( T_PARAMS VAR[$r.text] QSTRING[varName] ) )
                        {
                        CommonTree root_3 = (CommonTree)adaptor.nil();
                        root_3 = (CommonTree)adaptor.becomeRoot(stream_T_FUNCTION_CALL.nextNode(), root_3);

                        adaptor.addChild(root_3, (CommonTree)adaptor.create(NCNAME, nodeFunction));
                        // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:280:12: ^( T_PARAMS VAR[$r.text] QSTRING[varName] )
                        {
                        CommonTree root_4 = (CommonTree)adaptor.nil();
                        root_4 = (CommonTree)adaptor.becomeRoot(stream_T_PARAMS.nextNode(), root_4);

                        adaptor.addChild(root_4, (CommonTree)adaptor.create(VAR, (r!=null?r.getText():null)));
                        adaptor.addChild(root_4, (CommonTree)adaptor.create(QSTRING, varName));

                        adaptor.addChild(root_3, root_4);
                        }

                        adaptor.addChild(root_2, root_3);
                        }

                        adaptor.addChild(root_1, root_2);
                        }

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                    input.replaceChildren(adaptor.getParent(retval.start),
                                          adaptor.getChildIndex(retval.start),
                                          adaptor.getChildIndex(_last),
                                          retval.tree);}
                    }
                    break;
                case 6 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:287:6: ^(r= REWRITEVNODE LPAR ^( T_FUNCTION_CALL n= NCNAME ^( T_PARAMS ^( XPATH v= VAR ) ) ) AS v2= VAR RPAR )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    r=(CommonTree)match(input,REWRITEVNODE,FOLLOW_REWRITEVNODE_in_varrewrite1769); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_REWRITEVNODE.add(r);


                    if ( state.backtracking==1 )
                    if ( _first_0==null ) _first_0 = r;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    LPAR16=(CommonTree)match(input,LPAR,FOLLOW_LPAR_in_varrewrite1771); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_LPAR.add(LPAR16);

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_2 = _last;
                    CommonTree _first_2 = null;
                    _last = (CommonTree)input.LT(1);
                    T_FUNCTION_CALL17=(CommonTree)match(input,T_FUNCTION_CALL,FOLLOW_T_FUNCTION_CALL_in_varrewrite1774); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_T_FUNCTION_CALL.add(T_FUNCTION_CALL17);


                    if ( state.backtracking==1 )
                    if ( _first_1==null ) _first_1 = T_FUNCTION_CALL17;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    n=(CommonTree)match(input,NCNAME,FOLLOW_NCNAME_in_varrewrite1778); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_NCNAME.add(n);

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_3 = _last;
                    CommonTree _first_3 = null;
                    _last = (CommonTree)input.LT(1);
                    T_PARAMS18=(CommonTree)match(input,T_PARAMS,FOLLOW_T_PARAMS_in_varrewrite1781); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_T_PARAMS.add(T_PARAMS18);


                    if ( state.backtracking==1 )
                    if ( _first_2==null ) _first_2 = T_PARAMS18;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_4 = _last;
                    CommonTree _first_4 = null;
                    _last = (CommonTree)input.LT(1);
                    XPATH19=(CommonTree)match(input,XPATH,FOLLOW_XPATH_in_varrewrite1784); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_XPATH.add(XPATH19);


                    if ( state.backtracking==1 )
                    if ( _first_3==null ) _first_3 = XPATH19;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    v=(CommonTree)match(input,VAR,FOLLOW_VAR_in_varrewrite1788); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_VAR.add(v);


                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_4;
                    }


                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_3;
                    }


                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_2;
                    }

                    _last = (CommonTree)input.LT(1);
                    AS20=(CommonTree)match(input,AS,FOLLOW_AS_in_varrewrite1793); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_AS.add(AS20);

                    _last = (CommonTree)input.LT(1);
                    v2=(CommonTree)match(input,VAR,FOLLOW_VAR_in_varrewrite1797); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_VAR.add(v2);

                    _last = (CommonTree)input.LT(1);
                    RPAR21=(CommonTree)match(input,RPAR,FOLLOW_RPAR_in_varrewrite1799); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_RPAR.add(RPAR21);


                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_1;
                    }

                    if ( state.backtracking==1 ) {
                      varName=Helper.removeLeading((v2!=null?v2.getText():null), "$");
                    }


                    // AST REWRITE
                    // elements: VAR, T_PARAMS, T_FUNCTION_CALL, VAR, NCNAME
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==1 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 288:3: -> ^( T_FLWOR[$v2.token,\"i'm a stupid flworExpr\"] COMMENT[\"SPARQL variable \" + $v.text + \" from \" + $v.line + \":\" + $v.pos] ^( T_LET[$v2.token,\"LET\"] VAR[$v2.token, \"\\$\" + varName ] ^( T_FUNCTION_CALL NCNAME[nodeFunction] ^( T_PARAMS VAR[$r.text] QSTRING[varName] ) ) ) )
                    {
                        // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:288:6: ^( T_FLWOR[$v2.token,\"i'm a stupid flworExpr\"] COMMENT[\"SPARQL variable \" + $v.text + \" from \" + $v.line + \":\" + $v.pos] ^( T_LET[$v2.token,\"LET\"] VAR[$v2.token, \"\\$\" + varName ] ^( T_FUNCTION_CALL NCNAME[nodeFunction] ^( T_PARAMS VAR[$r.text] QSTRING[varName] ) ) ) )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FLWOR, v2.token, "i'm a stupid flworExpr"), root_1);

                        adaptor.addChild(root_1, (CommonTree)adaptor.create(COMMENT, "SPARQL variable " + (v!=null?v.getText():null) + " from " + (v!=null?v.getLine():0) + ":" + (v!=null?v.getCharPositionInLine():0)));
                        // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:290:8: ^( T_LET[$v2.token,\"LET\"] VAR[$v2.token, \"\\$\" + varName ] ^( T_FUNCTION_CALL NCNAME[nodeFunction] ^( T_PARAMS VAR[$r.text] QSTRING[varName] ) ) )
                        {
                        CommonTree root_2 = (CommonTree)adaptor.nil();
                        root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_LET, v2.token, "LET"), root_2);

                        adaptor.addChild(root_2, (CommonTree)adaptor.create(VAR, v2.token, "$" + varName));
                        // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:292:10: ^( T_FUNCTION_CALL NCNAME[nodeFunction] ^( T_PARAMS VAR[$r.text] QSTRING[varName] ) )
                        {
                        CommonTree root_3 = (CommonTree)adaptor.nil();
                        root_3 = (CommonTree)adaptor.becomeRoot(stream_T_FUNCTION_CALL.nextNode(), root_3);

                        adaptor.addChild(root_3, (CommonTree)adaptor.create(NCNAME, nodeFunction));
                        // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:294:12: ^( T_PARAMS VAR[$r.text] QSTRING[varName] )
                        {
                        CommonTree root_4 = (CommonTree)adaptor.nil();
                        root_4 = (CommonTree)adaptor.becomeRoot(stream_T_PARAMS.nextNode(), root_4);

                        adaptor.addChild(root_4, (CommonTree)adaptor.create(VAR, (r!=null?r.getText():null)));
                        adaptor.addChild(root_4, (CommonTree)adaptor.create(QSTRING, varName));

                        adaptor.addChild(root_3, root_4);
                        }

                        adaptor.addChild(root_2, root_3);
                        }

                        adaptor.addChild(root_1, root_2);
                        }

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                    input.replaceChildren(adaptor.getParent(retval.start),
                                          adaptor.getChildIndex(retval.start),
                                          adaptor.getChildIndex(_last),
                                          retval.tree);}
                    }
                    break;
                case 7 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:301:6: ^(r= REWRITEVNODE q= NOTHING )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    r=(CommonTree)match(input,REWRITEVNODE,FOLLOW_REWRITEVNODE_in_varrewrite1974); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_REWRITEVNODE.add(r);


                    if ( state.backtracking==1 )
                    if ( _first_0==null ) _first_0 = r;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    q=(CommonTree)match(input,NOTHING,FOLLOW_NOTHING_in_varrewrite1978); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_NOTHING.add(q);


                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_1;
                    }



                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==1 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 302:3: -> COMMENT[$q.token, \"dependent variable \" + $q.text]
                    {
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(COMMENT, q.token, "dependent variable " + (q!=null?q.getText():null)));

                    }

                    retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                    input.replaceChildren(adaptor.getParent(retval.start),
                                          adaptor.getChildIndex(retval.start),
                                          adaptor.getChildIndex(_last),
                                          retval.tree);}
                    }
                    break;
                case 8 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:305:6: DELETEVNODE
                    {
                    _last = (CommonTree)input.LT(1);
                    DELETEVNODE22=(CommonTree)match(input,DELETEVNODE,FOLLOW_DELETEVNODE_in_varrewrite1995); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_DELETEVNODE.add(DELETEVNODE22);



                    // AST REWRITE
                    // elements: DELETEVNODE
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==1 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 306:3: -> DELETEVNODE
                    {
                        adaptor.addChild(root_0, stream_DELETEVNODE.nextNode());

                    }

                    retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                    input.replaceChildren(adaptor.getParent(retval.start),
                                          adaptor.getChildIndex(retval.start),
                                          adaptor.getChildIndex(_last),
                                          retval.tree);}
                    }
                    break;
                case 9 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:307:5: ^( REWRITEVNODE1 v= VAR )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    REWRITEVNODE123=(CommonTree)match(input,REWRITEVNODE1,FOLLOW_REWRITEVNODE1_in_varrewrite2009); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_REWRITEVNODE1.add(REWRITEVNODE123);


                    if ( state.backtracking==1 )
                    if ( _first_0==null ) _first_0 = REWRITEVNODE123;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    v=(CommonTree)match(input,VAR,FOLLOW_VAR_in_varrewrite2013); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_VAR.add(v);


                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_1;
                    }



                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==1 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 308:3: -> QSTRING[$v.token, $v.text + \" \"]
                    {
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, v.token, (v!=null?v.getText():null) + " "));

                    }

                    retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                    input.replaceChildren(adaptor.getParent(retval.start),
                                          adaptor.getChildIndex(retval.start),
                                          adaptor.getChildIndex(_last),
                                          retval.tree);}
                    }
                    break;
                case 10 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:309:5: ^( REWRITEVNODE1 vv= NOTHING )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    REWRITEVNODE124=(CommonTree)match(input,REWRITEVNODE1,FOLLOW_REWRITEVNODE1_in_varrewrite2028); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_REWRITEVNODE1.add(REWRITEVNODE124);


                    if ( state.backtracking==1 )
                    if ( _first_0==null ) _first_0 = REWRITEVNODE124;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    vv=(CommonTree)match(input,NOTHING,FOLLOW_NOTHING_in_varrewrite2032); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_NOTHING.add(vv);


                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_1;
                    }



                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==1 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 310:3: -> QSTRING[$vv.token, \" \"]
                    {
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, vv.token, " "));

                    }

                    retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                    input.replaceChildren(adaptor.getParent(retval.start),
                                          adaptor.getChildIndex(retval.start),
                                          adaptor.getChildIndex(_last),
                                          retval.tree);}
                    }
                    break;
                case 11 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:311:5: ^( REWRITEVNODE1 LPAR ^( T_FUNCTION_CALL n= NCNAME ^( T_PARAMS ^( XPATH v= STAR ) ) ) AS v2= VAR RPAR )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    REWRITEVNODE125=(CommonTree)match(input,REWRITEVNODE1,FOLLOW_REWRITEVNODE1_in_varrewrite2047); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_REWRITEVNODE1.add(REWRITEVNODE125);


                    if ( state.backtracking==1 )
                    if ( _first_0==null ) _first_0 = REWRITEVNODE125;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    LPAR26=(CommonTree)match(input,LPAR,FOLLOW_LPAR_in_varrewrite2049); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_LPAR.add(LPAR26);

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_2 = _last;
                    CommonTree _first_2 = null;
                    _last = (CommonTree)input.LT(1);
                    T_FUNCTION_CALL27=(CommonTree)match(input,T_FUNCTION_CALL,FOLLOW_T_FUNCTION_CALL_in_varrewrite2052); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_T_FUNCTION_CALL.add(T_FUNCTION_CALL27);


                    if ( state.backtracking==1 )
                    if ( _first_1==null ) _first_1 = T_FUNCTION_CALL27;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    n=(CommonTree)match(input,NCNAME,FOLLOW_NCNAME_in_varrewrite2056); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_NCNAME.add(n);

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_3 = _last;
                    CommonTree _first_3 = null;
                    _last = (CommonTree)input.LT(1);
                    T_PARAMS28=(CommonTree)match(input,T_PARAMS,FOLLOW_T_PARAMS_in_varrewrite2059); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_T_PARAMS.add(T_PARAMS28);


                    if ( state.backtracking==1 )
                    if ( _first_2==null ) _first_2 = T_PARAMS28;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_4 = _last;
                    CommonTree _first_4 = null;
                    _last = (CommonTree)input.LT(1);
                    XPATH29=(CommonTree)match(input,XPATH,FOLLOW_XPATH_in_varrewrite2062); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_XPATH.add(XPATH29);


                    if ( state.backtracking==1 )
                    if ( _first_3==null ) _first_3 = XPATH29;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    v=(CommonTree)match(input,STAR,FOLLOW_STAR_in_varrewrite2066); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_STAR.add(v);


                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_4;
                    }


                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_3;
                    }


                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_2;
                    }

                    _last = (CommonTree)input.LT(1);
                    AS30=(CommonTree)match(input,AS,FOLLOW_AS_in_varrewrite2071); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_AS.add(AS30);

                    _last = (CommonTree)input.LT(1);
                    v2=(CommonTree)match(input,VAR,FOLLOW_VAR_in_varrewrite2075); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_VAR.add(v2);

                    _last = (CommonTree)input.LT(1);
                    RPAR31=(CommonTree)match(input,RPAR,FOLLOW_RPAR_in_varrewrite2077); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_RPAR.add(RPAR31);


                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_1;
                    }

                    if ( state.backtracking==1 ) {
                      logger.fine("\n\n------rewrite-2------");logger.fine("(" + (n!=null?n.getText():null) + "(*) AS " + (v2!=null?v2.getText():null) + ")");
                    }


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==1 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 313:3: -> QSTRING[$n.token, \"(\" + $n.text + \"(*) AS \" + $v2.text + \")\"]
                    {
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, n.token, "(" + (n!=null?n.getText():null) + "(*) AS " + (v2!=null?v2.getText():null) + ")"));

                    }

                    retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                    input.replaceChildren(adaptor.getParent(retval.start),
                                          adaptor.getChildIndex(retval.start),
                                          adaptor.getChildIndex(_last),
                                          retval.tree);}
                    }
                    break;
                case 12 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:314:5: ^( REWRITEVNODE1 LPAR ^( T_FUNCTION_CALL n= NCNAME ^( T_PARAMS ^( XPATH v= VAR ) ) ) AS v2= VAR RPAR )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    REWRITEVNODE132=(CommonTree)match(input,REWRITEVNODE1,FOLLOW_REWRITEVNODE1_in_varrewrite2096); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_REWRITEVNODE1.add(REWRITEVNODE132);


                    if ( state.backtracking==1 )
                    if ( _first_0==null ) _first_0 = REWRITEVNODE132;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    LPAR33=(CommonTree)match(input,LPAR,FOLLOW_LPAR_in_varrewrite2098); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_LPAR.add(LPAR33);

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_2 = _last;
                    CommonTree _first_2 = null;
                    _last = (CommonTree)input.LT(1);
                    T_FUNCTION_CALL34=(CommonTree)match(input,T_FUNCTION_CALL,FOLLOW_T_FUNCTION_CALL_in_varrewrite2101); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_T_FUNCTION_CALL.add(T_FUNCTION_CALL34);


                    if ( state.backtracking==1 )
                    if ( _first_1==null ) _first_1 = T_FUNCTION_CALL34;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    n=(CommonTree)match(input,NCNAME,FOLLOW_NCNAME_in_varrewrite2105); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_NCNAME.add(n);

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_3 = _last;
                    CommonTree _first_3 = null;
                    _last = (CommonTree)input.LT(1);
                    T_PARAMS35=(CommonTree)match(input,T_PARAMS,FOLLOW_T_PARAMS_in_varrewrite2108); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_T_PARAMS.add(T_PARAMS35);


                    if ( state.backtracking==1 )
                    if ( _first_2==null ) _first_2 = T_PARAMS35;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_4 = _last;
                    CommonTree _first_4 = null;
                    _last = (CommonTree)input.LT(1);
                    XPATH36=(CommonTree)match(input,XPATH,FOLLOW_XPATH_in_varrewrite2111); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_XPATH.add(XPATH36);


                    if ( state.backtracking==1 )
                    if ( _first_3==null ) _first_3 = XPATH36;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    v=(CommonTree)match(input,VAR,FOLLOW_VAR_in_varrewrite2115); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_VAR.add(v);


                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_4;
                    }


                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_3;
                    }


                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_2;
                    }

                    _last = (CommonTree)input.LT(1);
                    AS37=(CommonTree)match(input,AS,FOLLOW_AS_in_varrewrite2120); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_AS.add(AS37);

                    _last = (CommonTree)input.LT(1);
                    v2=(CommonTree)match(input,VAR,FOLLOW_VAR_in_varrewrite2124); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_VAR.add(v2);

                    _last = (CommonTree)input.LT(1);
                    RPAR38=(CommonTree)match(input,RPAR,FOLLOW_RPAR_in_varrewrite2126); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_RPAR.add(RPAR38);


                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_1;
                    }

                    if ( state.backtracking==1 ) {
                      logger.fine("\n\n------rewrite-1------");logger.fine("(" + (n!=null?n.getText():null) + "(" + (v!=null?v.getText():null) + ") AS " + (v2!=null?v2.getText():null) + ")");
                    }


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==1 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 316:3: -> QSTRING[$n.token, \"(\" + $n.text + \"(\" + $v.text + \") AS \" + $v2.text + \")\"]
                    {
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, n.token, "(" + (n!=null?n.getText():null) + "(" + (v!=null?v.getText():null) + ") AS " + (v2!=null?v2.getText():null) + ")"));

                    }

                    retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                    input.replaceChildren(adaptor.getParent(retval.start),
                                          adaptor.getChildIndex(retval.start),
                                          adaptor.getChildIndex(_last),
                                          retval.tree);}
                    }
                    break;
                case 13 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:317:5: ^( REWRITEVNODE1 ^(t= T_ASVAR LPAR (e+= . )+ AS v= VAR RPAR ) )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    REWRITEVNODE139=(CommonTree)match(input,REWRITEVNODE1,FOLLOW_REWRITEVNODE1_in_varrewrite2145); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_REWRITEVNODE1.add(REWRITEVNODE139);


                    if ( state.backtracking==1 )
                    if ( _first_0==null ) _first_0 = REWRITEVNODE139;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_2 = _last;
                    CommonTree _first_2 = null;
                    _last = (CommonTree)input.LT(1);
                    t=(CommonTree)match(input,T_ASVAR,FOLLOW_T_ASVAR_in_varrewrite2150); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_T_ASVAR.add(t);


                    if ( state.backtracking==1 )
                    if ( _first_1==null ) _first_1 = t;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    LPAR40=(CommonTree)match(input,LPAR,FOLLOW_LPAR_in_varrewrite2152); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_LPAR.add(LPAR40);

                    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:317:39: (e+= . )+
                    int cnt3=0;
                    loop3:
                    do {
                        int alt3=2;
                        int LA3_0 = input.LA(1);

                        if ( (LA3_0==AS) ) {
                            int LA3_1 = input.LA(2);

                            if ( (LA3_1==VAR) ) {
                                int LA3_3 = input.LA(3);

                                if ( (LA3_3==RPAR) ) {
                                    int LA3_4 = input.LA(4);

                                    if ( (LA3_4==DOWN||(LA3_4>=VAR && LA3_4<=T_UNOPTIMIZED_FUNCTION_CALL)) ) {
                                        alt3=1;
                                    }


                                }
                                else if ( (LA3_3==DOWN||(LA3_3>=VAR && LA3_3<=LPAR)||(LA3_3>=SEMICOLON && LA3_3<=T_UNOPTIMIZED_FUNCTION_CALL)) ) {
                                    alt3=1;
                                }


                            }
                            else if ( (LA3_1==DOWN||(LA3_1>=ENDELM && LA3_1<=T_UNOPTIMIZED_FUNCTION_CALL)) ) {
                                alt3=1;
                            }


                        }
                        else if ( ((LA3_0>=VAR && LA3_0<=IN)||(LA3_0>=DESCENDING && LA3_0<=T_UNOPTIMIZED_FUNCTION_CALL)) ) {
                            alt3=1;
                        }


                        switch (alt3) {
                    	case 1 :
                    	    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:0:0: e+= .
                    	    {
                    	    _last = (CommonTree)input.LT(1);
                    	    e=(CommonTree)input.LT(1);
                    	    matchAny(input); if (state.failed) return retval;
                    	     
                    	    if ( state.backtracking==1 )
                    	    if ( _first_2==null ) _first_2 = e;
                    	    if (list_e==null) list_e=new ArrayList();
                    	    list_e.add(e);


                    	    if ( state.backtracking==1 ) {
                    	    retval.tree = (CommonTree)_first_0;
                    	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                    	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);}
                    	    }
                    	    break;

                    	default :
                    	    if ( cnt3 >= 1 ) break loop3;
                    	    if (state.backtracking>0) {state.failed=true; return retval;}
                                EarlyExitException eee =
                                    new EarlyExitException(3, input);
                                throw eee;
                        }
                        cnt3++;
                    } while (true);

                    _last = (CommonTree)input.LT(1);
                    AS41=(CommonTree)match(input,AS,FOLLOW_AS_in_varrewrite2159); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_AS.add(AS41);

                    _last = (CommonTree)input.LT(1);
                    v=(CommonTree)match(input,VAR,FOLLOW_VAR_in_varrewrite2163); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_VAR.add(v);

                    _last = (CommonTree)input.LT(1);
                    RPAR42=(CommonTree)match(input,RPAR,FOLLOW_RPAR_in_varrewrite2165); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_RPAR.add(RPAR42);


                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_2;
                    }


                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_1;
                    }

                    if ( state.backtracking==1 ) {
                      logger.fine("\n\n------rewrite-0------");logger.fine("(" + exprToString(list_e) + " AS " + (v!=null?v.getText():null) + ")");
                    }


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==1 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 319:3: -> QSTRING[$t.token, \"(\" + exprToString($e) + \" AS \" + $v.text + \")\"]
                    {
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(QSTRING, t.token, "(" + exprToString(list_e) + " AS " + (v!=null?v.getText():null) + ")"));

                    }

                    retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                    input.replaceChildren(adaptor.getParent(retval.start),
                                          adaptor.getChildIndex(retval.start),
                                          adaptor.getChildIndex(_last),
                                          retval.tree);}
                    }
                    break;
                case 14 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:320:5: ^(r= REWRITEVNODE ^( T_ASVAR LPAR (e+= . )+ AS v= VAR RPAR ) )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    r=(CommonTree)match(input,REWRITEVNODE,FOLLOW_REWRITEVNODE_in_varrewrite2187); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_REWRITEVNODE.add(r);


                    if ( state.backtracking==1 )
                    if ( _first_0==null ) _first_0 = r;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_2 = _last;
                    CommonTree _first_2 = null;
                    _last = (CommonTree)input.LT(1);
                    T_ASVAR43=(CommonTree)match(input,T_ASVAR,FOLLOW_T_ASVAR_in_varrewrite2190); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_T_ASVAR.add(T_ASVAR43);


                    if ( state.backtracking==1 )
                    if ( _first_1==null ) _first_1 = T_ASVAR43;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    LPAR44=(CommonTree)match(input,LPAR,FOLLOW_LPAR_in_varrewrite2192); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_LPAR.add(LPAR44);

                    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:320:38: (e+= . )+
                    int cnt4=0;
                    loop4:
                    do {
                        int alt4=2;
                        int LA4_0 = input.LA(1);

                        if ( (LA4_0==AS) ) {
                            int LA4_1 = input.LA(2);

                            if ( (LA4_1==VAR) ) {
                                int LA4_3 = input.LA(3);

                                if ( (LA4_3==RPAR) ) {
                                    int LA4_4 = input.LA(4);

                                    if ( (LA4_4==DOWN||(LA4_4>=VAR && LA4_4<=T_UNOPTIMIZED_FUNCTION_CALL)) ) {
                                        alt4=1;
                                    }


                                }
                                else if ( (LA4_3==DOWN||(LA4_3>=VAR && LA4_3<=LPAR)||(LA4_3>=SEMICOLON && LA4_3<=T_UNOPTIMIZED_FUNCTION_CALL)) ) {
                                    alt4=1;
                                }


                            }
                            else if ( (LA4_1==DOWN||(LA4_1>=ENDELM && LA4_1<=T_UNOPTIMIZED_FUNCTION_CALL)) ) {
                                alt4=1;
                            }


                        }
                        else if ( ((LA4_0>=VAR && LA4_0<=IN)||(LA4_0>=DESCENDING && LA4_0<=T_UNOPTIMIZED_FUNCTION_CALL)) ) {
                            alt4=1;
                        }


                        switch (alt4) {
                    	case 1 :
                    	    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:0:0: e+= .
                    	    {
                    	    _last = (CommonTree)input.LT(1);
                    	    e=(CommonTree)input.LT(1);
                    	    matchAny(input); if (state.failed) return retval;
                    	     
                    	    if ( state.backtracking==1 )
                    	    if ( _first_2==null ) _first_2 = e;
                    	    if (list_e==null) list_e=new ArrayList();
                    	    list_e.add(e);


                    	    if ( state.backtracking==1 ) {
                    	    retval.tree = (CommonTree)_first_0;
                    	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                    	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);}
                    	    }
                    	    break;

                    	default :
                    	    if ( cnt4 >= 1 ) break loop4;
                    	    if (state.backtracking>0) {state.failed=true; return retval;}
                                EarlyExitException eee =
                                    new EarlyExitException(4, input);
                                throw eee;
                        }
                        cnt4++;
                    } while (true);

                    _last = (CommonTree)input.LT(1);
                    AS45=(CommonTree)match(input,AS,FOLLOW_AS_in_varrewrite2199); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_AS.add(AS45);

                    _last = (CommonTree)input.LT(1);
                    v=(CommonTree)match(input,VAR,FOLLOW_VAR_in_varrewrite2203); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_VAR.add(v);

                    _last = (CommonTree)input.LT(1);
                    RPAR46=(CommonTree)match(input,RPAR,FOLLOW_RPAR_in_varrewrite2205); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_RPAR.add(RPAR46);


                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_2;
                    }


                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_1;
                    }

                    if ( state.backtracking==1 ) {
                       varName=Helper.removeLeading((v!=null?v.getText():null), "$"); 
                    }


                    // AST REWRITE
                    // elements: VAR, VAR
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==1 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 321:3: -> ^( T_FLWOR[$v.token,\"i'm a stupid flworExpr 4\"] COMMENT[\"SPARQL variable \" + $v.text + \" from \" + $v.line + \":\" + $v.pos] ^( T_LET[$v.token,\"LET\"] VAR[$v.token, \"\\$\" + varName ] ^( T_FUNCTION_CALL NCNAME[nodeFunction] ^( T_PARAMS VAR[$r.text] QSTRING[varName] ) ) ) )
                    {
                        // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:321:6: ^( T_FLWOR[$v.token,\"i'm a stupid flworExpr 4\"] COMMENT[\"SPARQL variable \" + $v.text + \" from \" + $v.line + \":\" + $v.pos] ^( T_LET[$v.token,\"LET\"] VAR[$v.token, \"\\$\" + varName ] ^( T_FUNCTION_CALL NCNAME[nodeFunction] ^( T_PARAMS VAR[$r.text] QSTRING[varName] ) ) ) )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FLWOR, v.token, "i'm a stupid flworExpr 4"), root_1);

                        adaptor.addChild(root_1, (CommonTree)adaptor.create(COMMENT, "SPARQL variable " + (v!=null?v.getText():null) + " from " + (v!=null?v.getLine():0) + ":" + (v!=null?v.getCharPositionInLine():0)));
                        // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:323:8: ^( T_LET[$v.token,\"LET\"] VAR[$v.token, \"\\$\" + varName ] ^( T_FUNCTION_CALL NCNAME[nodeFunction] ^( T_PARAMS VAR[$r.text] QSTRING[varName] ) ) )
                        {
                        CommonTree root_2 = (CommonTree)adaptor.nil();
                        root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_LET, v.token, "LET"), root_2);

                        adaptor.addChild(root_2, (CommonTree)adaptor.create(VAR, v.token, "$" + varName));
                        // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:325:10: ^( T_FUNCTION_CALL NCNAME[nodeFunction] ^( T_PARAMS VAR[$r.text] QSTRING[varName] ) )
                        {
                        CommonTree root_3 = (CommonTree)adaptor.nil();
                        root_3 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FUNCTION_CALL, "T_FUNCTION_CALL"), root_3);

                        adaptor.addChild(root_3, (CommonTree)adaptor.create(NCNAME, nodeFunction));
                        // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:327:12: ^( T_PARAMS VAR[$r.text] QSTRING[varName] )
                        {
                        CommonTree root_4 = (CommonTree)adaptor.nil();
                        root_4 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_PARAMS, "T_PARAMS"), root_4);

                        adaptor.addChild(root_4, (CommonTree)adaptor.create(VAR, (r!=null?r.getText():null)));
                        adaptor.addChild(root_4, (CommonTree)adaptor.create(QSTRING, varName));

                        adaptor.addChild(root_3, root_4);
                        }

                        adaptor.addChild(root_2, root_3);
                        }

                        adaptor.addChild(root_1, root_2);
                        }

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                    input.replaceChildren(adaptor.getParent(retval.start),
                                          adaptor.getChildIndex(retval.start),
                                          adaptor.getChildIndex(_last),
                                          retval.tree);}
                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "varrewrite"

    public static class singleconcat_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "singleconcat"
    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:338:1: singleconcat : ^( T_FUNCTION_CALL f= NCNAME ^( T_PARAMS QSTRING ) ) -> {$f.text.equals(\"fn:concat\")}? QSTRING -> ^( T_FUNCTION_CALL $f ^( T_PARAMS QSTRING ) ) ;
    public final XSPARQLSimplifier.singleconcat_return singleconcat() throws RecognitionException {
        XSPARQLSimplifier.singleconcat_return retval = new XSPARQLSimplifier.singleconcat_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree f=null;
        CommonTree T_FUNCTION_CALL47=null;
        CommonTree T_PARAMS48=null;
        CommonTree QSTRING49=null;

        CommonTree f_tree=null;
        CommonTree T_FUNCTION_CALL47_tree=null;
        CommonTree T_PARAMS48_tree=null;
        CommonTree QSTRING49_tree=null;
        RewriteRuleNodeStream stream_T_PARAMS=new RewriteRuleNodeStream(adaptor,"token T_PARAMS");
        RewriteRuleNodeStream stream_QSTRING=new RewriteRuleNodeStream(adaptor,"token QSTRING");
        RewriteRuleNodeStream stream_T_FUNCTION_CALL=new RewriteRuleNodeStream(adaptor,"token T_FUNCTION_CALL");
        RewriteRuleNodeStream stream_NCNAME=new RewriteRuleNodeStream(adaptor,"token NCNAME");

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:339:3: ( ^( T_FUNCTION_CALL f= NCNAME ^( T_PARAMS QSTRING ) ) -> {$f.text.equals(\"fn:concat\")}? QSTRING -> ^( T_FUNCTION_CALL $f ^( T_PARAMS QSTRING ) ) )
            // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:339:5: ^( T_FUNCTION_CALL f= NCNAME ^( T_PARAMS QSTRING ) )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            T_FUNCTION_CALL47=(CommonTree)match(input,T_FUNCTION_CALL,FOLLOW_T_FUNCTION_CALL_in_singleconcat2391); if (state.failed) return retval; 
            if ( state.backtracking==1 ) stream_T_FUNCTION_CALL.add(T_FUNCTION_CALL47);


            if ( state.backtracking==1 )
            if ( _first_0==null ) _first_0 = T_FUNCTION_CALL47;
            match(input, Token.DOWN, null); if (state.failed) return retval;
            _last = (CommonTree)input.LT(1);
            f=(CommonTree)match(input,NCNAME,FOLLOW_NCNAME_in_singleconcat2395); if (state.failed) return retval; 
            if ( state.backtracking==1 ) stream_NCNAME.add(f);

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_2 = _last;
            CommonTree _first_2 = null;
            _last = (CommonTree)input.LT(1);
            T_PARAMS48=(CommonTree)match(input,T_PARAMS,FOLLOW_T_PARAMS_in_singleconcat2398); if (state.failed) return retval; 
            if ( state.backtracking==1 ) stream_T_PARAMS.add(T_PARAMS48);


            if ( state.backtracking==1 )
            if ( _first_1==null ) _first_1 = T_PARAMS48;
            match(input, Token.DOWN, null); if (state.failed) return retval;
            _last = (CommonTree)input.LT(1);
            QSTRING49=(CommonTree)match(input,QSTRING,FOLLOW_QSTRING_in_singleconcat2400); if (state.failed) return retval; 
            if ( state.backtracking==1 ) stream_QSTRING.add(QSTRING49);


            match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_2;
            }


            match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_1;
            }

            if ( state.backtracking==1 ) {
              logger.fine("\n\n------singleconcat-----");
            }


            // AST REWRITE
            // elements: T_PARAMS, f, QSTRING, QSTRING, T_FUNCTION_CALL
            // token labels: f
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==1 ) {
            retval.tree = root_0;
            RewriteRuleNodeStream stream_f=new RewriteRuleNodeStream(adaptor,"token f",f);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 341:3: -> {$f.text.equals(\"fn:concat\")}? QSTRING
            if ((f!=null?f.getText():null).equals("fn:concat")) {
                adaptor.addChild(root_0, stream_QSTRING.nextNode());

            }
            else // 342:3: -> ^( T_FUNCTION_CALL $f ^( T_PARAMS QSTRING ) )
            {
                // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:342:6: ^( T_FUNCTION_CALL $f ^( T_PARAMS QSTRING ) )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(stream_T_FUNCTION_CALL.nextNode(), root_1);

                adaptor.addChild(root_1, stream_f.nextNode());
                // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:342:27: ^( T_PARAMS QSTRING )
                {
                CommonTree root_2 = (CommonTree)adaptor.nil();
                root_2 = (CommonTree)adaptor.becomeRoot(stream_T_PARAMS.nextNode(), root_2);

                adaptor.addChild(root_2, stream_QSTRING.nextNode());

                adaptor.addChild(root_1, root_2);
                }

                adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            input.replaceChildren(adaptor.getParent(retval.start),
                                  adaptor.getChildIndex(retval.start),
                                  adaptor.getChildIndex(_last),
                                  retval.tree);}
            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "singleconcat"

    public static class markunoptimized_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "markunoptimized"
    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:348:1: markunoptimized : ^(t= T_FUNCTION_CALL f= NCNAME params= . ) -> {$f.text.equals(\"fn:concat\")}? ^( T_UNOPTIMIZED_FUNCTION_CALL $f $params) -> ^( $t $f $params) ;
    public final XSPARQLSimplifier.markunoptimized_return markunoptimized() throws RecognitionException {
        XSPARQLSimplifier.markunoptimized_return retval = new XSPARQLSimplifier.markunoptimized_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree t=null;
        CommonTree f=null;
        CommonTree params=null;

        CommonTree t_tree=null;
        CommonTree f_tree=null;
        CommonTree params_tree=null;
        RewriteRuleNodeStream stream_T_FUNCTION_CALL=new RewriteRuleNodeStream(adaptor,"token T_FUNCTION_CALL");
        RewriteRuleNodeStream stream_NCNAME=new RewriteRuleNodeStream(adaptor,"token NCNAME");

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:349:3: ( ^(t= T_FUNCTION_CALL f= NCNAME params= . ) -> {$f.text.equals(\"fn:concat\")}? ^( T_UNOPTIMIZED_FUNCTION_CALL $f $params) -> ^( $t $f $params) )
            // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:349:5: ^(t= T_FUNCTION_CALL f= NCNAME params= . )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            t=(CommonTree)match(input,T_FUNCTION_CALL,FOLLOW_T_FUNCTION_CALL_in_markunoptimized2453); if (state.failed) return retval; 
            if ( state.backtracking==1 ) stream_T_FUNCTION_CALL.add(t);


            if ( state.backtracking==1 )
            if ( _first_0==null ) _first_0 = t;
            match(input, Token.DOWN, null); if (state.failed) return retval;
            _last = (CommonTree)input.LT(1);
            f=(CommonTree)match(input,NCNAME,FOLLOW_NCNAME_in_markunoptimized2457); if (state.failed) return retval; 
            if ( state.backtracking==1 ) stream_NCNAME.add(f);

            _last = (CommonTree)input.LT(1);
            params=(CommonTree)input.LT(1);
            matchAny(input); if (state.failed) return retval;
             
            if ( state.backtracking==1 )
            if ( _first_1==null ) _first_1 = params;

            match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_1;
            }

            if ( state.backtracking==1 ) {
              logger.fine("\n\n------markunoptimized-----");logger.fine((f!=null?f.getText():null));
            }


            // AST REWRITE
            // elements: params, f, f, t, params
            // token labels: t, f
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: params
            if ( state.backtracking==1 ) {
            retval.tree = root_0;
            RewriteRuleNodeStream stream_t=new RewriteRuleNodeStream(adaptor,"token t",t);
            RewriteRuleNodeStream stream_f=new RewriteRuleNodeStream(adaptor,"token f",f);
            RewriteRuleSubtreeStream stream_params=new RewriteRuleSubtreeStream(adaptor,"wildcard params",params);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 351:3: -> {$f.text.equals(\"fn:concat\")}? ^( T_UNOPTIMIZED_FUNCTION_CALL $f $params)
            if ((f!=null?f.getText():null).equals("fn:concat")) {
                // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:351:37: ^( T_UNOPTIMIZED_FUNCTION_CALL $f $params)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_UNOPTIMIZED_FUNCTION_CALL, "T_UNOPTIMIZED_FUNCTION_CALL"), root_1);

                adaptor.addChild(root_1, stream_f.nextNode());
                adaptor.addChild(root_1, stream_params.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }
            else // 352:3: -> ^( $t $f $params)
            {
                // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:352:6: ^( $t $f $params)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(stream_t.nextNode(), root_1);

                adaptor.addChild(root_1, stream_f.nextNode());
                adaptor.addChild(root_1, stream_params.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            input.replaceChildren(adaptor.getParent(retval.start),
                                  adaptor.getChildIndex(retval.start),
                                  adaptor.getChildIndex(_last),
                                  retval.tree);}
            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "markunoptimized"

    public static class bottomup_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "bottomup"
    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:358:1: bottomup : staticconcat ;
    public final XSPARQLSimplifier.bottomup_return bottomup() throws RecognitionException {
        XSPARQLSimplifier.bottomup_return retval = new XSPARQLSimplifier.bottomup_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        XSPARQLSimplifier.staticconcat_return staticconcat50 = null;



        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:359:3: ( staticconcat )
            // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:359:5: staticconcat
            {
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_staticconcat_in_bottomup2513);
            staticconcat50=staticconcat();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==1 ) 
             
            if ( _first_0==null ) _first_0 = staticconcat50.tree;

            if ( state.backtracking==1 ) {
            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);}
            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "bottomup"

    public static class staticconcat_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "staticconcat"
    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:362:1: staticconcat : ( ^( T_UNOPTIMIZED_FUNCTION_CALL NCNAME ^( T_PARAMS ( VAR )? (q+= qstringandfunctioncall )* q2= QSTRING q3= QSTRING (rest+= . )* ) ) -> ^( T_UNOPTIMIZED_FUNCTION_CALL NCNAME ^( T_PARAMS ( VAR )? ( $q)* QSTRING[$q2.token, $q2.text + $q3.text] ( $rest)* ) ) | ^( T_UNOPTIMIZED_FUNCTION_CALL NCNAME ^( T_PARAMS ( VAR )? (q+= qstringandfunctioncall )+ (q1= QSTRING )? ) ) -> ^( T_FUNCTION_CALL NCNAME ^( T_PARAMS ( VAR )? ( $q)+ ( $q1)? ) ) | ^( T_UNOPTIMIZED_FUNCTION_CALL NCNAME ^( T_PARAMS VAR q1= QSTRING ) ) -> ^( T_FUNCTION_CALL NCNAME ^( T_PARAMS VAR $q1) ) | ^( T_UNOPTIMIZED_FUNCTION_CALL NCNAME ^( T_PARAMS QSTRING ) ) -> QSTRING | ^( T_GROUP_BY q1= QSTRING q2= QSTRING (rest+= . )* ) -> ^( T_GROUP_BY QSTRING[$q1.token, $q1.text + $q2.text] ( $rest)* ) | ^( T_HAVING q1= QSTRING q2= QSTRING (rest+= . )* ) -> ^( T_HAVING QSTRING[$q1.token, $q1.text + $q2.text] ( $rest)* ) | ^( VALUES LPAR ) );
    public final XSPARQLSimplifier.staticconcat_return staticconcat() throws RecognitionException {
        XSPARQLSimplifier.staticconcat_return retval = new XSPARQLSimplifier.staticconcat_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree q2=null;
        CommonTree q3=null;
        CommonTree q1=null;
        CommonTree T_UNOPTIMIZED_FUNCTION_CALL51=null;
        CommonTree NCNAME52=null;
        CommonTree T_PARAMS53=null;
        CommonTree VAR54=null;
        CommonTree T_UNOPTIMIZED_FUNCTION_CALL55=null;
        CommonTree NCNAME56=null;
        CommonTree T_PARAMS57=null;
        CommonTree VAR58=null;
        CommonTree T_UNOPTIMIZED_FUNCTION_CALL59=null;
        CommonTree NCNAME60=null;
        CommonTree T_PARAMS61=null;
        CommonTree VAR62=null;
        CommonTree T_UNOPTIMIZED_FUNCTION_CALL63=null;
        CommonTree NCNAME64=null;
        CommonTree T_PARAMS65=null;
        CommonTree QSTRING66=null;
        CommonTree T_GROUP_BY67=null;
        CommonTree T_HAVING68=null;
        CommonTree VALUES69=null;
        CommonTree LPAR70=null;
        CommonTree rest=null;
        List list_q=null;
        List list_rest=null;
        RuleReturnScope q = null;
        CommonTree q2_tree=null;
        CommonTree q3_tree=null;
        CommonTree q1_tree=null;
        CommonTree T_UNOPTIMIZED_FUNCTION_CALL51_tree=null;
        CommonTree NCNAME52_tree=null;
        CommonTree T_PARAMS53_tree=null;
        CommonTree VAR54_tree=null;
        CommonTree T_UNOPTIMIZED_FUNCTION_CALL55_tree=null;
        CommonTree NCNAME56_tree=null;
        CommonTree T_PARAMS57_tree=null;
        CommonTree VAR58_tree=null;
        CommonTree T_UNOPTIMIZED_FUNCTION_CALL59_tree=null;
        CommonTree NCNAME60_tree=null;
        CommonTree T_PARAMS61_tree=null;
        CommonTree VAR62_tree=null;
        CommonTree T_UNOPTIMIZED_FUNCTION_CALL63_tree=null;
        CommonTree NCNAME64_tree=null;
        CommonTree T_PARAMS65_tree=null;
        CommonTree QSTRING66_tree=null;
        CommonTree T_GROUP_BY67_tree=null;
        CommonTree T_HAVING68_tree=null;
        CommonTree VALUES69_tree=null;
        CommonTree LPAR70_tree=null;
        CommonTree rest_tree=null;
        RewriteRuleNodeStream stream_T_PARAMS=new RewriteRuleNodeStream(adaptor,"token T_PARAMS");
        RewriteRuleNodeStream stream_T_GROUP_BY=new RewriteRuleNodeStream(adaptor,"token T_GROUP_BY");
        RewriteRuleNodeStream stream_T_UNOPTIMIZED_FUNCTION_CALL=new RewriteRuleNodeStream(adaptor,"token T_UNOPTIMIZED_FUNCTION_CALL");
        RewriteRuleNodeStream stream_QSTRING=new RewriteRuleNodeStream(adaptor,"token QSTRING");
        RewriteRuleNodeStream stream_VAR=new RewriteRuleNodeStream(adaptor,"token VAR");
        RewriteRuleNodeStream stream_T_HAVING=new RewriteRuleNodeStream(adaptor,"token T_HAVING");
        RewriteRuleNodeStream stream_NCNAME=new RewriteRuleNodeStream(adaptor,"token NCNAME");
        RewriteRuleSubtreeStream stream_qstringandfunctioncall=new RewriteRuleSubtreeStream(adaptor,"rule qstringandfunctioncall");
        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:363:3: ( ^( T_UNOPTIMIZED_FUNCTION_CALL NCNAME ^( T_PARAMS ( VAR )? (q+= qstringandfunctioncall )* q2= QSTRING q3= QSTRING (rest+= . )* ) ) -> ^( T_UNOPTIMIZED_FUNCTION_CALL NCNAME ^( T_PARAMS ( VAR )? ( $q)* QSTRING[$q2.token, $q2.text + $q3.text] ( $rest)* ) ) | ^( T_UNOPTIMIZED_FUNCTION_CALL NCNAME ^( T_PARAMS ( VAR )? (q+= qstringandfunctioncall )+ (q1= QSTRING )? ) ) -> ^( T_FUNCTION_CALL NCNAME ^( T_PARAMS ( VAR )? ( $q)+ ( $q1)? ) ) | ^( T_UNOPTIMIZED_FUNCTION_CALL NCNAME ^( T_PARAMS VAR q1= QSTRING ) ) -> ^( T_FUNCTION_CALL NCNAME ^( T_PARAMS VAR $q1) ) | ^( T_UNOPTIMIZED_FUNCTION_CALL NCNAME ^( T_PARAMS QSTRING ) ) -> QSTRING | ^( T_GROUP_BY q1= QSTRING q2= QSTRING (rest+= . )* ) -> ^( T_GROUP_BY QSTRING[$q1.token, $q1.text + $q2.text] ( $rest)* ) | ^( T_HAVING q1= QSTRING q2= QSTRING (rest+= . )* ) -> ^( T_HAVING QSTRING[$q1.token, $q1.text + $q2.text] ( $rest)* ) | ^( VALUES LPAR ) )
            int alt14=7;
            alt14 = dfa14.predict(input);
            switch (alt14) {
                case 1 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:363:5: ^( T_UNOPTIMIZED_FUNCTION_CALL NCNAME ^( T_PARAMS ( VAR )? (q+= qstringandfunctioncall )* q2= QSTRING q3= QSTRING (rest+= . )* ) )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    T_UNOPTIMIZED_FUNCTION_CALL51=(CommonTree)match(input,T_UNOPTIMIZED_FUNCTION_CALL,FOLLOW_T_UNOPTIMIZED_FUNCTION_CALL_in_staticconcat2528); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_T_UNOPTIMIZED_FUNCTION_CALL.add(T_UNOPTIMIZED_FUNCTION_CALL51);


                    if ( state.backtracking==1 )
                    if ( _first_0==null ) _first_0 = T_UNOPTIMIZED_FUNCTION_CALL51;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    NCNAME52=(CommonTree)match(input,NCNAME,FOLLOW_NCNAME_in_staticconcat2530); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_NCNAME.add(NCNAME52);

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_2 = _last;
                    CommonTree _first_2 = null;
                    _last = (CommonTree)input.LT(1);
                    T_PARAMS53=(CommonTree)match(input,T_PARAMS,FOLLOW_T_PARAMS_in_staticconcat2533); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_T_PARAMS.add(T_PARAMS53);


                    if ( state.backtracking==1 )
                    if ( _first_1==null ) _first_1 = T_PARAMS53;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:363:53: ( VAR )?
                    int alt6=2;
                    switch ( input.LA(1) ) {
                        case VAR:
                            {
                            alt6=1;
                            }
                            break;
                    }

                    switch (alt6) {
                        case 1 :
                            // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:0:0: VAR
                            {
                            _last = (CommonTree)input.LT(1);
                            VAR54=(CommonTree)match(input,VAR,FOLLOW_VAR_in_staticconcat2535); if (state.failed) return retval; 
                            if ( state.backtracking==1 ) stream_VAR.add(VAR54);


                            if ( state.backtracking==1 ) {
                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);}
                            }
                            break;

                    }

                    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:363:59: (q+= qstringandfunctioncall )*
                    loop7:
                    do {
                        int alt7=2;
                        switch ( input.LA(1) ) {
                        case QSTRING:
                            {
                            switch ( input.LA(2) ) {
                            case T_FUNCTION_CALL:
                                {
                                alt7=1;
                                }
                                break;

                            }

                            }
                            break;

                        }

                        switch (alt7) {
                    	case 1 :
                    	    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:0:0: q+= qstringandfunctioncall
                    	    {
                    	    _last = (CommonTree)input.LT(1);
                    	    _last = (CommonTree)input.LT(1);
                    	    pushFollow(FOLLOW_qstringandfunctioncall_in_staticconcat2540);
                    	    q=qstringandfunctioncall();

                    	    state._fsp--;
                    	    if (state.failed) return retval;
                    	    if ( state.backtracking==1 ) stream_qstringandfunctioncall.add(q.getTree());
                    	    if (list_q==null) list_q=new ArrayList();
                    	    list_q.add(q.getTree());


                    	    if ( state.backtracking==1 ) {
                    	    retval.tree = (CommonTree)_first_0;
                    	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                    	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);}
                    	    }
                    	    break;

                    	default :
                    	    break loop7;
                        }
                    } while (true);

                    _last = (CommonTree)input.LT(1);
                    q2=(CommonTree)match(input,QSTRING,FOLLOW_QSTRING_in_staticconcat2545); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_QSTRING.add(q2);

                    _last = (CommonTree)input.LT(1);
                    q3=(CommonTree)match(input,QSTRING,FOLLOW_QSTRING_in_staticconcat2549); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_QSTRING.add(q3);

                    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:363:111: (rest+= . )*
                    loop8:
                    do {
                        int alt8=2;
                        int LA8_0 = input.LA(1);

                        if ( ((LA8_0>=VAR && LA8_0<=T_UNOPTIMIZED_FUNCTION_CALL)) ) {
                            alt8=1;
                        }


                        switch (alt8) {
                    	case 1 :
                    	    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:0:0: rest+= .
                    	    {
                    	    _last = (CommonTree)input.LT(1);
                    	    rest=(CommonTree)input.LT(1);
                    	    matchAny(input); if (state.failed) return retval;
                    	     
                    	    if ( state.backtracking==1 )
                    	    if ( _first_2==null ) _first_2 = rest;
                    	    if (list_rest==null) list_rest=new ArrayList();
                    	    list_rest.add(rest);


                    	    if ( state.backtracking==1 ) {
                    	    retval.tree = (CommonTree)_first_0;
                    	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                    	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);}
                    	    }
                    	    break;

                    	default :
                    	    break loop8;
                        }
                    } while (true);


                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_2;
                    }


                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_1;
                    }

                    if ( state.backtracking==1 ) {
                       logger.fine("\n\n------statitconcat-1----");
                          logger.fine("-q2+q3---------");
                          logger.fine((q2!=null?q2.getText():null) +"+"+ (q3!=null?q3.getText():null));
                          logger.fine("-q-------------");
                          logger.fine(""+list_q);
                          logger.fine("-rest----------");
                          logger.fine(""+list_rest);
                          logger.fine("-----------");
                    }


                    // AST REWRITE
                    // elements: QSTRING, rest, T_PARAMS, T_UNOPTIMIZED_FUNCTION_CALL, NCNAME, q, VAR
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: q
                    // wildcard labels: rest
                    if ( state.backtracking==1 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_rest=new RewriteRuleSubtreeStream(adaptor,"wildcard rest",list_rest);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_q=new RewriteRuleSubtreeStream(adaptor,"token q",list_q);
                    root_0 = (CommonTree)adaptor.nil();
                    // 372:3: -> ^( T_UNOPTIMIZED_FUNCTION_CALL NCNAME ^( T_PARAMS ( VAR )? ( $q)* QSTRING[$q2.token, $q2.text + $q3.text] ( $rest)* ) )
                    {
                        // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:372:6: ^( T_UNOPTIMIZED_FUNCTION_CALL NCNAME ^( T_PARAMS ( VAR )? ( $q)* QSTRING[$q2.token, $q2.text + $q3.text] ( $rest)* ) )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(stream_T_UNOPTIMIZED_FUNCTION_CALL.nextNode(), root_1);

                        adaptor.addChild(root_1, stream_NCNAME.nextNode());
                        // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:372:43: ^( T_PARAMS ( VAR )? ( $q)* QSTRING[$q2.token, $q2.text + $q3.text] ( $rest)* )
                        {
                        CommonTree root_2 = (CommonTree)adaptor.nil();
                        root_2 = (CommonTree)adaptor.becomeRoot(stream_T_PARAMS.nextNode(), root_2);

                        // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:372:54: ( VAR )?
                        if ( stream_VAR.hasNext() ) {
                            adaptor.addChild(root_2, stream_VAR.nextNode());

                        }
                        stream_VAR.reset();
                        // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:372:59: ( $q)*
                        while ( stream_q.hasNext() ) {
                            adaptor.addChild(root_2, stream_q.nextTree());

                        }
                        stream_q.reset();
                        adaptor.addChild(root_2, (CommonTree)adaptor.create(QSTRING, q2.token, (q2!=null?q2.getText():null) + (q3!=null?q3.getText():null)));
                        // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:372:103: ( $rest)*
                        while ( stream_rest.hasNext() ) {
                            adaptor.addChild(root_2, stream_rest.nextTree());

                        }
                        stream_rest.reset();

                        adaptor.addChild(root_1, root_2);
                        }

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                    input.replaceChildren(adaptor.getParent(retval.start),
                                          adaptor.getChildIndex(retval.start),
                                          adaptor.getChildIndex(_last),
                                          retval.tree);}
                    }
                    break;
                case 2 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:373:5: ^( T_UNOPTIMIZED_FUNCTION_CALL NCNAME ^( T_PARAMS ( VAR )? (q+= qstringandfunctioncall )+ (q1= QSTRING )? ) )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    T_UNOPTIMIZED_FUNCTION_CALL55=(CommonTree)match(input,T_UNOPTIMIZED_FUNCTION_CALL,FOLLOW_T_UNOPTIMIZED_FUNCTION_CALL_in_staticconcat2596); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_T_UNOPTIMIZED_FUNCTION_CALL.add(T_UNOPTIMIZED_FUNCTION_CALL55);


                    if ( state.backtracking==1 )
                    if ( _first_0==null ) _first_0 = T_UNOPTIMIZED_FUNCTION_CALL55;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    NCNAME56=(CommonTree)match(input,NCNAME,FOLLOW_NCNAME_in_staticconcat2598); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_NCNAME.add(NCNAME56);

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_2 = _last;
                    CommonTree _first_2 = null;
                    _last = (CommonTree)input.LT(1);
                    T_PARAMS57=(CommonTree)match(input,T_PARAMS,FOLLOW_T_PARAMS_in_staticconcat2601); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_T_PARAMS.add(T_PARAMS57);


                    if ( state.backtracking==1 )
                    if ( _first_1==null ) _first_1 = T_PARAMS57;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:373:53: ( VAR )?
                    int alt9=2;
                    switch ( input.LA(1) ) {
                        case VAR:
                            {
                            alt9=1;
                            }
                            break;
                    }

                    switch (alt9) {
                        case 1 :
                            // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:0:0: VAR
                            {
                            _last = (CommonTree)input.LT(1);
                            VAR58=(CommonTree)match(input,VAR,FOLLOW_VAR_in_staticconcat2603); if (state.failed) return retval; 
                            if ( state.backtracking==1 ) stream_VAR.add(VAR58);


                            if ( state.backtracking==1 ) {
                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);}
                            }
                            break;

                    }

                    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:373:59: (q+= qstringandfunctioncall )+
                    int cnt10=0;
                    loop10:
                    do {
                        int alt10=2;
                        switch ( input.LA(1) ) {
                        case QSTRING:
                            {
                            switch ( input.LA(2) ) {
                            case T_FUNCTION_CALL:
                                {
                                alt10=1;
                                }
                                break;

                            }

                            }
                            break;

                        }

                        switch (alt10) {
                    	case 1 :
                    	    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:0:0: q+= qstringandfunctioncall
                    	    {
                    	    _last = (CommonTree)input.LT(1);
                    	    _last = (CommonTree)input.LT(1);
                    	    pushFollow(FOLLOW_qstringandfunctioncall_in_staticconcat2608);
                    	    q=qstringandfunctioncall();

                    	    state._fsp--;
                    	    if (state.failed) return retval;
                    	    if ( state.backtracking==1 ) stream_qstringandfunctioncall.add(q.getTree());
                    	    if (list_q==null) list_q=new ArrayList();
                    	    list_q.add(q.getTree());


                    	    if ( state.backtracking==1 ) {
                    	    retval.tree = (CommonTree)_first_0;
                    	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                    	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);}
                    	    }
                    	    break;

                    	default :
                    	    if ( cnt10 >= 1 ) break loop10;
                    	    if (state.backtracking>0) {state.failed=true; return retval;}
                                EarlyExitException eee =
                                    new EarlyExitException(10, input);
                                throw eee;
                        }
                        cnt10++;
                    } while (true);

                    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:373:87: (q1= QSTRING )?
                    int alt11=2;
                    switch ( input.LA(1) ) {
                        case QSTRING:
                            {
                            alt11=1;
                            }
                            break;
                    }

                    switch (alt11) {
                        case 1 :
                            // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:0:0: q1= QSTRING
                            {
                            _last = (CommonTree)input.LT(1);
                            q1=(CommonTree)match(input,QSTRING,FOLLOW_QSTRING_in_staticconcat2613); if (state.failed) return retval; 
                            if ( state.backtracking==1 ) stream_QSTRING.add(q1);


                            if ( state.backtracking==1 ) {
                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);}
                            }
                            break;

                    }


                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_2;
                    }


                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_1;
                    }

                    if ( state.backtracking==1 ) {
                       logger.fine("\n\n------statitconcat-2----");
                          logger.fine("-q------------");
                          logger.fine(""+list_q);
                          logger.fine("-q1-----------");
                          logger.fine(""+q1);
                          logger.fine("-rest---------");
                          logger.fine(""+list_rest);
                          logger.fine("-----------");
                    }


                    // AST REWRITE
                    // elements: T_PARAMS, q, q1, NCNAME, VAR
                    // token labels: q1
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: q
                    // wildcard labels: 
                    if ( state.backtracking==1 ) {
                    retval.tree = root_0;
                    RewriteRuleNodeStream stream_q1=new RewriteRuleNodeStream(adaptor,"token q1",q1);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_q=new RewriteRuleSubtreeStream(adaptor,"token q",list_q);
                    root_0 = (CommonTree)adaptor.nil();
                    // 382:3: -> ^( T_FUNCTION_CALL NCNAME ^( T_PARAMS ( VAR )? ( $q)+ ( $q1)? ) )
                    {
                        // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:382:6: ^( T_FUNCTION_CALL NCNAME ^( T_PARAMS ( VAR )? ( $q)+ ( $q1)? ) )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FUNCTION_CALL, "T_FUNCTION_CALL"), root_1);

                        adaptor.addChild(root_1, stream_NCNAME.nextNode());
                        // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:382:31: ^( T_PARAMS ( VAR )? ( $q)+ ( $q1)? )
                        {
                        CommonTree root_2 = (CommonTree)adaptor.nil();
                        root_2 = (CommonTree)adaptor.becomeRoot(stream_T_PARAMS.nextNode(), root_2);

                        // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:382:42: ( VAR )?
                        if ( stream_VAR.hasNext() ) {
                            adaptor.addChild(root_2, stream_VAR.nextNode());

                        }
                        stream_VAR.reset();
                        if ( !(stream_q.hasNext()) ) {
                            throw new RewriteEarlyExitException();
                        }
                        while ( stream_q.hasNext() ) {
                            adaptor.addChild(root_2, stream_q.nextTree());

                        }
                        stream_q.reset();
                        // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:382:51: ( $q1)?
                        if ( stream_q1.hasNext() ) {
                            adaptor.addChild(root_2, stream_q1.nextNode());

                        }
                        stream_q1.reset();

                        adaptor.addChild(root_1, root_2);
                        }

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                    input.replaceChildren(adaptor.getParent(retval.start),
                                          adaptor.getChildIndex(retval.start),
                                          adaptor.getChildIndex(_last),
                                          retval.tree);}
                    }
                    break;
                case 3 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:383:5: ^( T_UNOPTIMIZED_FUNCTION_CALL NCNAME ^( T_PARAMS VAR q1= QSTRING ) )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    T_UNOPTIMIZED_FUNCTION_CALL59=(CommonTree)match(input,T_UNOPTIMIZED_FUNCTION_CALL,FOLLOW_T_UNOPTIMIZED_FUNCTION_CALL_in_staticconcat2653); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_T_UNOPTIMIZED_FUNCTION_CALL.add(T_UNOPTIMIZED_FUNCTION_CALL59);


                    if ( state.backtracking==1 )
                    if ( _first_0==null ) _first_0 = T_UNOPTIMIZED_FUNCTION_CALL59;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    NCNAME60=(CommonTree)match(input,NCNAME,FOLLOW_NCNAME_in_staticconcat2655); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_NCNAME.add(NCNAME60);

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_2 = _last;
                    CommonTree _first_2 = null;
                    _last = (CommonTree)input.LT(1);
                    T_PARAMS61=(CommonTree)match(input,T_PARAMS,FOLLOW_T_PARAMS_in_staticconcat2658); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_T_PARAMS.add(T_PARAMS61);


                    if ( state.backtracking==1 )
                    if ( _first_1==null ) _first_1 = T_PARAMS61;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    VAR62=(CommonTree)match(input,VAR,FOLLOW_VAR_in_staticconcat2660); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_VAR.add(VAR62);

                    _last = (CommonTree)input.LT(1);
                    q1=(CommonTree)match(input,QSTRING,FOLLOW_QSTRING_in_staticconcat2664); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_QSTRING.add(q1);


                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_2;
                    }


                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_1;
                    }

                    if ( state.backtracking==1 ) {
                       logger.fine("\n\n------statitconcat-3----");
                          logger.fine("-q1-----------");
                          logger.fine(""+q1);
                          logger.fine("-rest---------");
                          logger.fine(""+list_rest);
                          logger.fine("-----------");
                    }


                    // AST REWRITE
                    // elements: q1, NCNAME, T_PARAMS, VAR
                    // token labels: q1
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==1 ) {
                    retval.tree = root_0;
                    RewriteRuleNodeStream stream_q1=new RewriteRuleNodeStream(adaptor,"token q1",q1);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 390:3: -> ^( T_FUNCTION_CALL NCNAME ^( T_PARAMS VAR $q1) )
                    {
                        // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:390:6: ^( T_FUNCTION_CALL NCNAME ^( T_PARAMS VAR $q1) )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(T_FUNCTION_CALL, "T_FUNCTION_CALL"), root_1);

                        adaptor.addChild(root_1, stream_NCNAME.nextNode());
                        // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:390:31: ^( T_PARAMS VAR $q1)
                        {
                        CommonTree root_2 = (CommonTree)adaptor.nil();
                        root_2 = (CommonTree)adaptor.becomeRoot(stream_T_PARAMS.nextNode(), root_2);

                        adaptor.addChild(root_2, stream_VAR.nextNode());
                        adaptor.addChild(root_2, stream_q1.nextNode());

                        adaptor.addChild(root_1, root_2);
                        }

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                    input.replaceChildren(adaptor.getParent(retval.start),
                                          adaptor.getChildIndex(retval.start),
                                          adaptor.getChildIndex(_last),
                                          retval.tree);}
                    }
                    break;
                case 4 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:391:5: ^( T_UNOPTIMIZED_FUNCTION_CALL NCNAME ^( T_PARAMS QSTRING ) )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    T_UNOPTIMIZED_FUNCTION_CALL63=(CommonTree)match(input,T_UNOPTIMIZED_FUNCTION_CALL,FOLLOW_T_UNOPTIMIZED_FUNCTION_CALL_in_staticconcat2697); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_T_UNOPTIMIZED_FUNCTION_CALL.add(T_UNOPTIMIZED_FUNCTION_CALL63);


                    if ( state.backtracking==1 )
                    if ( _first_0==null ) _first_0 = T_UNOPTIMIZED_FUNCTION_CALL63;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    NCNAME64=(CommonTree)match(input,NCNAME,FOLLOW_NCNAME_in_staticconcat2699); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_NCNAME.add(NCNAME64);

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_2 = _last;
                    CommonTree _first_2 = null;
                    _last = (CommonTree)input.LT(1);
                    T_PARAMS65=(CommonTree)match(input,T_PARAMS,FOLLOW_T_PARAMS_in_staticconcat2702); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_T_PARAMS.add(T_PARAMS65);


                    if ( state.backtracking==1 )
                    if ( _first_1==null ) _first_1 = T_PARAMS65;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    QSTRING66=(CommonTree)match(input,QSTRING,FOLLOW_QSTRING_in_staticconcat2704); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_QSTRING.add(QSTRING66);


                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_2;
                    }


                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_1;
                    }

                    if ( state.backtracking==1 ) {
                      logger.fine("\n\n------statitconcat-4----");
                    }


                    // AST REWRITE
                    // elements: QSTRING
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==1 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 393:3: -> QSTRING
                    {
                        adaptor.addChild(root_0, stream_QSTRING.nextNode());

                    }

                    retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                    input.replaceChildren(adaptor.getParent(retval.start),
                                          adaptor.getChildIndex(retval.start),
                                          adaptor.getChildIndex(_last),
                                          retval.tree);}
                    }
                    break;
                case 5 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:394:5: ^( T_GROUP_BY q1= QSTRING q2= QSTRING (rest+= . )* )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    T_GROUP_BY67=(CommonTree)match(input,T_GROUP_BY,FOLLOW_T_GROUP_BY_in_staticconcat2724); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_T_GROUP_BY.add(T_GROUP_BY67);


                    if ( state.backtracking==1 )
                    if ( _first_0==null ) _first_0 = T_GROUP_BY67;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    q1=(CommonTree)match(input,QSTRING,FOLLOW_QSTRING_in_staticconcat2728); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_QSTRING.add(q1);

                    _last = (CommonTree)input.LT(1);
                    q2=(CommonTree)match(input,QSTRING,FOLLOW_QSTRING_in_staticconcat2732); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_QSTRING.add(q2);

                    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:394:44: (rest+= . )*
                    loop12:
                    do {
                        int alt12=2;
                        int LA12_0 = input.LA(1);

                        if ( ((LA12_0>=VAR && LA12_0<=T_UNOPTIMIZED_FUNCTION_CALL)) ) {
                            alt12=1;
                        }


                        switch (alt12) {
                    	case 1 :
                    	    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:0:0: rest+= .
                    	    {
                    	    _last = (CommonTree)input.LT(1);
                    	    rest=(CommonTree)input.LT(1);
                    	    matchAny(input); if (state.failed) return retval;
                    	     
                    	    if ( state.backtracking==1 )
                    	    if ( _first_1==null ) _first_1 = rest;
                    	    if (list_rest==null) list_rest=new ArrayList();
                    	    list_rest.add(rest);


                    	    if ( state.backtracking==1 ) {
                    	    retval.tree = (CommonTree)_first_0;
                    	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                    	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);}
                    	    }
                    	    break;

                    	default :
                    	    break loop12;
                        }
                    } while (true);


                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_1;
                    }



                    // AST REWRITE
                    // elements: QSTRING, rest, T_GROUP_BY
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: rest
                    if ( state.backtracking==1 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_rest=new RewriteRuleSubtreeStream(adaptor,"wildcard rest",list_rest);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 395:3: -> ^( T_GROUP_BY QSTRING[$q1.token, $q1.text + $q2.text] ( $rest)* )
                    {
                        // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:395:6: ^( T_GROUP_BY QSTRING[$q1.token, $q1.text + $q2.text] ( $rest)* )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(stream_T_GROUP_BY.nextNode(), root_1);

                        adaptor.addChild(root_1, (CommonTree)adaptor.create(QSTRING, q1.token, (q1!=null?q1.getText():null) + (q2!=null?q2.getText():null)));
                        // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:395:59: ( $rest)*
                        while ( stream_rest.hasNext() ) {
                            adaptor.addChild(root_1, stream_rest.nextTree());

                        }
                        stream_rest.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                    input.replaceChildren(adaptor.getParent(retval.start),
                                          adaptor.getChildIndex(retval.start),
                                          adaptor.getChildIndex(_last),
                                          retval.tree);}
                    }
                    break;
                case 6 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:396:5: ^( T_HAVING q1= QSTRING q2= QSTRING (rest+= . )* )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    T_HAVING68=(CommonTree)match(input,T_HAVING,FOLLOW_T_HAVING_in_staticconcat2760); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_T_HAVING.add(T_HAVING68);


                    if ( state.backtracking==1 )
                    if ( _first_0==null ) _first_0 = T_HAVING68;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    q1=(CommonTree)match(input,QSTRING,FOLLOW_QSTRING_in_staticconcat2764); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_QSTRING.add(q1);

                    _last = (CommonTree)input.LT(1);
                    q2=(CommonTree)match(input,QSTRING,FOLLOW_QSTRING_in_staticconcat2768); if (state.failed) return retval; 
                    if ( state.backtracking==1 ) stream_QSTRING.add(q2);

                    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:396:42: (rest+= . )*
                    loop13:
                    do {
                        int alt13=2;
                        int LA13_0 = input.LA(1);

                        if ( ((LA13_0>=VAR && LA13_0<=T_UNOPTIMIZED_FUNCTION_CALL)) ) {
                            alt13=1;
                        }


                        switch (alt13) {
                    	case 1 :
                    	    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:0:0: rest+= .
                    	    {
                    	    _last = (CommonTree)input.LT(1);
                    	    rest=(CommonTree)input.LT(1);
                    	    matchAny(input); if (state.failed) return retval;
                    	     
                    	    if ( state.backtracking==1 )
                    	    if ( _first_1==null ) _first_1 = rest;
                    	    if (list_rest==null) list_rest=new ArrayList();
                    	    list_rest.add(rest);


                    	    if ( state.backtracking==1 ) {
                    	    retval.tree = (CommonTree)_first_0;
                    	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                    	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);}
                    	    }
                    	    break;

                    	default :
                    	    break loop13;
                        }
                    } while (true);


                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_1;
                    }



                    // AST REWRITE
                    // elements: T_HAVING, QSTRING, rest
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: rest
                    if ( state.backtracking==1 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_rest=new RewriteRuleSubtreeStream(adaptor,"wildcard rest",list_rest);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 397:3: -> ^( T_HAVING QSTRING[$q1.token, $q1.text + $q2.text] ( $rest)* )
                    {
                        // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:397:6: ^( T_HAVING QSTRING[$q1.token, $q1.text + $q2.text] ( $rest)* )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(stream_T_HAVING.nextNode(), root_1);

                        adaptor.addChild(root_1, (CommonTree)adaptor.create(QSTRING, q1.token, (q1!=null?q1.getText():null) + (q2!=null?q2.getText():null)));
                        // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:397:57: ( $rest)*
                        while ( stream_rest.hasNext() ) {
                            adaptor.addChild(root_1, stream_rest.nextTree());

                        }
                        stream_rest.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                    input.replaceChildren(adaptor.getParent(retval.start),
                                          adaptor.getChildIndex(retval.start),
                                          adaptor.getChildIndex(_last),
                                          retval.tree);}
                    }
                    break;
                case 7 :
                    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:398:5: ^( VALUES LPAR )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    VALUES69=(CommonTree)match(input,VALUES,FOLLOW_VALUES_in_staticconcat2796); if (state.failed) return retval;


                    if ( state.backtracking==1 )
                    if ( _first_0==null ) _first_0 = VALUES69;
                    match(input, Token.DOWN, null); if (state.failed) return retval;
                    _last = (CommonTree)input.LT(1);
                    LPAR70=(CommonTree)match(input,LPAR,FOLLOW_LPAR_in_staticconcat2798); if (state.failed) return retval;
                     
                    if ( state.backtracking==1 )
                    if ( _first_1==null ) _first_1 = LPAR70;

                    match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_1;
                    }


                    if ( state.backtracking==1 ) {
                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);}
                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "staticconcat"

    public static class qstringandfunctioncall_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "qstringandfunctioncall"
    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:404:1: qstringandfunctioncall : QSTRING ^( T_FUNCTION_CALL (p+= . )+ ) -> QSTRING ^( T_FUNCTION_CALL ( $p)+ ) ;
    public final XSPARQLSimplifier.qstringandfunctioncall_return qstringandfunctioncall() throws RecognitionException {
        XSPARQLSimplifier.qstringandfunctioncall_return retval = new XSPARQLSimplifier.qstringandfunctioncall_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree QSTRING71=null;
        CommonTree T_FUNCTION_CALL72=null;
        CommonTree p=null;
        List list_p=null;

        CommonTree QSTRING71_tree=null;
        CommonTree T_FUNCTION_CALL72_tree=null;
        CommonTree p_tree=null;
        RewriteRuleNodeStream stream_QSTRING=new RewriteRuleNodeStream(adaptor,"token QSTRING");
        RewriteRuleNodeStream stream_T_FUNCTION_CALL=new RewriteRuleNodeStream(adaptor,"token T_FUNCTION_CALL");

        try {
            // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:405:2: ( QSTRING ^( T_FUNCTION_CALL (p+= . )+ ) -> QSTRING ^( T_FUNCTION_CALL ( $p)+ ) )
            // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:405:4: QSTRING ^( T_FUNCTION_CALL (p+= . )+ )
            {
            _last = (CommonTree)input.LT(1);
            QSTRING71=(CommonTree)match(input,QSTRING,FOLLOW_QSTRING_in_qstringandfunctioncall2816); if (state.failed) return retval; 
            if ( state.backtracking==1 ) stream_QSTRING.add(QSTRING71);

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            T_FUNCTION_CALL72=(CommonTree)match(input,T_FUNCTION_CALL,FOLLOW_T_FUNCTION_CALL_in_qstringandfunctioncall2819); if (state.failed) return retval; 
            if ( state.backtracking==1 ) stream_T_FUNCTION_CALL.add(T_FUNCTION_CALL72);


            if ( state.backtracking==1 )
            if ( _first_0==null ) _first_0 = T_FUNCTION_CALL72;
            match(input, Token.DOWN, null); if (state.failed) return retval;
            // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:405:31: (p+= . )+
            int cnt15=0;
            loop15:
            do {
                int alt15=2;
                int LA15_0 = input.LA(1);

                if ( ((LA15_0>=VAR && LA15_0<=T_UNOPTIMIZED_FUNCTION_CALL)) ) {
                    alt15=1;
                }


                switch (alt15) {
            	case 1 :
            	    // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:0:0: p+= .
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    p=(CommonTree)input.LT(1);
            	    matchAny(input); if (state.failed) return retval;
            	     
            	    if ( state.backtracking==1 )
            	    if ( _first_1==null ) _first_1 = p;
            	    if (list_p==null) list_p=new ArrayList();
            	    list_p.add(p);


            	    if ( state.backtracking==1 ) {
            	    retval.tree = (CommonTree)_first_0;
            	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
            	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);}
            	    }
            	    break;

            	default :
            	    if ( cnt15 >= 1 ) break loop15;
            	    if (state.backtracking>0) {state.failed=true; return retval;}
                        EarlyExitException eee =
                            new EarlyExitException(15, input);
                        throw eee;
                }
                cnt15++;
            } while (true);


            match(input, Token.UP, null); if (state.failed) return retval;_last = _save_last_1;
            }



            // AST REWRITE
            // elements: p, T_FUNCTION_CALL, QSTRING
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: p
            if ( state.backtracking==1 ) {
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_p=new RewriteRuleSubtreeStream(adaptor,"wildcard p",list_p);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 406:2: -> QSTRING ^( T_FUNCTION_CALL ( $p)+ )
            {
                adaptor.addChild(root_0, stream_QSTRING.nextNode());
                // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:406:13: ^( T_FUNCTION_CALL ( $p)+ )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(stream_T_FUNCTION_CALL.nextNode(), root_1);

                if ( !(stream_p.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_p.hasNext() ) {
                    adaptor.addChild(root_1, stream_p.nextTree());

                }
                stream_p.reset();

                adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            input.replaceChildren(adaptor.getParent(retval.start),
                                  adaptor.getChildIndex(retval.start),
                                  adaptor.getChildIndex(_last),
                                  retval.tree);}
            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "qstringandfunctioncall"

    // $ANTLR start synpred2_XSPARQLSimplifier
    public final void synpred2_XSPARQLSimplifier_fragment() throws RecognitionException {   
        // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:231:5: ( singleconcat )
        // org/sourceforge/xsparql/rewriter/XSPARQLSimplifier.g:231:5: singleconcat
        {
        pushFollow(FOLLOW_singleconcat_in_synpred2_XSPARQLSimplifier1113);
        singleconcat();

        state._fsp--;
        if (state.failed) return ;

        }
    }
    // $ANTLR end synpred2_XSPARQLSimplifier

    // Delegated rules

    public final boolean synpred2_XSPARQLSimplifier() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred2_XSPARQLSimplifier_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }


    protected DFA1 dfa1 = new DFA1(this);
    protected DFA5 dfa5 = new DFA5(this);
    protected DFA14 dfa14 = new DFA14(this);
    static final String DFA1_eotS =
        "\14\uffff";
    static final String DFA1_eofS =
        "\14\uffff";
    static final String DFA1_minS =
        "\1\u00b1\1\uffff\1\2\1\11\1\4\1\2\1\uffff\1\4\2\3\1\0\1\uffff";
    static final String DFA1_maxS =
        "\1\u0134\1\uffff\1\2\1\11\1\u0139\1\3\1\uffff\2\u0139\1\3\1\0\1"+
        "\uffff";
    static final String DFA1_acceptS =
        "\1\uffff\1\1\4\uffff\1\3\4\uffff\1\2";
    static final String DFA1_specialS =
        "\12\uffff\1\0\1\uffff}>";
    static final String[] DFA1_transitionS = {
            "\1\1\21\uffff\1\2\156\uffff\3\1",
            "",
            "\1\3",
            "\1\4",
            "\u009f\6\1\5\u0096\6",
            "\1\7\1\6",
            "",
            "\6\6\1\10\u012f\6",
            "\1\11\u0136\6",
            "\1\12",
            "\1\uffff",
            ""
    };

    static final short[] DFA1_eot = DFA.unpackEncodedString(DFA1_eotS);
    static final short[] DFA1_eof = DFA.unpackEncodedString(DFA1_eofS);
    static final char[] DFA1_min = DFA.unpackEncodedStringToUnsignedChars(DFA1_minS);
    static final char[] DFA1_max = DFA.unpackEncodedStringToUnsignedChars(DFA1_maxS);
    static final short[] DFA1_accept = DFA.unpackEncodedString(DFA1_acceptS);
    static final short[] DFA1_special = DFA.unpackEncodedString(DFA1_specialS);
    static final short[][] DFA1_transition;

    static {
        int numStates = DFA1_transitionS.length;
        DFA1_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA1_transition[i] = DFA.unpackEncodedString(DFA1_transitionS[i]);
        }
    }

    class DFA1 extends DFA {

        public DFA1(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 1;
            this.eot = DFA1_eot;
            this.eof = DFA1_eof;
            this.min = DFA1_min;
            this.max = DFA1_max;
            this.accept = DFA1_accept;
            this.special = DFA1_special;
            this.transition = DFA1_transition;
        }
        public String getDescription() {
            return "229:1: topdown : ( varrewrite | singleconcat | markunoptimized );";
        }
        public int specialStateTransition(int s, IntStream _input) throws NoViableAltException {
            TreeNodeStream input = (TreeNodeStream)_input;
        	int _s = s;
            switch ( s ) {
                    case 0 : 
                        int LA1_10 = input.LA(1);

                         
                        int index1_10 = input.index();
                        input.rewind();
                        s = -1;
                        if ( (synpred2_XSPARQLSimplifier()) ) {s = 11;}

                        else if ( (true) ) {s = 6;}

                         
                        input.seek(index1_10);
                        if ( s>=0 ) return s;
                        break;
            }
            if (state.backtracking>0) {state.failed=true; return -1;}
            NoViableAltException nvae =
                new NoViableAltException(getDescription(), 1, _s, input);
            error(nvae);
            throw nvae;
        }
    }
    static final String DFA5_eotS =
        "\45\uffff";
    static final String DFA5_eofS =
        "\45\uffff";
    static final String DFA5_minS =
        "\1\u00b1\2\2\1\uffff\1\2\1\4\1\12\1\4\2\uffff\1\u00c3\6\uffff\1"+
        "\u00c3\1\uffff\2\2\2\11\2\u00a3\2\2\2\u012d\2\2\2\4\4\uffff";
    static final String DFA5_maxS =
        "\1\u0134\2\2\1\uffff\1\2\1\u0138\1\21\1\u0138\2\uffff\1\u00c3\6"+
        "\uffff\1\u00c3\1\uffff\2\2\2\11\2\u00a3\2\2\2\u012d\2\2\2\30\4\uffff";
    static final String DFA5_acceptS =
        "\3\uffff\1\10\4\uffff\1\1\1\4\1\uffff\1\7\1\16\1\2\1\3\1\11\1\12"+
        "\1\uffff\1\15\16\uffff\1\5\1\6\1\13\1\14";
    static final String DFA5_specialS =
        "\45\uffff}>";
    static final String[] DFA5_transitionS = {
            "\1\2\u0080\uffff\1\1\1\4\1\3",
            "\1\5",
            "\1\6",
            "",
            "\1\7",
            "\1\10\20\uffff\1\12\u009b\uffff\1\11\u0084\uffff\1\13\1\uffff"+
            "\1\14",
            "\1\15\6\uffff\1\16",
            "\1\17\20\uffff\1\21\u0120\uffff\1\20\1\uffff\1\22",
            "",
            "",
            "\1\23",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\24",
            "",
            "\1\25",
            "\1\26",
            "\1\27",
            "\1\30",
            "\1\31",
            "\1\32",
            "\1\33",
            "\1\34",
            "\1\35",
            "\1\36",
            "\1\37",
            "\1\40",
            "\1\42\23\uffff\1\41",
            "\1\44\23\uffff\1\43",
            "",
            "",
            "",
            ""
    };

    static final short[] DFA5_eot = DFA.unpackEncodedString(DFA5_eotS);
    static final short[] DFA5_eof = DFA.unpackEncodedString(DFA5_eofS);
    static final char[] DFA5_min = DFA.unpackEncodedStringToUnsignedChars(DFA5_minS);
    static final char[] DFA5_max = DFA.unpackEncodedStringToUnsignedChars(DFA5_maxS);
    static final short[] DFA5_accept = DFA.unpackEncodedString(DFA5_acceptS);
    static final short[] DFA5_special = DFA.unpackEncodedString(DFA5_specialS);
    static final short[][] DFA5_transition;

    static {
        int numStates = DFA5_transitionS.length;
        DFA5_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA5_transition[i] = DFA.unpackEncodedString(DFA5_transitionS[i]);
        }
    }

    class DFA5 extends DFA {

        public DFA5(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 5;
            this.eot = DFA5_eot;
            this.eof = DFA5_eof;
            this.min = DFA5_min;
            this.max = DFA5_max;
            this.accept = DFA5_accept;
            this.special = DFA5_special;
            this.transition = DFA5_transition;
        }
        public String getDescription() {
            return "235:1: varrewrite : ( ^(r= REWRITEVNODE v= VAR ) -> ^( T_FLWOR[$v.token,\"i'm a stupid flworExpr 1\"] COMMENT[\"SPARQL variable \" + $v.text + \" from \" + $v.line + \":\" + $v.pos] ^( T_LET[$v.token,\"LET\"] VAR[$v.token, \"\\$\" + varName ] ^( T_FUNCTION_CALL NCNAME[nodeFunction] ^( T_PARAMS VAR[$r.text] QSTRING[varName] ) ) ) ) | ^( T_VAR q= QSTRING VAR ) -> QSTRING[\" \"+format($q.text)+\" AS \\\"\\\"\" + $q.text +\"\\\"\\\" \"] | ^( T_VAR c= COMMA q= QSTRING VAR ) -> QSTRING[$c.text+\" \"+format($q.text)+\" AS \\\"\\\"\" + $q.text +\"\\\"\\\" \"] | ^(r= REWRITEVNODE ^( T_VAR ( COMMA )? q= QSTRING v= VAR ) ) -> ^( T_FLWOR[$q.token,\"i'm a stupid flworExpr 2\"] COMMENT[\"SPARQL variable \" + $q.text + \" from \" + $q.line + \":\" + $q.pos] ^( T_LET[$q.token,\"LET\"] VAR[$q.token, \"\\$\" + varName] ^( T_FUNCTION_CALL NCNAME[\"_xsparql:_sqlResultNode\"] ^( T_PARAMS VAR[$r.text] QSTRING ) ) ) ) | ^(r= REWRITEVNODE LPAR ^( T_FUNCTION_CALL n= NCNAME ^( T_PARAMS ^( XPATH v= STAR ) ) ) AS v2= VAR RPAR ) -> ^( T_FLWOR[$v2.token,\"i'm a stupid flworExpr 3\"] COMMENT[\"SPARQL variable \" + $v.text + \" from \" + $v.line + \":\" + $v.pos] ^( T_LET[$v2.token,\"LET\"] VAR[$v2.token, \"\\$\" + varName ] ^( T_FUNCTION_CALL NCNAME[nodeFunction] ^( T_PARAMS VAR[$r.text] QSTRING[varName] ) ) ) ) | ^(r= REWRITEVNODE LPAR ^( T_FUNCTION_CALL n= NCNAME ^( T_PARAMS ^( XPATH v= VAR ) ) ) AS v2= VAR RPAR ) -> ^( T_FLWOR[$v2.token,\"i'm a stupid flworExpr\"] COMMENT[\"SPARQL variable \" + $v.text + \" from \" + $v.line + \":\" + $v.pos] ^( T_LET[$v2.token,\"LET\"] VAR[$v2.token, \"\\$\" + varName ] ^( T_FUNCTION_CALL NCNAME[nodeFunction] ^( T_PARAMS VAR[$r.text] QSTRING[varName] ) ) ) ) | ^(r= REWRITEVNODE q= NOTHING ) -> COMMENT[$q.token, \"dependent variable \" + $q.text] | DELETEVNODE -> DELETEVNODE | ^( REWRITEVNODE1 v= VAR ) -> QSTRING[$v.token, $v.text + \" \"] | ^( REWRITEVNODE1 vv= NOTHING ) -> QSTRING[$vv.token, \" \"] | ^( REWRITEVNODE1 LPAR ^( T_FUNCTION_CALL n= NCNAME ^( T_PARAMS ^( XPATH v= STAR ) ) ) AS v2= VAR RPAR ) -> QSTRING[$n.token, \"(\" + $n.text + \"(*) AS \" + $v2.text + \")\"] | ^( REWRITEVNODE1 LPAR ^( T_FUNCTION_CALL n= NCNAME ^( T_PARAMS ^( XPATH v= VAR ) ) ) AS v2= VAR RPAR ) -> QSTRING[$n.token, \"(\" + $n.text + \"(\" + $v.text + \") AS \" + $v2.text + \")\"] | ^( REWRITEVNODE1 ^(t= T_ASVAR LPAR (e+= . )+ AS v= VAR RPAR ) ) -> QSTRING[$t.token, \"(\" + exprToString($e) + \" AS \" + $v.text + \")\"] | ^(r= REWRITEVNODE ^( T_ASVAR LPAR (e+= . )+ AS v= VAR RPAR ) ) -> ^( T_FLWOR[$v.token,\"i'm a stupid flworExpr 4\"] COMMENT[\"SPARQL variable \" + $v.text + \" from \" + $v.line + \":\" + $v.pos] ^( T_LET[$v.token,\"LET\"] VAR[$v.token, \"\\$\" + varName ] ^( T_FUNCTION_CALL NCNAME[nodeFunction] ^( T_PARAMS VAR[$r.text] QSTRING[varName] ) ) ) ) );";
        }
    }
    static final String DFA14_eotS =
        "\30\uffff";
    static final String DFA14_eofS =
        "\30\uffff";
    static final String DFA14_minS =
        "\1\u00c7\1\2\3\uffff\1\11\1\u00a3\1\2\1\4\1\12\2\3\1\uffff\1\2\2"+
        "\uffff\1\4\1\2\1\3\1\4\1\3\1\uffff\2\3";
    static final String DFA14_maxS =
        "\1\u0139\1\2\3\uffff\1\11\1\u00a3\1\2\2\12\2\u00c3\1\uffff\1\2\2"+
        "\uffff\2\u0139\1\12\1\u0139\1\u00c3\1\uffff\2\u0139";
    static final String DFA14_acceptS =
        "\2\uffff\1\5\1\6\1\7\7\uffff\1\4\1\uffff\1\1\1\3\5\uffff\1\2\2\uffff";
    static final String DFA14_specialS =
        "\30\uffff}>";
    static final String[] DFA14_transitionS = {
            "\1\2\1\3\55\uffff\1\4\102\uffff\1\1",
            "\1\5",
            "",
            "",
            "",
            "\1\6",
            "\1\7",
            "\1\10",
            "\1\11\5\uffff\1\12",
            "\1\13",
            "\1\14\6\uffff\1\16\u00b8\uffff\1\15",
            "\1\17\6\uffff\1\16\u00b8\uffff\1\15",
            "",
            "\1\20",
            "",
            "",
            "\u0136\21",
            "\1\23\1\22\u0136\21",
            "\1\25\6\uffff\1\24",
            "\u0136\26",
            "\1\25\6\uffff\1\16\u00b8\uffff\1\15",
            "",
            "\1\27\u0136\26",
            "\1\22\u0136\21"
    };

    static final short[] DFA14_eot = DFA.unpackEncodedString(DFA14_eotS);
    static final short[] DFA14_eof = DFA.unpackEncodedString(DFA14_eofS);
    static final char[] DFA14_min = DFA.unpackEncodedStringToUnsignedChars(DFA14_minS);
    static final char[] DFA14_max = DFA.unpackEncodedStringToUnsignedChars(DFA14_maxS);
    static final short[] DFA14_accept = DFA.unpackEncodedString(DFA14_acceptS);
    static final short[] DFA14_special = DFA.unpackEncodedString(DFA14_specialS);
    static final short[][] DFA14_transition;

    static {
        int numStates = DFA14_transitionS.length;
        DFA14_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA14_transition[i] = DFA.unpackEncodedString(DFA14_transitionS[i]);
        }
    }

    class DFA14 extends DFA {

        public DFA14(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 14;
            this.eot = DFA14_eot;
            this.eof = DFA14_eof;
            this.min = DFA14_min;
            this.max = DFA14_max;
            this.accept = DFA14_accept;
            this.special = DFA14_special;
            this.transition = DFA14_transition;
        }
        public String getDescription() {
            return "362:1: staticconcat : ( ^( T_UNOPTIMIZED_FUNCTION_CALL NCNAME ^( T_PARAMS ( VAR )? (q+= qstringandfunctioncall )* q2= QSTRING q3= QSTRING (rest+= . )* ) ) -> ^( T_UNOPTIMIZED_FUNCTION_CALL NCNAME ^( T_PARAMS ( VAR )? ( $q)* QSTRING[$q2.token, $q2.text + $q3.text] ( $rest)* ) ) | ^( T_UNOPTIMIZED_FUNCTION_CALL NCNAME ^( T_PARAMS ( VAR )? (q+= qstringandfunctioncall )+ (q1= QSTRING )? ) ) -> ^( T_FUNCTION_CALL NCNAME ^( T_PARAMS ( VAR )? ( $q)+ ( $q1)? ) ) | ^( T_UNOPTIMIZED_FUNCTION_CALL NCNAME ^( T_PARAMS VAR q1= QSTRING ) ) -> ^( T_FUNCTION_CALL NCNAME ^( T_PARAMS VAR $q1) ) | ^( T_UNOPTIMIZED_FUNCTION_CALL NCNAME ^( T_PARAMS QSTRING ) ) -> QSTRING | ^( T_GROUP_BY q1= QSTRING q2= QSTRING (rest+= . )* ) -> ^( T_GROUP_BY QSTRING[$q1.token, $q1.text + $q2.text] ( $rest)* ) | ^( T_HAVING q1= QSTRING q2= QSTRING (rest+= . )* ) -> ^( T_HAVING QSTRING[$q1.token, $q1.text + $q2.text] ( $rest)* ) | ^( VALUES LPAR ) );";
        }
    }
 

    public static final BitSet FOLLOW_varrewrite_in_topdown1107 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_singleconcat_in_topdown1113 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_markunoptimized_in_topdown1119 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_REWRITEVNODE_in_varrewrite1141 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_VAR_in_varrewrite1145 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_T_VAR_in_varrewrite1320 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_QSTRING_in_varrewrite1324 = new BitSet(new long[]{0x0000000000000010L});
    public static final BitSet FOLLOW_VAR_in_varrewrite1326 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_T_VAR_in_varrewrite1345 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_COMMA_in_varrewrite1349 = new BitSet(new long[]{0x0000000000000400L});
    public static final BitSet FOLLOW_QSTRING_in_varrewrite1353 = new BitSet(new long[]{0x0000000000000010L});
    public static final BitSet FOLLOW_VAR_in_varrewrite1355 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_REWRITEVNODE_in_varrewrite1375 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_T_VAR_in_varrewrite1378 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_COMMA_in_varrewrite1380 = new BitSet(new long[]{0x0000000000000400L});
    public static final BitSet FOLLOW_QSTRING_in_varrewrite1385 = new BitSet(new long[]{0x0000000000000010L});
    public static final BitSet FOLLOW_VAR_in_varrewrite1389 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_REWRITEVNODE_in_varrewrite1564 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_LPAR_in_varrewrite1566 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000008L});
    public static final BitSet FOLLOW_T_FUNCTION_CALL_in_varrewrite1569 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_NCNAME_in_varrewrite1573 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000800000000L});
    public static final BitSet FOLLOW_T_PARAMS_in_varrewrite1576 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_XPATH_in_varrewrite1579 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_STAR_in_varrewrite1583 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_AS_in_varrewrite1588 = new BitSet(new long[]{0x0000000000000010L});
    public static final BitSet FOLLOW_VAR_in_varrewrite1592 = new BitSet(new long[]{0x0000000000400000L});
    public static final BitSet FOLLOW_RPAR_in_varrewrite1594 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_REWRITEVNODE_in_varrewrite1769 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_LPAR_in_varrewrite1771 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000008L});
    public static final BitSet FOLLOW_T_FUNCTION_CALL_in_varrewrite1774 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_NCNAME_in_varrewrite1778 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000800000000L});
    public static final BitSet FOLLOW_T_PARAMS_in_varrewrite1781 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_XPATH_in_varrewrite1784 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_VAR_in_varrewrite1788 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_AS_in_varrewrite1793 = new BitSet(new long[]{0x0000000000000010L});
    public static final BitSet FOLLOW_VAR_in_varrewrite1797 = new BitSet(new long[]{0x0000000000400000L});
    public static final BitSet FOLLOW_RPAR_in_varrewrite1799 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_REWRITEVNODE_in_varrewrite1974 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_NOTHING_in_varrewrite1978 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_DELETEVNODE_in_varrewrite1995 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_REWRITEVNODE1_in_varrewrite2009 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_VAR_in_varrewrite2013 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_REWRITEVNODE1_in_varrewrite2028 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_NOTHING_in_varrewrite2032 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_REWRITEVNODE1_in_varrewrite2047 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_LPAR_in_varrewrite2049 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000008L});
    public static final BitSet FOLLOW_T_FUNCTION_CALL_in_varrewrite2052 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_NCNAME_in_varrewrite2056 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000800000000L});
    public static final BitSet FOLLOW_T_PARAMS_in_varrewrite2059 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_XPATH_in_varrewrite2062 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_STAR_in_varrewrite2066 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_AS_in_varrewrite2071 = new BitSet(new long[]{0x0000000000000010L});
    public static final BitSet FOLLOW_VAR_in_varrewrite2075 = new BitSet(new long[]{0x0000000000400000L});
    public static final BitSet FOLLOW_RPAR_in_varrewrite2077 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_REWRITEVNODE1_in_varrewrite2096 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_LPAR_in_varrewrite2098 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000008L});
    public static final BitSet FOLLOW_T_FUNCTION_CALL_in_varrewrite2101 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_NCNAME_in_varrewrite2105 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000800000000L});
    public static final BitSet FOLLOW_T_PARAMS_in_varrewrite2108 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_XPATH_in_varrewrite2111 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_VAR_in_varrewrite2115 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_AS_in_varrewrite2120 = new BitSet(new long[]{0x0000000000000010L});
    public static final BitSet FOLLOW_VAR_in_varrewrite2124 = new BitSet(new long[]{0x0000000000400000L});
    public static final BitSet FOLLOW_RPAR_in_varrewrite2126 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_REWRITEVNODE1_in_varrewrite2145 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_T_ASVAR_in_varrewrite2150 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_LPAR_in_varrewrite2152 = new BitSet(new long[]{0xFFFFFFFFFFFFFFF0L,0xFFFFFFFFFFFFFFFFL,0xFFFFFFFFFFFFFFFFL,0xFFFFFFFFFFFFFFFFL,0x03FFFFFFFFFFFFFFL});
    public static final BitSet FOLLOW_AS_in_varrewrite2159 = new BitSet(new long[]{0x0000000000000010L});
    public static final BitSet FOLLOW_VAR_in_varrewrite2163 = new BitSet(new long[]{0x0000000000400000L});
    public static final BitSet FOLLOW_RPAR_in_varrewrite2165 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_REWRITEVNODE_in_varrewrite2187 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_T_ASVAR_in_varrewrite2190 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_LPAR_in_varrewrite2192 = new BitSet(new long[]{0xFFFFFFFFFFFFFFF0L,0xFFFFFFFFFFFFFFFFL,0xFFFFFFFFFFFFFFFFL,0xFFFFFFFFFFFFFFFFL,0x03FFFFFFFFFFFFFFL});
    public static final BitSet FOLLOW_AS_in_varrewrite2199 = new BitSet(new long[]{0x0000000000000010L});
    public static final BitSet FOLLOW_VAR_in_varrewrite2203 = new BitSet(new long[]{0x0000000000400000L});
    public static final BitSet FOLLOW_RPAR_in_varrewrite2205 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_T_FUNCTION_CALL_in_singleconcat2391 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_NCNAME_in_singleconcat2395 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000800000000L});
    public static final BitSet FOLLOW_T_PARAMS_in_singleconcat2398 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_QSTRING_in_singleconcat2400 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_T_FUNCTION_CALL_in_markunoptimized2453 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_NCNAME_in_markunoptimized2457 = new BitSet(new long[]{0xFFFFFFFFFFFFFFF0L,0xFFFFFFFFFFFFFFFFL,0xFFFFFFFFFFFFFFFFL,0xFFFFFFFFFFFFFFFFL,0x03FFFFFFFFFFFFFFL});
    public static final BitSet FOLLOW_staticconcat_in_bottomup2513 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_T_UNOPTIMIZED_FUNCTION_CALL_in_staticconcat2528 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_NCNAME_in_staticconcat2530 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000800000000L});
    public static final BitSet FOLLOW_T_PARAMS_in_staticconcat2533 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_VAR_in_staticconcat2535 = new BitSet(new long[]{0x0000000000000400L});
    public static final BitSet FOLLOW_qstringandfunctioncall_in_staticconcat2540 = new BitSet(new long[]{0x0000000000000400L});
    public static final BitSet FOLLOW_QSTRING_in_staticconcat2545 = new BitSet(new long[]{0x0000000000000400L});
    public static final BitSet FOLLOW_QSTRING_in_staticconcat2549 = new BitSet(new long[]{0xFFFFFFFFFFFFFFF8L,0xFFFFFFFFFFFFFFFFL,0xFFFFFFFFFFFFFFFFL,0xFFFFFFFFFFFFFFFFL,0x03FFFFFFFFFFFFFFL});
    public static final BitSet FOLLOW_T_UNOPTIMIZED_FUNCTION_CALL_in_staticconcat2596 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_NCNAME_in_staticconcat2598 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000800000000L});
    public static final BitSet FOLLOW_T_PARAMS_in_staticconcat2601 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_VAR_in_staticconcat2603 = new BitSet(new long[]{0x0000000000000400L});
    public static final BitSet FOLLOW_qstringandfunctioncall_in_staticconcat2608 = new BitSet(new long[]{0x0000000000000408L});
    public static final BitSet FOLLOW_QSTRING_in_staticconcat2613 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_T_UNOPTIMIZED_FUNCTION_CALL_in_staticconcat2653 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_NCNAME_in_staticconcat2655 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000800000000L});
    public static final BitSet FOLLOW_T_PARAMS_in_staticconcat2658 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_VAR_in_staticconcat2660 = new BitSet(new long[]{0x0000000000000400L});
    public static final BitSet FOLLOW_QSTRING_in_staticconcat2664 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_T_UNOPTIMIZED_FUNCTION_CALL_in_staticconcat2697 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_NCNAME_in_staticconcat2699 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000800000000L});
    public static final BitSet FOLLOW_T_PARAMS_in_staticconcat2702 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_QSTRING_in_staticconcat2704 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_T_GROUP_BY_in_staticconcat2724 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_QSTRING_in_staticconcat2728 = new BitSet(new long[]{0x0000000000000400L});
    public static final BitSet FOLLOW_QSTRING_in_staticconcat2732 = new BitSet(new long[]{0xFFFFFFFFFFFFFFF8L,0xFFFFFFFFFFFFFFFFL,0xFFFFFFFFFFFFFFFFL,0xFFFFFFFFFFFFFFFFL,0x03FFFFFFFFFFFFFFL});
    public static final BitSet FOLLOW_T_HAVING_in_staticconcat2760 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_QSTRING_in_staticconcat2764 = new BitSet(new long[]{0x0000000000000400L});
    public static final BitSet FOLLOW_QSTRING_in_staticconcat2768 = new BitSet(new long[]{0xFFFFFFFFFFFFFFF8L,0xFFFFFFFFFFFFFFFFL,0xFFFFFFFFFFFFFFFFL,0xFFFFFFFFFFFFFFFFL,0x03FFFFFFFFFFFFFFL});
    public static final BitSet FOLLOW_VALUES_in_staticconcat2796 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_LPAR_in_staticconcat2798 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_QSTRING_in_qstringandfunctioncall2816 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000008L});
    public static final BitSet FOLLOW_T_FUNCTION_CALL_in_qstringandfunctioncall2819 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_singleconcat_in_synpred2_XSPARQLSimplifier1113 = new BitSet(new long[]{0x0000000000000002L});

}