/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.xsparql.rewriter;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.DOTTreeGenerator;
import org.antlr.runtime.tree.Tree;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Helper {
    private static final Logger logger = Logger.getLogger(Helper.class.getClass().getName());
    private static final String DOTFORMAT = "pdf";

    public static String removeLeading(String s, String lead) {
        if (s.startsWith(lead)) {
            return s.substring(lead.length());
        }
        return s;
    }

    public static void outputString(String str, OutputStream out) throws IOException {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(out));
        bw.write(str);
        ((Writer)bw).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeDotFile(CommonTree tree, String dotFile) {
        String dotFilename = "tfd/" + dotFile.concat(".dot");
        String ouputFilename = "tfd/" + dotFile + "." + DOTFORMAT;
        logger.info("Creating DOT file " + dotFilename);
        DOTTreeGenerator dtg = new DOTTreeGenerator();
        StringTemplate st = dtg.toDOT((Tree)tree);
        String dotDesc = st.toString().replace("bgcolor=\"lightgrey\"; ", "").replace("fixedsize=false, fontsize=12, fontname=\"Helvetica-bold\", fontcolor=\"blue\"", "");
        Writer bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(dotFilename)));
            bw.write(dotDesc);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        String cmd = "dot -Tpdf -o" + ouputFilename + " " + dotFilename;
        logger.info("Executing command: " + cmd);
        try {
            Runtime.getRuntime().exec(cmd);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        logger.info("Done: " + dotFile);
    }

    private static void printTree(Tree tree, String spaces) {
        if (tree == null) {
            System.err.println("Tree is null!!");
        } else {
            System.err.println(spaces + tree);
            for (int i = 0; i < tree.getChildCount(); ++i) {
                Helper.printTree(tree.getChild(i), spaces + "  ");
            }
        }
    }

    static void printTree(Tree tree) {
        System.err.println("Tree");
        System.err.println();
        Helper.printTree(tree, "");
    }

    public static Document parseXMLString(String xml) {
        Object doc = new DocumentImpl();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xml));
            doc = db.parse(is);
        }
        catch (ParserConfigurationException e1) {
            e1.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return doc;
    }
}

