/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.xsparql.rewriter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeNodeStream;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.language.DefaultTemplateLexer;
import org.sourceforge.xsparql.rewriter.Helper;
import org.sourceforge.xsparql.rewriter.SPARQLEngine;
import org.sourceforge.xsparql.rewriter.XQuerySerializer;
import org.sourceforge.xsparql.rewriter.XSPARQL;
import org.sourceforge.xsparql.rewriter.XSPARQLLexer;
import org.sourceforge.xsparql.rewriter.XSPARQLRewriter;
import org.sourceforge.xsparql.rewriter.XSPARQLSimplifier;
import org.sourceforge.xsparql.sql.SQLQuery;

public class XSPARQLProcessor {
    private static final Logger logger = Logger.getLogger(XSPARQLProcessor.class.getClass().getName());
    private static final String XQUERYTEMPLATE = "/templates/XQuery.stg";
    private int numSyntaxErrors = 0;
    private String queryFilename = "";
    private int tempFileCounter = 0;
    private boolean validatingXQuery = false;
    private String SPARQLmethod = "arq";
    private boolean debugVersion;
    private String endpointURI;
    private boolean ast = false;
    private boolean dot = false;
    private boolean debug = false;
    private boolean debuglexer = false;
    private boolean warnIfNestedConstruct;
    private SQLQuery sqlQuery = null;
    private static String dbDriver = null;
    private static String dbName = null;
    private static String dbServer = null;
    private static String dbPort = null;
    private static String dbInstance = null;
    private static String dbUser = null;
    private static String dbPasswd = null;
    private String xqueryEngine = "saxon-he";
    private String outputMethod;

    public XSPARQLProcessor() {
        this.setVerbose(false);
        this.setSPARQLEngine(SPARQLEngine.ARQ);
    }

    public void setXQueryEngine(String xqueryEngine) {
        this.xqueryEngine = xqueryEngine;
    }

    public void setQueryFilename(String name) {
        this.queryFilename = name;
    }

    public int getNumberOfSyntaxErrors() {
        return this.numSyntaxErrors;
    }

    public String process(Reader is) throws RecognitionException, IOException, Exception {
        CommonTokenStream tokenStream = this.createTokenStream(is);
        if (this.numSyntaxErrors > 0) {
            throw new Exception("Errors for Lexer. Translation aborted.");
        }
        CommonTree tree = this.parse(tokenStream);
        if (this.numSyntaxErrors > 0) {
            throw new Exception("Errors for Parser. Translation aborted.");
        }
        this.printAST(tree);
        tree = this.rewrite(tokenStream, tree);
        if (this.numSyntaxErrors > 0) {
            throw new Exception("Errors for Rewriter. Translation aborted.");
        }
        this.printAST(tree);
        tree = this.simplify(tokenStream, tree);
        if (this.numSyntaxErrors > 0) {
            throw new Exception("Errors for Simplifier. Translation aborted.");
        }
        this.printAST(tree);
        String xquery = this.serialize(tokenStream, tree);
        if (this.numSyntaxErrors > 0) {
            throw new Exception("Errors for Serializer. Translation aborted.");
        }
        return xquery;
    }

    private void printAST(CommonTree tree) {
        if (this.dot) {
            Helper.writeDotFile(tree, this.queryFilename.concat(".").concat(Integer.toString(this.tempFileCounter)));
            ++this.tempFileCounter;
        }
        if (this.ast) {
            Helper.printTree((Tree)tree);
        }
    }

    CommonTokenStream createTokenStream(Reader is) {
        logger.info("Start Lexer");
        XSPARQLLexer lexer = new XSPARQLLexer(is);
        lexer.setDebug(this.debuglexer);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        logger.info("End Lexer");
        return tokenStream;
    }

    CommonTree parse(CommonTokenStream tokenStream) throws RecognitionException {
        logger.info("Start Parser");
        XSPARQL parser = new XSPARQL((TokenStream)tokenStream);
        parser.setDebug(this.debug);
        XSPARQL.mainModule_return r = parser.mainModule();
        CommonTree tree = (CommonTree)r.getTree();
        this.outputMethod = parser.getOutputMethod();
        this.numSyntaxErrors += parser.getNumberOfSyntaxErrors();
        logger.info("End Parser");
        return tree;
    }

    CommonTree rewrite(CommonTokenStream tokenStream, CommonTree tree) throws RecognitionException {
        logger.info("Start Rewriter");
        CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)tree);
        nodes.setTokenStream((TokenStream)tokenStream);
        XSPARQLRewriter xqr = new XSPARQLRewriter((TreeNodeStream)nodes);
        xqr.setValidatingXQuery(this.validatingXQuery);
        xqr.setXQueryEngine(this.xqueryEngine);
        xqr.setSPARQLMethod(this.SPARQLmethod);
        xqr.setWarnIfNestedConstruct(this.warnIfNestedConstruct);
        xqr.setEndpointURI(this.endpointURI);
        xqr.setDebugVersion(this.debugVersion);
        xqr.setEvaluationMethod();
        xqr.setLibraryVersion();
        xqr.setDBconnection(this.sqlQuery);
        CommonTree ret = (CommonTree)xqr.root().getTree();
        this.numSyntaxErrors += xqr.getNumberOfSyntaxErrors();
        logger.info("End Rewriter");
        return ret;
    }

    CommonTree simplify(CommonTokenStream tokenStream, CommonTree tree) throws RecognitionException {
        logger.info("Start Simplifier");
        CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)tree);
        nodes.setTokenStream((TokenStream)tokenStream);
        XSPARQLSimplifier xqr = new XSPARQLSimplifier((TreeNodeStream)nodes);
        xqr.setEngine(this.xqueryEngine, this.SPARQLmethod);
        CommonTree ret = (CommonTree)xqr.downup(tree);
        this.numSyntaxErrors += xqr.getNumberOfSyntaxErrors();
        logger.info("End Simplifier");
        return ret;
    }

    String serialize(CommonTokenStream tokenStream, CommonTree tree) throws Exception {
        logger.info("Start Serializer");
        InputStream template = XSPARQLProcessor.class.getResourceAsStream(XQUERYTEMPLATE);
        if (template == null) {
            throw new Exception("Could not find/load simplifier template classpath at /templates/XQuery.stg");
        }
        BufferedReader templatesIn = new BufferedReader(new InputStreamReader(template));
        StringTemplateGroup templates = new StringTemplateGroup((Reader)templatesIn, DefaultTemplateLexer.class);
        CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)tree);
        nodes.setTokenStream((TokenStream)tokenStream);
        XQuerySerializer xqs = new XQuerySerializer((TreeNodeStream)nodes);
        xqs.setTemplateLib(templates);
        String ret = xqs.root().toString() + System.getProperty("line.separator");
        this.numSyntaxErrors += xqs.getNumberOfSyntaxErrors();
        logger.info("End Serializer");
        return ret;
    }

    public void setWarnIfNestedConstruct(boolean b) {
        this.warnIfNestedConstruct = b;
    }

    public void setAst(boolean has) {
        this.ast = has;
    }

    public void setDebugLexer(boolean has) {
        this.debuglexer = has;
    }

    public void setDebug(boolean has) {
        this.debug = has;
    }

    public void setDot(boolean has) {
        this.dot = has;
    }

    public void setVerbose(boolean has) {
        if (has) {
            logger.setLevel(Level.ALL);
        } else {
            logger.setLevel(Level.WARNING);
        }
    }

    public void setEndpointURI(String string) {
        this.endpointURI = string;
        this.setWarnIfNestedConstruct(true);
    }

    public void setDebugVersion(boolean has) {
        this.debugVersion = has;
    }

    public void setSPARQLEngine(SPARQLEngine se) {
        switch (se) {
            case JOSEKI: {
                this.SPARQLmethod = "joseki";
                break;
            }
            default: {
                this.SPARQLmethod = "arq";
            }
        }
    }

    public void setValidating(boolean b) {
        this.validatingXQuery = b;
    }

    public String getOutputMethod() {
        return this.outputMethod;
    }

    public boolean isDebug() {
        return this.debug || this.debuglexer;
    }

    public String getDBDriver() {
        return dbDriver;
    }

    public String getDBName() {
        return dbName;
    }

    public String getDBUser() {
        return dbUser;
    }

    public String getDBPasswd() {
        return dbPasswd;
    }

    public void setDBDriver(String driver) {
        dbDriver = driver;
    }

    public void setDBServer(String server) {
        dbServer = server;
    }

    public void setDBPort(String port) {
        dbPort = port;
    }

    public void setDBName(String name) {
        dbName = name;
    }

    public void setDBInstance(String instance) {
        dbInstance = instance;
    }

    public void setDBUser(String user) {
        dbUser = user;
    }

    public void setDBPasswd(String passwd) {
        dbPasswd = passwd;
    }

    public void setDBConfig(File file) {
        String passwd;
        String user;
        String instance;
        String name;
        String port;
        String server;
        Properties configFile = new Properties();
        try {
            configFile.load(new FileReader(file));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        String driver = configFile.getProperty("dbDriver");
        if (driver != null) {
            this.setDBDriver(driver);
        }
        if ((server = configFile.getProperty("dbServer")) != null) {
            this.setDBServer(server);
        }
        if ((port = configFile.getProperty("dbPort")) != null) {
            this.setDBPort(port);
        }
        if ((name = configFile.getProperty("dbName")) != null) {
            this.setDBName(name);
        }
        if ((instance = configFile.getProperty("dbInstance")) != null) {
            this.setDBInstance(instance);
        }
        if ((user = configFile.getProperty("dbUser")) != null) {
            this.setDBUser(user);
        }
        if ((passwd = configFile.getProperty("dbPasswd")) != null) {
            this.setDBPasswd(passwd);
        }
    }

    public void createDBconnection() {
        this.sqlQuery = new SQLQuery(dbDriver, dbServer, dbPort, dbName, dbInstance, dbUser, dbPasswd);
    }

    public SQLQuery getDBconnection() {
        return this.sqlQuery;
    }

    public void closeDBconnection() {
        if (this.sqlQuery != null) {
            this.sqlQuery.close();
        }
    }
}

