/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.xsparql.sql;

import java.io.ByteArrayOutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.codec.binary.Hex;
import org.sourceforge.xsparql.rewriter.Helper;
import org.sourceforge.xsparql.rewriter.Pair;
import org.sourceforge.xsparql.rewriter.XSPARQLProcessor;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SQLQuery {
    private Connection db;
    private String dbDriver;
    private static final Logger logger = Logger.getLogger(XSPARQLProcessor.class.getClass().getName());

    public SQLQuery(String driver, String dbServer, String dbPort, String database, String instance, String username, String password) {
        logger.info("dbDriver: " + driver + ", dbServer: " + dbServer + ", dbPort: " + dbPort + ", dbName: " + database + ", dbInstance: " + instance + ", dbUser: " + username + ", dbPass: " + password);
        if (driver == null || database == null || username == null) {
            System.err.println("Missing database configuration information");
            System.exit(1);
        }
        this.dbDriver = driver;
        if (dbServer == null) {
            dbServer = "localhost";
        }
        String connDriver = null;
        String connUrl = null;
        if (driver.equals("mysql")) {
            if (dbPort == null) {
                dbPort = "3306";
            }
            connDriver = "com.mysql.jdbc.Driver";
            connUrl = "jdbc:mysql://" + dbServer + ":" + dbPort + "/" + database;
        } else if (driver.equals("psql")) {
            if (dbPort == null) {
                dbPort = "3306";
            }
            connDriver = "org.postgresql.Driver";
            connUrl = "jdbc:postgresql://" + dbServer + ":" + dbPort + "/" + database;
            connUrl = "jdbc:postgresql:" + database;
        } else if (driver.equals("sqlserver")) {
            if (dbPort == null) {
                dbPort = "1433";
            }
            connDriver = "net.sourceforge.jtds.jdbc.Driver";
            connUrl = "jdbc:jtds:sqlserver://" + dbServer + ":" + dbPort + "/" + database;
            if (instance != null) {
                connUrl = connUrl + ";instance=" + instance;
            }
        }
        logger.info("dbDriver: " + driver + ", dbServer: " + dbServer + ", dbPort: " + dbPort + ", dbName: " + database + ", dbInstance: " + instance + ", dbUser: " + username + ", dbPass: " + password);
        logger.info("connDriver: " + connDriver + ", connURL: " + connUrl);
        try {
            Class.forName(connDriver);
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println("Couldn't find driver class:");
            cnfe.printStackTrace();
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("Exception:" + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
        try {
            this.db = DriverManager.getConnection(connUrl, username, password);
        }
        catch (Exception e) {
            System.err.println("Error connecting to the database: " + e.getMessage());
            System.exit(1);
        }
    }

    public void close() {
        if (this.db != null) {
            try {
                this.db.close();
            }
            catch (SQLException e) {
                System.err.println(e.getMessage());
                System.exit(1);
            }
        }
    }

    public ResultSet getResults(String query) throws ClassNotFoundException {
        ResultSet res = null;
        try {
            Statement sql = this.db.createStatement();
            logger.info("Executing query: " + query);
            res = sql.executeQuery(query);
        }
        catch (SQLException e) {
            System.err.println("SQL ERROR: " + e.getMessage());
            logger.info("SQL ERROR (getResults): " + e.getMessage());
            System.exit(1);
        }
        return res;
    }

    public String getResultsAsXMLString(String query) {
        ByteArrayOutputStream sb = new ByteArrayOutputStream();
        try {
            ResultSet results = this.getResults(query);
            ResultSetMetaData rsmd = results.getMetaData();
            int columns = rsmd.getColumnCount();
            XMLOutputFactory xof = XMLOutputFactory.newInstance();
            XMLStreamWriter xtw = xof.createXMLStreamWriter(sb, "UTF-8");
            xtw.writeStartDocument("utf-8", "1.0");
            xtw.writeStartElement("", "sql");
            xtw.writeStartElement("", "results");
            if (results != null) {
                while (results.next()) {
                    xtw.writeStartElement("", "result");
                    for (int i = 1; i <= columns; ++i) {
                        String value;
                        String label = rsmd.getColumnLabel(i);
                        label = "\"" + label + "\"";
                        int type = rsmd.getColumnType(i);
                        xtw.writeStartElement("", "SQLbinding");
                        xtw.writeAttribute("type", rsmd.getColumnTypeName(i));
                        xtw.writeAttribute("name", label);
                        if (label.matches(".*\\..*")) {
                            String[] tokens = label.split("\\.");
                            xtw.writeAttribute("label", tokens[1]);
                        }
                        if ((value = results.getString(i)) != null) {
                            logger.info("OBJECT: " + value.toString() + ", type: " + type);
                            switch (type) {
                                case -3: 
                                case -2: {
                                    Hex h = new Hex();
                                    xtw.writeCData(new String(h.encode(results.getBytes(i)), "UTF-8").toUpperCase());
                                    break;
                                }
                                case 1: {
                                    if (this.dbDriver.equals("mysql")) {
                                        xtw.writeCharacters(String.format("%1$-" + rsmd.getPrecision(i) + "s", new String(value.getBytes(), "UTF-8")));
                                        break;
                                    }
                                    xtw.writeCharacters(new String(value.getBytes(), "UTF-8"));
                                    break;
                                }
                                case 93: {
                                    xtw.writeCharacters(new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss").format(results.getTimestamp(i)));
                                    break;
                                }
                                case -7: 
                                case 16: {
                                    xtw.writeCharacters(new Boolean(results.getBoolean(i)).toString());
                                    break;
                                }
                                case 3: 
                                case 6: 
                                case 7: 
                                case 8: {
                                    xtw.writeCharacters(new Float(results.getFloat(i)).toString());
                                    break;
                                }
                                case 4: 
                                case 5: {
                                    xtw.writeCharacters(new Integer(results.getInt(i)).toString());
                                    break;
                                }
                                default: {
                                    xtw.writeCharacters(new String(value.getBytes(), "UTF-8"));
                                }
                            }
                        }
                        xtw.writeEndElement();
                    }
                    xtw.writeEndElement();
                }
            }
            xtw.writeEndElement();
            xtw.writeEndElement();
            xtw.writeEndDocument();
            xtw.flush();
            xtw.close();
        }
        catch (Exception e) {
            System.err.println("SQL ERROR: " + e.getMessage());
            logger.info("SQL ERROR (getResultsAsXMLString): " + e.getMessage());
            System.exit(1);
        }
        String res = ((Object)sb).toString();
        return res;
    }

    public Document getResultsAsDocument(String query) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e1) {
            e1.printStackTrace();
        }
        Document doc = builder.newDocument();
        try {
            ResultSet results = this.getResults(query);
            ResultSetMetaData rsmd = results.getMetaData();
            int columns = rsmd.getColumnCount();
            Element sqlXML = doc.createElement("sql");
            doc.appendChild(sqlXML);
            Element resultsXML = doc.createElement("results");
            sqlXML.appendChild(resultsXML);
            if (results != null) {
                while (results.next()) {
                    for (int i = 1; i <= columns; ++i) {
                        Object value;
                        String label = rsmd.getColumnLabel(i);
                        int type = rsmd.getColumnType(i);
                        Element node = doc.createElement(label);
                        if (label.matches(".*\\..*")) {
                            String[] tokens = label.split("\\.");
                            Attr name = doc.createAttribute("name");
                            name.setValue(tokens[1]);
                            node.setAttributeNode(name);
                        }
                        if ((value = results.getObject(i)) == null) continue;
                        if (type == -2) {
                            node.appendChild(doc.createCDATASection(value.toString()));
                            continue;
                        }
                        node.appendChild(doc.createTextNode(value.toString()));
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("SQL ERROR: " + e.getMessage());
            logger.info("SQL ERROR (getResultsAsDocument): " + e.getMessage());
            System.exit(1);
        }
        return doc;
    }

    public Document getResultsAsXML(String query) {
        String results = this.getResultsAsXMLString(query);
        return Helper.parseXMLString(results);
    }

    public List<String> getRelationAttributes(List<Pair<String, String>> relation) {
        LinkedList<String> res = new LinkedList<String>();
        try {
            DatabaseMetaData dbmd = this.db.getMetaData();
            for (Pair<String, String> relAlias : relation) {
                ResultSet results = dbmd.getColumns(null, null, relAlias.getFirst(), null);
                while (results.next()) {
                    String alias = relAlias.getSecond() != null ? relAlias.getSecond() : relAlias.getFirst();
                    res.add(alias + "." + results.getString("COLUMN_NAME"));
                }
            }
            if (res.size() == 0) {
                System.err.println("Unable to determine relation attributes");
                System.exit(1);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        return res;
    }

    public String getRelationInfoAsXMLString(List<String> relations) {
        ByteArrayOutputStream sb = new ByteArrayOutputStream();
        try {
            XMLOutputFactory xof = XMLOutputFactory.newInstance();
            XMLStreamWriter xtw = xof.createXMLStreamWriter(sb);
            DatabaseMetaData dbmd = this.db.getMetaData();
            xtw.writeStartDocument("utf-8", "1.0");
            xtw.writeStartElement("", "metadata");
            for (String relationName : relations) {
                if (relationName.matches("\".*\"")) {
                    relationName = relationName.substring(1, relationName.length() - 1);
                }
                ResultSet results = dbmd.getColumns(null, null, relationName, null);
                ResultSet primaryKeys = dbmd.getPrimaryKeys(null, null, relationName);
                LinkedList<String> pks = new LinkedList<String>();
                while (primaryKeys.next()) {
                    String pk = primaryKeys.getString("COLUMN_NAME");
                    pk = "\"" + pk + "\"";
                    pks.add(pk);
                }
                ResultSet foreignKeys = dbmd.getImportedKeys(null, null, relationName);
                HashMap<String, Pair<String, String>> fks = new HashMap<String, Pair<String, String>>();
                xtw.writeStartElement("", "foreignKeys");
                boolean firstElem = true;
                while (foreignKeys.next()) {
                    int pos = foreignKeys.getInt("KEY_SEQ");
                    if (pos == 1) {
                        if (!firstElem) {
                            xtw.writeEndElement();
                        }
                        xtw.writeStartElement("", "foreignKey");
                        firstElem = false;
                    }
                    String attributeFK = foreignKeys.getString("FKCOLUMN_NAME");
                    attributeFK = "\"" + attributeFK + "\"";
                    xtw.writeStartElement("", "foreignKeyElem");
                    xtw.writeAttribute("name", attributeFK);
                    String fkTableName = foreignKeys.getString("PKTABLE_NAME");
                    fkTableName = "\"" + fkTableName + "\"";
                    String fkColumnName = foreignKeys.getString("PKCOLUMN_NAME");
                    fkColumnName = "\"" + fkColumnName + "\"";
                    fks.put(attributeFK, new Pair<String, String>(fkTableName, fkColumnName));
                    xtw.writeAttribute("foreignKeyTable", fkTableName);
                    xtw.writeAttribute("foreignKeyAttribute", fkColumnName);
                    xtw.writeEndElement();
                }
                if (!firstElem) {
                    xtw.writeEndElement();
                }
                xtw.writeEndElement();
                xtw.writeStartElement("", "columns");
                while (results.next()) {
                    String columnName = results.getString("COLUMN_NAME");
                    columnName = "\"" + columnName + "\"";
                    xtw.writeStartElement("", "column");
                    xtw.writeAttribute("name", columnName);
                    xtw.writeAttribute("type", results.getString("TYPE_NAME"));
                    if (pks.contains(columnName)) {
                        xtw.writeAttribute("primaryKey", "true");
                    }
                    if (fks.containsKey(columnName)) {
                        Pair value = (Pair)fks.get(columnName);
                        xtw.writeAttribute("foreignKeyTable", (String)value.getFirst());
                        xtw.writeAttribute("foreignKeyAttribute", (String)value.getSecond());
                    }
                    xtw.writeEndElement();
                }
            }
            xtw.writeEndElement();
            xtw.writeEndElement();
            xtw.flush();
            xtw.close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        String res = ((Object)sb).toString();
        return res;
    }

    public List<String> getRelations() {
        LinkedList<String> res = new LinkedList<String>();
        try {
            DatabaseMetaData dbmd = this.db.getMetaData();
            String[] types = new String[]{"TABLE"};
            ResultSet results = dbmd.getTables(null, null, null, types);
            while (results.next()) {
                String relationName = results.getString("TABLE_NAME");
                relationName = "\"" + relationName + "\"";
                res.add(relationName);
            }
            if (res.size() == 0) {
                System.err.println("Unable to determine relation names");
                System.exit(1);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        return res;
    }

    public String getRelationsAsXMLString() {
        List<String> results = this.getRelations();
        return this.createXMLString(results, "relations", "relation");
    }

    private String createXMLString(List<String> results, String parent, String child) {
        ByteArrayOutputStream sb = new ByteArrayOutputStream();
        try {
            XMLOutputFactory xof = XMLOutputFactory.newInstance();
            XMLStreamWriter xtw = xof.createXMLStreamWriter(sb);
            xtw.writeStartDocument("utf-8", "1.0");
            xtw.writeStartElement("", parent);
            if (results != null) {
                for (String c : results) {
                    xtw.writeStartElement("", child);
                    xtw.writeCharacters(c);
                    xtw.writeEndElement();
                }
            }
            xtw.writeEndElement();
            xtw.flush();
            xtw.close();
        }
        catch (XMLStreamException e) {
            System.err.println("XML CREATION ERROR: " + e.getMessage());
            System.exit(1);
        }
        return ((Object)sb).toString();
    }
}

