/*
 * 
 *  This file is part of Sourceprojects.org Lycia Copyright 2010 noctarius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * 
 */
package org.sourceprojects.xmlparser;

import javax.xml.namespace.QName;

import org.sourceprojects.xmlparser.exceptions.XmlParserParsingException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/**
 * Abstract implementation of
 * {@link org.sourceprojects.xmlparser.TagDefinitionParser} with basic handling
 * of some of the needed method structures. If someone want's to implement a tag
 * parser / transformer, he must extends this class instead of implementing the
 * interface directly.
 * 
 * @author noctarius
 * @since 0.0.1
 * 
 * @param <B>
 *            Type of ContextObject to use
 * @deprecated Use {@link org.sourceprojects.lycia.AbstractTagParser} instead
 */
@Deprecated
public abstract class AbstractTagParser<B> implements TagDefinitionParser<B> {

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.sourceprojects.xmlparser.TagDefinitionParser#parseElement(org.w3c
	 * .dom.Element, org.sourceprojects.xmlparser.ParserContext,
	 * org.sourceprojects.xmlparser.DefinitionBuilder)
	 */
	@Override
	public void parseElement(Element element, ParserContext<B> parserContext,
			DefinitionBuilder definitionBuilder)
			throws XmlParserParsingException {

		return;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.sourceprojects.xmlparser.TagDefinitionParser#parseElement(org.w3c
	 * .dom.Element, java.lang.String,
	 * org.sourceprojects.xmlparser.ParserContext,
	 * org.sourceprojects.xmlparser.DefinitionBuilder)
	 */
	@Override
	public void parseElement(Element element, String localName,
			ParserContext<B> parserContext, DefinitionBuilder definitionBuilder)
			throws XmlParserParsingException {

		parseElement(element, parserContext, definitionBuilder);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.sourceprojects.xmlparser.TagDefinitionParser#parseElement(org.w3c
	 * .dom.Element, java.lang.String, javax.xml.namespace.QName,
	 * org.sourceprojects.xmlparser.ParserContext,
	 * org.sourceprojects.xmlparser.DefinitionBuilder)
	 */
	@Override
	public void parseElement(Element element, String localName, QName parent,
			ParserContext<B> parserContext, DefinitionBuilder definitionBuilder)
			throws XmlParserParsingException {

		parseElement(element, localName, parserContext, definitionBuilder);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.sourceprojects.xmlparser.TagDefinitionParser#transformElement(org
	 * .w3c.dom.Element, org.sourceprojects.xmlparser.ParserContext,
	 * org.sourceprojects.xmlparser.DefinitionBuilder)
	 */
	@Override
	public Node transformElement(Element element,
			ParserContext<B> parserContext, DefinitionBuilder definitionBuilder)
			throws XmlParserParsingException {

		return definitionBuilder.getDocument().importNode(element, false);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.sourceprojects.xmlparser.TagDefinitionParser#transformElement(org
	 * .w3c.dom.Element, java.lang.String,
	 * org.sourceprojects.xmlparser.ParserContext,
	 * org.sourceprojects.xmlparser.DefinitionBuilder)
	 */
	@Override
	public Node transformElement(Element element, String localName,
			ParserContext<B> parserContext, DefinitionBuilder definitionBuilder)
			throws XmlParserParsingException {

		return transformElement(element, parserContext, definitionBuilder);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.sourceprojects.xmlparser.TagDefinitionParser#transformElement(org
	 * .w3c.dom.Element, java.lang.String, javax.xml.namespace.QName,
	 * org.sourceprojects.xmlparser.ParserContext,
	 * org.sourceprojects.xmlparser.DefinitionBuilder)
	 */
	@Override
	public Node transformElement(Element element, String localName,
			QName parent, ParserContext<B> parserContext,
			DefinitionBuilder definitionBuilder)
			throws XmlParserParsingException {

		return transformElement(element, localName, parserContext,
				definitionBuilder);
	}

}
