/*
 * 
 *  This file is part of Sourceprojects.org Lycia Copyright 2010 noctarius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * 
 */
package org.sourceprojects.xmlparser;

import org.w3c.dom.ls.LSResourceResolver;

/**
 * Interface to define ResourceResolver.<br>
 * Standard implementation returned by {@link ResourceResolverFactory} handles
 * different {@link NamespaceResolver}s to redirect namespace resolution to
 * special URLs
 * 
 * @author noctarius
 * @since 0.0.1
 * @deprecated Use {@link org.sourceprojects.lycia.ResourceResolver} instead
 */
@Deprecated
public interface ResourceResolver extends LSResourceResolver {

	/**
	 * Returns if warnings should be shown
	 * 
	 * @return Show warnings
	 */
	boolean isShowWarning();

	/**
	 * Sets if warnins should be shown
	 * 
	 * @param showWarning
	 *            Show warnings
	 */
	void setShowWarning(boolean showWarning);

	/**
	 * Registers a {@link NamespaceResolver} for this ResourceResolver
	 * 
	 * @param namespaceResolver
	 *            NamespaceResolver to add
	 */
	void registerNamespaceResolver(NamespaceResolver namespaceResolver);

	/**
	 * Removes a {@link NamespaceResolver} by given instance
	 * 
	 * @param namespaceResolver
	 *            NamespaceResolver instance to remove
	 */
	void unregisterNamespaceResolver(NamespaceResolver namespaceResolver);

	/**
	 * Removes a {@link NamespaceResolver} by given namespace URI
	 * 
	 * @param namespaceURI
	 *            Namespace of NamespaceResolver instance to remove
	 */
	void unregisterNamespaceResolver(String namespaceURI);

}