/*
 * 
 *  This file is part of Sourceprojects.org Lycia Copyright 2010 noctarius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * 
 */
package org.sourceprojects.xmlparser;

import javax.xml.namespace.QName;

import org.sourceprojects.xmlparser.exceptions.XmlParserParsingException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/**
 * Interface for TagDefinitionParsers to implement. Defines basic methods to
 * handle parsing and transforming of XML elements.
 * 
 * @author noctarius
 * @since 0.0.1
 * 
 * @param <B>
 *            Type of ContextObject to use
 * @deprecated Use {@link org.sourceprojects.lycia.TagDefinitionParser} instead
 */
@Deprecated
public interface TagDefinitionParser<B> {
	/**
	 * Returns the namespace URI this {@link TagDefinitionParser} implementation
	 * handles
	 * 
	 * @return NamespaceURI
	 */
	String getNamespace();

	/**
	 * Returns a string array with all tags handled by this
	 * {@link TagDefinitionParser} implementation
	 * 
	 * @return handled tags
	 */
	String[] getTags();

	/**
	 * Parses an element. Method is called if a element combination
	 * namespace-tag (optional with parent hierarchy) is found
	 * 
	 * @param element
	 *            Element which was found
	 * @param parserContext
	 *            ParserContext instance which was given to the
	 *            {@link XmlParser} instance
	 * @param definitionBuilder
	 *            DefinitionBuilder instance which was given to the
	 *            {@link XmlParser} instance
	 * @throws XmlParserParsingException
	 *             Is thrown when some error occurs. Implementation specific
	 *             exceptions are wrapped into XmlParserParsingException
	 */
	void parseElement(Element element, ParserContext<B> parserContext,
			DefinitionBuilder definitionBuilder)
			throws XmlParserParsingException;

	/**
	 * Parses an element. Method is called if a element combination
	 * namespace-tag (optional with parent hierarchy) is found
	 * 
	 * @param element
	 *            Element which was found
	 * @param localName
	 *            Name, as String, of the actual element
	 * @param parserContext
	 *            ParserContext instance which was given to the
	 *            {@link XmlParser} instance
	 * @param definitionBuilder
	 *            DefinitionBuilder instance which was given to the
	 *            {@link XmlParser} instance
	 * @throws XmlParserParsingException
	 *             Is thrown when some error occurs. Implementation specific
	 *             exceptions are wrapped into XmlParserParsingException
	 */
	void parseElement(Element element, String localName,
			ParserContext<B> parserContext, DefinitionBuilder definitionBuilder)
			throws XmlParserParsingException;

	/**
	 * Parses an element. Method is called if a element combination
	 * namespace-tag (optional with parent hierarchy) is found
	 * 
	 * @param element
	 *            Element which was found
	 * @param localName
	 *            Name, as String, of the actual element
	 * @param parent
	 *            {@link QName} instance of the parent element, null if no
	 *            parent-hierarchy was defined
	 * @param parserContext
	 *            ParserContext instance which was given to the
	 *            {@link XmlParser} instance
	 * @param definitionBuilder
	 *            DefinitionBuilder instance which was given to the
	 *            {@link XmlParser} instance
	 * @throws XmlParserParsingException
	 *             Is thrown when some error occurs. Implementation specific
	 *             exceptions are wrapped into XmlParserParsingException
	 */
	void parseElement(Element element, String localName, QName parent,
			ParserContext<B> parserContext, DefinitionBuilder definitionBuilder)
			throws XmlParserParsingException;

	/**
	 * Transforms an element. Method is called if a element combination
	 * namespace-tag (optional with parent hierarchy) is found
	 * 
	 * @param element
	 *            Element which was found
	 * @param parserContext
	 *            ParserContext instance which was given to the
	 *            {@link XmlParser} instance
	 * @param definitionBuilder
	 *            DefinitionBuilder instance which was given to the
	 *            {@link XmlParser} instance
	 * @return {@link Node} of the transformed element (defined against
	 *         {@link DefinitionBuilder}.getDocument() {@link Document}), null
	 *         if element should be removed from returning {@link Document}
	 * @throws XmlParserParsingException
	 *             Is thrown when some error occurs. Implementation specific
	 *             exceptions are wrapped into XmlParserParsingException
	 */
	Node transformElement(Element element, ParserContext<B> parserContext,
			DefinitionBuilder definitionBuilder)
			throws XmlParserParsingException;

	/**
	 * Transforms an element. Method is called if a element combination
	 * namespace-tag (optional with parent hierarchy) is found
	 * 
	 * @param element
	 *            Element which was found
	 * @param localName
	 *            Name, as String, of the actual element
	 * @param parserContext
	 *            ParserContext instance which was given to the
	 *            {@link XmlParser} instance
	 * @param definitionBuilder
	 *            DefinitionBuilder instance which was given to the
	 *            {@link XmlParser} instance
	 * @return {@link Node} of the transformed element (defined against
	 *         {@link DefinitionBuilder}.getDocument() {@link Document}), null
	 *         if element should be removed from returning {@link Document}
	 * @throws XmlParserParsingException
	 *             Is thrown when some error occurs. Implementation specific
	 *             exceptions are wrapped into XmlParserParsingException
	 */
	Node transformElement(Element element, String localName,
			ParserContext<B> parserContext, DefinitionBuilder definitionBuilder)
			throws XmlParserParsingException;

	/**
	 * Transforms an element. Method is called if a element combination
	 * namespace-tag (optional with parent hierarchy) is found
	 * 
	 * @param element
	 *            Element which was found
	 * @param localName
	 *            Name, as String, of the actual element
	 * @param parent
	 *            {@link QName} instance of the parent element, null if no
	 *            parent-hierarchy was defined
	 * @param parserContext
	 *            ParserContext instance which was given to the
	 *            {@link XmlParser} instance
	 * @param definitionBuilder
	 *            DefinitionBuilder instance which was given to the
	 *            {@link XmlParser} instance
	 * @return {@link Node} of the transformed element (defined against
	 *         {@link DefinitionBuilder}.getDocument() {@link Document}), null
	 *         if element should be removed from returning {@link Document}
	 * @throws XmlParserParsingException
	 *             Is thrown when some error occurs. Implementation specific
	 *             exceptions are wrapped into XmlParserParsingException
	 */
	Node transformElement(Element element, String localName, QName parent,
			ParserContext<B> parserContext, DefinitionBuilder definitionBuilder)
			throws XmlParserParsingException;
}
