/*
 * 
 *  This file is part of Sourceprojects.org Lycia Copyright 2010 noctarius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * 
 */
package org.sourceprojects.xmlparser;

import java.util.Dictionary;
import java.util.Hashtable;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.sourceprojects.lycia.LyciaActivator;
import org.sourceprojects.xmlparser.internal.XmlParserOsgiServiceFactoryAdapter;

/**
 * OSGi {@link BundleActivator} implementation for using {@link XmlParser} in OSGi environments.<br>
 * To retrieve an {@link XmlParser} instance on OSGi environments get a service reference to the {@link XmlParserOsgiFactory}.<br>
 * <pre>ServiceReference reference = context.getServiceReference(XmlParserOsgiFactory.class.getName());
		
if (reference == null)
	throw new XmlParserInitializationException("ServiceReference not found");
		
XmlParserOsgiFactory factory = (XmlParserOsgiFactory) context.getService(reference);
ServiceReference reference = context.getServiceReference(XmlParserOsgiFactory.class.getName());
		
if (reference == null)
	throw new XmlParserInitializationException("ServiceReference not found");
		
XmlParserOsgiFactory factory = (XmlParserOsgiFactory) context.getService(reference);
		
XmlParser<StringBuilder> parser = factory.newParserInstance();
ResourceResolver resolver = factory.newResourceResolverInstance();</pre>
 * 
 * @author noctarius
 * @since 0.0.5
 * @deprecated Use {@link LyciaActivator} instead
 */
@Deprecated
public class XmlParserActivator implements BundleActivator {
	private ServiceRegistration registration;

	/* (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
	 */
	@Override
	public void start(BundleContext context) throws Exception {
		Dictionary<String, String> properties = new Hashtable<String, String>();
		registration = context.registerService(XmlParserOsgiFactory.class
				.getName(), new XmlParserOsgiServiceFactoryAdapter(), properties);
	}

	/* (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
	 */
	@Override
	public void stop(BundleContext context) throws Exception {
		registration.unregister();
	}

}
