/*
 * 
 *  This file is part of Sourceprojects.org Lycia Copyright 2010 noctarius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * 
 */
package org.sourceprojects.xmlparser;

import org.sourceprojects.lycia.LyciaOsgiFactory;
import org.sourceprojects.xmlparser.exceptions.XmlParserInitializationException;

/**
 * Service interface for factory service in OSGi environments.
 * 
 * @author noctarius
 * @since 0.0.5
 * @deprecated Use {@link LyciaOsgiFactory} instead
 */
@Deprecated
public interface XmlParserOsgiFactory {
	/**
	 * Returns a new instance of the {@link XmlParser} on OSGi environments
	 * 
	 * @param <B>
	 *            Type of ContextObject to use
	 * @return A new instance of XmlParser
	 * @throws XmlParserInitializationException
	 *             If some exception occurs on initialization of the new
	 *             instance the exception is wrapped into a
	 *             {@link XmlParserInitializationException}
	 */
	<B> XmlParser<B> newParserInstance()
			throws XmlParserInitializationException;

	/**
	 * Returns a new instance of the {@link ResourceResolver} on OSGi
	 * environments
	 * 
	 * @return A new instance of ResourceResolver
	 * @throws XmlParserInitializationException
	 *             If some exception occurs on initialization of the new
	 *             instance the exception is wrapped into a
	 *             {@link XmlParserInitializationException}
	 */
	ResourceResolver newResourceResolverInstance()
			throws XmlParserInitializationException;

}
