/*
 * 
 *  This file is part of Sourceprojects.org Lycia Copyright 2010 noctarius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * 
 */
package org.sourceprojects.xmlparser.internal;

import java.lang.annotation.Annotation;

import org.sourceprojects.lycia.annotations.Namespace;

/**
 * 
 * @author noctarius
 * @since 1.9.1
 */
public class NamespaceInnerImpl implements Namespace {
	private final String prefix;
	private final String uri;

	public NamespaceInnerImpl(String prefix, String uri) {
		this.prefix = prefix;
		this.uri = uri;
	}

	@Override
	public String prefix() {
		return prefix;
	}

	@Override
	public String uri() {
		return uri;
	}

	@Override
	public Class<? extends Annotation> annotationType() {
		return Namespace.class;
	}
}
