/*
 * 
 *  This file is part of Sourceprojects.org Lycia Copyright 2010 noctarius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * 
 */
package org.sourceprojects.xmlparser.internal;

import org.sourceprojects.xmlparser.NamespaceResolver;
import org.w3c.dom.ls.LSInput;

public class NamespaceResolverAdapter implements NamespaceResolver {
	private final org.sourceprojects.lycia.NamespaceResolver resolver;

	public NamespaceResolverAdapter(
			org.sourceprojects.lycia.NamespaceResolver resolver) {

		this.resolver = resolver;
	}

	@Override
	public LSInput getInput(String type, String namespaceURI, String publicId,
			String systemId, String baseURI) {
		
		return resolver.getInput(type, namespaceURI, publicId, systemId,
				baseURI);
	}

	@Override
	public String getNamespaceURI() {
		return resolver.getNamespaceURI();
	}

}
