/*
 * 
 *  This file is part of Sourceprojects.org Lycia Copyright 2010 noctarius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * 
 */
package org.sourceprojects.xmlparser.internal;

import org.sourceprojects.lycia.NamespaceResolver;
import org.sourceprojects.lycia.ResourceResolver;
import org.w3c.dom.ls.LSInput;

public class ResourceResolverAdapter implements ResourceResolver {

	private final org.sourceprojects.xmlparser.ResourceResolver resolver;

	public ResourceResolverAdapter(
			org.sourceprojects.xmlparser.ResourceResolver resolver) {

		this.resolver = resolver;
	}

	@Override
	public boolean isShowWarning() {
		return resolver.isShowWarning();
	}

	@Override
	public void setShowWarning(boolean showWarning) {
		resolver.setShowWarning(showWarning);
	}

	@Override
	public void unregisterNamespaceResolver(String namespaceURI) {
		resolver.unregisterNamespaceResolver(namespaceURI);
	}

	@Override
	public LSInput resolveResource(String type, String namespaceURI,
			String publicId, String systemId, String baseURI) {

		return resolver.resolveResource(type, namespaceURI, publicId, systemId,
				baseURI);
	}

	@Override
	public void registerNamespaceResolver(NamespaceResolver namespaceResolver) {
		resolver.registerNamespaceResolver(new NamespaceResolverAdapter(
				namespaceResolver));
	}

	@Override
	public void unregisterNamespaceResolver(NamespaceResolver namespaceResolver) {
		resolver.unregisterNamespaceResolver(new NamespaceResolverAdapter(
				namespaceResolver));
	}

	org.sourceprojects.xmlparser.ResourceResolver getWrappedResolver() {
		return resolver;
	}

}
