/*
 * 
 *  This file is part of Sourceprojects.org Lycia Copyright 2010 noctarius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * 
 */
package org.sourceprojects.xmlparser.internal;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import org.sourceprojects.lycia.DefinitionBuilder;
import org.sourceprojects.lycia.ParserContext;
import org.sourceprojects.lycia.TagDefinitionParser;
import org.sourceprojects.lycia.annotations.Namespace;
import org.sourceprojects.lycia.annotations.Tag;
import org.sourceprojects.lycia.annotations.XPath;
import org.sourceprojects.lycia.exceptions.LyciaParsingException;
import org.sourceprojects.xmlparser.exceptions.XmlParserParsingException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TagDefinitionParserAdapter<B> implements TagDefinitionParser<B> {
	private static final Namespace[] ZERO_LENGTH_NAMESPACE_ARRAY = new Namespace[] { new NamespaceInnerImpl(
			null, null) };

	private final org.sourceprojects.xmlparser.TagDefinitionParser<B> parser;

	public TagDefinitionParserAdapter(
			org.sourceprojects.xmlparser.TagDefinitionParser<B> parser) {

		this.parser = parser;
	}

	@Override
	public String getNamespace() {
		return parser.getNamespace();
	}

	@Override
	public Tag[] getTagAnnotations() {
		if (getTags().length == 0) {
			return new Tag[0];
		}

		List<Tag> tags = new ArrayList<Tag>();
		for (String tag : getTags()) {
			tags.add(getTagAnnotationImpl(tag, getNamespace()));
		}

		return tags.toArray(new Tag[tags.size()]);
	}

	@Override
	public String[] getTags() {
		return parser.getTags();
	}

	@Override
	public void parseElement(Element element, ParserContext<B> parserContext,
			DefinitionBuilder definitionBuilder) throws LyciaParsingException {

		if (!(parserContext instanceof ParserContext<?>))
			throw new XmlParserParsingException(
					"ParserContext isn't of type org.sourceprojects.xmlparser.ParserContext");

		if (!(definitionBuilder instanceof DefinitionBuilder))
			throw new XmlParserParsingException(
					"ParserContext isn't of type org.sourceprojects.xmlparser.DefinitionBuilder");

		parser.parseElement(element,
				(org.sourceprojects.xmlparser.ParserContext<B>) parserContext,
				wrapDefinitionBuilder(definitionBuilder));
	}

	@Override
	public void parseElement(Element element, String localName,
			ParserContext<B> parserContext, DefinitionBuilder definitionBuilder)
			throws LyciaParsingException {

		if (!(parserContext instanceof ParserContext<?>))
			throw new XmlParserParsingException(
					"ParserContext isn't of type org.sourceprojects.xmlparser.ParserContext");

		if (!(definitionBuilder instanceof DefinitionBuilder))
			throw new XmlParserParsingException(
					"ParserContext isn't of type org.sourceprojects.xmlparser.DefinitionBuilder");

		parser.parseElement(element, localName,
				(org.sourceprojects.xmlparser.ParserContext<B>) parserContext,
				wrapDefinitionBuilder(definitionBuilder));
	}

	@Override
	public void parseElement(Element element, String localName, QName parent,
			ParserContext<B> parserContext, DefinitionBuilder definitionBuilder)
			throws LyciaParsingException {

		if (!(parserContext instanceof ParserContext<?>))
			throw new XmlParserParsingException(
					"ParserContext isn't of type org.sourceprojects.xmlparser.ParserContext");

		if (!(definitionBuilder instanceof DefinitionBuilder))
			throw new XmlParserParsingException(
					"ParserContext isn't of type org.sourceprojects.xmlparser.DefinitionBuilder");

		parser.parseElement(element, localName, parent,
				(org.sourceprojects.xmlparser.ParserContext<B>) parserContext,
				wrapDefinitionBuilder(definitionBuilder));
	}

	@Override
	public Node transformElement(Element element,
			ParserContext<B> parserContext, DefinitionBuilder definitionBuilder)
			throws LyciaParsingException {

		if (!(parserContext instanceof ParserContext<?>))
			throw new XmlParserParsingException(
					"ParserContext isn't of type org.sourceprojects.xmlparser.ParserContext");

		if (!(definitionBuilder instanceof DefinitionBuilder))
			throw new XmlParserParsingException(
					"ParserContext isn't of type org.sourceprojects.xmlparser.DefinitionBuilder");

		return parser.transformElement(element,
				(org.sourceprojects.xmlparser.ParserContext<B>) parserContext,
				wrapDefinitionBuilder(definitionBuilder));
	}

	@Override
	public Node transformElement(Element element, String localName,
			ParserContext<B> parserContext, DefinitionBuilder definitionBuilder)
			throws LyciaParsingException {

		if (!(parserContext instanceof ParserContext<?>))
			throw new XmlParserParsingException(
					"ParserContext isn't of type org.sourceprojects.xmlparser.ParserContext");

		if (!(definitionBuilder instanceof DefinitionBuilder))
			throw new XmlParserParsingException(
					"ParserContext isn't of type org.sourceprojects.xmlparser.DefinitionBuilder");

		return parser.transformElement(element, localName,
				(org.sourceprojects.xmlparser.ParserContext<B>) parserContext,
				wrapDefinitionBuilder(definitionBuilder));
	}

	@Override
	public Node transformElement(Element element, String localName,
			QName parent, ParserContext<B> parserContext,
			DefinitionBuilder definitionBuilder) throws LyciaParsingException {

		if (!(parserContext instanceof ParserContext<?>))
			throw new XmlParserParsingException(
					"ParserContext isn't of type org.sourceprojects.xmlparser.ParserContext");

		if (!(definitionBuilder instanceof DefinitionBuilder))
			throw new XmlParserParsingException(
					"ParserContext isn't of type org.sourceprojects.xmlparser.DefinitionBuilder");

		return parser.transformElement(element, localName, parent,
				(org.sourceprojects.xmlparser.ParserContext<B>) parserContext,
				wrapDefinitionBuilder(definitionBuilder));
	}

	org.sourceprojects.xmlparser.TagDefinitionParser<B> getWrappedTagDefinitionParser() {
		return parser;
	}

	private Tag getTagAnnotationImpl(String tag, String namespace) {
		return new TagInnerImpl(tag, namespace, getNullXPathExpression(), false);
	}

	private XPath getNullXPathExpression() {
		return new XPathInnerImpl(XPath.NULL, getNamespaceArray());
	}

	private Namespace[] getNamespaceArray() {
		return ZERO_LENGTH_NAMESPACE_ARRAY;
	}

	private DefinitionBuilderAdapter wrapDefinitionBuilder(
			DefinitionBuilder definitionBuilder) {

		return new DefinitionBuilderAdapter(definitionBuilder);
	}
}
