/*
 * 
 *  This file is part of Sourceprojects.org Lycia Copyright 2010 noctarius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * 
 */
package org.sourceprojects.xmlparser.internal;

import java.lang.annotation.Annotation;

import org.sourceprojects.lycia.annotations.Tag;
import org.sourceprojects.lycia.annotations.Validator;
import org.sourceprojects.lycia.annotations.XPath;

/**
 * 
 * @author noctarius
 * @since 1.9.1
 */
public class TagInnerImpl implements Tag {
	private final String namespace;
	private final String value;
	private final XPath xpath;
	private final boolean regex;
	private final Validator[] validators;

	public TagInnerImpl(String value, String namespace, XPath xpath,
			boolean regex) {
		this(value, namespace, xpath, regex, new Validator[0]);
	}

	public TagInnerImpl(String value, String namespace, XPath xpath,
			boolean regex, Validator... validators) {

		this.namespace = namespace;
		this.value = value;
		this.xpath = xpath;
		this.regex = regex;
		this.validators = new Validator[validators.length];
		System.arraycopy(validators, 0, this.validators, 0, validators.length);
	}

	@Override
	public String namespace() {
		return namespace;
	}

	@Override
	public String value() {
		return value;
	}

	@Override
	public Class<? extends Annotation> annotationType() {
		return Tag.class;
	}

	@Override
	public Validator[] validations() {
		Validator[] result = new Validator[validators.length];
		System.arraycopy(validators, 0, result, 0, validators.length);
		return result;
	}

	@Override
	public XPath xpath() {
		return xpath;
	}

	@Override
	public boolean regex() {
		return regex;
	}

}
