/*
 * 
 *  This file is part of Sourceprojects.org Lycia Copyright 2010 noctarius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * 
 */
package org.sourceprojects.xmlparser.internal;

import org.osgi.framework.Bundle;
import org.sourceprojects.xmlparser.ResourceResolver;
import org.sourceprojects.xmlparser.XmlParser;
import org.sourceprojects.xmlparser.XmlParserFactory;
import org.sourceprojects.xmlparser.XmlParserOsgiFactory;
import org.sourceprojects.xmlparser.exceptions.XmlParserInitializationException;
import org.sourceprojects.xmlparser.internal.dom.OsgiResourceResolverImpl;

/**
 * 
 * @author noctarius
 * @since 0.0.5
 */
public class XmlParserOsgiFactoryImpl implements XmlParserOsgiFactory {
	private final Bundle bundle;

	public XmlParserOsgiFactoryImpl(Bundle bundle) {
		this.bundle = bundle;
	}

	@Override
	public <B> XmlParser<B> newParserInstance()
			throws XmlParserInitializationException {
		return XmlParserFactory.newInstance(getClass().getClassLoader());
	}

	@Override
	public ResourceResolver newResourceResolverInstance()
			throws XmlParserInitializationException {
		ResourceResolver resolver = new OsgiResourceResolverImpl(bundle);
		return resolver;
	}

}
