/*
 * 
 *  This file is part of Sourceprojects.org Lycia Copyright 2010 noctarius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * 
 */
package org.sourceprojects.xmlparser.internal.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import org.osgi.framework.Bundle;
import org.sourceprojects.xmlparser.NamespaceResolver;
import org.sourceprojects.xmlparser.internal.dom.LSInputImpl;
import org.sourceprojects.xmlparser.internal.resolver.BasicNamespaceResolver.NamespaceResolverHandlerContainer;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;

/**
 * 
 * @author noctarius
 * @since 0.0.5
 */
public class OsgiBasicNamespaceResolver implements NamespaceResolver {
	private final NamespaceResolverHandlerContainer[] containers;
	private final Bundle bundle;

	public OsgiBasicNamespaceResolver(
			NamespaceResolverHandlerContainer[] containers, Bundle bundle) {
		this.containers = containers;
		this.bundle = bundle;
	}

	@Override
	public LSInput getInput(String type, String namespaceURI, String publicId,
			String systemId, String baseURI) {

		for (NamespaceResolverHandlerContainer container : containers) {
			if (container.getNamespaceURI().equals(namespaceURI)
					|| container.getNamespaceURI().equals(systemId)) {
				InputStream is = getByteStream(container.getRedirectedURI());

				LSInput input = new LSInputImpl();
				input.setBaseURI(baseURI);
				input.setPublicId(publicId);
				input.setSystemId(systemId);
				input.setByteStream(is);

				return input;
			}
		}

		try {
			DOMImplementationRegistry registry = DOMImplementationRegistry
					.newInstance();
			DOMImplementationLS impl = (DOMImplementationLS) registry
					.getDOMImplementation("XML").getFeature("LS", "");

			return impl.createLSInput();
		} catch (ClassCastException e) {
			return new LSInputImpl();
		} catch (ClassNotFoundException e) {
			return new LSInputImpl();
		} catch (InstantiationException e) {
			return new LSInputImpl();
		} catch (IllegalAccessException e) {
			return new LSInputImpl();
		}
	}

	@Override
	public String getNamespaceURI() {
		return null;
	}

	private InputStream getByteStream(String uri) {
		URL url = bundle.getResource(uri);
		try {
			return url.openStream();
		} catch (IOException e) {
			return null;
		}
	}
}
