/*
 * Decompiled with CFR 0.152.
 */
package org.sourceprojects.lycia;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.sourceprojects.lycia.DefinitionBuilder;
import org.sourceprojects.lycia.ParserContext;
import org.sourceprojects.lycia.TagDefinitionParser;
import org.sourceprojects.lycia.annotations.Namespace;
import org.sourceprojects.lycia.annotations.Tag;
import org.sourceprojects.lycia.annotations.XPath;
import org.sourceprojects.lycia.exceptions.LyciaParsingException;
import org.sourceprojects.lycia.internal.configuration.NamespaceInnerImpl;
import org.sourceprojects.lycia.internal.configuration.TagInnerImpl;
import org.sourceprojects.lycia.internal.configuration.XPathInnerImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractTagParser<B>
implements TagDefinitionParser<B> {
    private static final Namespace[] ZERO_LENGTH_NAMESPACE_ARRAY = new Namespace[]{new NamespaceInnerImpl(null, null)};

    @Override
    public void parseElement(Element element, ParserContext<B> parserContext, DefinitionBuilder definitionBuilder) throws LyciaParsingException {
    }

    @Override
    public void parseElement(Element element, String localName, ParserContext<B> parserContext, DefinitionBuilder definitionBuilder) throws LyciaParsingException {
        this.parseElement(element, parserContext, definitionBuilder);
    }

    @Override
    public void parseElement(Element element, String localName, QName parent, ParserContext<B> parserContext, DefinitionBuilder definitionBuilder) throws LyciaParsingException {
        this.parseElement(element, localName, parserContext, definitionBuilder);
    }

    @Override
    public Node transformElement(Element element, ParserContext<B> parserContext, DefinitionBuilder definitionBuilder) throws LyciaParsingException {
        return definitionBuilder.getDocument().importNode(element, false);
    }

    @Override
    public Node transformElement(Element element, String localName, ParserContext<B> parserContext, DefinitionBuilder definitionBuilder) throws LyciaParsingException {
        return this.transformElement(element, parserContext, definitionBuilder);
    }

    @Override
    public Node transformElement(Element element, String localName, QName parent, ParserContext<B> parserContext, DefinitionBuilder definitionBuilder) throws LyciaParsingException {
        return this.transformElement(element, localName, parserContext, definitionBuilder);
    }

    @Override
    public String[] getTags() {
        return new String[0];
    }

    @Override
    public Tag[] getTagAnnotations() {
        if (this.getTags().length == 0) {
            return new Tag[0];
        }
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (String tag : this.getTags()) {
            tags.add(this.getTagAnnotationImpl(tag, this.getNamespace()));
        }
        return tags.toArray(new Tag[tags.size()]);
    }

    private Tag getTagAnnotationImpl(String tag, String namespace) {
        return new TagInnerImpl(tag, namespace, this.getNullXPathExpression(), false);
    }

    private XPath getNullXPathExpression() {
        return new XPathInnerImpl("~~NULL~~", this.getNamespaceArray());
    }

    private Namespace[] getNamespaceArray() {
        return ZERO_LENGTH_NAMESPACE_ARRAY;
    }
}

