/*
 * Decompiled with CFR 0.152.
 */
package org.sourceprojects.lycia;

import org.sourceprojects.lycia.LyciaParser;
import org.sourceprojects.lycia.ParserContext;
import org.sourceprojects.lycia.ResourceResolverFactory;
import org.sourceprojects.lycia.exceptions.LyciaInitializationException;

public final class LyciaParserFactory {
    public static final String STANDARD_XMLPARSER_CLASS = "org.sourceprojects.lycia.internal.LyciaParserImpl";
    public static final String STANDARD_PARSERCONTEXT_THREADSAFE_CLASS = "org.sourceprojects.lycia.internal.ThreadsafeParserContextImpl";
    public static final String STANDARD_PARSERCONTEXT_CLASS = "org.sourceprojects.lycia.internal.ParserContextImpl";

    public static final <B> LyciaParser<B> newInstance() {
        return LyciaParserFactory.newInstance(false);
    }

    public static final <B> LyciaParser<B> newInstance(boolean threadsafe) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (threadsafe) {
            return LyciaParserFactory.newInstance(STANDARD_XMLPARSER_CLASS, STANDARD_PARSERCONTEXT_THREADSAFE_CLASS, classLoader);
        }
        return LyciaParserFactory.newInstance(STANDARD_XMLPARSER_CLASS, STANDARD_PARSERCONTEXT_CLASS, classLoader);
    }

    public static final <B> LyciaParser<B> newInstance(ClassLoader classLoader) {
        return LyciaParserFactory.newInstance(classLoader, false);
    }

    public static final <B> LyciaParser<B> newInstance(ClassLoader classLoader, boolean threadsafe) {
        if (threadsafe) {
            return LyciaParserFactory.newInstance(STANDARD_XMLPARSER_CLASS, STANDARD_PARSERCONTEXT_THREADSAFE_CLASS, classLoader);
        }
        return LyciaParserFactory.newInstance(STANDARD_XMLPARSER_CLASS, STANDARD_PARSERCONTEXT_CLASS, classLoader);
    }

    public static final <B> LyciaParser<B> newInstance(String parserImplementationClassname, String contextImplementationClassname, ClassLoader classLoader) {
        return LyciaParserFactory.newInstance(parserImplementationClassname, contextImplementationClassname, classLoader, true);
    }

    public static final <B> LyciaParser<B> newInstance(String parserImplementationClassname, String contextImplementationClassname, ClassLoader classLoader, boolean createResourceResolver) {
        try {
            Class<?> parserClass = classLoader.loadClass(parserImplementationClassname);
            Class<?> contextClass = classLoader.loadClass(contextImplementationClassname);
            LyciaParser parser = (LyciaParser)parserClass.newInstance();
            ParserContext context = (ParserContext)contextClass.newInstance();
            parser.setParserContext(context);
            if (createResourceResolver) {
                parser.setResourceResolver(ResourceResolverFactory.newInstance(classLoader));
            }
            return parser;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new LyciaInitializationException("Parser initialization failed", e);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new LyciaInitializationException("Parser initialization failed", e);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new LyciaInitializationException("Parser initialization failed", e);
        }
    }

    private LyciaParserFactory() {
    }
}

