/*
 * Decompiled with CFR 0.152.
 */
package org.sourceprojects.lycia;

import org.sourceprojects.lycia.ResourceResolver;
import org.sourceprojects.lycia.exceptions.LyciaInitializationException;

public final class ResourceResolverFactory {
    public static final String STANDARD_RESOURCERESOLVER_CLASS = "org.sourceprojects.lycia.internal.dom.ResourceResolverImpl";

    public static final ResourceResolver newInstance() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return ResourceResolverFactory.newInstance(STANDARD_RESOURCERESOLVER_CLASS, classLoader);
    }

    public static final ResourceResolver newInstance(ClassLoader classLoader) {
        return ResourceResolverFactory.newInstance(STANDARD_RESOURCERESOLVER_CLASS, classLoader);
    }

    public static final ResourceResolver newInstance(String resolverImplementationClassname, ClassLoader classLoader) {
        try {
            Class<?> resolverClass = classLoader.loadClass(resolverImplementationClassname);
            return (ResourceResolver)resolverClass.newInstance();
        }
        catch (Exception e) {
            throw new LyciaInitializationException("Parser initialization failed", e);
        }
    }

    private ResourceResolverFactory() {
    }
}

