/*
 * Decompiled with CFR 0.152.
 */
package org.sourceprojects.lycia.fluent;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.sourceprojects.lycia.Generator;
import org.sourceprojects.lycia.LyciaBuilder;
import org.sourceprojects.lycia.LyciaConfigurator;
import org.sourceprojects.lycia.LyciaParser;
import org.sourceprojects.lycia.exceptions.LyciaInitializationException;
import org.sourceprojects.lycia.fluent.ConfigurationBuilder;
import org.xml.sax.ContentHandler;

class ConfigurationBuilderHelper {
    private ConfigurationBuilderHelper() {
    }

    static <B> ConfigurationBuilder<B> createValidatingSchema(final boolean validatingSchema) {
        return new AbstractConfigurationBuilder<B>(){

            @Override
            public void configure(LyciaParser<B> xmlParser) {
                xmlParser.setValidatingSchema(validatingSchema);
            }
        };
    }

    static <B> ConfigurationBuilder<B> createGenerationStrategy(final LyciaBuilder.GenerationStrategy generationStrategy, final Class<? extends Generator> generatorClass) {
        if (generationStrategy == null) {
            throw new IllegalArgumentException("GenerationStrategy cannot be null");
        }
        if (generationStrategy == LyciaBuilder.GenerationStrategy.Customized && generatorClass == null) {
            throw new IllegalArgumentException("When using GenerationStrategy.Customized Generator class cannot be null");
        }
        return new AbstractConfigurationBuilder<B>(){

            @Override
            public int getPriority() {
                return -2147483647;
            }

            @Override
            public void configure(LyciaParser<B> xmlParser) {
                LyciaConfigurator configurator = xmlParser.getConfigurator();
                configurator.setGenerationStrategy(generationStrategy);
                if (generationStrategy == LyciaBuilder.GenerationStrategy.Customized) {
                    configurator.getGeneratorFactory().setCustomGeneratorClass(generatorClass);
                }
            }
        };
    }

    static <B> ConfigurationBuilder<B> createXmlParserConfigurator(final Class<? extends LyciaConfigurator> configuratorClass) {
        if (configuratorClass == null) {
            throw new IllegalArgumentException("XmlParserConfigurator class cannot be null");
        }
        return new AbstractConfigurationBuilder<B>(){

            @Override
            public int getPriority() {
                return Integer.MIN_VALUE;
            }

            @Override
            public void configure(LyciaParser<B> xmlParser) {
                try {
                    Class clazz = configuratorClass;
                    Constructor constructor = clazz.getConstructor(LyciaParser.class, LyciaConfigurator.class);
                    LyciaConfigurator configurator = (LyciaConfigurator)constructor.newInstance(xmlParser, xmlParser.getConfigurator());
                    xmlParser.setConfigurator(configurator);
                }
                catch (InvocationTargetException e) {
                    throw new LyciaInitializationException(e);
                }
                catch (IllegalArgumentException e) {
                    throw new LyciaInitializationException(e);
                }
                catch (InstantiationException e) {
                    throw new LyciaInitializationException(e);
                }
                catch (IllegalAccessException e) {
                    throw new LyciaInitializationException(e);
                }
                catch (SecurityException e) {
                    throw new LyciaInitializationException(e);
                }
                catch (NoSuchMethodException e) {
                    throw new LyciaInitializationException(e);
                }
            }
        };
    }

    static <B> ConfigurationBuilder<B> createContentHandler(final ContentHandler contentHandler) {
        return new AbstractConfigurationBuilder<B>(){

            @Override
            public void configure(LyciaParser<B> xmlParser) {
                xmlParser.getConfigurator().addContentHandler(contentHandler);
            }
        };
    }

    static abstract class AbstractConfigurationBuilder<B>
    implements ConfigurationBuilder<B> {
        AbstractConfigurationBuilder() {
        }

        @Override
        public int getPriority() {
            return 0;
        }
    }
}

