/*
 * Decompiled with CFR 0.152.
 */
package org.sourceprojects.lycia.fluent;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.sourceprojects.lycia.ConstraintValidator;
import org.sourceprojects.lycia.Generator;
import org.sourceprojects.lycia.LyciaBuilder;
import org.sourceprojects.lycia.LyciaConfigurator;
import org.sourceprojects.lycia.LyciaParser;
import org.sourceprojects.lycia.TagDefinitionParser;
import org.sourceprojects.lycia.fluent.ConfigurationBuilder;
import org.sourceprojects.lycia.fluent.ConfigurationBuilderHelper;
import org.sourceprojects.lycia.fluent.FluentBuilderImpl;
import org.sourceprojects.lycia.fluent.MethodBuilder;
import org.sourceprojects.lycia.fluent.NamespaceBuilder;
import org.sourceprojects.lycia.fluent.NamespacesBuilder;
import org.sourceprojects.lycia.fluent.RegexEventBuilder;
import org.sourceprojects.lycia.fluent.TagEventBuilder;
import org.sourceprojects.lycia.fluent.ValidationBuilder;
import org.sourceprojects.lycia.fluent.ValidationsBuilder;
import org.sourceprojects.lycia.fluent.XPathEventBuilder;
import org.xml.sax.ContentHandler;

public abstract class FluentBuilder<B> {
    public static final <B> FluentBuilder<B> prepare() {
        return new FluentBuilderImpl();
    }

    public static final ValidationBuilder validation(Class<? extends ConstraintValidator<? extends Annotation>> validator) {
        return new ValidationBuilder(validator);
    }

    public static final NamespaceBuilder namespace(String prefix, String uri) {
        return new NamespaceBuilder(prefix, uri);
    }

    public static final MethodBuilder method(final Method method, final Object parser) {
        return new MethodBuilder(){

            @Override
            public Method getMethod() {
                return method;
            }

            @Override
            public Object getParser() {
                return parser;
            }
        };
    }

    public static final NamespacesBuilder namespaces(NamespaceBuilder ... namespaceBuilders) {
        return new NamespacesBuilder(namespaceBuilders);
    }

    public static final ValidationsBuilder validations(ValidationBuilder ... validationBuilders) {
        return new ValidationsBuilder(validationBuilders);
    }

    public static final XPathEventBuilder xpath(String expression, MethodBuilder methodBuilder) {
        return new XPathEventBuilder(expression, null, methodBuilder, null);
    }

    public static final RegexEventBuilder regex(String expression, MethodBuilder methodBuilder) {
        return new RegexEventBuilder(expression, "", methodBuilder, null);
    }

    public static final TagEventBuilder tag(String expression, MethodBuilder methodBuilder) {
        return new TagEventBuilder(expression, "", methodBuilder, null);
    }

    public static final XPathEventBuilder xpath(String expression, MethodBuilder methodBuilder, NamespacesBuilder namespacesBuilder) {
        return new XPathEventBuilder(expression, namespacesBuilder, methodBuilder, null);
    }

    public static final RegexEventBuilder regex(String expression, String namespaceUri, MethodBuilder methodBuilder) {
        return new RegexEventBuilder(expression, namespaceUri, methodBuilder, null);
    }

    public static final TagEventBuilder tag(String expression, String namespaceUri, MethodBuilder methodBuilder) {
        return new TagEventBuilder(expression, namespaceUri, methodBuilder, null);
    }

    public static final XPathEventBuilder xpath(String expression, MethodBuilder methodBuilder, ValidationsBuilder validationsBuilder) {
        return new XPathEventBuilder(expression, null, methodBuilder, validationsBuilder);
    }

    public static final RegexEventBuilder regex(String expression, MethodBuilder methodBuilder, ValidationsBuilder validationsBuilder) {
        return new RegexEventBuilder(expression, "", methodBuilder, validationsBuilder);
    }

    public static final TagEventBuilder tag(String expression, MethodBuilder methodBuilder, ValidationsBuilder validationsBuilder) {
        return new TagEventBuilder(expression, "", methodBuilder, validationsBuilder);
    }

    public static final XPathEventBuilder xpath(String expression, MethodBuilder methodBuilder, NamespacesBuilder namespacesBuilder, ValidationsBuilder validationsBuilder) {
        return new XPathEventBuilder(expression, namespacesBuilder, methodBuilder, validationsBuilder);
    }

    public static final RegexEventBuilder regex(String expression, String namespaceUri, MethodBuilder methodBuilder, ValidationsBuilder validationsBuilder) {
        return new RegexEventBuilder(expression, namespaceUri, methodBuilder, validationsBuilder);
    }

    public static final TagEventBuilder tag(String expression, String namespaceUri, MethodBuilder methodBuilder, ValidationsBuilder validationsBuilder) {
        return new TagEventBuilder(expression, namespaceUri, methodBuilder, validationsBuilder);
    }

    public static final ConfigurationBuilder validateSchema(boolean validatingSchema) {
        return ConfigurationBuilderHelper.createValidatingSchema(validatingSchema);
    }

    public static final ConfigurationBuilder generationStrategy(LyciaBuilder.GenerationStrategy generationStrategy) {
        return ConfigurationBuilderHelper.createGenerationStrategy(generationStrategy, null);
    }

    public static final ConfigurationBuilder generationStrategy(LyciaBuilder.GenerationStrategy generationStrategy, Class<? extends Generator> generatorClass) {
        return ConfigurationBuilderHelper.createGenerationStrategy(generationStrategy, generatorClass);
    }

    public static final ConfigurationBuilder contentHandler(ContentHandler contentHandler) {
        return ConfigurationBuilderHelper.createContentHandler(contentHandler);
    }

    public static final ConfigurationBuilder configurator(Class<? extends LyciaConfigurator> configuratorClass) {
        return ConfigurationBuilderHelper.createXmlParserConfigurator(configuratorClass);
    }

    public abstract LyciaParser<B> build();

    public abstract FluentBuilder<B> parser(TagDefinitionParser<B> var1);

    public abstract FluentBuilder<B> parser(XPathEventBuilder var1);

    public abstract FluentBuilder<B> parser(RegexEventBuilder var1);

    public abstract FluentBuilder<B> parser(TagEventBuilder var1);

    public abstract FluentBuilder<B> transformer(TagDefinitionParser<B> var1);

    public abstract FluentBuilder<B> transformer(XPathEventBuilder var1);

    public abstract FluentBuilder<B> transformer(RegexEventBuilder var1);

    public abstract FluentBuilder<B> transformer(TagEventBuilder var1);

    public abstract FluentBuilder<B> configure(ConfigurationBuilder<B> var1);

    public abstract FluentBuilder<B> configure(ConfigurationBuilder<B> ... var1);
}

