/*
 * Decompiled with CFR 0.152.
 */
package org.sourceprojects.lycia.fluent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.sourceprojects.lycia.LyciaConfigurator;
import org.sourceprojects.lycia.LyciaParser;
import org.sourceprojects.lycia.LyciaParserFactory;
import org.sourceprojects.lycia.TagDefinitionParser;
import org.sourceprojects.lycia.exceptions.LyciaConfigurationException;
import org.sourceprojects.lycia.fluent.ConfigurationBuilder;
import org.sourceprojects.lycia.fluent.FluentBuilder;
import org.sourceprojects.lycia.fluent.RegexEventBuilder;
import org.sourceprojects.lycia.fluent.TagEventBuilder;
import org.sourceprojects.lycia.fluent.XPathEventBuilder;
import org.sourceprojects.lycia.internal.XPathAwareXmlParserConfigurator;

class FluentBuilderImpl<B>
extends FluentBuilder<B> {
    private final List<TagDefinitionParser<B>> tagParsers = new ArrayList<TagDefinitionParser<B>>();
    private final List<RegexEventBuilder<B>> regexEventParsers = new ArrayList<RegexEventBuilder<B>>();
    private final List<XPathEventBuilder<B>> xpathEventParsers = new ArrayList<XPathEventBuilder<B>>();
    private final List<TagEventBuilder<B>> tagEventParsers = new ArrayList<TagEventBuilder<B>>();
    private final List<ConfigurationBuilder<B>> configurationBuilders = new ArrayList<ConfigurationBuilder<B>>();

    FluentBuilderImpl() {
    }

    @Override
    public LyciaParser<B> build() {
        LyciaParser xmlParser = LyciaParserFactory.newInstance();
        Collections.sort(this.configurationBuilders, new ConfigurationBuilderPriorityComparator());
        for (ConfigurationBuilder configurationBuilder : this.configurationBuilders) {
            configurationBuilder.configure(xmlParser);
        }
        LyciaConfigurator configurator = xmlParser.getConfigurator();
        for (TagDefinitionParser<B> tagDefinitionParser : this.tagParsers) {
            configurator.addTagDefinitionParser(tagDefinitionParser);
        }
        for (TagEventBuilder tagEventBuilder : this.tagEventParsers) {
            configurator.addTagDefinitionParser(tagEventBuilder.build(configurator));
        }
        for (RegexEventBuilder regexEventBuilder : this.regexEventParsers) {
            configurator.addTagDefinitionParser(regexEventBuilder.build(configurator));
        }
        XPathAwareXmlParserConfigurator xpathConfigurator = this.findXPathAwareConfigurator(configurator);
        for (XPathEventBuilder xpathEventParser : this.xpathEventParsers) {
            if (xpathConfigurator == null) {
                throw new LyciaConfigurationException("No XPath aware XmlParserConfigurator was found but is needed for XPath parsing");
            }
            XPathEventBuilder.BuildReturn<B> build = xpathEventParser.build(configurator);
            xpathConfigurator.registerXPathTagDefinitionParser(build.delegate, build.tag, build.namespaceURI);
        }
        return xmlParser;
    }

    @Override
    public FluentBuilder<B> parser(TagDefinitionParser<B> tagDefinitionParser) {
        this.tagParsers.add(tagDefinitionParser);
        return this;
    }

    @Override
    public FluentBuilder<B> parser(XPathEventBuilder xpathEventBuilder) {
        this.xpathEventParsers.add(xpathEventBuilder);
        return this;
    }

    @Override
    public FluentBuilder<B> parser(RegexEventBuilder regexEventBuilder) {
        this.regexEventParsers.add(regexEventBuilder);
        return this;
    }

    @Override
    public FluentBuilder<B> parser(TagEventBuilder tagEventBuilder) {
        this.tagEventParsers.add(tagEventBuilder);
        return this;
    }

    @Override
    public FluentBuilder<B> transformer(TagDefinitionParser<B> tagDefinitionParser) {
        this.tagParsers.add(tagDefinitionParser);
        return this;
    }

    @Override
    public FluentBuilder<B> transformer(XPathEventBuilder xpathEventBuilder) {
        this.xpathEventParsers.add(xpathEventBuilder);
        return this;
    }

    @Override
    public FluentBuilder<B> transformer(RegexEventBuilder regexEventBuilder) {
        this.regexEventParsers.add(regexEventBuilder);
        return this;
    }

    @Override
    public FluentBuilder<B> transformer(TagEventBuilder tagEventBuilder) {
        this.tagEventParsers.add(tagEventBuilder);
        return this;
    }

    @Override
    public FluentBuilder<B> configure(ConfigurationBuilder<B> configurationBuilder) {
        this.configurationBuilders.add(configurationBuilder);
        return this;
    }

    @Override
    public FluentBuilder<B> configure(ConfigurationBuilder<B> ... configurationBuilders) {
        this.configurationBuilders.addAll(Arrays.asList(configurationBuilders));
        return this;
    }

    private XPathAwareXmlParserConfigurator<B> findXPathAwareConfigurator(LyciaConfigurator<B> configurator) {
        if (configurator instanceof XPathAwareXmlParserConfigurator) {
            return (XPathAwareXmlParserConfigurator)((Object)configurator);
        }
        if (configurator.getParentXmlParserConfigurator() == null) {
            return null;
        }
        return this.findXPathAwareConfigurator(configurator.getParentXmlParserConfigurator());
    }

    private class ConfigurationBuilderPriorityComparator
    implements Comparator<ConfigurationBuilder<B>> {
        private ConfigurationBuilderPriorityComparator() {
        }

        @Override
        public int compare(ConfigurationBuilder<B> o1, ConfigurationBuilder<B> o2) {
            if (o1.getPriority() == o2.getPriority()) {
                return 0;
            }
            return o1.getPriority() < o2.getPriority() ? -1 : 1;
        }
    }
}

