/*
 * Decompiled with CFR 0.152.
 */
package org.sourceprojects.lycia.fluent;

import org.sourceprojects.lycia.Delegate;
import org.sourceprojects.lycia.Generator;
import org.sourceprojects.lycia.LyciaConfigurator;
import org.sourceprojects.lycia.TagDefinitionParser;
import org.sourceprojects.lycia.annotations.Namespace;
import org.sourceprojects.lycia.annotations.Validator;
import org.sourceprojects.lycia.fluent.MethodBuilder;
import org.sourceprojects.lycia.fluent.ValidationsBuilder;
import org.sourceprojects.lycia.internal.configuration.DelegateTagDefinitionParser;
import org.sourceprojects.lycia.internal.configuration.TagConfigurationUtils;
import org.sourceprojects.lycia.internal.configuration.TagInnerImpl;
import org.sourceprojects.lycia.internal.configuration.XPathInnerImpl;

class TagEventBuilder<B> {
    private final String expression;
    private final String namespaceUri;
    private final MethodBuilder methodBuilder;
    private final ValidationsBuilder validationsBuilder;

    TagEventBuilder(String expression, String namespaceUri, MethodBuilder methodBuilder, ValidationsBuilder validationsBuilder) {
        this.expression = expression;
        this.namespaceUri = namespaceUri;
        this.methodBuilder = methodBuilder;
        this.validationsBuilder = validationsBuilder;
    }

    TagDefinitionParser<B> build(LyciaConfigurator<B> configurator) {
        Generator<B> generator = configurator.getGeneratorFactory().newInstance(configurator.getGenerationStrategy());
        Validator[] validators = this.validationsBuilder != null ? this.validationsBuilder.build() : new Validator[]{};
        TagInnerImpl tag = new TagInnerImpl(this.expression, this.namespaceUri, new XPathInnerImpl("~~NULL~~", new Namespace[0]), false, validators);
        TagConfigurationUtils.MethodDefinition definition = new TagConfigurationUtils.MethodDefinition(this.methodBuilder.getMethod(), tag);
        Delegate<B> delegate = generator.generate(this.methodBuilder.getParser(), definition);
        return new DelegateTagDefinitionParser<B>(delegate, tag, this.namespaceUri);
    }
}

