/*
 * Decompiled with CFR 0.152.
 */
package org.sourceprojects.lycia.fluent;

import org.sourceprojects.lycia.Delegate;
import org.sourceprojects.lycia.Generator;
import org.sourceprojects.lycia.LyciaConfigurator;
import org.sourceprojects.lycia.annotations.Namespace;
import org.sourceprojects.lycia.annotations.Tag;
import org.sourceprojects.lycia.annotations.Validator;
import org.sourceprojects.lycia.fluent.MethodBuilder;
import org.sourceprojects.lycia.fluent.NamespacesBuilder;
import org.sourceprojects.lycia.fluent.ValidationsBuilder;
import org.sourceprojects.lycia.internal.configuration.TagConfigurationUtils;
import org.sourceprojects.lycia.internal.configuration.TagInnerImpl;
import org.sourceprojects.lycia.internal.configuration.XPathInnerImpl;

class XPathEventBuilder<B> {
    private final String expression;
    private final NamespacesBuilder namespacesBuilder;
    private final MethodBuilder methodBuilder;
    private final ValidationsBuilder validationsBuilder;

    XPathEventBuilder(String expression, NamespacesBuilder namespacesBuilder, MethodBuilder methodBuilder, ValidationsBuilder validationsBuilder) {
        this.expression = expression;
        this.namespacesBuilder = namespacesBuilder;
        this.methodBuilder = methodBuilder;
        this.validationsBuilder = validationsBuilder;
    }

    BuildReturn<B> build(LyciaConfigurator<B> configurator) {
        Generator<B> generator = configurator.getGeneratorFactory().newInstance(configurator.getGenerationStrategy());
        Validator[] validators = this.validationsBuilder != null ? this.validationsBuilder.build() : new Validator[]{};
        Namespace[] namespaces = this.namespacesBuilder != null ? this.namespacesBuilder.build() : new Namespace[]{};
        TagInnerImpl tag = new TagInnerImpl("*", "", new XPathInnerImpl(this.expression, namespaces), false, validators);
        TagConfigurationUtils.MethodDefinition definition = new TagConfigurationUtils.MethodDefinition(this.methodBuilder.getMethod(), tag);
        Delegate<B> delegate = generator.generate(this.methodBuilder.getParser(), definition);
        return new BuildReturn(delegate, tag, "");
    }

    static class BuildReturn<B> {
        final Delegate<B> delegate;
        final Tag tag;
        final String namespaceURI;

        private BuildReturn(Delegate<B> delegate, Tag tag, String namespaceURI) {
            this.delegate = delegate;
            this.tag = tag;
            this.namespaceURI = namespaceURI;
        }
    }
}

