/*
 * Decompiled with CFR 0.152.
 */
package org.sourceprojects.lycia.internal;

import org.sourceprojects.lycia.LyciaBuilder;
import org.sourceprojects.lycia.LyciaParser;
import org.sourceprojects.lycia.LyciaParserFactory;
import org.sourceprojects.lycia.ParserContext;
import org.sourceprojects.lycia.ResourceResolver;
import org.sourceprojects.lycia.ResourceResolverFactory;
import org.xml.sax.ErrorHandler;

public class LyciaBuilderImpl<B>
implements LyciaBuilder<B> {
    private boolean validatingSchema;
    private ErrorHandler errorHandler;
    private ResourceResolver resourceResolver;
    private ParserContext<B> parserContext;
    private LyciaBuilder.GenerationStrategy generationStrategy = LyciaBuilder.GenerationStrategy.ReflectiveGeneration;
    private ClassLoader classLoader;
    private Class<? extends ResourceResolver> resourceResolverClass;
    private Class<? extends ParserContext<B>> parserContextClass;
    private Class<? extends LyciaParser<B>> xmlParserClass;

    @Override
    public LyciaParser<B> build() {
        if (this.resourceResolver == null) {
            this.resourceResolver = this.resourceResolverClass != null ? ResourceResolverFactory.newInstance(this.resourceResolverClass.getCanonicalName(), this.classLoader) : ResourceResolverFactory.newInstance(this.classLoader);
        }
        String parserContextClassName = this.parserContext != null ? (this.parserContextClass != null ? this.parserContextClass.getCanonicalName() : "org.sourceprojects.lycia.internal.ParserContextImpl") : "org.sourceprojects.lycia.internal.ParserContextImpl";
        String xmlParserClassName = this.xmlParserClass != null ? this.xmlParserClass.getCanonicalName() : "org.sourceprojects.lycia.internal.LyciaParserImpl";
        LyciaParser<B> xmlParser = LyciaParserFactory.newInstance(xmlParserClassName, parserContextClassName, this.classLoader, false);
        xmlParser.setErrorHandler(this.errorHandler);
        xmlParser.setValidatingSchema(this.validatingSchema);
        xmlParser.setResourceResolver(this.resourceResolver);
        xmlParser.getConfigurator().setGenerationStrategy(this.generationStrategy);
        if (this.parserContext != null) {
            xmlParser.setParserContext(this.parserContext);
        }
        return xmlParser;
    }

    @Override
    public LyciaBuilder<B> setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    @Override
    public LyciaBuilder<B> setGenerationStrategy(LyciaBuilder.GenerationStrategy generationStrategy) {
        this.generationStrategy = generationStrategy;
        return this;
    }

    @Override
    public LyciaBuilder<B> setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    @Override
    public LyciaBuilder<B> setParserContext(ParserContext<B> parserContext) {
        this.parserContext = parserContext;
        return this;
    }

    @Override
    public LyciaBuilder<B> setParserContextClass(Class<? extends ParserContext<B>> parserContextClass) {
        this.parserContextClass = parserContextClass;
        return this;
    }

    @Override
    public LyciaBuilder<B> setResourceResolver(ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
        return this;
    }

    @Override
    public LyciaBuilder<B> setResourceResolverClass(Class<? extends ResourceResolver> resourceResolverClass) {
        this.resourceResolverClass = resourceResolverClass;
        return this;
    }

    @Override
    public LyciaBuilder<B> setValidatingSchema(boolean validatingSchema) {
        this.validatingSchema = validatingSchema;
        return this;
    }

    @Override
    public LyciaBuilder<B> setXmlParserClass(Class<? extends LyciaParser<B>> xmlParserClass) {
        this.xmlParserClass = xmlParserClass;
        return this;
    }
}

