/*
 * Decompiled with CFR 0.152.
 */
package org.sourceprojects.lycia.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.log4j.Logger;
import org.sourceprojects.lycia.DefinitionBuilder;
import org.sourceprojects.lycia.LyciaConfigurator;
import org.sourceprojects.lycia.LyciaParser;
import org.sourceprojects.lycia.ParserContext;
import org.sourceprojects.lycia.ProgressListener;
import org.sourceprojects.lycia.ResourceResolver;
import org.sourceprojects.lycia.TagDefinitionParser;
import org.sourceprojects.lycia.annotations.AfterPropertySet;
import org.sourceprojects.lycia.exceptions.LyciaInitializationException;
import org.sourceprojects.lycia.exceptions.LyciaParsingException;
import org.sourceprojects.lycia.internal.Cache;
import org.sourceprojects.lycia.internal.DataLengthStringReader;
import org.sourceprojects.lycia.internal.DefinitionBuilderImpl;
import org.sourceprojects.lycia.internal.InternalParserContext;
import org.sourceprojects.lycia.internal.ParserContextUtils;
import org.sourceprojects.lycia.internal.ProgressAwareReader;
import org.sourceprojects.lycia.internal.bundled.ReaderInputStream;
import org.sourceprojects.lycia.internal.configuration.RankingXmlParserConfigurator;
import org.sourceprojects.lycia.internal.io.LyciaXmlReader;
import org.sourceprojects.lycia.io.LyciaReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LyciaParserImpl<B>
implements LyciaParser<B> {
    private static final Logger LOGGER = Logger.getLogger(LyciaParserImpl.class);
    private final List<ProgressListener> listeners = new ArrayList<ProgressListener>();
    private LyciaConfigurator<B> configurator;
    private ResourceResolver resourceResolver;
    private ErrorHandler errorHandler;
    private ParserContext<B> parserContext;
    private boolean validatingSchema = true;
    private Class<? extends LyciaReader<B>> readerClass;
    private LyciaReader<B> reader;
    private long expirationTime = 100L;

    public LyciaParserImpl() {
        this(null);
    }

    public LyciaParserImpl(LyciaConfigurator<B> configurator) {
        this.configurator = configurator != null ? configurator : new RankingXmlParserConfigurator(this, null);
    }

    @Override
    public void addTagDefinitionParser(TagDefinitionParser<B> tagDefinitionParser) {
        this.configurator.addTagDefinitionParser(tagDefinitionParser);
    }

    @Override
    public void addTagDefinitionParsers(TagDefinitionParser<B>[] tagDefinitionParsers) {
        this.configurator.addTagDefinitionParsers(tagDefinitionParsers);
    }

    @Override
    public void removeTagDefinitionParser(TagDefinitionParser<B> tagDefinitionParser) {
        this.configurator.removeTagDefinitionParser(tagDefinitionParser);
    }

    @Override
    public void removeTagDefinitionParsers(TagDefinitionParser<B>[] tagDefinitionParsers) {
        this.configurator.removeTagDefinitionParsers(tagDefinitionParsers);
    }

    @Override
    public void parse(InputStream inputStream) throws LyciaParsingException {
        try {
            Document document = this.createReader(inputStream);
            DefinitionBuilderImpl definitionBuilder = new DefinitionBuilderImpl(document);
            for (Node node = document.getFirstChild(); node != null; node = node.getNextSibling()) {
                this.readNode(node, definitionBuilder);
            }
        }
        catch (Exception e) {
            throw new LyciaParsingException("Parsing failed", e);
        }
        finally {
            if (this.parserContext instanceof InternalParserContext) {
                InternalParserContext context = (InternalParserContext)this.parserContext;
                Cache<Pattern> patternCache = context.getContextUtils().getPatternCache();
                Cache<NodeList> xpathCache = context.getContextUtils().getXPathCache();
                if (patternCache != null) {
                    patternCache.shutdown();
                }
                if (xpathCache != null) {
                    xpathCache.shutdown();
                }
                context.setContextUtils(new ParserContextUtils());
            }
        }
    }

    @Override
    public void parse(Reader reader) throws LyciaParsingException {
        this.parse(reader, 0L);
    }

    public void parse(Reader reader, long length) throws LyciaParsingException {
        this.parse(new ReaderInputStream(reader, length));
    }

    @Override
    public void parse(String xml) throws LyciaParsingException {
        this.parse(new DataLengthStringReader(xml, xml.length()));
    }

    @Override
    public void parse(File file) throws LyciaParsingException {
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            this.parse(reader, file.length());
        }
        catch (FileNotFoundException e) {
            throw new LyciaParsingException("Parsing failed", e);
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public Document transform(InputStream inputStream) throws LyciaParsingException {
        try {
            Document document = this.createReader(inputStream);
            Document transformedDocument = this.createDocumentBuilder().newDocument();
            DefinitionBuilderImpl definitionBuilder = new DefinitionBuilderImpl(transformedDocument);
            for (Node node = document.getFirstChild(); node != null; node = node.getNextSibling()) {
                Node result = this.transformNode(node, definitionBuilder);
                if (result == null) continue;
                transformedDocument.appendChild(result);
            }
            Document document2 = transformedDocument;
            return document2;
        }
        catch (Exception e) {
            throw new LyciaParsingException("Parsing failed", e);
        }
        finally {
            if (this.parserContext instanceof InternalParserContext) {
                ((InternalParserContext)this.parserContext).setContextUtils(new ParserContextUtils());
            }
        }
    }

    @Override
    public Document transform(String xml) throws LyciaParsingException {
        return this.transform(new DataLengthStringReader(xml, xml.length()));
    }

    @Override
    public Document transform(Reader reader) throws LyciaParsingException {
        return this.transform(reader, 0L);
    }

    public Document transform(Reader reader, long length) throws LyciaParsingException {
        return this.transform(new ReaderInputStream(reader, length));
    }

    @Override
    public Document transform(File file) throws LyciaParsingException {
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            Document document = this.transform(reader, file.length());
            return document;
        }
        catch (FileNotFoundException e) {
            throw new LyciaParsingException("Parsing failed", e);
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    @Override
    public void setResourceResolver(ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public ParserContext<B> getParserContext() {
        return this.parserContext;
    }

    @Override
    public void setParserContext(ParserContext<B> parserContext) {
        this.parserContext = parserContext;
    }

    @Override
    public boolean isValidatingSchema() {
        return this.validatingSchema;
    }

    @Override
    public void setValidatingSchema(boolean validatingSchema) {
        this.validatingSchema = validatingSchema;
    }

    @Override
    public void addProgressListener(ProgressListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeProgressListener(ProgressListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void setConfigurator(LyciaConfigurator<B> configurator) {
        this.configurator = configurator;
    }

    @Override
    public LyciaConfigurator<B> getConfigurator() {
        return this.configurator;
    }

    @Override
    public Class<? extends LyciaReader<B>> getReader() {
        return this.readerClass;
    }

    @Override
    public void setReader(Class<? extends LyciaReader<B>> readerClass) {
        this.readerClass = readerClass;
    }

    @Override
    public void purge() {
        if (this.parserContext instanceof InternalParserContext) {
            ParserContextUtils utils = ((InternalParserContext)this.parserContext).getContextUtils();
            utils.getPatternCache().shutdown();
            utils.getXPathCache().shutdown();
        }
    }

    @Override
    public long getCacheExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public void setCacheExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime;
    }

    private synchronized Document createReader(InputStream inputStream) throws Exception {
        if (this.reader == null) {
            this.initializeReader();
        }
        Document document = this.reader.read(new InputSource(new ProgressAwareReader(inputStream, this.listeners)));
        return document;
    }

    private DocumentBuilder createDocumentBuilder() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setNamespaceAware(true);
        if (this.isValidatingSchema()) {
            try {
                factory.setSchema(this.createSchema());
            }
            catch (UnsupportedOperationException e) {
                LOGGER.warn((Object)"Warning: Schema isn't supported");
            }
        }
        return factory.newDocumentBuilder();
    }

    private Schema createSchema() throws SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        factory.setResourceResolver(this.getResourceResolver());
        factory.setErrorHandler(this.getErrorHandler());
        return factory.newSchema();
    }

    private void initializeReader() throws LyciaInitializationException {
        if (this.readerClass == null) {
            this.reader = new LyciaXmlReader();
        } else {
            try {
                this.reader = this.readerClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new LyciaInitializationException("Reader could not be initialized", e);
            }
            catch (IllegalAccessException e) {
                throw new LyciaInitializationException("Reader could not be initialized", e);
            }
        }
        this.reader.setXmlParser(this);
        for (Method method : this.reader.getClass().getMethods()) {
            AfterPropertySet annotation = method.getAnnotation(AfterPropertySet.class);
            if (annotation == null) continue;
            if (!annotation.value()) {
                this.executeInitialization(method, this.reader, "Reader could not be initialized");
                continue;
            }
            new Thread(this.createAsyncExecution(method, this.reader)).start();
        }
    }

    private void readNode(Node node, DefinitionBuilder definitionBuilder) throws LyciaParsingException {
        String tagname;
        String namespaceURI;
        TagDefinitionParser<B> parser;
        if (node.getNodeType() == 1 && (parser = this.findParserByNamespaceAndTag(namespaceURI = node.getNamespaceURI(), tagname = node.getLocalName(), (Element)node)) != null) {
            QName qName = new QName(namespaceURI, tagname);
            parser.parseElement((Element)node, tagname, qName, this.parserContext, definitionBuilder);
        }
        if (node.hasChildNodes()) {
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                this.readNode(child, definitionBuilder);
            }
        }
    }

    private Node transformNode(Node node, DefinitionBuilder definitionBuilder) throws LyciaParsingException {
        Node n;
        String namespaceURI = node.getNamespaceURI();
        String tagname = node.getLocalName();
        TagDefinitionParser<B> parser = null;
        if (namespaceURI != null) {
            parser = this.findParserByNamespaceAndTag(namespaceURI, tagname, (Element)node);
        }
        if (parser != null) {
            QName qName = new QName(namespaceURI, tagname);
            n = parser.transformElement((Element)node, tagname, qName, this.parserContext, definitionBuilder);
        } else {
            n = definitionBuilder.getDocument().importNode(node, false);
        }
        if (node.hasChildNodes() && n != null) {
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                Node result = this.transformNode(child, definitionBuilder);
                if (result == null) continue;
                n.appendChild(result);
            }
        }
        return n;
    }

    private TagDefinitionParser<B> findParserByNamespaceAndTag(String namespaceURI, String tagname, Element element) {
        TagDefinitionParser<B> result = this.configurator.findTagDefinitionParser(tagname, namespaceURI, element);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Found TagDefinitionParser '" + result + "' for tag '" + namespaceURI + "->" + tagname));
        }
        return result;
    }

    public String toString() {
        return "XmlParserImpl [configurator=" + this.configurator + ", errorHandler=" + this.errorHandler + ", listeners=" + this.listeners + ", parserContext=" + this.parserContext + ", resourceResolver=" + this.resourceResolver + ", validatingSchema=" + this.validatingSchema + "]";
    }

    private Runnable createAsyncExecution(final Method method, final LyciaReader<B> reader) {
        return new Runnable(){

            @Override
            public void run() {
                LyciaParserImpl.this.executeInitialization(method, reader, "Asynchronous initialization failed");
            }
        };
    }

    private void executeInitialization(Method method, LyciaReader<B> reader, String message) {
        try {
            method.invoke(reader, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new LyciaInitializationException(message, e);
        }
        catch (IllegalAccessException e) {
            throw new LyciaInitializationException(message, e);
        }
        catch (InvocationTargetException e) {
            throw new LyciaInitializationException(message, e);
        }
    }
}

