/*
 * Decompiled with CFR 0.152.
 */
package org.sourceprojects.lycia.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.sourceprojects.lycia.internal.DataLength;

public class PrebufferedInputStream
extends InputStream
implements DataLength {
    private final ByteArrayInputStream byteArrayInputStream;
    private final long length;

    public PrebufferedInputStream(InputStream inputStream) throws IOException {
        int read = -1;
        byte[] buffer = new byte[65536];
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        while ((read = inputStream.read(buffer, 0, buffer.length)) >= 0) {
            output.write(buffer, 0, read);
        }
        buffer = output.toByteArray();
        this.length = buffer.length;
        this.byteArrayInputStream = new ByteArrayInputStream(buffer);
    }

    @Override
    public int available() throws IOException {
        return this.byteArrayInputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.byteArrayInputStream.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.byteArrayInputStream.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.byteArrayInputStream.markSupported();
    }

    @Override
    public int read() throws IOException {
        return this.byteArrayInputStream.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.byteArrayInputStream.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.byteArrayInputStream.read(b);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.byteArrayInputStream.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.byteArrayInputStream.skip(n);
    }

    @Override
    public long length() {
        return this.length;
    }
}

