/*
 * Decompiled with CFR 0.152.
 */
package org.sourceprojects.lycia.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.sourceprojects.lycia.ProgressListener;
import org.sourceprojects.lycia.internal.DataLength;

public class ProgressAwareReader
extends Reader {
    private static final Logger LOGGER = Logger.getLogger(ProgressAwareReader.class);
    private final ReentrantLock lock = new ReentrantLock();
    private final List<ProgressListener> listeners;
    private final InputStreamReader reader;
    private final long fileLength;
    private int lastPercent = 0;
    private long position = 0L;
    private long markedPosition = 0L;

    public ProgressAwareReader(InputStream inputStream, List<ProgressListener> listeners) throws IOException {
        this.fileLength = inputStream instanceof DataLength ? ((DataLength)((Object)inputStream)).length() : (long)inputStream.available();
        this.reader = new InputStreamReader(inputStream);
        this.listeners = listeners;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        if (this.reader.markSupported()) {
            this.markedPosition = readAheadLimit;
            this.reader.mark(readAheadLimit);
        }
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int length = this.reader.read(cbuf, off, len);
        this.notifyListeners(length);
        return length;
    }

    @Override
    public int read() throws IOException {
        this.notifyListeners(4);
        return this.reader.read();
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        this.notifyListeners(cbuf.length);
        return this.reader.read(cbuf);
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        this.notifyListeners(target.length());
        return this.reader.read(target);
    }

    @Override
    public void reset() throws IOException {
        this.notifyListenersAboutReset();
        this.reader.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        this.notifyListeners((int)n);
        return this.reader.skip(n);
    }

    private void notifyListeners(int bytes) {
        this.notifyListeners(bytes, this.position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(int bytes, long offset) {
        if (this.fileLength == -1L) {
            return;
        }
        this.lock.lock();
        try {
            this.position = offset + (long)bytes;
            Double percent = (double)this.position * 100.0 / (double)this.fileLength;
            if (percent.intValue() > this.lastPercent) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Value changed: " + percent.intValue()));
                }
                this.lastPercent = percent.intValue();
                for (ProgressListener listener : this.listeners) {
                    listener.notify(this.lastPercent);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersAboutReset() {
        if (this.fileLength == -1L) {
            return;
        }
        this.lock.lock();
        try {
            this.position = this.markedPosition;
            Double percent = (double)this.position * 100.0 / (double)this.fileLength;
            if (percent.intValue() > this.lastPercent) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Percent value resetted: " + percent.intValue()));
                }
                this.lastPercent = percent.intValue();
                for (ProgressListener listener : this.listeners) {
                    listener.notifyReset();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

