/*
 * Decompiled with CFR 0.152.
 */
package org.sourceprojects.lycia.internal;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.sourceprojects.lycia.internal.Cache;

public class SoftReferencedCache<T>
implements Cache<T> {
    private static final Logger LOGGER = Logger.getLogger(SoftReferencedCache.class);
    private final Map<String, SoftReference<T>> cache = new ConcurrentHashMap<String, SoftReference<T>>();
    private final ReentrantLock lock = new ReentrantLock();
    private final ReferenceQueue<T> queue = new ReferenceQueue();
    private final long expireTime;
    private Timer timer = null;

    public SoftReferencedCache() {
        this(100L);
    }

    public SoftReferencedCache(long expireTime) {
        this.expireTime = expireTime;
    }

    @Override
    public T get(String name) {
        this.removeQueuedSoftReferences();
        SoftReference<T> reference = this.cache.get(name);
        return reference == null ? null : (T)reference.get();
    }

    @Override
    public <R extends T> R get(String name, Class<R> type) {
        this.removeQueuedSoftReferences();
        SoftReference<T> reference = this.cache.get(name);
        return reference == null ? null : (R)reference.get();
    }

    @Override
    public long getExpire() {
        return this.expireTime;
    }

    @Override
    public void put(String name, T obj) {
        this.put(name, obj, this.expireTime);
    }

    @Override
    public void put(String name, T obj, long expireTime) {
        if (expireTime == -1L) {
            expireTime = this.expireTime;
        }
        this.initializeTimer();
        this.cache.put(name, new SoftReference<T>(obj, this.queue));
        this.timer.schedule((TimerTask)new RemoverTask(name), expireTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeTimer() {
        this.lock.lock();
        try {
            if (this.timer == null) {
                this.timer = new Timer(true);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private synchronized void removeQueuedSoftReferences() {
        Reference<T> reference = null;
        while ((reference = this.queue.poll()) != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Key was referenced to be removed from cache");
            }
            String keyToRemove = null;
            for (String key : this.cache.keySet()) {
                SoftReference<T> r = this.cache.get(key);
                if (!r.equals(reference)) continue;
                keyToRemove = key;
                break;
            }
            if (keyToRemove == null) continue;
            this.cache.remove(keyToRemove);
        }
    }

    @Override
    public void shutdown() {
        this.cache.clear();
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
        }
    }

    public String toString() {
        return "SoftReferencedCache [cache=" + this.cache + ", expireTime=" + this.expireTime + ", lock=" + this.lock + ", queue=" + this.queue + ", timer=" + this.timer + "]";
    }

    @Override
    public void invalidate() {
        this.cache.clear();
    }

    private class RemoverTask
    extends TimerTask {
        private final String key;

        RemoverTask(String key) {
            this.key = key;
        }

        @Override
        public void run() {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Removing " + this.key + " from cache " + this.toString()));
            }
            SoftReferencedCache.this.cache.remove(this.key);
        }
    }
}

