/*
 * Decompiled with CFR 0.152.
 */
package org.sourceprojects.lycia.internal;

import org.sourceprojects.lycia.internal.InternalParserContext;
import org.sourceprojects.lycia.internal.ParserContextUtils;

public class ThreadsafeParserContextImpl<T>
implements InternalParserContext<T> {
    private ThreadLocal<ThreadLocalHolder> holders = new ThreadLocal<ThreadLocalHolder>(){

        @Override
        protected synchronized ThreadLocalHolder initialValue() {
            return new ThreadLocalHolder();
        }
    };

    @Override
    public T getContextObject() {
        ThreadLocalHolder holder = this.holders.get();
        if (holder == null) {
            return null;
        }
        return holder.getContextObject();
    }

    @Override
    public void setContextObject(T contextObject) {
        ThreadLocalHolder holder = this.holders.get();
        holder.setContextObject(contextObject);
    }

    @Override
    public void setParserState(String parserState) {
        ThreadLocalHolder holder = this.holders.get();
        holder.setParserState(parserState);
    }

    @Override
    public String getParserState() {
        ThreadLocalHolder holder = this.holders.get();
        if (holder == null) {
            return null;
        }
        return holder.getParserState();
    }

    @Override
    public void setContextUtils(ParserContextUtils contextUtils) {
        ThreadLocalHolder holder = this.holders.get();
        holder.setContextUtils(contextUtils);
    }

    @Override
    public ParserContextUtils getContextUtils() {
        ThreadLocalHolder holder = this.holders.get();
        if (holder == null) {
            return null;
        }
        return holder.getContextUtils();
    }

    public synchronized void remove() {
        this.holders.remove();
    }

    private class ThreadLocalHolder {
        private ParserContextUtils contextUtils = new ParserContextUtils();
        private T contextObject;
        private String parserState;

        private ThreadLocalHolder() {
        }

        public void setContextObject(T contextObject) {
            this.contextObject = contextObject;
        }

        public T getContextObject() {
            return this.contextObject;
        }

        public void setParserState(String parserState) {
            this.parserState = parserState;
        }

        public String getParserState() {
            return this.parserState;
        }

        public void setContextUtils(ParserContextUtils contextUtils) {
            this.contextUtils = contextUtils;
        }

        public ParserContextUtils getContextUtils() {
            return this.contextUtils;
        }
    }
}

