/*
 * Decompiled with CFR 0.152.
 */
package org.sourceprojects.lycia.internal.bundled;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.sourceprojects.lycia.internal.DataLength;

public class ReaderInputStream
extends InputStream
implements DataLength {
    private final long length;
    private Reader in;
    private String encoding = System.getProperty("file.encoding");
    private byte[] slack;
    private int begin;

    public ReaderInputStream(Reader reader, long length) {
        this.in = reader;
        this.length = length;
    }

    public ReaderInputStream(Reader reader, String encoding, long length) {
        this(reader, length);
        if (encoding == null) {
            throw new IllegalArgumentException("encoding must not be null");
        }
        this.encoding = encoding;
    }

    @Override
    public synchronized int read() throws IOException {
        int result;
        if (this.in == null) {
            throw new IOException("Stream Closed");
        }
        if (this.slack != null && this.begin < this.slack.length) {
            result = this.slack[this.begin];
            if (++this.begin == this.slack.length) {
                this.slack = null;
            }
        } else {
            byte[] buf = new byte[1];
            if (this.read(buf, 0, 1) <= 0) {
                result = -1;
            }
            result = buf[0];
        }
        if (result < -1) {
            result = (byte)(result + 256);
        }
        return result;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.in == null) {
            throw new IOException("Stream Closed");
        }
        while (this.slack == null) {
            char[] buf = new char[len];
            int n = this.in.read(buf);
            if (n == -1) {
                return -1;
            }
            if (n <= 0) continue;
            this.slack = new String(buf, 0, n).getBytes(this.encoding);
            this.begin = 0;
        }
        if (len > this.slack.length - this.begin) {
            len = this.slack.length - this.begin;
        }
        System.arraycopy(this.slack, this.begin, b, off, len);
        if ((this.begin += len) >= this.slack.length) {
            this.slack = null;
        }
        return len;
    }

    @Override
    public synchronized void mark(int limit) {
        try {
            this.in.mark(limit);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe.getMessage());
        }
    }

    @Override
    public synchronized int available() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream Closed");
        }
        if (this.slack != null) {
            return this.slack.length - this.begin;
        }
        if (this.in.ready()) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream Closed");
        }
        this.slack = null;
        this.in.reset();
    }

    @Override
    public synchronized void close() throws IOException {
        this.in.close();
        this.slack = null;
        this.in = null;
    }

    @Override
    public long length() {
        return this.length;
    }
}

