/*
 * Decompiled with CFR 0.152.
 */
package org.sourceprojects.lycia.internal.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathExpression;
import org.apache.log4j.Logger;
import org.sourceprojects.lycia.Delegate;
import org.sourceprojects.lycia.Generator;
import org.sourceprojects.lycia.LyciaConfigurator;
import org.sourceprojects.lycia.LyciaParser;
import org.sourceprojects.lycia.TagDefinitionParser;
import org.sourceprojects.lycia.annotations.Namespace;
import org.sourceprojects.lycia.annotations.Tag;
import org.sourceprojects.lycia.exceptions.LyciaConfigurationException;
import org.sourceprojects.lycia.internal.Cache;
import org.sourceprojects.lycia.internal.InternalParserContext;
import org.sourceprojects.lycia.internal.XPathAwareXmlParserConfigurator;
import org.sourceprojects.lycia.internal.configuration.BasicXmlParserConfigurator;
import org.sourceprojects.lycia.internal.configuration.DelegateTagDefinitionParser;
import org.sourceprojects.lycia.internal.configuration.TagConfigurationUtils;
import org.sourceprojects.lycia.internal.configuration.XPathConfigutationUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AnnotatedXmlParserConfigurator<B>
extends BasicXmlParserConfigurator<B>
implements XPathAwareXmlParserConfigurator<B> {
    private static final Logger LOGGER = Logger.getLogger(AnnotatedXmlParserConfigurator.class);
    private final Map<XPathExpression, List<TagDefinitionParser<B>>> xpathMappings = new HashMap<XPathExpression, List<TagDefinitionParser<B>>>();

    public AnnotatedXmlParserConfigurator(LyciaParser<B> xmlParser, LyciaConfigurator<B> parent) {
        super(xmlParser, parent);
    }

    @Override
    public void addTagDefinitionParser(Object definitionParser) {
        TagConfigurationUtils.MethodDefinition[] definitions = TagConfigurationUtils.findAnnotatedMethods(definitionParser.getClass());
        if (definitions.length == 0 && !(definitionParser instanceof TagDefinitionParser)) {
            throw new LyciaConfigurationException("Class " + definitionParser.getClass().getCanonicalName() + " is no legal TagDefinitionParser");
        }
        if (definitions.length > 0) {
            this.addAnnotatedTagDefinitionParser(definitionParser, definitions);
        }
    }

    @Override
    public void addTagDefinitionParsers(Object[] definitionParsers) {
        for (Object definitionParser : definitionParsers) {
            this.addTagDefinitionParser(definitionParser);
        }
    }

    @Override
    public void addTagDefinitionParsers(TagDefinitionParser<B>[] definitionParsers) {
        for (TagDefinitionParser<B> definitionParser : definitionParsers) {
            this.addTagDefinitionParser(definitionParser);
        }
    }

    @Override
    public void addTagDefinitionParser(TagDefinitionParser<B> definitionParser) {
        TagConfigurationUtils.MethodDefinition[] definitions;
        if (definitionParser.getTags() != null && definitionParser.getTags().length > 0) {
            super.addTagDefinitionParser(definitionParser);
        }
        if ((definitions = TagConfigurationUtils.findAnnotatedMethods(definitionParser.getClass())).length > 0) {
            this.addAnnotatedTagDefinitionParser(definitionParser, definitions);
        }
    }

    @Override
    public List<TagDefinitionParser<B>> findTagDefinitionParsers(QName localElement, Element element) {
        ArrayList<TagDefinitionParser<B>> parsers = new ArrayList<TagDefinitionParser<B>>();
        try {
            parsers.addAll(super.findTagDefinitionParsers(localElement, element));
        }
        catch (LyciaConfigurationException e) {
            if (!this.isNamespaceInXPathMappings(localElement.getNamespaceURI())) {
                LOGGER.warn((Object)("No standard namespace parser for namespaceURI '" + localElement.getNamespaceURI() + "' registered"));
                return Collections.emptyList();
            }
            parsers.addAll(this.findXPathMapping(element));
            return parsers;
        }
        parsers.addAll(this.findXPathMapping(element));
        return parsers;
    }

    @Override
    public void registerXPathTagDefinitionParser(Delegate<B> delegate, Tag tag, String namespaceURI) {
        for (Namespace namespace : tag.xpath().namespaces()) {
            this.checkNamespaceResolver(namespace.uri());
        }
        XPathExpression compiled = XPathConfigutationUtils.compileExpression(tag.xpath().expression(), tag.xpath().namespaces());
        DelegateTagDefinitionParser<B> parser = new DelegateTagDefinitionParser<B>(delegate, tag, namespaceURI);
        List<TagDefinitionParser<B>> list = this.asList(parser);
        this.xpathMappings.put(compiled, list);
    }

    private boolean isNamespaceInXPathMappings(String namespaceURI) {
        Collection<List<TagDefinitionParser<B>>> parserCollections = this.xpathMappings.values();
        for (List<TagDefinitionParser<B>> parsers : parserCollections) {
            for (TagDefinitionParser<B> parser : parsers) {
                if (parser.getNamespace() == null || !parser.getNamespace().equals(namespaceURI)) continue;
                return true;
            }
        }
        for (List<TagDefinitionParser<B>> parsers : parserCollections) {
            for (TagDefinitionParser<B> parser : parsers) {
                if (!XPathConfigutationUtils.isHandleNamespace(parser, namespaceURI)) continue;
                return true;
            }
        }
        return false;
    }

    private List<TagDefinitionParser<B>> findXPathMapping(Element element) {
        InternalParserContext context = this.getInternalParserContextRepresentation();
        Cache<NodeList> xpathCache = null;
        if (context != null) {
            xpathCache = context.getContextUtils().getXPathCache();
        }
        for (XPathExpression expression : this.xpathMappings.keySet()) {
            if (!XPathConfigutationUtils.matches(element, expression, xpathCache, this.getXmlParser())) continue;
            return this.xpathMappings.get(expression);
        }
        return Collections.emptyList();
    }

    private void addAnnotatedTagDefinitionParser(Object tagDefinitionParser, TagConfigurationUtils.MethodDefinition[] definitions) {
        Generator generator = this.getGeneratorFactory().newInstance(this.getGenerationStrategy());
        for (TagConfigurationUtils.MethodDefinition definition : definitions) {
            Delegate delegate = generator.generate(tagDefinitionParser, definition);
            if (delegate == null) {
                throw new LyciaConfigurationException("Could not initialize Annotation-Delegate for method " + definition.getMethod().getName() + " on class " + tagDefinitionParser.getClass().getCanonicalName());
            }
            for (Tag tag : definition.getTags()) {
                boolean legalXpath;
                String namespaceURI = tag.namespace();
                if ("".equals(namespaceURI) && tagDefinitionParser instanceof TagDefinitionParser) {
                    namespaceURI = ((TagDefinitionParser)tagDefinitionParser).getNamespace();
                }
                boolean bl = legalXpath = !XPathConfigutationUtils.isNullXPathAnnotation(tag);
                if (legalXpath) {
                    this.registerXPathTagDefinitionParser(delegate, tag, namespaceURI);
                    continue;
                }
                this.checkNamespaceResolver(namespaceURI);
                this.addTagDefinitionParserToContainer(new DelegateTagDefinitionParser(delegate, tag, namespaceURI), namespaceURI);
            }
        }
    }

    private void checkNamespaceResolver(String namespaceURI) {
        if (this.getXmlParser().getResourceResolver().resolveResource(null, namespaceURI, null, null, null) == null) {
            throw new LyciaConfigurationException(new NullPointerException("Namespace " + namespaceURI + " cannot be resolved"));
        }
    }

    private List<TagDefinitionParser<B>> asList(TagDefinitionParser<B> ... parsers) {
        ArrayList<TagDefinitionParser<B>> list = new ArrayList<TagDefinitionParser<B>>();
        for (int i = 0; i < parsers.length; ++i) {
            list.add(parsers[i]);
        }
        return Collections.unmodifiableList(list);
    }
}

