/*
 * Decompiled with CFR 0.152.
 */
package org.sourceprojects.lycia.internal.configuration;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.sourceprojects.lycia.GeneratorFactory;
import org.sourceprojects.lycia.LyciaBuilder;
import org.sourceprojects.lycia.LyciaConfigurator;
import org.sourceprojects.lycia.LyciaParser;
import org.sourceprojects.lycia.TagDefinitionParser;
import org.sourceprojects.lycia.annotations.Tag;
import org.sourceprojects.lycia.exceptions.LyciaConfigurationException;
import org.sourceprojects.lycia.exceptions.LyciaInitializationException;
import org.sourceprojects.lycia.internal.Cache;
import org.sourceprojects.lycia.internal.InternalParserContext;
import org.sourceprojects.lycia.internal.TagDefinitionParserContainer;
import org.sourceprojects.lycia.internal.generator.GeneratorFactoryImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public class BasicXmlParserConfigurator<B>
implements LyciaConfigurator<B> {
    private static final Logger LOGGER = Logger.getLogger(BasicXmlParserConfigurator.class);
    private static final Pattern DEFAULT_PATTERN = Pattern.compile("\\*");
    private final LyciaConfigurator<B> parent;
    private final TagDefinitionParserContainer<B> tagDefinitionParsers = new TagDefinitionParserContainer();
    private final List<ContentHandler> contentHandlers = new ArrayList<ContentHandler>();
    private final LyciaParser<B> xmlParser;
    private LyciaBuilder.GenerationStrategy generationStrategy = LyciaBuilder.GenerationStrategy.ReflectiveGeneration;
    private GeneratorFactory<B> generatorFactory = new GeneratorFactoryImpl<B>();

    public BasicXmlParserConfigurator(LyciaParser<B> xmlParser, LyciaConfigurator<B> parent) {
        this.xmlParser = xmlParser;
        this.parent = parent;
    }

    @Override
    public void addTagDefinitionParser(TagDefinitionParser<B> definitionParser) {
        this.addTagDefinitionParserInternal(definitionParser);
    }

    @Override
    public void addTagDefinitionParsers(TagDefinitionParser<B>[] definitionParsers) {
        for (TagDefinitionParser<B> definitionParser : definitionParsers) {
            this.addTagDefinitionParserInternal(definitionParser);
        }
    }

    @Override
    public void addTagDefinitionParser(Object definitionParser) {
        this.addTagDefinitionParserInternal(definitionParser);
    }

    @Override
    public void addTagDefinitionParsers(Object[] definitionParsers) {
        for (Object definitionParser : definitionParsers) {
            this.addTagDefinitionParserInternal(definitionParser);
        }
    }

    @Override
    public TagDefinitionParser<B> findTagDefinitionParser(QName localElement, Element element) {
        List<TagDefinitionParser<B>> parsers = this.findTagDefinitionParsers(localElement, element);
        if (parsers.size() == 0) {
            return null;
        }
        return parsers.get(0);
    }

    @Override
    public TagDefinitionParser<B> findTagDefinitionParser(String tagName, String namespaceURI, Element element) {
        return this.findTagDefinitionParser(new QName(namespaceURI, tagName), element);
    }

    @Override
    public List<TagDefinitionParser<B>> findTagDefinitionParsers(QName localElement, Element element) {
        return this.findTagDefinitionParserInternal(localElement.getNamespaceURI(), localElement.getLocalPart(), element);
    }

    @Override
    public List<TagDefinitionParser<B>> findTagDefinitionParsers(String tagName, String namespaceURI, Element element) {
        return this.findTagDefinitionParsers(new QName(namespaceURI, tagName), element);
    }

    @Override
    public void removeTagDefinitionParser(TagDefinitionParser<B> definitionParser) {
        this.removeTagDefinitionParserInternal(definitionParser);
    }

    @Override
    public void removeTagDefinitionParsers(TagDefinitionParser<B>[] definitionParsers) {
        for (TagDefinitionParser<B> definitionParser : definitionParsers) {
            this.removeTagDefinitionParserInternal(definitionParser);
        }
    }

    @Override
    public void removeTagDefinitionParser(Object definitionParser) {
        this.removeTagDefinitionParserInternal(definitionParser);
    }

    @Override
    public void removeTagDefinitionParsers(Object[] definitionParsers) {
        for (Object definitionParser : definitionParsers) {
            this.removeTagDefinitionParserInternal(definitionParser);
        }
    }

    @Override
    public LyciaBuilder.GenerationStrategy getGenerationStrategy() {
        return this.generationStrategy;
    }

    @Override
    public void setGenerationStrategy(LyciaBuilder.GenerationStrategy generationStrategy) {
        this.generationStrategy = generationStrategy;
    }

    public LyciaParser<B> getXmlParser() {
        return this.xmlParser;
    }

    @Override
    public LyciaConfigurator<B> getParentXmlParserConfigurator() {
        return this.parent;
    }

    @Override
    public GeneratorFactory<B> getGeneratorFactory() {
        return this.generatorFactory;
    }

    @Override
    public void setGeneratorFactory(GeneratorFactory<B> generatorFactory) {
        this.generatorFactory = generatorFactory;
    }

    @Override
    public void addContentHandler(ContentHandler contentHandler) {
        this.contentHandlers.add(contentHandler);
    }

    @Override
    public void removeContentHandler(ContentHandler contentHandler) {
        this.contentHandlers.remove(contentHandler);
    }

    @Override
    public List<ContentHandler> getContentHandlers() {
        return this.contentHandlers;
    }

    protected void addTagDefinitionParserToContainer(TagDefinitionParser<B> tagDefinitionParser, String namespaceURI) {
        for (Tag tag : tagDefinitionParser.getTagAnnotations()) {
            if (!this.isAlreadyRegistered(tag, namespaceURI)) continue;
            throw new LyciaInitializationException(namespaceURI + "=>" + tag.value() + " has already a registered parser. Duplicate parsers " + "for same tag-expression is illegal");
        }
        HashSet<TagDefinitionParser<B>> parsers = (HashSet<TagDefinitionParser<B>>)this.tagDefinitionParsers.get(namespaceURI);
        if (parsers == null) {
            parsers = new HashSet<TagDefinitionParser<B>>();
        }
        if (LOGGER.isDebugEnabled()) {
            for (Tag tag : tagDefinitionParser.getTagAnnotations()) {
                LOGGER.debug((Object)("Registered TagDefinitionParser '" + tagDefinitionParser + "' for tag '" + tag.namespace() + "->" + tag.value()));
            }
        }
        parsers.add(tagDefinitionParser);
        this.tagDefinitionParsers.put(namespaceURI, parsers);
    }

    protected QName[] generateParentQNames(String tag, String namespaceURI) {
        String[] tags = tag.split("\\\\");
        ArrayList<QName> qNames = new ArrayList<QName>();
        for (String t : tags) {
            if (t.contains("{")) {
                String pNamespaceURI = t.substring(t.indexOf("{") + 1, t.indexOf("}"));
                String pTag = t.substring(t.indexOf("}") + 1);
                qNames.add(new QName(pNamespaceURI, pTag));
                continue;
            }
            qNames.add(new QName(namespaceURI, t));
        }
        return qNames.toArray(new QName[qNames.size()]);
    }

    protected InternalParserContext<B> getInternalParserContextRepresentation() {
        if (!(this.xmlParser.getParserContext() instanceof InternalParserContext)) {
            return null;
        }
        return (InternalParserContext)this.xmlParser.getParserContext();
    }

    private boolean isAlreadyRegistered(Tag tag, String namespaceURI) {
        Set parsers = (Set)this.tagDefinitionParsers.get(namespaceURI);
        if (parsers == null) {
            return false;
        }
        for (TagDefinitionParser parser : parsers) {
            for (Tag parserTag : parser.getTagAnnotations()) {
                if (!tag.value().equals(parserTag.value()) || !tag.namespace().equals(parserTag.namespace())) continue;
                return true;
            }
        }
        return false;
    }

    private List<TagDefinitionParser<B>> findTagDefinitionParserInternal(String namespaceURI, String tagname, Element element) {
        ArrayList<TagDefinitionParser<B>> result = new ArrayList<TagDefinitionParser<B>>();
        TagDefinitionParser defaultParser = null;
        Set parsers = (Set)this.tagDefinitionParsers.get(namespaceURI);
        if (parsers == null) {
            throw new LyciaConfigurationException("No namespace parsers found for namespace " + namespaceURI);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Try to find TagDefinitionParser for " + namespaceURI + "::" + tagname));
        }
        for (TagDefinitionParser parser : parsers) {
            for (Tag tag : parser.getTagAnnotations()) {
                String expression = tag.value();
                String namespace = "".equals(tag.namespace()) ? namespaceURI : tag.namespace();
                Pattern pattern = this.buildPattern(tag);
                if (pattern == null && expression.contains("\\")) {
                    QName[] qNames = this.generateParentQNames(expression, namespace);
                    TagDefinitionParser<B> finalParser = this.matchesElement(element, qNames, parser);
                    if (finalParser == null) continue;
                    result.add(finalParser);
                    continue;
                }
                if (pattern != null) {
                    Matcher matcher = pattern.matcher(tagname);
                    if (!matcher.matches()) continue;
                    result.add(parser);
                    continue;
                }
                if (expression.equals(tagname) && namespace.equals(namespaceURI)) {
                    result.add(parser);
                    continue;
                }
                if (!expression.equals("*") || !namespace.equals(namespaceURI)) continue;
                if (defaultParser != null) {
                    throw new LyciaConfigurationException("Only one default TagDefinitionParser can be registered for expression " + expression);
                }
                defaultParser = parser;
                result.add(parser);
            }
        }
        return result;
    }

    private TagDefinitionParser<B> matchesElement(Element element, QName[] qNames, TagDefinitionParser<B> parser) {
        if (element == null) {
            return null;
        }
        QName qName = qNames[qNames.length - 1];
        String localPart = qName.getLocalPart();
        String namespacePart = qName.getNamespaceURI();
        if (localPart.equals(element.getLocalName()) && (namespacePart.equals("") && element.getNamespaceURI() == null || namespacePart.equals(element.getNamespaceURI()))) {
            if (qNames.length == 1) {
                return parser;
            }
            Node parent = element.getParentNode();
            if (!(parent instanceof Element)) {
                return null;
            }
            QName[] temp = new QName[qNames.length - 1];
            System.arraycopy(qNames, 0, temp, 0, temp.length);
            return this.matchesElement((Element)parent, temp, parser);
        }
        return null;
    }

    private void addTagDefinitionParserInternal(Object tagDefinitionParser) {
        if (this.xmlParser.getResourceResolver() == null) {
            throw new NullPointerException("ResourceResolver is null");
        }
        if (tagDefinitionParser instanceof TagDefinitionParser) {
            this.addOldFashionedTagDefinitionParser((TagDefinitionParser)tagDefinitionParser);
            return;
        }
        if (this.parent != null) {
            this.parent.addTagDefinitionParser(tagDefinitionParser);
        }
    }

    private void addOldFashionedTagDefinitionParser(TagDefinitionParser<B> tagDefinitionParser) {
        String namespaceURI = tagDefinitionParser.getNamespace();
        if (this.xmlParser.getResourceResolver().resolveResource(null, namespaceURI, null, null, null) == null) {
            throw new LyciaConfigurationException(new NullPointerException("Namespace " + namespaceURI + " cannot be resolved"));
        }
        this.addTagDefinitionParserToContainer(tagDefinitionParser, namespaceURI);
    }

    private Pattern buildPattern(Tag tag) {
        if (!tag.regex()) {
            return null;
        }
        InternalParserContext<B> context = this.getInternalParserContextRepresentation();
        Cache<Pattern> patternCache = null;
        if (context != null) {
            patternCache = context.getContextUtils().getPatternCache();
        }
        Pattern pattern = null;
        if (patternCache != null) {
            pattern = patternCache.get(String.valueOf(tag.hashCode()));
        }
        if (pattern == null) {
            try {
                pattern = Pattern.compile(tag.value());
            }
            catch (PatternSyntaxException e) {
                pattern = DEFAULT_PATTERN;
            }
            if (patternCache != null) {
                patternCache.put(String.valueOf(tag.hashCode()), pattern, this.xmlParser.getCacheExpirationTime());
            }
        }
        return pattern == DEFAULT_PATTERN ? null : pattern;
    }

    private void removeTagDefinitionParserInternal(Object tagDefinitionParser) {
        Set parsers;
        String namespaceURI = null;
        if (tagDefinitionParser instanceof TagDefinitionParser) {
            namespaceURI = ((TagDefinitionParser)tagDefinitionParser).getNamespace();
        }
        if ((parsers = (Set)this.tagDefinitionParsers.get(namespaceURI)) != null) {
            parsers.remove(tagDefinitionParser);
            this.tagDefinitionParsers.put(namespaceURI, parsers);
        }
    }
}

