/*
 * Decompiled with CFR 0.152.
 */
package org.sourceprojects.lycia.internal.configuration;

import java.util.Arrays;
import javax.xml.namespace.QName;
import org.sourceprojects.lycia.AbstractTagParser;
import org.sourceprojects.lycia.DefinitionBuilder;
import org.sourceprojects.lycia.Delegate;
import org.sourceprojects.lycia.ParserContext;
import org.sourceprojects.lycia.annotations.Tag;
import org.sourceprojects.lycia.exceptions.LyciaParsingException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DelegateTagDefinitionParser<B>
extends AbstractTagParser<B> {
    private final Delegate<B> delegate;
    private final String namespaceURI;
    private final String[] tags;
    private final Tag tag;

    public DelegateTagDefinitionParser(Delegate<B> delegate, Tag tag, String namespaceURI) {
        this.delegate = delegate;
        this.namespaceURI = namespaceURI;
        this.tags = new String[]{tag.value()};
        this.tag = tag;
    }

    @Override
    public String getNamespace() {
        return this.namespaceURI;
    }

    @Override
    public String[] getTags() {
        String[] result = new String[this.tags.length];
        System.arraycopy(this.tags, 0, result, 0, this.tags.length);
        return result;
    }

    @Override
    public Tag[] getTagAnnotations() {
        return new Tag[]{this.tag};
    }

    @Override
    public void parseElement(Element element, ParserContext<B> parserContext, DefinitionBuilder definitionBuilder) throws LyciaParsingException {
        this.parseElement(element, null, null, parserContext, definitionBuilder);
    }

    @Override
    public void parseElement(Element element, String localName, ParserContext<B> parserContext, DefinitionBuilder definitionBuilder) throws LyciaParsingException {
        this.parseElement(element, localName, null, parserContext, definitionBuilder);
    }

    @Override
    public void parseElement(Element element, String localName, QName parent, ParserContext<B> parserContext, DefinitionBuilder definitionBuilder) throws LyciaParsingException {
        this.delegate.invokeParse(element, localName, parent, parserContext, definitionBuilder);
    }

    @Override
    public Node transformElement(Element element, ParserContext<B> parserContext, DefinitionBuilder definitionBuilder) throws LyciaParsingException {
        return this.transformElement(element, null, null, parserContext, definitionBuilder);
    }

    @Override
    public Node transformElement(Element element, String localName, ParserContext<B> parserContext, DefinitionBuilder definitionBuilder) throws LyciaParsingException {
        return this.transformElement(element, localName, null, parserContext, definitionBuilder);
    }

    @Override
    public Node transformElement(Element element, String localName, QName parent, ParserContext<B> parserContext, DefinitionBuilder definitionBuilder) throws LyciaParsingException {
        return this.delegate.invokeTransform(element, localName, parent, parserContext, definitionBuilder);
    }

    public Delegate<B> getDelegate() {
        return this.delegate;
    }

    public Tag getTag() {
        return this.tag;
    }

    public String toString() {
        return "DelegateTagDefinitionParser [delegate=" + this.delegate + ", namespaceURI=" + this.namespaceURI + ", tag=" + this.tag + ", tags=" + Arrays.toString(this.tags) + "]";
    }
}

